/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.h2.tools.indexer.HtmlConverter;
import org.h2.tools.indexer.Page;
import org.h2.tools.indexer.Weight;
import org.h2.tools.indexer.Word;
import org.h2.util.ByteUtils;
import org.h2.util.StringUtils;

public class Indexer {
    ArrayList pages = new ArrayList();
    HashMap words = new HashMap();
    HashSet noIndex = new HashSet();
    ArrayList wordList;
    int totalAllWeights;
    PrintWriter output;
    Page page;
    boolean title;
    boolean heading;
    private static final int MIN_WORDSIZE = 3;
    private static final int MAX_RELATIONS = 20;

    public static void main(String[] args) throws Exception {
        String dir = "docs";
        String destDir = "docs/html";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (!args[i].equals("-destDir")) continue;
            destDir = args[++i];
        }
        Indexer app = new Indexer();
        File file = new File(dir);
        System.out.println("indexing " + file.getCanonicalPath());
        app.setNoIndex(new String[]{"index.html", "html/header.html", "html/search.html", "html/frame.html", "javadoc/index.html", "javadoc/classes.html", "javadoc/allclasses-frame.html", "javadoc/allclasses-noframe.html", "javadoc/constant-values.html", "javadoc/overview-frame.html", "javadoc/overview-summary.html", "javadoc/serialized-form.html"});
        app.output = new PrintWriter(new FileWriter(destDir + "/index.js"));
        app.readPages("", file, 0);
        app.output.println("var pages=new Array();");
        app.output.println("var ref=new Array();");
        app.output.println("function Page(title, file) { this.title=title; this.file=file; }");
        app.output.println("function load() {");
        app.sortWords();
        app.removeOverflowRelations();
        app.sortPages();
        app.listPages();
        app.listWords();
        app.output.println("}");
        app.output.close();
    }

    private void setNoIndex(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            this.noIndex.add(strings[i]);
        }
    }

    void sortWords() {
        this.wordList = new ArrayList(this.words.values());
        Collections.sort(this.wordList, new Comparator(){

            public int compare(Object o0, Object o1) {
                Word w0 = (Word)o0;
                Word w1 = (Word)o1;
                return w0.name.compareToIgnoreCase(w1.name);
            }
        });
    }

    void removeOverflowRelations() {
        for (int i = 0; i < this.wordList.size(); ++i) {
            Weight weight;
            int max;
            Word word = (Word)this.wordList.get(i);
            ArrayList weights = word.getSortedWeights();
            if (weights.size() > max) {
                for (max = 20; max < weights.size(); ++max) {
                    weight = (Weight)weights.get(max);
                    if (weight.value < 100) break;
                }
            }
            while (max < weights.size()) {
                weight = (Weight)weights.get(max);
                weights.remove(max);
                --weight.page.relations;
            }
        }
    }

    void sortPages() {
        Collections.sort(this.pages, new Comparator(){

            public int compare(Object o0, Object o1) {
                Page p0 = (Page)o0;
                Page p1 = (Page)o1;
                return p0.relations == p1.relations ? 0 : (p0.relations < p1.relations ? 1 : -1);
            }
        });
        int i = 0;
        while (i < this.pages.size()) {
            Page page = (Page)this.pages.get(i);
            page.id = i++;
        }
    }

    void listPages() {
        for (int i = 0; i < this.pages.size(); ++i) {
            Page page = (Page)this.pages.get(i);
            this.output.println("pages[" + page.id + "]=new Page('" + this.convertUTF(page.title) + "', '" + page.fileName + "');");
        }
    }

    void readPages(String dir, File file, int level) throws Exception {
        String fileName;
        String name = file.getName();
        String string = dir.length() > 0 ? dir + "/" + name : (fileName = level > 0 ? name : "");
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.readPages(fileName, list[i], level + 1);
            }
            return;
        }
        String lower = name.toLowerCase();
        if (!lower.endsWith(".html") && !lower.endsWith(".htm")) {
            return;
        }
        if (!this.noIndex.contains(fileName)) {
            this.page = new Page(this.pages.size(), fileName, name);
            this.pages.add(this.page);
            this.readPage(file);
        }
    }

    void listWords() {
        this.output.println("// words: " + this.wordList.size());
        StringBuffer buff = new StringBuffer();
        String first = "";
        int firstLen = 1;
        int totalRelations = 0;
        for (int i = 0; i < this.wordList.size(); ++i) {
            Word word = (Word)this.wordList.get(i);
            ArrayList weights = word.getSortedWeights();
            String lower = word.name.toLowerCase();
            if (!first.equals(lower.substring(0, firstLen))) {
                if (buff.length() > 0) {
                    this.output.println("ref['" + this.convertUTF(first) + "']='" + buff.toString() + "';");
                    buff = new StringBuffer();
                }
                first = lower.substring(0, firstLen);
            }
            if (buff.length() > 0) {
                buff.append(';');
            }
            buff.append(this.convertUTF(word.name));
            buff.append('=');
            String weightString = "r";
            totalRelations += weights.size();
            for (int j = 0; j < weights.size(); ++j) {
                String ws;
                Weight weight = (Weight)weights.get(j);
                Page page = weight.page;
                if (j > 0) {
                    buff.append(",");
                }
                if ((ws = weight.value >= 10000 ? "t" : (weight.value >= 100 ? "h" : "r")) != weightString) {
                    weightString = ws;
                    buff.append(ws);
                }
                buff.append(page.id);
            }
        }
        this.output.println("ref['" + this.convertUTF(first) + "']='" + buff.toString() + "';");
        this.output.println("// totalRelations: " + totalRelations);
    }

    private void readPage(File file) throws Exception {
        byte[] data = ByteUtils.getBytesAndClose(new FileInputStream(file), 0);
        String text = new String(data, "UTF-8");
        StringTokenizer t = new StringTokenizer(text, "<> \r\n", true);
        boolean inTag = false;
        this.title = false;
        this.heading = false;
        block5: while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.length() == 1) {
                char c = token.charAt(0);
                switch (c) {
                    case '<': {
                        if (inTag) {
                            this.process("???");
                        }
                        inTag = true;
                        if (!t.hasMoreTokens()) break;
                        token = t.nextToken();
                        if (token.startsWith("/")) {
                            this.title = false;
                            this.heading = false;
                            break;
                        }
                        if (token.equalsIgnoreCase("title")) {
                            this.title = true;
                            break;
                        }
                        if (token.length() != 2 || token.toLowerCase().charAt(0) != 'h' || !Character.isDigit(token.charAt(1))) continue block5;
                        this.heading = true;
                        break;
                    }
                    case '>': {
                        if (!inTag) {
                            this.process("???");
                        }
                        inTag = false;
                        break;
                    }
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        if (inTag) continue block5;
                        this.process(token);
                    }
                }
                continue;
            }
            if (inTag) continue;
            this.process(token);
        }
        if (this.page.title == null || this.page.title.trim().length() == 0) {
            System.out.println("Error: not title found in " + file.getName());
            this.page.title = file.getName();
        }
        this.page.title = this.page.title.trim();
    }

    void process(String text) {
        text = HtmlConverter.convertHtml(text);
        if (this.title) {
            this.page.title = this.page.title == null ? text : this.page.title + " " + text;
        }
        int weight = this.title ? 10000 : (this.heading ? 100 : 1);
        StringTokenizer t = new StringTokenizer(text, " \t\r\n\"'.,:;!&/\\?%@`[]{}()+-=<>|*^~#$\u00a0", false);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.length() < 3 || Character.isDigit(token.charAt(0))) continue;
            String lower = token.toLowerCase();
            Word word = (Word)this.words.get(lower);
            if (word == null) {
                word = new Word(token);
                this.words.put(lower, word);
            } else if (!word.name.equals(token)) {
                word.name = token.compareTo(word.name) > 0 ? token : word.name;
            }
            this.page.totalWeight += weight;
            this.totalAllWeights += weight;
            word.addPage(this.page, weight);
        }
    }

    String convertUTF(String s) {
        s = StringUtils.quoteJavaString(s);
        s = s.substring(1, s.length() - 1);
        return s;
    }
}

