/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLong
extends Value {
    public static final int PRECISION = 19;
    private long value;
    private static final int STATIC_SIZE = 10;
    private static ValueLong[] cache = new ValueLong[10];

    private ValueLong(long value) {
        this.value = value;
    }

    public Value add(Value v) {
        ValueLong other = (ValueLong)v;
        return ValueLong.get(this.value + other.value);
    }

    public int getSignum() {
        return this.value == 0L ? 0 : (this.value < 0L ? -1 : 1);
    }

    public Value negate() {
        return ValueLong.get(-this.value);
    }

    public Value subtract(Value v) {
        ValueLong other = (ValueLong)v;
        return ValueLong.get(this.value - other.value);
    }

    public Value multiply(Value v) {
        ValueLong other = (ValueLong)v;
        return ValueLong.get(this.value * other.value);
    }

    public Value divide(Value v) throws SQLException {
        ValueLong other = (ValueLong)v;
        if (other.value == 0L) {
            throw Message.getSQLException(22012);
        }
        return ValueLong.get(this.value / other.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 5;
    }

    public long getLong() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueLong v = (ValueLong)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 19L;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public Object getObject() {
        return new Long(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setLong(parameterIndex, this.value);
    }

    public static ValueLong get(long i) {
        if (i >= 0L && i < 10L) {
            return cache[(int)i];
        }
        return (ValueLong)Value.cache(new ValueLong(i));
    }

    public int getDisplaySize() {
        return 19;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueLong && this.value == ((ValueLong)v).value;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ValueLong.cache[i] = new ValueLong(i);
        }
    }
}

