<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Links/Commands" => "链接/命令",
"create tag" => "自定义标签",
"Anonymous users can edit pages" => "允许匿名用户编辑页面",
"Ranking" => "排名",
"User versions" => "用户版本",
"TextFormattingRules" => "文本格式化规则",
"References" => "参考",
"JoinCapitalizedWords" => "连在一起的大写词汇",
"or use square brackets for an" => "或使用方括号表示",
"link_description" => "链接描述",
"Title_bar" => "标题栏",
"img" => "图像",
"printable" => "可打印",
"History of" => "历史记录",
"current_version" => "当前版本",
"All pages" => "所有页面",
"Rollback_page" => "复原页面",
"last_login" => "上次登录",
"assign group" => "指定用户组",
"Create or edit a gallery using this form" => "使用此表单生成或编辑一个文件库",
"versions" => "版本",
"Perm" => "权限",
"No individual permissions global permissions to all pages apply" => "不采用个別页面权限,套用全体权限到所有页面",
"Assign permissions to thispage" => "为该页设定权限",
"ranking" => "排名",
"list_pages" => "列出页面",
"my galleries" => "我的文件库",
"You can include the image in an HTML/Tiki page using" => "你可将此图像包含在 HTML/Tiki 的页面中使用",
"You can include the image in an HTML or Tiki page using" => "你可包含图像在HTML或Tiki页面中使用",
"modules" => "版块",
"links" => "链接",
"system gallery" => "系统文件库",
"Anonymous users cannot edit pages" => "匿名用户无法编辑页面",
"Permission denied you cannot browse this gallery" => "你没有浏览这个文件库的权限",
"view info" => "查看信息",
"HasImg" => "有图像",
"UseImg" => "使用图像",
"User preferences screen" => "用户偏好屏幕",
"The SandBox is a page where you can practice your editing skills, use the preview feature\nto preview the appearance of the page, no versions are stored for this page." => "涂鸦板是一个可以练习编辑技巧的页面, 使用预览的功能\n来预览这个页面的样式, 而这个页面的版本将不会被保存.",
"Configure this page" => "配置本页面",
"hotwords" => "热词",
"user preferences" => "用户偏好",
"No image uploaded" => "没有上传图像",
"Current version" => "当前版本",
"Next version" => "下一个版本",
"Programmed versions" => "计划的版本",
"Old versions" => "旧版本",
"Edit desc" => "编辑描述",
"Index page" => "索引页面",
"Set prefs" => "设置偏好",
">Remove Zones (you lose entered info for the banner)" => ">移除区域 (会失去此标题的信息)",
">Block description: " => ">锁定描述: ",
"Admin content" => "管理內容",
"Warn on edit" => "编辑警告",
"Show comments" => "显示评论",
"Hide comments" => "隐藏评论",
"reply to this" => "回复这篇",
"Create or edit a file gallery using this form" => "使用此表单创建或编辑下载中心",
"Top Files" => "热门文件",
"Cannot get file from URL" => "无法从URL取得文件",
"You cant download files" => "你无法下传文件",
"No file" => "没有文件",
"Create/edit Forums" => "创建/编辑论坛",
"Moderator" => "版主",
"Comm" => "通讯",
"Cms" => "内容管理",
"There are inddividual permissions set for this gallery" => "此文件库有独立的权限设置",
" modified" => " 更改",
"No indivual permissions global permissions apply" => "没有单独权限设定，套用全局权限设定",
"Assign permissions to this page" => "指定权限给此页面",
"Show Post Form" => "显示发帖表单",
"Hide Post Form" => "隐藏发表表单",
"smileys" => "表情符号",
"Edit or add category" => "编辑或增加类别",
"sub categories" => "子类别",
"There are inddividual permissions set for this blog" => "这个博客有独立的权限设置",
"Layout options" => "版面配置选项",
"polls" => "投票",
"features" => "特性",
"cms" => "内容管理",
"CMS settings" => "内容管理设置",
"image galleries" => "图像画廊",
"general" => "一般",
"Set home forum" => "设置主页论坛",
"file galleries" => "下载中心",
"rss" => "rss",
"Set feeds" => "设定 feeds",
"There are inddividual permissions set for this file gallery" => "这个文件库有独立权限设置",
"half a second" => "0.5秒",
"Create/edit RSS module" => "创建/编辑 RSS 版块",
"Create/edit Menus" => "创建/编辑 菜单",
"Admin chat" => "管理聊天",
"Permission denied you cant view this section" => "权限不足, 你无法查看这个版块",
"File gals" => "下载中心",
"Image gals" => "图像画廊",
"use square brackets for an" => "使用方括号表示",
"Allowed HTML:" => "允许 HTML:",
"Configure modules" => "配置版块",
"to insert a random tagline" => "插入随机的标记行",
"Use (:name:) for smileys" => "使用 (:name:) 笑脸符",
"Restoring a backup destoys all the data in your Tiki database.\nAll your tables will be replaced with the information in the backup." => "从备份文件中回复数据将破坏您现有数据库中的数据.\n所有的数据将会被备份中的数据所替代.",
"Creating backups may take a long time. If the process is not completed you will\nsee a blank screen. If so you need to increment the maximum script execution time\nfrom your php.ini file" => "创建备份可能花费许多时间。如果备份过程未完成，会出现空白\n页面。你必须从 php.ini 中调整最大命令执行时间以避免发生此现象。\n",
"Click here to create a new backup" => "点击这里以创建新备份",
"Create/edit Faq" => "建立/增加 FAQ",
"FAQ Questions" => "FAQ 问题",
"FAQ Answers" => "FAQ 答案",
">I forgot my password" => ">忘记密码",
"column" => "列",
"Show chart for the last " => "显示排行榜于最近",
"days (0=all)" => "天 (1=全部)",
"dispay" => "显示",
"user bookmarks" => "用户书签",
"Admin Cookies" => "管理 Cookies",
"Entire site" => "整个网站",
"content templates" => "內容模板",
"shoutbox" => "布告栏",
"drawings" => "绘图",
"assigned" => "指定",
"Hotwords in new window" => "热词于新窗口中",
"Allow smileys" => "允许表情符号",
"Reuse question" => "重复使用问题",
"suggested" => "建议",
"wiki link" => "wiki 链接",
"heading2" => "标题2",
"heading3" => "标题3",
"Show suggested questions/suggest a question" => "显示建议的问题/建议一个问题",
"Hide suggested questions" => "隐藏建议的问题",
"Create/edit templates" => "创建/编辑模板",
"categorize" => "分类",
"Create/edit HTML pages" => "创建/编辑 HTML 页面",
"Admin HTML page dynamic zones" => "管理 HTML 页面动态区域",
"Edit this HTML page" => "编辑此 HTML 页面",
"feat" => "功能",
"Server time zone" => "服务器时区",
"Wiki Page Names" => "Wiki 页面名称",
"strict" => "严谨",
"gral" => "一般",
"file gls" => "下载中心",
"trckrs" => "跟踪",
"frms" => "论坛",
"img gls" => "图像画廊",
"webmail" => "web邮箱",
"Allow viwing HTML mails?" => "允许查看 HTML 邮件?",
"Add all your site users to this newsletter (broadcast)" => "加入你所有的用户到此电子期刊 (广播)",
"Add users" => "增加用户",
"Users can subscribe any email addresss" => "用户可以提交任何EMAIL地址",
"Create/edit surveys" => "创建/编辑 调查",
"Options (separated by commas used in dropdowns only)" => "选项 (仅用于下拉菜单, 使用逗号分开)",
"There are inddividual permissions set for this tracker" => "这个跟踪有独立权限设置",
"Show status when listing tracker items?" => "当列出跟踪项目时显示统计?",
"Prevents parsing data" => "防止分析资料",
"b" => "粗体",
"i" => "斜体",
"ul" => "ul",
"a" => "超连接",
"h1" => "标题1",
"h2" => "标题2",
"h3" => "标题3",
"tbl" => "表格",
"dcs" => "定义css",
"center" => "居中",
"img nc" => "图像 nc",
"chars" => "特殊字符",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appeareance of the page, no versions are stored for this page." => "涂鸦板是一个可以练习编辑技巧的页面, 使用预览的功能\n来预览这个页面的样式, 而这个页面的版本将不会被保存.",
"Import pages from a PHPWiki Dump" => "从PHPWiki的卸出导入页面",
"Path to where the dumped files are" => "卸出文件的路径",
"ver" => "版本",
"Thanks for your subscription. You will receive an email soon to confirm your subscription.\nNo newsletters will be sent to you until the subscription is confirmed." => "感谢你的订阅. 你会收到一封信件以确认你的订阅.\n在订阅确认前不会收到电子期刊.",
"Average posts pero weblog" => "每博客平均帖子数",
"checked" => "勾选的",
"unchecked" => "未勾选的",
"Mark as Flagged" => "设为已标记",
"Wiki Import dump" => "Wiki导入卸出",
"You cant use the same password again" => "你不能再次使用相同的密码",
"You have to provide a name to the file" => "您必须为这个文件指定一个名称",
"parent" => "父系",
"userfiles" => "用户文件",
"Cache wiki pages" => "缓存 wiki 页面",
"Users can save pages to notepad" => "用户能保存页面到记事本",
"\n for rows" => "\n 表示行",
"Forum settings" => "论坛设置",
"Allow wiki markup" => "允许 wiki 标记",
"Describe topics in listing" => "在列表中描述主题",
"Allow viewing HTML mails" => "允许查看 HTML 邮件",
"subs" => "主题",
"objs" => "对象",
"Admin content templates" => "管理內容模版",
"Edit drawings &amp; pictures" => "编辑绘图和图片",
"Edit/Create user module" => "编辑/创建 用户版块",
"assign_perms" => "指定权限",
"assgn" => "指定",
"rotate left" => "向左旋转",
"Klick to enlarge" => "点击放大",
"Add or edit a category" => "增加或编辑类别",
"In parent page" => "在父页面中",
"Availible scales" => "可用比例",
"No scales availible" => "没有可用比例",
"Add scaled images size X x Y" => "增加图像尺度大小 X x Y",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "卸出文件所在的路径 (tiki目录的相对路径加上斜线 例如: dump/)",
"use filename" => "使用文件名称",
"Use dbl click to edit pages" => "双击鼠标编辑页面",
"All tasks" => "所有任务",
"mark as done" => "标记为已完成",
"open tasks" => "打开任务",
"Add or edit a task" => "创建或编辑一个任务",
"Mailin accounts" => "Mailin 账号",
"Return to messages" => "返回消息列表",
"Unflagg" => "解除标记",
"Newss from" => "新闻来自",
"Control by Object" => "由对象控制",
"Control by category" => "由类别控制",
"Create/edit extwiki" => "创建/编辑 外部wiki",
"Admin (click!)" => "管理 (点击!)",
"Mus enter a name to add a site" => "增加站点时必须输入名称",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "无法存取 URL, URL 错误或站点不存在, 无法加入目录",
"MyTiki (click!)" => "我的TiKi(点击!)",
"draws" => "绘图",
"List Games" => "游戏列表",
"You will receive an email with your password soon" => "你很快就会收到含有密码的电子邮件",
"Displays a snippet of code.\nSet optional paramater -+ln+- to 1 if you need line numbering feature." => "显示一段代码.\n如果需要行号特性, 请设置选择性参数 -+ln+- 为 2.",
"Renders a graph" => "画出图表",
"PluginsHelp" => "插件说明",
"create new empty structure" => "创建新的空导航结构",
"Create structure from tree" => "由树系创建导航结构",
"Admin structures" => "管理导航结构",
"Click twice if once is not enough !" => "如果一次不够, 请点击两次!",
"Toggle display of comment zone" => "开关注解区域的显示",
"In blog listing show user as" => "在博客列表中显示用户为",
"creation date" => "创建日期",
"last modification time" => "最后修改时间",
"Articles listing configuration" => "文集列表配置",
"Edit css" => "编辑CSS样式",
"Use PHPOpenTracker" => "使用 PHPOpenTracker",
"User watches" => "用户监视",
"PDF Export" => "导出为PDF",
"Users can vote only one item from this chart per period" => "用户每一单位时间只能从这个排行榜中投票一项",
"Prevent users from voting same item more than one time" => "防止用户对相同项目投票超过一次",
"Edit drawings" => "编辑绘图",
"Threads can be voted" => "讨论串可投票",
"Forward messages to this forum to this email" => "转发此论坛的消息到此电子邮箱",
"Directory (include trailing slash)" => "目录 (包含结尾的/)",
"stat" => "统计",
"ExtWikis" => "外部 Wikis",
"Calendars Panel" => "日程表控制面板",
"Navigation Panel" => "导览面板",
"Hide Panels" => "隐藏面板",
"hide from display" => "不显示",
"Tiki Calendars" => "Tiki日程表",
"today" => "今日",
"+1d" => "+1天",
"+7d" => "+7天",
"+1m" => "+1月",
"browse by" => "浏览",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "如果你更改了日程表选项, 请重新整理以取得正确的类别, 地点, 以及人名列表(如果適用于你所选的日程表类型)",
"from the list" => "从列表",
"choose" => "选择",
"You should first ask that a calendar is created, so you can create events attached to it." => "你必须在创建日程表时先询问, 以便创建要附加上去的事件",
"save a custom copy" => "另存定制备份",
"heading" => "标题",
"horizontal ruler" => "水平标尺",
"act status" => "活动统计",
"running" => "执行中",
"op" => "操作",
"remove bookmark" => "移除书签",
"Tiki forums" => "Tiki 论坛",
"mot" => "警句",
"this post was reported" => "本帖子已被报告",
"report this post" => "报告此帖子",
"someone from" => "某人来自",
"If you want to be a registered user in this site you will have to use" => "如果你想成为本站的注册用户, 你必须使用",
"the following link to login for the first time" => "以下的链接来进行第一次登录",
"More info about" => "更多信息:",
"idle" => "发呆",
"blog_ranking_top_blogs" => "最热博客排名",
"blog_ranking_last_posts" => "博客最近发帖排名",
"blog_ranking_top_active_blogs" => "最勤博客排名",
"filegal_ranking_top_galleries" => "filegal_ranking_top_galleries",
"filegal_ranking_top_files" => "filegal_ranking_top_files",
"filegal_ranking_last_files" => "filegal_ranking_last_files",
"gal_ranking_top_galleries" => "gal_ranking_top_galleries",
"gal_ranking_top_images" => "gal_ranking_top_images",
"gal_ranking_last_images" => "gal_ranking_last_images",
"updated by the phpwiki import process" => "被phpwiki导入过程所更新",
"created from phpwiki import" => "从phpwiki导入创建",
"Wiki page" => "Wiki页面",
"Your Tiki account information for" => "你的 Tiki 帐号信息",
"A new password has been sent " => "新密码已发送 ",
" new topic:" => " 新主题:",
"topic:" => "主题:",
"forum topic" => "论坛主题",
"Current page:" => "当前页面:",
"version %s" => "版本 %s",
"last modified on %s" => "最后修改于 %s",
"by %s" => "由 %s",
"Archived page:" => "保存的页面:",
"Diff of %s." => " %s 的差异.",
" tags. Example: {tr}The newsletter was sent to {\$sent} email addresses" => " 标签. 范例: {tr}本电子期刊发送到 {\$sent} 电子邮件地址",
"New article submitted at " => "新文章发表于 ",
"Welcome to " => "欢迎来到 ",
" at " => " 在 ",
"Bye bye from " => "Bye bye 从 ",
"There is an error in the plugin data" => "外挂模块资料发生错误",
"Change your email" => "更改你的电子邮箱",
"Tip: hold down CTRL to select multiple categories" => "提示：按住CTRL可以选择多个类别",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "提示：取消钩选上面这个检查框取消对这个页面/对象的分类",
"A new password has been sent" => "新密码已经发送",
"A password reminder email has been sent" => "已发送密码提示邮件",
"Information:" => "信息:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "新博客帖子: {\$mail_title} 由 {\$mail_user} 发表于 {\$mail_date|tiki_short_datetime}",
"Admin Mods" => "插件管理",
"Please" => "请",
"log in" => "登录",
"to access full functionalities" => "以使用完整特性",
"Jukebox" => "在线点播",
"Friendship network" => "网友",
"TikiTabs" => "Tiki表格",
"Tiki Projects" => "Tiki 项目",
"Php error reporting level for non-admin:" => "非管理员PHP错误报告等级:",
"Jukebox settings" => "在线点播设置",
"Jukebox tracks location" => "在线点播轨道位置",
"Jukebox features" => "在线点播特性",
"Default ordering for album listing" => "默认影集列表顺序",
"Album title (asc)" => "影集列表标题（升序）",
"Number of tracks (desc)" => "轨道数（降序）",
"In album listing show user as" => "在影集列表显示用户为",
"Jukebox listing configuration (when listing available albums)" => "在线点播列表配置（当影集列表有效时）",
"Tracks" => "轨道",
"Genre" => "流派",
"Create a group for each user <br />(with the same\nname as the user)" => "为每个用户创建群组（与用户同名）",
"<b>Title</b>" => "<b>标题</b>",
"<b>Description</b>" => "<b>描述</b>",
"Append CSS file to feed urls" => "给应用的urls附上CSS文件",
"Publisher" => "发表者",
"List Calendars" => "列出日程表",
"Add unsubscribe instructions to each event" => "Add unsubscribe instructions to each event",
"send event" => "发送事件",
"Category: wiki, tracker, etc." => "类别:wiki、tracker(跟踪器)等",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "注意: 如果你要使用图像，请先保存文章，之后才能编辑/发表图像。在文本区域中使用&lt;img&gt; 片段表示上传的图像。或使用所见即所得编辑器插入图像 URL。",
"Add Calendar Item" => "增加日程表条目",
"make a line break" => "断行",
"creates an editable drawing named foo" => "创建名称为foo的可编辑的绘图",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "显示预格式化的文本或者代码；在这个版块内不进行Wiki文档词法处理，并且空格也是固定的（不作词换行）。",
"Insert Module Output" => "插入版块的输出",
"Rendering Program Code" => "显示程序代码",
"The passwords didn't match" => "密码不符",
"You dont have permission to use this feature" => "你没有使用此特性的权限",
"You do not have permission to use this feature." => "你没有权限使用此特性.",
"no description" => "无描述",
"requested a reminder of the password for the" => "要求发送密码提示",
"since this is your registered email address we inform that the" => "既然这是你的注册电子邮件地址, 我们就发送到此",
"password for this account is" => "此账号的密码是",
"Wiki page list configuration" => "Wiki页面列表设定",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "使用 {literal}{{/literal}ed id=name} 或 {literal}{{/literal}ted id=name}以加入动态区域",
"Added users" => "加入的用户",
"Textheight" => "文本高度",
"Height of top Heading" => "顶标题高度",
"Height of mid Heading" => "中层标题大小",
"Height of inner Heading" => "內层标题大小",
"tbheight" => "表格大小",
"use ...page... to separate pages" => "使用 ...page... 分隔页面",
"Activs" => "活跃",
"Ins" => "实例",
"Wiki quick help" => "Wiki快速帮助",
"perm" => "权限",
"Blog settings" => "博客设置",
"FAQs settings" => "FAQs 设定",
"FAQ comments" => "FAQ 评论",
"Remind passwords by email" => "用电子邮件提示密码",
"Poll settings" => "投票设置",
"Create a tag for the current wiki" => "为当前的Wiki文档生成一个标签",
"Restore the wiki" => "恢复此wiki",
"Wiki comments settings" => "Wiki文档评论设置",
"Like pages" => "类似页面",
"search category" => "搜索类别",
"deep" => "深度",
"Emphasis" => "字型样式",
"italics" => "斜体",
"both" => "粗斜体",
"make_headings" => "创建标题",
"underlines text" => "文本加底线，",
"Simple box" => "简单方块",
"Will display using the indicated HTML color" => "会使用指定的 HTML 色彩显示",
"Will display the text centered" => "会置中显示文本",
"time" => "时间",
"Quicklinks" => "快速链接",
"Comparing versions" => "版本比较",
"Actual_version" => "实际版本",
"Diff to version" => "版本差异",
"Editing tracker item" => "编辑跟踪项目",
"The passwords dont match" => "密码不匹配",
"You do not have permission to write the template" => "您没有权限写入模板",
"You have to provide a name to the image" => "你必须为此图像取个名字",
" #" => " #",
" <b>enable/disable</b>" => " <b>开启/关闭</b>",
" <b>Feed</b>" => " <b>应用</b>",
" <b>Max number of items</b>" => " <b>最大项目数</b>",
" >Block description:" => " >模块描述:",
" >I forgot my password" => " >忘记密码",
" >Remove Zones (you lose entered info for the banner)" => " >移除区域 (会失去此标题的信息)",
" at" => " 在",
" is interactive so it must use the \$instance->complete() method" => "是交互活动，所以必须使用方法\$instance->complete()",
" is non-interactive so it must not use the \$instance->complete() method" => "是非交互活动，所以不能使用方法\$instance->complete()",
" is standalone and is using the \$instance object" => "是独立活动，但使用实例对象\$instance",
" is switch so it must use \$instance->setNextActivity(\$actname) method" => "是开关活动，所以必须使用方法\$instance->setNextActivity(\$actname)",
" on" => "在",
"(optional)" => "(可选)",
"(work in progress)" => "(工作进行中)",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>注意事项 1</b>: 如果你允许用户自行调整版块的配置, 配置的版块\n将不会反应到屏幕上, 必须到 我的Tiki->版块 中配置.<br/>\n<b>注意事项 2</b>: 如果你指定版块到用户组中, 请确定你已到 管理->一般选项 中把\n「所有的版块都显示用户组」选项关闭。",
"<b>Legend:</b> v=view, b=rollback, c=compare with current, d=diff to current, s=source" => "<b>图例说明</b>: v=查看, b=还原, c=与当前比较, d=与当前差异, s=来源",
"-1d" => "-1天",
"-1m" => "-1月",
"-7d" => "-7天",
"Accepted friendship request from" => "接受交友请求:",
"Activity " => "活动",
"Add New Group" => "创建新用户组",
"Admin Genres" => "管理流派",
"admin_menu" => "管理菜单",
"Alias:" => "别名:",
"Application menu" => "应用程序菜单",
"application_menu" => "应用程序菜单",
"Apr" => "4月",
"Are you sure you want to delete this directory?" => "真的要删除这个目录吗？",
"Are you sure you want to delete this file?" => "真的要删除这个文件吗？",
"Are you sure you want to delete this template?" => "真的要删除这个模版？",
"Assign permissions automatically:<br /><i>(recommended for best performance)</i>" => "自动指定权限：:<br /><i>(为了好性能，推荐使用)</i>",
"Assign permissions to" => "指定权限给",
"assistant" => "助手",
"assistant.tpl" => "助手模板",
"Aug" => "8月",
"Available styles" => "有效样式",
"background color of the node\n" => "节点背景色。\n",
"breadcrumb" => "最近访问Wiki页面",
"breake friendship" => "中断了友谊",
"Broke friendship with" => "中断友谊，和",
"Bye bye from" => "再见!来自",
"Can admin ephemerides" => "可管理日程表",
"Can admin events in the calendar" => "可管理日程表中的事件",
"Can broadcast" => "可广播",
"Can create new css" => "可创建新CSS",
"Can create user bookmarksche user bookmarks" => "可创建、管理用户书签",
"Can create user" => "可创建用户",
"Can edit copyright" => "可编辑版权",
"Can edit site" => "可编辑网站",
"Can send instances" => "可发送实例",
"Can validate submited" => "可验证提交",
"Can view ephemerides" => "可查看日程表",
"Can vote in forums" => "在论坛里可投票",
"Category: wiki, tracker, etc.:" => "类别：wiki, tracker, 等",
"change email" => "更改电子邮件",
"Click here to delete this template" => "点击这里删除这个模版",
"color for links (called edges here)\n" => "链接的颜色（叫边缘）。\n",
"color of the border\n" => "边框色。\n",
"comm" => "通讯",
"comm_received_objects" => "收到的通讯对象",
"Create a group for each user <br />(with the samename as the user)" => "为每个用户创建用户组，（用同样的名称作为用户）",
"Create a new album" => "创建新点播本",
"create image galleries" => "创建新库",
"create new album" => "创建点播本",
"create new genre" => "创建新流派",
"Create new survey" => "创建新调查",
"Create New Survey:" => "创建新调查:",
"Create/edit FAQ" => "创建/增加FAQ",
"Dec" => "12月",
"Dictionary / Thesaurus" => "在线词典",
"dictionary" => "在线词典",
"Diff:" => "差异:",
"directory_last_sites" => "最新目录网站",
"directory_stats" => "网站目录统计",
"directory_top_sites" => "热门目录网站",
"dscending" => "降序",
"dynamic variables" => "动态变量",
"Edit this group:" => "编辑此用户组:",
"Edit Translation" => "编辑翻译",
"Enable watch by default for author" => "作者默认启动监视",
"Enable watches when I am the editor" => "当我是编辑者时启动监视",
"eph" => "小日程表",
"Events Panel" => "事项面板",
"feature_ hat" => "聊天特性",
"feature_articles" => "文集特性",
"feature_autolinks" => "自动链接特性",
"feature_babelfish" => "显示Babelfish翻译网站链接特性",
"feature_babelfish_logo" => "显示Babelfish翻译网站的徽标特性",
"feature_banners" => "标语特性",
"feature_banning" => "禁用特性",
"feature_blogs" => "博客特性",
"feature_bot_bar" => "条特性",
"feature_calendar" => "日程表特性",
"feature_categories" => "类别特性",
"feature_categoryobjects" => "显示类别路径特性",
"feature_categorypath" => "显示类别路径特性",
"feature_charts" => "排行榜特性",
"feature_comm" => "通讯特性",
"feature_contact" => "联系我们特性",
"feature_custom_home" => "定制主页特性",
"feature_debug_console" => "调试控制台特性",
"feature_directory" => "网站目录特性",
"feature_drawings" => "画图特性",
"feature_dynamic_content" => "动态内容",
"feature_edit_templates" => "编辑模板特性",
"feature_editcss" => "编辑CSS特性",
"feature_eph" => "日程表特性",
"feature_faqs" => "FAQ特性",
"feature_featuredLinks" => "推荐链接特性",
"feature_file_galleries" => "下载中心特性",
"feature_forums" => "论坛特性",
"feature_friends" => "友情链接特性",
"feature_galleries" => "文件库特性",
"feature_games" => "游戏特性",
"feature_help" => "帮助特性",
"feature_homework" => "家庭作业特性",
"feature_hotwords" => "热词特性",
"feature_hotwords_nw" => "新窗口显示热词特性",
"feature_html_pages" => "HTML页面特性",
"feature_integrator" => "收集器特性",
"feature_jscalendar" => "JS日程表特性",
"feature_jukebox" => "媒体点播特性",
"feature_left_column" => "左列特性",
"feature_live_support" => "在线支持特性",
"feature_maps" => "地图特性",
"feature_messages" => "消息特性",
"feature_minical" => "迷你日程表特性",
"feature_modulecontrols" => "模块控制特性",
"feature_multilingual" => "多语言支持特性",
"feature_newsletters" => "电子期刊特性",
"feature_newsreader" => "新闻阅读器特性",
"feature_notepad" => "笔记本特性",
"feature_phplayers" => "phplayers特性",
"feature_polls" => "投票特性",
"feature_quizzes" => "小测验特性",
"feature_referer_stats" => "参照状态特性",
"feature_right_column" => "右列特性",
"feature_score" => "打分特性",
"feature_search" => "搜索特性",
"feature_search_stats" => "搜索状态特性",
"feature_sheet" => "工作表特性",
"feature_shoutbox" => "布告栏特性",
"feature_smileys" => "表情特性",
"feature_stats" => "状态特性",
"feature_surveys" => "调查特性",
"feature_tabs" => "表格特性",
"feature_tasks" => "任务特性",
"feature_theme_control" => "布景主题控制特性",
"feature_top_bar" => "页顶条特性",
"feature_trackers" => "跟踪特性",
"feature_user_bookmarks" => "用户书签特性",
"feature_user_watches" => "用户监视特性",
"feature_userfiles" => "用户文件特性",
"feature_usermenu" => "用户菜单特性",
"feature_userPreferences" => "用户偏好",
"feature_view_tpl" => "查看模板特性",
"feature_webmail" => "Web邮箱特性",
"feature_wiki" => "Wiki文档特性",
"feature_workflow" => "工作流程特性",
"feature_xmlrpc" => "XMLPRC特性",
"featured_links" => "推荐链接",
"Feb" => "2月",
"file_galleries" => "下载中心",
"Font Color" => "字体颜色",
"For more information, please see <a\nhref=\"http:www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http:www.tikiwiki.org\">Tikiwiki.org</a>." => "更多信息，请查看 <a\nhref=\"http:www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\n在 <a href=\"http:www.tikiwiki.org\">Tikiwiki.org</a>",
"Forums last posts topics" => "论坛最近发帖主题",
"forums_best_voted_topics" => "论坛最高票数主题",
"forums_last_posts" => "论坛最近帖子",
"forums_last_posts_topics" => "论坛最近发帖主题",
"forums_last_topics" => "最近论坛主题",
"forums_most_commented_forums" => "最多评论论坛",
"forums_most_read_topics" => "最多阅读论坛",
"forums_most_visited_forums" => "最多被访论坛",
"ForumsUser" => "发帖作者",
"forumsuser" => "发帖作者",
"Frienship request sent to" => "交友请求发送给",
"Genres Admin" => "流派管理",
"google" => "google搜索",
"groupname" => "用户组名称",
"has not been created" => "尚未创建",
"Header Only" => "仅标题",
"hot_links" => "常用链接",
"html pages" => "HTML页面",
"html_pages" => "HTML页面",
"Icon Theme" => "图标主题",
"Insert articles into a wikipage" => "将文章插入到Wiki页面。",
"Invalid password.  You current password is required to change your email address." => "密码错误. 请输入正确的密码才能更改你的电子邮箱地址.",
"Jan" => "1月",
"Jukebox Admin" => "点播管理",
"Jukebox Albums" => "点播本",
"Jukebox Genres" => "点播流派",
"Jul" => "7月",
"Jun" => "6月",
"Last forum posts topics" => "论坛最近发帖主题",
"last_articles" => "最近文集",
"last_blog_posts" => "最近发表博客",
"last_category_objects" => "最近分类对象",
"last_created_blogs" => "最近创建博客",
"last_created_faqs" => "最近创建FAQ",
"last_created_quizzes" => "最近创建测验",
"last_file_galleries" => "最近下载中心",
"last_files" => "最近文件库",
"last_image_galleries" => "最近图像画廊",
"last_modif_pages" => "最近Wiki文档变动",
"last_modif_tracker_items" => "最近修改跟踪条目",
"last_modified_blogs" => "最近修改博客",
"last_submissions" => "最近投稿",
"last_tracker_items" => "最近跟踪条目",
"Layer Management" => "层次管理",
"layout_section" => "布局版块特性",
"LDAP Group Atribute" => "LDAP 用户组属性",
"Left to Right, the direction of graph\n" => "（Left to Right）左到右，图表的方向。\n",
"live_support" => "在线支持",
"logged_users" => "登录用户",
"login_box" => "登录框",
"logo" => "徽标",
"Mailin" => "内置邮箱",
"Main extensive navigation menu" => "主要的广泛导航菜单",
"Manage attachement preferences" => "管理附件参数",
"Maps :" => "地图",
"maps" => "地图",
"Mar" => "3月",
"Max tracks per page" => "每页最大轨道数",
"messages_unread_messages" => "未读消息",
"messu" => "消息",
"mytiki" => "我的Tiki",
"New article submitted at" => "新文章提交于",
"New message arrived from" => "收到新消息:",
"newsletters" => "电子期刊",
"newsreader" => "新闻阅读器",
"No Change" => "不改变",
"No FAQ indicated" => "未指定FAQ",
"note: those parameters are exclusive" => "注意：那些参数是互斥的",
"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "什么都没有，不限大小。用5,3测定大小，单位为英寸。\n",
"notices" => "通知",
"Nov" => "11月",
"num is optionnal and is the order number of the attachment in the list. If not provided a list of all attachments is displayed." => "num是一个可选的表示附件在列表中的顺序的数字。如果没有提供所显示的全部附件的列表",
"num_submissions" => "投稿数目",
"Oct" => "10月",
"old_articles" => "旧文集",
"OnLine Search" => "在线搜索",
"online_search" => "在线搜索",
"online_users" => "在线用户",
"onlines total" => "在线人数",
"Other users can upload tracks to this album" => "其他用户可以上传轨道到这个点播本",
"page/pages" => "页面",
"pageviews" => "浏览数",
"PHPOpenTracker" => "PHPOpenTracker",
"post new reply" => "发表新回复",
"Posted comments" => "已发表评论",
"Posted replies" => "已发表的回复",
"Processing account" => "处理账号",
"quick_edit" => "快速编辑Wiki页面",
"Quiz time limit excedeed quiz cannot be computed" => "小测验时间限制已超过,小测验不列入计算",
"random_pages" => "随机页面",
"Relace internal links to integrator. Dont touch an external links." => "重新捆绑内部链接到储存库，不涉及外部链接。",
"Renders a graph, with linked pages navigation visually figured.\n" => "用数字图表链接的页面导航画出图表。\n",
"Replies below your current threshold" => "条回复于当前讨论串",
"Request friendship" => "请求交友",
"same mystery as above\n" => "节点的高度??。\n",
"SandBox" => "涂鸦板",
"search_box" => "搜索框",
"search_new" => "搜索新闻",
"search_wiki_page" => "搜索Wiki文档",
"Sep" => "9月",
"shape of the arrow that come with the link\n" => "伴随链接的箭头形状。\n",
"since_last_visit" => "上次以来更新",
"since_last_visit_new" => "上次以来更新",
"Sorry" => "抱歉",
"sortof relative width ??\n" => "节点的宽度??。\n",
"Source(URL)" => "来源网址(URL)",
"start is interactive but has no role assigned" => "交互活动已开始，但没有指定角色。",
"Stats for this quiz Questions" => "此小测验问题统计资料",
"Stats for this survey Questions" => "这次调查问题的结果",
"style for drawing nodes.\n" => "画节点的样式。\n",
"support" => "支持",
"surveys" => "调查",
"Swicth construct" => "切换导航结构",
"switch_lang" => "切换语言",
"switch_lang2" => "切换语言2",
"switch_theme" => "切换主题",
"tail" => "页脚",
"templates" => "模板",
"the background color, use #rrvvbb color types.\n" => "背景色，使用#rrvvbb颜色类型。\n",
"The cord" => "The cord",
"the font size in pts presumably\n" => "大概的字体大小。\n",
"the name of the font used for labels\n" => "标签用的字体名称。\n",
"The new page content is:" => "新的页面內容:",
"the number of hops the graph follows\n" => "图表线条跳跃的数字。\n",
"the shape of a node. can be " => "节点的形状。可以是 ",
"the space beetween nodes\n" => "节点之间的空白。\n",
"the title of the map\n" => "图形标题。\n",
"The user has choosen to make his information private" => "此用户选择保密个人信息",
"There was an unsepecified error.  Please go back and try again." => "发生意外的错误，请返回再试。",
"This user is not your friend" => "这个用户不是你的朋友",
"tiki_p_abort_instance" => "中断处理的实例",
"tiki_p_access_closed_site" => "存取关闭网站",
"tiki_p_add_events" => "在日程表增加事件 ",
"tiki_p_admin" => "管理全权",
"tiki_p_admin_banners" => "管理标题条 ",
"tiki_p_admin_banning" => "禁止用户或IP ",
"tiki_p_admin_calendar" => "创建/管理日程表 ",
"tiki_p_admin_categories" => "管理导航类别 ",
"tiki_p_admin_charts" => "管理排行榜 ",
"tiki_p_admin_chat" => "管理聊天 ",
"tiki_p_admin_cms" => "管理内容管理 ",
"tiki_p_admin_directory" => "管理网站目录 ",
"tiki_p_admin_directory_cats" => "管理网站目录类别 ",
"tiki_p_admin_directory_sites" => "管理目录网站 ",
"tiki_p_admin_drawings" => "管理绘图 ",
"tiki_p_admin_dynamic" => "管理动态内容系统 ",
"tiki_p_admin_faqs" => "管理FAQ ",
"tiki_p_admin_file_galleries" => "管理下载中心 ",
"tiki_p_admin_forum" => "管理论坛 ",
"tiki_p_admin_galleries" => "管理文件库 ",
"tiki_p_admin_games" => "管理游戏 ",
"tiki_p_admin_integrator" => "管理储存库和规则 ",
"tiki_p_admin_mailin" => "管理内置邮箱账号 ",
"tiki_p_admin_newsletters" => "管理电子期刊 ",
"tiki_p_admin_quizzes" => "管理小测验 ",
"tiki_p_admin_received_articles" => "管理收到的文章 ",
"tiki_p_admin_received_pages" => "管理收到的页面 ",
"tiki_p_admin_shoutbox" => "管理布告栏（编辑/移除消息） ",
"tiki_p_admin_surveys" => "管理调查 ",
"tiki_p_admin_trackers" => "管理跟踪 ",
"tiki_p_admin_wiki" => "管理Wiki文档",
"tiki_p_admin_workflow" => "管理工作流程过程",
"tiki_p_approve_submission" => "审核投稿 ",
"tiki_p_attach_trackers" => "附加文件到跟踪条目 ",
"tiki_p_autoapprove_submission" => "自动审核投稿 ",
"tiki_p_autosubmit_link" => "自动提交链接 ",
"tiki_p_autoval_chart_suggestio" => " 自动验证建议 ",
"tiki_p_batch_upload_files" => "用文件上传 zip 文件 ",
"tiki_p_batch_upload_images" => "批量上传zip文件 ",
"tiki_p_blog_admin" => "管理博客 ",
"tiki_p_blog_post" => "发表博客",
"tiki_p_broadcast" => "广播消息到用户组 ",
"tiki_p_broadcast_all" => "广播消息给所有用户 ",
"tiki_p_cache_bookmarks" => "缓存用户书签",
"tiki_p_change_events" => "改变日程表中的事件 ",
"tiki_p_chat" => "可使用聊天系统 ",
"tiki_p_comment_tracker_items" => "评论跟踪条目",
"tiki_p_configure_modules" => "配置版块 ",
"tiki_p_create_blogs" => "创建博客",
"tiki_p_create_bookmarks" => "创建管理用户书签 ",
"tiki_p_create_css" => "创建css ",
"tiki_p_create_file_galleries" => "创建下载中心 ",
"tiki_p_create_galleries" => "创建文件库 ",
"tiki_p_create_tracker_items" => "创建新跟踪条目 ",
"tiki_p_download_files" => "下载文件 ",
"tiki_p_edit" => "编辑页面",
"tiki_p_edit_article" => "编辑文章 ",
"tiki_p_edit_comments" => "编辑所有评论 ",
"tiki_p_edit_content_templates" => "编辑内容模板 ",
"tiki_p_edit_cookies" => "管理cookies ",
"tiki_p_edit_copyrights" => "编辑版权通知",
"tiki_p_edit_drawings" => "编辑绘图 ",
"tiki_p_edit_dynvar" => "编辑动态变量",
"tiki_p_edit_html_pages" => "编辑HTML页面 ",
"tiki_p_edit_languages" => "编辑翻译和创建新语言 ",
"tiki_p_edit_structures" => "编辑导航结构",
"tiki_p_edit_submission" => "编辑投稿 ",
"tiki_p_edit_templates" => "编辑网站模板 ",
"tiki_p_eph_admin" => "管理日程表 ",
"tiki_p_exception_instance" => "声明例外的实例",
"tiki_p_forum_attach" => "在论坛跟帖 ",
"tiki_p_forum_autoapp" => " 自动通过论坛帖子 ",
"tiki_p_forum_post" => "在论坛发帖 ",
"tiki_p_forum_post_topic" => "在论坛里发起讨论 ",
"tiki_p_forum_read" => "查看论坛 ",
"tiki_p_forum_vote" => "在论坛投票评论 ",
"tiki_p_forums_report" => "报告信息给版主 ",
"tiki_p_live_support" => "使用实时支持系统 ",
"tiki_p_live_support_admin" => "实时支持系统 ",
"tiki_p_lock" => "锁定页面",
"tiki_p_map_create" => "创建新地图文件 ",
"tiki_p_map_delete" => "删除地图文件 ",
"tiki_p_map_edit" => "编辑地图文件 ",
"tiki_p_map_view" => "查看地图文件 ",
"tiki_p_messages" => "使用消息系统 ",
"tiki_p_minical" => "使用小事件日程表 ",
"tiki_p_minor" => "另存为次要的编辑",
"tiki_p_modify_tracker_items" => "改变跟踪条目 ",
"tiki_p_newsreader" => "使用新闻阅读器",
"tiki_p_notepad" => "使用笔记本",
"tiki_p_play_games" => "玩游戏 ",
"tiki_p_post_comments" => "发表新评论 ",
"tiki_p_post_shoutbox" => "在布告栏发帖 ",
"tiki_p_read_article" => "阅读文章 ",
"tiki_p_read_blog" => "阅读博客 ",
"tiki_p_read_comments" => "阅读评论 ",
"tiki_p_remove" => "移除页面",
"tiki_p_remove_article" => "移除文章 ",
"tiki_p_remove_comments" => "删除评论 ",
"tiki_p_remove_submission" => "移除投稿 ",
"tiki_p_rename" => "给页面改名",
"tiki_p_rollback" => "复原页面",
"tiki_p_send_articles" => "发送文章到其他网站 ",
"tiki_p_send_instance" => "发送实例",
"tiki_p_send_pages" => "发送页面到其他网站 ",
"tiki_p_sendme_articles" => "发送文章到这个网站 ",
"tiki_p_sendme_pages" => "发送页面到这个网站 ",
"tiki_p_submit_article" => "提交文章 ",
"tiki_p_submit_link" => "提交网站到目录 ",
"tiki_p_subscribe_email" => "用任何电子邮件订阅电子期刊 ",
"tiki_p_subscribe_newsletters" => "订阅电子期刊 ",
"tiki_p_suggest_chart_item" => "建议条目 ",
"tiki_p_suggest_faq" => "建议FAQ问题 ",
"tiki_p_take_quiz" => "接受小测验 ",
"tiki_p_take_survey" => "接受调查 ",
"tiki_p_tasks" => "使用任务 ",
"tiki_p_topic_read" => "阅读主题（仅提供给独立的主题权限） ",
"tiki_p_upload_files" => "上传文件 ",
"tiki_p_upload_images" => "上传图像 ",
"tiki_p_upload_picture" => "上传图片到Wiki页面",
"tiki_p_use_content_templates" => "使用内容模板 ",
"tiki_p_use_HTML" => "在页面使用HTML ",
"tiki_p_use_webmail" => "使用web邮箱",
"tiki_p_use_workflow" => "执行工作流程活动",
"tiki_p_userfiles" => "上传个人文件 ",
"tiki_p_usermenu" => "在个人菜单管理",
"tiki_p_validate_links" => "验证提交的链接 ",
"tiki_p_view" => "查看页面",
"tiki_p_view_calendar" => "浏览日程表 ",
"tiki_p_view_categories" => "浏览类别 ",
"tiki_p_view_chart" => "查看排行榜 ",
"tiki_p_view_directory" => "查看网站目录 ",
"tiki_p_view_eph" => "查看日程表 ",
"tiki_p_view_faqs" => "查看FAQ ",
"tiki_p_view_file_gallery" => "查看下载中心 ",
"tiki_p_view_html_pages" => "查看HTML页面 ",
"tiki_p_view_image_gallery" => "查看图像画廊 ",
"tiki_p_view_integrator" => "查看储存库 ",
"tiki_p_view_quiz_stats" => "查看小测验统计 ",
"tiki_p_view_referer_stats" => "查看相关统计 ",
"tiki_p_view_shoutbox" => "查看布告栏 ",
"tiki_p_view_stats" => "查看网站统计 ",
"tiki_p_view_survey_stats" => "查看调查统计 ",
"tiki_p_view_trackers" => "查看跟踪 ",
"tiki_p_view_user_results" => "查看用户小测验结果 ",
"tiki_p_vote_chart" => "投票 ",
"tiki_p_vote_comments" => "投票评论 ",
"tiki_p_vote_poll" => "投票表决 ",
"tiki_p_wiki_admin_attachments" => "管理Wiki页面的附件",
"tiki_p_wiki_attach_files" => "附加文件到Wiki页面",
"tiki_p_wiki_view_attachments" => "查看Wiki文档附件并下载",
"Time Zone Map" => "时区地图",
"Time Zone" => "时区",
"to configure your trackers, look for 'Admin trackers' under 'Trackers' on the application menu, or" => "要配置跟踪器，查找应用程序菜单的'跟踪器'下面的'管理跟踪器'，或者",
"top_active_blogs" => "最勤博客",
"top_articles" => "热门文章",
"top_file_galleries" => "热门下载中心",
"top_files" => "热门文件",
"top_forum_posters" => "最勤论坛作者",
"top_games" => "热门游戏",
"top_image_galleries" => "热门图像画廊",
"top_images" => "热门图像",
"top_images_th" => "热门图像",
"top_pages" => "热门页面",
"top_quizzes" => "热门小测验",
"top_visited_blogs" => "热门博客",
"top_visited_faqs" => "热门FAQ",
"Translation of" => "翻译",
"Unavailable - please set your e-mail below " => "无效--请在下面设置你的e-mail",
"Unexistant gallery" => "文件库不存在",
"Unexistant link" => "不存在的链接",
"Unexistant user" => "不存在的用户",
"Unexistant version" => "不存在版本",
"Unkwon" => "未知",
"Upload was not successful (maybe a duplicate file)" => "上传不成功 (可能是文件重复)",
"Use (:smileyname:) for smileys(smile, biggrin, cool, evil, frown, rolleyes, confused, cry, eek, exclaim, idea, mad, surprised, lol, redface, neutral, sad, twisted, wink)" => "使用 (:表情名称:) 表示表情图符。表情(复制即可)：微笑(:smile:) 大笑(:biggrin:) 扮酷(:cool:) 发邪(:evil:) 皱眉(:frown:) 转眼睛(:rolleyes:) 困惑(:confused:) 哭脸(:cry:) 惊恐(:eek:) 惊讶(:exclaim:) 思考(:idea:) 发疯(:mad:) 惊奇(:surprised:) 哈哈笑(:lol:) 害羞(:redface:) 中立(:neutral:) 悲伤(:sad:) 苦恼(:twisted:) 眨眼(:wink:)",
"Use [[foo] to show [foo]" => "用[[foo]来显示[foo]",
"Use this thread to discuss the" => "使用这个讨论串来讨论",
"User can Configure Modules" => "允许用户配置版块",
"user Can configure modules" => "用户可配置版块",
"user Can create items in personal menu" => "用户可在个人菜单中创建条目",
"user Can upload personal files" => "用户可上传个人文件",
"user Can use the notepad" => "用户可使用笔记本",
"User Page admin" => "用户Wiki页面管理",
"user_assigned_modules" => "用户指定版块特性",
"user_blogs" => "我的博客",
"user_bookmarks" => "我的书签",
"user_image_galleries" => "我的图像画廊",
"user_messages" => "用户消息",
"user_pages" => "我改过的Wiki页面",
"user_tasks" => "用户任务",
"usergroup_tracker" => "用户群组跟踪器",
"Userpage" => "我的Wiki页面",
"UserPage" => "我的Wiki页面",
"users_rank" => "用户排名",
"userSign" => "个性签名",
"Warning : Backups are known not to work since some time now. Don't rely on them. Chealer9 20031117" => "警告：已知已有一段时间没有备份，不能信赖这些备份。",
"WebMail accounts" => "Web邮箱账号",
"whats_related" => "相关信息",
"who_is_there" => "在线名册",
"wiki_last_comments" => "最近Wiki文档评论",
"WikiFormat Help" => "发帖格式帮助",
"with role" => "以角色",
"Word to look up" => "查词",
"workflow" => "工作流程",
"xx" => "xx",
"xxx" => "xxx",
"You can edit the page following this link:" => "你可使用此链接编辑页面:",
"You dont have permission to edit messages" => "你没有编辑消息的权限",
"You dont have permission to edit this banner" => "权限不足，不能编辑这个标题条",
"You dont have permission to read the template" => "权限不足, 你无法读取模板",
"You dont have permission to view other users data" => "你没有权限查看其他用户的资料",
"You dont have permission to write the style sheet" => "你没有权限写入样式表",
"You dont have permission to write the template" => "权限不足, 你无法写入模板",
"You dont have permissions to edit banners" => "权限不足, 你无法编辑标题条",
"You have 1 unread private messages" => "你有1条未读私人消息",
"you will need to backup this using FTP or SCP." => "你需要用FTP或者SCP来备份。",
"Your file gallery storage is set to" => "你的下载中心存储设在",
"Your image gallery storage is set to" => "你的图像画廊存储设在",
"You're already friend of" => "你们已经是朋友了",
"reload" => "重试",
"Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "注意: 本安装文本存在潜在的风险。我们强烈\n    \t\t建议你禁止以后再进入Tiki程序。 如果\n    \t\t你想稍后进行, 请按照i\n\t\ttiki-install.php中的说明进行",
"Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki检测到你的PHP memory limit设置仅有8 Megs",
"Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"dsn" => "dsn",
"uploaded by" => "上传自",
"not specified" => "未指定",
"delete" => "刪除",
"post" => "发表",
"stop monitoring this blog" => "停止监控此博客",
"posts" => "帖子",
"visits" => "浏览数",
"show categories" => "显示类别",
"author" => "作者",
"user level" => "用户等级",
"send email to user" => "发送电子邮件给用户",
"score" => "打分",
"delete selected" => "刪除选择项目",
"move" => "移动",
"set" => "设置",
"replies" => "回复",
"new reply" => "新回复",
"cancel" => "取消",
"up" => "上移",
"down" => "下移",
"add" => "增加",
"create" => "创建",
"save" => "保存",
"send" => "发送",
"register" => "注册",
"standard" => "标准",
"secure" => "安全",
"stay in ssl mode" => "停留在 ssl 模式",
"go" => "搜",
"cache" => "缓存",
"use" => "使用",
"cached" => "已缓存",
"refresh" => "刷新",
"print" => "打印",
"create pdf" => "创建 pdf",
"monitor this page" => "监视此页面",
"stop monitoring this page" => "停止监控此页面",
"backlinks" => "反向连接",
"rename" => "更名",
"unlock" => "解除锁定",
"lock" => "锁定",
"perms" => "权限",
"history" => "历史",
"similar" => "相似",
"undo" => "撤消",
"slides" => "幻灯片",
"export" => "导出",
"discuss" => "讨论",
"add comment" => "增加评论",
"attach file" => "附加文件",
"translation" => "翻译",
"last modification" => "最后修改",
"attachments" => "附件",
"stats" => "统计",
"last changes" => "最近变动",
"list pages" => "列出页面",
"back to homepage" => "回到主页",
"cancel edit" => "取消编辑",
"No attachments for this page" => "此页面没有附件",
"switch" => "条件",
"view blog" => "查看博客",
"list blogs" => "列出博客",
"save and exit" => "保存并退出",
"reads" => "阅读",
"view comments" => "查看评论",
"Click here to create it" => "点击这里创建这个Wiki页面",
"wiki help" => "Wiki帮助",
"General preferences" => "一般偏好",
"Other preferences" => "其他偏好",
"flag" => "国旗",
"HomePage" => "首页",
"Change information" => "改变信息",
"ok" => "确定",
"Best language" => "最佳语言",
"images" => "图像",
"Report PHP errors only for admin" => "只向管理员报告PHP错误",
"Server name (for absolute URIs)" => "服务器名称 (絕对 URI)",
"HTTPS Server" => "HTTPS服务器",
"path" => "路径",
"Validate email address (may not work)" => "确证电子邮件地址（可能不工作）",
"Require HTTP Basic authentication" => "需要 HTTP 基本认证",
"HTTP server name" => "HTTP 服务器名称",
"HTTP URL prefix" => "HTTP URL 前置",
"HTTPS server name" => "HTTPS 服务器名称",
"HTTPS URL prefix" => "HTTPS URL 前置",
"Only for users" => "仅用于用户",
"Users and admins" => "用户和管理员",
"Full Text Search" => "全文搜索",
"Site logo" => "网站徽标",
"Manage attachment preferences" => "管理附件偏好",
"full" => "完整",
"Enable Feature" => "启用特性",
"loc" => "位置",
"cat" => "类别",
"lang" => "语言",
"prio" => "优先级",
"permissions" => "权限",
"create new" => "创建新的",
"edit chart" => "编辑排行榜",
"update" => "更新",
"admin charts template" => "管理排行榜模板",
"use in cms" => "使用于内容管理",
"use in wiki" => "使用于Wiki文档",
"use in newsletters" => "使用于电子期刊",
"use in HTML pages" => "使用于 HTML 页面",
"last modif" => "最近修改",
"sections" => "版块",
"upload" => "上传",
"admin External Wikis" => "管理外部Wiki",
"extwiki" => "外部 wiki",
"admin forums template" => "管理论坛模板",
"Edit existing forums" => "编辑存在的论坛",
"online" => "在线",
"topics" => "主题",
"coms" => "帖子",
"age" => "年龄",
"ppd" => "每日发帖数",
"last post" => "最近帖子",
"list repositories" => "列出储藏",
"new repository" => "新储藏",
"view repository" => "查看储藏",
"view this repository" => "查看这个储藏",
"new rule" => "新规则",
"admin featured links" => "管理推荐链接",
"admin featured links template" => "管理推荐链接模板",
"position" => "位置",
"admin Webmail" => "管理webmail",
"admin mailin template" => "管理内置邮件账号模板",
"section" => "版块",
"sorted section" => "版块排序",
"admin menu builder" => "管理菜单构建器",
"admin menus template" => "管理菜单模板",
"options" => "选项",
"admin modules" => "管理版块",
"admin modules template" => "创建版块模板",
"assign module" => "指定版块",
"left modules" => "左版块",
"right modules" => "右版块",
"edit/create" => "编辑/创建",
"clear cache" => "清除缓存",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>注意事项 1</b>: 如果你允许用户自行调整版块的配置, 配置的版块\n将不会反应到屏幕上, 必须到 我的Tiki->版块 中配置.<br/>\n<b>注意事项 3</b>: 如果你指定版块到用户组中, 请确定你已到 管理->一般选项 中把\n「所有的版块都显示用户组」选项关闭。",
"assign" => "指定",
"left" => "左",
"right" => "右",
"order" => "顺序",
"create/edit" => "创建/编辑",
"use poll" => "使用投票",
"use gallery" => "使用文件库",
"use dynamic  content" => "使用动态內容",
"use rss module" => "使用 rss 版块",
"use menu" => "使用菜单",
"use phplayermenu" => "使用PHP层菜单",
"use banner zone" => "使用标语区域",
"list newsletters" => "列出电子期刊",
"admin newsletters" => "管理电子期刊",
"send newsletters" => "发送电子期刊",
"editions" => "版本",
"last sent" => "上次发送",
"use admin email" => "使用管理员电子邮件",
"event" => "事件",
"label" => "标签",
"export pages" => "导出页面",
"dump tree" => "卸出树系",
"create webhelp" => "创建web帮助",
"tree" => "树系",
"create new structure" => "创建新的导航结构",
"survey stats" => "调查结果",
"edit this survey" => "编辑这个调查",
"admin surveys" => "管理调查",
"list surveys" => "列出调查",
"questions" => "问题",
"files" => "文件",
"items" => "项目",
"version" => "版本",
"admin" => "管理",
"all" => "全部",
"Assign user" => "指定用户",
"Available groups" => "有效的群组",
"List of available backups" => "现有备份列表",
"Restoring a backup" => "回存一个备份",
"Warning!" => "警告!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "恢复备份会摧毀你所有 tiki 数据库的资料, 全部的表格将会被备份中的资料所取代",
"Click here to confirm restoring" => "点击这里确认回存",
"Create new backup" => "创建新备份",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "创建新的备份需要很长时间,如果你未执行完毕, 请增加你php.ini文件中最大执行时间的配置",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "如果你有任何附件保存在目录里，你需要用FTP或者SCP来备份",
"Upload a backup" => "上传一个备份",
"Upload backup" => "上传备份",
"admin category" => "管理类别目录",
"list galleries" => "列出文件库",
"edit gallery" => "编辑库",
"rebuild thumbnails" => "重建缩略图",
"upload image" => "上传图像",
"list gallery" => "列出库",
"original size" => "原始大小",
"return to gallery" => "返回文件库",
"edit image" => "编辑图像",
"smaller" => "缩小",
"bigger" => "放大",
"prev image" => "上一个图像",
"popup window" => "弹出窗口",
"next image" => "下一个图像",
"stop" => "停止",
"imagescale" => "图像比例",
"or create a new category" => "或创建新类别",
"or create a new location" => "或创建新地点",
"comma separated usernames" => "以逗点分隔的用户名称",
"comma separated username:role" => "以逗点分隔的 用户名称:角色",
"with roles" => "附带角色",
"Chair" => "席位",
"Optional" => "可选",
"permission" => "权限",
"remove page" => "移除页面",
"edit tpl" => "编辑模板",
"browse" => "浏览",
"related" => "相关",
"validate" => "确认",
"add a site" => "增加一个站点",
"search" => "搜索",
"list articles" => "列出文章",
"view articles" => "显示文章",
"create zone" => "创建区域",
"save the banner" => "保存标语",
"edit blog tpl" => "编辑博客模板",
"try" => "尝试",
"display" => "显示",
"admin quicktags" => "管理快捷标记",
"create new block" => "创建新模块",
"list quizzes" => "列出小测验",
"quiz stats" => "小测验统计",
"edit this quiz" => "编辑这个小测验",
"admin quizzes" => "管理小测验",
"results" => "结果",
"create page" => "创建页面",
"list submissions" => "列出投稿",
"Admin ephemerides" => "管理日程表",
"All ephemerides" => "所有日程表",
"new question" => "新问题",
"approve" => "审核",
"configure listing" => "配置列表",
"topic" => "主题",
"save and approve" => "保存并审核",
"new topic" => "新主题",
"reject" => "拒绝",
"accept" => "接受",
"refuse" => "拒绝",
"add new" => "新增加",
"add role" => "添加角色",
"new minor" => "新的次流程",
"new major" => "新的主流程",
"admin processes" => "管理流程",
"admin activities" => "管理流程活动",
"admin roles" => "管理角色",
"edit this process" => "编辑这个流程",
"monitor" => "监控器",
"send instance" => "发送实例",
"create new gallery" => "创建新库",
"result" => "结果",
"source" => "查看源码",
"edit new article" => "编辑新文章",
"create new blog" => "创建新博客",
"upload file" => "上传文件",
"Edit a file using this form" => "用这个格式编辑文件",
"delete selected files" => "删除所选文件",
"browse gallery" => "浏览库",
"Flash binary (.sqf or .dcr)" => "Flash 文件(.sqf 或 .dcr)",
"edit blog" => "编辑博客",
"edit new submission" => "编辑新的投稿",
"adm" => "管理",
"set as operator" => "设为操作员",
"add topic" => "增加主题",
"wiki create" => "wiki 建立",
"wiki overwrite" => "wiki 覆写",
"back" => "返回",
"Assign permissions to page" => "指定权限给页面",
"Current permissions for this page" => "本页面权限设置",
"this page" => "这一页",
"this structure" => "这个导航结构",
"Current permissions for categories that this page belongs to" => "当前这个页面的权限属于",
"Send email notifications when this page changes to" => "页面改变时发送电子邮件提醒",
"add email" => "加入电子邮件",
"Notifications" => "提醒",
"clear stats" => "清除统计",
"Edit received page" => "编辑收到的页面",
"last" => "最近",
"send me my password" => "寄给我密码",
"searched" => "已搜索",
"galleries" => "文件库",
"blog posts" => "博客帖子",
"wiki pages" => "wiki 页面",
"site" => "网站",
"clear" => "清除",
"add article" => "加入文章",
"create new sheet" => "创建新表",
"send answers" => "发送答案",
"move to right column" => "移到右列",
"unassign" => "未指定",
"move to left column" => "移到左列",
"remove folder" => "删除资料夹",
"refresh cache" => "刷新缓存",
"no comments" => "没有评论",
"edit items" => "编辑项目",
"list charts" => "列出排行榜",
"last chart" => "最末张排行榜",
"item" => "项目",
"add suggestion" => "添加建议",
"monitor this forum" => "监控此论坛",
"stop monitoring this forum" => "停止监控此论坛",
"delete selected topics" => "刪除选择的主题",
"stop monitoring this topic" => "停止监控此主题",
"Comments below your current threshold" => "显示当前算起的以下评论",
"add contacts" => "增加到通讯录",
"DATE-of" => "of",
"You cannot edit this page because it is a user personal page" => "你无法编辑此页面, 因为这是用户个人页面",
"Permission denied you cannot assign permissions for this page" => "权限不足, 你无法指定此页面的权限",
"You do not have permission to edit messages" => "您没有权限编辑消息",
"Cannot read file" => "无法读取文件",
"Permission denied you cannot upload files" => "权限不足, 你无法上传文件",
"cannot process upload" => "无法进行上传",
"Your email address has been removed from the list of addresses monitoring this tracker" => "你的电子邮件地址已经从监控此跟踪的列表中移除",
"Your email address has been added to the list of addresses monitoring this tracker" => "你的电子邮件地址已经加入监控此跟踪的列表",
"Cancel monitoring" => "取消监控",
"Your email address has been removed from the list of addresses monitoring this item" => "你的电子邮件地址已经从监控此项目的列表中移除",
"Your email address has been added to the list of addresses monitoring this item" => "你的电子邮件地址已经加入监控此项目的列表",
"ChinaTiki" => "Tikiwiki中国站",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
"UTC" => "UTC",
"If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
"pop" => "pop",
"new image uploaded by" => "新图像上传自",
"new subscriptions" => "新订阅",
"new item in tracker" => "跟踪中有新项目",
"message" => "消息",
"Include an article" => "插入一篇文章",
"filter" => "过滤器",
"no such file" => "无此文件",
"Can browse categories" => "可浏览类别",
"downloads" => "下传数",
"download" => "下载",
"attach" => "附件",
"monitor this blog" => "监控此博客",
"hide categories" => "隐藏类别",
"Admin categories" => "管理类别",
"browse category" => "浏览类别目录",
"reply" => "回复",
"monitor this topic" => "监控此主题",
"with checked" => "被选中的",
"Dls" => "下载数",
"move selected files" => "移动所选的文件",
"Thank you for you registration. You may log in now." => "感谢你的注册. 你现在可登录了.",
"compare" => "比较",
"diff" => "比对差异",
"Click the :: options in the Menu for more options." => "点options您可以在菜单里找到更多选项.",
"Please, also see" => "也请参考",
"for more setup details." => "更多安装详细说明.",
"Note 1:" => "说明 1:",
"You can remove this module in" => "您可以取消或者",
"as well as assign or edit many others." => "指定某个或者多个模块.",
"Note 2:" => "说明 2:",
"The menu module installed by default is named" => "模块使用安装时的初始名称",
"it is a \"custom module\" which includes menu ID " => "他是\"custom module\" 包含了菜单ID ",
"That menu is stored in database and it can be edited from " => "菜单被保存在数据库中并且可以被编辑 ",
"Do not mix this with the original <em>application_menu</em> module" => "请不要把这个与 <em>application_menu</em> 模块混淆",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "前者可以根据风格和需求的不同任意编辑，而后者则必须在mod-application_menu.tpl中手动编辑 ",
"del" => "清除",
"Create pdf" => "创建 pdf",
"pdf" => "创建pdf",
"1 file attached" => "1个附加文件",
"categories" => "类别",
"by creator" => "创建者",
"by modificator" => "修改者",
"at tracker" => "在跟踪",
"check / uncheck all" => "全选/全取消",
"Tiki sections and features" => "Tiki 分区和功能",
"tikiwiki.org help" => "tikiwiki.org上的帮助",
"Site Logo and Identity" => "网站徽标和标识",
"please read" => "请阅读",
"yes" => "是",
"Click here for more details." => "点击这里看更多细节。",
"Users &amp; groups" => "用户 &amp; 用户组",
"private" => "私人",
"<b>Item</b>" => "<b>条目</b>",
"<b>Value</b>" => "<b>值</b>",
"<b>Feed</b>" => "<b>聚合</b>",
"<b>enable/disable</b>" => "<b>启用/停用</b>",
"<b>Max number of items</b>" => "<b>最大条目数</b>",
"Feed for Articles" => "文章聚合",
"Feed for Weblogs" => "博客聚合",
"Feed for Image Galleries" => "图像画廊聚合",
"Feed for File Galleries" => "下载中心聚合",
"Feed for the Wiki" => "Wiki聚合",
"Feed for individual Image Galleries" => "单个图像画廊聚合",
"Feed for individual File Galleries" => "单个下载中心聚合",
"Feed for individual weblogs" => "单个博客聚合",
"Feed for individual forums" => "单个论坛聚合",
"Feed for mapfiles" => "应用到地图文件",
"Feed for directories" => "应用到网站目录",
"Change style only" => "只更改样式",
"PDF generation" => "生成PDF",
"Use in CMS" => "使用于内容管理",
"Use in Wiki" => "使用于Wiki文档",
"Use in newsletters" => "使用于电子期刊",
"Use in HTML pages" => "使用于 HTML 页面",
"Edit Existing Forums" => "编辑已有论坛",
"Refresh rate (if dynamic) [secs]" => "更新频率 (如果为动态) [秒]",
"configure repositories" => "配置储藏",
"configure this repository" => "配置这个储藏",
"copy rules" => "复制规则",
"Create/edit newsletters" => "创建/编辑电子期刊",
"subscriptions" => "订阅",
"Use Admin Email" => "使用管理员电子邮件",
"Edit or add poll options" => "编辑或加入投票选项",
"Create/edit Polls" => "创建/编辑 投票",
"Rss channels" => "Rss频道",
"show pubdate" => "发表日期",
"activate" => "活跃",
"Admin tracker" => "管理跟踪",
"Edit this tracker" => "编辑此跟踪",
"View this tracker items" => "浏览此跟踪项目",
"Edit tracker fields" => "编辑跟踪列",
"Create trackers" => "创建跟踪器",
"Import/export" => "导入/导出",
"fields" => "域",
"Create/edit trackers" => "创建/编辑跟踪",
"Add a new group" => "增加新用户组",
"Edit item" => "编辑项目",
"Add a new user" => "增加用户",
"Popup Window" => "弹出窗口",
"details" => "细节",
"No individual permissions global permissions apply" => "不采用单独的权限设置,采用全体权限设置",
"Welcome to the Tiki Chat Rooms" => "欢迎来到Tiki聊天室",
"Please select a chat channel" => "请选择一个聊天频道",
"enter chat room" => "进入聊天室",
"There are no channels setup, please contact a site admin" => "尚没有创建频道，请联系网站管理员",
"Chatroom" => "聊天室",
"Active Channels" => "频道",
"Users in this channel" => "频道中的用户",
"Channel Information" => "频道信息",
"Channel" => "频道",
"Ratio" => "比率",
"Use :nickname:message for private messages" => "用 “:昵称:消息” 来发送个人消息",
"Use [URL|description] or [URL] for links" => "使用 [URL|描述] 或 [URL] 表示链接",
"Create PDF" => "创建 PDF",
"PDF Settings" => "PDF设置",
"Select Wiki Pages" => "选择Wiki页面",
"Remove Page" => "移除页面",
"Add or edit a site" => "增加或编辑站点",
"sites" => "站点",
"cool sites" => "酷站点",
"Use ...page... to separate pages in a multi-page article" => "使用 ...page... 将页面分隔为多重页面",
"Create Zone" => "创建区域",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "用中括弧表示外部链接：[URL] 或者 [URL|链接描述] 或者 [URL|链接描述|nocache]  (最后的那个格式用于防止来自缓存这个页面的本地Wiki文档；对大网页请使用这种格式!).",
"browse image" => "浏览图像",
"translate" => "翻译",
"Create or edit content" => "创建或编辑內容",
"this quiz stats" => "这个小测验的统计",
"answer" => "答案",
"Set of Translations" => "翻译设置",
"graph" => "图表",
"Edit FAQ questions" => "编辑FAQ问题",
"Edit this file gallery:" => "编辑此下载中心:",
"icon" => "图标",
"Other users can upload files to this gallery" => "允许其他用户上传文件到此文件库",
"Available File Galleries" => "现有下载中心",
"start" => "开始",
"end" => "结束",
"roles" => "角色",
"Add role" => "添加角色",
"active process" => "活动流程",
"invalid" => "无效的",
"invalid process" => "无效的流程",
"valid process" => "有效的流程",
"activities" => "活动节点",
"aborted" => "放弃",
"value" => "值",
"proc" => "流程",
"exceptions" => "异常",
"Please enter your database connection info" => "请输入您的数据库信息",
"The type of database you intend to use" => "您想使用的数据库类型",
"Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "数据库服务所在的主机名或者IP地址, 例如，在本地运行Tiki则输入localhost",
"If you use SQLite, insert the path and filename to your database file" => "如果你使用SQLite,请输入数据库文件夹名称",
"Database password" => "数据库密码",
"The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "数据库名即将要创建tiki数据库表的地方。你可以使用mysqladmin或者phpmyadmin，或者咨询你的主机服务商来创建一个数据库。通常情况下，请不要将Tiki与其他数据库混用",
"Welcome to the installation &amp; upgrade script!" => "欢迎使用安装 &amp; 升级程序!",
"Create database (clean install) with profile" => "创建数据库（干净安装,有描述）",
"Descriptions of the available profiles" => "可用描述",
"backup your database" => "备份你的数据库",
"with mysqldump or phpmyadmin before you proceed" => "开始前，请准备使用mysqldump或者phpmyadmin",
"For database update from 1.8 or later" => "升级1.8或者以后版本的数据库",
"If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "如果你是从1.8.x升级，请<b>务必</b>运行 tiki_1.8to1.9。其他的不需要运行",
"If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "如果你是从较早的1.9.x升级, 请同样使用tiki_1.8to1.9,(例如: 从1.9.2到1.9.5)",
"For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "如果从1.7.x升级, 请访问<a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
"For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "了解关于tiki-secdb_*.sql 文件, 请访问<a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
"Please enter your admin password to continue" => "请输入你的admin密码后继续",
"Print operations executed successfully" => "打印成功的操作",
"Print operations failed" => "打印失败的操作",
"Your database has been configured and Tikiwiki is ready to run! If\n    \t\tthis is your first install, your admin password is 'admin'. You can\n    \t\tnow log in into Tikiwiki as user 'admin' and start configuring\n    \t\tthe application." => " 你的数据库色配置成功，Tikiwiki可以正常运行。 如果\n    \t\\这是第一次安装, 你的初始管理密码是'admin'. 你可以\n    \t\\使用用户名'admin'登陆开始配置程序.",
"READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "开始使用Tiki前，请仔细阅读下面的说明",
"Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "请务必保证Tiki能够至少使用8MB的内存来运行程序. \n请查看php.ini中关于memory_limit的信息. 最好使用memory_limit = 16M，然后重启 \n你的浏览器.过小的内存设置会导致空白页发生！",
"If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "如果这是你全新安装，请运行tiki-admin.php登陆后配置你的Tiki程序",
"If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "如果你是升级了Tiki, 请务必手动清空caches (templates_c/)，或者直接使用admin / system中的功能进行清理",
"Now you may proceed by clicking one of these links" => "现在你可以点下面的连接继续",
"Click here to disable the install script and proceed into tiki" => "点这里禁用安装文本，并进入tiki",
"Click here to proceed into tiki without disabling the script" => "点这里不禁用安装文本，并进入tiki",
"do not use your Back button in your browser!" => "请不要使用浏览器的后退按钮",
"rollback" => "复原",
"Create or edit content block" => "创建或编辑內容模块",
"Listing Gallery" => "列出文件库",
"Gallery Files" => "库内文件",
"Last ver" => "最近版本",
"Com" => "评论",
"Vers" => "版本",
"Subscribe to newsletter" => "订阅电子期刊",
"Add or edit a news server" => "增加或编辑新闻服务器",
"Print Wiki Pages" => "打印Wiki页面",
"add page" => "增加页面",
"click to navigate" => "点击导览",
"Total threads" => "总讨论串数",
"Average threads per topic" => "主题平均讨论串数",
"You can include the file in an HTML/Tiki page using" => "你可包含这个文件在一个 HTML/Tiki 页面中使用",
"Now enter the file URL" => "输入这个文件的URL",
" or upload a local file from your disk" => "或从你的磁盘上传一个本地的文件",
"Add or edit folder" => "增加或编辑文件夹",
"Add or edit a URL" => "增加或编辑一个URL",
"priority" => "优先级",
"previous chart" => "上一排行榜",
"next chart" => "下一张排行榜",
"pos" => "排名",
"pre" => "上一",
"avg" => "平均",
"post new comment" => "发表新评论",
"Post New Comment" => "发表新评论",
"HTML tags are not allowed inside comments" => "不允许评论中使用 HTML 标签",
"moderator actions" => "版主命令",
"move selected topics" => "移动选择的主题",
"unlock selected topics" => "解锁选择的主题",
"lock selected topics" => "锁定选择的主题",
"merge" => "合并",
"merge selected topics" => "合并选择的主题",
"reported messages:" => "报告的消息:",
"queued messages:" => "队列中消息:",
"emot" => "表情",
"View item" => "查看项目",
"Add a comment" => "增加一个评论",
"account" => "账号",
"Group doesnt exist" => "用户组不存在",
"User doesnt exist" => "用户不存在",
"Event without Name" => "无名事件",
"Invalid old password" => "旧密码错误",
"No channel indicated" => "未指定频道",
"No nickname indicated" => "未指定昵称",
"I have refused your friendship request!" => "我已经拒绝了你的交友请求！",
"Permision denied" => "权限不足",
"sender" => "寄件者",
"subject" => "主题",
"date" => "日期",
"flagged" => "已标记",
"mark" => "标计",
"Click" => "点击",
"posted by" => "发表者",
"email this post" => "将此帖子电邮",
"Anonymous editors must input anti-bot code" => "匿名编辑者必须输入anti-bot代码",
"Edit idle timeout" => "编辑空闲超时",
"Use page description" => "使用页面描述",
"Show page title" => "显示页面标题",
"Users can lock pages (if perm)" => "允许用户锁定页面 (如果有权限)",
"Use WikiWords" => "使用Wiki词汇",
"Use Wiki paragraph formatting" => "使用Wiki段落格式",
"Use external link icons" => "使用外部链接图标",
"Maximum number of versions for history" => "历史记录中版本最大数目",
"Never delete versions younger than days" => "永不刪除少于几天的版本",
"Old vers" => "旧版本",
"Add or edit event" => "创建或编辑事件",
"merge selected notes into" => "合并选择的记事到",
"Faq Stats" => "FAQ统计",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "你的消息已排入等待审核, 版主许可之后\n就会发布.",
"settings" => "设置",
"mailbox" => "邮件夹",
"compose" => "新邮件",
"contacts" => "通讯录",
"clip" => "徊形针",
"back to mailbox" => "返回邮件夹",
"full headers" => "完整标头",
"normal headers" => "一般标头",
"reply all" => "全部回复",
"forward" => "转寄",
"select from address book" => "从通讯录中选择",
"cc" => "抄送",
"new sites" => "新站点",
"database queries used" => "次数据查询",
"{\$atts_cnt} files attached" => "{\$atts_cnt} 个附加文件",
"pass" => "密码",
"Page generated in" => "生成本页耗时",
"sent" => "已发送",
"Homework" => "家庭作业",
"Favorites" => "收藏夹",
"Member list" => "成员列表",
"Back to Homepage" => "回到主页",
"Minor" => "次要",
"Translate in" => "翻译为",
"Welcome to" => "欢迎来到",
"Content Features" => "內容特性",
"Contact Us (Anonymous)" => "联系我们（匿名用户）",
"Prevent automatic/robot registration" => "防止自动/机器人注册",
"Create/edit Calendars" => "创建/编辑日程表",
"charts" => "排行榜",
"Admin Charts Template" => "管理排行榜模板",
"Chat Administration" => "聊天管理",
"Create/edit channel" => "创建/编辑 频道",
"Half a second" => "半秒",
"second" => "秒",
"Chat channels" => "聊天频道",
"Admin Forums Template" => "管理论坛模板",
"Admin Featured Links" => "管理推荐链接",
"Admin Featured Links Template" => "管理推荐链接模板",
"Admin Webmail" => "管理webmail",
"Admin Mailing Template" => "管理内置邮件账号模板",
"Admin Menu Builder" => "管理菜单构建器",
"Admin Menus Template" => "管理菜单模板",
"Admin Modules Template" => "创建版块模板",
"Assign Module" => "指定版块",
"subscribed" => "订阅",
"Score System" => "积分系统",
"Edit survey questions" => "编辑调查问题",
"Admin Tracker" => "管理跟踪",
"Again" => "再次输入",
"Assign permissions to group" => "指定权限给用户组",
"Browsing Gallery" => "浏览库",
"Edit Blog Tpl" => "编辑博客模板",
"Show Plugins Help" => "显示外挂模块说明",
"Show Text Formatting Rules" => "显示文本格式化规则",
"Program dynamic content for block" => "设计模块的动态內容",
"Admin quizzes" => "管理小测验",
"Message queue for" => "消息队列",
"back to forum" => "回到论坛",
"Reported messages for" => "报告消息",
"Update database using script" => "文本模式升级数据库",
"hist" => "历史",
"back to admin" => "回到管理界面",
"Subscribe to This Newsletter" => "订阅",
"Stats for quiz" => "小测验统计",
"Received Articles" => "收到的文章",
"Rename page" => "页面更名",
"to_version" => "到版本",
"Stats for survey" => "调查结果",
"system logs" => "系统日志",
"system logs tpl" => "系统日志模板",
"Theme Control Center: categories" => "布景主题控制台: 类别",
"Theme Control Center: sections" => "布景主题控制台: 版块",
"File Title" => "文件标题",
"IRC log" => "IRC 记录",
"Add new mail account" => "增加新的邮件账号",
"User accounts" => "用户账号",
"View All" => "查看全部",
"Msg" => "消息",
"Permission denied you cannot remove pages" => "权限不足, 你无法移除页面",
"Newsletter subscription information at " => "Newsletter subscription information at ",
"Cannot write to this file" => "无法写入此文件",
"Missing title or body when trying to post a comment" => "标题或正文在发表评论时必须填写",
"\\n for rows" => "\\n 表示一行",
"categorize this object" => "分类这个对象",
"Your account request have been stored and will be activated by the admin as soon as possible." => "您的账户请求已经储存，管理员将尽快通过您的请求",
"Syntax highlighting" => "语法强调",
"MyTiki Home" => "我的Tiki主页",
"My Files" => "我的文件",
"Mini calendar" => "迷你日程表",
"User list" => "用户列表",
"Dump" => "卸出",
"Send Pages" => "发送页面",
"Received pages" => "收到的页面",
"Admin Posts" => "管理帖子",
"Submit a New Link" => "提交新链接",
"Browse directory" => "浏览网站目录",
"Admin Directory" => "管理网站目录",
"List quizzes" => "列出小测验",
"List trackers" => "列出跟踪",
"Ephemerides Admin" => "日程表管理",
"Charts Admin" => "排行榜管理",
"Debugger console" => "调试控制台",
"I forgot my pass" => "忘记密码",
"Send trackback pings to:" => "发送跟踪反馈到:",
"(comma separated list of URIs)" => "(用逗号,分隔的 URIs 列表)",
"This is" => "这是",
"by the" => "由",
"User identity features" => "用户自定义功能",
"Use URI as Home Page" => "使用 URI 当主页",
"OS" => "操作系统",
"Disallow access to the site (except for those with permission)" => "不允许存取这个网站(除非有相应权限)",
"Message to display when site is closed" => "当这个网站关闭时显示信息",
"Disallow access when load is above the threshold (except for those with permission)" => "当超过最大吞吐量不允许存取(除非有相应权限)",
"Max average server load threshold in the last minute" => "最近一分钟的最大服务器吞吐量",
"Message to display when server is too busy" => "当服务器太忙时显示的信息",
"Use cache for external images" => "缓存外部图像",
"Use gzipped output" => "使用 gzip 压缩输出",
"Sender Email" => "发送人电子邮箱",
"Allow anonymous users to \"Contact Us\"" => "允许匿名用户使用［联系我们］",
"contact feature disabled" => "联络特性已关闭",
"Session lifetime in minutes" => "Session 的生命周期为几分钟",
"Proxy Host" => "代理主机",
"User registration and login" => "用户注册与登录",
"Use WebServer authentication for Tiki" => "Tiki使用Web服务器提供的认证服务",
"... but need admin validation" => "... 但需要管理员验证",
"Use tracker for more user information" => "为获得更多用户信息使用跟踪器",
"Use tracker for more group information" => "为获得更多群组信息使用跟踪器",
"Request passcode to register" => "须用通过码才能注册",
"Validate users by email" => "用电子邮件确认用户",
"Store plaintext passwords" => "保存明文密码",
"Reg users can change password" => "用户可以更改密码",
"Reg users can change language" => "允许注册用户更改语言",
"Restrict available languages" => "限制有效语言",
"Available languages:" => "可用语言:",
"Force to use chars and nums in passwords" => "强制在密码中使用字符和数字",
"Minimum password length" => "最小密码长度",
"Password invalid after days" => "密码在几天后到期",
"Remember me feature" => "记忆登录特性",
"Remember me name" => "记住我名字",
"Remember me domain" => "记住我的主域",
"Remember me path" => "记住我的路径",
"Protect against CSRF with a confirmation step" => "用确认步骤提供SRF保护",
"Create user if not in Tiki?" => "如果Tiki中无用户则创建账号?",
"Create user if not in Auth?" => "如果 Auth 中无用户则创建账号?",
"Just use Tiki auth for admin?" => "仅 admin 账号使用 Tiki 认证?",
"LDAP Host" => "LDAP 主机",
"LDAP Port" => "LDAP 端口",
"LDAP Scope" => "LDAP 范围",
"LDAP Base DN" => "LDAP 主 DN",
"LDAP User DN" => "LDAP 用户 DN",
"LDAP User Attribute" => "LDAP 用户属性",
"LDAP User OC" => "LDAP 用户 OC",
"LDAP Group DN" => "LDAP 用户组 DN",
"LDAP Group Attribute" => "LDAP群组属性",
"LDAP Group OC" => "LDAP 用户组 OC",
"LDAP Member Attribute" => "LDAP 成员属性",
"LDAP Member Is DN" => "LDAP 成员是 DN",
"LDAP Admin User" => "LDAP 管理员",
"LDAP Admin Pwd" => "LDAP 管理员密码",
"CAS server hostname" => "CAS服务器主机名",
"CAS server port" => "CAS服务器端口",
"CAS server path" => "CAS服务器路径",
"Change CAS preferences" => "改变CAS偏好",
"Meta Keywords" => "元关键词",
"Meta Description" => "元描述",
"Meta Author" => "元作者",
"meta robots" => "元机器人",
"revisit after" => "之后重访",
"Allow Smileys" => "允许表情符号",
"Hotwords in New Windows" => "以新窗口显示热词",
"restore" => "恢复",
"Wiki Home Page" => "Wiki主页",
"Wiki Discussion" => "Wiki讨论",
"Wiki Link Format" => "Wiki文档链接的格式",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "用两个圆括弧的Wiki链接语法子为Wiki链接的识别控制：((页面名称))",
"Wiki Features" => "Wiki特性",
"Wiki History" => "Wiki历史",
"Wiki Watch" => "Wiki文档监视",
"Admin Charts" => "管理排行榜",
"Add new rule" => "增加新规则",
"EMail notifications" => "邮件通知",
"Edit this RSS module:" => "编辑这个 RSS 版块:",
"Create new RSS module" => "创建新 RSS 版块",
"Create/edit questions for survey" => "创建/编辑调查的问题",
"Active?" => "启用中?",
"Create Trackers" => "创建跟踪器",
"Create/Edit Trackers" => "创建/编辑跟踪",
"Delete this type" => "刪除这个类型",
"Browse gallery" => "浏览库",
"Upload from disk" => "从磁盘上传",
"Browsing Image" => "浏览图像",
"Again please" => "请再输入一次",
"Admin category relationships" => "管理类别关系",
"Validate links" => "确认链接",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "文件名附加有 -{\$user} 的可修改, 其他只能做为样本复制",
"Im- Export Languages" => "导入- 导出语言",
"MultiTiki setup" => "多Tiki站点设置",
"To add a new virtual host" => "添加一个新的主机",
"Database name" => "数据库名",
"Do nothing and enter Tiki" => "直接进入Tiki",
"Reset database connection settings" => "重置数据库连接设置",
"Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki没有检测到你的PHP memory_limit. 可能你没有设置这个限制",
"Create a file gallery" => "创建下载中心",
"Support tickets" => "支持标签",
"Return to HomePage" => "返回主页",
"Stats for this survey Questions " => "关于这个调查问题的统计",
"SysLog" => "系统日志",
"Batch upload" => "批次上传",
"1 suggestion" => "一个建议",
"suggestions" => "建议",
"Minor Edit" => "次要",
"You can not download files" => "你无法下传文件",
"Please wait 2 minutes between posts" => "请间隔两分钟再发表帖子",
"The text in RED is" => "红色的文本是",
"Show Categories" => "显示类别",
"Hide Categories" => "隐藏类别",
"Blog features" => "博客特性",
"Blog level comments" => "博客水平评论",
"Post level comments" => "帖子水平评论",
"Spellchecking" => "拼写检查",
"Default ordering for blog listing" => "博客列表默认顺序",
"Blog listing configuration (when listing available blogs)" => "博客列表配置 (列出现有博客时)",
"Last modification time" => "最后修改时间",
"Blog comments settings" => "博客评论设置",
"Show Category Path" => "显示类别路径",
"Show Category Objects" => "显示类别对象",
"CMS features" => "内容管理特性",
"Use templates" => "使用模板",
"Maximum number of articles in home" => "主页最大文章数",
"Article comments settings" => "文章评论设置",
"Fields to display on page" => "显示在页面的域",
"Expire Date" => "过期时间",
"Copyright Management" => "版权管理",
"License Page" => "授权页面",
"Submit Notice" => "提交时提示",
"Uploaded filenames cannot match regex" => "上传文件名称不得符合正则表示式",
"File galleries comments settings" => "下载中心评论设置",
"File galleries search indexing" => "下载中心搜索索引",
"Enable auto indexing on file upload or change" => "启动自动索引被上传和更改的文件",
"Forum quick jumps" => "快速跳转",
"Ordering for forums in the forum listing" => "在论坛列表中论坛的顺序",
"Forum listing configuration" => "论坛列表配置",
"Show Babelfish Translation URLs" => "显示 Babelfish 翻译网站的链接",
"Show Babelfish Translation Logo" => "显示 Babelfish 翻译网站的徽标",
"Show Module Controls" => "显示版块控制",
"Users can Configure Modules" => "用户可配置版块",
"Allow Anonymous Poll Voting" => "允许匿名用户投票",
"Performance issues" => "性能问题",
"Search features" => "搜索特性",
"SearchStats" => "搜索状态",
"Settings for searching content" => "搜索内容设置",
"Search refresh rate" => "搜索刷新率",
"this survey stats" => "这次调查结果",
"bold" => "粗体",
"italic" => "斜体",
"underline" => "底线",
"hr" => "水平线",
"You have {\$unread} unread private messages" => "你有 {\$unread} 条未读私人短消息",
"unread private messages" => "未读私人消息",
"you or someone registered this email address at" => "你或是某位注册此电子邮件地址的人",
"Your Tiki information registration" => "您登记的Tiki信息",
"Your registration" => "您登记的Tiki信息",
"left/right" => "左/右",
"home" => "主页",
"chat" => "聊天",
"contact us" => "联络我们",
"debugger console" => "除错器控制台",
"MyMenu" => "我的菜单",
"User menu" => "用户菜单",
"WfMenu" => "Wiki文档菜单",
"WikiMenu" => "Wiki文档菜单",
"dump" => "卸出",
"rankings" => "排名",
"orphan pages" => "单独页面",
"sandbox" => "涂鸦板",
"received pages" => "收到的页面",
"structures" => "导航结构",
"GalMenu" => "文件库菜单",
"Articles Home" => "文集主页",
"Send articles" => "发送文章",
"Create/Edit Blog" => "创建博客",
"ForMenu" => "论坛菜单",
"DirMenu" => "目录菜单",
"Browse Directory" => "浏览网站目录",
"FileGalMenu" => "文件库菜单",
"Admin FAQs" => "FAQs管理",
"Edit mapfiles" => "编辑地图文件",
"QuizMenu" => "小测验菜单",
"Admin quiz" => "管理小测验",
"TrkMenu" => "跟踪菜单",
"Admin trackers" => "管理跟踪",
"SrvMenu" => "调查菜单",
"Send newsletters" => "发送电子期刊",
"EphMenu" => "日程表菜单",
"Ephemerides" => "日程表",
"ChartMenu" => "聊天菜单",
"AdmMenu" => "管理菜单",
"Admin home" => "Admin首页",
"Backups" => "系统备份",
"Edit languages" => "编辑语言",
"External wikis" => "外部Wiki",
"UsrMenu" => "用户菜单",
"Click here to manage your personal menu" => "点击这里管理你的个人菜单",
"Quick edit a Wiki page" => "快速编辑Wiki页面",
"Language: " => "语言： ",
"Sort posts by:" => "排序帖子依据:",
"read more" => "详细阅读",
"Tiki has detected your PHP memory_limit at" => "Tiki检测到你的PHP memory_limit设置是",
"Tiki cannot find a database connection" => "Tiki无法连接数据库",
"Database type" => "数据库类型",
"This site has an admin account configured" => "这个网站已经有admin设置",
"Pass" => "密码",
"Go back and run another install/upgrade script" => "返回，安装/升级另外一个Tiki",
"System Admin" => "系统管理",
"Displays an miniquiz" => "显示一个小测验",
"some text" => "某些文本",
"Creates a box with the data" => "用数据创建一个盒子",
"creates a title bar" => "生成标题列",
"creates a table" => "生成表格",
"makes a horizontal rule" => "表示水平线，",
"page|desc" => "页面|描述",
"displays an image" => "显示图像",
"Non cacheable images" => "无可缓存的图像",
"height width desc link and align are optional" => "高度与宽度的描述以及链接以及对齐方式都是可选项",
"displays rss feed with id=n maximum=m items" => "显示RSS聚合的 id=n maximum=m 项数",
"Will be replaced by the actual value of the dynamic content block with id=n" => "将会用 id=n 的动态內容模块实际值来取代",
"Misc" => "杂项",
"Unix" => "Unix",
"Windows" => "Windows",
"PEAR::Auth" => "PEAR::Auth",
"If:SetNextact" => "If:SetNextact",
"int" => "int",
"This instance of activity is already complete" => "该活动实例已经完成",
"Fatal error: cannot execute automatic activity \$activityId" => "致命错误：不能执行自动活动 \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "致命错误：设置了一个不存在的节点为下一个节点",
"Cannot add transition only split activities can have more than one outbound transition" => "不能仅仅通过分离具有超过一个外向过渡的活动来增加过渡活动",
"Circular reference found some activity has a transition leading to itself" => "在一些有自导过渡的活动中发现循环参考",
"Process does not have exactly one end activity" => "过程没有确切的结束活动",
"End activity is not reachable from start activity" => "从开始活动不能到达结束活动",
"is interactive but has no role assigned" => "是交互活动，但没有指定角色。",
"is non-interactive and non-autorouted but has no role assigned" => "是非交互和非自动发送的活动，但没有指定角色。",
"is standalone but has transitions" => "是独立活动，但有过渡活动",
"Role" => "角色",
"is not mapped" => "没有映射",
"Process %d has been activated" => "过程 %d 已经激活",
"Process %d has been deactivated" => "过程 %d 已经不活动",
"Process %s %s imported" => "过程 %s %s 导出了",
"Process %s removed" => "过程 %s 移除了",
"Process %s has been updated" => "过程 %s 已经更新",
"Process %s has been created" => "过程 %s 已经创建",
"<return> for rows" => "\n 表示行",
"Report all errors except notices" => "报告所有错误除了注意",
"1 day" => "2天",
"1 week" => "2周",
"1 month" => "2个月",
"Just Tiki" => "仅Tiki",
"Tiki and PEAR::Auth" => "Tiki 与 PEAR::Auth",
"Charts" => "排行榜",
"Forums last topics" => "最近论坛主题",
"games" => "游戏",
"Insert a division block on wiki page" => "在插入Wiki页面插入独立的一个版块",
"drawing not found" => "找不到绘图",
"heads and cells separated by ~|~" => "用~|~分隔头和单元。",
"Autovalidate suggestions" => "自动验证建议",
"Can abort a process instance" => "可中断处理的实例",
"Can admin charts" => "可管理排行榜",
"Can admin drawings" => "可管理绘图",
"Can admin games" => "可管理游戏",
"Can admin workflow processes" => "可管理工作流程过程",
"Can declare an instance as exception" => "可声明例外的实例",
"Can edit drawings" => "可编辑绘图",
"Can execute workflow activities" => "可执行工作流程活动",
"Can play games" => "可玩游戏",
"Can send instances after completion" => "完成之后可发送实例",
"Can suggest items" => "可建议条目",
"Can use the newsreader" => "可使用新闻阅读器",
"Can view charts" => "可查看排行榜",
"Can vote" => "可投票",
"Quicktags" => "快捷标记",
"Listing configuration" => "列表配置",
"Tiki User Account Activated" => "Tiki用户已经激活",
"Tiki email notification" => "Tiki电子邮件通知",
"QuickTags" => "快捷标记",
"TikiWiki Assistant" => "Tikiwiki助手",
"Recently visited pages" => "最近访问页面",
"Last Sites" => "最新加入目录站点",
"Directory Stats" => "网站目录统计",
"Sites to validate" => "待确认的站点",
"Visited links" => "已访问链接",
"Top Sites" => "热门站点",
"Last articles" => "最近文集文章",
"Last galleries" => "最近加入文件库",
"Menu" => "菜单",
"New Messages" => "条新消息",
"New Message" => "条新消息",
"Top games" => "热门游戏",
"Whats related" => "相关信息",
"show structures" => "显示导航结构",
"hide structures" => "隐藏导航结构",
"Creation date" => "创建日期",
"My workflow" => "我的工作流程",
"Number of columns per page when listing categories" => "当列出类别时每页列数",
"Featured Help" => "主打说明",
"JsCalendar" => "JS日程表",
"PhpLayers Dynamic menus" => "PHP层动态菜单",
"Tiki Sheet" => "Tiki工作表",
"Drawings" => "绘图",
"Games" => "游戏",
"Administration Features" => "管理功能",
"Banning System" => "禁用系统",
"User Features" => "我的特性",
"Newsreader" => "新闻阅读器",
"Workflow" => "工作流",
"Workflow engine" => "工作流引擎",
"Unknown/Other" => "未知/其他",
"Tikiwiki.org help" => "Tikiwiki.org 帮助",
"Store session data in database" => "用数据库储存Session数据",
"Long date format" => "长日期格式",
"Short date format" => "短日期格式",
"Long time format" => "长时间格式",
"Short time format" => "短时间格式",
"New password" => "新密码",
"HTTP port" => "HTTP 端口",
"HTTPS port" => "HTTPS 端口",
"PAM service" => "PAM服务",
"CAS server version" => "CAS服务器版本",
"Reg users can change theme" => "允许注册用户更改布景",
"Slideshows theme" => "幻灯片主题",
"Site logo background color" => "网站徽标背景色",
"Site logo title (on mouse over)" => "网站徽标标题（鼠标滑过时）",
"Default RDF version" => "默认的 RDF 版本",
"Editor" => "编辑者",
"Webmaster" => "站长",
"hits" => "点击数",
"Individual cache" => "独立缓存",
"Perms inherited from closest parent if possible or from global perms" => "如果可能，从直接父节点或者全局权限继承权限",
"Assign permissions automatically" => "自动指定权限",
"recommended for best performance" => "推荐的最佳性能",
"image gal" => "图像画廊",
"file gal" => "下载中心",
"Admin chart items" => "管理排行榜项目",
"Edit Chart" => "编辑排行榜",
"Chart items" => "排行榜项目",
"No items defined yet" => "尚未定义项目",
"Add or edit a chart" => "增加或编辑排行榜",
"Users can vote for only one item from this chart per period" => "用户每一单位时间只能从这个排行榜中投票一项",
"Prevent users from voting for the same item more than once" => "防止用户对相同项目投票超过一次",
"Users can suggest new items" => "用户可建议新条目",
"Auto validate user suggestions" => "自动验证用户建议",
"Ranking shows" => "显示排行榜",
"All items" => "所有项目",
"Top 10 items" => "前 10 项",
"Top 20 items" => "前 20 项",
"Top 40 items" => "前 40 项",
"Top 50 items" => "前 50 项",
"Top 100 items" => "前 100 项",
"Top 250 items" => "前 250 项",
"Voting system" => "投票系统",
"Vote items" => "投票项目",
"Rank 1..5" => "排名 1..5",
"Rank 1..10" => "排名 1..10",
"Ranking frequency" => "排行榜频率",
"Realtime" => "即时",
"Each 5 minutes" => "每6分钟",
"Show Average" => "显示平均值",
"Show Votes" => "显示票数",
"Use Cookies for unregistered users" => "未注册用户使用 cookies",
"Users can vote again after" => "允许再次投票于",
"Anytime" => "随时",
"Ranks" => "排名",
"No charts defined yet" => "尚未定义排行榜",
"Admin drawings" => "绘图管理",
"Available drawings" => "现存绘图",
"Ver" => "版本",
"no display" => "不显示",
"Available polls" => "现有的投票",
"Random image from" => "随机图像来自",
"Dynamic content blocks" => "动态內容模块",
"phpLayersMenus" => "PHP层菜单",
"Banner zones" => "横幅区域",
"Admin Quicktags" => "管理快捷标记",
"Create/Edit QuickTags" => "创建/编辑快捷标记",
"Insert (use 'text' for figuring the selection)" => "插入(用'text'表示选定对象的外形)",
"Path to the tag icon" => "到这个标记的图标的路径",
"Admin RSS Modules" => "管理 RSS 版块",
"show feed title" => "显示应用者标题",
"show publish date" => "显示发表日期",
"Templates compiler" => "模板编译器",
"Compile" => "编译",
"Member of the default group of creator can modify items?" => "创建者默认群组的成员可否修改条目？",
"Rejected users" => "拒绝的用户",
"Default Group" => "默认用户组",
"Old password" => "旧密码",
"Parent category" => "父类别",
"Most visited sub-categories" => "最常访子类别",
"Category description" => "类别描述",
"Random sub-categories" => "随机子类别",
"Allow sites in this category" => "在这个类别可加入站点",
"Show number of sites in this category" => "在这个类别里允许显示站点",
"Subcategories" => "子类别",
"Admin related categories" => "管理相关类别",
"Add a related category" => "加入相关类别",
"Related categories" => "相关类别",
"in current category" => "在当前类别",
"Total categories" => "所有类别",
"creates the editable drawing foo" => "创建可编辑的暂时图像",
"table" => "表格",
"table new" => "新表格",
"external link" => "外部链接",
"wiki link'" => "Wiki连接",
"heading1" => "标题1",
"title bar" => "标题列",
"box" => "盒",
"rss feed" => "RSS聚合",
"dynamic content" => "动态內容",
"tagline" => "标记行",
"center text" => "置中文本",
"colored text" => "上色文本",
"dynamic variable" => "动态变量",
"quote" => "引用",
"special chars" => "特殊字符",
"special characters" => "特殊字符",
"Questions per page" => "每页问题数",
"Activity completed" => "活动完成",
"Admin process activities" => "管理过程活动",
"Add or edit an activity" => "增加或编辑活动",
"activity" => "活动",
"split" => "分支",
"join" => "合并",
"standalone" => "独立式",
"interactive" => "交互式",
"auto routed" => "自动路由",
"Add transitions" => "添加连接",
"Add transition from:" => "添加连接自:",
"Add transition to:" => "添加连接至:",
"No roles associated to this activity" => "没有与此活动相关的角色",
"Add Role" => "添加角色",
"Add New" => "新增加",
"Process activities" => "流程活动节点",
"Int" => "交互",
"Routing" => "路由路径",
"Interactive" => "交互式",
"Automatic" => "自动",
"Auto routed" => "自动路由",
"Manual" => "人工",
"inter" => "交互",
"route" => "路由",
"(no roles)" => "(无角色)",
"No activities defined yet" => "尚未定义活动节点",
"Process Transitions" => "流程连接",
"List of transitions" => "流程连接列表",
"Origin" => "原始",
"No transitions defined yet" => "尚未定义连接",
"Add a transition" => "添加一个连接",
"Edit Tpl" => "编辑模板",
"This process is invalid" => "这个流程是不合法的",
"List of processes" => "流程列表",
"Inactive" => "非活动",
"val" => "值",
"Active Process" => "活动流程",
"Invalid Process" => "无效的流程",
"Valid Process" => "有效的流程",
"Activities" => "活动",
"New Minor" => "新的次流程",
"New Major" => "新的主流程",
"No processes defined yet" => "尚未定义流程",
"Admin instance" => "管理流程实例",
"Process:" => "流程:",
"Instance" => "实例",
"Workitems" => "工作项目",
"exception" => "异常",
"completed" => "已完成",
"Send all to" => "全部发送到",
"Don't move" => "不要移动",
"Act status" => "活动状态",
"Property" => "属性",
"Add property" => "增加属性",
"run instance" => "运行实例",
"Admin processes" => "流程管理",
"Add or edit a process" => "添加或编辑流程",
"Process Name" => "流程名称",
"ver:" => "版本:",
"is active?" => "活动的?",
"Or upload a process using this form" => "或者通过这个表单上传流程",
"Admin process roles" => "管理流程角色",
"Add or edit a role" => "添加或编辑一个角色",
"Process roles" => "流程角色",
"No roles defined yet" => "尚未定义角色",
"Map users to roles" => "将用户映射到角色",
"map" => "映射表",
"Map groups to roles" => "映射群组到角色",
"Operation" => "操作",
"No roles are defined yet so no roles can be mapped" => "因为尚未定义角色，因此没有角色可以被映射",
"List of mappings" => "映射列表",
"No mappings defined yet" => "尚未定义映射表",
"Admin process sources" => "管理流程来源",
"select source" => "选择来源",
"Shared code" => "共享代码",
"Set next user" => "设置下一用户",
"Get property" => "获取属性",
"Set property" => "设置属性",
"Process form" => "流程表单",
"Set Next act" => "设置下个动作",
"Switch construct" => "分支结构",
"Map process roles" => "映射流程角色",
"Admin Processes" => "管理流程",
"Admin Activities" => "管理流程活动",
"Admin Roles" => "管理角色",
"Edit this Process" => "编辑这个流程",
"Monitor Activities" => "监控流程节点",
"List of activities" => "流程活动列表",
"Proc" => "流程",
"auto" => "自动",
"routing" => "路由",
"Instances" => "实例数",
"run" => "运行",
"run activity" => "执行活动",
"monitor processes" => "监控流程",
"monitor activities" => "监控活动节点",
"monitor instances" => "监控流程实例",
"monitor workitems" => "监控工作项目",
"Monitor Instances" => "监控流程实例",
"List of instances" => "流程实例列表",
"No instances created yet" => "实例尚未创建",
"Monitor Processes" => "流程监控",
"processes" => "流程",
"being run" => "即将执行",
"Exceptions" => "异常",
"Monitor workitems" => "监控工作项目",
"List of workitems" => "工作项目列表",
"instance" => "实例",
"exception instance" => "例外实例",
"exceptions instance" => "例外实例",
"Send Instance" => "发送实例",
"abort instance" => "中断实例",
"grab instance" => "抓取实例",
"release instance" => "释放实例",
"User Activities" => "用户活动",
"process" => "流程",
"user processes" => "用户流程",
"user activities" => "用户流程节点",
"user instances" => "用户实例",
"User Instances" => "用户实例",
"Inst Status" => "实例状态",
"No instances defined yet" => "尚未定义流程实例",
"User Processes" => "用户流程",
"Browsing Workitem" => "浏览工作项目",
"Workitem information" => "工作项目信息",
"Use cache for external pages" => "缓存外部页面",
"All games are from" => "所有游戏来自",
"visit the site for more games and fun" => "访问这个网站以取得更多游戏",
"Upload a game" => "上传一个游戏",
"Upload a new game" => "上传一个新游戏",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "缩略图 (如果game的名称为foo.swf 则缩略图必须命名为 foo.swf.gif 或 foo.swf.png 或 foo.swf.jpg)",
"Edit game" => "编辑游戏",
"Played" => "已玩",
"If you can't see the game then you need a flash plugin for your browser" => "如果你无法看到游戏那么你必须在你的浏览器中加入 flash 外挂模块",
"Accepted requests" => "已接受要求",
"since" => "自",
"Assigned items" => "指定项目",
"Select news group" => "选择新闻讨论组",
"Back to servers" => "返回服务器列表",
"Msgs" => "消息",
"Back to groups" => "回到用户组",
"Save position" => "保存位置",
"Reading article from" => "阅读文章由",
"Back to list of articles" => "返回文集列表",
"Newsgroup" => "新闻讨论组",
"Configure news servers" => "配置新闻服务器",
"Select a news server to browse" => "选择要浏览的新闻服务器",
"server" => "服务器",
"News server" => "新闻服务器",
"Current permissions for this object" => "此对象当前的权限",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "注意:请确认本站域名在你邮箱的白名单中，否则可能无法收到注册相关的邮件",
"Tiki Shoutbox" => "Tiki布告栏",
"Click to Navigate" => "点击导览",
"big grin" => "大笑",
"cry" => "哭脸",
"eek" => "惊恐",
"evil" => "发邪",
"lol" => "哈哈笑",
"mr green" => "发奋",
"razz" => "做鬼脸",
"redface" => "害羞",
"rolleyes" => "转眼睛",
"smile" => "微笑",
"surprised" => "惊奇",
"twisted" => "苦恼",
"arrow" => "箭头",
"Current folder" => "目标文件夹",
"Your personal Wiki Page" => "个人Wiki页面",
"Confirm new password" => "确认新密码",
"Current password (required)" => "当前密码（要求）",
"Edit Items" => "编辑项目",
"List Charts" => "列出排行榜",
"Last Chart" => "最末张排行榜",
"Previous Chart" => "上一排行榜",
"Chart created" => "排行榜已创建",
"Next Chart" => "下一张排行榜",
"Permanency" => "耐久度",
"chg" => "改变",
"Avg" => "平均",
"info/vote" => "信息/投票",
"Next chart will be generated on" => "下一排行榜将生成于",
"View or vote items not listed in the chart" => "查看或投票不列在排行榜中的项目",
"Select something to vote on" => "选择要投的项目",
"Item information" => "项目信息",
"Dif" => "差异",
"Best Position" => "最佳排名",
"Vote this item" => "票选此项目",
"Highest" => "最高",
"No chart indicated" => "未指定排行榜",
"No process indicated" => "未指定过程",
"Activity name already exists" => "活动名称已经存在",
"indicates if the process is active. Invalid processes cant be active" => "即使表明这个过程是活动的. 无效的过程不能备激活",
"No instance indicated" => "没有指定实例",
"No activity indicated" => "没有指定活动",
"The process name already exists" => "流程名已存在",
"Process already exists" => "流程已存在",
"You cant execute this activity" => "您不能执行该活动",
"The thumbnail name must be" => "缩略图的名称必须是",
"No server indicated" => "未指定服务器",
"Cannot connect to" => "无法连接到",
"Missing information to read news (server,port,username,password,group) required" => "缺少读取新闻所需信息(服务器,端口,用户名称,密码,用户组)",
"Cannot get messages" => "无法取得消息",
"Tiki Calendar" => "Tiki日程表",
"Admin Menu" => "菜单管理",
"RSS Modules" => "RSS模块",
"Chat" => "聊天管理",
"Import PHPWiki Dump" => "导入PHPWiki的卸出",
"Tiki Logo" => "Tiki徽标",
"Email This Post" => "将此帖子电邮",
"RSS feeds" => "RSS聚合",
"Use titles in blog posts" => "使用博客文章标题",
"Send blog post" => "发送博客帖子",
"A link to this post was sent to the following addresses:" => "已经发送一个到此帖子的链接到下列地址:",
"Send post to this addresses" => "发送帖子到此地址",
"List of email addresses separated by commas" => "电子邮箱地址列表, 由逗点分隔",
"Post recommendation at" => "发表建议于",
"Prevent flooding" => "防止灌水",
"Minimum time between posts" => "发表帖子的最小间隔时间",
"Moderator user" => "管理员账号",
"Moderator group" => "管理员用户组",
"Send this forums posts to this email" => "发送此论坛帖子到这个电子邮件",
"Prune unreplied messages after" => "刪去未回复的消息于",
"Prune old messages after" => "刪去旧消息于",
"POP3 server" => "POP4 服务器",
"Max attachment size (bytes)" => "最大附件大小 (字节)",
"Default ordering for topics" => "默认主题排列顺序",
"Topics per page" => "每页主题数",
"Default ordering for threads" => "默认讨论串排列顺序",
"Includes" => "包含",
"Assign permissions to category" => "给类别指定权限",
"Current permissions for this category" => "这个类别的权限",
"Assign permissions" => "指定权限",
"to group" => "给用户组",
"this category &amp; all its children" => "这个类别和它的全部下位类",
"this category only" => "仅这个类别",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "为最佳性能推荐指定权限给所有下位类",
"Your registration code:" => "您的注册码:",
"Registration code" => "注册码",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "For you to vote, cookies must be allowed" => "For you to vote, cookies must be allowed",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Copyright management" => "Copyright management",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Cayman Islands" => "Cayman Islands",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Cook Islands" => "Cook Islands",
// "Costa Rica" => "Costa Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "Netherlands Antilles" => "Netherlands Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Tuvalu" => "Tuvalu",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States" => "United States",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "Uruguay" => "Uruguay",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Line" => "Line",
// "Lines" => "Lines",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Link" => "Link",
// "Cannot open this file" => "Cannot open this file",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Title length" => "Title length",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and PAM" => "Tiki and PAM",
// "Tiki and LDAP" => "Tiki and LDAP",
// "Shibboleth" => "Shibboleth",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Faqs" => "Faqs",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Freetags" => "Freetags",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Contribution" => "Contribution",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Google Maps" => "Google Maps",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "HTML pages" => "HTML pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Intertiki" => "Intertiki",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Multilingual structures" => "Multilingual structures",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Search and replace" => "Search and replace",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Object type" => "Object type",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Headers Only" => "Headers Only",
// "Default sort mode" => "Default sort mode",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Bottom" => "Bottom",
// "Neither" => "Neither",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "After" => "After",
// "Before" => "Before",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can shade modules" => "Users can shade modules",
// "Always" => "Always",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "Page last modified on" => "Page last modified on",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Both" => "Both",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Load page on navigation" => "Load page on navigation",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "uploaded the file" => "uploaded the file",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "See other users' profiles" => "See other users' profiles",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other users' galleries" => "See other users' galleries",
// "See other users' images" => "See other users' images",
// "Have your gallery seen by other users" => "Have your gallery seen by other users",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other users' blogs" => "Read other users' blogs",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Directory category" => "Directory category",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "tip" => "tip",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "Your edit session will expire in" => "Your edit session will expire in",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Help page" => "Help page",
// "View tpl" => "View tpl",
// "Edit Template" => "Edit Template",
// "Admin Feature" => "Admin Feature",
// "The text is" => "The text is",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "Select All" => "Select All",
// "Invert Sort" => "Invert Sort",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "End date" => "End date",
// "Friend" => "Friend",
// "Gender" => "Gender",
// "km" => "km",
// "Last seen on" => "Last seen on",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "Table of contents" => "Table of contents",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "unknown error" => "unknown error",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Edit Plugin" => "Edit Plugin",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "Show" => "Show",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Create page" => "Create page",
// "Unknown language" => "Unknown language",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "View the tracker item at" => "View the tracker item at",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "numeric field" => "numeric field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "header" => "header",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor",
// "linktext" => "linktext",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Field" => "Field",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Incorrect param" => "Incorrect param",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Events" => "Events",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "cells" => "cells",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "failed" => "failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download" => "Download",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File not found" => "File not found",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Include a page" => "Include a page",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages" => "List wiki pages",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "complete" => "complete",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "%" => "%",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "No arguments indicated" => "No arguments indicated",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "Display" => "Display",
// "name|desc" => "name|desc",
// "Last modified by" => "Last modified by",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "Displays text between HTML tags" => "Displays text between HTML tags",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Reset" => "Reset",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "View" => "View",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Display List" => "Display List",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Table" => "Table",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Most popular tags" => "Most popular tags",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "My preferred tags" => "My preferred tags",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Last actions" => "Last actions",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "no object here yet" => "no object here yet",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "Last Images" => "Last Images",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Last modified events" => "Last modified events",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Last Visitors" => "Last Visitors",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Changes since" => "Changes since",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Top files" => "Top files",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Top Forum Posters" => "Top Forum Posters",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Top Objects" => "Top Objects",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Public tasks" => "Public tasks",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Top users" => "Top users",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Can admin contributions" => "Can admin contributions",
// "Can admin users" => "Can admin users",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view site templates" => "Can view site templates",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can admin freetags" => "Can admin freetags",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can browse freetags" => "Can browse freetags",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can list trackers" => "Can list trackers",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can watch structure" => "Can watch structure",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can admin public tasks" => "Can admin public tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can admin comments" => "Can admin comments",
// "Can admin content templates" => "Can admin content templates",
// "Can list registered users" => "Can list registered users",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "more info" => "more info",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Admin Categories" => "Admin Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Comments Locked" => "Comments Locked",
// "below your current threshold" => "below your current threshold",
// "Comments are locked" => "Comments are locked",
// "Editing reply" => "Editing reply",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "File gallery" => "File gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate permissions" => "Duplicate permissions",
// "View inserted gallery" => "View inserted gallery",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Display Properties" => "Display Properties",
// "Default sort order" => "Default sort order",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Please login" => "Please login",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Show an icon in a column" => "Show an icon in a column",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Go" => "Go",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Perform action with checked" => "Perform action with checked",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "New topic" => "New topic",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "New message arrived from %s" => "New message arrived from %s",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone" => "Someone",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "New" => "New",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "The new page content follows below" => "The new page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Zoom out" => "Zoom out",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Older Version" => "Older Version",
// "back to" => "back to",
// "Archive is full" => "Archive is full",
// "Confirmation" => "Confirmation",
// "Please Confirm" => "Please Confirm",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "Toggle Vertically" => "Toggle Vertically",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as admin" => "as admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Apply" => "Apply",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "year" => "year",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "click to view" => "click to view",
// "select" => "select",
// "Group information" => "Group information",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "on host" => "on host",
// "User does not accept messages" => "User does not accept messages",
// "Send a message" => "Send a message",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Send Newsletter" => "Send Newsletter",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Site Ads and Banners" => "Site Ads and Banners",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "i18n" => "i18n",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Security" => "Security",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "InterTiki" => "InterTiki",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "Day" => "Day",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Enable now" => "Enable now",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "never" => "never",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Home Gallery" => "Home Gallery",
// "No Gallery exists" => "No Gallery exists",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change configuration" => "Change configuration",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Wysiwyg" => "Wysiwyg",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "LDAP" => "LDAP",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "PAM" => "PAM",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "View Templates" => "View Templates",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Site title" => "Site title",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Menu ID" => "Menu ID",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom code" => "Custom code",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "always" => "always",
// "user decides" => "user decides",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Site location bar" => "Site location bar",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Larger font for" => "Larger font for",
// "Entire location" => "Entire location",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Email this page" => "Email this page",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Generate User Map" => "Generate User Map",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "Robots" => "Robots",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "Waiting" => "Waiting",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Documentation" => "Documentation",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Switch storage" => "Switch storage",
// "No records" => "No records",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Validate choice" => "Validate choice",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "List authors" => "List authors",
// "Allow override per page" => "Allow override per page",
// "Not Installed" => "Not Installed",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "Only with last version" => "Only with last version",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "Similar" => "Similar",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Change" => "Change",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look & feel" => "Look & feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "External Pages Cache" => "External Pages Cache",
// "External Wikis" => "External Wikis",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Search Stats" => "Search Stats",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Create New Forum" => "Create New Forum",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Posts can be rated" => "Posts can be rated",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate perms" => "Duplicate perms",
// "Duplicate" => "Duplicate",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "View source code after rules applied" => "View source code after rules applied",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "article-put" => "article-put",
// "Discard to the end from" => "Discard to the end from",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Active Permissions" => "Active Permissions",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Add email" => "Add email",
// "Add user" => "Add user",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Drafts" => "Drafts",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "XML Zip Import" => "XML Zip Import",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "View WebHelp" => "View WebHelp",
// "XML Zip" => "XML Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Closed" => "Closed",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Mandatory" => "Mandatory",
// "Searchable" => "Searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Hidden" => "Hidden",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Field is mandatory" => "Field is mandatory",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "with" => "with",
// "Edit Tracker" => "Edit Tracker",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Manage permissions" => "Manage permissions",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Edit group" => "Edit group",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members" => "Members",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Edit Account Settings" => "Edit Account Settings",
// "Registered" => "Registered",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Change user preferences" => "Change user preferences",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Invalid email" => "Invalid email",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "Edit user" => "Edit user",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Source" => "Source",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "Powered by" => "Powered by",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin the Category System" => "Admin the Category System",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "Directory Batch" => "Directory Batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "Edit Calendar" => "Edit Calendar",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "%m/%d" => "%m/%d",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Click here to send us an email" => "Click here to send us an email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Related directory categories" => "Related directory categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Total directory categories" => "Total directory categories",
// "List Articles" => "List Articles",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Passing Percentage" => "Passing Percentage",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "View object" => "View object",
// "Preview your changes" => "Preview your changes",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "This edit session will expire in" => "This edit session will expire in",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Admin Content Templates" => "Admin Content Templates",
// "Lock this page" => "Lock this page",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Case Insensitivity" => "Case Insensitivity",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "My Footnotes" => "My Footnotes",
// "Use rating" => "Use rating",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "break friendship" => "break friendship",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Edit Repository" => "Edit Repository",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "v" => "v",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "Edit/Create" => "Edit/Create",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Additional Info" => "Additional Info",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Choose a movie" => "Choose a movie",
// "Page aliases found" => "Page aliases found",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Xml Zip" => "Xml Zip",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "MyInfo" => "MyInfo",
// "Contacts Preferences" => "Contacts Preferences",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Available Newsletters" => "Available Newsletters",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Edit Permissions" => "Edit Permissions",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Note: Remember that this is only a preview, and has not yet been saved" => "Note: Remember that this is only a preview, and has not yet been saved",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Tiki site registered" => "Tiki site registered",
// "Read this first" => "Read this first",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering is voluntary" => "Registering is voluntary",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "If your site is private or inside your intranet, you should not register" => "If your site is private or inside your intranet, you should not register",
// "Information about your site" => "Information about your site",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save as Draft" => "Save as Draft",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Location : " => "Location : ",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Daily Usage" => "Daily Usage",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "File title" => "File title",
// "required field for podcasts" => "required field for podcasts",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "No gallery available" => "No gallery available",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a bookmark" => "a bookmark",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Default view" => "Default view",
// "Manage Fields" => "Manage Fields",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Toggle" => "Toggle",
// "Toggle options" => "Toggle options",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "Notify sender when reading his mail" => "Notify sender when reading his mail",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "All Shared Tasks" => "All Shared Tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Add Watch" => "Add Watch",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "expires" => "expires",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Edit Fields" => "Edit Fields",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Tracker Item" => "Tracker Item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Edit/Delete" => "Edit/Delete",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "close" => "close",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show All" => "Show All",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Part" => "Part",
// "page id" => "page id",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Fullscreen" => "Fullscreen",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Column" => "Show/Hide Left Column",
// "Show/Hide Right Column" => "Show/Hide Right Column",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "no (disabled)" => "no (disabled)",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "Feeds settings" => "Feeds settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No display" => "No display",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "You must specify a directory" => "You must specify a directory",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version" => "Detected, Version",
// "Test Image" => "Test Image",
// "Not detected" => "Not detected",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "safe" => "safe",
// "risky" => "risky",
// "off" => "off",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist" => "You must specify a page name, it will be created if it doesn't exist",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "%H:%M %Z" => "%H:%M %Z",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No parent specified" => "No parent specified",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "No type indicated" => "No type indicated",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Note not found" => "Note not found",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "You are already logged in" => "You are already logged in",
// "You must choose a group" => "You must choose a group",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "No newsletters available" => "No newsletters available",
// "invalid email" => "invalid email",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Usage" => "Usage",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki" => "Last modifications to the Wiki",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"FAQs" => "FAQs",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"FAQ" => "FAQ",
"XMLRPC API" => "XMLRPC API",
"Mb" => "Mb",
"Tracker was modified at " => "Tracker was modified at ",
"url" => "url",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Cookie" => "Cookie",
"URL" => "URL",
"Url" => "Url",
"of" => "of",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"Cookies" => "Cookies",
"DSN" => "DSN",
"x" => "x",
"cookie" => "cookie",
"Human readable text description of repository" => "Human readable text description of repository",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"RSS" => "RSS",
"+" => "+",
"tikiwiki.org" => "tikiwiki.org",
"pvs" => "pvs",
"#" => "#",
"tiki-mobile.php" => "tiki-mobile.php",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "这个特性已经关闭",
"Permission denied. You cannot view pages" => "你没有查看页面的权限",
"The copyright management feature is not enabled." => "版权管理特性并未启动.",
"No page indicated" => "没有指定页面",
"You must supply all the information, including title and year." => "你必须提供所有信息, 包含标题与年份.",
"You do not have permission to use this feature" => "您没有权限使用这个功能",
"ID" => "编号",
"Type" => "类型",
"Name" => "名称",
"Description" => "描述",
"Size" => "大小",
"Created" => "生成",
"Last Modified" => "最近修改",
"Creator" => "创建者",
"Author" => "作者",
"Comment" => "评论",
"Files" => "文件",
"Hits" => "点击数",
"Locked by" => "锁定者",
"Path" => "路径",
"None" => "无",
"Permission denied" => "权限不足",
"The file is not a CSV file or has not a correct syntax" => "不是 CSV 文件, 或是语法错误",
"locked" => "锁定",
"locked by" => "锁定者",
"in" => "于",
"continued" => "待续",
"New Image Uploaded by" => "新图像上传自",
"New Subscriptions" => "新订阅",
"New Item in Tracker" => "跟踪中有新项目",
"tracker" => "跟踪",
"by" => "作者",
"Wiki" => "Wiki文档",
"Image Gallery" => "图像画廊",
"Articles" => "文集",
"Blogs" => "博客",
"Forums" => "论坛",
"Directory" => "网站目录",
"File Gallery" => "下载中心",
"Quizzes" => "小测验",
"Trackers" => "跟踪",
"Survey" => "调查",
"Newsletter" => "电子期刊",
"article" => "文章",
"blog" => "博客",
"directory" => "网站目录",
"faq" => "FAQ",
"file gallery" => "下载中心",
"forum" => "论坛",
"image gallery" => "图像画廊",
"poll" => "投票",
"quiz" => "小测验",
"wiki page" => "Wiki页面",
"image" => "图像",
"calendar" => "日程表",
"Invalid filename (using filters for filenames)" => "不合法文件名 (使用文件名过滤器)",
"Cannot upload this file - maximum upload size exceeded" => "无法上传文件, 超过最大文件大小限制",
"Anonymous" => "匿名",
"Wrong password. Cannot post comment" => "密码错误. 无法发表评论",
"You have to enter a title and text" => "请输入标题与內容",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: 行数不符: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: 失败",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: 编辑序列并非最佳",
"Newsletter subscription information at" => "电子期刊注册信息在",
"Find" => "查找",
"find" => "查找",
"prev" => "上一页",
"Page" => "页面",
"next" => "下一页",
"Page name" => "页面名称",
"File Galleries" => "下载中心",
"Wiki Home" => "Wiki 首页",
"Home" => "主页",
"Blog" => "博客",
"previous page" => "上一页",
"next page" => "下一页",
"posted on" => "发表于",
"By:" => "由:",
"Read" => "阅读",
"List articles" => "列出文章",
"Last post" => "最新帖子",
"Invalid imagename (using filters for filenames)" => "图像名称不合法 (使用文件名过滤器)",
"Errors detected" => "侦测到错误",
"Upload was not successful" => "上传失败",
"No image yet, sorry." => "尚无图像, 抱歉.",
"unknown" => "未知",
"NONE" => "无",
"Language" => "语言",
"Section" => "版块",
"Theme" => "布景主题",
"Rows" => "行",
"Title" => "标题",
"Topic" => "主题",
"Visible" => "可见",
"Rating" => "评比",
"Reads" => "阅读",
"Images" => "图像",
"Newest first" => "最近的排前面",
"Oldest first" => "最老的排前面",
"Points" => "点数",
"Authentication method" => "认证方式",
"CAS (Central Authentication Service)" => "CAS（重要身份鉴定服务）",
"Web Server" => "Web服务器",
"Available languages" => "有效语言",
"Creation date (desc)" => "创建日期(降序)",
"Last modification date (desc)" => "最近修改日期 (降序)",
"Blog title (asc)" => "博客标题 (升序)",
"Number of posts (desc)" => "帖子数(降序)",
"Visits (desc)" => "访问数(降序)",
"Activity (desc)" => "活动(降序)",
"Disabled" => "关闭",
"Plain text" => "纯文本",
"Link to user information" => "查看用户信息",
"User avatar" => "用户头像",
"Contact user" => "联络用户",
"Count admin pageviews" => "计算管理页面浏览数",
"default mapfile" => "默认地图文件",
"Validate URLs" => "确认 URLs",
"Links per page" => "每页链接数",
"Method to open directory links" => "打开网站目录链接的方法",
"replace current window" => "取代当前窗口",
"new window" => "新的窗口",
"inline frame" => "行內页框",
"No error reporting" => "不报告错误",
"Report all PHP errors" => "报告所有PHP错误",
"Default number of comments per page" => "默认每页评论数目",
"Comments default ordering" => "默认评论排序",
"Polls" => "投票记录",
"Newsletters" => "电子期刊",
"Calendar" => "日程表",
"Banners" => "横幅",
"Category" => "类别",
"Score" => "分数",
"Search" => "搜索",
"Multilingual" => "多语言支持",
"Surveys" => "调查",
"Featured links" => "推荐链接",
"Copyright" => "版权所有",
"Shoutbox" => "布告栏",
"Maps" => "地图",
"Live support system" => "在线支持系统",
"Contact Us" => "联络我们",
"Webmail" => "Web邮箱",
"Mail-in" => "内置邮箱",
"Friendship Network" => "我的网友",
"Banning system" => "禁用系统",
"Stats" => "统计",
"Referer Stats" => "参照页统计",
"Communications (send/receive objects)" => "通讯(发送/接受对象)",
"Custom Home" => "定制主页",
"Mini Calendar" => "迷你日程表",
"User Preferences Screen" => "用户偏好屏幕",
"User Notepad" => "我的笔记本",
"User Bookmarks" => "我的书签",
"User Watches" => "用户监视",
"User Menu" => "我的菜单",
"User Tasks" => "我的任务",
"User Messages" => "我的消息",
"User Files" => "我的文件",
"Integrator" => "储存库",
"Debugger Console" => "除错器控制台",
"Protect against CSRF with a ticket" => "用标签提供SRF保护",
"Detect browser language" => "侦测浏览器语言:",
"Help System" => "帮助系统",
"Smileys" => "表情符号",
"Dynamic Content System" => "动态內容系统",
"Display menus as folders" => "用文件夹方式显示菜单",
"Activate" => "启动",
"Comments" => "评论",
"Submissions" => "投稿",
"Rankings" => "排名",
"Content templates" => "內容模板",
"Print" => "打印",
"Local" => "本地",
"List pages" => "列出页面",
"Last changes" => "最近Wiki文档变动",
"Orphan pages" => "单独页面",
"Search stats" => "搜索统计",
"Visits" => "浏览数",
"Accept wiki syntax" => "接受wiki语法",
"Allow same file to be uploaded more than once" => "允许同一个文件上传多次",
"Never" => "从不",
"Uploaded filenames must match regex" => "上传文件名称必须符合正则表示式",
"Plain" => "平板",
"Threaded" => "讨论串",
"Title (desc)" => "标题 (降序)",
"Title (asc)" => "标题 (升序)",
"Topics" => "主题",
"Posts" => "帖子",
"Posts per day" => "每日发帖数",
"Creation Date (desc)" => "创建日期 (降序)",
"Topics (desc)" => "主题 (降序)",
"Threads (desc)" => "讨论串 (降序)",
"Last post (desc)" => "最近发表帖子 (降序)",
"Name (desc)" => "名称(降序)",
"Name (asc)" => "名称 (升序)",
"Browser title" => "浏览器标题",
"Home page" => "首页",
"Use group homepages" => "使用用户组主页",
"Temporary directory" => "暂存目录",
"Help URL" => "在线帮助的URL",
"Open external links in new window" => "在新窗口中打开外部链接",
"Full path to gdaltindex" => "gdaltindex 的完整路径",
"Display modules to all groups always" => "所有的用户组都显示版块",
"Content" => "內容",
"Use database for translation" => "使用数据库存放翻译",
"full path to mapfiles" => "地图文件的完整路径",
"Wiki Page for Help" => "帮助Wiki页面",
"Wiki Page for Comments" => "评论的Wiki页面",
"geo.position" => "地理位置",
"geo.region" => "地理区域",
"geo.placename" => "地名",
"Port" => "端口",
"Proxy port" => "代理端口",
"Record untranslated strings" => "记录未翻译项目",
"Normal" => "正常",
"Refresh rate" => "更新率",
"Minimum length of search word" => "搜索词汇最短长度",
"Max. number of words containing a syllable" => "包含音节的词汇的最多数量",
"Max. age in hours of syllable search cache" => "音节搜索缓存中可存在的最长时间",
"LRU list purging rate" => "LRU列表清除率",
"LRU list length" => "LRU列表长度",
"Database" => "数据库",
"Publish" => "发表",
"Use proxy" => "使用代理",
"Users can configure modules" => "允许用户配置版块",
"Allow viewing HTML mails?" => "允许阅读 HTML 邮件?",
"Maximum size for each attachment" => "每个附件的最大大小",
"Unlimited" => "未限制",
"Complete" => "完成",
"Top" => "顶层",
"Cache wiki pages (global)" => "缓存Wiki页面（全局的）",
"no cache" => "无缓存",
"minute" => "分",
"minutes" => "分",
"hour" => "时",
"hours" => "小时",
"Enable wiki 3D browser" => "启用Wiki三维浏览器",
"Browser height" => "浏览器高度",
"Navigation depth" => "导航深度",
"Existing page node color" => "存在页面的节点颜色",
"Missing page node color" => "丢失了页面的节点颜色",
"Feed animation interval (milisecs)" => "动画间隔（毫秒）",
"Wiki top pages" => "Wiki主页",
"Most relevant pages" => "最相关页面",
"Relevance" => "相当",
"Wiki last pages" => "Wiki末页",
"Modified" => "已更改",
"Forums last posts" => "论坛最近帖子",
"Topic date" => "主题日期",
"Forums most read topics" => "论坛热门主题",
"Forums best topics" => "论坛最佳主题",
"Forums most visited forums" => "热门论坛",
"Forums with most posts" => "最多发帖论坛",
"Wiki top galleries" => "Wiki热门文件库",
"Wiki top file galleries" => "Wiki热门文件库",
"Wiki top images" => "Wiki热门图像",
"Wiki top files" => "Wiki热门文件",
"Downloads" => "下载数",
"Wiki last images" => "Wiki最新图像",
"Upload date" => "上传日期",
"Wiki last files" => "Wiki最近文件",
"Wiki top articles" => "Wiki热门文章",
"Most visited blogs" => "最热博客",
"Most active blogs" => "最活跃博客",
"Activity" => "活动",
"Blogs last posts" => "最近发表博客",
"Post date" => "发表日期",
"Wiki top authors" => "Wiki最佳作者",
"Pages" => "页面",
"Top article authors" => "文章最多作者",
"User already exists" => "用户已经存在",
"Wrong registration code" => "注册码错误",
"Invalid username" => "不合法的用户名称",
"Username is too long" => "用户名称过长",
"Username cannot contain whitespace" => "用户名称不可含有空白",
"Wrong passcode. You need to know the passcode to register at this site" => "通过码错误, 你必须获得通过码才能在本站注册",
"Invalid email address. You must enter a valid email address" => "不正确的电子邮箱. 请输入正确的电子邮箱地址",
"change" => "更改",
"Today" => "今天",
"and" => "和",
"from" => "从",
"replied" => "已回复",
"Login" => "登录",
"Send message" => "发送消息",
"Attach file" => "附加文件",
"Gallery" => "文件库",
"Image" => "图像",
"Forum" => "论坛",
"Article" => "文章",
"Blog post" => "博客帖子",
"Tracker" => "跟踪",
"Prev" => "上一页",
"Next" => "下一个",
"comment" => "评论",
"Click Here" => "点击这里",
"Hide" => "隐藏",
"help" => "帮助",
"All" => "全部",
"character(s) too long - please edit it." => "字符太长-请编辑它.",
"days" => "日",
"day" => "日",
"mins" => "分",
"min" => "分",
"secs" => "秒",
"done" => "完成",
"for" => "针对",
"Priority" => "优先级",
"Yes" => "是",
"No" => "否",
"created from structure" => "创建自导航结构",
"text" => "文本",
"You are not logged in" => "你尚未登录",
"Page cannot be found" => "找不到页面",
"Permission denied. You cannot view this section" => "权限不足, 你无法查看这个版块",
"Help" => "帮助",
"You are banned from" => "你被禁止使用",
"wiki" => "Wiki文档",
"faqs" => "FAQ",
"quizzes" => "小测验",
"blogs" => "博客",
"forums" => "论坛",
"sad" => "难过",
"confused" => "困惑",
"cool" => "扮酷",
"mad" => "疯狂",
"at" => "于",
"new" => "增加",
"Click here to confirm your action" => "点击这里以确认你的活动",
"Heading" => "标题",
"Reduce area height" => "缩小文本域高度",
"Enlarge area height" => "扩大文本域高度",
"Wiki Help" => "Wiki帮助",
"Item" => "项目",
"Subject" => "主题",
"text field" => "文本域",
"size" => "大小",
"textarea" => "文本区",
"checkbox" => "检查框",
"drop down" => "下拉菜单",
"user selector" => "用户选择器",
"group selector" => "用户组选择器",
"date and time" => "日期和时间",
"action" => "动作",
"category" => "类别",
"email" => "电子邮件",
"system" => "系统",
"attachment" => "附件",
"open" => "开放",
"pending" => "待审",
"closed" => "关闭",
"Message" => "消息",
"child categories" => "子类别",
"objects in category" => "类别中的对象",
"Password should be at least" => "密码应至少有",
"characters long" => "字符长度",
"Password must contain both letters and numbers" => "密码必须含有字母及数字",
"Country" => "国家",
"No subject" => "无标题",
"Displays browser client info" => "显示浏览器客户信息",
"Location" => "地点",
"Start date" => "开始日期",
"Attachment" => "附件",
"File" => "文件",
"Show description" => "显示描述",
"Displays an attachment or a list of them" => "显示一个附件或者附件列表",
"Avatar" => "头像",
"Displays the user Avatar" => "显示用户头像",
"username" => "用户名称",
"Back" => "返回",
"Backlinks" => "反向连接",
"List all pages that link to specific pages" => "列出链接到特指页面的所有页面",
"Zone" => "区域",
"Items" => "项目",
"Insert theme-styled box on wiki page" => "Wiki页面上插入采用主题样式的方块",
"Insert list of items with the current/given category in the wiki page" => "插入当前/指定类别的项目列表到Wiki页面",
"Categories are disabled" => "类别特性已关闭",
"Display Tiki objects that have not been categorized" => "显示尚未分类的Tiki对象",
"Objects" => "对象",
"Insert the full category path for each category that this wiki page belongs to" => "给这个Wiki页面隶属的每个类别插入完整的类别路径",
"Center" => "置中",
"Centers the plugin content in the wiki page" => "Wiki页面中插件內容置中",
"Chart" => "排行榜",
"title" => "标题",
"Code" => "代码",
"Displays a snippet of code" => "显示代码片断:",
"code" => "代码",
"Dynamic Content" => "动态內容",
"Insert copyright notices" => "插入版权宣言",
"Example" => "范例",
"seconds" => "秒",
"Pre" => "上一",
"Right" => "右",
"Left" => "左",
"Clear" => "清除",
"Creates a definition list" => "创建一个定义列表：",
"term" => "来自",
"definition" => "定义",
"one definition per line" => "每行一个定义。",
"Desc" => "描述",
"Upcoming events" => "近期事件",
"Label" => "标签",
"Displays the data using the Tikiwiki odd/even table style" => "使用 Tikiwiki 「奇/偶」表格样式显示资料",
"sort" => "排序",
"Displays a Flash (.swf) file in the wiki page" => "在Wiki文档显示一个SWF",
"description" => "描述",
"Value" => "值",
"Displays a graphical GAUGE" => "显示图表化测量",
"type" => "类型",
"Group" => "用户组",
"groups" => "用户组",
"HTML code" => "HTML码",
"name" => "名称",
"Image ID" => "图像 ID",
"Image size" => "图像大小",
"Thumbnail" => "缩略图",
"Browse" => "浏览",
"Include" => "包含",
"Start" => "开始",
"Stop" => "停止",
"Email address" => "电子邮件地址",
"Displays the text only if the language matchs" => "仅语言匹配时才显示文本",
"Last Modification" => "最后修改",
"List Pages" => "列出页面",
"Sort" => "排序",
"or" => "或",
"Filter" => "过滤器",
"articles" => "文集",
"Map" => "地图",
"Feature disabled" => "特性已关闭",
"Template" => "模板",
"Style" => "样式",
"Groups" => "群组管理",
"Module Name" => "版块名称",
"Please choose a module" => "请选择版块",
"to be used as argument" => "用为参数",
"Displays a module inline in a wiki page" => "在页面显示版块列",
"Sorry, no such module" => "抱歉, 没有这个版块",
"Font" => "字体",
"Displays the data using a monospace font" => "以定宽字显示资料",
"Text" => "文本",
"Sticky" => "置顶",
"data" => "数据",
"Object" => "对象",
"Days" => "数日",
"Status" => "状态",
"Picture" => "图片",
"picture not found" => "找不到图片",
"Displays a list of plugins available in this wiki." => "在Wiki文档中提供插件的列表",
"No version indicated" => "未指定版本",
"Poll" => "投票",
"Preferences" => "使用偏好",
"User Information" => "我的信息",
"one data per line" => "每行一个数据。",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "产生正则表达式并解析在REGEX标记之间的内容，并且替换相应的文本",
"Icon" => "图标",
"Close" => "关闭",
"Date" => "日期",
"Automatically creates a link to the appropriate SourceForge object" => "自动创建链接到适当的SourceForge目标",
"Action" => "动作",
"Sorts the plugin content in the wiki page" => "排序在Wiki页面中的插件内容",
"Order" => "顺序",
"Split a page into rows and columns" => "分割页面到行列形式",
"First" => "第一个",
"Edit" => "编辑",
"Run a sql query" => "执行sql查询",
"sql query" => "sql查询语句",
"Missing db param" => "缺少数据库参数",
"Subscribe" => "订阅",
"Id" => "编号",
"Tag Name" => "标签名称",
"Displays the thumbnail for an image" => "显示图像的缩略图",
"Original" => "原始",
"Search the titles of all pages in this wiki" => "搜索这个Wiki文档中所有页面的标题",
"Structure ID" => "导航结构标识",
"Public" => "公开",
"Translate" => "翻译",
"Fields" => "域",
"Email" => "电子邮件",
"to" => "到",
"template" => "模板",
"Preview" => "预览",
"preview" => "预览",
"Error" => "错误",
"Filters" => "过滤器",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "显示一个跟踪器内容的输出，域由数字ID来指示",
"Mode" => "模式",
"Delete" => "刪除",
"Links to a translated content" => "链接一个翻译的内容",
"Flag" => "国旗",
"Displays the number of registered users" => "显示注册用户数",
"User List" => "用户列表",
"Real Name" => "真实姓名",
"users" => "用户",
"Versions" => "版本",
"Vote" => "投票",
"__key__ | __default__ | __comments__\n" => "键 | 默认值 | 注释\n",
"External Wiki" => "外部 Wiki",
"valid" => "确认",
"ERROR: Either the subject or body must be non-empty" => "错误: 标题或內文不可为空",
"ERROR: No valid users to send the message" => "错误: 没有可发送消息的合法用户",
"Invalid user" => "不合法的用户",
"Message will be sent to: " => "消息将发送给：",
"No more messages" => "没有消息了",
"Categories" => "类别目录",
"Categorize" => "分类",
"Unassign" => "未指定",
"Assign" => "指定",
"Received objects" => "接到的对象",
"File galleries" => "下载中心",
"Last forum posts" => "论坛最近帖子",
"Topics only" => "仅主题",
"Most commented forums" => "最多评论论坛",
"Most read topics" => "最多阅读主题",
"Most visited forums" => "最多访客论坛",
"Google Search" => "Google 搜索",
"Last blog posts" => "最近博客帖子",
"Last Created blogs" => "最近新建博客",
"Last Created FAQs" => "新建FAQ",
"Last Created Quizzes" => "最近新建小测验",
"Last modified file galleries" => "最近更新的下载中心",
"Last Files" => "最近文件库文件",
"Last Modified blogs" => "最近博客变动",
"Last submissions" => "最近投稿",
"Last Items" => "上一个项目",
"Last Modified Items" => "上一个修改项目",
"Live support" => "在线支持",
"Messages" => "私人消息",
"Waiting Submissions" => "等待投稿",
"Old articles" => "旧文集",
"Create/Edit" => "创建/编辑",
"Quick Edit a Wiki Page" => "快速编辑Wiki页面",
"Random Pages" => "随机页面",
"New user registration" => "新用户注册",
"Post" => "发帖",
"Since your last visit" => "自从你上次访问",
"new comments" => "新评论",
"wiki pages changed" => "Wiki页面改变",
"new images" => "新图像",
"new files" => "新文件",
"new users" => "新用户",
"Most Active blogs" => "最勤博客",
"Top articles" => "热门文章",
"Top File Galleries" => "热门下载中心",
"Top Images" => "热门图像",
"Top Pages" => "热门页面",
"Top Quizzes" => "热门小测验",
"Top Visited FAQs" => "热门FAQ",
"User Blogs" => "我的博客",
"My blogs" => "我的博客",
"User bookmarks" => "用户书签",
"My galleries" => "我的图像画廊",
"User Pages" => "我改过的Wiki页面",
"My Pages" => "我改过的Wiki页面",
"User tasks" => "用户任务",
"Online users" => "在线用户",
"Last wiki comments" => "Wiki最新评论",
"Invalid username or password" => "用户名称或密码错误",
"Can create/admin calendars" => "可创建/管理日程表",
"Can add events in the calendar" => "可在日程表增加事件",
"Can change events in the calendar" => "可改变日程表中的事件",
"Can browse the calendar" => "可浏览日程表",
"Administrator, can create channels remove channels etc" => "管理员可创建、移除频道等",
"Can use the chat system" => "可使用聊天系统",
"Can admin the cms" => "可管理内容管理",
"Can approve submissions" => "可审核投稿",
"Submited articles automatically approved" => "提交的文章自动批准",
"Can edit articles" => "可编辑文章",
"Can edit submissions" => "可编辑投稿",
"Can read articles" => "可阅读文章",
"Can remove articles" => "可移除文章",
"Can remove submissions" => "可移除投稿",
"Can submit articles" => "可提交文章",
"Can read a topic (Applies only to individual topic perms)" => "可阅读主题（仅提供给独立的主题权限）",
"Can admin the directory" => "可管理网站目录",
"Can admin directory categories" => "可管理目录类别",
"Can admin directory sites" => "可管理目录网站",
"Submited links are valid" => "提交有效链接",
"Can submit sites to the directory" => "可提交网站到目录",
"Can validate submited links" => "可验证提交的链接",
"Can use the directory" => "可使用网站目录",
"Can admin faqs" => "可管理FAQ",
"Can suggest faq questions" => "可建议FAQ问题",
"Can view faqs" => "可查看FAQ",
"Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "管理员，可管理用户组和权限，热词和所有的博客特性",
"Can access site when closed" => "当网站关闭时也可存取",
"Administrator, can admin banners" => "管理员，可管理标题条",
"Can ban users or ips" => "可禁止用户或IP",
"Can admin the dynamic content system" => "可管理动态内容系统",
"Can admin integrator repositories and rules" => "可管理储存库和规则",
"Can admin mail-in accounts" => "可管理内置邮箱账号",
"Can create new css suffixed with -user" => "可创建新的带-user 后缀的css",
"Can admin cookies" => "可管理cookies",
"Can edit translations and create new languages" => "可编辑翻译和创建新语言",
"Can edit site templates" => "可编辑网站模板",
"Can use HTML in pages" => "可在页面使用HTML",
"Can view integrated repositories" => "可查看储存库",
"Can view referer stats" => "可查看相关统计",
"Can view site stats" => "可查看网站统计",
"Can admin blogs" => "可管理博客",
"Can post to a blog" => "可发表博客",
"Can create a blog" => "可创建博客",
"Can read blogs" => "可阅读博客",
"Can admin file galleries" => "可管理下载中心",
"Can upload zip files with files" => "可用文件上传 zip 文件",
"Can create file galleries" => "可创建下载中心",
"Can download files" => "可下载文件",
"Can upload files" => "可上传文件",
"Can view file galleries" => "可查看下载中心",
"Can admin forums" => "可管理论坛",
"Can attach to forum posts" => "可在论坛跟帖",
"Auto approve forum posts" => "自动通过论坛帖子",
"Can post in forums" => "可在论坛发帖",
"Can start threads in forums" => "可在论坛里发起讨论",
"Can read forums" => "可查看论坛",
"Can report msgs to moderator" => "可报告信息给版主",
"Can vote comments in forums" => "可在论坛投票评论",
"Can admin Image Galleries" => "可管理图像画廊",
"Can upload zip files with images" => "可用图像上传zip文件",
"Can create image galleries" => "可创建图像画廊",
"Can upload images" => "可上传图像",
"Can view image galleries" => "可查看图像画廊",
"Can admin newsletters" => "可管理电子期刊",
"Can subscribe any email to newsletters" => "可用任何电子邮件订阅电子期刊",
"Can subscribe to newsletters" => "可订阅电子期刊",
"Can vote polls" => "可投票表决",
"Can admin quizzes" => "可管理小测验",
"Can take quizzes" => "可接受小测验",
"Can view quiz stats" => "可查看小测验统计",
"Can view user quiz results" => "可查看用户小测验结果",
"Can admin shoutbox (Edit/remove msgs)" => "可管理布告栏（编辑/移除消息）",
"Can post messages in shoutbox" => "可在布告栏发帖",
"Can view shoutbox" => "可查看布告栏",
"Can admin surveys" => "可管理调查",
"Can take surveys" => "可接受调查",
"Can view survey stats" => "可查看调查统计",
"Can admin trackers" => "可管理跟踪",
"Can attach files to tracker items" => "可附加文件到跟踪条目",
"Can insert comments for tracker items" => "可为跟踪条目插入评论",
"Can create new items for trackers" => "可为跟踪创建新条目",
"Can change tracker items" => "可改变跟踪条目",
"Can view trackers" => "可查看跟踪",
"Can admin the wiki" => "可管理Wiki文档",
"Can edit pages" => "可编辑页面",
"Can edit copyright notices" => "可编辑版权通知",
"Can edit dynamic variables" => "可编辑动态变量",
"Can create and edit structures" => "可创建并编辑导航结构",
"Can lock pages" => "可锁定页面",
"Can save as minor edit" => "可另存为次要的编辑",
"Can remove" => "可移除页面",
"Can rename pages" => "可给页面改名",
"Can rollback pages" => "可复原页面",
"Can upload pictures to wiki pages" => "可上传图片到Wiki页面",
"Can view page/pages" => "可查看页面",
"Can admin attachments to wiki pages" => "可管理Wiki页面的附件",
"Can attach files to wiki pages" => "可附加文件到Wiki页面",
"Can view wiki attachments and download" => "可查看Wiki文档附件并下载",
"Can admin received articles" => "可管理收到的文章",
"Can admin received pages" => "可管理收到的页面",
"Can send articles to other sites" => "可发送文章到其他网站",
"Can send articles to this site" => "可发送文章到这个网站",
"Can send pages to this site" => "可发送页面到这个网站",
"Can send pages to other sites" => "可发送页面到其他网站",
"Can cache user bookmarks" => "可缓存用户书签",
"Can configure modules" => "可配置版块",
"Can use the mini event calendar" => "可使用小事件日程表",
"Can use the notepad" => "可使用笔记本",
"Can use tasks" => "可使用任务",
"Can upload personal files" => "可上传个人文件",
"Can create items in personal menu" => "可在个人菜单创建新条目",
"Can broadcast messages to all user" => "可广播消息给所有用户",
"Can broadcast messages to groups" => "可广播消息到用户组",
"Can use the messaging system" => "可使用消息系统",
"Can edit all comments" => "可编辑所有评论",
"Can post new comments" => "可发表新评论",
"Can read comments" => "可阅读评论",
"Can delete comments" => "可删除评论",
"Can vote comments" => "可投票评论",
"Can edit content templates" => "可编辑内容模板",
"Can use content templates" => "可使用内容模板",
"Can edit HTML pages" => "可编辑HTML页面",
"Can view HTML pages" => "可查看HTML页面",
"Admin live support system" => "管理员实时支持系统",
"Can use live support system" => "可使用实时支持系统",
"Can create new mapfile" => "可创建新地图文件",
"Can delete mapfiles" => "可删除地图文件",
"Can edit mapfiles" => "可编辑地图文件",
"Can view mapfiles" => "可查看地图文件",
"Can use webmail" => "可使用web邮箱",
"Can admin categories" => "可管理导航类别",
"change password" => "更改密码",
"country" => "国家",
"theme" => "布景主题",
"Random Image" => "随机图像",
"List of attached files" => "附件列表",
"id" => "编号",
"desc" => "描述",
"uploaded" => "已上传",
"Remove" => "移除",
"Upload file" => "上传文件",
"Attach" => "附件",
"Attach a file to this item" => "附加一个文件到此项目",
"Version" => "版本",
"Attachments" => "附件",
"No attachments for this item" => "此项目无附件",
"debug" => "调试",
"Fatal error" => "致命错误",
"Created by" => "创建自",
"on" => "在",
"Activity=" => "活跃度=",
"Actions" => "动作",
"Properties" => "属性",
"No records found" => "查无记录",
"No categories defined" => "尚未定义类别",
"Browse Category" => "浏览类别目录",
"stars" => "星",
"User Level" => "用户等级",
"private message" => "私人消息",
"Send eMail to User" => "发送电子邮件给用户",
"user online" => "用户在线",
"user offline" => "用户已离线",
"Reply" => "回复",
"Approve" => "审核",
"Reject" => "拒绝",
"Save to notepad" => "保存到记事本",
"Monitor this Topic" => "监控此主题",
"Stop Monitoring this Topic" => "停止监控此主题",
"Errors" => "错误",
"Moderator actions" => "版主命令",
"reported:" => "已报告项目:",
"queued:" => "队列:",
"Move to topic:" => "移动到主题:",
"Move" => "移动",
"Delete Selected" => "刪除选择项目",
"Unlock" => "解除锁定",
"Lock" => "锁定",
"Threshold" => "起算点",
"Set" => "设置",
"Replies" => "回复数",
"Note" => "说明",
"New Reply" => "新回复",
"Reply to the selected post" => "回复所选择的帖子",
"Editing comment" => "编辑评论",
"Post new comment" => "发表新评论",
"Toolbars" => "快捷标记",
"optional" => "可选",
"Post new reply" => "发表新回复",
"Cancel" => "取消",
"Posting replies" => "已发表的回复",
"Posting comments" => "发表评论",
"Add Comment" => "增加评论",
"1 comment" => "1篇评论",
"Go back" => "回上页",
"Return to home page" => "返回主页",
"Copyrights" => "版权所有",
"Year" => "年",
"Authors" => "作者",
"Add" => "加入",
"Tiki Debugger Console" => "Tiki 调试控制台",
"Current URL" => "当前的 URL",
"Command" => "命令",
"exec" => "执行",
"Type <code>help</code> to get list of available commands" => "输入 <code>help</code> 可取得完整指令列表",
"Syntax" => "语法",
"Page generation debugging log" => "页面生成除错用记录",
"Features state" => "特性统计",
"Total" => "全部",
"features matched" => "符合的特性",
"Watchlist" => "监视列表",
"duplicate" => "重复",
"There are individual permissions set for this file gallery" => "这个文件库有独立的权限设置",
"Save" => "保存",
"System" => "系统",
"Use" => "使用",
"none" => "无",
"Max description display size" => "最大描述显示大小",
"Create this page" => "创建这个页面",
"Perms" => "权限",
"Replace" => "替换",
"List" => "列表",
"Name-filename" => "名称-文件名",
"Filename only" => "仅文件名",
"Number of displayed rows" => "显示的行数",
"in:" => "于:",
"Move Selected Files" => "移动所选的文件",
"Assign Permissions" => "指定权限",
"Move to" => "移动到",
"Filename" => "文件",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} 寄给你这个链接:",
"Blog post:" => "博客帖子:",
"at:" => "于:",
"Somebody or you tried to subscribe this email address at our site:" => "某人或是你试图以此电子邮箱地址订阅本站的电子期刊:",
"To the newsletter:" => "订阅的电子期刊:",
"Description:" => "描述:",
"In order to confirm your subscription you must access the following URL:" => "你必须连接到以下的 URL 以确认订阅:",
"User:" => "用户:",
"A new message was posted to forum" => "论坛中有新帖",
"Tiki mail-in instructions" => "Tiki内置邮箱说明",
"Hi," => "您好,",
"A new message was posted to you at {\$mail_machine}" => "有新消息于 {\$mail_machine} 发送给你",
"From" => "从",
"Hi" => "您好",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "您在{\$mail_site}的注册请求已经通过管理员审核，您的帐号已经激活",
"To login with your username and password, please follow this link:" => "请在以下连接使用您的用户名和密码登陆:",
"Enjoy the site!" => "祝您在本站的旅程愉快!",
"User Account Activated" => "Tiki用户已经激活",
"has requested an account on" => "账户请求在",
"To validate that account, please follow the link:" => "请在下面地址激活账户:",
"You're invited to join my network of friends!" => "我邀请你做我的网友！",
"The user" => "用户",
"registered at your site" => "在你的站点注册",
"Bye bye!" => "再见!",
"This email address has been removed to the list of subscriptors of:" => "此电子邮件地址已被移出订阅列表:",
"Newsletter:" => "电子期刊:",
"You can unsubscribe from this newsletter following this link" => "你可用如下链接退订这个电子期刊",
"Welcome to our newsletter!" => "欢迎加入我们的电子期刊!",
"This email address has been added to the list of subscriptors of:" => "此电子邮件地址已被加入订阅列表:",
"You can always cancel your subscription using:" => "你可这样取消你的订阅:",
"Email notification" => "Tiki电子邮件通知",
"requested a reminder of the password for your account" => "找回你的密码",
"requested password reset for your account" => "申请重新设置密码",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => " {\$mail_user} 提交新文章到 {\$mail_site} 于 {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "你可使用此链接修改发送的资料:",
"Title:" => "标题:",
"Heading:" => "标题:",
"Body:" => "正文:",
"Tracker was modified at" => "跟踪修改于",
"You or someone registered this email address at" => "你或是某位注册此电子邮件地址的人",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "如果你要成为本站的注册用户, 必须使用以下链接进行第一次登录:",
"Your registration confirmation" => "您登记的Tiki信息",
"You will receive an email with information to login for the first time into this site" => "你将会收到电子邮件说明初次登录本站的信息",
"Your account request has been stored and will be activated by the admin as soon as possible." => "您的账户请求已经储存，管理员将尽快通过您的请求",
"If you don't want to receive these notifications follow this link:" => "如果你不想再收到这些通知请使用此链接:",
"View the blog at:" => "查看此博客于:",
"changed" => "更改",
"created" => "创建",
"File Description" => "文件描述",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "此页面 {\$mail_page} 由 {\$mail_user} 更改于 {\$mail_date|tiki_short_datetime}",
"Comment:" => "评论:",
"New name" => "新名称",
"Last modification date" => "上次修改日期",
"Mapfiles" => "地图文件",
"Mapfile" => "地图文件",
"Available mapfiles" => "有效的地图文件",
"Create a new mapfile" => "创建新的地图文件",
"Create" => "创建",
"History" => "历史记录",
"Compare" => "比较",
"Current" => "当前",
"Versions are identical" => "版本相同",
"User" => "用户",
"Ip" => "IP",
"Diff" => "比对差异",
"Directories" => "目录",
"Upload From Disk:" => "从磁盘上传",
"Upload Files" => "上传文件",
"Bytes maximum" => "字节为最大容量",
"Create Directory:" => "创建网站目录",
"index file (.shp):" => "索引文件(.shp):",
"files to index (regexp):" => "要索引的文件（正则表达式）",
"Message Archive" => "归档消息",
"messages" => "消息数",
"Unread" => "未读",
"Flagged" => "标记",
"Unflagged" => "取消标记",
"Containing" => "包含",
"Sender" => "寄件者",
"No messages to display" => "没有消息可显示",
"Broadcast message" => "广播消息",
"OK" => "确定",
"All users" => "所有用户",
"Lowest" => "最低",
"Low" => "低",
"High" => "高",
"Very High" => "非常高",
"Send" => "发送",
"Compose message" => "撰写消息",
"Invalid" => "无效",
"Archive" => "已归档",
"Mark as read" => "设为阅读",
"Mark as unread" => "设为未读",
"Mark as flagged" => "设为已标记",
"Mark as unflagged" => "设为未标记",
"Mark" => "标计",
"Mailbox" => "邮箱",
"Compose" => "撰写",
"Broadcast" => "广播",
"Sent" => "已发送",
"Read message" => "阅读消息",
"replyall" => "回复全部",
"Flag this message" => "标记此消息",
"From:" => "从:",
"Sent Messages" => "已发消息",
"move to archive" => "消息归档",
"receiver" => "接收人",
"Move module up" => "上移这个版块",
"Up" => "上",
"Move module down" => "下移这个版块",
"Down" => "下",
"Move module to opposite side" => "这个版块移到对面",
"Thank you for installing Tikiwiki" => "感谢您安装Tikiwiki",
"Select" => "选择",
"Admin" => "管理",
"Admin Modules" => "管理版块",
"Modules" => "模块管理",
"Admin Menus" => "管理菜单",
"Menus" => "菜单管理",
"login" => "登录",
"Pages:" => "页面:",
"Categories:" => "类别:",
"Register" => "注册",
"Open operator console" => "开启操作员界面",
"Logout" => "退出",
"Switch" => "条件",
"eMail" => "电子邮件",
"Password" => "密码",
"Remember me" => "记住我",
"week" => "周",
"month" => "月",
"Click here to register" => "点击这里注册",
"Click here if you've forgotten your password" => "如果忘了密码点击这里",
"I forgot my password" => "忘记密码",
"Click here to login using the default security protocol" => "点击这里使用默认安全协议登录",
"Standard" => "标准",
"Click here to login using a secure protocol" => "点击这里使用安全协议登录",
"Secure" => "安全",
"Stay in ssl Mode" => "停留在 ssl 模式",
"You have" => "你有",
"new messages" => "条新消息",
"new message" => "条新消息",
"You have 0 new messages" => "你有 0 条新消息",
"We have" => "我们有",
"submissions waiting to be examined" => "等待检查的投稿",
"Image Galleries" => "图像画廊",
"Entire Site" => "整个网站",
"Wiki Pages" => "Wiki页面",
"Image Gals" => "图像画廊",
"Blog Posts" => "博客帖子",
"Search Wiki PageName" => "搜索Wiki页面名称",
"Read More" => " 阅读全文",
"Since your last visit on" => "自从你上次访问在",
"New Images" => "新图像",
"Wiki Pages Changed" => "Wiki页面改变",
"New Files" => "新文件",
"New Comments" => "新评论",
"New Users" => "新用户",
"click to edit" => "点击可编辑",
"Top galleries" => "热门文件库",
"view" => "查看",
"Bookmarks" => "书签",
"Cache" => "系统缓存",
"Done" => "完成",
"Del" => "清除",
"Refresh" => "刷新",
"online users" => "在线用户",
"online user" => "在线用户",
"Send a message to" => "发送消息到",
"vote" => "投票",
"Warning" => "警告",
"Users" => "用户管理",
"RSS feed" => "RSS聚合",
"Edit blog" => "编辑博客",
"Monitor this Blog" => "监控此博客",
"Stop Monitoring this Blog" => "停止监控此博客",
"Find:" => "寻找:",
"pages" => "页面",
"To edit the copyright notices" => "要编辑版权宣言",
"The content on this page is licensed under the terms of the" => "本页面的內容根据以下条文授权",
"Permalink" => "固定链接",
"comments" => "评论",
"First page" => "首页",
"Previous page" => "上一页",
"page" => "页面",
"Next page" => "下一页",
"Last page" => "末页",
"referenced by" => "参考自",
"references" => "参考",
"View Comments" => "查看评论",
"Blog name" => "博客名称",
"Tools Calendars" => "工具日程表",
"Check / Uncheck All" => "全选/全取消",
"Tip" => "提示",
"Cancel Edit" => "取消编辑",
"Change preferences" => "更改偏好",
"General" => "一般",
"Features" => "特性",
"Community" => "社区交友",
"Module" => "版块",
"Meta Tags" => "元标识",
"User files" => "用户文件",
"General Settings" => "一般设置",
"Home Blog (main blog)" => "主页博客(主博客)",
"Change settings" => "改变设置",
"Week" => "周",
"Month" => "月",
"Saturday" => "星期六",
"Sunday" => "星期日",
"Monday" => "星期一",
"5 minutes" => "6 分钟",
"Permissions" => "权限",
"Import CSV file" => "导入 CSV 文件",
"Batch upload (CSV file)" => "批次上传 (CSV 文件)",
"Import" => "导入",
"avatar" => "头像",
"Number of friends" => "朋友数量",
"E-mail" => "电子邮箱l",
"Last login" => "最近登录",
"Number of visited pages to remember" => "记住浏览的页面数",
"Displayed time zone" => "显示时区",
"User information" => "用户信息",
"Private" => "私人",
"public" => "公开",
"Use double-click to edit pages" => "双击编辑页面",
"Show user's info on mouseover" => "当鼠标滑过时显示用户信息",
"Tasks per page" => "每页任务数",
"Messages per page" => "每页消息数",
"Allow messages from other users" => "允许其他用户的消息",
"Send me an email for messages with priority equal or greater than" => "发送电子邮件通知, 当消息优先级大于等于",
"My Tiki" => "我的Tiki",
"My pages" => "我的页面",
"My messages" => "我的消息",
"My tasks" => "我的任务",
"My items" => "我的项目",
"Settings" => "设置",
"Watches" => "监视",
"Home Gallery (main gallery)" => "主页库 (主库)",
"Home Forum (main forum)" => "主页论坛 (主论坛)",
"Searches" => "搜索",
"Browser width" => "浏览器宽度",
"Galleries features" => "文件库特性",
"Uses Slideshow" => "使用幻灯显示",
"Use database to store images" => "数据库方式存储图片",
"Use a directory to store images" => "使用文件夹来保存图像",
"Directory path" => "文件夹路径",
"Library to use for processing images" => "用于处理图像的程序库",
"Uploaded image names must match regex" => "上传图像名称必须符合正则表示式",
"Uploaded image names cannot match regex" => "上传图像名称不得符合正则表示式",
"Max Rows per page" => "每页最大行数",
"Images per row" => "每列图像数",
"Thumbnails size X" => "缩略图宽度X",
"Thumbnails size Y" => "缩略图高度Y",
"Set features" => "设置特性",
"Exterminator" => "缓存处",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "移除系统文件库中没有用于Wiki页面, 文章或博客帖子的图像",
"All galleries" => "所有文件库",
"System Gallery" => "系统文件库",
"Gallery listing configuration" => "库列表设定",
"Parent" => "父系",
"Last modified" => "最近修改",
"Image galleries comments settings" => "图像画廊评论设置",
"General Preferences" => "一般偏好",
"Username" => "用户名称",
"Contact" => "联络",
"Home Page" => "主页",
"Custom home" => "定制主页",
"Date and Time Formats" => "日期与时间格式",
"Date and Time Format Help" => "日期与时间格式说明",
"Change admin password" => "更改管理员密码",
"Change password" => "更改密码",
"Syntax error" => "语法错误",
"port" => "端口",
"click here" => "点击这里",
"Tiki and HTTP Auth" => "Tiki 与 HTTP Auth",
"Registration" => "注册",
"Users can register" => "允许用户注册",
"Account validated successfully." => "账户验证成功.",
"Use challenge/response authentication" => "使用安全回应认证",
"Allow secure (https) login" => "允许安全 (https) 登录",
"Require secure (https) login" => "需要安全 (https) 登录",
"Duration:" => "持续时间:",
"Host:" => "主机:",
"Currently unused" => "当前没用",
"Version 1.0" => "版本 1.0",
"Version 2.0" => "版本 2.0",
"Users can change theme" => "允许注册用户更改布景",
"Restrict available themes" => "限制有效布景主题",
"Available styles:" => "可用样式:",
"Edit CSS" => "编辑CSS样式",
"Theme Control" => "布景主题控制",
"Tiki Template Viewing" => "浏览Tiki模版",
"Edit Templates" => "编辑模板",
"General Layout options" => "一般版面配置选项",
"logged as" => "登录为",
"Alt. description (e.g. for text browsers)" => "警告描述",
"Subtitle" => "副标题",
"Left column" => "左列",
"Right column" => "右列",
"Bottom bar" => "底部横幅",
"Maximum number of records in listings" => "列表中版本最大数目",
"Use direct pagination links" => "使用直接页码链接",
"Direction" => "指示符号",
"Use Tabs" => "使用表格",
"Layout per section" => "每版块版面配置",
"Admin layout per section" => "管理每版块的版面配置",
"Last update" => "最近更新",
"Image galleries" => "图像画廊",
"Feed for forums" => "论坛聚合",
"Specification" => "说明",
"Automonospaced text" => "自动单空格文本",
"Tables syntax" => "表格语法",
"|| for rows" => " || 表示一行",
"AutoLinks" => "自动链接",
"Hotwords" => "热词管理",
"rows" => "行",
"Required" => "必须",
"Parameters" => "参数",
"Use database to store files" => "使用数据库来保存文件",
"Use a directory to store files" => "使用文件夹来保存文件",
"dls" => "下传数",
"Storage" => "存储",
"Change all to db" => "改变所有到数据库",
"Change all to file" => "改变所有到文件",
"Quota (Mb)" => "配额 (Mb)",
"Use database to store userfiles" => "使用数据库保存用户文件",
"Use a directory to store userfiles" => "使用目录保存用户文件",
"Create New" => "创建新的",
"Warn on edit conflict" => "警告编辑的冲突",
"Undo" => "撤消",
"Footnotes" => "脚注",
"Permission" => "权限",
"Allow HTML" => "允许 HTML",
"Sandbox" => "涂鸦板",
"Dumps" => "卸出",
"Remove a tag" => "移除一个标记",
"Generate dump" => "生成卸出",
"Download last dump" => "下载最近的卸出",
"Pictures" => "图片",
"Remove unused pictures" => "移除未使用的图片",
"Export" => "导出",
"Export Wiki Pages" => "导出Wiki页面",
"Accept dashes and underscores in WikiWords" => "Wiki词汇接受斜杠和下划线",
"Link plural WikiWords to their singular forms" => "链接复数的 Wiki 词汇到其单数形式",
"Discuss pages on forums" => "在论坛上讨论页面",
"like pages" => "相似页面",
"Structures" => "导航结构",
"Open page as structure" => "打开页面作为结构",
"Import HTML" => "导入 HTML",
"Page creators are admin of their pages" => "页面创建者也是页面管理员",
"MultiPrint" => "多重打印",
"Create watch for author on page creation" => "在页面创建时为作者创建监视",
"Enable watch events when I am the editor" => "当我是编辑时开启监视事件",
"Enable watches on comments" => "启动对评论的监视",
"Links" => "链接维护",
"Wiki attachments" => "Wiki附件",
"Shoutbox Words" => "布告栏词汇",
"Live Support" => "在线支持",
"Contact us" => "联络我们",
"phpinfo" => "php信息",
"Banning" => "禁用",
"Mail Notifications" => "邮件提醒",
"Content Templates" => "內容模版",
"bytes" => "字节",
"Statistics" => "统计",
"Weeks" => "周",
"Setting" => "设置",
"viewed" => "被浏览",
"Add or edit a rule" => "增加或编辑规则",
"Rule title" => "规则标题",
"Username regex matching" => "用户名称符合正则表示式",
"IP regex matching" => "IP 符合正则表示式",
"Banned from sections" => "禁用下列版块",
"Rule activated by dates" => "规则依日期启用",
"Rule active from" => "规则起始日期",
"Rule active until" => "规则结束日期",
"Custom message to the user" => "给用户的定制消息",
"Rules" => "规则",
"User/IP" => "用户/IP",
"Sections" => "版块",
"Admin Calendars" => "管理日程表",
"List of Calendars" => "日程表列表",
"Loc" => "位置",
"Participants" => "参与者",
"Cat" => "类别",
"Lang" => "语言",
"Prio" => "优先级",
"Custom Locations" => "定制位置",
"Custom Categories" => "定制类别",
"Custom Languages" => "定制语言",
"Custom Priorities" => "定制优先级",
"h" => "标题",
"Current category" => "当前类别",
"Child categories" => "子类别",
"Edit permissions for this category" => "编辑这个类别的权限",
"Edit this category:" => "编辑此类别:",
"Add new category" => "加入新类别",
"Objects in category" => "类别中的对象",
"Add objects to category" => "增加对象到类别中",
"Admin templates" => "管理模板",
"Edit this template:" => "编辑此模板:",
"Create new template" => "创建新模板",
"Use wysiwyg editor" => "使用所见即所得编辑器",
"Use normal editor" => "使用一般编辑器",
"CMS" => "内容管理",
"HTML Pages" => "HTML 页面",
"Templates" => "模板",
"Admin cookies" => "管理 cookies",
"Create/edit cookies" => "创建/编辑 cookies",
"Upload Cookies from textfile" => "从文本文件上传 Cookies",
"Upload from disk:" => "从磁盘上传:",
"Upload" => "上传",
"Remove all cookies" => "移除所有cookies",
"Admin dsn" => "管理 dsn",
"Create/edit dsn" => "创建/编辑 dsn",
"Admin external wikis" => "管理外部 wiki",
"View template" => "浏览模板",
"Edit template" => "编辑模板",
"Create/Edit External Wiki" => "创建/编辑外部 Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (在URL中使用 \$page 来取代 page, 例如: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "外部 wiki",
"Admin Forums" => "管理论坛",
"Create new forum" => "创建新论坛",
"List forums" => "论坛列表",
"Coms" => "帖子",
"Age" => "年龄",
"PPD" => "每日发帖数",
"Edit this Forum:" => "编辑此论坛:",
"There are individual permissions set for this forum" => "这个论坛有独立权限设置",
"Name:" => "名称：",
"Create new" => "创建新的",
"Password protected" => "受密码保护",
"Forum password" => "论坛密码",
"Topic list configuration" => "主题列表配置",
"Display last post titles" => "显示最近的帖子主题",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "以可用来向这个内部论坛的e-mail地址反馈的格式，转发此论坛的消息到此电子邮箱地址，",
"Originating e-mail address for mails from this forum" => "原始的用于这个论坛的邮件的电子邮件地址",
"Add messages from this email to the forum" => "将来自此电子邮箱的消息增加到论坛",
"Use topic smileys" => "主题可使用表情符号",
"Show topic summary" => "显示主题统计",
"User information display" => "显示用户资料",
"Online" => "在线",
"Approval type" => "审核类型",
"Store attachments in:" => "保存附件于:",
"Admin Hotwords" => "管理热词",
"Add Hotword" => "加入热词",
"Word" => "词汇",
"Admin HTML pages" => "管理 HTML 页面",
"Edit this page" => "编辑此页面",
"View page" => "查看页面",
"Edit zone" => "编辑区域",
"Dynamic zones" => "动态区域",
"zone" => "区域",
"content" => "內容",
"Mass update" => "大量更新",
"Create new HTML page" => "创建新 HTML 页面",
"Edit this HTML page:" => "编辑此 HTML 页面:",
"Apply template" => "套用模板",
"Dynamic" => "动态",
"Static" => "静态",
"Last Modif" => "最近修改",
"Edit Repository:" => "编辑储藏:",
"Create New Repository" => "创建新储藏",
"List Repositories" => "列出储藏",
"New Repository" => "新储藏",
"View Repository" => "查看储藏",
"Start page" => "开始页面",
"CSS file" => "CSS 文件",
"Cacheable" => "可缓存",
"Clear cache" => "清除缓存",
"Cache expiration" => "缓存期",
"Available Repositories" => "有效的储藏",
"CSS File" => "CSS文件",
"Edit rules" => "编辑规则",
"Edit Rules for Repository:" => "编辑储藏规则:",
"Configure Repositories" => "配置储藏",
"Configure this Repository" => "配置这个储藏",
"View this Repository" => "查看这个储藏",
"New Rule" => "新规则",
"Copy Rules" => "复制规则",
"view/hide copy rules dialog" => "显示/隐藏 拷贝规则对话框",
"Rule order" => "规则顺序",
"Text to search for" => "查找内容",
"Text to replace" => "待替换内容",
"Enabled" => "生效",
"Preview options" => "预览选项",
"Apply all rules" => "应用所有规则",
"Code preview" => "代码预览",
"Generate HTML preview" => "生成HTML预览",
"HTML preview" => "HTML预览",
"Rules List" => "规则列表",
"Case" => "大小写敏感",
"Configure/Options" => "配置/选项",
"Admin layout" => "管理版面配置",
"Theme control" => "布景控制",
"layout options" => "版面配置选项",
"Top bar" => "顶部横幅",
"Generate positions by hits" => "按点击数排序",
"List of featured links" => "列出推荐链接",
"Position" => "位置",
"Add Featured Link" => "加入推荐链接",
"Edit this Featured Link:" => "编辑此推荐链接:",
"Create new Featured Link" => "创建新推荐链接",
"disables the link" => "关闭此链接",
"Link type" => "链接类型",
"replace current page" => "取代当前页面",
"framed" => "页框",
"open new window" => "开启新窗口",
"Mail-in accounts" => "内置邮件账号",
"Account" => "账号",
"Add new Mail-in account" => "加入新的内置邮件账号",
"Edit Mail-in account" => "编辑内置邮件账号",
"Account name" => "账号名称",
"POP server" => "POP 服务器",
"SMTP server" => "SMTP 服务器",
"SMTP requires authentication" => "SMTP 需要认证",
"Article Topic" => "文章主题",
"Admin Topics" => "管理主题",
"Article Type" => "文章类型",
"Admin Types" => "管理文章类型",
"Active" => "启动",
"Allow anonymous acces" => "允许匿名存取",
"Allow attachments" => "允许附件",
"Check Mail-in accounts" => "检查内置邮件账号",
"Check automatically" => "自动检查",
"Frequency" => "频率",
"List menus" => "列出菜单",
"Edit this menu" => "编辑此菜单",
"Edit menu options" => "编辑菜单项目",
"Some useful URLs" => "一些有用的 URL",
"option" => "选项",
"separator" => "分隔线",
"Choose" => "选择",
"Home Blog" => "主博客",
"Home Image Gal" => "主图像画廊",
"Home Image Gallery" => "主图像画廊",
"Home File Gal" => "主下载中心",
"Home File Gallery" => "主下载中心",
"User preferences" => "用户偏好",
"User prefs" => "用户偏好",
"List galleries" => "列出文件库",
"List image galleries" => "列出图像画廊",
"Upload image" => "上传图像",
"Gallery Rankings" => "文件库排名",
"Browse a gallery" => "浏览库",
"Articles home" => "文集主页",
"All articles" => "所有文章",
"Submit" => "提交",
"List Blogs" => "列出博客",
"Create blog" => "创建博客",
"View a forum" => "进入论坛",
"View a thread" => "查看讨论串",
"View a FAQ" => "查看FAQ",
"Take a quiz" => "参加小测验",
"Quiz stats" => "小测验统计",
"Stats for a Quiz" => "小测验统计",
"Preview menu" => "预览菜单",
"Menu options" => "菜单项目",
"Options" => "选项",
"Edit this Menu:" => "编辑此菜单:",
"Create new Menu" => "创建新菜单",
"dynamic collapsed" => "动态折叠",
"dynamic extended" => "动态扩展",
"fixed" => "固定",
"Clear Cache" => "清除缓存",
"Assigned Modules" => "指定版块",
"Left Modules" => "左方版块",
"Move to Right Column" => "移到右列",
"Right Modules" => "右方版块",
"Move to Left Column" => "移到左列",
"Assign new module" => "指定新版块",
"Edit this assigned module:" => "编辑指定的版块:",
"Cache Time" => "缓存时间",
"Visibility" => "可见性",
"Displayed now for all eligible users even with personal assigned modules" => "现在向所有合法用户显示一致的个人指定版块",
"Displayed for the eligible users with no personal assigned modules" => "向合法用户显示没有进行个人指定的版块",
"Displayed now, can't be unassigned" => "现在显示，不能取消指定",
"Not displayed until a user chooses it" => "不显示，直到有用户选择它",
"User Modules" => "我的版块",
"Create new user module" => "创建新的用户版块",
"Edit this user module:" => "编辑这个用户 module:",
"Objects that can be included" => "允许包含的对象",
"Use Poll" => "使用投票",
"Use Gallery" => "使用文件库",
"Use Dynamic Content" => "使用动态內容",
"Use RSS Module" => "使用 rss 版块",
"Use Menu" => "使用菜单",
"Use phplayermenu" => "使用PHP层菜单",
"Use Banner Zone" => "使用标语区域",
"Structures:" => "导航结构",
"Data" => "数据",
"Admin newsletter subscriptions" => "管理电子期刊订阅",
"List Newsletters" => "列出电子期刊",
"Admin Newsletters" => "管理电子期刊",
"Send Newsletters" => "发送电子期刊",
"Add a subscription newsletters" => "增加订阅电子期刊",
"Email:" => "电子邮件:",
"Subscriptions" => "订阅",
"Valid" => "有效",
"Subscribed" => "订阅",
"Admin newsletters" => "管理电子期刊",
"Editions" => "版本",
"Last Sent" => "上次发送",
"Create/Edit Newsletters" => "创建/编辑电子期刊",
"There are individual permissions set for this newsletter" => "此电子期刊有独立的权限设置",
"Users can subscribe/unsubscribe to this list" => "用户可取消/订阅到这个列表",
"Users can subscribe any email address" => "允许用户以任何电子邮件订阅",
"Add unsubscribe instructions to each newsletter" => "增加取消订阅的介绍到每一个电子期刊",
"Validate email addresses" => "验证电子邮件地址",
"Add notification" => "增加通知",
"Event" => "事件",
"edit" => "编辑",
"remove" => "移除",
"Update" => "更新",
"List polls" => "列出投票",
"Edit this poll" => "编辑这个投票",
"Preview poll" => "预览这个投票",
"Poll options" => "投票选项",
"Votes" => "投票",
"Admin Polls" => "管理投票",
"Set last poll as current" => "设置最下一个投票为当前的投票",
"Close all polls but last" => "关闭所有投票除了最下一个",
"Activate all polls" => "启动所有投票",
"active" => "启动",
"current" => "当前",
"object" => "对象",
"PublishDate" => "发表日期",
"Results" => "结果",
"Wiki pages" => "Wiki页面",
"Content for the feed" => "应用到內容",
"Security Admin" => "安全管理",
"user" => "用户",
"group" => "用户组",
"sticky" => "置顶",
"Admin Shoutbox Words" => "管理布告栏词汇",
"Add Banned Word" => "增加禁用词汇",
"Destroy the structure leaving the wiki pages" => "刪除导航结构, 保留Wiki页面",
"Destroy the structure and remove the pages" => "刪除导航结构与页面",
"Export Pages" => "导出页面",
"Dump Tree" => "卸出树系",
"Create WebHelp" => "创建web帮助",
"Create new structure" => "创建新的导航结构",
"Alias" => "别名",
"Tree" => "树系",
"Use single spaces to indent structure levels" => "使用单一空格缩排导航结构层级",
"Create New Structure" => "创建新的导航结构",
"List surveys" => "列出调查",
"Survey Stats" => "调查结果",
"Edit this Survey" => "编辑这个调查",
"Admin Surveys" => "管理调查",
"Question" => "问题",
"One choice" => "单一选择",
"Multiple choices" => "多重选择",
"Short text" => "简短文本",
"Rate (1..5)" => "评比 (1..5)",
"Rate (1..10)" => "评比 (1..10)",
"Rate" => "评比",
"Options (if apply)" => "选项 (如果有)",
"Questions" => "问题",
"Admin surveys" => "管理调查",
"List Surveys" => "列出调查",
"Edit this Survey:" => "编辑此调查:",
"Create New Survey" => "创建新调查",
"There are individual permissions set for this survey" => "此调查有独立的权限设置",
"Open" => "开放",
"Empty" => "清空",
"Create a new topic" => "创建新主题",
"Topic Name" => "主题名称",
"Upload Image" => "上传图像",
"List of topics" => "主题列表",
"Articles (subs)" => "文章 (回应数)",
"topic image" => "主题图像",
"Deactivate" => "停止",
"Remove with articles" => "用文集移除",
"List Trackers" => "跟踪列表",
"Admin Trackers" => "管理跟踪",
"Edit This Tracker" => "编辑此跟踪",
"View This Tracker's Items" => "浏览此跟踪项目",
"Tracker fields" => "跟踪列",
"Is column visible when listing tracker items?" => "当列出跟踪项目时可否看见列?",
"Tbl vis" => "列表可见",
"Column links to edit/view item?" => "列是否链接到 编辑/查看 项目?",
"isMain" => "是主要",
"Edit tracker field" => "编辑跟踪列",
"Found" => "找到",
"trackers" => "跟踪",
"There are individual permissions set for this tracker" => "这个跟踪项目有独立的权限设置",
"No individual permissions. Global permissions apply." => "不采用单独的权限设置,采用全体权限设置",
"Show status" => "显示状态",
"Default status displayed in list mode" => "默认状态以列表模式显示",
"Show status to tracker admin only" => "只在跟踪器管理显示状态",
"New items are created with status" => "新条目已创建用状态:",
"Authoritative status for modified items" => "修改条目的命令状态",
"No change" => "没有变动",
"Item creator can modify his items?" => "条目创建者可否修改其条目?",
"Show creation date when listing tracker items?" => "当列出跟踪项目时跟踪创建日期?",
"Show lastModif date when listing tracker items?" => "当列出跟踪项目时显示上次修改日期?",
"What field is used for default sort?" => "默认用于排序域是什么?",
"What is default sort order in list?" => "在表中默认用于排序的顺序是什么?",
"ascending" => "升序",
"descending" => "降序",
"Tracker items allow comments?" => "允许对跟踪项目发表评论?",
"Tracker items allow attachments?" => "允许跟踪项目包含附件?",
"Filesize" => "文件大小",
"Import/Export" => "导入/导出",
"Import/export trackers" => "导入/导出跟踪器",
"Admin groups" => "管理用户组",
"Admin users" => "管理用户",
"Add new group" => "增加新用户组",
"List of existing groups" => "现存用户组列表",
"Add a New Group" => "增加新用户组",
"Edit Item" => "编辑项目",
"Add a New User" => "增加用户",
"Reason" => "原因",
"to groups" => "给用户组",
"bcc" => "暗抄",
"Generate a password" => "生成一个密码",
"Overwrite" => "覆盖",
"Admin Article Types" => "管理文章类型",
"List of types" => "类型列表",
"Shows up in the drop down list of article types" => "显示文章类型名称下拉列表",
"Allow ratings by the author" => "允许作者评比",
"Show before publish date" => "发表之前即显示",
"non-admins can view before the publish date" => "非管理员可在发表之前查看",
"Show after expire date" => "到期之后再显示",
"non-admins can view after the expire date" => "非管理员可在到期之后查看",
"Heading only" => "仅标题",
"No article body, heading only" => "没有文章内文，只有标题",
"Allow comments for this type" => "允许评论这个类型",
"Comment Can Rate Article" => "评论可评比文章",
"Allow comments to include a rating value" => "允许包含评比值的评论",
"Show image" => "显示图像",
"Show topic or own image" => "显示主题或自带图像",
"Show avatar" => "显示头像",
"Show author's avatar" => "显示作者头像",
"Show author" => "显示作者",
"Show author name" => "显示作者名称",
"Show publish date" => "显示发表日期",
"Show expire date" => "显示到期日",
"Show reads" => "显示阅读次数",
"Show the number of times the article was read" => "显示文章的被阅读次数",
"Show size" => "显示大小",
"Show the size of the article" => "显示文章的大小",
"Show topline" => "显示页顶行",
"Show a small title over the title" => "显示在标题上的小标题",
"Show subtitle" => "显示副标题",
"Show the subtitle" => "显示副标题",
"Show source" => "显示来源",
"Show link to source after article body" => "在文章内文后显示来源的网址链接",
"Show Image Caption" => "显示图像标题",
"Show a legend under the image" => "在图像下面显示的说明",
"Show Language" => "显示语言",
"Show the language" => "显示语言",
"Creator can edit" => "创建者可编辑",
"The person who submits an article of this type can edit it" => "提交这个类型文章的人可编辑它",
"Show lang" => "显示语言",
"Review" => "评论",
"Classified" => "机密",
"Create a new type" => "创建新的类型",
"Group Information" => "用户组信息",
"level" => "层级",
"Create level" => "创建新级别",
"all permissions in level" => "本层级所有权限",
"backlinks to" => "回退链接到",
"No backlinks to this page" => "此页面并无回退链接",
"Browse Gallery" => "浏览库",
"Upload From Disk" => "从磁盘上传",
"Process" => "过程",
"Edit Post" => "编辑帖子",
"View Blog" => "查看博客",
"Use ...page... to separate pages in a multi-page post" => "使用 ...page... 将页面分隔为多页帖子",
"Body" => "正文",
"Upload image for this post" => "上传图像到此帖子",
"Trash" => "垃圾桶",
"Mark entry as private:" => "标记这篇为隐私博客",
"Spellcheck" => "拼写检查",
"Save and Exit" => "保存并退出",
"Execution time" => "运行时间",
"Memory usage" => "内存使用",
"Server load" => "系统负载",
"Admin Category" => "管理类别目录",
"Browse in" => "浏览范围",
"Trackers Items" => "跟踪项目",
"Hide subcategories objects" => "隐藏子类别目录",
"Show subcategories objects" => "显示子类别目录",
"Upper level" => "上一层",
"List Galleries" => "列出文件库",
"Edit Gallery" => "编辑库",
"Rebuild Thumbnails" => "重建缩略图",
"List Gallery" => "列出库",
"Sort Images by" => "排列图像顺序",
"Original Size" => "原始大小",
"rotate right" => "向右旋转",
"rotate" => "旋转",
"Details" => "细节",
"popup" => "弹出",
"You can include the image in a tiki page using one of these lines" => "你可用以下之一的代码把这个图像包含在一个Wiki页面里",
"Return to Gallery" => "返回文件库",
"Edit Image" => "编辑图像",
"First Image" => "第一张图像",
"Prev Image" => "上一个图像",
"Smaller" => "缩小",
"Bigger" => "放大",
"Popup window" => "弹出窗口",
"Next Image" => "下一个图像",
"Last Image" => "最末张图像",
"Image Name" => "图像名称",
"Image Scale" => "图像比例",
"Move image" => "移动图像",
"Stop Monitoring this Page" => "停止监控此页面",
"Monitor this Page" => "监视此页面",
"Group Calendars" => "用户组日程表",
"Tentative" => "暂定",
"Confirmed" => "已确认",
"Cancelled" => "已取消",
"Edit Calendar Item" => "编辑日程表项目",
"New Calendar Item" => "新日程表条目",
"Tuesday" => "星期二",
"Wednesday" => "星期三",
"Thursday" => "星期四",
"Friday" => "星期五",
"January" => "1月",
"February" => "2月",
"March" => "3月",
"April" => "4月",
"May" => "5月",
"June" => "6月",
"July" => "7月",
"August" => "8月",
"September" => "9月",
"October" => "10月",
"November" => "11月",
"December" => "12月",
"times" => "次",
"End" => "结束",
"Duration" => "持续时间",
"Organized by" => "组织方式",
"Roles" => "角色",
"import" => "导入",
"Change password enforced" => "强制更改密码",
"Change your password" => "更改你的密码",
"Send a message to us" => "发送消息给我们",
"Contact us by email" => "使用电子邮箱与我们联络",
"Contacts" => "通讯录",
"Create/edit contacts" => "创建/编辑 通讯录",
"First Name" => "名",
"Last Name" => "姓",
"Nickname" => "昵称",
"You can browse the generated WebHelp here" => "在这里浏览生成的web帮助",
"Structure" => "导航结构",
"Top page" => "顶层页面",
"Add a new site" => "增加新的站点",
"Site added" => "增加的站点",
"Directory Administration" => "网站目录管理",
"There are" => "有",
"invalid sites" => "不正确的站点",
"valid sites" => "正确的站点",
"Users have visited" => "用户已访问",
"sites from the directory" => "个站点来自这个目录",
"Users have searched" => "用户已搜索",
"times from the directory" => "次自这个目录",
"Related" => "相关",
"Sites" => "网站",
"Validate" => "确认",
"Admin directory categories" => "管理网站目录类别",
"Add a directory category" => "增加网站目录类别",
"Edit this directory category" => "编辑网站目录类别",
"Children type" => "子类型",
"Maximum number of children to show" => "最大显示子层数",
"Editor group" => "编辑者用户组",
"cType" => "类型",
"allow" => "允许",
"count" => "次",
"editor" => "编辑",
"relate" => "相关",
"Mutual" => "共同",
"Admin sites" => "管理站点",
"Is valid" => "是有效的",
"New Sites" => "新站点",
"Cool Sites" => "酷站点",
"Add a Site" => "增加一个站点",
"any" => "任何",
"in entire directory" => "在整个目录中",
"Sort by" => "排序依据",
"name (desc)" => "名称 (降序)",
"name (asc)" => "名称 (升序)",
"hits (desc)" => "点击数 (降序)",
"hits (asc)" => "点击数 (升序)",
"creation date (desc)" => "创建日期 (降序)",
"creation date (asc)" => "创建日期 (升序)",
"last updated (desc)" => "最后更新 (降序)",
"last updated (asc)" => "最后更新 (升序)",
"Added" => "加入",
"Last updated" => "最近修改",
"Total links" => "全部链接",
"Links to validate" => "待确认链接",
"Searches performed" => "搜索已执行",
"Total links visited" => "全部被访问链接",
"Directory ranking" => "网站目录排名",
"Search results" => "搜索结果",
"Validate sites" => "确认网站",
"Edit article" => "编辑文章",
"View Articles" => "显示文章",
"Topline" => "页顶行",
"Author Name" => "作者",
"Own Image" => "图像",
"Article image" => "文章图片",
"Use own image" => "使用图像",
"Float text around image" => "文绕图",
"Own image size x" => "自有图片宽度",
"Own image size y" => "自有图片高度",
"Image caption" => "图像标题",
"Publish Date" => "发表日期",
"Expiration Date" => "到期日",
"Edit or create banners" => "编辑或创建标语",
"List banners" => "列出横幅",
"URL to link the banner" => "链接此标语的 URL",
"Client" => "用户",
"Max impressions" => "最大次数",
"Show the banner only between these dates" => "只在这些日期显示标语",
"From date" => "开始日期",
"To date" => "结束日期",
"Use dates" => "使用日期",
"Show the banner only in this hours" => "只在这些时间显示标语",
"Show the banner only on" => "显示大横幅的日子",
"Mon" => "星期一",
"Tue" => "星期二",
"Wed" => "星期三",
"Thu" => "星期四",
"Fri" => "星期五",
"Sat" => "星期六",
"Sun" => "星期日",
"Select ONE method for the banner" => "选择标语的方式",
"Use HTML" => "使用 HTML",
"Use image" => "使用图像",
"Image:" => "图像:",
"Current Image" => "当前图像",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "使用由URL生成的图像 (图像每次都会从URL索取)",
"Use text" => "使用文本",
"Save the Banner" => "保存标语",
"Remove Zones (you lose entered info for the banner)" => "移出区域（输入标语的信息将丢失）",
"Create Blog" => "创建博客",
"Current heading" => "当前标题",
"There are individual permissions set for this blog" => "这个博客有独立的权限设置",
"Number of posts to show" => "显示的帖子数",
"Allow other user to post in this blog" => "允许其他用户发表于这个博客",
"Allow search" => "允许搜索",
"Allow comments" => "允许评论",
"Show user avatar" => "显示用户头像",
"Blog heading" => "博客标题",
"Edit Style Sheet" => "编辑样式表",
"Style Sheet" => "样式表",
"choose a stylesheet" => "选择样式表",
"Try" => "尝试",
"Colored text" => "著色文本",
"Box content" => "方块內容",
"Dynamic variables" => "动态变量",
"Inserts an editable variable" => "插入一个可编辑的变量",
"External links" => "外部链接",
"Square Brackets" => "方括弧",
"Wiki References" => "Wiki文档参考",
"JoinCapitalizedWords or use" => "连在一起的大写词汇或使用",
"page|description" => "页面|描述",
"for wiki references" => "表示Wiki文档参考",
"SomeName" => "某个名称",
"prevents referencing" => "表示不参考",
"Lists" => "项目",
"for bullet lists" => "表示无序列表",
"for numbered lists" => "表示有序列表",
"for definiton lists" => "表示定义列表",
"Tables" => "表格",
"col" => "颜色",
"Title bar" => "标题条",
"Multi-page pages" => "多页式页面",
"Non parsed sections" => "不分析的版块",
"Prevents wiki parsing of the enclosed data." => "在封闭的数据块内防止Wiki文档词法分析",
"Preformated sections" => "预格式的版块",
"Block Preformatting" => "预格式的块",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "~pp~...~/pp~ 表示用任意多的空格缩进文本来转换成一个空白块，将一直跟着其他Wiki格式化的说明。它将用同样多的空格缩进。注意，这个模式并不保持精确的空白和断行，",
"No description available" => "没有有效的描述",
"Browse Images" => "浏览图像",
"Edit successful!" => "编辑成功!",
"The following image was successfully edited" => "下列图像已成功编辑",
"Image Description" => "图像描述",
"You can view this image in your browser using" => "你可查看此图像在你的浏览器中使用",
"You can include the image in an HTML page using one of these lines" => "你可用以下之一的代码把这个图像包含在一个HTML页面里",
"Edit or ex/import Languages" => "编辑或导出/导入语言",
"Edit and create Languages" => "编辑或创建语言",
"Edit and create languages" => "编辑和创建语言",
"Create Language" => "创建语言",
"Shortname" => "简称",
"like" => "如同",
"Longname" => "完整名称",
"Select the language to edit" => "选择要编辑的语言",
"Add a translation" => "增加翻译",
"Edit translations" => "编辑一个翻译",
"Translate recorded" => "已记录翻译",
"Translation" => "翻译",
"reset table" => "重设表格",
"Create New Block" => "创建新模块",
"Return to block listing" => "返回模块列表",
"Block description: " => "模块描述： ",
"You are editing block:" => "你正在编辑模块:",
"Publishing date" => "发表日期",
"Publishing Date" => "发表日期",
"Edit question options" => "编辑问题选项",
"List Quizzes" => "列出小测验",
"Quiz Stats" => "小测验统计",
"This Quiz Stats" => "这个小测验的统计",
"Edit this Quiz" => "编辑这个小测验",
"Admin Quizzes" => "管理小测验",
"Create/edit options for question" => "创建/编辑 问题的选项",
"Option" => "选项",
"points" => "分",
"Quiz" => "小测验",
"canRepeat" => "允许重复",
"timeLimit" => "时限",
"Create/edit quizzes" => "增加/编辑 小测验",
"There are individual permissions set for this quiz" => "这个小测验有单独权限设置",
"Quiz can be repeated" => "可重复参加小测验",
"Store quiz results" => "储存小测验结果",
"Immediate feedback" => "立刻反馈",
"Show correct answers" => "显示正确答案",
"Shuffle questions" => "打乱问题",
"Shuffle answers" => "打乱答案",
"Quiz is time limited" => "小测验有时间限制",
"Maximum time" => "最大时间",
"Edit quiz questions" => "编辑小测验问题",
"Create/edit questions for quiz" => "创建/编辑 小测验的选项",
"maxScore" => "最高分数",
"Edit quiz results" => "编辑测验结果",
"From Points" => "从分数",
"To Points" => "到分数",
"Answer" => "回答",
"Modify Structure" => "修改导航结构",
"You will remove" => "将会移除",
"and its subpages from the structure, now you have two options:" => "以及导航结构中的子页面, 你有两个选择:",
"Remove only from structure" => "只从导航结构移除",
"Remove from structure and remove page too" => "从导航结构移除且移除页面",
"Structure Layout" => "导航结构布局",
"Promote" => "升级",
"Demote" => "降级",
"Previous" => "前移",
"Current Node" => "当前节点",
"Page alias" => "页面別名",
"Add pages to current node" => "增加页面到当前节点",
"After page" => "在页面后",
"Create Page" => "创建页面",
"Use pre-existing page" => "使用默认页面",
"Submit article" => "提交文章",
"List Submissions" => "列出投稿",
"Edit templates" => "编辑模板",
"Template listing" => "模版列表",
"Available templates" => "现有模板",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "涂鸦板是一个用来让你练习编辑技巧的页面, 使用预览特性可查看页面的外观, 但是不会保存任何版本改变.",
"Upload picture" => "上传图片",
"Try to convert HTML to wiki" => "尝试将HTML 转换成Wiki",
"Import page" => "导入页面",
"export all versions" => "导出所有版本",
"Year:" => "年:",
"Authors:" => "作者:",
"Manage structures" => "管理导航结构",
"License" => "授权",
"Important" => "要点",
"votes" => "票数",
"status" => "统计",
"lastModif" => "上次修改",
"Admin FAQ" => "管理FAQ",
"List FAQs" => "FAQs列表",
"View FAQ" => "查看FAQ",
"Edit this FAQ" => "编辑这个FAQ",
"New Question" => "新问题",
"Use a question from another FAQ" => "使用来自其他FAQ的问题",
"FAQ questions" => "FAQ问题",
"Suggested questions" => "建议问题",
"No suggested questions" => "无建议的问题",
"Upload File" => "上传文件",
"You can access the file gallery using the following URL" => "你可由下列URL进入这个文件库",
"Admin forums" => "管理论坛",
"Edit queued message" => "编辑队列中的消息",
"make this a thread of" => "设为讨论串",
"None, this is a thread message" => "不, 这不是讨论串",
"summary" => "摘要",
"normal" => "正常",
"announce" => "公布",
"hot" => "热门",
"no feeling" => "没感觉",
"frown" => "皱眉",
"exclaim" => "惊叫",
"idea" => "灵感来了",
"neutral" => "中立",
"question" => "问题",
"happy" => "快乐",
"wink" => "眨眼",
"Save and Approve" => "保存并审核",
"convert to topic" => "切换到主题",
"List of messages" => "消息列表",
"New Topic" => "新主题",
"no summary" => "没有摘要",
"No messages queued yet" => "队列中尚无消息",
"Last Post" => "最近帖子",
"Reported by" => "报告自",
"Pending requests" => "代审请求",
"Request Time" => "请求时间",
"Accept" => "接受",
"Refuse" => "拒绝",
"Waiting requests" => "等候请求",
"Your friends" => "你的朋友",
"Galleries" => "文件库",
"Create New Gallery" => "创建新库",
"Create a gallery" => "创建新库",
"Edit this gallery:" => "编辑此文件库:",
"There are individual permissions set for this gallery" => "这个文件库有独立的权限设置",
"Gallery is visible to non-admin users?" => "允许非管理员用户看到?",
"Available scales" => "可用比例",
"No scales available" => "无可用比例",
"Other users can upload images to this gallery" => "允许其他用户上传图像到此文件库",
"You can access the gallery using the following URL" => "你可经由下列的URL进入此文件库",
"Available Galleries" => "当前所有文件库",
"Imgs" => "图像",
"To" => "收件人",
"Im- Export languages" => "导入/导出语言",
"Select the language to Import" => "选择要导入的语言",
"Select the language to Export" => "选择要导出的语言",
"Overwrite existing pages if the name is the same" => "当名称一样时覆盖写已存在的页面",
"Previously remove existing page versions" => "事先移除已存在的页面版本",
"excerpt" => "引用",
"Result" => "结果",
"Locked" => "锁定",
"Tiki installer" => "Tiki安装程序",
"Database user" => "数据库用户名",
"Install" => "安装",
"Upgrade" => "升级",
"Configure General Settings" => "一般设置",
"MultiTiki" => "多Tiki",
"Last Changes" => "最近变动",
"Search by Date" => "以日期搜索",
"LastChanges" => "最近变动",
"Rollback" => "复原",
"Pages like" => "相似页面",
"No pages found" => "找不到页面",
"Edit New Article" => "编辑新文章",
"View Submissions" => "查看投稿",
"ExpireDate" => "到期日",
"AuthorName" => "作者名称",
"Img" => "图像",
"Create banner" => "创建标语",
"Method" => "方法",
"Use Dates?" => "使用日期?",
"Max Impressions" => "最大次数",
"Impressions" => "次数",
"Clicks" => "点击",
"Create New Blog" => "创建新博客",
"Dynamic content system" => "动态內容系统",
"Available content blocks" => "有效的內容模块",
"Current ver" => "当前版本",
"Next ver" => "下一个版本",
"Program" => "方案",
"Available FAQs" => "现有的FAQ",
"Edit this FAQ:" => "编辑词FAQ：",
"Create new FAQ" => "创建新FAQ",
"Create New FAQ:" => "创建新FAQ：",
"Users can suggest questions" => "允许用户建议问题",
"Create a File Gallery" => "创建下载中心",
"Gallery Images" => "文件库图像",
"Edit Blog" => "编辑博客",
"Blog Title" => "博客标题",
"Edit New Submission" => "编辑新的投稿",
"Survey stats" => "调查结果",
"Last mod" => "最近修改",
"Last author" => "最近加入作者",
"Last version" => "最近版本",
"unlocked" => "解锁",
"Open client window" => "开启客户端窗口",
"Generate HTML" => "生成 HTML",
"Transcripts" => "记录",
"Online operators" => "在线操作员",
"Operator" => "操作员",
"transcripts" => "记录",
"Offline operators" => "离线操作员",
"Add an operator to the system" => "增加系统操作员",
"Operators must be tiki users" => "操作员必须是tiki用户",
"Set as Operator" => "设为操作员",
"Chat started" => "聊天已开始",
"Operator:" => "操作员:",
"Live support:User window" => "在线支持:用户窗口",
"Request live support" => "要求在线支持",
"Request support" => "请求支持",
"Open a support ticket instead" => "改为开启要求标签",
"Your request is being processed" => "你的要求正在处理",
"cancel request and exit" => "取消要求并退出",
"cancel request and leave a message" => "取消要求并留言",
"Live support:Console" => "线上支持:操作台",
"be online" => "在线",
"be offline" => "不在线",
"Support requests" => "支持要求",
"Requested" => "已要求",
"Join" => "加入",
"Support chat transcripts" => "支持聊天记录",
"started" => "已开始",
"reason" => "原因",
"msgs" => "消息",
"Transcript" => "记录",
"Mail-in feature" => "内置邮件特性",
"Prefs" => "使用偏好",
"Daily" => "每日",
"Weekly" => "每周",
"Remove old events" => "移除旧事件",
"duration" => "期间",
"Mini Calendar: Preferences" => "迷你日程表: 个人偏好",
"Calendar Interval in daily view" => "每日查看中的日程表周期",
"Start hour for days" => "每天开始时间",
"End hour for days" => "每天结束时间",
"Reminders" => "提醒",
"no reminders" => "没有提醒",
"Or enter path or URL" => "或 输入路径 或 URL",
"Add Topic" => "增加主题",
"User Galleries" => "我的图像画廊",
"Unread Messages" => "未读消息",
"Tasks" => "任务",
"MyTiki" => "我的Tiki",
"Notepad" => "记事本",
"MyFiles" => "我的文件",
"My Watches" => "我的监视",
"Sent editions" => "发送版本",
"The newsletter was sent to {\$sent} email addresses" => "电子期刊已发送到 {\$sent}电子邮箱地址",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "谢谢你的订阅，你将很快收到一个电子邮件要求确认你的订阅，在你确认订阅之前将不会有电子期刊发送给你。",
"Your email address was removed from the list of subscriptors." => "你的电子邮件地址已从订阅者名单中移除",
"Subscription confirmed!" => "订阅已确认!",
"Subscribe to Newsletter" => "订阅电子期刊",
"Subscribe to this Newsletter" => "订阅",
"Notes" => "注解",
"Write a note" => "写个注解",
"quota" => "配额",
"No notes yet" => "尚无记事",
"Merge selected notes into" => "合并选择的记事到",
"Reading note:" => "阅读注解:",
"List notes" => "注解列表",
"Write note" => "写注解",
"Wiki Create" => "wiki 建立",
"Wiki Overwrite" => "wiki 覆写",
"Assign permissions to " => "授权给 ",
"Assign permissions to this object" => "指定权限给此对象",
"Published" => "发表",
"Passcode to register (not your user password)" => "注册用通过码(并非你的用户密码)",
"Orphan Pages" => "单独页面",
"Browser not supported" => "浏览器不支持",
"Rename" => "更名",
"Slides" => "幻灯片",
"Discuss" => "讨论",
"Attach File" => "附加文件",
"1 File Attached" => "1个附加文件",
"Pick your avatar" => "选择你的头像",
"User Preferences" => "用户偏好",
"Your current avatar" => "你当前的头像",
"reset" => "重新设置",
"Pick avatar from the library" => "从內建头像中选取",
"Pick user Avatar" => "选择用户的头像",
"Hide all" => "隐藏全部",
"Show all" => "显示全部",
"Avatar Image" => "个人头像",
"random" => "随机",
"Upload your own avatar" => "上传你自己的头像",
"Insert" => "插入",
"Average" => "平均",
"View Results" => "查看结果",
"Vote poll" => "投票",
"Other Polls" => "其他投票",
"on:" => "在:",
"Topic image" => "主题图片",
"Viewing blog post" => "查看博客帖子",
"Return to blog" => "返回博客",
"The original document is available at" => "原始文件位于",
"Print multiple pages" => "打印多重页面",
"Add Page" => "添加页面",
"Quiz result stats" => "小测验结果统计",
"Time" => "时间",
"User answers" => "用户答案",
"Stats for quizzes" => "小测验统计",
"taken" => "参加过",
"Av score" => "平均分数",
"Av time" => "平均时间",
"Clear Stats" => "清除统计",
"Stats for this quiz Questions " => "这个测验问题的统计",
"Top 10" => "前 10",
"Top 20" => "前 20",
"Top 50" => "前 50",
"Top 100" => "前 100",
"Received articles" => "收到的文章",
"Edit received article" => "编辑接到的文章",
"Use Image" => "使用图像",
"Image x size" => "图片宽度",
"Image y size" => "图片高度",
"Image name" => "图像名称",
"Accept Article" => "接受文章",
"Site" => "网站",
"Referer stats" => "访问参考统计",
"Last" => "最近",
"Your email could not be validated; make sure you email is correct and click register below." => "你的电子邮箱无法确认; 请确认你的电子邮箱输入正确并按下注册鍵.",
"Register as a new user" => "注册新用户",
"Repeat password" => "再次输入密码",
"A valid email is mandatory to register" => "你必须输入有效的邮箱才能完成注册",
"The following site was added and validation by admin may be needed before appearing on the lists" => "已加入以下站点, 需等待管理员确认后才会显示在列表上",
"You don't have permission to use this feature." => "你无权使用这个特性",
"Please register." => "请注册.",
"Register this site at tikiwiki.org" => "到 tikiwiki.org 注册这个网站",
"Send me my Password" => "寄给我密码",
"Remove page" => "移除页面",
"Last Version" => "最近版本",
"You are about to remove the page" => "你即将刪除此页面",
"permanently" => "永久地",
"Remove all versions of this page" => "移除这个页面的所有版本",
"Rollback page" => "复原页面",
"Searched" => "已搜索",
"Search in" => "搜索于",
"Simple search" => "简单搜索",
"No pages matched the search criteria" => "找不到符合条件的页面",
"This newsletter will be sent to {\$subscribers} email addresses." => "电子期刊已发送到 {\$subscribers}电子邮件地址.",
"Prepare a newsletter to be sent" => "准备将要发送的电子期刊",
"Send objects" => "发送对象",
"Transmission results" => "传送结果",
"Send Wiki Pages" => "发送Wiki页面",
"Send Articles" => "发送文章",
"Add Article" => "加入文章",
"Send objects to this site" => "发送对象到这个网站",
"Create New Sheet" => "创建新表",
"Header Rows" => "第一行",
"Footer Rows" => "最后行",
"Create new Sheet" => "创建新表",
"Available Sheets" => "有效的表",
"Change shoutbox general settings" => "改变布告栏的一般设置",
"auto-link urls" => "自动链接 urls",
"Post or edit a message" => "发表或编辑消息",
"Site Stats" => "网站统计",
"Started" => "开始",
"Days online" => "上线天数",
"Total pageviews" => "全部页面浏览数",
"Average pageviews per day" => "每天平均页面浏览数",
"Best day" => "最好的一天",
"Worst day" => "最差的一天",
"Wiki Stats" => "Wiki文档统计",
"Size of Wiki Pages" => "Wiki页面大小",
"Average page length" => "平均页面长度",
"Average versions per page" => "平均每页版本数",
"Visits to wiki pages" => "Wiki页面访问数",
"Average links per page" => "平均每页链接数",
"Image galleries Stats" => "图像画廊统计",
"Average images per gallery" => "平均文件库图像数",
"Total size of images" => "所有图像大小",
"Average image size" => "平均图像大小",
"Visits to image galleries" => "图像画廊访问数",
"File galleries Stats" => "下载中心统计",
"Average files per gallery" => "文件库平均文件数",
"Total size of files" => "全部文件的总大小",
"Average file size" => "平均文件大小",
"Visits to file galleries" => "下载中心访问数",
"CMS Stats" => "内容管理统计",
"Total reads" => "全部阅读数",
"Average reads per article" => "文章平均阅读数",
"Total articles size" => "全部文章大小",
"Average article size" => "平均文章大小",
"Forum Stats" => "论坛统计",
"Total topics" => "全部主题",
"Average topics per forums" => "论坛平均主题数",
"Visits to forums" => "论坛访问数",
"Blog Stats" => "博客统计",
"Weblogs" => "博客",
"Total posts" => "发帖总数",
"Average posts per weblog" => "博客平均发表数",
"Total size of blog posts" => "博客帖子的总大小",
"Average posts size" => "平均帖子大小",
"Visits to weblogs" => "博客访问数",
"Poll Stats" => "投票统计",
"Total votes" => "总票数",
"Average votes per poll" => "投票平均票数",
"FAQ Stats" => "FAQ统计",
"Total questions" => "全部问题数",
"Average questions per FAQ" => "FAQ平均问题数",
"User Stats" => "用户统计",
"Average bookmarks per user" => "用户平均书签数",
"Average questions per quiz" => "每小测验平均问题数",
"Quizzes taken" => "已参加过的小测验",
"Average quiz score" => "平均小测验分数",
"Average time per quiz" => "每小测验平均回复时间",
"Usage chart" => "使用排行榜",
"Usage chart image" => "使用记录图表",
"Stats for surveys" => "调查结果",
"Last taken" => "最近参加的调查",
"Tiki Logs" => "Tiki日志",
"Time Left" => "剩余时间",
"Send Answers" => "发送答案",
"Your email was sent" => "电子邮件已发送",
"Theme is selected as follows" => "布景主题选择如下",
"If a theme is assigned to the individual object that theme is used." => "如果指定单独对象的布景主题,则使用该主题.",
"If not then if a theme is assigned to the object's category that theme is used" => "如不成立, 那么如果指定对象类别的布景主题, 则使用該主题",
"If not then a theme for the section is used" => "如不成立, 则使用版块的布景主题",
"If none of the above was selected the user theme is used" => "如果以上都没有配置, 则采用用户的布景主题",
"Finally if the user didn't select a theme the default theme is used" => "最后, 如果用户没有配置布景主题, 则使用默认的布景主题",
"Control by Objects" => "由对象控制",
"Control by Sections" => "由版块控制",
"Assign themes to categories" => "指定类别的布景主题",
"Assigned categories" => "已指定的类别",
"Theme Control Center: Objects" => "布景主题控制台: 对象",
"Control by Categories" => "由类别控制",
"Assign themes to objects" => "指定对象的布景主题",
"Assigned objects" => "指定对象",
"Assign themes to sections" => "指定版块的布景主题",
"Assigned sections" => "指定版块",
"The following file was successfully uploaded" => "下列的文件已成功上传",
"You can download this file using" => "你可下传这个文件使用",
"Batch Upload Results" => "批次上传结果",
"Upload successful!" => "上传成功!",
"The following image was successfully uploaded" => "下列图像已成功上传",
"Image ID thumb" => "图像 ID 缩略图",
"You can include the image in an Wiki page using" => "你可以在Wiki页面中包含这个图像，通过使用",
"or use filename" => "或者使用文件名",
"Now enter the image URL" => "输入图像的URL",
"or upload a local image from your disk" => "或从你的磁盘上传图像",
"Batch Upload" => "批次上传",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "缩略图 (选择项, 覆盖自动缩略图生成)",
"You have to create a gallery first!" => "你必须先创建库!",
"User assigned modules" => "用户指定版块",
"Restore defaults" => "恢复默认值",
"act" => "活动",
"Assign module" => "指定版块",
"Column" => "列",
"top" => "顶层",
"Folders" => "资料夹",
"Folder in" => "文件夹于",
"Remove Folder" => "删除资料夹",
"Refresh Cache" => "刷新缓存",
"Admin folders and bookmarks" => "管理资料夹与书签",
"Send me a message" => "发送消息给我",
"Assign Group" => "指定用户组",
"Personal Wiki Page" => "个人Wiki页面",
"Personal Information" => "个人信息",
"Male" => "男",
"Female" => "女",
"Is email public? (uses scrambling to prevent spam)" => "公开电子邮箱? (使用扰乱法以避免垃圾邮件)",
"Does your mail reader need a special charset" => "你的邮件阅读器需要的特殊字符集",
"Account Information" => "帐户信息",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "新密码和确认新密码留空，则保持当前密码",
"Change administrative info" => "改变管理信息",
"Percentage completed" => "完成百分比",
"Completed" => "完成",
"No tasks entered" => "尚未输入任务",
"Monthly" => "每月",
"A user submits an article" => "有用户提交文章",
"May need to refresh twice to see changes" => "可能需要更新两次才看得到改变",
"Add top level bookmarks to menu" => "增加顶层的书签到菜单",
"Add or edit an item" => "增加或编辑一个项目",
"New Window" => "新的窗口",
"replace window" => "取代窗口",
"Pos" => "位置",
"User_versions_for" => "用户定制版本：",
"This page is being edited by" => "此页面被编辑中:",
"Proceed at your own peril" => "请小心进行",
"Banner stats" => "标语统计",
"Create new banner" => "创建新横幅",
"Banner Information" => "标语信息",
"Click ratio" => "点击率",
"Hours" => "小时",
"Weekdays" => "工作日",
"mon" => "一",
"tue" => "二",
"wed" => "三",
"thu" => "四",
"fri" => "五",
"sat" => "六",
"sun" => "日",
"Banner raw data" => "横幅原始资料",
"Cached" => "已缓存",
"This is a cached version of the page." => "这是本页面的缓存版本",
"Click here to view the Google cache of the page instead." => "点击这里查看 Google 缓存的页面.",
"Answers" => "答案",
"Add Suggestion" => "添加建议",
"Forum List" => "论坛列表",
"Edit Forum" => "编辑论坛",
"Summary" => "摘要",
"for links" => "表示链接",
"HTML tags are not allowed inside posts" => "帖子里不允许使用HTML标记",
"Moderator Actions" => "版主命令",
"Move Selected Topics" => "移动选择的主题",
"Unlock Selected Topics" => "解锁选择的主题",
"Lock Selected Topics" => "锁定选择的主题",
"Delete Selected Topics" => "刪除选择的主题",
"Merge" => "合并",
"Merge Selected Topics" => "合并选择的主题",
"Reported Messages:" => "报告的消息:",
"Queued Messages:" => "队列中消息:",
"Merge into topic" => "合并到主题",
"Emot" => "表情",
"pts" => "帖数",
"Announce" => "公布",
"Hot" => "热门",
"No topics yet" => "尚无主题",
"Jump to forum" => "跳转至论坛",
"All posts" => "全部发表",
"Last hour" => "前 1 小时",
"Last 24 hours" => "前 24 小时",
"Last 48 hours" => "前 48 小时",
"prev topic" => "上一主题",
"next topic" => "下一主题",
"Show posts" => "显示发帖数",
"Monitor" => "监控",
"Insert New Item" => "插入新项目",
"Tracker Items" => "跟踪项目",
"Insert new item" => "插入新项目",
"View Item" => "查看项目",
"Add a Comment" => "增加一个评论",
"Clip" => "徊形针",
"Back To Mailbox" => "返回邮件夹",
"Full Headers" => "完整标头",
"Normal Headers" => "一般标头",
"Reply To All" => "全部回复",
"Forward" => "转寄",
"Cc" => "抄送",
"Select from address book" => "从通讯录中选择",
"CC" => "抄送",
"BCC" => "密送",
"Use HTML mail" => "使用 HTML 邮件",
"The following addresses are not in your address book" => "下列地址不在你的通讯录中",
"Add Contacts" => "增加到通讯录",
"Attachment 1" => "附件 1",
"Attachment 2" => "附件 2",
"Attachment 3" => "附件 3",
"Address book" => "通讯录",
"3d browser" => "三维浏览器",
"Save Minor Edit" => "次要",
"Administration" => "系统管理",
"General preferences and settings" => "一般偏好设置",
"Wiki settings" => "Wiki设置",
"Article/CMS settings" => "文集/内容管理设置",
"Poll comments settings" => "投票评论设置",
"Forums settings" => "论坛设置",
"Search settings" => "搜索设置",
"Upload failed" => "上传失败",
"All posted" => "所有帖子",
"Queue anonymous posts" => "保留匿名帖子",
"Queue all posts" => "保留所有帖子",
"No attachments" => "禁止附件",
"Everybody can attach" => "允许任何人附件",
"Only users with attach permission" => "只允许有附件权限的用户",
"Moderators and admin can attach" => "只允许版主与管理员",
"Date (desc)" => "日期 (降序)",
"Date (asc)" => "日期 (升序)",
"Score (desc)" => "分数 (降序)",
"Replies (desc)" => "回复 (降序)",
"Reads (desc)" => "阅读 (降序)",
"Owner" => "所属者",
"Tag already exists" => "标签已经存在",
"Tag not found" => "找不到标签",
"Non-existent link" => "不存在的链接",
"No menu indicated" => "未指定菜单",
"No newsletter indicated" => "未指定电子期刊",
"A user registers" => "有用户注册",
"Any wiki page is changed" => "任何Wiki页面被改变",
"No poll indicated" => "未指定投票",
"Permission denied. You cannot view this page." => "权限不足, 你无法查看此页面",
"Permission denied you cannot edit this page" => "权限不足, 你无法编辑此页面",
"page not added (Exists)" => "未加入页面 (已存在)",
"No survey indicated" => "未指定调查",
"No tracker indicated" => "未指定跟踪",
"Group already exists" => "用户组已经存在",
"User doesn't exist" => "用户不存在",
"No records were found. Check the file please!" => "找不到记录, 请检查文件!",
"User login is required" => "需要用户登录",
"Password is required" => "需要密码",
"Email is required" => "需要电子邮件",
"User is duplicated" => "用户重复",
"password" => "密码",
"Unknown group" => "未知用户组",
"Group doesn't exist" => "用户组不存在",
"Permission denied you cannot view backlinks for this page" => "权限不足, 你无法查看此页面的回退链接",
"The page cannot be found" => "找不到页面",
"It isn't possible to post in any blog. You may need to create a blog first." => "你无法在任何博客中发表帖子, 请先创建一个博客",
"Permission denied you cannot post" => "权限不足, 你无法发表帖子",
"Permission denied you cannot edit this post" => "权限不足, 你无法编辑此帖子",
"Top visited blogs" => "热门博客",
"Last posts" => "最近发表",
"Top active blogs" => "最活跃博客",
"TOP" => "顶层",
"Permission denied you cannot access this gallery" => "你没有存取这个文件库的权限",
"No gallery indicated" => "未指定文件库",
"Permission denied you can not view this section" => "权限不足, 你无法浏览这个版块",
"Permission denied you cannot remove images from this gallery" => "你没有刪除本文件库中图像的权限",
"Permission denied you cannot rebuild thumbnails in this gallery" => "权限不足, 你无法创建此文件库的缩略图",
"Permission denied you cannot rotate images in this gallery" => "权限不足, 你无法旋转此文件库中的图像",
"No image indicated" => "未指定图像",
"Permission denied you cannot move images from this gallery" => "你没有移动本文件库中文件的权限",
"Permission denied you cannot view the calendar" => "权限不足, 你无法使用日程表",
"event without name" => "无名事件",
"Access Denied" => "拒绝访问",
"You can not use the same password again" => "请勿再使用相同的密码",
"Top authors" => "最多产作者",
"Message sent to" => "消息发送到",
"This feature has been disabled" => "这个特性已被关闭",
"Must enter a url to add a site. " => "增加站点时必须输入URL. ",
"Must select a category. " => "必须选择一个类别.",
"Must enter a name to add a site" => "增加站点时必须输入名称",
"Must enter a url to add a site" => "增加站点时必须输入URL",
"URL already added to the directory. Duplicate site?" => "已经加入过此URL了. 是否为重复站点?",
"Must select a category" => "必须选择一个类别.",
"No site indicated" => "未指定站点",
"Article not found" => "找不到文章",
"Permission denied you cannot edit this article" => "你没有权限编辑此文章",
"You do not have permissions to edit banners" => "您没有权限编辑横幅",
"Banner not found" => "找不到横幅",
"You do not have permission to edit this banner" => "您没有权限编辑横幅",
"Permission denied you cannot create or edit blogs" => "权限不足, 你无法创建或编辑博客",
"Permission denied you cannot edit this blog" => "权限不足, 你无法编辑此博客",
"You do not have permission to write the style sheet" => "您没有权限编辑这个样式表",
"Invalid request to edit an image" => "不正确的编辑图像请求",
"Permission denied you cannot edit images" => "权限不足, 你无法编辑图像",
"Permission denied you can edit images but not in this gallery" => "权限不足, 你可编辑图像, 但不得编辑此文件库",
"Failed to edit the image" => "编辑图像失败",
"Permission denied to use this feature" => "权限不足, 无法使用本特性",
"Shortname must be 2 Characters" => "缩写必须是两个字符",
"You must provide a longname" => "必须提供完整名称",
"Language created" => "语言已创建",
"No content id indicated" => "未指定內容编号",
"No question indicated" => "未指定问题",
"No quiz indicated" => "未指定小测验",
"No structure indicated" => "未指定导航结构",
"Permission denied you cannot send submissions" => "权限不足, 你无法发送投稿",
"Permission denied you cannot edit submissions" => "权限不足, 你无法编辑投稿",
"You have to create a topic first" => "你必须先创建主题",
"You do not have permission to do that" => "抱歉，您没有权限",
"You do not have permission to read the template" => "您没有权限读取模板",
"page imported" => "导入的页面",
"created from import" => "从导入创建",
"The SandBox is disabled" => "涂鸦板特性已关闭",
"Cannot edit page because it is locked" => "无法编辑页面, 它正被锁定中",
"Permission denied you cannot edit this file" => "权限不足, 你无法编辑此文件",
"Permission denied you cannot remove files from this gallery" => "权限不足, 你无法移除此文件库中的文件",
"Top visited file galleries" => "最常被浏览下载中心",
"Most downloaded files" => "最多下传文件",
"Last files" => "最近下载文件",
"No forum indicated" => "未指定论坛",
"Last forum topics" => "最近论坛主题",
"Top topics" => "热门主题",
"Forum posts" => "论坛帖子数",
"I have broken our friendship!" => "我已经中断了我们的友谊！",
"You're already friend of %s" => "你 %s 已经是我的网友",
"I have accepted your friendship request!" => "我已经接受了你的交友请求！",
"first image" => "第一张图像",
"last image" => "最末张图像",
"Permission denied you cannot create galleries and so you cant edit them" => "权限不足, 你无法创建和编辑文件库",
"Permission denied you cannot edit this gallery" => "权限不足, 你无法编辑此文件库",
"Permission denied you cannot remove this gallery" => "权限不足, 你无法移除此文件库",
"Top images" => "热门图像",
"Last images" => "最近图像",
"overwriting old page" => "覆盖旧页面",
"page created" => "页面已创建",
"No name indicated for wiki page" => "尚未指定Wiki页面名称",
"Permission denied. You cannot view pages like this page" => "权限不足, 你无法查看此页面的相似页面",
"Permission denied you cannot remove articles" => "你没有权限刪除文章",
"Permission denied you cannot remove banners" => "权限不足, 你无法移除标语",
"Permission denied you cannot remove this blog" => "权限不足, 你无法移除此博客",
"Non-existent gallery" => "不存在的图库",
"Permission denied you can upload files but not to this file gallery" => "权限不足, 你可上传文件, 但不能上传到此文件库",
"Permission denied you can't upload files so you can't edit them" => "权限不足, 你无法上传文件也无法编辑",
"You cannot admin blogs" => "你无法管理博客",
"Permission denied you cannot remove submissions" => "权限不足, 你无法移除投稿",
"Permission denied you cannot approve submissions" => "权限不足, 你无法审核投稿",
"You have to enable cookies to be able to login to this site" => "您必须启用cookie才能正常登陆本站",
"Invalid password" => "密码无效",
"Account disabled" => "您的帐号被禁止",
"You must first setup MapServer" => "你必须首先创建地图服务器",
"mapfile name incorrect" => "地图文件名不正确",
"You dont have permission to do that" => "你没有权限",
"Must be logged to use this feature" => "必须登录才能使用此特性",
"Welcome at Hawiki" => "欢迎来到 Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "本 Tikiwiki 站点是为各种移动设备设计, 例如 WAP 手机, PDA, i-mode 设备等等.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "你可使用移动设备连接到以下的 URL 来浏览本站:",
"About" => "关于",
"You must log in to use this feature" => "你必须登录才能使用此特性",
"You do not have permission to view other users data" => "您没有权限去查看其他用户的资料",
"You must be logged in to subscribe to newsletters" => "你必须登录才能订阅电子期刊",
"No note indicated" => "未指定笔记",
"merged note:" => "合并记事:",
"File is too big" => "文件太大",
"No item indicated" => "未指定任何项目",
"created from notepad" => "从笔记本创建",
"Page already exists" => "页面已存在",
"Not enough information to display this page" => "没有足够信息显示此页面",
"Permission denied you cannot browse this page history" => "你没有查看本页历史的权限",
"No article indicated" => "未指定文章",
"Article is not published yet" => "文章尚未被发表",
"No post indicated" => "未指定帖子",
"Blog not found" => "找不到博客",
"No pages indicated" => "未指定页面",
"No result indicated" => "未指定结果",
"The passwords don't match" => "密码错误",
"Invalid or unknown username" => "无效或错误的用户名",
"A password reminder email has been sent " => "密码提醒Email已发送 ",
"to the registered email address for" => "到注册的电子邮件地址:",
"last version" => "最近版本",
"Permission denied you cannot remove versions from this page" => "你没有移除本页版本的权限",
"Cannot rename page maybe new page already exists" => "无法更名页面, 也许已存在同名页面",
"Non-existent version" => "不存在的版本",
"Permission denied you cannot rollback this page" => "权限不足，您无法复员该页面",
"successfully sent" => "成功发送",
"not sent" => "未发送",
"Page must be defined inside a structure to use this feature" => "页面必须定义在导航结构中才能使用此特性",
"You cannot take this quiz twice" => "你不能重复参加这个小测验",
"Quiz time limit exceeded quiz cannot be computed" => "测验时间期限已过，测验无法被计算",
"You cannot take this survey twice" => "你不能重复参加这个调查",
"Please create a category first" => "请先创建一个类别",
"No permission to upload zipped file packages" => "没有权限上传 zip 压缩的文件包",
"Error processing zipped image package" => "处理 zip 压缩的图像包时发生错误",
"No permission to upload zipped image packages" => "没有权限上传 zip 压缩的图像包",
"Permission denied you cannot upload images" => "你没有上传图像的权限",
"Permission denied you can upload images but not to this gallery" => "你无法在此文件库中上传图像",
"Cannot get image from URL" => "无法从URL取得图像",
"No url indicated" => "未指定url",
"Unknown user" => "未知用户",
"You are not logged in and no user indicated" => "你尚未登录及指定用户",
"The user has chosen to make his information private" => "该用户已选择隐藏自己的用户信息",
"The passwords did not match" => "密码不匹配",
"no" => "否",
"Cannot upload this file not enough quota" => "无法上传文件, 磁盘配额不足",
"No user indicated" => "未指定用户",
"Non-existent user" => "不存在的用户",
"No banner indicated" => "未指定横幅",
"No blog indicated" => "未指定博客",
"Permission denied you cannot remove the post" => "权限不足, 你无法移除此帖子",
"No cache information available" => "无缓存信息",
"No faq indicated" => "未指定FAQ",
"No thread indicated" => "未指定讨论串",
"Aborted" => "放弃",
"Top pages" => "热门页面",
"Last pages" => "最近页面",
"###end###"=>"###end###");
