/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private JTree mTree;
    private TreeTableModel mTreeTableModel;

    public TreeTableModelAdapter(TreeTableModel aTreeTableModel, JTree aTree) {
        this.mTree = aTree;
        this.mTreeTableModel = aTreeTableModel;
        aTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        aTreeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.mTreeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.mTreeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.mTreeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        int rowCount = this.mTree.getRowCount();
        return rowCount;
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.mTree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        return this.mTreeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.mTreeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.mTreeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }
}

