/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_prefs_h
#define __nd_prefs_h

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>

#include <nd.h>

#define ND_DOM_NETDUDE   "netdude"

typedef struct nd_prefs_domain ND_PrefsDomain;

/**
 * nd_prefs_init - initializes preferences.
 */
void           nd_prefs_init(void);

/**
 * nd_prefs_get_plugin_dir_global - returns global plugin directory.
 *
 * The function returns a pointer to static memory containing
 * the name of the system-wide feature plugin directory.
 *
 * Returns: global plugin directory.
 */
const char    *nd_prefs_get_plugin_dir_global(void);

/**
 * nd_prefs_get_plugin_dir_user - returns user's plugin directory.
 *
 * The function returns a pointer to static memory containing
 * the name of the user's feature plugin directory.
 *
 * Returns: user's plugin directory.
 */
const char    *nd_prefs_get_plugin_dir_user(void);

/**
 * nd_prefs_get_proto_dir_global - returns global protocol plugin directory.
 *
 * The function returns a pointer to static memory containing
 * the name of the system-wide protocol plugin directory.
 *
 * Returns: global protocol plugin directory.
 */
const char    *nd_prefs_get_proto_dir_global(void);

/**
 * nd_prefs_get_proto_dir_user - returns user's protocol plugin directory.
 *
 * The function returns a pointer to static memory containing
 * the name of the user's protocol plugin directory.
 *
 * Returns: user's plugin directory.
 */
const char    *nd_prefs_get_proto_dir_user(void);



/**
 * nd_prefs_add_domain - adds a preferences domain to the config system.
 * @domain: the preferences domain to add a GUI to.
 * @container: the GUI container.
 * @gui: the widget itself.
 *
 * The function registers a GUI for a preferences domain. Each domain gets
 * displayed in its own tab in the preferences dialog and is stored
 * with its own prefix in the config file. @container is a widget from
 * which all other preference widgets can be retrieved via
 * gtk_object_get_data(), such as a toplevel window when using Glade.
 * @gui is the widget containing the actual preferences widgets, usually
 * something like a #GtkVBox.
 */
void           nd_prefs_add_domain_gui(LND_PrefsDomain *domain,
				       GtkWidget *container,
				       GtkWidget *gui);

ND_PrefsDomain *nd_prefs_get_domain(LND_PrefsDomain *domain);

/**
 * nd_prefs_dialog_show - shows preferences dialog.
 */
void           nd_prefs_dialog_show(void);

/* GUI callbacks. */
void           nd_prefs_dialog_ok(void);
void           nd_prefs_dialog_apply(void);
void           nd_prefs_dialog_cancel(void);

void           nd_prefs_fontsel_show(void);

/**
 * nd_dialog_sync - syncs preferences dialog to config settings.
 *
 * The function adjusts the  widgets in the preferences dialog
 * to reflect the current config settings.
 */
void           nd_prefs_dialog_sync(void);

void           nd_prefs_select_tcpdump(void);

#endif
