/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.SequenceInputStream;
import org.icepdf.core.io.ZeroPaddedInputStream;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.filters.G4State;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class CCITTFax {
    private static final Logger logger = Logger.getLogger(CCITTFax.class.toString());
    static final String[] _twcodes = new String[]{"00110101", "000111", "0111", "1000", "1011", "1100", "1110", "1111", "10011", "10100", "00111", "01000", "001000", "000011", "110100", "110101", "101010", "101011", "0100111", "0001100", "0001000", "0010111", "0000011", "0000100", "0101000", "0101011", "0010011", "0100100", "0011000", "00000010", "00000011", "00011010", "00011011", "00010010", "00010011", "00010100", "00010101", "00010110", "00010111", "00101000", "00101001", "00101010", "00101011", "00101100", "00101101", "00000100", "00000101", "00001010", "00001011", "01010010", "01010011", "01010100", "01010101", "00100100", "00100101", "01011000", "01011001", "01011010", "01011011", "01001010", "01001011", "00110010", "00110011", "00110100"};
    static final String[] _mwcodes = new String[]{"11011", "10010", "010111", "0110111", "00110110", "00110111", "01100100", "01100101", "01101000", "01100111", "011001100", "011001101", "011010010", "011010011", "011010100", "011010101", "011010110", "011010111", "011011000", "011011001", "011011010", "011011011", "010011000", "010011001", "010011010", "011000", "010011011"};
    static final String[] _tbcodes = new String[]{"0000110111", "010", "11", "10", "011", "0011", "0010", "00011", "000101", "000100", "0000100", "0000101", "0000111", "00000100", "00000111", "000011000", "0000010111", "0000011000", "0000001000", "00001100111", "00001101000", "00001101100", "00000110111", "00000101000", "00000010111", "00000011000", "000011001010", "000011001011", "000011001100", "000011001101", "000001101000", "000001101001", "000001101010", "000001101011", "000011010010", "000011010011", "000011010100", "000011010101", "000011010110", "000011010111", "000001101100", "000001101101", "000011011010", "000011011011", "000001010100", "000001010101", "000001010110", "000001010111", "000001100100", "000001100101", "000001010010", "000001010011", "000000100100", "000000110111", "000000111000", "000000100111", "000000101000", "000001011000", "000001011001", "000000101011", "000000101100", "000001011010", "000001100110", "000001100111"};
    static final String[] _mbcodes = new String[]{"0000001111", "000011001000", "000011001001", "000001011011", "000000110011", "000000110100", "000000110101", "0000001101100", "0000001101101", "0000001001010", "0000001001011", "0000001001100", "0000001001101", "0000001110010", "0000001110011", "0000001110100", "0000001110101", "0000001110110", "0000001110111", "0000001010010", "0000001010011", "0000001010100", "0000001010101", "0000001011010", "0000001011011", "0000001100100", "0000001100101"};
    static final String[] _extmcodes = new String[]{"00000001000", "00000001100", "00000001101", "000000010010", "000000010011", "000000010100", "000000010101", "000000010110", "000000010111", "000000011100", "000000011101", "000000011110", "000000011111"};
    static final String[] _modecodes = new String[]{"0001", "001", "1", "011", "000011", "0000011", "010", "000010", "0000010", "0000001111", "000000001111", "000000000001"};
    static final Code[][] twcodes = CCITTFax.convertStringArrayToCodeArray2D(_twcodes);
    static final Code[][] mwcodes = CCITTFax.convertStringArrayToCodeArray2D(_mwcodes);
    static final Code[][] tbcodes = CCITTFax.convertStringArrayToCodeArray2D(_tbcodes);
    static final Code[][] mbcodes = CCITTFax.convertStringArrayToCodeArray2D(_mbcodes);
    static final Code[][] extmcodes = CCITTFax.convertStringArrayToCodeArray2D(_extmcodes);
    static final Code[][] modecodes = CCITTFax.convertStringArrayToCodeArray2D(_modecodes);
    static int black = 0;
    static int white = 1;
    private static final short TIFF_COMPRESSION_NONE_default = 1;
    private static final short TIFF_COMPRESSION_GROUP3_1D = 2;
    private static final short TIFF_COMPRESSION_GROUP3_2D = 3;
    private static final short TIFF_COMPRESSION_GROUP4 = 4;
    private static final short TIFF_PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO_default = 0;
    private static final short TIFF_PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    private static boolean USE_JAI_IMAGE_LIBRARY = false;

    private static Code[][] convertStringArrayToCodeArray2D(String[] stringArray) {
        int n;
        int n2;
        int n3 = stringArray.length;
        int[] nArray = new int[64];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            int n5 = n4 = stringArray[n2].length();
            nArray[n5] = nArray[n5] + 1;
        }
        for (n2 = nArray.length - 1; n2 > 0 && nArray[n2] == 0; --n2) {
        }
        Code[][] codeArray = new Code[n2 + 1][];
        for (n = 0; n < codeArray.length; ++n) {
            codeArray[n] = new Code[nArray[n]];
        }
        block3: for (n = 0; n < n3; ++n) {
            int n6 = stringArray[n].length();
            Code[] codeArray2 = codeArray[n6];
            for (int i = 0; i < codeArray2.length; ++i) {
                if (codeArray2[i] != null) continue;
                codeArray2[i] = new Code(stringArray[n], n);
                continue block3;
            }
        }
        return codeArray;
    }

    private static int findPositionInTable(Code code, Code[][] codeArray) {
        int n = code.getLength();
        if (n >= codeArray.length) {
            return -1;
        }
        Code[] codeArray2 = codeArray[n];
        if (codeArray2 == null) {
            return -1;
        }
        for (Code code2 : codeArray2) {
            if (!code.equals(code2)) continue;
            return code2.getTablePosition();
        }
        return -1;
    }

    static int findWhite(BitStream bitStream, Code code) throws IOException {
        code.reset();
        while (!bitStream.atEndOfFile()) {
            int n = bitStream.getBits(1);
            code.append(n != 0);
            int n2 = CCITTFax.findPositionInTable(code, twcodes);
            if (n2 >= 0) {
                return n2;
            }
            n2 = CCITTFax.findPositionInTable(code, mwcodes);
            if (n2 >= 0) {
                return (n2 + 1) * 64;
            }
            n2 = CCITTFax.findPositionInTable(code, extmcodes);
            if (n2 < 0) continue;
            return 1792 + n2 * 64;
        }
        bitStream.close();
        return 0;
    }

    static int findBlack(BitStream bitStream, Code code) throws IOException {
        code.reset();
        while (!bitStream.atEndOfFile()) {
            int n = bitStream.getBits(1);
            code.append(n != 0);
            int n2 = CCITTFax.findPositionInTable(code, tbcodes);
            if (n2 >= 0) {
                return n2;
            }
            n2 = CCITTFax.findPositionInTable(code, mbcodes);
            if (n2 >= 0) {
                return (n2 + 1) * 64;
            }
            n2 = CCITTFax.findPositionInTable(code, extmcodes);
            if (n2 < 0) continue;
            return 1792 + n2 * 64;
        }
        bitStream.close();
        return 0;
    }

    static void addRun(int n, G4State g4State, BitStream bitStream) throws IOException {
        g4State.runLength += n;
        g4State.cur[g4State.curIndex++] = g4State.runLength;
        g4State.a0 += n;
        if (g4State.runLength > 0) {
            bitStream.putRunBits(g4State.white ? white : black, g4State.runLength);
        }
        bitStream.close();
        g4State.runLength = 0;
    }

    static int readmode(BitStream bitStream, Code code) throws IOException {
        code.reset();
        while (!bitStream.atEndOfFile()) {
            int n = bitStream.getBits(1);
            code.append(n != 0);
            int n2 = CCITTFax.findPositionInTable(code, modecodes);
            if (n2 < 0) continue;
            return n2;
        }
        bitStream.close();
        return -1;
    }

    static void detectB1(G4State g4State) {
        if (g4State.curIndex != 0) {
            while (g4State.b1 <= g4State.a0 && g4State.b1 < g4State.width) {
                int n = g4State.ref[g4State.refIndex] + g4State.ref[g4State.refIndex + 1];
                if (n == 0) {
                    g4State.b1 = g4State.width;
                }
                g4State.b1 += n;
                if (g4State.refIndex + 2 >= g4State.ref.length) continue;
                g4State.refIndex += 2;
            }
        }
    }

    static void decodePass(G4State g4State) {
        CCITTFax.detectB1(g4State);
        g4State.b1 += g4State.ref[g4State.refIndex++];
        g4State.runLength += g4State.b1 - g4State.a0;
        g4State.a0 = g4State.b1;
        g4State.b1 += g4State.ref[g4State.refIndex++];
    }

    static void decodeHorizontal(BitStream bitStream, BitStream bitStream2, G4State g4State, Code code) throws IOException {
        int n = 0;
        do {
            int n2 = n = g4State.white ? CCITTFax.findWhite(bitStream, code) : CCITTFax.findBlack(bitStream, code);
            if (n >= 0) {
                if (n < 64) {
                    CCITTFax.addRun(n + g4State.longrun, g4State, bitStream2);
                    g4State.white = !g4State.white;
                    g4State.longrun = 0;
                    continue;
                }
                g4State.longrun += n;
                continue;
            }
            CCITTFax.addRun(n, g4State, bitStream2);
        } while (n >= 64);
        bitStream2.close();
    }

    static void resetRuns(BitStream bitStream, G4State g4State) throws IOException {
        int n;
        g4State.white = true;
        CCITTFax.addRun(0, g4State, bitStream);
        if (g4State.a0 != g4State.width) {
            while (g4State.a0 > g4State.width) {
                g4State.a0 -= g4State.cur[--g4State.curIndex];
            }
            if (g4State.a0 < g4State.width) {
                if (g4State.a0 < 0) {
                    g4State.a0 = 0;
                }
                if ((g4State.curIndex & 1) != 0) {
                    CCITTFax.addRun(0, g4State, bitStream);
                }
                CCITTFax.addRun(g4State.width - g4State.a0, g4State, bitStream);
            } else if (g4State.a0 > g4State.width) {
                CCITTFax.addRun(g4State.width, g4State, bitStream);
                CCITTFax.addRun(0, g4State, bitStream);
            }
        }
        int[] nArray = g4State.ref;
        g4State.ref = g4State.cur;
        g4State.cur = nArray;
        for (n = g4State.curIndex; n < g4State.width; ++n) {
            g4State.ref[n] = 0;
        }
        for (n = 0; n < g4State.width; ++n) {
            g4State.cur[n] = 0;
        }
        g4State.runLength = 0;
        g4State.a0 = 0;
        g4State.b1 = g4State.ref[0];
        g4State.refIndex = 1;
        g4State.curIndex = 0;
        bitStream.close();
    }

    public static void Group4Decode(InputStream inputStream, OutputStream outputStream, int n, boolean bl) {
        BitStream bitStream = new BitStream(inputStream);
        BitStream bitStream2 = new BitStream(outputStream);
        black = 0;
        white = 1;
        if (bl) {
            black = 1;
            white = 0;
        }
        Code code = new Code();
        try {
            G4State g4State = new G4State(n);
            block14: while (!bitStream.atEndOfFile()) {
                int n2 = CCITTFax.readmode(bitStream, code);
                switch (n2) {
                    case 0: {
                        CCITTFax.decodePass(g4State);
                        continue block14;
                    }
                    case 1: {
                        CCITTFax.decodeHorizontal(bitStream, bitStream2, g4State, code);
                        CCITTFax.decodeHorizontal(bitStream, bitStream2, g4State, code);
                        CCITTFax.detectB1(g4State);
                        break;
                    }
                    case 2: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0, g4State, bitStream2);
                        g4State.white = !g4State.white;
                        g4State.b1 += g4State.ref[g4State.refIndex++];
                        break;
                    }
                    case 3: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 + 1, g4State, bitStream2);
                        g4State.white = !g4State.white;
                        g4State.b1 += g4State.ref[g4State.refIndex++];
                        break;
                    }
                    case 4: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 + 2, g4State, bitStream2);
                        g4State.white = !g4State.white;
                        g4State.b1 += g4State.ref[g4State.refIndex++];
                        break;
                    }
                    case 5: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 + 3, g4State, bitStream2);
                        g4State.white = !g4State.white;
                        g4State.b1 += g4State.ref[g4State.refIndex++];
                        break;
                    }
                    case 6: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 - 1, g4State, bitStream2);
                        boolean bl2 = g4State.white = !g4State.white;
                        if (g4State.refIndex <= 0) break;
                        g4State.b1 -= g4State.ref[--g4State.refIndex];
                        break;
                    }
                    case 7: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 - 2, g4State, bitStream2);
                        boolean bl3 = g4State.white = !g4State.white;
                        if (g4State.refIndex <= 0) break;
                        g4State.b1 -= g4State.ref[--g4State.refIndex];
                        break;
                    }
                    case 8: {
                        CCITTFax.detectB1(g4State);
                        CCITTFax.addRun(g4State.b1 - g4State.a0 - 3, g4State, bitStream2);
                        boolean bl4 = g4State.white = !g4State.white;
                        if (g4State.refIndex <= 0) break;
                        g4State.b1 -= g4State.ref[--g4State.refIndex];
                        break;
                    }
                    case 11: {
                        CCITTFax.resetRuns(bitStream2, g4State);
                        break;
                    }
                }
                if (g4State.a0 < g4State.width) continue;
                CCITTFax.resetRuns(bitStream2, g4State);
            }
            bitStream.close();
            bitStream2.close();
            inputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BufferedImage attemptDeriveBufferedImageFromBytes(Stream stream, Library library, Hashtable hashtable, Color color) {
        if (!USE_JAI_IMAGE_LIBRARY) {
            return null;
        }
        boolean bl = stream.isImageMask();
        Vector vector = (Vector)library.getObject(hashtable, "Decode");
        Hashtable hashtable2 = library.getDictionary(hashtable, "DecodeParms");
        Boolean bl2 = stream.getBlackIs1OrNull(library, hashtable2);
        float f = library.getFloat(hashtable2, "K");
        boolean bl3 = false;
        InputStream inputStream = stream.getInputStreamForDecodedStreamBytes();
        if (inputStream == null) {
            return null;
        }
        inputStream = new ZeroPaddedInputStream(inputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        bufferedInputStream.mark(4);
        try {
            int n = bufferedInputStream.read();
            int n2 = bufferedInputStream.read();
            bufferedInputStream.reset();
            if (n < 0 || n2 < 0) {
                inputStream.close();
                return null;
            }
            bl3 = n == 77 && n2 == 77 || n == 73 && n2 == 73;
        }
        catch (IOException iOException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return null;
        }
        inputStream = bufferedInputStream;
        BufferedImage bufferedImage = null;
        byte[] byArray = null;
        if (!bl3) {
            int n;
            byArray = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 12, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 3, 0, 3, 0, 0, 0, 1, 0, 1, 0, 0, 1, 6, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 0, -82, 1, 22, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 26, 0, 5, 0, 0, 0, 1, 0, 0, 0, -98, 1, 27, 0, 5, 0, 0, 0, 1, 0, 0, 0, -90, 1, 40, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};
            boolean bl4 = false;
            boolean bl5 = false;
            if (bl2 != null) {
                bl5 = bl2;
                bl4 = true;
            }
            int n3 = library.getInt(hashtable, "Width");
            int n4 = library.getInt(hashtable, "Height");
            Object object = library.getObject(hashtable2, "Columns");
            if (object != null && object instanceof Number && (n = ((Number)object).intValue()) > n3) {
                n3 = n;
            }
            Utils.setIntIntoByteArrayBE(n3, byArray, 30);
            Utils.setIntIntoByteArrayBE(n4, byArray, 42);
            Object object2 = library.getObject(hashtable, "BitsPerComponent");
            if (object2 != null && object2 instanceof Number) {
                Utils.setShortIntoByteArrayBE(((Number)object2).shortValue(), byArray, 54);
            }
            short s = 1;
            if (f < 0.0f) {
                s = 4;
            } else if (f > 0.0f) {
                s = 3;
            } else if (f == 0.0f) {
                s = 2;
            }
            Utils.setShortIntoByteArrayBE(s, byArray, 66);
            short s2 = 0;
            if (bl4 && !bl5) {
                s2 = 1;
            }
            Utils.setShortIntoByteArrayBE(s2, byArray, 78);
            Utils.setIntIntoByteArrayBE(n4, byArray, 102);
            int n5 = 0x7FFFFFFE;
            Object object3 = library.getObject(hashtable, "Length");
            if (object3 != null && object3 instanceof Number) {
                n5 = ((Number)object3).intValue();
            } else {
                int n6 = n3 * n4;
                if (n6 > 0) {
                    n5 = n6;
                }
            }
            Utils.setIntIntoByteArrayBE(n5, byArray, 114);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream);
            bufferedImage = CCITTFax.deriveBufferedImageFromTIFFBytes(sequenceInputStream, library, n5, n3, n4);
            if (bufferedImage == null) {
                for (int i = 1; i <= 2; ++i) {
                    if ((s = (short)((short)(s + 1))) > 4) {
                        s = 2;
                    }
                    Utils.setShortIntoByteArrayBE(s, byArray, 66);
                    inputStream = stream.getInputStreamForDecodedStreamBytes();
                    if (inputStream == null) {
                        return null;
                    }
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    sequenceInputStream = new SequenceInputStream(byteArrayInputStream, inputStream = new ZeroPaddedInputStream(inputStream));
                    bufferedImage = CCITTFax.deriveBufferedImageFromTIFFBytes(sequenceInputStream, library, n5, n3, n4);
                    if (bufferedImage == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n = library.getInt(hashtable, "Width");
            int n7 = library.getInt(hashtable, "Height");
            int n8 = n * n7;
            bufferedImage = CCITTFax.deriveBufferedImageFromTIFFBytes(inputStream, library, n8, n, n7);
        }
        if (bufferedImage != null) {
            bufferedImage = CCITTFax.applyImageMaskAndDecodeArray(bufferedImage, bl, bl2, vector, color);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage deriveBufferedImageFromTIFFBytes(InputStream inputStream, Library library, int n, int n2, int n3) {
        BufferedImage bufferedImage = null;
        try {
            library.memoryManager.checkMemory(n);
            Class<?> clazz = Class.forName("com.sun.media.jai.codec.SeekableStream");
            Method method = clazz.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
            Object object = method.invoke(null, inputStream, Boolean.TRUE);
            ParameterBlock parameterBlock = new ParameterBlock();
            parameterBlock.add(object);
            Class<?> clazz2 = Class.forName("javax.media.jai.JAI");
            Method method2 = clazz2.getMethod("create", String.class, ParameterBlock.class);
            Object object2 = method2.invoke(null, "tiff", parameterBlock);
            if (object2 != null) {
                library.memoryManager.checkMemory(Math.max(n * 60, (int)((double)(n2 * n3) * 0.15)));
                RenderedImage renderedImage = (RenderedImage)object2;
                Raster raster = renderedImage.getTile(0, 0);
                if (raster instanceof WritableRaster) {
                    library.memoryManager.checkMemory(1024);
                    ColorModel colorModel = renderedImage.getColorModel();
                    bufferedImage = new BufferedImage(colorModel, (WritableRaster)raster, false, null);
                } else {
                    library.memoryManager.checkMemory((int)((double)(n2 * n3) * 2.5));
                    Class<?> clazz3 = Class.forName("javax.media.jai.RenderedOp");
                    Method method3 = clazz3.getMethod("getAsBufferedImage", new Class[0]);
                    bufferedImage = (BufferedImage)method3.invoke(object2, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            bufferedImage = null;
            logger.log(Level.FINE, "deriveBufferedImageFromTIFFBytes() : Could not derive image from data bytes: ", throwable);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bufferedImage;
    }

    private static BufferedImage applyImageMaskAndDecodeArray(BufferedImage bufferedImage, boolean bl, Boolean bl2, Vector vector, Color color) {
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() == 1) {
            boolean bl3;
            boolean bl4 = vector == null || 0.0f == ((Number)vector.elementAt(0)).floatValue();
            boolean bl5 = bl3 = bl2 == null && !bl4 || bl2 != null && bl2 != false && vector == null;
            if (bl) {
                int n = 0xFFFFFF;
                int[] nArray = new int[]{bl3 ? color.getRGB() : n, bl3 ? n : color.getRGB()};
                int n2 = bl3 ? 1 : 0;
                IndexColorModel indexColorModel = new IndexColorModel(colorModel.getPixelSize(), nArray.length, nArray, 0, true, n2, colorModel.getTransferType());
                bufferedImage = new BufferedImage(indexColorModel, bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), null);
            } else {
                int[] nArray = new int[]{bl3 ? -16777216 : -1, bl3 ? -1 : -16777216};
                IndexColorModel indexColorModel = new IndexColorModel(colorModel.getPixelSize(), nArray.length, nArray, 0, false, -1, colorModel.getTransferType());
                bufferedImage = new BufferedImage(indexColorModel, bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), null);
            }
        }
        return bufferedImage;
    }

    static {
        try {
            Class<?> clazz = Class.forName("javax.media.jai.JAI");
            if (clazz != null) {
                USE_JAI_IMAGE_LIBRARY = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Code {
        private long value = 0L;
        private int length = 0;
        private int tablePosition;

        public Code() {
        }

        public Code(String string, int n) {
            this.tablePosition = n;
            for (int i = 0; i < string.length(); ++i) {
                this.append(string.charAt(i) == '1');
            }
        }

        public final void append(boolean bl) {
            if (bl && this.length <= 63) {
                long l = 1L << this.length;
                this.value |= l;
            }
            ++this.length;
        }

        public final boolean equals(Object object) {
            if (object instanceof Code) {
                Code code = (Code)object;
                return this.value == code.value && this.length == code.length;
            }
            return false;
        }

        public final void reset() {
            this.value = 0L;
            this.length = 0;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getTablePosition() {
            return this.tablePosition;
        }
    }
}

