/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.ofont.OFont;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class FontFactory {
    private static final Logger logger = Logger.getLogger(FontFactory.class.toString());
    private static boolean awtFontLoading = Defs.sysPropertyBoolean("org.icepdf.core.awtFontLoading", false);
    private static boolean awtFontSubstitution;
    public static final int FONT_OPEN_TYPE = 5;
    public static final int FONT_TRUE_TYPE = 0;
    public static final int FONT_TYPE_0 = 6;
    public static final int FONT_TYPE_1 = 1;
    public static final int FONT_TYPE_3 = 7;
    private static FontFactory fontFactory;
    private static final String FONT_CLASS = "org.icepdf.core.pobjects.fonts.nfont.Font";
    private static final String NFONT_CLASS = "org.icepdf.core.pobjects.fonts.nfont.NFont";
    private static final String NFONT_OPEN_TYPE = "org.icepdf.core.pobjects.fonts.nfont.NFontOpenType";
    private static final String NFONT_TRUE_TYPE = "org.icepdf.core.pobjects.fonts.nfont.NFontTrueType";
    private static final String NFONT_TRUE_TYPE_0 = "org.icepdf.core.pobjects.fonts.nfont.NFontType0";
    private static final String NFONT_TRUE_TYPE_1 = "org.icepdf.core.pobjects.fonts.nfont.NFontType1";
    private static final String NFONT_TRUE_TYPE_3 = "org.icepdf.core.pobjects.fonts.nfont.NFontType3";
    private static boolean foundNFont;

    public static FontFactory getInstance() {
        if (fontFactory == null) {
            fontFactory = new FontFactory();
        }
        return fontFactory;
    }

    private FontFactory() {
    }

    public Font getFont(Library library, Hashtable hashtable) {
        Font font = null;
        if (this.foundFontEngine()) {
            try {
                Class<?> clazz = Class.forName(FONT_CLASS);
                Class[] classArray = new Class[]{Library.class, Hashtable.class};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                Object[] objectArray = new Object[]{library, hashtable};
                font = (Font)constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Could not load font dictionary class", throwable);
            }
        } else {
            font = new org.icepdf.core.pobjects.fonts.ofont.Font(library, hashtable);
        }
        return font;
    }

    public FontFile createFontFile(Stream stream, int n) {
        FontFile fontFile;
        block15: {
            fontFile = null;
            if (this.foundFontEngine()) {
                try {
                    Class clazz = this.getNFontClass(n);
                    if (clazz == null) break block15;
                    Class[] classArray = new Class[]{byte[].class};
                    Constructor constructor = clazz.getDeclaredConstructor(classArray);
                    Object[] objectArray = new Object[]{stream.getBytes()};
                    if (stream.getBytes().length > 0) {
                        fontFile = (FontFile)constructor.newInstance(objectArray);
                    }
                }
                catch (Throwable throwable) {
                    logger.log(Level.FINE, "Could not create instance oof font file " + n, throwable);
                }
            } else if (awtFontLoading) {
                InputStream inputStream = null;
                try {
                    inputStream = stream.getInputStreamForDecodedStreamBytes();
                    java.awt.Font font = java.awt.Font.createFont(n, inputStream);
                    if (font != null) {
                        fontFile = new OFont(font);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Successfully created embedded OFont: " + this.fontTypeToString(n));
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            logger.log(Level.FINE, "Error closing font stream.", iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.log(Level.FINE, "Error reading font file with ", throwable);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        logger.log(Level.FINE, "Error closing font stream.", throwable);
                    }
                }
            }
        }
        return fontFile;
    }

    public FontFile createFontFile(File file, int n) {
        FontFile fontFile = null;
        if (this.foundFontEngine()) {
            try {
                Class clazz = this.getNFontClass(n);
                if (clazz != null) {
                    Class[] classArray = new Class[]{URL.class};
                    Constructor constructor = clazz.getDeclaredConstructor(classArray);
                    Object[] objectArray = new Object[]{file.toURL()};
                    fontFile = (FontFile)constructor.newInstance(objectArray);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Could not create instance oof font file " + n, throwable);
            }
        } else {
            try {
                java.awt.Font font = java.awt.Font.createFont(n, file);
                if (font != null) {
                    fontFile = new OFont(font);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Successfully loaded OFont: " + file.toURL());
                    }
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Error ready font file with ", throwable);
            }
        }
        return fontFile;
    }

    public boolean isAwtFontSubstitution() {
        return awtFontSubstitution;
    }

    public void setAwtFontSubstitution(boolean bl) {
        awtFontSubstitution = bl;
    }

    public void toggleAwtFontSubstitution() {
        awtFontSubstitution = !awtFontSubstitution;
    }

    private Class getNFontClass(int n) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (5 == n) {
            clazz = Class.forName(NFONT_OPEN_TYPE);
        } else if (0 == n) {
            clazz = Class.forName(NFONT_TRUE_TYPE);
        } else if (6 == n) {
            clazz = Class.forName(NFONT_TRUE_TYPE_0);
        } else if (1 == n) {
            clazz = Class.forName(NFONT_TRUE_TYPE_1);
        } else if (7 == n) {
            clazz = Class.forName(NFONT_TRUE_TYPE_3);
        }
        return clazz;
    }

    private String fontTypeToString(int n) {
        if (n == 5) {
            return "Open Type Font";
        }
        if (n == 0) {
            return "True Type Font";
        }
        if (n == 6) {
            return "Type 0 Font";
        }
        if (n == 1) {
            return "Type 1 Font";
        }
        if (n == 7) {
            return "Type 3 Font";
        }
        return "unkown font type: " + n;
    }

    public boolean foundFontEngine() {
        try {
            Class.forName(NFONT_CLASS);
            foundNFont = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return foundNFont && !awtFontSubstitution;
    }

    static {
        try {
            Class.forName(NFONT_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.FINE, "NFont font library was not found on the class path");
        }
    }
}

