/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-query.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_SYMBOL_QUERY_H_
#define _IANJUTA_SYMBOL_QUERY_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-iterable.h>
#include <libanjuta/interfaces/ianjuta-symbol.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_SYMBOL_QUERY (ianjuta_symbol_query_get_type ())
#define IANJUTA_SYMBOL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_SYMBOL_QUERY, IAnjutaSymbolQuery))
#define IANJUTA_IS_SYMBOL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_SYMBOL_QUERY))
#define IANJUTA_SYMBOL_QUERY_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_SYMBOL_QUERY, IAnjutaSymbolQueryIface))

#define IANJUTA_TYPE_SYMBOL_QUERY_DB (ianjuta_symbol_query_db_get_type())
#define IANJUTA_TYPE_SYMBOL_QUERY_FILE_SCOPE (ianjuta_symbol_query_file_scope_get_type())
#define IANJUTA_TYPE_SYMBOL_QUERY_MODE (ianjuta_symbol_query_mode_get_type())
#define IANJUTA_TYPE_SYMBOL_QUERY_NAME (ianjuta_symbol_query_name_get_type())

#define IANJUTA_SYMBOL_QUERY_ERROR ianjuta_symbol_query_error_quark()

typedef struct _IAnjutaSymbolQuery IAnjutaSymbolQuery;
typedef struct _IAnjutaSymbolQueryIface IAnjutaSymbolQueryIface;

/**
 * IAnjutaSymbolQueryDb:
 * @IANJUTA_SYMBOL_QUERY_DB_PROJECT: Select project database.
 * @IANJUTA_SYMBOL_QUERY_DB_SYSTEM: Select system database.
 *
 * Sets the database to use for the query. System database is where
 * all system library symbols are found. While project database is where
 * currently open project's symbols are found.
 */
typedef enum {
	IANJUTA_SYMBOL_QUERY_DB_PROJECT,
	IANJUTA_SYMBOL_QUERY_DB_SYSTEM
} IAnjutaSymbolQueryDb;

/**
 * IAnjutaSymbolQueryFileScope:
 * @IANJUTA_SYMBOL_QUERY_SEARCH_FS_IGNORE: Ignore file scope
 * @IANJUTA_SYMBOL_QUERY_SEARCH_FS_PUBLIC: Only public symbols visible to rest of project.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_FS_PRIVATE: Only private symbols visible inside a file.
 *
 * Defines file scope of symbols to query.
 */
typedef enum {
	IANJUTA_SYMBOL_QUERY_SEARCH_FS_IGNORE,
	IANJUTA_SYMBOL_QUERY_SEARCH_FS_PUBLIC,
	IANJUTA_SYMBOL_QUERY_SEARCH_FS_PRIVATE
} IAnjutaSymbolQueryFileScope;

/**
 * IAnjutaSymbolQueryMode:
 * @IANJUTA_SYMBOL_QUERY_MODE_SYNC: Syncronous query. The result is immediately
 *     available as retrun value of search call.
 * @IANJUTA_SYMBOL_QUERY_MODE_ASYNC: Asynchronous query. The search call
 *     return immediately and result delievered as a signal later. The actual
 *     query is done in a separate thread.
 * @IANJUTA_SYMBOL_QUERY_MODE_QUEUED: If the database is busy
 *     scanning, then the query is performed later when database is ready.
 *     It returns NULL and result is delivered through async-result signal.
 *     Only query can stay queued, so calling search multiple times would
 *     result in only the last one being active.
 *
 * This parameter determines the mode of query execution. By default,
 * IANJUTA_SYMBOL_QUERY_MODE_SYNC is selected.
 */
typedef enum {
	IANJUTA_SYMBOL_QUERY_MODE_SYNC,
	IANJUTA_SYMBOL_QUERY_MODE_ASYNC,
	IANJUTA_SYMBOL_QUERY_MODE_QUEUED
} IAnjutaSymbolQueryMode;

/**
 * IAnjutaSymbolQueryName:
 * @IANJUTA_SYMBOL_QUERY_SEARCH: Query to perform basic substring search.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_ALL: Query to get all symbols
 * @IANJUTA_SYMBOL_QUERY_SEARCH_FILE: Query to perform substring search in a file.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_IN_SCOPE: Query to perform substring search in a scope.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_ID: Query to find the symbol of given ID.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_MEMBERS: Query to find members of a scope (eg. class).
 * @IANJUTA_SYMBOL_QUERY_SEARCH_CLASS_PARENTS: Query to get parents of a class.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_SCOPE: Query to find scope name of a file position.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE: Query to get the parent scope of a symbol.
 * @IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE_FILE: Query to get the parent scope of a symbol in the file.
 *
 * Names of query that defined what kind of query it is.
 */
typedef enum {
	IANJUTA_SYMBOL_QUERY_SEARCH,
	IANJUTA_SYMBOL_QUERY_SEARCH_ALL,
	IANJUTA_SYMBOL_QUERY_SEARCH_FILE,
	IANJUTA_SYMBOL_QUERY_SEARCH_IN_SCOPE,
	IANJUTA_SYMBOL_QUERY_SEARCH_ID,
	IANJUTA_SYMBOL_QUERY_SEARCH_MEMBERS,
	IANJUTA_SYMBOL_QUERY_SEARCH_CLASS_PARENTS,
	IANJUTA_SYMBOL_QUERY_SEARCH_SCOPE,
	IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE,
	IANJUTA_SYMBOL_QUERY_SEARCH_PARENT_SCOPE_FILE
} IAnjutaSymbolQueryName;


struct _IAnjutaSymbolQueryIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*async_result) (IAnjutaSymbolQuery *obj, GObject* result);

	void (*cancel) (IAnjutaSymbolQuery *obj, GError **err);
	IAnjutaIterable* (*search) (IAnjutaSymbolQuery *obj, const gchar *pattern, GError **err);
	IAnjutaIterable* (*search_all) (IAnjutaSymbolQuery *obj, GError **err);
	IAnjutaIterable* (*search_class_parents) (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);
	IAnjutaIterable* (*search_file) (IAnjutaSymbolQuery *obj, const gchar *pattern,  const GFile *file, GError **err);
	IAnjutaIterable* (*search_id) (IAnjutaSymbolQuery *obj, gint symbol_id, GError **err);
	IAnjutaIterable* (*search_in_scope) (IAnjutaSymbolQuery *obj, const gchar *pattern,  IAnjutaSymbol *scope, GError **err);
	IAnjutaIterable* (*search_members) (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);
	IAnjutaIterable* (*search_parent_scope) (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);
	IAnjutaIterable* (*search_parent_scope_file) (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol,  const gchar *file_path, GError **err);
	IAnjutaIterable* (*search_scope) (IAnjutaSymbolQuery *obj, const gchar *file_path,  gint line, GError **err);
	void (*set_fields) (IAnjutaSymbolQuery *obj, gint n_fields,  IAnjutaSymbolField *fields, GError **err);
	void (*set_file_scope) (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryFileScope filescope_search, GError **err);
	void (*set_filters) (IAnjutaSymbolQuery *obj, IAnjutaSymbolType filters,  gboolean includes_types, GError **err);
	void (*set_group_by) (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err);
	void (*set_limit) (IAnjutaSymbolQuery *obj, gint limit, GError **err);
	void (*set_mode) (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryMode mode, GError **err);
	void (*set_offset) (IAnjutaSymbolQuery *obj, gint offset, GError **err);
	void (*set_order_by) (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err);

};

GType ianjuta_symbol_query_db_get_type (void);
GType ianjuta_symbol_query_file_scope_get_type (void);
GType ianjuta_symbol_query_mode_get_type (void);
GType ianjuta_symbol_query_name_get_type (void);

GQuark ianjuta_symbol_query_error_quark     (void);
GType  ianjuta_symbol_query_get_type        (void);

void ianjuta_symbol_query_cancel (IAnjutaSymbolQuery *obj, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search (IAnjutaSymbolQuery *obj, const gchar *pattern, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_all (IAnjutaSymbolQuery *obj, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_class_parents (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_file (IAnjutaSymbolQuery *obj, const gchar *pattern,  const GFile *file, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_id (IAnjutaSymbolQuery *obj, gint symbol_id, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_in_scope (IAnjutaSymbolQuery *obj, const gchar *pattern,  IAnjutaSymbol *scope, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_members (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_parent_scope (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_parent_scope_file (IAnjutaSymbolQuery *obj, IAnjutaSymbol *symbol,  const gchar *file_path, GError **err);

IAnjutaIterable* ianjuta_symbol_query_search_scope (IAnjutaSymbolQuery *obj, const gchar *file_path,  gint line, GError **err);

void ianjuta_symbol_query_set_fields (IAnjutaSymbolQuery *obj, gint n_fields,  IAnjutaSymbolField *fields, GError **err);

void ianjuta_symbol_query_set_file_scope (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryFileScope filescope_search, GError **err);

void ianjuta_symbol_query_set_filters (IAnjutaSymbolQuery *obj, IAnjutaSymbolType filters,  gboolean includes_types, GError **err);

void ianjuta_symbol_query_set_group_by (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err);

void ianjuta_symbol_query_set_limit (IAnjutaSymbolQuery *obj, gint limit, GError **err);

void ianjuta_symbol_query_set_mode (IAnjutaSymbolQuery *obj, IAnjutaSymbolQueryMode mode, GError **err);

void ianjuta_symbol_query_set_offset (IAnjutaSymbolQuery *obj, gint offset, GError **err);

void ianjuta_symbol_query_set_order_by (IAnjutaSymbolQuery *obj, IAnjutaSymbolField field, GError **err);


G_END_DECLS

#endif
