/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.result.ResultDiskBuffer;
import org.h2.result.ResultInterface;
import org.h2.result.SortOrder;
import org.h2.util.ObjectArray;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class LocalResult
implements ResultInterface {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ObjectArray rows;
    private SortOrder sort;
    private ValueHashMap distinctRows;
    private Value[] currentRow;
    private int[] displaySizes;
    private ResultDiskBuffer disk;
    private int diskOffset;
    private boolean isUpdateCount;
    private int updateCount;

    public LocalResult(int updateCount) {
        this.isUpdateCount = true;
        this.updateCount = updateCount;
    }

    public boolean isUpdateCount() {
        return this.isUpdateCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public LocalResult(Session session, ObjectArray cols, int visibleColumnCount) {
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : session.getDatabase().getMaxMemoryRows();
        this.expressions = new Expression[cols.size()];
        cols.toArray(this.expressions);
        this.displaySizes = new int[cols.size()];
        this.rows = new ObjectArray();
        this.visibleColumnCount = visibleColumnCount;
        this.rowId = -1;
    }

    public void setSortOrder(SortOrder sort) {
        this.sort = sort;
    }

    public void setDistinct() {
        this.distinctRows = new ValueHashMap(this.session.getDatabase());
    }

    public void removeDistinct(Value[] values) throws SQLException {
        if (this.distinctRows == null) {
            throw Message.internal();
        }
        ValueArray array = ValueArray.get(values);
        this.distinctRows.remove(array);
        this.rowCount = this.distinctRows.size();
    }

    public boolean containsDistinct(Value[] values) throws SQLException {
        if (this.distinctRows == null) {
            throw Message.internal();
        }
        ValueArray array = ValueArray.get(values);
        return this.distinctRows.get(array) != null;
    }

    public void reset() throws SQLException {
        this.rowId = -1;
        if (this.disk != null) {
            this.disk.reset();
            if (this.diskOffset > 0) {
                for (int i = 0; i < this.diskOffset; ++i) {
                    this.disk.next();
                }
            }
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() throws SQLException {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.disk != null ? this.disk.next() : (Value[])this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public void addRow(Value[] values) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            int size = v.getDisplaySize();
            this.displaySizes[i] = Math.max(this.displaySizes[i], size);
        }
        if (this.distinctRows != null) {
            ValueArray array = ValueArray.get(values);
            this.distinctRows.put(array, values);
            this.rowCount = this.distinctRows.size();
            return;
        }
        this.rows.add(values);
        ++this.rowCount;
        if (this.rows.size() > this.maxMemoryRows && this.session.getDatabase().isPersistent()) {
            if (this.disk == null) {
                this.disk = new ResultDiskBuffer(this.session, this.sort, values.length);
            }
            this.addRowsToDisk();
        }
    }

    private void addRowsToDisk() throws SQLException {
        this.disk.addRows(this.rows);
        this.rows.clear();
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() throws SQLException {
        if (this.distinctRows != null) {
            this.rows = this.distinctRows.values();
            this.distinctRows = null;
        }
        if (this.disk != null) {
            this.addRowsToDisk();
            this.disk.done();
        } else if (this.sort != null) {
            this.sort.sort(this.rows);
        }
        this.reset();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void limit(int len) {
        if (len <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.rows.size() > len) {
                this.rows.removeRange(len, this.rows.size());
                this.rowCount = len;
            }
        } else if (len < this.rowCount) {
            this.rowCount = len;
        }
    }

    public void close() {
        if (this.disk != null) {
            this.disk.close();
            this.disk = null;
        }
    }

    public String getAlias(int i) {
        return this.expressions[i].getAlias();
    }

    public String getTableName(int i) {
        return this.expressions[i].getTableName();
    }

    public String getSchemaName(int i) {
        return this.expressions[i].getSchemaName();
    }

    public int getDisplaySize(int i) {
        return this.displaySizes[i];
    }

    public String getColumnName(int i) {
        return this.expressions[i].getColumnName();
    }

    public int getColumnType(int i) {
        return this.expressions[i].getType();
    }

    public long getColumnPrecision(int i) {
        return this.expressions[i].getPrecision();
    }

    public boolean isAutoIncrement(int i) {
        return this.expressions[i].isAutoIncrement();
    }

    public int getColumnScale(int i) {
        return this.expressions[i].getScale();
    }

    public void setOffset(int offset) {
        if (offset <= 0) {
            return;
        }
        if (this.disk == null) {
            if (offset >= this.rows.size()) {
                this.rows.clear();
                this.rowCount = 0;
            } else {
                int remove = Math.min(offset, this.rows.size());
                this.rows.removeRange(0, remove);
                this.rowCount -= remove;
            }
        } else if (offset >= this.rowCount) {
            this.rowCount = 0;
        } else {
            this.diskOffset = offset;
            this.rowCount -= offset;
        }
    }
}

