;;; finder-inf.el --- keyword-to-package mapping
;; This file is part of GNU Emacs.
;; Keywords: help
;;; Commentary:
;; Don't edit this file.  It's generated by finder.el

;;; Code:

(setq finder-package-info '(
    ("abbrev.el"
        "abbrev mode commands for Emacs"
        (abbrev convenience))
    ("abbrevlist.el"
        "list one abbrev table alphabetically ordered"
        (abbrev))
    ("add-log.el"
        "change log maintenance commands for Emacs"
        (tools))
    ("align.el"
        "align text to a specific column, by regexp"
        (convenience languages lisp))
    ("allout.el"
        "extensive outline mode for use alone and with other modes"
        (outline mode wp languages))
    ("ansi-color.el"
        "translate ANSI escape sequences into faces"
        (comm processes terminals services))
    ("apropos.el"
        "apropos commands for users and programmers"
        (help))
    ("arc-mode.el"
        "simple editing of archives"
        (archives msdog editing major-mode))
    ("array.el"
        "array editing commands for GNU Emacs"
        (extensions))
    ("autoarg.el"
        "make digit keys supply prefix args"
        (abbrev  emulations))
    ("autoinsert.el"
        "automatic mode-dependent insertion of text into new files"
        (convenience))
    ("autorevert.el"
        "revert buffers when files on disk change"
        (convenience))
    ("avoid.el"
        "make mouse pointer stay out of the way of editing"
        (mouse))
    ("battery.el"
        "display battery status information"
        (hardware))
    ("bindings.el"
        "define standard key bindings and some variables"
        (internal))
    ("bookmark.el"
        "set bookmarks, maybe annotate them, jump to them later"
        (bookmarks  placeholders  annotations))
    ("bs.el"
        "menu for selecting and displaying buffers"
        (convenience))
    ("buff-menu.el"
        "buffer menu main function and support functions"
        (convenience))
    ("byte-run.el"
        "byte-compiler support for inlining"
        (internal))
    ("calculator.el"
        "a [not so] simple calculator for Emacs"
        (tools  convenience))
    ("case-table.el"
        "code to extend the character set and support case tables"
        (i18n))
    ("cdl.el"
        "Common Data Language (CDL) utility functions for GNU Emacs"
        (data))
    ("chistory.el"
        "list command history"
        nil)
    ("cmuscheme.el"
        "Scheme process in a buffer. Adapted from tea.el"
        (processes  lisp))
    ("comint.el"
        "general command interpreter in a window stuff"
        (processes))
    ("compare-w.el"
        "compare text between windows for Emacs"
        nil)
    ("complete.el"
        "partial completion mechanism plus other goodies"
        (abbrev convenience))
    ("completion.el"
        "dynamic word-completion code"
        (abbrev convenience))
    ("composite.el"
        "support character composition"
        (mule  multilingual  character composition))
    ("cus-dep.el"
        "find customization dependencies"
        (internal))
    ("cus-edit.el"
        "tools for customizing Emacs and Lisp packages"
        (help  faces))
    ("cus-face.el"
        "customization support for faces"
        (help  faces))
    ("cus-load.el"
        "automatically extracted custom dependencies"
        nil)
    ("cus-start.el"
        "define customization properties of builtins"
        (internal))
    ("custom.el"
        "tools for declaring and initializing options"
        (help  faces))
    ("cvs-status.el"
        "Major mode for browsing `cvs status' output"
        (pcl-cvs cvs status tree))
    ("dabbrev.el"
        "dynamic abbreviation package"
        (abbrev expand completion convenience))
    ("delim-col.el"
        "prettify all columns in a region or rectangle"
        (internal))
    ("delsel.el"
        "delete selection if you insert"
        (convenience emulations))
    ("derived.el"
        "allow inheritance of major modes"
        (extensions))
    ("desktop.el"
        "save partial status of Emacs when killed"
        (convenience))
    ("diff-mode.el"
        "A mode for viewing/editing context diffs"
        (patch diff))
    ("diff.el"
        "run `diff' in compilation-mode"
        (unix  tools))
    ("dired-aux.el"
        "less commonly used parts of dired"
        (files))
    ("dired-x.el"
        "Extra Dired functionality"
        (dired extensions files))
    ("dired.el"
        "directory-browsing commands"
        (files))
    ("dirtrack.el"
        "Directory Tracking by watching the prompt"
        (processes))
    ("disp-table.el"
        "functions for dealing with char tables"
        (i18n))
    ("dos-fns.el"
        "MS-Dos specific functions"
        (internal))
    ("dos-vars.el"
        "MS-Dos specific user options"
        (internal))
    ("dos-w32.el"
        "Functions shared among MS-DOS and W32 (NT/95) platforms"
        (internal))
    ("double.el"
        "support for keyboard remapping with double clicking"
        (i18n))
    ("ebuff-menu.el"
        "electric-buffer-list mode"
        (convenience))
    ("echistory.el"
        "Electric Command History Mode"
        nil)
    ("ediff-diff.el"
        "diff-related utilities"
        nil)
    ("ediff-help.el"
        "Code related to the contents of Ediff help buffers"
        nil)
    ("ediff-hook.el"
        "setup for Ediff's menus and autoloads"
        nil)
    ("ediff-init.el"
        "Macros, variables, and defsubsts used by Ediff"
        nil)
    ("ediff-merg.el"
        "merging utilities"
        nil)
    ("ediff-mult.el"
        "support for multi-file/multi-buffer processing in Ediff"
        nil)
    ("ediff-ptch.el"
        "Ediff's  patch support"
        nil)
    ("ediff-util.el"
        "the core commands and utilities of ediff"
        nil)
    ("ediff-vers.el"
        "version control interface to Ediff"
        nil)
    ("ediff-wind.el"
        "window manipulation utilities"
        nil)
    ("ediff.el"
        "a comprehensive visual interface to diff & patch"
        (comparing  merging  patching  tools  unix))
    ("edmacro.el"
        "keyboard macro editor"
        (abbrev))
    ("ehelp.el"
        "bindings for electric-help mode"
        (help  extensions))
    ("electric.el"
        "window maker and Command loop for `electric' modes"
        (extensions))
    ("elide-head.el"
        "hide headers in files"
        (outlines tools))
    ("emacs-lock.el"
        "prevents you from exiting emacs if a buffer is locked"
        (extensions  processes))
    ("emerge.el"
        "merge diffs under Emacs control"
        (unix  tools))
    ("enriched.el"
        "read and save files in text/enriched format"
        (wp  faces))
    ("env.el"
        "functions to manipulate environment variables"
        (processes  unix))
    ("expand.el"
        "make abbreviations more usable"
        (abbrev))
    ("facemenu.el"
        "create a face menu for interactively adding fonts to text"
        (faces))
    ("faces.el"
        "Lisp faces"
        nil)
    ("fast-lock.el"
        "automagic text properties caching for fast Font Lock mode"
        (faces files))
    ("ffap.el"
        "find file (or url) at point"
        (files  hypermedia  matching  mouse  convenience))
    ("filecache.el"
        "Find files using a pre-loaded cache"
        (convenience))
    ("files.el"
        "file input and output commands for Emacs"
        nil)
    ("find-dired.el"
        "run a `find' command and dired the output"
        (unix))
    ("find-file.el"
        "find a file corresponding to this one given a pattern"
        (c  matching  tools))
    ("find-lisp.el"
        "emulation of find in Emacs Lisp"
        (unix))
    ("finder-inf.el"
        "keyword-to-package mapping"
        (help))
    ("finder.el"
        "topic & keyword-based code finder"
        (help))
    ("float-sup.el"
        "detect absence of floating-point support in Emacs runtime"
        nil)
    ("flow-ctrl.el"
        "help for lusers on cu(1) or ttys with wired-in ^S/^Q flow control"
        (hardware))
    ("foldout.el"
        "folding extensions for outline-mode and outline-minor-mode"
        (folding  outlines))
    ("follow.el"
        "synchronize windows showing the same buffer"
        (display  window  minor-mode  convenience))
    ("font-lock.el"
        "Electric font lock mode"
        (languages  faces))
    ("format.el"
        "read and save files in multiple formats"
        nil)
    ("forms-d2.el"
        "demo forms-mode"
        nil)
    ("forms-pass.el"
        "passwd file demo for forms-mode"
        nil)
    ("forms.el"
        "Forms mode: edit a file as a form to fill in"
        nil)
    ("frame.el"
        "multi-frame management independent of window systems"
        (internal))
    ("generic-x.el"
        "Extra Modes for generic-mode"
        (generic  comment  font-lock))
    ("generic.el"
        "defining simple major modes with comment and font-lock"
        (generic  comment  font-lock))
    ("gs.el"
        "interface to Ghostscript"
        (internal))
    ("gud.el"
        "Grand Unified Debugger mode for running GDB and other debuggers"
        (unix  tools))
    ("help-macro.el"
        "makes command line help such as help-for-help"
        nil)
    ("help.el"
        "help commands for Emacs"
        (help  internal))
    ("hexl.el"
        "edit a file in a hex dump format using the hexl filter"
        (data))
    ("hi-lock.el"
        "minor mode for interactive automatic highlighting"
        (faces  minor-mode  matching  display))
    ("hilit-chg.el"
        "minor mode displaying buffer changes with special face"
        (faces))
    ("hippie-exp.el"
        "expand text trying various ways to find its expansion"
        (abbrev convenience))
    ("hl-line.el"
        "highlight the current line"
        (faces  frames  emulation))
    ("icomplete.el"
        "minibuffer completion incremental feedback"
        (help  abbrev))
    ("ielm.el"
        "interaction mode for Emacs Lisp"
        (lisp))
    ("image-file.el"
        "Support for visiting image files"
        (multimedia))
    ("image.el"
        "image API"
        (multimedia))
    ("imenu.el"
        "framework for mode-specific buffer indexes"
        (tools convenience))
    ("indent.el"
        "indentation commands for Emacs"
        nil)
    ("info-look.el"
        "major-mode-sensitive Info index lookup facility"
        (help languages))
    ("info.el"
        "info package for Emacs"
        (help))
    ("informat.el"
        "info support functions package for Emacs"
        (help))
    ("isearch.el"
        "incremental search minor mode"
        (matching))
    ("iswitchb.el"
        "switch between buffers using substrings"
        (completion convenience))
    ("jit-lock.el"
        "just-in-time fontification"
        (faces files))
    ("jka-compr.el"
        "reading/writing/loading compressed files"
        (data))
    ("kermit.el"
        "additions to shell mode for use with kermit"
        (comm))
    ("lazy-lock.el"
        "lazy demand-driven fontification for fast Font Lock mode"
        (faces files))
    ("ledit.el"
        "Emacs side of ledit interface"
        (languages))
    ("loaddefs.el"
        "automatically extracted autoloads"
        nil)
    ("loadhist.el"
        "lisp functions for working with feature groups"
        (internal))
    ("loadup.el"
        "load up standardly loaded Lisp files for Emacs"
        (internal))
    ("locate.el"
        "interface to the locate command"
        (unix files))
    ("log-edit.el"
        "Major mode for editing CVS commit messages"
        (pcl-cvs cvs commit log))
    ("log-view.el"
        "Major mode for browsing RCS/CVS/SCCS log output"
        (rcs sccs cvs log version-control))
    ("lpr.el"
        "print Emacs buffer on line printer"
        (unix))
    ("ls-lisp.el"
        "emulate insert-directory completely in Emacs Lisp"
        (unix  dired))
    ("macros.el"
        "non-primitive commands for keyboard macros"
        (abbrev))
    ("makesum.el"
        "generate key binding summary for Emacs"
        (help))
    ("man.el"
        "browse UNIX manual pages"
        (help))
    ("map-ynp.el"
        "general-purpose boolean question-asker"
        (lisp  extensions))
    ("menu-bar.el"
        "define a default menu bar"
        (internal  mouse))
    ("midnight.el"
        "run something every midnight, e.g., kill old buffers"
        (utilities))
    ("minibuf-eldef.el"
        "Only show defaults in prompts when applicable"
        (convenience))
    ("misc.el"
        "some nonstandard basic editing commands for Emacs"
        nil)
    ("mouse-copy.el"
        "one-click text copy and move"
        (mouse))
    ("mouse-drag.el"
        "use mouse-2 to do a new style of scrolling"
        (mouse))
    ("mouse-sel.el"
        "multi-click selection support for Emacs 19"
        (mouse))
    ("mouse.el"
        "window system-independent mouse support"
        (hardware  mouse))
    ("msb.el"
        "customizable buffer-selection with multiple menus"
        (mouse buffer menu))
    ("mwheel.el"
        "Mouse support for MS intelli-mouse type mice"
        (mouse))
    ("newcomment.el"
        "(un)comment regions of buffers"
        (comment uncomment))
    ("novice.el"
        "handling of disabled commands (\"novice mode\") for Emacs"
        (internal  help))
    ("options.el"
        "edit Options command for Emacs"
        nil)
    ("paren.el"
        "highlight matching paren"
        (languages  faces))
    ("patcomp.el"
        "used by patch files to update Emacs releases"
        nil)
    ("paths.el"
        "define pathnames for use by various Emacs commands"
        (internal))
    ("pcmpl-cvs.el"
        "functions for dealing with cvs completions"
        nil)
    ("pcmpl-gnu.el"
        "completions for GNU project tools"
        nil)
    ("pcmpl-linux.el"
        "functions for dealing with GNU/Linux completions"
        nil)
    ("pcmpl-rpm.el"
        "functions for dealing with rpm completions"
        nil)
    ("pcmpl-unix.el"
        "standard UNIX completions"
        nil)
    ("pcomplete.el"
        "programmable completion"
        (processes abbrev))
    ("pcvs-defs.el"
        "variable definitions for PCL-CVS"
        (pcl-cvs))
    ("pcvs-info.el"
        "internal representation of a fileinfo entry"
        (pcl-cvs))
    ("pcvs-parse.el"
        "the CVS output parser"
        (pcl-cvs))
    ("pcvs-util.el"
        "utility functions for PCL-CVS"
        (pcl-cvs))
    ("pcvs.el"
        "a front-end to CVS"
        (cvs  version control  release management))
    ("ps-bdf.el"
        "BDF font file handler for ps-print"
        (wp  bdf  font  postscript))
    ("ps-mule.el"
        "provide multi-byte character facility to ps-print"
        (wp  print  postscript  multibyte  mule))
    ("ps-print.el"
        "print text from the buffer as PostScript"
        (wp  print  postscript))
    ("recentf.el"
        "setup a menu of recently opened files"
        (customization))
    ("rect.el"
        "rectangle functions for GNU Emacs"
        (internal))
    ("regi.el"
        "REGular expression Interpreting engine"
        (extensions  matching))
    ("register.el"
        "register commands for Emacs"
        (internal))
    ("repeat.el"
        "convenient way to repeat the previous command"
        (convenience  vi  repeat))
    ("replace.el"
        "replace commands for Emacs"
        nil)
    ("reposition.el"
        "center a Lisp function or comment on the screen"
        nil)
    ("resume.el"
        "process command line args from within a suspended Emacs job"
        (processes))
    ("rot13.el"
        "display a buffer in rot13"
        nil)
    ("s-region.el"
        "set region using shift key"
        (terminals))
    ("saveplace.el"
        "automatically save place in files"
        (bookmarks  placeholders))
    ("scroll-all.el"
        "scroll all buffers together minor mode"
        (scroll crisp brief lock))
    ("scroll-bar.el"
        "window system-independent scroll bar support"
        (hardware))
    ("select.el"
        "lisp portion of standard selection support"
        (internal))
    ("server.el"
        "Lisp code for GNU Emacs running as server process"
        (processes))
    ("shadowfile.el"
        "automatic file copying"
        (comm files))
    ("shell.el"
        "specialized comint.el for running the shell"
        (processes))
    ("simple.el"
        "basic editing commands for Emacs"
        nil)
    ("skeleton.el"
        "Lisp language extension for writing statement skeletons"
        (extensions  abbrev  languages  tools))
    ("smerge-mode.el"
        "Minor mode to resolve diff3 conflicts"
        (merge diff3 cvs conflict))
    ("sort.el"
        "commands to sort text in an Emacs buffer"
        (unix))
    ("soundex.el"
        "implement Soundex algorithm"
        (matching))
    ("speedbar.el"
        "quick access to files and tags in a frame"
        (file  tags  tools))
    ("startup.el"
        "process Emacs shell arguments"
        (internal))
    ("strokes.el"
        "control Emacs through mouse strokes"
        (lisp  mouse  extensions))
    ("subdirs.el"
        nil
        nil)
    ("subr.el"
        "basic lisp subroutines for Emacs"
        nil)
    ("tabify.el"
        "tab conversion commands for Emacs"
        nil)
    ("talk.el"
        "allow several users to talk to each other through Emacs"
        (comm  frames))
    ("tar-mode.el"
        "simple editing of tar files from GNU emacs"
        (unix))
    ("tcp.el"
        "TCP/IP stream emulation for GNU Emacs"
        nil)
    ("tempo.el"
        "Flexible template insertion"
        (extensions  languages  tools))
    ("term.el"
        "general command interpreter in a window stuff"
        (processes))
    ("terminal.el"
        "terminal emulator for GNU Emacs"
        (comm  terminals))
    ("thingatpt.el"
        "get the `thing' at point"
        (extensions  matching  mouse))
    ("time-stamp.el"
        "Maintain last change time stamps in files edited by Emacs"
        (tools))
    ("time.el"
        "display time, load and mail indicator in mode line of Emacs"
        nil)
    ("timer.el"
        "run a function with args at some time in future"
        nil)
    ("timezone.el"
        "time zone package for GNU Emacs"
        (news))
    ("tmm.el"
        "text mode access to menu-bar"
        (convenience))
    ("tooltip.el"
        "Show tooltip windows"
        (help c mouse tools))
    ("type-break.el"
        "encourage rests from typing at appropriate intervals"
        (extensions  timers))
    ("uniquify.el"
        "unique buffer names dependent on file name"
        (files))
    ("unused.el"
        "editing commands in GNU Emacs that turned out not to be used"
        (emulations))
    ("userlock.el"
        "handle file access contention between multiple users"
        (internal))
    ("vc-cvs.el"
        "non-resident support for CVS version-control"
        nil)
    ("vc-hooks.el"
        "resident support for version-control"
        nil)
    ("vc-rcs.el"
        "support for RCS version-control"
        nil)
    ("vc-sccs.el"
        "support for SCCS version-control"
        nil)
    ("vc.el"
        "drive a version-control system from within Emacs"
        (tools))
    ("vcursor.el"
        "manipulate an alternative (\"virtual\") cursor"
        (virtual cursor  convenience))
    ("version.el"
        "record version number of Emacs"
        (internal))
    ("view.el"
        "peruse file or buffer without editing"
        (files))
    ("vms-patch.el"
        "override parts of files.el for VMS"
        (vms))
    ("vmsproc.el"
        "run asynchronous VMS subprocesses under Emacs"
        (vms))
    ("vt-control.el"
        "Common VTxxx control functions"
        (terminals))
    ("vt100-led.el"
        "functions for LED control on VT-100 terminals & clones"
        (hardware))
    ("w32-fns.el"
        "Lisp routines for Windows NT"
        (internal))
    ("which-func.el"
        "print current function in mode line"
        (mode-line  imenu  tools))
    ("whitespace.el"
        "warn about and clean bogus whitespaces in the file"
        (convenience))
    ("wid-browse.el"
        "functions for browsing widgets"
        (extensions))
    ("wid-edit.el"
        "Functions for creating and using widgets"
        (extensions))
    ("widget.el"
        "a library of user interface components"
        (help  extensions  faces  hypermedia))
    ("windmove.el"
        "directional window-selection routines"
        (window  movement  convenience))
    ("window.el"
        "GNU Emacs window commands aside from those written in C"
        (internal))
    ("winner.el"
        "Restore old window configurations"
        (convenience frames))
    ("woman.el"
        "browse UN*X manual pages `wo (without) man'"
        (help  man  un*x  manual))
    ("xml.el"
        "XML parser"
        (xml))
    ("xscheme.el"
        "run MIT Scheme under Emacs"
        (languages  lisp))
    ("xt-mouse.el"
        "support the mouse when emacs run in an xterm"
        (mouse  terminals))
    ("binhex.el"
        "elisp native binhex decode"
        (binhex news))
    ("earcon.el"
        "sound effects for messages"
        nil)
    ("flow-fill.el"
        "interprete RFC2646 \"flowed\" text"
        (mail))
    ("format-spec.el"
        "functions for formatting arbitrary formatting strings"
        (tools))
    ("gnus-agent.el"
        "unplugged support for Gnus"
        nil)
    ("gnus-art.el"
        "article mode commands for Gnus"
        (news))
    ("gnus-async.el"
        "asynchronous support for Gnus"
        (news))
    ("gnus-audio.el"
        "sound effects for Gnus"
        (news  mail  multimedia))
    ("gnus-bcklg.el"
        "backlog functions for Gnus"
        (news))
    ("gnus-cache.el"
        "cache interface for Gnus"
        (news))
    ("gnus-cite.el"
        "parse citations in articles for Gnus"
        nil)
    ("gnus-cus.el"
        "customization commands for Gnus"
        (news))
    ("gnus-demon.el"
        "daemonic Gnus behaviour"
        (news))
    ("gnus-draft.el"
        "draft message support for Gnus"
        (news))
    ("gnus-dup.el"
        "suppression of duplicate articles in Gnus"
        (news))
    ("gnus-eform.el"
        "a mode for editing forms for Gnus"
        (news))
    ("gnus-ems.el"
        "functions for making Gnus work under different Emacsen"
        (news))
    ("gnus-gl.el"
        "an interface to GroupLens for Gnus"
        (news  score))
    ("gnus-group.el"
        "group mode commands for Gnus"
        (news))
    ("gnus-int.el"
        "backend interface functions for Gnus"
        (news))
    ("gnus-kill.el"
        "kill commands for Gnus"
        (news))
    ("gnus-logic.el"
        "advanced scoring code for Gnus"
        (news))
    ("gnus-mh.el"
        "mh-e interface for Gnus"
        (news))
    ("gnus-ml.el"
        "mailing list minor mode for Gnus"
        (news))
    ("gnus-mlspl.el"
        "a group params-based mail splitting mechanism"
        (news  mail))
    ("gnus-move.el"
        "commands for moving Gnus from one server to another"
        (news))
    ("gnus-msg.el"
        "mail and post interface for Gnus"
        (news))
    ("gnus-mule.el"
        "provide backward compatibility function to GNUS"
        (news  i18n))
    ("gnus-nocem.el"
        "NoCeM pseudo-cancellation treatment"
        (news))
    ("gnus-range.el"
        "range and sequence functions for Gnus"
        (news))
    ("gnus-salt.el"
        "alternate summary mode interfaces for Gnus"
        (news))
    ("gnus-score.el"
        "scoring code for Gnus"
        (news))
    ("gnus-setup.el"
        "initialization & setup for Gnus 5"
        (news))
    ("gnus-soup.el"
        "SOUP packet writing support for Gnus"
        (news  mail))
    ("gnus-spec.el"
        "format spec functions for Gnus"
        (news))
    ("gnus-srvr.el"
        "virtual server support for Gnus"
        (news))
    ("gnus-start.el"
        "startup functions for Gnus"
        (news))
    ("gnus-sum.el"
        "summary mode commands for Gnus"
        (news))
    ("gnus-topic.el"
        "a folding minor mode for Gnus group buffers"
        (news))
    ("gnus-undo.el"
        "minor mode for undoing in Gnus"
        (news))
    ("gnus-util.el"
        "utility functions for Gnus"
        (news))
    ("gnus-uu.el"
        "extract (uu)encoded files in Gnus"
        nil)
    ("gnus-vm.el"
        "vm interface for Gnus"
        (news  mail))
    ("gnus-win.el"
        "window configuration functions for Gnus"
        (news))
    ("gnus.el"
        "a newsreader for GNU Emacs"
        (news  mail))
    ("ietf-drums.el"
        "functions for parsing RFC822bis headers"
        nil)
    ("imap.el"
        "imap library"
        (mail))
    ("mail-parse.el"
        "interface functions for parsing mail"
        nil)
    ("mail-prsvr.el"
        "interface variables for parsing mail"
        nil)
    ("mail-source.el"
        "functions for fetching mail"
        (news  mail))
    ("mailcap.el"
        "MIME media types configuration"
        (news  mail  multimedia))
    ("message.el"
        "composing mail and news messages"
        (mail  news))
    ("messcompat.el"
        "making message mode compatible with mail mode"
        (mail  news))
    ("mm-bodies.el"
        "functions for decoding MIME things"
        nil)
    ("mm-decode.el"
        "functions for decoding MIME things"
        nil)
    ("mm-encode.el"
        "functions for encoding MIME things "
        nil)
    ("mm-partial.el"
        "showing message/partial"
        (message partial))
    ("mm-util.el"
        "Utility functions for Mule and low level things"
        nil)
    ("mm-uu.el"
        "return uu stuff as mm handles"
        (postscript uudecode binhex shar forward news))
    ("mm-view.el"
        "functions for viewing MIME objects"
        nil)
    ("mml.el"
        "package for parsing and validating MML documents"
        nil)
    ("nnagent.el"
        "offline backend for Gnus"
        (news  mail))
    ("nnbabyl.el"
        "rmail mbox access for Gnus"
        (news  mail))
    ("nndir.el"
        "single directory newsgroup access for Gnus"
        (news))
    ("nndoc.el"
        "single file access for Gnus"
        (news))
    ("nndraft.el"
        "draft article access for Gnus"
        (news))
    ("nneething.el"
        "arbitrary file access for Gnus"
        (news  mail))
    ("nnfolder.el"
        "mail folder access for Gnus"
        (mail))
    ("nngateway.el"
        "posting news via mail gateways"
        (news  mail))
    ("nnheader.el"
        "header access macros for Gnus and its backends"
        (news))
    ("nnimap.el"
        "imap backend for Gnus"
        (mail))
    ("nnkiboze.el"
        "select virtual news access for Gnus"
        (news))
    ("nnlistserv.el"
        "retrieving articles via web mailing list archives"
        (news  mail))
    ("nnmail.el"
        "mail support functions for the Gnus mail backends"
        (news  mail))
    ("nnmbox.el"
        "mail mbox access for Gnus"
        (news  mail))
    ("nnmh.el"
        "mhspool access for Gnus"
        (news  mail))
    ("nnml.el"
        "mail spool access for Gnus"
        (news  mail))
    ("nnoo.el"
        "OO Gnus Backends"
        (news))
    ("nnslashdot.el"
        "interfacing with Slashdot"
        (news))
    ("nnsoup.el"
        "SOUP access for Gnus"
        (news  mail))
    ("nnspool.el"
        "spool access for GNU Emacs"
        (news))
    ("nntp.el"
        "nntp access for Gnus"
        (news))
    ("nnultimate.el"
        "interfacing with the Ultimate Bulletin Board system"
        (news))
    ("nnvirtual.el"
        "virtual newsgroups access for Gnus"
        (news))
    ("nnwarchive.el"
        "interfacing with web archives"
        (news egroups mail-archive))
    ("nnweb.el"
        "retrieving articles via web search engines"
        (news))
    ("parse-time.el"
        "parsing time strings"
        (util))
    ("pop3.el"
        "Post Office Protocol (RFC 1460) interface"
        (mail))
    ("qp.el"
        "Quoted-Printable functions"
        (mail  extensions))
    ("rfc1843.el"
        "HZ (rfc1843) decoding"
        (news hz hz+ mail i18n))
    ("rfc2045.el"
        "functions for decoding rfc2045 headers"
        nil)
    ("rfc2047.el"
        "functions for encoding and decoding rfc2047 messages"
        nil)
    ("rfc2104.el"
        "RFC2104 Hashed Message Authentication Codes"
        (mail))
    ("rfc2231.el"
        "functions for decoding rfc2231 headers"
        nil)
    ("score-mode.el"
        "mode for editing Gnus score files"
        (news  mail))
    ("smiley-ems.el"
        "displaying smiley faces"
        (news mail multimedia))
    ("starttls.el"
        "STARTTLS functions"
        (tls  ssl  openssl  mail  news))
    ("time-date.el"
        "date and time handling functions"
        (mail news util))
    ("utf7.el"
        "UTF-7 encoding/decoding for Emacs"
        (mail))
    ("uudecode.el"
        "elisp native uudecode"
        (uudecode news))
    ("webmail.el"
        "interface of web mail"
        (hotmail netaddress my-deja netscape))
    ("blessmail.el"
        "decide whether movemail needs special privileges"
        (internal))
    ("emacsbug.el"
        "command to report Emacs bugs to appropriate mailing list"
        (maint mail))
    ("feedmail.el"
        "assist other email packages to massage outgoing messages"
        (email  queue  mail  sendmail  message  spray  smtp  draft))
    ("footnote.el"
        "footnote support for message mode"
        (mail  news))
    ("mail-extr.el"
        "extract full name and address from RFC 822 mail header"
        (mail))
    ("mail-hist.el"
        "headers and message body history for outgoing mail"
        (mail  history))
    ("mail-utils.el"
        "utility functions used both by rmail and rnews"
        (mail  news))
    ("mailabbrev.el"
        "abbrev-expansion of mail aliases"
        (mail))
    ("mailalias.el"
        "expand and complete mailing address aliases"
        (mail))
    ("mailheader.el"
        "mail header parsing, merging, formatting"
        (tools  mail  news))
    ("mailpost.el"
        "RMAIL coupler to /usr/uci/post mailer"
        (mail))
    ("metamail.el"
        "Metamail interface for GNU Emacs"
        (mail  news  mime  multimedia))
    ("mh-comp.el"
        "mh-e functions for composing messages"
        (mail))
    ("mh-e.el"
        "GNU Emacs interface to the MH mail system"
        (mail))
    ("mh-funcs.el"
        "mh-e functions not everyone will use right away"
        nil)
    ("mh-mime.el"
        "mh-e support for composing MIME messages"
        nil)
    ("mh-pick.el"
        "make a search pattern and search for a message in mh-e"
        nil)
    ("mh-seq.el"
        "mh-e sequences support"
        nil)
    ("mh-utils.el"
        "mh-e code needed for both sending and reading"
        nil)
    ("mspools.el"
        "show mail spools waiting to be read"
        (mail))
    ("reporter.el"
        "customizable bug reporting of lisp programs"
        (maint mail tools))
    ("rfc2368.el"
        "support for rfc2368"
        (mail))
    ("rfc822.el"
        "hairy rfc822 parser for mail and news and suchlike"
        (mail))
    ("rmail.el"
        "main code of \"RMAIL\" mail reader for Emacs"
        (mail))
    ("rmailedit.el"
        "\"RMAIL edit mode\"  Edit the current message"
        (mail))
    ("rmailkwd.el"
        "part of the \"RMAIL\" mail reader for Emacs"
        (mail))
    ("rmailmsc.el"
        "miscellaneous support functions for the RMAIL mail reader"
        (mail))
    ("rmailout.el"
        "\"RMAIL\" mail reader for Emacs: output message to a file"
        (mail))
    ("rmailsort.el"
        "Rmail: sort messages"
        (mail))
    ("rmailsum.el"
        "make summary buffers for the mail reader"
        (mail))
    ("sendmail.el"
        "mail sending commands for Emacs."
        (mail))
    ("smtpmail.el"
        "simple SMTP protocol (RFC 821) for sending mail"
        (mail))
    ("supercite.el"
        "minor mode for citing mail and news replies"
        (mail  news))
    ("uce.el"
        "facilitate reply to unsolicited commercial email"
        (uce  unsolicited commercial email))
    ("undigest.el"
        "digest-cracking support for the RMAIL mail reader"
        (mail))
    ("unrmail.el"
        "convert Rmail files to mailbox files"
        (mail))
    ("vms-pmail.el"
        "use Emacs as the editor within VMS mail"
        (vms))
    ("appt.el"
        "appointment notification functions"
        (calendar))
    ("cal-china.el"
        "calendar functions for the Chinese calendar"
        (calendar))
    ("cal-coptic.el"
        "calendar functions for the Coptic/Ethiopic calendars"
        (calendar))
    ("cal-dst.el"
        "calendar functions for daylight savings rules"
        (calendar))
    ("cal-french.el"
        "calendar functions for the French Revolutionary calendar"
        (calendar))
    ("cal-hebrew.el"
        "calendar functions for the Hebrew calendar"
        (calendar))
    ("cal-islam.el"
        "calendar functions for the Islamic calendar"
        (calendar))
    ("cal-iso.el"
        "calendar functions for the ISO calendar"
        (calendar))
    ("cal-julian.el"
        "calendar functions for the Julian calendar"
        (calendar))
    ("cal-mayan.el"
        "calendar functions for the Mayan calendars"
        (calendar))
    ("cal-menu.el"
        "calendar functions for menu bar and popup menu support"
        (calendar))
    ("cal-move.el"
        "calendar functions for movement in the calendar"
        (calendar))
    ("cal-persia.el"
        "calendar functions for the Persian calendar"
        (calendar))
    ("cal-tex.el"
        "calendar functions for printing calendars with LaTeX"
        (calendar))
    ("cal-x.el"
        "calendar windows in dedicated frames in X"
        (calendar))
    ("calendar.el"
        "calendar functions"
        (calendar))
    ("diary-lib.el"
        "diary functions"
        (calendar))
    ("holidays.el"
        "holiday functions for the calendar package"
        (holidays  calendar))
    ("lunar.el"
        "calendar functions for phases of the moon"
        (calendar))
    ("solar.el"
        "calendar functions for solar events"
        (calendar))
    ("timeclock.el"
        "mode for keeping track of how much you work"
        (calendar data))
    ("todo-mode.el"
        "major mode for editing TODO list files"
        (calendar  todo))
    ("advice.el"
        "an overloading mechanism for Emacs Lisp functions"
        (extensions  lisp  tools))
    ("assoc.el"
        "insert/delete/sort functions on association lists"
        (extensions))
    ("authors.el"
        "utility for maintaining Emacs' AUTHORS file"
        (maint))
    ("autoload.el"
        "maintain autoloads in loaddefs.el"
        (maint))
    ("backquote.el"
        "implement the ` Lisp construct"
        (extensions  internal))
    ("byte-opt.el"
        "the optimization passes of the emacs-lisp byte compiler"
        (internal))
    ("bytecomp.el"
        "compilation of Lisp code into byte code"
        (lisp))
    ("checkdoc.el"
        "check documentation strings for style requirements"
        (docs  maint  lisp))
    ("cl-compat.el"
        "Common Lisp extensions for GNU Emacs Lisp (compatibility)"
        (extensions))
    ("cl-extra.el"
        "Common Lisp features, part 2"
        (extensions))
    ("cl-indent.el"
        "enhanced lisp-indent mode"
        (lisp  tools))
    ("cl-macs.el"
        "Common Lisp macros"
        (extensions))
    ("cl-seq.el"
        "Common Lisp features, part 3"
        (extensions))
    ("cl-specs.el"
        "Edebug specs for cl.el"
        (lisp  tools  maint))
    ("cl.el"
        "Common Lisp extensions for Emacs"
        (extensions))
    ("copyright.el"
        "update the copyright notice in current buffer"
        (maint  tools))
    ("crm.el"
        "read multiple strings with completion"
        (completion  minibuffer  multiple elements))
    ("cust-print.el"
        "handles print-level and print-circle"
        (extensions))
    ("debug.el"
        "debuggers and related commands for Emacs"
        (lisp  tools  maint))
    ("disass.el"
        "disassembler for compiled Emacs Lisp code"
        (internal))
    ("easy-mmode.el"
        "easy definition for major and minor modes"
        (extensions lisp))
    ("easymenu.el"
        "support the easymenu interface for defining a menu"
        (emulations))
    ("edebug.el"
        "a source-level debugger for Emacs Lisp"
        (lisp  tools  maint))
    ("eldoc.el"
        "show function arglist or variable docstring in echo area"
        (extensions))
    ("elint.el"
        "Lint Emacs Lisp"
        (lisp))
    ("elp.el"
        "Emacs Lisp Profiler"
        (debugging lisp tools))
    ("ewoc.el"
        "utility to maintain a view of a list of objects in a buffer"
        (extensions  lisp))
    ("find-func.el"
        "find the definition of the Emacs Lisp function near point"
        (emacs-lisp  functions  variables))
    ("find-gc.el"
        "detect functions that call the garbage collector"
        nil)
    ("float.el"
        "obsolete floating point arithmetic package"
        (extensions))
    ("gulp.el"
        "ask for updates for Lisp packages"
        (maintenance))
    ("helper.el"
        "utility help package supporting help in electric modes"
        (help))
    ("levents.el"
        "emulate the Lucid event data type and associated functions"
        (emulations))
    ("lisp-mnt.el"
        "minor mode for Emacs Lisp maintainers"
        (docs))
    ("lisp-mode.el"
        "Lisp mode, and its idiosyncratic commands"
        (lisp  languages))
    ("lisp.el"
        "Lisp editing commands for Emacs"
        (lisp  languages))
    ("lmenu.el"
        "emulate Lucid's menubar support"
        (emulations obsolete))
    ("lselect.el"
        "Lucid interface to X Selections"
        (emulations))
    ("lucid.el"
        "emulate some Lucid Emacs functions"
        (emulations))
    ("pp.el"
        "pretty printer for Emacs Lisp"
        (lisp))
    ("re-builder.el"
        "building Regexps with visual feedback"
        (matching  lisp  tools))
    ("regexp-opt.el"
        "generate efficient regexps to match strings"
        (strings  regexps  extensions))
    ("ring.el"
        "handle rings of items"
        (extensions))
    ("rx.el"
        "sexp notation for regular expressions"
        (strings  regexps  extensions))
    ("shadow.el"
        "locate Emacs Lisp file shadowings"
        (lisp))
    ("sregex.el"
        "symbolic regular expressions"
        (extensions))
    ("tq.el"
        "utility to maintain a transaction queue"
        (extensions))
    ("trace.el"
        "tracing facility for Emacs Lisp functions"
        (tools  lisp))
    ("crisp.el"
        "CRiSP/Brief Emacs emulator"
        (emulations brief crisp))
    ("edt-lk201.el"
        "enhanced EDT keypad mode emulation for LK-201 keyboards"
        (emulations))
    ("edt-mapper.el"
        "create an EDT LK-201 map file for X-Windows Emacs"
        (emulations))
    ("edt-pc.el"
        "enhanced EDT keypad mode emulation for PC 101 keyboards"
        (emulations))
    ("edt-vt100.el"
        "enhanced EDT keypad mode emulation for VT series terminals"
        (emulations))
    ("edt.el"
        "enhanced EDT keypad mode emulation for GNU Emacs 19"
        (emulations))
    ("mlconvert.el"
        "convert buffer of Mocklisp code to real lisp"
        (emulations))
    ("mlsupport.el"
        "run-time support for mocklisp code"
        (extensions))
    ("pc-mode.el"
        "emulate certain key bindings used on PCs"
        (emulations))
    ("pc-select.el"
        "emulate mark, cut, copy and paste from Motif"
        (convenience emulation))
    ("tpu-edt.el"
        "Emacs emulating TPU emulating EDT"
        (emulations))
    ("tpu-extras.el"
        "scroll margins and free cursor mode for TPU-edt"
        (emulations))
    ("tpu-mapper.el"
        "create a TPU-edt X-windows keymap file"
        (emulations))
    ("vi.el"
        "major mode for emulating \"vi\" editor under GNU Emacs"
        (emulations))
    ("vip.el"
        "a VI Package for GNU Emacs"
        (emulations))
    ("viper-cmd.el"
        "Vi command support for Viper"
        nil)
    ("viper-ex.el"
        "functions implementing the Ex commands for Viper"
        nil)
    ("viper-init.el"
        "some common definitions for Viper"
        nil)
    ("viper-keym.el"
        "Viper keymaps"
        nil)
    ("viper-macs.el"
        "functions implementing keyboard macros for Viper"
        nil)
    ("viper-mous.el"
        "mouse support for Viper"
        nil)
    ("viper-util.el"
        "Utilities used by viper.el"
        nil)
    ("viper.el"
        "A full-featured Vi emulator for GNU Emacs and XEmacs,"
        (emulations))
    ("ws-mode.el"
        "WordStar emulation mode for GNU Emacs"
        (emulations))
    ("em-alias.el"
        "creation and management of command aliases"
        nil)
    ("em-banner.el"
        "sample module that displays a login banner"
        nil)
    ("em-basic.el"
        "basic shell builtin commands"
        nil)
    ("em-cmpl.el"
        "completion using the TAB key"
        nil)
    ("em-dirs.el"
        "directory navigation commands"
        nil)
    ("em-glob.el"
        "extended file name globbing"
        nil)
    ("em-hist.el"
        "history list management"
        nil)
    ("em-ls.el"
        "implementation of ls in Lisp"
        nil)
    ("em-pred.el"
        "argument predicates and modifiers (ala zsh)"
        nil)
    ("em-prompt.el"
        "command prompts"
        nil)
    ("em-rebind.el"
        "rebind keys when point is at current input"
        nil)
    ("em-script.el"
        "Eshell script files"
        nil)
    ("em-smart.el"
        "smart display of output"
        nil)
    ("em-term.el"
        "running visual commands"
        nil)
    ("em-unix.el"
        "UNIX command aliases"
        nil)
    ("em-xtra.el"
        "extra alias functions"
        nil)
    ("esh-arg.el"
        "argument processing"
        nil)
    ("esh-cmd.el"
        "command invocation"
        nil)
    ("esh-ext.el"
        "commands external to Eshell"
        nil)
    ("esh-groups.el"
        nil
        nil)
    ("esh-io.el"
        "I/O management"
        nil)
    ("esh-maint.el"
        "init code for building eshell"
        nil)
    ("esh-mode.el"
        "user interface"
        nil)
    ("esh-module.el"
        "Eshell modules"
        (processes))
    ("esh-opt.el"
        "command options processing"
        nil)
    ("esh-proc.el"
        "process management"
        nil)
    ("esh-test.el"
        "Eshell test suite"
        nil)
    ("esh-util.el"
        "general utilities"
        nil)
    ("esh-var.el"
        "handling of variables"
        nil)
    ("eshell.el"
        "the Emacs command shell"
        (processes))
    ("ccl.el"
        "CCL (Code Conversion Language) compiler"
        (ccl  mule  multilingual  character set  coding-system))
    ("characters.el"
        "set syntax and category for multibyte characters"
        (multibyte character  character set  syntax  category))
    ("codepage.el"
        "MS-DOS/MS-Windows specific coding systems"
        (i18n ms-dos ms-windows codepage))
    ("encoded-kb.el"
        "handler to input multibyte characters encoded somehow"
        nil)
    ("fontset.el"
        "commands for handling fontset"
        (mule  multilingual  fontset))
    ("isearch-x.el"
        "extended isearch handling commands"
        (multilingual  isearch))
    ("iso-acc.el"
        "minor mode providing electric accent keys"
        (i18n))
    ("iso-ascii.el"
        "set up char tables for ISO 8859/1 on ASCII terminals"
        (i18n))
    ("iso-cvt.el"
        "translate ISO 8859-1 from/to various encodings"
        (tex  iso  latin  i18n))
    ("iso-insert.el"
        "insert functions for ISO 8859/1"
        (i18n))
    ("iso-swed.el"
        "set up char tables for ISO 8859/1 for Swedish/Finnish ttys"
        (i18n))
    ("iso-transl.el"
        "keyboard input definitions for ISO 8859-1"
        (i18n))
    ("ja-dic-cnv.el"
        "convert a Japanese dictionary (SKK-JISYO.L) to Emacs Lisp"
        (mule  multilingual  japanese))
    ("ja-dic-utl.el"
        "utilities for handling Japanese dictionary (SKK-JISYO.L)"
        (mule  multilingual  japanese))
    ("kinsoku.el"
        "`Kinsoku' processing funcs"
        (mule  kinsoku))
    ("kkc.el"
        "Kana Kanji converter"
        (mule  multilingual  japanese))
    ("latin-1.el"
        "set up case-conversion and syntax tables for ISO Latin-1"
        (i18n))
    ("latin-2.el"
        "set up case-conversion and syntax tables for ISO Latin-2"
        (i18n))
    ("latin-3.el"
        "set up case-conversion and syntax tables for ISO Latin-3"
        (i18n))
    ("latin-4.el"
        "set up case-conversion and syntax tables for ISO Latin-4"
        (i18n))
    ("latin-5.el"
        "set up case-conversion and syntax tables for ISO latin-5"
        (i18n))
    ("latin-8.el"
        "set up case-conversion and syntax tables for ISO Latin-8"
        (i18n))
    ("latin-9.el"
        "set up case-conversion and syntax tables for ISO Latin-9"
        (i18n))
    ("latin1-disp.el"
        "display tables for other ISO 8859 on Latin-1 terminals"
        (i18n))
    ("mule-cmds.el"
        "commands for mulitilingual environment"
        (mule  multilingual))
    ("mule-conf.el"
        "configure multilingual environment"
        (mule  multilingual  character set  coding system))
    ("mule-diag.el"
        "show diagnosis of multilingual environment (Mule)"
        (multilingual  charset  coding system  fontset  diagnosis  i18n))
    ("mule-util.el"
        "utility functions for mulitilingual environment (mule)"
        (mule  multilingual))
    ("mule.el"
        "basic commands for mulitilingual environment"
        (mule  multilingual  character set  coding system))
    ("ogonek.el"
        "change the encoding of Polish diacritics"
        (i18n))
    ("quail.el"
        "provides simple input method for multilingual text"
        (mule  multilingual  input method))
    ("swedish.el"
        "miscellaneous functions for dealing with Swedish"
        (i18n))
    ("titdic-cnv.el"
        "convert cxterm dictionary (TIT format) to Quail package"
        (quail  tit  cxterm))
    ("utf-8.el"
        "limited UTF-8 decoding/encoding support"
        (multilingual  unicode  utf-8  i18n))
    ("china-util.el"
        "utilities for Chinese"
        (mule  multilingual  chinese))
    ("chinese.el"
        "support for Chinese"
        (multilingual  chinese))
    ("cyril-util.el"
        "utilities for Cyrillic scripts"
        (mule  multilingual  cyrillic))
    ("cyrillic.el"
        "support for Cyrillic"
        (multilingual  cyrillic))
    ("czech.el"
        "support for Czech"
        (multilingual  czech))
    ("devan-util.el"
        "support for Devanagari Script Composition"
        (multilingual  indian  devanagari))
    ("devanagari.el"
        "support for Devanagari"
        (multilingual  indian  devanagari))
    ("english.el"
        "support for English"
        (multibyte character  character set  syntax  category))
    ("ethio-util.el"
        "utilities for Ethiopic"
        (mule  multilingual  ethiopic))
    ("ethiopic.el"
        "support for Ethiopic"
        (multilingual  ethiopic))
    ("european.el"
        "support for European languages"
        (multilingual  european))
    ("greek.el"
        "support for Greek"
        (multilingual  greek))
    ("hebrew.el"
        "support for Hebrew"
        (multilingual  hebrew))
    ("indian.el"
        "support for Indian Languages"
        (multilingual  indian))
    ("japan-util.el"
        "utilities for Japanese"
        (mule  multilingual  japanese))
    ("japanese.el"
        "support for Japanese"
        (multilingual  japanese))
    ("korea-util.el"
        "utilities for Korean"
        (mule  multilingual  korean))
    ("korean.el"
        "support for Korean"
        (multilingual  korean))
    ("lao-util.el"
        "utilities for Lao"
        (multilingual  lao))
    ("lao.el"
        "support for Lao"
        (multilingual  lao))
    ("misc-lang.el"
        "support for miscellaneous languages (characters)"
        (multilingual  character set  coding system))
    ("romanian.el"
        "support for Romanian"
        (multilingual  romanian))
    ("slovak.el"
        "support for Slovak"
        (multilingual  slovak))
    ("thai-util.el"
        "utilities for Thai"
        (mule  multilingual  thai))
    ("thai.el"
        "support for Thai"
        (multilingual  thai))
    ("tibet-util.el"
        "utilities for Tibetan"
        (multilingual  tibetan))
    ("tibetan.el"
        "support for Tibetan language"
        (multilingual  tibetan))
    ("viet-util.el"
        "utilities for Vietnamese"
        (mule  multilingual  vietnamese))
    ("vietnamese.el"
        "support for Vietnamese"
        (multilingual  vietnamese))
    ("ange-ftp.el"
        "transparent FTP support for GNU Emacs"
        (comm))
    ("browse-url.el"
        "pass a URL to a WWW browser"
        (hypertext  hypermedia  mouse))
    ("eudc-bob.el"
        "Binary Objects Support for EUDC"
        (help))
    ("eudc-export.el"
        "functions to export EUDC query results"
        (help))
    ("eudc-hotlist.el"
        "hotlist management for EUDC"
        (help))
    ("eudc-vars.el"
        "Emacs Unified Directory Client"
        (help))
    ("eudc.el"
        "Emacs Unified Directory Client"
        (help))
    ("eudcb-bbdb.el"
        "Emacs Unified Directory Client - BBDB Backend"
        (help))
    ("eudcb-ldap.el"
        "Emacs Unified Directory Client - LDAP Backend"
        (help))
    ("eudcb-ph.el"
        "Emacs Unified Directory Client - CCSO PH/QI Backend"
        (help))
    ("goto-addr.el"
        "click to browse URL or to send to e-mail address"
        (mh-e  www  mouse  mail))
    ("ldap.el"
        "client interface to LDAP for Emacs"
        (comm))
    ("net-utils.el"
        "network functions"
        (network communications))
    ("quickurl.el"
        "insert an URL based on text at point in buffer"
        (hypermedia))
    ("rcompile.el"
        "run a compilation on a remote machine"
        (tools  processes))
    ("rlogin.el"
        "remote login interface"
        (unix  comm))
    ("snmp-mode.el"
        "SNMP & SNMPv2 MIB major mode"
        (data))
    ("telnet.el"
        "run a telnet session from within an Emacs buffer"
        (unix  comm))
    ("webjump.el"
        "programmable Web hotlist"
        (comm www))
    ("zone-mode.el"
        "major mode for editing DNS zone files"
        (dns  languages))
    ("5x5.el"
        "simple little puzzle game"
        (games puzzles))
    ("animate.el"
        "make text dance"
        (games))
    ("blackbox.el"
        "blackbox game in Emacs Lisp"
        (games))
    ("bruce.el"
        "bruce phrase utility for overloading the Communications"
        (games))
    ("cookie1.el"
        "retrieve random phrases from fortune cookie files"
        (games  extensions))
    ("decipher.el"
        "cryptanalyze monoalphabetic substitution ciphers"
        (games))
    ("dissociate.el"
        "scramble text amusingly for Emacs"
        (games))
    ("doctor.el"
        "psychological help for frustrated users"
        (games))
    ("dunnet.el"
        "text adventure for Emacs"
        (games))
    ("fortune.el"
        "use fortune to create signatures"
        (games utils mail))
    ("gamegrid.el"
        "library for implementing grid-based games on Emacs"
        (games))
    ("gametree.el"
        "manage game analysis trees in Emacs"
        (games))
    ("gomoku.el"
        "Gomoku game between you and Emacs"
        (games))
    ("handwrite.el"
        "turns your emacs buffer into a handwritten document"
        (wp  print  postscript  cursive writing))
    ("hanoi.el"
        "towers of hanoi in Emacs"
        (games))
    ("landmark.el"
        "neural-network robot that learns landmarks"
        (gomoku neural network adaptive search chemotaxis))
    ("life.el"
        "John Horton Conway's `Life' game for GNU Emacs"
        (games))
    ("meese.el"
        "protect the impressionable young minds of America"
        (games))
    ("morse.el"
        "convert text to morse code and back"
        (games))
    ("mpuz.el"
        "multiplication puzzle for GNU Emacs"
        (games))
    ("pong.el"
        "classical implementation of pong"
        (games))
    ("snake.el"
        "implementation of Snake for Emacs"
        (games))
    ("solitaire.el"
        "game of solitaire in Emacs Lisp"
        (games))
    ("spook.el"
        "spook phrase utility for overloading the NSA line eater"
        (games))
    ("studly.el"
        "StudlyCaps (tm)(r)(c)(xxx)"
        (games))
    ("tetris.el"
        "implementation of Tetris for Emacs"
        (games))
    ("yow.el"
        "quote random zippyisms"
        (games))
    ("zone.el"
        "idle display hacks"
        (games))
    ("ada-mode.el"
        "major-mode for editing Ada sources"
        (languages ada))
    ("ada-prj.el"
        "easy editing of project files for the ada-mode"
        (languages  ada  project file))
    ("ada-stmt.el"
        "an extension to Ada mode for inserting statement templates"
        (languages  ada))
    ("ada-xref.el"
        "for lookup and completion in Ada mode"
        (languages ada xref))
    ("antlr-mode.el"
        "major mode for ANTLR grammar files"
        (languages))
    ("asm-mode.el"
        "mode for editing assembler code"
        (tools  languages))
    ("autoconf.el"
        "mode for editing Autoconf configure.in files"
        (languages))
    ("awk-mode.el"
        "AWK code editing commands for Emacs"
        (unix  languages))
    ("cc-align.el"
        "custom indentation functions for CC Mode"
        (c languages oop))
    ("cc-bytecomp.el"
        "compile time setup for proper compilation"
        (c languages oop))
    ("cc-cmds.el"
        "user level commands for CC Mode"
        (c languages oop))
    ("cc-compat.el"
        "cc-mode compatibility with c-mode.el confusion"
        (c languages oop))
    ("cc-defs.el"
        "compile time definitions for CC Mode"
        (c languages oop))
    ("cc-engine.el"
        "core syntax guessing engine for CC mode"
        (c languages oop))
    ("cc-langs.el"
        "language specific settings for CC Mode"
        (c languages oop))
    ("cc-menus.el"
        "imenu support for CC Mode"
        (c languages oop))
    ("cc-mode.el"
        "major mode for editing C, C++, Objective-C, and Java code"
        (c languages oop))
    ("cc-styles.el"
        "support for styles in CC Mode"
        (c languages oop))
    ("cc-vars.el"
        "user customization variables for CC Mode"
        (c languages oop))
    ("cmacexp.el"
        "expand C macros in a region"
        (c))
    ("compile.el"
        "run compiler as inferior of Emacs, parse error messages"
        (tools  processes))
    ("cperl-mode.el"
        "Perl code editing commands for Emacs"
        (languages  perl))
    ("cpp.el"
        "highlight or hide text according to cpp conditionals"
        (c  faces  tools))
    ("cwarn.el"
        "highlight suspicious C and C++ constructions"
        (c  languages  faces))
    ("dcl-mode.el"
        "major mode for editing DCL command files"
        (dcl editing major-mode languages))
    ("delphi.el"
        "major mode for editing Delphi source (Object Pascal) in Emacs"
        (languages))
    ("ebnf-bnf.el"
        "parser for EBNF"
        (wp  ebnf  postscript))
    ("ebnf-iso.el"
        "parser for ISO EBNF"
        (wp  ebnf  postscript))
    ("ebnf-otz.el"
        "syntatic chart OpTimiZer"
        (wp  ebnf  postscript))
    ("ebnf-yac.el"
        "parser for Yacc/Bison"
        (wp  ebnf  postscript))
    ("ebnf2ps.el"
        "translate an EBNF to a syntatic chart on PostScript"
        (wp  ebnf  postscript))
    ("ebrowse.el"
        "Emacs C++ class browser & tags facility"
        (c++ tags tools))
    ("etags.el"
        "etags facility for Emacs"
        (tools))
    ("executable.el"
        "base functionality for executable interpreter scripts"
        (languages  unix))
    ("f90.el"
        "Fortran-90 mode (free format)"
        (fortran  f90  languages))
    ("fortran.el"
        "Fortran mode for GNU Emacs"
        (languages))
    ("glasses.el"
        "make cantReadThis readable"
        (tools))
    ("hideif.el"
        "hides selected code within ifdef"
        (c  outlines))
    ("hideshow.el"
        "minor mode cmds to selectively display code/comment blocks"
        (c c++ java lisp tools editing comments blocks hiding outlines))
    ("icon.el"
        "mode for editing Icon code"
        (languages))
    ("idlw-rinfo.el"
        "Routine Information for IDLWAVE"
        (languages))
    ("idlw-shell.el"
        "run IDL or WAVE as an inferior process of Emacs"
        (processes))
    ("idlw-toolbar.el"
        "a debugging toolbar for IDLWAVE"
        (processes))
    ("idlwave.el"
        "IDL and WAVE CL editing mode for GNU Emacs"
        (languages))
    ("inf-lisp.el"
        "an inferior-lisp mode"
        (processes  lisp))
    ("m4-mode.el"
        "m4 code editing commands for Emacs"
        (languages  faces))
    ("make-mode.el"
        "makefile editing commands for Emacs"
        (unix  tools))
    ("mantemp.el"
        "create manual template instantiations from g++ 2.7.2 output"
        (g++  templates))
    ("meta-mode.el"
        "major mode for editing Metafont or MetaPost sources"
        (metafont  metapost  tex  languages))
    ("modula2.el"
        "Modula-2 editing support package"
        (languages))
    ("octave-hlp.el"
        "getting help on Octave symbols using info"
        (languages))
    ("octave-inf.el"
        "running Octave as an inferior Emacs process"
        (languages))
    ("octave-mod.el"
        "editing Octave source files under Emacs"
        (languages))
    ("pascal.el"
        "major mode for editing pascal source in Emacs"
        (languages))
    ("perl-mode.el"
        "Perl code editing commands for GNU Emacs"
        (languages))
    ("prolog.el"
        "major mode for editing and running Prolog under Emacs"
        (languages))
    ("ps-mode.el"
        "PostScript mode for GNU Emacs"
        (postscript  languages))
    ("scheme.el"
        "Scheme (and DSSSL) editing mode"
        (languages  lisp))
    ("sh-script.el"
        "shell-script editing commands for Emacs"
        (languages  unix))
    ("simula.el"
        "SIMULA 87 code editing commands for Emacs"
        (languages))
    ("sql.el"
        "specialized comint.el for SQL interpreters"
        (comm languages processes))
    ("tcl.el"
        "Tcl code editing commands for Emacs"
        (languages tcl modes))
    ("vhdl-mode.el"
        "major mode for editing VHDL code"
        (languages vhdl))
    ("artist.el"
        "draw ascii graphics with your mouse"
        (mouse))
    ("bib-mode.el"
        "major mode for editing bib files"
        (bib))
    ("bibtex.el"
        "BibTeX mode for GNU Emacs"
        (bibtex  latex  tex))
    ("fill.el"
        "fill commands for Emacs"
        (wp))
    ("flyspell.el"
        "on-the-fly spell checker"
        (convenience))
    ("ispell.el"
        "interface to International Ispell Versions 3.1 and 3.2"
        (unix wp))
    ("makeinfo.el"
        "run makeinfo conveniently"
        (docs convenience))
    ("nroff-mode.el"
        "GNU Emacs major mode for editing nroff source"
        (wp))
    ("outline.el"
        "outline mode commands for Emacs"
        (outlines))
    ("page-ext.el"
        "extended page handling commands"
        (wp data))
    ("page.el"
        "page motion commands for Emacs"
        (wp convenience))
    ("paragraphs.el"
        "paragraph and sentence parsing"
        (wp))
    ("picture.el"
        "\"Picture mode\" -- editing using quarter-plane screen model"
        (convenience wp))
    ("refbib.el"
        "convert refer-style references to ones usable by Latex bib"
        (bib  tex))
    ("refer.el"
        "look up references in bibliography files"
        (bib))
    ("refill.el"
        "`auto-fill' by refilling paragraphs on changes"
        (wp))
    ("reftex-auc.el"
        "RefTeX's interface to AUC TeX"
        nil)
    ("reftex-cite.el"
        "creating citations with RefTeX"
        nil)
    ("reftex-dcr.el"
        "viewing cross references and citations with RefTeX"
        nil)
    ("reftex-global.el"
        "operations on entire documents with RefTeX"
        nil)
    ("reftex-index.el"
        "index support with RefTeX"
        nil)
    ("reftex-parse.el"
        "parser functions for RefTeX"
        nil)
    ("reftex-ref.el"
        "code to create labels and references with RefTeX"
        nil)
    ("reftex-sel.el"
        "the selection modes for RefTeX"
        nil)
    ("reftex-toc.el"
        "RefTeX's table of contents mode"
        nil)
    ("reftex-vars.el"
        "configuration variables for RefTeX"
        nil)
    ("reftex.el"
        "minor mode for doing \\label, \\ref, \\cite, \\index in LaTeX"
        (tex))
    ("scribe.el"
        "scribe mode, and its idiosyncratic commands"
        (wp))
    ("sgml-mode.el"
        "SGML- and HTML-editing modes"
        (wp  hypermedia  comm  languages))
    ("spell.el"
        "spelling correction interface for Emacs"
        (wp  unix))
    ("tex-mode.el"
        "TeX, LaTeX, and SliTeX mode commands"
        (tex))
    ("texinfmt.el"
        "format Texinfo files into Info files"
        (maint  tex  docs))
    ("texinfo.el"
        "major mode for editing Texinfo files"
        (maint  tex  docs))
    ("texnfo-upd.el"
        "utilities for updating nodes and menus in Texinfo files"
        (maint  tex  docs))
    ("text-mode.el"
        "text mode, and its idiosyncratic commands"
        (wp))
    ("tildify.el"
        "adding hard spaces into texts"
        (text  tex  sgml  wp))
    ("two-column.el"
        "minor mode for editing of two-column text"
        (wp))
    ("underline.el"
        "insert/remove underlining (done by overstriking) in Emacs"
        (wp))
    ("tool-bar.el"
        "setting up the tool bar"
        (mouse frames))
))

(provide 'finder-inf)

;;; Local Variables:
;;; version-control: never
;;; no-byte-compile: t
;;; no-update-autoloads: t
;;; End:
;;; finder-inf.el ends here
