/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class DeflateTransformer
extends Transformer {
    private Deflater compressor;
    private Inflater decompressor;
    private int outputBlockSize;
    private byte[] zlibBuffer;

    private /* synthetic */ void finit$() {
        this.outputBlockSize = 512;
    }

    DeflateTransformer() {
        this.finit$();
    }

    void initDelegate(Map map) throws TransformerException {
        if (this.tail == null) {
            IllegalStateException illegalStateException = new IllegalStateException("Compression transformer missing its tail!");
            throw new TransformerException("initDelegate()", illegalStateException);
        }
        this.outputBlockSize = this.tail.currentBlockSize();
        this.zlibBuffer = new byte[this.outputBlockSize];
        Direction direction = (Direction)map.get("gnu.crypto.assembly.transformer.direction");
        if (direction == Direction.FORWARD) {
            this.compressor = new Deflater();
        } else {
            this.decompressor = new Inflater();
        }
    }

    int delegateBlockSize() {
        return 1;
    }

    void resetDelegate() {
        this.compressor = null;
        this.decompressor = null;
        this.outputBlockSize = 1;
        this.zlibBuffer = null;
    }

    byte[] updateDelegate(byte[] byArray, int n, int n2) throws TransformerException {
        if (this.wired == Direction.FORWARD) {
            this.compressor.setInput(byArray, n, n2);
            while (!this.compressor.needsInput()) {
                this.compress();
            }
        } else {
            this.decompress(byArray, n, n2);
        }
        byte[] byArray2 = this.inBuffer.toByteArray();
        this.inBuffer.reset();
        return byArray2;
    }

    byte[] lastUpdateDelegate() throws TransformerException {
        if (this.wired == Direction.FORWARD) {
            if (!this.compressor.finished()) {
                this.compressor.finish();
                while (!this.compressor.finished()) {
                    this.compress();
                }
            }
        } else if (!this.decompressor.finished()) {
            IllegalStateException illegalStateException = new IllegalStateException("Compression transformer, after last update, must be finished but isn't");
            throw new TransformerException("lastUpdateDelegate()", illegalStateException);
        }
        byte[] byArray = this.inBuffer.toByteArray();
        this.inBuffer.reset();
        return byArray;
    }

    private void compress() {
        int n = this.compressor.deflate(this.zlibBuffer);
        if (n > 0) {
            this.inBuffer.write(this.zlibBuffer, 0, n);
        }
    }

    private void decompress(byte[] byArray, int n, int n2) throws TransformerException {
        this.decompressor.setInput(byArray, n, n2);
        int n3 = 1;
        while (n3 > 0) {
            try {
                n3 = this.decompressor.inflate(this.zlibBuffer);
            }
            catch (DataFormatException dataFormatException) {
                throw new TransformerException("decompress()", dataFormatException);
            }
            if (n3 <= 0) continue;
            this.inBuffer.write(this.zlibBuffer, 0, n3);
        }
    }
}

