/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class LogRecord
implements Serializable {
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient Object[] parameters;
    private transient ResourceBundle bundle;
    static final long serialVersionUID = 5372048053134512534L;
    private static long lastSeqNum;

    public LogRecord(Level level, String string) {
        this.level = level;
        this.message = string;
        this.millis = System.currentTimeMillis();
        this.threadID = System.identityHashCode(Thread.currentThread());
        this.sequenceNumber = LogRecord.allocateSeqNum();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        int n = objectInputStream.readInt();
        if (n >= 0) {
            this.parameters = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.parameters[i] = objectInputStream.readObject();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(0);
        objectOutputStream.writeByte(0);
        if (this.parameters == null) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(this.parameters.length);
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null) {
                    objectOutputStream.writeObject(null);
                    continue;
                }
                objectOutputStream.writeObject(this.parameters[i].toString());
            }
        }
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
        this.resourceBundleName = null;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
        this.bundle = null;
        try {
            if (this.resourceBundleName != null) {
                this.bundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    private static synchronized long allocateSeqNum() {
        return ++lastSeqNum;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getSourceClassName() {
        if (this.sourceClassName != null) {
            return this.sourceClassName;
        }
        return null;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
    }

    public String getSourceMethodName() {
        if (this.sourceMethodName != null) {
            return this.sourceMethodName;
        }
        return null;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }
}

