/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Stack;

public class QtImageGraphics
extends QtGraphics {
    Image parentImage;
    Stack owners;
    QtImageGraphics topParent;

    public QtImageGraphics(Image image) {
        int h;
        int w;
        if (!(image instanceof QtVolatileImage) && !(image instanceof QtImage)) {
            throw new IllegalArgumentException("Cannot create QtImageGraphics for a non-QImage context.");
        }
        this.owners = new Stack();
        this.owners.push(this);
        this.topParent = null;
        if (image instanceof QtImage) {
            w = ((QtImage)image).width;
            h = ((QtImage)image).height;
            this.initImage((QtImage)image);
            ((QtImage)image).putPainter(this);
        } else {
            w = ((QtVolatileImage)image).width;
            h = ((QtVolatileImage)image).height;
            this.initVolatileImage((QtVolatileImage)image);
            ((QtVolatileImage)image).putPainter(this);
        }
        this.parentImage = image;
        this.initialClip = new Rectangle(0, 0, w, h);
        this.setClip(this.initialClip);
        this.setBackground(Color.white);
        this.currentAlpha = 1.0;
        this.setColor(Color.black);
        this.setup();
    }

    QtImageGraphics(QtImageGraphics g) {
        super(g);
        this.parentImage = g.parentImage;
        if (this.parentImage instanceof QtImage) {
            ((QtImage)this.parentImage).putPainter(this);
        } else {
            ((QtVolatileImage)this.parentImage).putPainter(this);
        }
    }

    public void dispose() {
        this.delete();
        if (this.parentImage instanceof QtImage) {
            ((QtImage)this.parentImage).removePainter(this);
        } else {
            ((QtVolatileImage)this.parentImage).removePainter(this);
        }
    }

    public Graphics create() {
        return new QtImageGraphics(this);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.parentImage instanceof QtImage) {
            ((QtImage)this.parentImage).copyArea(x, y, width, height, dx, dy);
        } else {
            ((QtVolatileImage)this.parentImage).copyArea(x, y, width, height, dx, dy);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

