/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;

public final class ObjID
implements Serializable {
    static final long serialVersionUID = -6386392263968365220L;
    private static long next = Long.MIN_VALUE;
    private static final Object lock = ObjID.class;
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    long objNum;
    UID space;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjID() {
        Object object = lock;
        synchronized (object) {
            this.objNum = next++;
        }
        this.space = new UID();
    }

    public ObjID(int id) {
        this.objNum = id;
        this.space = new UID(0);
    }

    public void write(ObjectOutput out) throws IOException {
        ObjectOutput dout = out;
        dout.writeLong(this.objNum);
        this.space.write(dout);
    }

    public static ObjID read(ObjectInput in) throws IOException {
        ObjectInput din = in;
        ObjID id = new ObjID();
        id.objNum = din.readLong();
        id.space = UID.read(din);
        return id;
    }

    public int hashCode() {
        return this.space == null ? (int)this.objNum : this.space.hashCode() ^ (int)this.objNum;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjID) {
            ObjID that = (ObjID)obj;
            return that.objNum == this.objNum && ObjID.eq(that.space, this.space);
        }
        return false;
    }

    static final boolean eq(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public String toString() {
        return String.valueOf(this.objNum) + ":" + this.space;
    }
}

