/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private long mostSigBits;
    private long leastSigBits;
    private static transient Random r = new Random();

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >> 48);
    }

    @Override
    public int compareTo(UUID o) {
        if (this.mostSigBits < o.mostSigBits) {
            return -1;
        }
        if (this.mostSigBits > o.mostSigBits) {
            return 1;
        }
        if (this.leastSigBits < o.leastSigBits) {
            return -1;
        }
        if (this.leastSigBits > o.mostSigBits) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        return ((UUID)obj).mostSigBits == this.mostSigBits && ((UUID)obj).leastSigBits == this.leastSigBits;
    }

    public static UUID fromString(String name) {
        StringTokenizer st = new StringTokenizer(name.trim(), "-");
        if (st.countTokens() < 5) {
            throw new IllegalArgumentException("Incorrect UUID string representation:" + name);
        }
        long msb = Long.parseLong(st.nextToken(), 16) << 32;
        msb |= Long.parseLong(st.nextToken(), 16) << 16;
        long lsb = Long.parseLong(st.nextToken(), 16) << 48;
        return new UUID(msb |= Long.parseLong(st.nextToken(), 16), lsb |= Long.parseLong(st.nextToken(), 16));
    }

    public String toString() {
        return String.valueOf(this.padHex((this.mostSigBits & 0xFFFFFFFF00000000L) >> 32 & 0xFFFFFFFFL, 8)) + "-" + this.padHex((this.mostSigBits & 0xFFFF0000L) >> 16, 4) + "-" + this.padHex(this.mostSigBits & 0xFFFFL, 4) + "-" + this.padHex((this.leastSigBits & 0xFFFF000000000000L) >> 48 & 0xFFFFL, 4) + "-" + this.padHex(this.leastSigBits & 0xFFFFFFFFFFFFL, 12);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int hashCode() {
        int l1 = (int)(this.leastSigBits & 0xFFFFFFFFL);
        int l2 = (int)((this.leastSigBits & 0xFFFFFFFF00000000L) >> 32);
        int m1 = (int)(this.mostSigBits & 0xFFFFFFFFL);
        int m2 = (int)((this.mostSigBits & 0xFFFFFFFF00000000L) >> 32);
        return l1 ^ l2 ^ (m1 ^ m2);
    }

    public static UUID nameUUIDFromBytes(byte[] name) {
        byte[] hash;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            hash = md5.digest(name);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("No MD5 algorithm available.");
        }
        long msb = ((long)hash[0] & 0xFFL) << 56 | ((long)hash[1] & 0xFFL) << 48 | ((long)hash[2] & 0xFFL) << 40 | ((long)hash[3] & 0xFFL) << 32 | ((long)hash[4] & 0xFFL) << 24 | ((long)hash[5] & 0xFFL) << 16 | ((long)hash[6] & 0xFFL) << 8 | (long)hash[7] & 0xFFL;
        long lsb = ((long)hash[8] & 0xFFL) << 56 | ((long)hash[9] & 0xFFL) << 48 | ((long)hash[10] & 0xFFL) << 40 | ((long)hash[11] & 0xFFL) << 32 | ((long)hash[12] & 0xFFL) << 24 | ((long)hash[13] & 0xFFL) << 16 | ((long)hash[14] & 0xFFL) << 8 | (long)hash[15] & 0xFFL;
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        msb &= 0xFFFFFFFFFFFF0FFFL;
        return new UUID(msb |= 0x3000L, lsb |= Long.MIN_VALUE);
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        long time = (this.mostSigBits & 0xFFFFFFFF00000000L) >> 32;
        time |= (this.mostSigBits & 0xFFFF0000L) << 16;
        long time_hi = this.mostSigBits & 0xFFFL;
        return time |= time_hi << 48;
    }

    public static UUID randomUUID() {
        long lsb = r.nextLong();
        long msb = r.nextLong();
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        msb &= 0xFFFFFFFFFFFF0FFFL;
        return new UUID(msb |= 0x4000L, lsb |= Long.MIN_VALUE);
    }

    private String padHex(long l, int n) {
        String s = Long.toHexString(l);
        while (s.length() < n) {
            s = "0" + s;
        }
        return s;
    }

    public int variant() {
        int v = (int)((this.leastSigBits & 0xE000000000000000L) >> 61);
        if ((v & 4) == 0) {
            return 0;
        }
        if ((v & 2) == 0) {
            return 2;
        }
        return v;
    }

    public int version() {
        return (int)((this.mostSigBits & 0xF000L) >> 12);
    }
}

