##
# $Id: db2_version.rb 9551 2010-06-17 15:16:39Z todb $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##


require 'msf/core'


class Metasploit3 < Msf::Auxiliary

	include Msf::Exploit::Remote::DB2
	include Msf::Auxiliary::Scanner
	include Msf::Auxiliary::Report

	def initialize
		super(
			'Name'           => 'DB2 Probe Utility',
			'Version'        => '$Revision: 9551 $',
			'Description'    => 'This module queries a DB2 instance information.',
			'Author'         => ['todb'],
			'License'        => MSF_LICENSE
		)
		register_options(
			[
				OptBool.new('VERBOSE', [ true, 'Verbose output', false]),
				OptInt.new('TIMEOUT', [true, 'Timeout for the DB2 probe', 5])
		], self.class)

		deregister_options('USERNAME' , 'PASSWORD')
	end

	def to
		return 5 if datastore['TIMEOUT'].to_i.zero?
		datastore['TIMEOUT'].to_i
	end

	def run_host(ip)
		verbose = datastore['VERBOSE']
		begin

			info = db2_probe(to)
			if info[:excsatrd]
				inst,plat,ver,pta = info[:instance_name],info[:platform],info[:version],info[:plaintext_auth]
				report_info = "Platform: #{plat}, Version: #{ver}, Instance: #{inst}, Plain-Authentication: #{pta ? "OK" : "NO"}"
				print_status("#{ip}:#{rport} DB2 - #{report_info}")
				report_service(
					:host => rhost,
					:port => rport,
					:name => "db2",
					:info => report_info
				)
			end
			disconnect

		rescue ::Rex::ConnectionRefused
			print_error("#{rhost}:#{rport} : Cannot connect to host") if verbose
			return :done
		rescue ::Rex::ConnectionError
			print_error("#{rhost}:#{rport} : Unable to attempt probe") if verbose
			return :done
		rescue ::Rex::Proto::DRDA::RespError => e
			print_error("#{rhost}:#{rport} : Error in connecting to DB2 instance: #{e}") if verbose
			return :error
		end
	end
end
