/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Bezier;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierTool
extends AbstractTool {
    private static final boolean DEBUG = false;
    private Boolean finishWhenMouseReleased;
    protected Map<AttributeKey, Object> attributes;
    private boolean isToolDoneAfterCreation;
    private BezierFigure prototype;
    protected BezierFigure createdFigure;
    private int nodeCountBeforeDrag;
    private String presentationName;
    private Point mouseLocation;
    private DrawingView creationView;

    public BezierTool(BezierFigure bezierFigure) {
        this(bezierFigure, null);
    }

    public BezierTool(BezierFigure bezierFigure, Map<AttributeKey, Object> map) {
        this(bezierFigure, map, null);
    }

    public BezierTool(BezierFigure bezierFigure, Map<AttributeKey, Object> map, String string) {
        this.prototype = bezierFigure;
        this.attributes = map;
        if (string == null) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            string = resourceBundleUtil.getString("edit.createFigure.text");
        }
        this.presentationName = string;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        if (this.createdFigure != null) {
            if (this.anchor != null && this.mouseLocation != null) {
                Rectangle rectangle = new Rectangle(this.anchor);
                rectangle.add(this.mouseLocation);
                if (this.createdFigure.getNodeCount() > 0 && this.createdFigure.isClosed()) {
                    rectangle.add(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                }
                this.fireAreaInvalidated(rectangle);
            }
            this.finishCreation(this.createdFigure, this.creationView);
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseLocation != null) {
            Rectangle rectangle = new Rectangle(this.mouseLocation);
            rectangle.add(mouseEvent.getPoint());
            rectangle.grow(1, 1);
            this.fireAreaInvalidated(rectangle);
        }
        this.mouseLocation = mouseEvent.getPoint();
        super.mousePressed(mouseEvent);
        if (this.createdFigure != null && this.creationView != this.getView()) {
            this.finishCreation(this.createdFigure, this.creationView);
            this.createdFigure = null;
        }
        if (this.createdFigure == null) {
            this.creationView = this.getView();
            this.creationView.clearSelection();
            this.finishWhenMouseReleased = null;
            this.createdFigure = this.createFigure();
            this.createdFigure.addNode(new BezierPath.Node(this.creationView.getConstrainer().constrainPoint(this.creationView.viewToDrawing(this.anchor))));
            this.getDrawing().add(this.createdFigure);
        } else if (mouseEvent.getClickCount() == 1) {
            this.addPointToFigure(this.creationView.getConstrainer().constrainPoint(this.creationView.viewToDrawing(this.anchor)));
        }
        this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
    }

    protected BezierFigure createFigure() {
        BezierFigure bezierFigure = this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(bezierFigure);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                bezierFigure.set(entry.getKey(), entry.getValue());
            }
        }
        return bezierFigure;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void addPointToFigure(Point2D.Double double_) {
        int n = this.createdFigure.getNodeCount();
        this.createdFigure.willChange();
        if (n < 2) {
            this.createdFigure.addNode(new BezierPath.Node(double_));
        } else {
            Point2D.Double double_2;
            Point2D.Double double_3 = this.createdFigure.getEndPoint();
            Point2D.Double double_4 = double_2 = n <= 1 ? double_3 : this.createdFigure.getPoint(n - 2, 0);
            if (!double_.equals(double_3)) {
                if (n > 1 && Geom.lineContainsPoint(double_.x, double_.y, double_2.x, double_2.y, double_3.x, double_3.y, (double)0.9f / this.getView().getScaleFactor())) {
                    this.createdFigure.setPoint(n - 1, 0, double_);
                } else {
                    this.createdFigure.addNode(new BezierPath.Node(double_));
                }
            }
        }
        this.createdFigure.changed();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    if (this.createdFigure.getNodeCount() <= 2) break;
                    Rectangle rectangle = new Rectangle(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                    rectangle.grow(2, 2);
                    if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                    this.createdFigure.setClosed(true);
                    this.finishCreation(this.createdFigure, this.creationView);
                    this.createdFigure = null;
                    if (!this.isToolDoneAfterCreation) break;
                    this.fireToolDone();
                    break;
                }
                case 2: {
                    this.finishWhenMouseReleased = null;
                    this.finishCreation(this.createdFigure, this.creationView);
                    this.createdFigure = null;
                }
            }
        }
    }

    protected void fireUndoEvent(Figure figure, DrawingView drawingView) {
        final Figure figure2 = figure;
        final Drawing drawing = drawingView.getDrawing();
        final DrawingView drawingView2 = drawingView;
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return BezierTool.this.presentationName;
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                drawing.remove(figure2);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                drawingView2.clearSelection();
                drawing.add(figure2);
                drawingView2.addToSelection(figure2);
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Shape shape;
        this.isWorking = false;
        if (this.createdFigure.getNodeCount() > this.nodeCountBeforeDrag + 1) {
            this.createdFigure.willChange();
            shape = this.createdFigure.getBezierPath();
            BezierPath bezierPath = new BezierPath();
            int n = ((ArrayList)((Object)shape)).size();
            for (int i = this.nodeCountBeforeDrag - 1; i < n; ++i) {
                bezierPath.add(((ArrayList)((Object)shape)).get(this.nodeCountBeforeDrag - 1));
                ((ArrayList)((Object)shape)).remove(this.nodeCountBeforeDrag - 1);
            }
            BezierPath bezierPath2 = this.calculateFittedCurve(bezierPath);
            ((ArrayList)((Object)shape)).addAll(bezierPath2);
            this.createdFigure.setBezierPath((BezierPath)shape);
            this.createdFigure.changed();
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        }
        if (this.finishWhenMouseReleased == Boolean.TRUE) {
            if (this.createdFigure.getNodeCount() > 1) {
                this.finishCreation(this.createdFigure, this.creationView);
                this.createdFigure = null;
                this.finishWhenMouseReleased = null;
                return;
            }
        } else if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.FALSE;
        }
        shape = new Rectangle(this.anchor);
        ((Rectangle)shape).add(this.mouseLocation);
        ((Rectangle)shape).add(mouseEvent.getPoint());
        ((Rectangle)shape).grow(1, 1);
        this.fireAreaInvalidated((Rectangle)shape);
        this.anchor.x = mouseEvent.getX();
        this.anchor.y = mouseEvent.getY();
        this.mouseLocation = mouseEvent.getPoint();
    }

    protected void finishCreation(BezierFigure bezierFigure, DrawingView drawingView) {
        this.fireUndoEvent(bezierFigure, drawingView);
        drawingView.addToSelection(bezierFigure);
        if (this.isToolDoneAfterCreation) {
            this.fireToolDone();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.TRUE;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.addPointToFigure(this.getView().viewToDrawing(new Point(n, n2)));
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.createdFigure != null && this.anchor != null && this.mouseLocation != null && this.getView() == this.creationView) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 5.0f}, 0.0f));
            graphics2D.drawLine(this.anchor.x, this.anchor.y, this.mouseLocation.x, this.mouseLocation.y);
            if (!this.isWorking && this.createdFigure.isClosed() && this.createdFigure.getNodeCount() > 1) {
                Point point = this.creationView.drawingToView(this.createdFigure.getStartPoint());
                graphics2D.drawLine(this.mouseLocation.x, this.mouseLocation.y, point.x, point.y);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.createdFigure != null && this.anchor != null && this.mouseLocation != null && mouseEvent.getSource() == this.creationView) {
            Rectangle rectangle = new Rectangle(this.anchor);
            rectangle.add(this.mouseLocation);
            rectangle.add(mouseEvent.getPoint());
            if (this.createdFigure.isClosed() && this.createdFigure.getNodeCount() > 0) {
                rectangle.add(this.creationView.drawingToView(this.createdFigure.getStartPoint()));
            }
            rectangle.grow(1, 1);
            this.fireAreaInvalidated(rectangle);
            this.mouseLocation = mouseEvent.getPoint();
        }
    }

    protected BezierPath calculateFittedCurve(BezierPath bezierPath) {
        return Bezier.fitBezierPath(bezierPath, 1.5 / this.getView().getScaleFactor());
    }

    public void setToolDoneAfterCreation(boolean bl) {
        this.isToolDoneAfterCreation = bl;
    }

    public boolean isToolDoneAfterCreation() {
        return this.isToolDoneAfterCreation;
    }
}

