/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.net.Uri;
import android.util.Log;
import android.webkit.CookieManager;
import com.phonegap.FileUploadResult;
import com.phonegap.FileUtils;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileTransfer
extends Plugin {
    private static final String LOG_TAG = "FileTransfer";
    private static final String LINE_START = "--";
    private static final String LINE_END = "\r\n";
    private static final String BOUNDRY = "*****";
    public static int FILE_NOT_FOUND_ERR = 1;
    public static int INVALID_URL_ERR = 2;
    public static int CONNECTION_ERR = 3;
    private SSLSocketFactory defaultSSLSocketFactory = null;
    private HostnameVerifier defaultHostnameVerifier = null;
    static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        String source = null;
        String target = null;
        try {
            source = args.getString(0);
            target = args.getString(1);
        }
        catch (JSONException e) {
            Log.d((String)LOG_TAG, (String)"Missing source or target");
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION, "Missing source or target");
        }
        try {
            if (action.equals("upload")) {
                String fileKey = null;
                String fileName = null;
                String mimeType = null;
                fileKey = this.getArgument(args, 2, "file");
                fileName = this.getArgument(args, 3, "image.jpg");
                mimeType = this.getArgument(args, 4, "image/jpeg");
                JSONObject params = args.optJSONObject(5);
                boolean trustEveryone = args.optBoolean(6);
                boolean chunkedMode = args.optBoolean(7);
                FileUploadResult r = this.upload(source, target, fileKey, fileName, mimeType, params, trustEveryone, chunkedMode);
                Log.d((String)LOG_TAG, (String)"****** About to return a result from upload");
                return new PluginResult(PluginResult.Status.OK, r.toJSONObject());
            }
            if (action.equals("download")) {
                JSONObject r = this.download(source, target);
                Log.d((String)LOG_TAG, (String)"****** About to return a result from download");
                return new PluginResult(PluginResult.Status.OK, r, "window.localFileSystem._castEntry");
            }
            return new PluginResult(PluginResult.Status.INVALID_ACTION);
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            JSONObject error = this.createFileTransferError(FILE_NOT_FOUND_ERR, source, target);
            return new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            JSONObject error = this.createFileTransferError(INVALID_URL_ERR, source, target);
            return new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
        }
        catch (SSLException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            Log.d((String)LOG_TAG, (String)"Got my ssl exception!!!");
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target);
            return new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target);
            return new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    private void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            this.defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private JSONObject createFileTransferError(int errorCode, String source, String target) {
        JSONObject error = null;
        try {
            error = new JSONObject();
            error.put("code", errorCode);
            error.put("source", (Object)source);
            error.put("target", (Object)target);
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return error;
    }

    private String getArgument(JSONArray args, int position, String defaultString) {
        String arg = defaultString;
        if (args.length() >= position && ((arg = args.optString(position)) == null || "null".equals(arg))) {
            arg = defaultString;
        }
        return arg;
    }

    public FileUploadResult upload(String file, String server, String fileKey, String fileName, String mimeType, JSONObject params, boolean trustEveryone, boolean chunkedMode) throws IOException, SSLException {
        String line;
        DataInputStream inStream;
        FileUploadResult result = new FileUploadResult();
        InputStream fileInputStream = this.getPathFromUri(file);
        HttpURLConnection conn = null;
        DataOutputStream dos = null;
        int maxBufferSize = 8096;
        URL url = new URL(server);
        if (url.getProtocol().toLowerCase().equals("https")) {
            if (!trustEveryone) {
                conn = (HttpsURLConnection)url.openConnection();
            } else {
                this.trustAllHosts();
                HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                this.defaultHostnameVerifier = https.getHostnameVerifier();
                https.setHostnameVerifier(DO_NOT_VERIFY);
                conn = https;
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
        String cookie = CookieManager.getInstance().getCookie(server);
        if (cookie != null) {
            conn.setRequestProperty("Cookie", cookie);
        }
        if (chunkedMode) {
            conn.setChunkedStreamingMode(maxBufferSize);
        }
        dos = new DataOutputStream(conn.getOutputStream());
        try {
            Iterator iter = params.keys();
            while (iter.hasNext()) {
                Object key = iter.next();
                dos.writeBytes("--*****\r\n");
                dos.writeBytes("Content-Disposition: form-data; name=\"" + key.toString() + "\";");
                dos.writeBytes("\r\n\r\n");
                dos.write(params.getString(key.toString()).getBytes());
                dos.writeBytes(LINE_END);
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        dos.writeBytes("--*****\r\n");
        dos.writeBytes("Content-Disposition: form-data; name=\"" + fileKey + "\";" + " filename=\"" + fileName + "\"" + LINE_END);
        dos.writeBytes("Content-Type: " + mimeType + LINE_END);
        dos.writeBytes(LINE_END);
        int bytesAvailable = fileInputStream.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        long totalBytes = 0L;
        while (bytesRead > 0) {
            result.setBytesSent(totalBytes += (long)bytesRead);
            dos.write(buffer, 0, bufferSize);
            bytesAvailable = fileInputStream.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        }
        dos.writeBytes(LINE_END);
        dos.writeBytes("--*****--\r\n");
        fileInputStream.close();
        dos.flush();
        dos.close();
        StringBuffer responseString = new StringBuffer("");
        try {
            inStream = new DataInputStream(conn.getInputStream());
        }
        catch (FileNotFoundException e) {
            throw new IOException("Received error from server");
        }
        while ((line = inStream.readLine()) != null) {
            responseString.append(line);
        }
        Log.d((String)LOG_TAG, (String)"got response from server");
        Log.d((String)LOG_TAG, (String)responseString.toString());
        result.setResponseCode(conn.getResponseCode());
        result.setResponse(responseString.toString());
        inStream.close();
        conn.disconnect();
        if (trustEveryone && url.getProtocol().toLowerCase().equals("https")) {
            ((HttpsURLConnection)conn).setHostnameVerifier(this.defaultHostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(this.defaultSSLSocketFactory);
        }
        return result;
    }

    public JSONObject download(String source, String target) throws IOException {
        try {
            File file = new File(target);
            file.getParentFile().mkdirs();
            URL url = new URL(source);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Log.d((String)LOG_TAG, (String)("Download file:" + url));
            InputStream inputStream = connection.getInputStream();
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            FileOutputStream outputStream = new FileOutputStream(file);
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            Log.d((String)LOG_TAG, (String)("Saved file: " + target));
            FileUtils fileUtil = new FileUtils();
            return fileUtil.getEntry(file);
        }
        catch (Exception e) {
            Log.d((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            throw new IOException("Error while downloading");
        }
    }

    private InputStream getPathFromUri(String path) throws FileNotFoundException {
        if (path.startsWith("content:")) {
            Uri uri = Uri.parse((String)path);
            return this.ctx.getContentResolver().openInputStream(uri);
        }
        if (path.startsWith("file://")) {
            int question = path.indexOf("?");
            if (question == -1) {
                return new FileInputStream(path.substring(7));
            }
            return new FileInputStream(path.substring(7, question));
        }
        return new FileInputStream(path);
    }
}

