/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ClassUtil {
    private static final int TYPE_NOT_FOUND = 10008;
    private static final int UNEXPECTED_TYPE = 10009;
    private static final int CANNOT_CREATE_TYPE = 10010;
    private static final int SECURITY_ERROR = 10011;
    private static final int UNKNOWN_ERROR = 10012;

    private ClassUtil() {
    }

    public static Class createClass(String type) {
        return ClassUtil.createClass(type, null);
    }

    public static Class createClass(String type, ClassLoader loader) {
        try {
            if (type != null) {
                type = type.trim();
            }
            if (loader == null) {
                return Class.forName(type);
            }
            return Class.forName(type, true, loader);
        }
        catch (ClassNotFoundException cnf) {
            MessageException ex = new MessageException();
            ex.setMessage(10008, new Object[]{type});
            ex.setDetails(10008, "0", new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
    }

    public static Object createDefaultInstance(Class cls, Class expectedInstance) {
        String type = cls.getName();
        try {
            Object instance = cls.newInstance();
            if (expectedInstance != null && !expectedInstance.isInstance(instance)) {
                MessageException ex = new MessageException();
                ex.setMessage(10009, new Object[]{instance.getClass().getName(), expectedInstance.getName()});
                ex.setCode("Server.ResourceUnavailable");
                throw ex;
            }
            return instance;
        }
        catch (IllegalAccessException ia) {
            boolean details = false;
            StringBuffer message = new StringBuffer("Unable to create a new instance of type ");
            message.append(type);
            if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                details = true;
            }
            MessageException ex = new MessageException();
            ex.setMessage(10010, new Object[]{type});
            if (details) {
                ex.setDetails(10010, "0");
            }
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
        catch (InstantiationException ine) {
            String variant = null;
            if (cls != null) {
                if (cls.isInterface()) {
                    variant = "1";
                } else if (ClassUtil.isAbstract(cls)) {
                    variant = "2";
                } else if (!ClassUtil.hasValidDefaultConstructor(cls)) {
                    variant = "3";
                }
            }
            MessageException ex = new MessageException();
            ex.setMessage(10010, new Object[]{type});
            if (variant != null) {
                ex.setDetails(10010, variant);
            }
            ex.setCode("Server.ResourceUnavailable");
            throw ex;
        }
        catch (SecurityException se) {
            MessageException ex = new MessageException();
            ex.setMessage(10011, new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            ex.setRootCause(se);
            throw ex;
        }
        catch (Exception e) {
            MessageException ex = new MessageException();
            ex.setMessage(10012, new Object[]{type});
            ex.setCode("Server.ResourceUnavailable");
            ex.setRootCause(e);
            throw ex;
        }
    }

    public static boolean isAbstract(Class cls) {
        boolean abs = false;
        try {
            if (cls != null) {
                int mod = cls.getModifiers();
                abs = Modifier.isAbstract(mod);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return abs;
    }

    public static boolean hasValidDefaultConstructor(Class cls) {
        boolean valid = false;
        try {
            if (cls != null) {
                Constructor c = cls.getConstructor(new Class[0]);
                int mod = c.getModifiers();
                valid = Modifier.isPublic(mod);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return valid;
    }

    public static String classLoaderToString(ClassLoader cl) {
        if (cl == null) {
            return "null";
        }
        if (cl == ClassLoader.getSystemClassLoader()) {
            return "system";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("hashCode: " + System.identityHashCode(cl) + " (parent " + ClassUtil.classLoaderToString(cl.getParent()) + ")");
        return sb.toString();
    }
}

