/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpedal.examples.simpleviewer.gui.GUI;
import org.jpedal.utils.Messages;

public class OldPreferences {
    JFrame jf = new JFrame("JPedal PDF Preferences");
    JLabel title = new JLabel("Preferences");
    JPanel mainPane = new JPanel(new GridBagLayout());
    JPanel[] settings = new JPanel[4];
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTextField dpi_Input = new JTextField("96");
    String dpiDefaultValue = "96";
    JComboBox searchStyle = new JComboBox<String>(new String[]{"Ext. Window", "Tab Pane", "Menu Bar"});
    int searchStyleDefaultValue = 1;
    JCheckBox border = new JCheckBox();
    int borderDefaultValue = 1;
    JCheckBox update = new JCheckBox();
    boolean updateDefaultValue = true;
    JTextField maxMultiViewers = new JTextField("20");
    String maxMultiViewersDefaultValue = "20";
    JCheckBox autoScroll = new JCheckBox();
    boolean scrollDefaultValue = false;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing"});
    int pageLayoutDefaultValue = 1;
    JList settingsList = new JList<String>(new String[]{"Display", "Viewer"});
    Box setButtons = Box.createHorizontalBox();
    int currentListSelection = 0;

    public void createPreferenceWindow(final GUI gUI) {
        int n;
        this.jf = new JFrame(Messages.getMessage("PageLayoutViewMenu.PreferencesWindowTitle"));
        for (n = 0; n != this.settings.length; ++n) {
            this.settings[n] = new JPanel(new BorderLayout());
        }
        this.settingsList = new JList<String>(new String[]{"Display", "Viewer", "Updates", "MultiViewer"});
        this.settingsList.setSelectedIndex(this.currentListSelection);
        this.settingsList.setSize(50, 100);
        this.dpi_Input = new JTextField(this.dpiDefaultValue);
        this.dpi_Input.setPreferredSize(new Dimension(this.dpi_Input.getFont().getSize() * 4, this.dpi_Input.getFont().getSize() + 10));
        this.maxMultiViewers = new JTextField(this.maxMultiViewersDefaultValue);
        this.maxMultiViewers.setPreferredSize(new Dimension(this.maxMultiViewers.getFont().getSize() * 4, this.maxMultiViewers.getFont().getSize() + 10));
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing")});
        this.border = new JCheckBox();
        this.autoScroll = new JCheckBox();
        this.update = new JCheckBox();
        this.confirm = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.title = new JLabel(Messages.getMessage("PageLayoutViewMenu.Preferences"));
        this.title.setFont(new Font(null, 1, 14));
        this.setButtons.add(this.confirm);
        this.setButtons.add(Box.createHorizontalStrut(30));
        this.setButtons.add(this.cancel);
        block7: for (n = 0; n < this.settingsList.getModel().getSize(); ++n) {
            switch (n) {
                case 0: {
                    this.createDisplaySettings(this.settings[0]);
                    continue block7;
                }
                case 1: {
                    this.createViewerSettings(this.settings[1]);
                    continue block7;
                }
                case 2: {
                    this.createUpdateSettings(this.settings[2]);
                    continue block7;
                }
                case 3: {
                    this.createMultiViewerSettings(this.settings[3]);
                    continue block7;
                }
            }
        }
        this.mainPane = this.buildMainPane(this.mainPane);
        this.jf.getContentPane().setLayout(new BorderLayout());
        this.jf.getContentPane().add((Component)this.mainPane, "Center");
        this.jf.setSize(400, 300);
        this.jf.setResizable(false);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OldPreferences.this.dpiDefaultValue = OldPreferences.this.dpi_Input.getText();
                int n = Integer.parseInt(OldPreferences.this.dpi_Input.getText());
                int n2 = OldPreferences.this.searchStyleDefaultValue = OldPreferences.this.searchStyle.getSelectedIndex();
                int n3 = OldPreferences.this.pageLayoutDefaultValue = OldPreferences.this.pageLayout.getSelectedIndex() + 1;
                OldPreferences.this.borderDefaultValue = 0;
                int n4 = 0;
                if (OldPreferences.this.border.isSelected()) {
                    OldPreferences.this.borderDefaultValue = 1;
                    n4 = 1;
                }
                OldPreferences.this.updateDefaultValue = OldPreferences.this.update.isSelected();
                boolean bl = OldPreferences.this.scrollDefaultValue = OldPreferences.this.autoScroll.isSelected();
                int n5 = Integer.parseInt(OldPreferences.this.maxMultiViewers.getText());
                gUI.setPreferences(n, n2, n4, bl, n3, OldPreferences.this.updateDefaultValue, n5, false);
                OldPreferences.this.jf.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OldPreferences.this.jf.setVisible(false);
            }
        });
        KeyListener keyListener = new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent keyEvent) {
                this.consume = false;
                if (!(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        };
        this.dpi_Input.addKeyListener(keyListener);
        this.maxMultiViewers.addKeyListener(keyListener);
        this.settingsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OldPreferences.this.changeDisplayedSettings();
            }
        });
        this.searchStyle.setSelectedIndex(this.searchStyleDefaultValue);
        this.dpi_Input.setText(this.dpiDefaultValue);
        if (this.borderDefaultValue == 1) {
            this.border.setSelected(true);
        } else {
            this.border.setSelected(false);
        }
        this.autoScroll.setSelected(this.scrollDefaultValue);
        this.update.setSelected(this.updateDefaultValue);
    }

    private JPanel buildMainPane(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.title, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 5;
        jPanel.add((Component)this.settings[0], gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.setButtons, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.settingsList, gridBagConstraints);
        return jPanel;
    }

    private void changeDisplayedSettings() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.mainPane.remove(this.settings[this.currentListSelection]);
        this.mainPane.add((Component)this.settings[this.settingsList.getSelectedIndex()], gridBagConstraints);
        this.mainPane.validate();
        this.mainPane.repaint();
        this.currentListSelection = this.settingsList.getSelectedIndex();
    }

    public void showPreferenceWindow() {
        this.jf.setVisible(true);
    }

    private JPanel createViewerSettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.searchStyle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.pageLayout.setSelectedIndex(this.pageLayoutDefaultValue - 1);
        jPanel.add((Component)this.pageLayout, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.autoScroll, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Viewer Settings"));
        return jPanel;
    }

    private JPanel createDisplaySettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.Dpi")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.dpi_Input, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(Messages.getMessage("PageLayoutViewMenu.Borders_Show")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.border, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Display Settings"));
        return jPanel;
    }

    private JPanel createMultiViewerSettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("Maximum number of MultiViewer Windows "), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.maxMultiViewers, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "MultiViewer Settings"));
        return jPanel;
    }

    private JPanel createUpdateSettings(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(250, 100));
        jPanel.setMinimumSize(new Dimension(250, 100));
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.update.setText("Check for updates on startup");
        this.update.setHorizontalTextPosition(2);
        jPanel.add(this.update);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0.3f, 0.5f, 1.0f), 1), "Update Settings"));
        return jPanel;
    }

    public void setAutoScrollDefaultValue(boolean bl) {
        this.scrollDefaultValue = bl;
    }

    public void setBorderDefaultValue(int n) {
        this.borderDefaultValue = n;
    }

    public void setUpdateDefaultValue(boolean bl) {
        this.updateDefaultValue = bl;
    }

    public void setMaxMultiViewersDefaultValue(String string) {
        this.maxMultiViewersDefaultValue = string;
    }

    public void setDpiDefaultValue(String string) {
        this.dpiDefaultValue = string;
    }

    public void setSearchStyleDefaultValue(int n) {
        this.searchStyleDefaultValue = n;
    }

    public void setPageLayoutDefaultValue(int n) {
        if (n > this.pageLayout.getItemCount() + 1) {
            n = 1;
        }
        this.pageLayoutDefaultValue = n;
    }
}

