/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;

public class TestListener
extends TestBase
implements DatabaseEventListener {
    private long last;
    private long start;

    public TestListener() {
        this.start = this.last = System.currentTimeMillis();
    }

    public void test() throws Exception {
        if (this.config.networked) {
            return;
        }
        this.deleteDb("listener");
        Connection conn = this.getConnection("listener");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Test' || SPACE(100))");
        int len = this.getSize(100, 100000);
        for (int i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.execute();
        }
        this.crash(conn);
        conn = this.getConnection("listener;database_event_listener='" + this.getClass().getName() + "'");
        conn.close();
    }

    public void diskSpaceIsLow(long stillAvailable) throws SQLException {
        System.out.println("diskSpaceIsLow stillAvailable=" + stillAvailable);
    }

    public void exceptionThrown(SQLException e) {
        e.printStackTrace();
    }

    public void setProgress(int state, String name, int current, int max) {
        String stateName;
        long time = System.currentTimeMillis();
        if (time < this.last + 1000L) {
            return;
        }
        this.last = time;
        switch (state) {
            case 0: {
                stateName = "Scan " + name;
                break;
            }
            case 1: {
                stateName = "Create Index " + name;
                break;
            }
            case 2: {
                stateName = "Recover";
                break;
            }
            default: {
                new Error("unknownn state: " + state).printStackTrace();
                stateName = "? " + name;
            }
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("state: " + stateName + " " + 100 * current / max + " " + (time - this.start));
    }

    public void closingDatabase() {
    }
}

