/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.BitSet;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.BitField;

public class TestBitField
extends TestBase {
    public void test() throws Exception {
        this.testRandom();
        this.testGetSet();
    }

    void testRandom() throws Exception {
        BitField bits = new BitField();
        BitSet set = new BitSet();
        int max = 300;
        int count = 100000;
        Random random = new Random(1L);
        for (int i = 0; i < count; ++i) {
            int idx = random.nextInt(max);
            if (random.nextBoolean()) {
                if (random.nextBoolean()) {
                    bits.set(idx);
                    set.set(idx);
                    continue;
                }
                bits.clear(idx);
                set.clear(idx);
                continue;
            }
            this.check(bits.get(idx), set.get(idx));
            this.check(bits.nextClearBit(idx), set.nextClearBit(idx));
            this.check(bits.nextSetBit(idx), set.nextSetBit(idx));
        }
    }

    void testGetSet() throws Exception {
        int i;
        BitField bits = new BitField();
        for (i = 0; i < 10000; ++i) {
            bits.set(i);
            if (!bits.get(i)) {
                throw new Exception("not set: " + i);
            }
            if (!bits.get(i + 1)) continue;
            throw new Exception("set: " + i);
        }
        for (i = 0; i < 10000; ++i) {
            if (bits.get(i)) continue;
            throw new Exception("not set: " + i);
        }
        for (i = 0; i < 1000; ++i) {
            int k = bits.nextClearBit(0);
            if (k == 10000) continue;
            throw new Exception("" + k);
        }
    }
}

