/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;

public class KillThread
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
        ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(oRef instanceof ThreadReference)) {
            throw new JDEException("The ID doesn't correspond to a thread");
        }
        ThreadReference tRef = (ThreadReference)oRef;
        uniqueID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
        oRef = this.m_debugger.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such thread exists");
        }
        try {
            tRef.stop(oRef);
        }
        catch (InvalidTypeException ex) {
            throw new JDEException("Object ID doesn't correspond to a Throwable object");
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, null, true);
    }

    public Object clone() {
        return new KillThread();
    }
}

