/*
 * Decompiled with CFR 0.152.
 */
package jalview;

public class RotatableMatrix {
    float[][] matrix;
    float[] temp;
    float[][] rot;

    public RotatableMatrix(int n, int n2) {
        this.matrix = new float[n][n2];
        this.temp = new float[3];
        this.rot = new float[3][3];
    }

    public void addElement(int n, int n2, float f) {
        this.matrix[n][n2] = f;
    }

    public void print() {
        System.out.println(String.valueOf(this.matrix[0][0]) + " " + this.matrix[0][1] + " " + this.matrix[0][2]);
        System.out.println(String.valueOf(this.matrix[1][0]) + " " + this.matrix[1][1] + " " + this.matrix[1][2]);
        System.out.println(String.valueOf(this.matrix[2][0]) + " " + this.matrix[2][1] + " " + this.matrix[2][2]);
    }

    public void rotate(float f, char c) {
        float f2 = (float)Math.cos((double)f * Math.PI / 180.0);
        float f3 = (float)Math.sin((double)f * Math.PI / 180.0);
        if (c == 'z') {
            this.rot[0][0] = f2;
            this.rot[0][1] = -f3;
            this.rot[0][2] = 0.0f;
            this.rot[1][0] = f3;
            this.rot[1][1] = f2;
            this.rot[1][2] = 0.0f;
            this.rot[2][0] = 0.0f;
            this.rot[2][1] = 0.0f;
            this.rot[2][2] = 1.0f;
            this.preMultiply(this.rot);
        }
        if (c == 'x') {
            this.rot[0][0] = 1.0f;
            this.rot[0][1] = 0.0f;
            this.rot[0][2] = 0.0f;
            this.rot[1][0] = 0.0f;
            this.rot[1][1] = f2;
            this.rot[1][2] = f3;
            this.rot[2][0] = 0.0f;
            this.rot[2][1] = -f3;
            this.rot[2][2] = f2;
            this.preMultiply(this.rot);
        }
        if (c == 'y') {
            this.rot[0][0] = f2;
            this.rot[0][1] = 0.0f;
            this.rot[0][2] = -f3;
            this.rot[1][0] = 0.0f;
            this.rot[1][1] = 1.0f;
            this.rot[1][2] = 0.0f;
            this.rot[2][0] = f3;
            this.rot[2][1] = 0.0f;
            this.rot[2][2] = f2;
            this.preMultiply(this.rot);
        }
    }

    public float[] vectorMultiply(float[] fArray) {
        this.temp[0] = fArray[0];
        this.temp[1] = fArray[1];
        this.temp[2] = fArray[2];
        int n = 0;
        while (n < 3) {
            this.temp[n] = this.matrix[n][0] * fArray[0] + this.matrix[n][1] * fArray[1] + this.matrix[n][2] * fArray[2];
            ++n;
        }
        fArray[0] = this.temp[0];
        fArray[1] = this.temp[1];
        fArray[2] = this.temp[2];
        return fArray;
    }

    public void preMultiply(float[][] fArray) {
        int n;
        float[][] fArray2 = new float[3][3];
        int n2 = 0;
        while (n2 < 3) {
            n = 0;
            while (n < 3) {
                fArray2[n2][n] = fArray[n2][0] * this.matrix[0][n] + fArray[n2][1] * this.matrix[1][n] + fArray[n2][2] * this.matrix[2][n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 3) {
            int n3 = 0;
            while (n3 < 3) {
                this.matrix[n][n3] = fArray2[n][n3];
                ++n3;
            }
            ++n;
        }
    }

    public void postMultiply(float[][] fArray) {
        int n;
        float[][] fArray2 = new float[3][3];
        int n2 = 0;
        while (n2 < 3) {
            n = 0;
            while (n < 3) {
                fArray2[n2][n] = this.matrix[n2][0] * fArray[0][n] + this.matrix[n2][1] * fArray[1][n] + this.matrix[n2][2] * fArray[2][n];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 3) {
            int n3 = 0;
            while (n3 < 3) {
                this.matrix[n][n3] = fArray2[n][n3];
                ++n3;
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        RotatableMatrix rotatableMatrix = new RotatableMatrix(3, 3);
        rotatableMatrix.addElement(0, 0, 1.0f);
        rotatableMatrix.addElement(0, 1, 0.0f);
        rotatableMatrix.addElement(0, 2, 0.0f);
        rotatableMatrix.addElement(1, 0, 0.0f);
        rotatableMatrix.addElement(1, 1, 2.0f);
        rotatableMatrix.addElement(1, 2, 0.0f);
        rotatableMatrix.addElement(2, 0, 0.0f);
        rotatableMatrix.addElement(2, 1, 0.0f);
        rotatableMatrix.addElement(2, 2, 1.0f);
        rotatableMatrix.print();
        RotatableMatrix rotatableMatrix2 = new RotatableMatrix(3, 3);
        rotatableMatrix2.addElement(0, 0, 2.0f);
        rotatableMatrix2.addElement(0, 1, 1.0f);
        rotatableMatrix2.addElement(0, 2, 1.0f);
        rotatableMatrix2.addElement(1, 0, 2.0f);
        rotatableMatrix2.addElement(1, 1, 1.0f);
        rotatableMatrix2.addElement(1, 2, 1.0f);
        rotatableMatrix2.addElement(2, 0, 2.0f);
        rotatableMatrix2.addElement(2, 1, 1.0f);
        rotatableMatrix2.addElement(2, 2, 1.0f);
        rotatableMatrix2.print();
        float[] fArray = new float[]{2.0f, 4.0f, 6.0f};
        fArray = rotatableMatrix.vectorMultiply(fArray);
        System.out.println(String.valueOf(fArray[0]) + " " + fArray[1] + " " + fArray[2]);
    }

    public void setIdentity() {
        this.matrix[0][0] = 1.0f;
        this.matrix[1][1] = 1.0f;
        this.matrix[2][2] = 1.0f;
        this.matrix[0][1] = 0.0f;
        this.matrix[0][2] = 0.0f;
        this.matrix[1][0] = 0.0f;
        this.matrix[1][2] = 0.0f;
        this.matrix[2][0] = 0.0f;
        this.matrix[2][1] = 0.0f;
    }
}

