/*
 * Decompiled with CFR 0.152.
 */
package railo.runtime.net.flex;

import flex.messaging.FactoryInstance;
import flex.messaging.FlexContext;
import flex.messaging.config.ConfigMap;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.remoting.RemotingDestination;
import javax.servlet.ServletException;
import railo.loader.engine.CFMLEngine;
import railo.loader.engine.CFMLEngineFactory;
import railo.loader.engine.EngineChangeListener;
import railo.runtime.util.BlazeDS;

public class RailoAdapter
extends ServiceAdapter
implements EngineChangeListener {
    public static final short LOWER_CASE = 0;
    public static final short UPPER_CASE = 1;
    public static final short ORIGINAL_CASE = 2;
    private CFMLEngine engine;
    private ConfigMap properties;
    private BlazeDS util;

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        this.properties = properties;
        try {
            ConfigMap access;
            ConfigMap propertyCases = properties.getPropertyAsMap("property-case", null);
            if (propertyCases != null) {
                propertyCases.getPropertyAsBoolean("force-cfc-lowercase", false);
                propertyCases.getPropertyAsBoolean("force-query-lowercase", false);
                propertyCases.getPropertyAsBoolean("force-struct-lowercase", false);
            }
            if ((access = properties.getPropertyAsMap("access", null)) != null) {
                access.getPropertyAsBoolean("use-mappings", false);
                access.getPropertyAsString("method-access-level", "remote");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object invoke(Message message) {
        try {
            if (this.util == null) {
                this.util = (BlazeDS)this.getEngine().getBlazeDSUtil();
                this.util.init(this.properties);
            }
            RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
            RemotingMessage remotingMessage = (RemotingMessage)message;
            FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
            return this.util.invoke(this, message);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private CFMLEngine getEngine() {
        if (this.engine == null) {
            try {
                CFMLEngineFactory.getInstance();
                this.engine = CFMLEngineFactory.getInstance(FlexContext.getServletConfig(), this);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this.engine;
    }

    @Override
    public void onUpdate(CFMLEngine newEngine) {
        try {
            this.engine = CFMLEngineFactory.getInstance(FlexContext.getServletConfig(), this);
        }
        catch (ServletException e) {
            this.engine = newEngine;
        }
    }
}

