/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.security.AES;
import org.h2.security.SHA256;
import org.h2.security.XTEA;
import org.h2.test.TestBase;
import org.h2.util.ByteUtils;

public class TestSecurity
extends TestBase {
    public void test() throws Exception {
        this.testSHA();
        this.testAES();
        this.testXTEA();
    }

    public void testSHA() throws Exception {
        SHA256 sha = new SHA256();
        this.testOneSHA(sha);
    }

    private String getHashString(SHA256 sha, byte[] data) {
        byte[] result = sha.getHash(data);
        return ByteUtils.convertBytesToString(result);
    }

    private void testOneSHA(SHA256 sha) throws Exception {
        if (!this.getHashString(sha, new byte[0]).equals("e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855")) {
            throw new Exception("x");
        }
        if (!this.getHashString(sha, new byte[]{25}).equals("68aa2e2ee5dff96e3355e6c7ee373e3d6a4e17f75f9518d843709c0c9bc3e3d4")) {
            throw new Exception("x");
        }
        if (!this.getHashString(sha, new byte[]{-29, -41, 37, 112, -36, -35, 120, 124, -29, -120, 122, -78, -51, 104, 70, 82}).equals("175ee69b02ba9b58e2b0a5fd13819cea573f3940a94f825128cf4209beabb4e8")) {
            throw new Exception("x");
        }
    }

    public void testXTEA() throws Exception {
        byte[] test = new byte[4096];
        XTEA tea = new XTEA();
        tea.setKey("abcdefghijklmnop".getBytes());
        for (int i = 0; i < 10; ++i) {
            tea.decryptBlock(test, test, 0);
        }
    }

    private void testAES() throws Exception {
        AES test = new AES();
        test.setKey(ByteUtils.convertStringToBytes("000102030405060708090A0B0C0D0E0F"));
        byte[] in = new byte[128];
        byte[] enc = new byte[128];
        test.encrypt(enc, 0, 128);
        test.decrypt(enc, 0, 128);
        if (ByteUtils.compareNotNull(in, enc) != 0) {
            throw new Error("hey!");
        }
        for (int i = 0; i < 10; ++i) {
            test.encrypt(in, 0, 128);
            test.decrypt(enc, 0, 128);
        }
    }
}

