require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALTIVEC_H)) {
    eval 'sub _ALTIVEC_H () {1;}' unless defined(&_ALTIVEC_H);
    if(!defined(&__VEC__) || !defined(&__ALTIVEC__)) {
	die("Use\ the\ \"\-maltivec\"\ flag\ to\ enable\ PowerPC\ AltiVec\ support");
    }
    if(!defined(&__APPLE_ALTIVEC__)) {
	eval 'sub vector () { &__vector;}' unless defined(&vector);
	eval 'sub pixel () { &__pixel;}' unless defined(&pixel);
	eval 'sub bool () { &__bool;}' unless defined(&bool);
    }
    eval 'sub __CR6_EQ () {0;}' unless defined(&__CR6_EQ);
    eval 'sub __CR6_EQ_REV () {1;}' unless defined(&__CR6_EQ_REV);
    eval 'sub __CR6_LT () {2;}' unless defined(&__CR6_LT);
    eval 'sub __CR6_LT_REV () {3;}' unless defined(&__CR6_LT_REV);
    eval 'sub vec_vaddcuw () { &vec_addc;}' unless defined(&vec_vaddcuw);
    eval 'sub vec_vand () { &vec_and;}' unless defined(&vec_vand);
    eval 'sub vec_vandc () { &vec_andc;}' unless defined(&vec_vandc);
    eval 'sub vec_vrfip () { &vec_ceil;}' unless defined(&vec_vrfip);
    eval 'sub vec_vcmpbfp () { &vec_cmpb;}' unless defined(&vec_vcmpbfp);
    eval 'sub vec_vcmpgefp () { &vec_cmpge;}' unless defined(&vec_vcmpgefp);
    eval 'sub vec_vctsxs () { &vec_cts;}' unless defined(&vec_vctsxs);
    eval 'sub vec_vctuxs () { &vec_ctu;}' unless defined(&vec_vctuxs);
    eval 'sub vec_vexptefp () { &vec_expte;}' unless defined(&vec_vexptefp);
    eval 'sub vec_vrfim () { &vec_floor;}' unless defined(&vec_vrfim);
    eval 'sub vec_lvx () { &vec_ld;}' unless defined(&vec_lvx);
    eval 'sub vec_lvxl () { &vec_ldl;}' unless defined(&vec_lvxl);
    eval 'sub vec_vlogefp () { &vec_loge;}' unless defined(&vec_vlogefp);
    eval 'sub vec_vmaddfp () { &vec_madd;}' unless defined(&vec_vmaddfp);
    eval 'sub vec_vmhaddshs () { &vec_madds;}' unless defined(&vec_vmhaddshs);
    eval 'sub vec_vmladduhm () { &vec_mladd;}' unless defined(&vec_vmladduhm);
    eval 'sub vec_vmhraddshs () { &vec_mradds;}' unless defined(&vec_vmhraddshs);
    eval 'sub vec_vnmsubfp () { &vec_nmsub;}' unless defined(&vec_vnmsubfp);
    eval 'sub vec_vnor () { &vec_nor;}' unless defined(&vec_vnor);
    eval 'sub vec_vor () { &vec_or;}' unless defined(&vec_vor);
    eval 'sub vec_vpkpx () { &vec_packpx;}' unless defined(&vec_vpkpx);
    eval 'sub vec_vperm () { &vec_perm;}' unless defined(&vec_vperm);
    eval 'sub vec_vrefp () { &vec_re;}' unless defined(&vec_vrefp);
    eval 'sub vec_vrfin () { &vec_round;}' unless defined(&vec_vrfin);
    eval 'sub vec_vrsqrtefp () { &vec_rsqrte;}' unless defined(&vec_vrsqrtefp);
    eval 'sub vec_vsel () { &vec_sel;}' unless defined(&vec_vsel);
    eval 'sub vec_vsldoi () { &vec_sld;}' unless defined(&vec_vsldoi);
    eval 'sub vec_vsl () { &vec_sll;}' unless defined(&vec_vsl);
    eval 'sub vec_vslo () { &vec_slo;}' unless defined(&vec_vslo);
    eval 'sub vec_vspltisb () { &vec_splat_s8;}' unless defined(&vec_vspltisb);
    eval 'sub vec_vspltish () { &vec_splat_s16;}' unless defined(&vec_vspltish);
    eval 'sub vec_vspltisw () { &vec_splat_s32;}' unless defined(&vec_vspltisw);
    eval 'sub vec_vsr () { &vec_srl;}' unless defined(&vec_vsr);
    eval 'sub vec_vsro () { &vec_sro;}' unless defined(&vec_vsro);
    eval 'sub vec_stvx () { &vec_st;}' unless defined(&vec_stvx);
    eval 'sub vec_stvxl () { &vec_stl;}' unless defined(&vec_stvxl);
    eval 'sub vec_vsubcuw () { &vec_subc;}' unless defined(&vec_vsubcuw);
    eval 'sub vec_vsum2sws () { &vec_sum2s;}' unless defined(&vec_vsum2sws);
    eval 'sub vec_vsumsws () { &vec_sums;}' unless defined(&vec_vsumsws);
    eval 'sub vec_vrfiz () { &vec_trunc;}' unless defined(&vec_vrfiz);
    eval 'sub vec_vxor () { &vec_xor;}' unless defined(&vec_vxor);
    eval 'sub vec_vaddfp () { &__builtin_vec_vaddfp;}' unless defined(&vec_vaddfp);
    eval 'sub vec_addc () { &__builtin_vec_addc;}' unless defined(&vec_addc);
    eval 'sub vec_vaddsws () { &__builtin_vec_vaddsws;}' unless defined(&vec_vaddsws);
    eval 'sub vec_vaddshs () { &__builtin_vec_vaddshs;}' unless defined(&vec_vaddshs);
    eval 'sub vec_vaddsbs () { &__builtin_vec_vaddsbs;}' unless defined(&vec_vaddsbs);
    eval 'sub vec_vavgsw () { &__builtin_vec_vavgsw;}' unless defined(&vec_vavgsw);
    eval 'sub vec_vavguw () { &__builtin_vec_vavguw;}' unless defined(&vec_vavguw);
    eval 'sub vec_vavgsh () { &__builtin_vec_vavgsh;}' unless defined(&vec_vavgsh);
    eval 'sub vec_vavguh () { &__builtin_vec_vavguh;}' unless defined(&vec_vavguh);
    eval 'sub vec_vavgsb () { &__builtin_vec_vavgsb;}' unless defined(&vec_vavgsb);
    eval 'sub vec_vavgub () { &__builtin_vec_vavgub;}' unless defined(&vec_vavgub);
    eval 'sub vec_ceil () { &__builtin_vec_ceil;}' unless defined(&vec_ceil);
    eval 'sub vec_cmpb () { &__builtin_vec_cmpb;}' unless defined(&vec_cmpb);
    eval 'sub vec_vcmpeqfp () { &__builtin_vec_vcmpeqfp;}' unless defined(&vec_vcmpeqfp);
    eval 'sub vec_cmpge () { &__builtin_vec_cmpge;}' unless defined(&vec_cmpge);
    eval 'sub vec_vcmpgtfp () { &__builtin_vec_vcmpgtfp;}' unless defined(&vec_vcmpgtfp);
    eval 'sub vec_vcmpgtsw () { &__builtin_vec_vcmpgtsw;}' unless defined(&vec_vcmpgtsw);
    eval 'sub vec_vcmpgtuw () { &__builtin_vec_vcmpgtuw;}' unless defined(&vec_vcmpgtuw);
    eval 'sub vec_vcmpgtsh () { &__builtin_vec_vcmpgtsh;}' unless defined(&vec_vcmpgtsh);
    eval 'sub vec_vcmpgtuh () { &__builtin_vec_vcmpgtuh;}' unless defined(&vec_vcmpgtuh);
    eval 'sub vec_vcmpgtsb () { &__builtin_vec_vcmpgtsb;}' unless defined(&vec_vcmpgtsb);
    eval 'sub vec_vcmpgtub () { &__builtin_vec_vcmpgtub;}' unless defined(&vec_vcmpgtub);
    eval 'sub vec_vcfsx () { &__builtin_vec_vcfsx;}' unless defined(&vec_vcfsx);
    eval 'sub vec_vcfux () { &__builtin_vec_vcfux;}' unless defined(&vec_vcfux);
    eval 'sub vec_cts () { &__builtin_vec_cts;}' unless defined(&vec_cts);
    eval 'sub vec_ctu () { &__builtin_vec_ctu;}' unless defined(&vec_ctu);
    eval 'sub vec_expte () { &__builtin_vec_expte;}' unless defined(&vec_expte);
    eval 'sub vec_floor () { &__builtin_vec_floor;}' unless defined(&vec_floor);
    eval 'sub vec_loge () { &__builtin_vec_loge;}' unless defined(&vec_loge);
    eval 'sub vec_madd () { &__builtin_vec_madd;}' unless defined(&vec_madd);
    eval 'sub vec_madds () { &__builtin_vec_madds;}' unless defined(&vec_madds);
    eval 'sub vec_mtvscr () { &__builtin_vec_mtvscr;}' unless defined(&vec_mtvscr);
    eval 'sub vec_vmaxfp () { &__builtin_vec_vmaxfp;}' unless defined(&vec_vmaxfp);
    eval 'sub vec_vmaxsw () { &__builtin_vec_vmaxsw;}' unless defined(&vec_vmaxsw);
    eval 'sub vec_vmaxsh () { &__builtin_vec_vmaxsh;}' unless defined(&vec_vmaxsh);
    eval 'sub vec_vmaxsb () { &__builtin_vec_vmaxsb;}' unless defined(&vec_vmaxsb);
    eval 'sub vec_vminfp () { &__builtin_vec_vminfp;}' unless defined(&vec_vminfp);
    eval 'sub vec_vminsw () { &__builtin_vec_vminsw;}' unless defined(&vec_vminsw);
    eval 'sub vec_vminsh () { &__builtin_vec_vminsh;}' unless defined(&vec_vminsh);
    eval 'sub vec_vminsb () { &__builtin_vec_vminsb;}' unless defined(&vec_vminsb);
    eval 'sub vec_mradds () { &__builtin_vec_mradds;}' unless defined(&vec_mradds);
    eval 'sub vec_vmsumshm () { &__builtin_vec_vmsumshm;}' unless defined(&vec_vmsumshm);
    eval 'sub vec_vmsumuhm () { &__builtin_vec_vmsumuhm;}' unless defined(&vec_vmsumuhm);
    eval 'sub vec_vmsummbm () { &__builtin_vec_vmsummbm;}' unless defined(&vec_vmsummbm);
    eval 'sub vec_vmsumubm () { &__builtin_vec_vmsumubm;}' unless defined(&vec_vmsumubm);
    eval 'sub vec_vmsumshs () { &__builtin_vec_vmsumshs;}' unless defined(&vec_vmsumshs);
    eval 'sub vec_vmsumuhs () { &__builtin_vec_vmsumuhs;}' unless defined(&vec_vmsumuhs);
    eval 'sub vec_vmulesb () { &__builtin_vec_vmulesb;}' unless defined(&vec_vmulesb);
    eval 'sub vec_vmulesh () { &__builtin_vec_vmulesh;}' unless defined(&vec_vmulesh);
    eval 'sub vec_vmuleuh () { &__builtin_vec_vmuleuh;}' unless defined(&vec_vmuleuh);
    eval 'sub vec_vmuleub () { &__builtin_vec_vmuleub;}' unless defined(&vec_vmuleub);
    eval 'sub vec_vmulosh () { &__builtin_vec_vmulosh;}' unless defined(&vec_vmulosh);
    eval 'sub vec_vmulouh () { &__builtin_vec_vmulouh;}' unless defined(&vec_vmulouh);
    eval 'sub vec_vmulosb () { &__builtin_vec_vmulosb;}' unless defined(&vec_vmulosb);
    eval 'sub vec_vmuloub () { &__builtin_vec_vmuloub;}' unless defined(&vec_vmuloub);
    eval 'sub vec_nmsub () { &__builtin_vec_nmsub;}' unless defined(&vec_nmsub);
    eval 'sub vec_packpx () { &__builtin_vec_packpx;}' unless defined(&vec_packpx);
    eval 'sub vec_vpkswss () { &__builtin_vec_vpkswss;}' unless defined(&vec_vpkswss);
    eval 'sub vec_vpkuwus () { &__builtin_vec_vpkuwus;}' unless defined(&vec_vpkuwus);
    eval 'sub vec_vpkshss () { &__builtin_vec_vpkshss;}' unless defined(&vec_vpkshss);
    eval 'sub vec_vpkuhus () { &__builtin_vec_vpkuhus;}' unless defined(&vec_vpkuhus);
    eval 'sub vec_vpkswus () { &__builtin_vec_vpkswus;}' unless defined(&vec_vpkswus);
    eval 'sub vec_vpkshus () { &__builtin_vec_vpkshus;}' unless defined(&vec_vpkshus);
    eval 'sub vec_re () { &__builtin_vec_re;}' unless defined(&vec_re);
    eval 'sub vec_round () { &__builtin_vec_round;}' unless defined(&vec_round);
    eval 'sub vec_rsqrte () { &__builtin_vec_rsqrte;}' unless defined(&vec_rsqrte);
    eval 'sub vec_vsubfp () { &__builtin_vec_vsubfp;}' unless defined(&vec_vsubfp);
    eval 'sub vec_subc () { &__builtin_vec_subc;}' unless defined(&vec_subc);
    eval 'sub vec_vsubsws () { &__builtin_vec_vsubsws;}' unless defined(&vec_vsubsws);
    eval 'sub vec_vsubshs () { &__builtin_vec_vsubshs;}' unless defined(&vec_vsubshs);
    eval 'sub vec_vsubsbs () { &__builtin_vec_vsubsbs;}' unless defined(&vec_vsubsbs);
    eval 'sub vec_sum4s () { &__builtin_vec_sum4s;}' unless defined(&vec_sum4s);
    eval 'sub vec_vsum4shs () { &__builtin_vec_vsum4shs;}' unless defined(&vec_vsum4shs);
    eval 'sub vec_vsum4sbs () { &__builtin_vec_vsum4sbs;}' unless defined(&vec_vsum4sbs);
    eval 'sub vec_vsum4ubs () { &__builtin_vec_vsum4ubs;}' unless defined(&vec_vsum4ubs);
    eval 'sub vec_sum2s () { &__builtin_vec_sum2s;}' unless defined(&vec_sum2s);
    eval 'sub vec_sums () { &__builtin_vec_sums;}' unless defined(&vec_sums);
    eval 'sub vec_trunc () { &__builtin_vec_trunc;}' unless defined(&vec_trunc);
    eval 'sub vec_vupkhpx () { &__builtin_vec_vupkhpx;}' unless defined(&vec_vupkhpx);
    eval 'sub vec_vupkhsh () { &__builtin_vec_vupkhsh;}' unless defined(&vec_vupkhsh);
    eval 'sub vec_vupkhsb () { &__builtin_vec_vupkhsb;}' unless defined(&vec_vupkhsb);
    eval 'sub vec_vupklpx () { &__builtin_vec_vupklpx;}' unless defined(&vec_vupklpx);
    eval 'sub vec_vupklsh () { &__builtin_vec_vupklsh;}' unless defined(&vec_vupklsh);
    eval 'sub vec_vupklsb () { &__builtin_vec_vupklsb;}' unless defined(&vec_vupklsb);
    eval 'sub vec_abs () { &__builtin_vec_abs;}' unless defined(&vec_abs);
    eval 'sub vec_abss () { &__builtin_vec_abss;}' unless defined(&vec_abss);
    eval 'sub vec_add () { &__builtin_vec_add;}' unless defined(&vec_add);
    eval 'sub vec_adds () { &__builtin_vec_adds;}' unless defined(&vec_adds);
    eval 'sub vec_and () { &__builtin_vec_and;}' unless defined(&vec_and);
    eval 'sub vec_andc () { &__builtin_vec_andc;}' unless defined(&vec_andc);
    eval 'sub vec_avg () { &__builtin_vec_avg;}' unless defined(&vec_avg);
    eval 'sub vec_cmpeq () { &__builtin_vec_cmpeq;}' unless defined(&vec_cmpeq);
    eval 'sub vec_cmpgt () { &__builtin_vec_cmpgt;}' unless defined(&vec_cmpgt);
    eval 'sub vec_ctf () { &__builtin_vec_ctf;}' unless defined(&vec_ctf);
    eval 'sub vec_dst () { &__builtin_vec_dst;}' unless defined(&vec_dst);
    eval 'sub vec_dstst () { &__builtin_vec_dstst;}' unless defined(&vec_dstst);
    eval 'sub vec_dststt () { &__builtin_vec_dststt;}' unless defined(&vec_dststt);
    eval 'sub vec_dstt () { &__builtin_vec_dstt;}' unless defined(&vec_dstt);
    eval 'sub vec_ld () { &__builtin_vec_ld;}' unless defined(&vec_ld);
    eval 'sub vec_lde () { &__builtin_vec_lde;}' unless defined(&vec_lde);
    eval 'sub vec_ldl () { &__builtin_vec_ldl;}' unless defined(&vec_ldl);
    eval 'sub vec_lvebx () { &__builtin_vec_lvebx;}' unless defined(&vec_lvebx);
    eval 'sub vec_lvehx () { &__builtin_vec_lvehx;}' unless defined(&vec_lvehx);
    eval 'sub vec_lvewx () { &__builtin_vec_lvewx;}' unless defined(&vec_lvewx);
    eval 'sub vec_lvsl () { &__builtin_vec_lvsl;}' unless defined(&vec_lvsl);
    eval 'sub vec_lvsr () { &__builtin_vec_lvsr;}' unless defined(&vec_lvsr);
    eval 'sub vec_max () { &__builtin_vec_max;}' unless defined(&vec_max);
    eval 'sub vec_mergeh () { &__builtin_vec_mergeh;}' unless defined(&vec_mergeh);
    eval 'sub vec_mergel () { &__builtin_vec_mergel;}' unless defined(&vec_mergel);
    eval 'sub vec_min () { &__builtin_vec_min;}' unless defined(&vec_min);
    eval 'sub vec_mladd () { &__builtin_vec_mladd;}' unless defined(&vec_mladd);
    eval 'sub vec_msum () { &__builtin_vec_msum;}' unless defined(&vec_msum);
    eval 'sub vec_msums () { &__builtin_vec_msums;}' unless defined(&vec_msums);
    eval 'sub vec_mule () { &__builtin_vec_mule;}' unless defined(&vec_mule);
    eval 'sub vec_mulo () { &__builtin_vec_mulo;}' unless defined(&vec_mulo);
    eval 'sub vec_nor () { &__builtin_vec_nor;}' unless defined(&vec_nor);
    eval 'sub vec_or () { &__builtin_vec_or;}' unless defined(&vec_or);
    eval 'sub vec_pack () { &__builtin_vec_pack;}' unless defined(&vec_pack);
    eval 'sub vec_packs () { &__builtin_vec_packs;}' unless defined(&vec_packs);
    eval 'sub vec_packsu () { &__builtin_vec_packsu;}' unless defined(&vec_packsu);
    eval 'sub vec_perm () { &__builtin_vec_perm;}' unless defined(&vec_perm);
    eval 'sub vec_rl () { &__builtin_vec_rl;}' unless defined(&vec_rl);
    eval 'sub vec_sel () { &__builtin_vec_sel;}' unless defined(&vec_sel);
    eval 'sub vec_sl () { &__builtin_vec_sl;}' unless defined(&vec_sl);
    eval 'sub vec_sld () { &__builtin_vec_sld;}' unless defined(&vec_sld);
    eval 'sub vec_sll () { &__builtin_vec_sll;}' unless defined(&vec_sll);
    eval 'sub vec_slo () { &__builtin_vec_slo;}' unless defined(&vec_slo);
    eval 'sub vec_splat () { &__builtin_vec_splat;}' unless defined(&vec_splat);
    eval 'sub vec_sr () { &__builtin_vec_sr;}' unless defined(&vec_sr);
    eval 'sub vec_sra () { &__builtin_vec_sra;}' unless defined(&vec_sra);
    eval 'sub vec_srl () { &__builtin_vec_srl;}' unless defined(&vec_srl);
    eval 'sub vec_sro () { &__builtin_vec_sro;}' unless defined(&vec_sro);
    eval 'sub vec_st () { &__builtin_vec_st;}' unless defined(&vec_st);
    eval 'sub vec_ste () { &__builtin_vec_ste;}' unless defined(&vec_ste);
    eval 'sub vec_stl () { &__builtin_vec_stl;}' unless defined(&vec_stl);
    eval 'sub vec_stvebx () { &__builtin_vec_stvebx;}' unless defined(&vec_stvebx);
    eval 'sub vec_stvehx () { &__builtin_vec_stvehx;}' unless defined(&vec_stvehx);
    eval 'sub vec_stvewx () { &__builtin_vec_stvewx;}' unless defined(&vec_stvewx);
    eval 'sub vec_sub () { &__builtin_vec_sub;}' unless defined(&vec_sub);
    eval 'sub vec_subs () { &__builtin_vec_subs;}' unless defined(&vec_subs);
    eval 'sub vec_sum () { &__builtin_vec_sum;}' unless defined(&vec_sum);
    eval 'sub vec_unpackh () { &__builtin_vec_unpackh;}' unless defined(&vec_unpackh);
    eval 'sub vec_unpackl () { &__builtin_vec_unpackl;}' unless defined(&vec_unpackl);
    eval 'sub vec_vaddubm () { &__builtin_vec_vaddubm;}' unless defined(&vec_vaddubm);
    eval 'sub vec_vaddubs () { &__builtin_vec_vaddubs;}' unless defined(&vec_vaddubs);
    eval 'sub vec_vadduhm () { &__builtin_vec_vadduhm;}' unless defined(&vec_vadduhm);
    eval 'sub vec_vadduhs () { &__builtin_vec_vadduhs;}' unless defined(&vec_vadduhs);
    eval 'sub vec_vadduwm () { &__builtin_vec_vadduwm;}' unless defined(&vec_vadduwm);
    eval 'sub vec_vadduws () { &__builtin_vec_vadduws;}' unless defined(&vec_vadduws);
    eval 'sub vec_vcmpequb () { &__builtin_vec_vcmpequb;}' unless defined(&vec_vcmpequb);
    eval 'sub vec_vcmpequh () { &__builtin_vec_vcmpequh;}' unless defined(&vec_vcmpequh);
    eval 'sub vec_vcmpequw () { &__builtin_vec_vcmpequw;}' unless defined(&vec_vcmpequw);
    eval 'sub vec_vmaxub () { &__builtin_vec_vmaxub;}' unless defined(&vec_vmaxub);
    eval 'sub vec_vmaxuh () { &__builtin_vec_vmaxuh;}' unless defined(&vec_vmaxuh);
    eval 'sub vec_vmaxuw () { &__builtin_vec_vmaxuw;}' unless defined(&vec_vmaxuw);
    eval 'sub vec_vminub () { &__builtin_vec_vminub;}' unless defined(&vec_vminub);
    eval 'sub vec_vminuh () { &__builtin_vec_vminuh;}' unless defined(&vec_vminuh);
    eval 'sub vec_vminuw () { &__builtin_vec_vminuw;}' unless defined(&vec_vminuw);
    eval 'sub vec_vmrghb () { &__builtin_vec_vmrghb;}' unless defined(&vec_vmrghb);
    eval 'sub vec_vmrghh () { &__builtin_vec_vmrghh;}' unless defined(&vec_vmrghh);
    eval 'sub vec_vmrghw () { &__builtin_vec_vmrghw;}' unless defined(&vec_vmrghw);
    eval 'sub vec_vmrglb () { &__builtin_vec_vmrglb;}' unless defined(&vec_vmrglb);
    eval 'sub vec_vmrglh () { &__builtin_vec_vmrglh;}' unless defined(&vec_vmrglh);
    eval 'sub vec_vmrglw () { &__builtin_vec_vmrglw;}' unless defined(&vec_vmrglw);
    eval 'sub vec_vpkuhum () { &__builtin_vec_vpkuhum;}' unless defined(&vec_vpkuhum);
    eval 'sub vec_vpkuwum () { &__builtin_vec_vpkuwum;}' unless defined(&vec_vpkuwum);
    eval 'sub vec_vrlb () { &__builtin_vec_vrlb;}' unless defined(&vec_vrlb);
    eval 'sub vec_vrlh () { &__builtin_vec_vrlh;}' unless defined(&vec_vrlh);
    eval 'sub vec_vrlw () { &__builtin_vec_vrlw;}' unless defined(&vec_vrlw);
    eval 'sub vec_vslb () { &__builtin_vec_vslb;}' unless defined(&vec_vslb);
    eval 'sub vec_vslh () { &__builtin_vec_vslh;}' unless defined(&vec_vslh);
    eval 'sub vec_vslw () { &__builtin_vec_vslw;}' unless defined(&vec_vslw);
    eval 'sub vec_vspltb () { &__builtin_vec_vspltb;}' unless defined(&vec_vspltb);
    eval 'sub vec_vsplth () { &__builtin_vec_vsplth;}' unless defined(&vec_vsplth);
    eval 'sub vec_vspltw () { &__builtin_vec_vspltw;}' unless defined(&vec_vspltw);
    eval 'sub vec_vsrab () { &__builtin_vec_vsrab;}' unless defined(&vec_vsrab);
    eval 'sub vec_vsrah () { &__builtin_vec_vsrah;}' unless defined(&vec_vsrah);
    eval 'sub vec_vsraw () { &__builtin_vec_vsraw;}' unless defined(&vec_vsraw);
    eval 'sub vec_vsrb () { &__builtin_vec_vsrb;}' unless defined(&vec_vsrb);
    eval 'sub vec_vsrh () { &__builtin_vec_vsrh;}' unless defined(&vec_vsrh);
    eval 'sub vec_vsrw () { &__builtin_vec_vsrw;}' unless defined(&vec_vsrw);
    eval 'sub vec_vsububs () { &__builtin_vec_vsububs;}' unless defined(&vec_vsububs);
    eval 'sub vec_vsububm () { &__builtin_vec_vsububm;}' unless defined(&vec_vsububm);
    eval 'sub vec_vsubuhm () { &__builtin_vec_vsubuhm;}' unless defined(&vec_vsubuhm);
    eval 'sub vec_vsubuhs () { &__builtin_vec_vsubuhs;}' unless defined(&vec_vsubuhs);
    eval 'sub vec_vsubuwm () { &__builtin_vec_vsubuwm;}' unless defined(&vec_vsubuwm);
    eval 'sub vec_vsubuws () { &__builtin_vec_vsubuws;}' unless defined(&vec_vsubuws);
    eval 'sub vec_xor () { &__builtin_vec_xor;}' unless defined(&vec_xor);
    if(defined(&__cplusplus__)) {
	eval 'sub __altivec_unary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T> \'int\' $NAME ( &T  &a1) {  &return $CALL; });
	}' unless defined(&__altivec_unary_pred);
	eval 'sub __altivec_scalar_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U> \'int\' $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_scalar_pred);
	eval 'sub __altivec_binary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U>  &typename  &__altivec_bool_ret < &vec_step ( &T)>:: &__ret $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_binary_pred);
	undef(&__altivec_scalar_pred) if defined(&__altivec_scalar_pred);
	undef(&__altivec_unary_pred) if defined(&__altivec_unary_pred);
	undef(&__altivec_binary_pred) if defined(&__altivec_binary_pred);
    } else {
	eval 'sub vec_cmplt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_cmpgt (($a2), ($a1)));
	}' unless defined(&vec_cmplt);
	eval 'sub vec_cmple {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgefp (($a2), ($a1)));
	}' unless defined(&vec_cmple);
	eval 'sub vec_all_in {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_in);
	eval 'sub vec_any_out {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_out);
	eval 'sub vec_all_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_altivec_vcmpeqfp_p ( &__CR6_EQ, ($a1), ($a1)));
	}' unless defined(&vec_all_nan);
	eval 'sub vec_any_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_altivec_vcmpeqfp_p ( &__CR6_LT_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_nan);
	eval 'sub vec_all_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_altivec_vcmpeqfp_p ( &__CR6_LT, ($a1), ($a1)));
	}' unless defined(&vec_all_numeric);
	eval 'sub vec_any_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_altivec_vcmpeqfp_p ( &__CR6_EQ_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_numeric);
	eval 'sub vec_all_eq {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_eq);
	eval 'sub vec_all_ne {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_ne);
	eval 'sub vec_any_eq {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_eq);
	eval 'sub vec_any_ne {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ne);
	eval 'sub vec_all_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_gt);
	eval 'sub vec_all_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_lt);
	eval 'sub vec_any_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_gt);
	eval 'sub vec_any_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_lt);
	eval 'sub vec_all_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgtfp_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_ngt);
	eval 'sub vec_all_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgtfp_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nlt);
	eval 'sub vec_any_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgtfp_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ngt);
	eval 'sub vec_any_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgtfp_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nlt);
	eval 'sub vec_all_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_le);
	eval 'sub vec_all_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_ge);
	eval 'sub vec_any_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_le);
	eval 'sub vec_any_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ge);
	eval 'sub vec_all_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgefp_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_nge);
	eval 'sub vec_all_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgefp_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nle);
	eval 'sub vec_any_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgefp_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_nge);
	eval 'sub vec_any_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpgefp_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nle);
    }
    eval 'sub vec_dss {
        my($x) = @_;
	    eval q( &__builtin_altivec_dss(($x)));
    }' unless defined(&vec_dss);
    eval 'sub vec_dssall () {
        eval q( &__builtin_altivec_dssall ());
    }' unless defined(&vec_dssall);
    eval 'sub vec_mfvscr () {
        eval q((( &__vector \'unsigned short\')  &__builtin_altivec_mfvscr ()));
    }' unless defined(&vec_mfvscr);
    eval 'sub vec_splat_s8 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltisb (($x)));
    }' unless defined(&vec_splat_s8);
    eval 'sub vec_splat_s16 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltish (($x)));
    }' unless defined(&vec_splat_s16);
    eval 'sub vec_splat_s32 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltisw (($x)));
    }' unless defined(&vec_splat_s32);
    eval 'sub vec_splat_u8 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned char\')  &vec_splat_s8 (($x))));
    }' unless defined(&vec_splat_u8);
    eval 'sub vec_splat_u16 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned short\')  &vec_splat_s16 (($x))));
    }' unless defined(&vec_splat_u16);
    eval 'sub vec_splat_u32 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned int\')  &vec_splat_s32 (($x))));
    }' unless defined(&vec_splat_u32);
    eval 'sub vec_step {
        my($x) = @_;
	    eval q( &__builtin_vec_step (* ( &__typeof__ ($x) *) 0));
    }' unless defined(&vec_step);
}
1;
