require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_PARAM_H_)) {
    eval 'sub _POWERPC_PARAM_H_ () {1;}' unless defined(&_POWERPC_PARAM_H_);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub MACHINE_ARCH () {"powerpc";}' unless defined(&MACHINE_ARCH);
    eval 'sub _MACHINE_ARCH () { &powerpc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_POWERPC;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () { &_ALIGNBYTES;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q( &_ALIGN($p));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q( &_ALIGNED_POINTER($p,$t));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {4096;}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
    eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
    eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub UPAGES () {4;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub PPC_SEGMENT_LENGTH () {0x10000000;}' unless defined(&PPC_SEGMENT_LENGTH);
    eval 'sub PPC_SEGMENT_MASK () {0xf0000000;}' unless defined(&PPC_SEGMENT_MASK);
    eval 'sub PPC_USER_SR () {13;}' unless defined(&PPC_USER_SR);
    eval 'sub PPC_KERNEL_SR () {14;}' unless defined(&PPC_KERNEL_SR);
    eval 'sub PPC_KERNEL_SEG0 () {0xfffff0;}' unless defined(&PPC_KERNEL_SEG0);
    eval 'sub PPC_KERNEL_SEGMENT () {( &PPC_KERNEL_SEG0 +  &PPC_KERNEL_SR);}' unless defined(&PPC_KERNEL_SEGMENT);
    eval 'sub PPC_USER_ADDR () {(( &void *)( &PPC_USER_SR <<  &ADDR_SR_SHIFT));}' unless defined(&PPC_USER_ADDR);
    unless(defined(&NPMAPS)) {
	eval 'sub NPMAPS () {32768;}' unless defined(&NPMAPS);
    }
    eval 'sub ovbcopy () { &bcopy;}' unless defined(&ovbcopy);
}
1;
