require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_BIT_TWIDDLE)) {
    eval 'sub _BIT_TWIDDLE () {1;}' unless defined(&_BIT_TWIDDLE);
    eval 'sub LOWEST_SET_BIT {
        my($x) = @_;
	    eval q((((($x) - 1) & ($x)) ^ ($x)));
    }' unless defined(&LOWEST_SET_BIT);
    eval 'sub GTEQ_POWER {
        my($x, $p) = @_;
	    eval q(((($x) >> ($p)) != 0));
    }' unless defined(&GTEQ_POWER);
    eval 'sub MASK_TO_SHIFT2 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 1) ? 1: 0));
    }' unless defined(&MASK_TO_SHIFT2);
    eval 'sub MASK_TO_SHIFT4 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 2) ? 2+  &MASK_TO_SHIFT2(($m) >> 2) :  &MASK_TO_SHIFT2(($m))));
    }' unless defined(&MASK_TO_SHIFT4);
    eval 'sub MASK_TO_SHIFT8 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 4) ? 4+  &MASK_TO_SHIFT4(($m) >> 4) :  &MASK_TO_SHIFT4(($m))));
    }' unless defined(&MASK_TO_SHIFT8);
    eval 'sub MASK_TO_SHIFT16 {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 8) ? 8+  &MASK_TO_SHIFT8(($m) >> 8) :  &MASK_TO_SHIFT8(($m))));
    }' unless defined(&MASK_TO_SHIFT16);
    eval 'sub MASK_TO_SHIFT {
        my($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 16) ? 16+  &MASK_TO_SHIFT16(($m) >> 16) :  &MASK_TO_SHIFT16(($m))));
    }' unless defined(&MASK_TO_SHIFT);
    eval 'sub MASK_AND_RSHIFT {
        my($x, $mask) = @_;
	    eval q(((($x) & ($mask)) >>  &MASK_TO_SHIFT($mask)));
    }' unless defined(&MASK_AND_RSHIFT);
    eval 'sub LSHIFT {
        my($x, $mask) = @_;
	    eval q((($x) <<  &MASK_TO_SHIFT($mask)));
    }' unless defined(&LSHIFT);
    eval 'sub MASK_AND_REPLACE {
        my($reg, $val, $mask) = @_;
	    eval q((($reg & ~$mask) |  &LSHIFT($val, $mask)));
    }' unless defined(&MASK_AND_REPLACE);
    eval 'sub PRESHIFT {
        my($m) = @_;
	    eval q( &MASK_AND_RSHIFT(($m), ($m)));
    }' unless defined(&PRESHIFT);
}
unless(defined(&ATW_PAR)) {
    sub ATW_PAR () {	0x;}
}
unless(defined(&ATW_FRCTL)) {
    sub ATW_FRCTL () {	0x4;}
}
unless(defined(&ATW_TDR)) {
    sub ATW_TDR () {	0x8;}
}
unless(defined(&ATW_WTDP)) {
    sub ATW_WTDP () {	0xc;}
}
unless(defined(&ATW_RDR)) {
    sub ATW_RDR () {	0x10;}
}
unless(defined(&ATW_WRDP)) {
    sub ATW_WRDP () {	0x14;}
}
unless(defined(&ATW_RDB)) {
    sub ATW_RDB () {	0x18;}
}
unless(defined(&ATW_CSR3A)) {
    sub ATW_CSR3A () {	0x1c;}
}
unless(defined(&ATW_C_TDBH)) {
    sub ATW_C_TDBH () {	0x1c;}
}
unless(defined(&ATW_TDBD)) {
    sub ATW_TDBD () {	0x20;}
}
unless(defined(&ATW_TDBP)) {
    sub ATW_TDBP () {	0x24;}
}
unless(defined(&ATW_STSR)) {
    sub ATW_STSR () {	0x28;}
}
unless(defined(&ATW_CSR5A)) {
    sub ATW_CSR5A () {	0x2c;}
}
unless(defined(&ATW_C_TDBB)) {
    sub ATW_C_TDBB () {	0x2c;}
}
unless(defined(&ATW_NAR)) {
    sub ATW_NAR () {	0x30;}
}
unless(defined(&ATW_CSR6A)) {
    sub ATW_CSR6A () {	0x34;}
}
unless(defined(&ATW_IER)) {
    sub ATW_IER () {	0x38;}
}
unless(defined(&ATW_CSR7A)) {
    sub ATW_CSR7A () {	0x3c;}
}
unless(defined(&ATW_LPC)) {
    sub ATW_LPC () {	0x40;}
}
unless(defined(&ATW_TEST1)) {
    sub ATW_TEST1 () {	0x44;}
}
unless(defined(&ATW_SPR)) {
    sub ATW_SPR () {	0x48;}
}
unless(defined(&ATW_TEST0)) {
    sub ATW_TEST0 () {	0x4c;}
}
unless(defined(&ATW_WCSR)) {
    sub ATW_WCSR () {	0x50;}
}
unless(defined(&ATW_WPDR)) {
    sub ATW_WPDR () {	0x54;}
}
unless(defined(&ATW_GPTMR)) {
    sub ATW_GPTMR () {	0x58;}
}
unless(defined(&ATW_GPIO)) {
    sub ATW_GPIO () {	0x5c;}
}
unless(defined(&ATW_BBPCTL)) {
    sub ATW_BBPCTL () {	0x60;}
}
unless(defined(&ATW_SYNCTL)) {
    sub ATW_SYNCTL () {	0x64;}
}
unless(defined(&ATW_PLCPHD)) {
    sub ATW_PLCPHD () {	0x68;}
}
unless(defined(&ATW_MMIWADDR)) {
    sub ATW_MMIWADDR () {	0x6c;}
}
unless(defined(&ATW_MMIRADDR1)) {
    sub ATW_MMIRADDR1 () {	0x70;}
}
unless(defined(&ATW_MMIRADDR2)) {
    sub ATW_MMIRADDR2 () {	0x74;}
}
unless(defined(&ATW_TXBR)) {
    sub ATW_TXBR () {	0x78;}
}
unless(defined(&ATW_CSR15A)) {
    sub ATW_CSR15A () {	0x7c;}
}
unless(defined(&ATW_ALCSTAT)) {
    sub ATW_ALCSTAT () {	0x80;}
}
unless(defined(&ATW_TOFS2)) {
    sub ATW_TOFS2 () {	0x84;}
}
unless(defined(&ATW_CMDR)) {
    sub ATW_CMDR () {	0x88;}
}
unless(defined(&ATW_PCIC)) {
    sub ATW_PCIC () {	0x8c;}
}
unless(defined(&ATW_PMCSR)) {
    sub ATW_PMCSR () {	0x90;}
}
unless(defined(&ATW_PAR0)) {
    sub ATW_PAR0 () {	0x94;}
}
unless(defined(&ATW_PAR1)) {
    sub ATW_PAR1 () {	0x98;}
}
unless(defined(&ATW_MAR0)) {
    sub ATW_MAR0 () {	0x9c;}
}
unless(defined(&ATW_MAR1)) {
    sub ATW_MAR1 () {	0xa0;}
}
unless(defined(&ATW_ATIMDA0)) {
    sub ATW_ATIMDA0 () {	0xa4;}
}
unless(defined(&ATW_ABDA1)) {
    sub ATW_ABDA1 () {	0xa8;}
}
unless(defined(&ATW_BSSID0)) {
    sub ATW_BSSID0 () {	0xac;}
}
unless(defined(&ATW_TXLMT)) {
    sub ATW_TXLMT () {	0xb0;}
}
unless(defined(&ATW_MIBCNT)) {
    sub ATW_MIBCNT () {	0xb4;}
}
unless(defined(&ATW_BCNT)) {
    sub ATW_BCNT () {	0xb8;}
}
unless(defined(&ATW_TSFTH)) {
    sub ATW_TSFTH () {	0xbc;}
}
unless(defined(&ATW_TSC)) {
    sub ATW_TSC () {	0xc0;}
}
unless(defined(&ATW_SYNRF)) {
    sub ATW_SYNRF () {	0xc4;}
}
unless(defined(&ATW_BPLI)) {
    sub ATW_BPLI () {	0xc8;}
}
unless(defined(&ATW_CAP0)) {
    sub ATW_CAP0 () {	0xcc;}
}
unless(defined(&ATW_CAP1)) {
    sub ATW_CAP1 () {	0xd0;}
}
unless(defined(&ATW_RMD)) {
    sub ATW_RMD () {	0xd4;}
}
unless(defined(&ATW_CFPP)) {
    sub ATW_CFPP () {	0xd8;}
}
unless(defined(&ATW_TOFS0)) {
    sub ATW_TOFS0 () {	0xdc;}
}
unless(defined(&ATW_TOFS1)) {
    sub ATW_TOFS1 () {	0xe0;}
}
unless(defined(&ATW_IFST)) {
    sub ATW_IFST () {	0xe4;}
}
unless(defined(&ATW_RSPT)) {
    sub ATW_RSPT () {	0xe8;}
}
unless(defined(&ATW_TSFTL)) {
    sub ATW_TSFTL () {	0xec;}
}
unless(defined(&ATW_WEPCTL)) {
    sub ATW_WEPCTL () {	0xf0;}
}
unless(defined(&ATW_WESK)) {
    sub ATW_WESK () {	0xf4;}
}
unless(defined(&ATW_WEPCNT)) {
    sub ATW_WEPCNT () {	0xf8;}
}
unless(defined(&ATW_MACTEST)) {
    sub ATW_MACTEST () {	0xfc;}
}
unless(defined(&ATW_FER)) {
    sub ATW_FER () {	0x100;}
}
unless(defined(&ATW_FEMR)) {
    sub ATW_FEMR () {	0x104;}
}
unless(defined(&ATW_FPSR)) {
    sub ATW_FPSR () {	0x108;}
}
unless(defined(&ATW_FFER)) {
    sub ATW_FFER () {	0x10c;}
}
unless(defined(&ATW_PAR_MWIE)) {
    sub ATW_PAR_MWIE () {	(1<<24);}
}
unless(defined(&ATW_PAR_MRLE)) {
    sub ATW_PAR_MRLE () {	(1<<23);}
}
unless(defined(&ATW_PAR_MRME)) {
    sub ATW_PAR_MRME () {	(1<<21);}
}
unless(defined(&ATW_PAR_RAP_MASK)) {
    sub ATW_PAR_RAP_MASK () {	0x60000;}
}
unless(defined(&ATW_PAR_CAL_MASK)) {
    sub ATW_PAR_CAL_MASK () {	0xc000;}
}
unless(defined(&ATW_PAR_CAL_PBL)) {
    sub ATW_PAR_CAL_PBL () {	0x;}
}
unless(defined(&ATW_PAR_CAL_8DW)) {
    sub ATW_PAR_CAL_8DW () {	 &LSHIFT(0x1,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_CAL_16DW)) {
    sub ATW_PAR_CAL_16DW () {	 &LSHIFT(0x2,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_CAL_32DW)) {
    sub ATW_PAR_CAL_32DW () {	 &LSHIFT(0x3,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_PBL_MASK)) {
    sub ATW_PAR_PBL_MASK () {	0x3f00;}
}
unless(defined(&ATW_PAR_PBL_UNLIMITED)) {
    sub ATW_PAR_PBL_UNLIMITED () {	0x;}
}
unless(defined(&ATW_PAR_PBL_1DW)) {
    sub ATW_PAR_PBL_1DW () {	 &LSHIFT(0x1,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_2DW)) {
    sub ATW_PAR_PBL_2DW () {	 &LSHIFT(0x2,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_4DW)) {
    sub ATW_PAR_PBL_4DW () {	 &LSHIFT(0x4,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_8DW)) {
    sub ATW_PAR_PBL_8DW () {	 &LSHIFT(0x8,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_16DW)) {
    sub ATW_PAR_PBL_16DW () {	 &LSHIFT(0x16,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_32DW)) {
    sub ATW_PAR_PBL_32DW () {	 &LSHIFT(0x32,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_BLE)) {
    sub ATW_PAR_BLE () {	(1<<7);}
}
unless(defined(&ATW_PAR_DSL_MASK)) {
    sub ATW_PAR_DSL_MASK () {	0x7c;}
}
unless(defined(&ATW_PAR_BAR)) {
    sub ATW_PAR_BAR () {	(1<<1);}
}
unless(defined(&ATW_PAR_SWR)) {
    sub ATW_PAR_SWR () {	(1<<0);}
}
unless(defined(&ATW_FRCTL_PWRMGMT)) {
    sub ATW_FRCTL_PWRMGMT () {	(1<<31);}
}
unless(defined(&ATW_FRCTL_VER_MASK)) {
    sub ATW_FRCTL_VER_MASK () {	0x60000000;}
}
unless(defined(&ATW_FRCTL_ORDER)) {
    sub ATW_FRCTL_ORDER () {	(1<<28);}
}
unless(defined(&ATW_FRCTL_MAXPSP)) {
    sub ATW_FRCTL_MAXPSP () {	(1<<27);}
}
unless(defined(&ATW_C_FRCTL_PRSP)) {
    sub ATW_C_FRCTL_PRSP () {	(1<<26);}
}
unless(defined(&ATW_C_FRCTL_DRVBCON)) {
    sub ATW_C_FRCTL_DRVBCON () {	(1<<25);}
}
unless(defined(&ATW_C_FRCTL_DRVLINKCTRL)) {
    sub ATW_C_FRCTL_DRVLINKCTRL () {	(1<<24);}
}
unless(defined(&ATW_C_FRCTL_DRVLINKON)) {
    sub ATW_C_FRCTL_DRVLINKON () {	(1<<23);}
}
unless(defined(&ATW_C_FRCTL_CTX_DATA)) {
    sub ATW_C_FRCTL_CTX_DATA () {	(1<<22);}
}
unless(defined(&ATW_C_FRCTL_RSVFRM)) {
    sub ATW_C_FRCTL_RSVFRM () {	(1<<21);}
}
unless(defined(&ATW_C_FRCTL_CFEND)) {
    sub ATW_C_FRCTL_CFEND () {	(1<<19);}
}
unless(defined(&ATW_FRCTL_DOZEFRM)) {
    sub ATW_FRCTL_DOZEFRM () {	(1<<18);}
}
unless(defined(&ATW_FRCTL_PSAWAKE)) {
    sub ATW_FRCTL_PSAWAKE () {	(1<<17);}
}
unless(defined(&ATW_FRCTL_PSMODE)) {
    sub ATW_FRCTL_PSMODE () {	(1<<16);}
}
unless(defined(&ATW_FRCTL_AID_MASK)) {
    sub ATW_FRCTL_AID_MASK () {	0xffff;}
}
unless(defined(&ATW_INTR_PCF)) {
    sub ATW_INTR_PCF () {	(1<<31);}
}
unless(defined(&ATW_INTR_BCNTC)) {
    sub ATW_INTR_BCNTC () {	(1<<30);}
}
unless(defined(&ATW_INTR_GPINT)) {
    sub ATW_INTR_GPINT () {	(1<<29);}
}
unless(defined(&ATW_INTR_LINKOFF)) {
    sub ATW_INTR_LINKOFF () {	(1<<28);}
}
unless(defined(&ATW_INTR_ATIMTC)) {
    sub ATW_INTR_ATIMTC () {	(1<<27);}
}
unless(defined(&ATW_INTR_TSFTF)) {
    sub ATW_INTR_TSFTF () {	(1<<26);}
}
unless(defined(&ATW_INTR_TSCZ)) {
    sub ATW_INTR_TSCZ () {	(1<<25);}
}
unless(defined(&ATW_INTR_LINKON)) {
    sub ATW_INTR_LINKON () {	(1<<24);}
}
unless(defined(&ATW_INTR_SQL)) {
    sub ATW_INTR_SQL () {	(1<<23);}
}
unless(defined(&ATW_INTR_WEPTD)) {
    sub ATW_INTR_WEPTD () {	(1<<22);}
}
unless(defined(&ATW_INTR_ATIME)) {
    sub ATW_INTR_ATIME () {	(1<<21);}
}
unless(defined(&ATW_INTR_TBTT)) {
    sub ATW_INTR_TBTT () {	(1<<20);}
}
unless(defined(&ATW_INTR_NISS)) {
    sub ATW_INTR_NISS () {	(1<<16);}
}
unless(defined(&ATW_INTR_AISS)) {
    sub ATW_INTR_AISS () {	(1<<15);}
}
unless(defined(&ATW_INTR_TEIS)) {
    sub ATW_INTR_TEIS () {	(1<<14);}
}
unless(defined(&ATW_INTR_FBE)) {
    sub ATW_INTR_FBE () {	(1<<13);}
}
unless(defined(&ATW_INTR_REIS)) {
    sub ATW_INTR_REIS () {	(1<<12);}
}
unless(defined(&ATW_INTR_GPTT)) {
    sub ATW_INTR_GPTT () {	(1<<11);}
}
unless(defined(&ATW_INTR_RPS)) {
    sub ATW_INTR_RPS () {	(1<<8);}
}
unless(defined(&ATW_INTR_RDU)) {
    sub ATW_INTR_RDU () {	(1<<7);}
}
unless(defined(&ATW_INTR_RCI)) {
    sub ATW_INTR_RCI () {	(1<<6);}
}
unless(defined(&ATW_INTR_TUF)) {
    sub ATW_INTR_TUF () {	(1<<5);}
}
unless(defined(&ATW_INTR_TRT)) {
    sub ATW_INTR_TRT () {	(1<<4);}
}
unless(defined(&ATW_INTR_TLT)) {
    sub ATW_INTR_TLT () {	(1<<3);}
}
unless(defined(&ATW_INTR_TDU)) {
    sub ATW_INTR_TDU () {	(1<<2);}
}
unless(defined(&ATW_INTR_TPS)) {
    sub ATW_INTR_TPS () {	(1<<1);}
}
unless(defined(&ATW_INTR_TCI)) {
    sub ATW_INTR_TCI () {	(1<<0);}
}
unless(defined(&ATW_NAR_TXCF)) {
    sub ATW_NAR_TXCF () {	(1<<31);}
}
unless(defined(&ATW_NAR_HF)) {
    sub ATW_NAR_HF () {	(1<<30);}
}
unless(defined(&ATW_NAR_UTR)) {
    sub ATW_NAR_UTR () {	(1<<29);}
}
unless(defined(&ATW_NAR_PCF)) {
    sub ATW_NAR_PCF () {	(1<<28);}
}
unless(defined(&ATW_NAR_CFP)) {
    sub ATW_NAR_CFP () {	(1<<27);}
}
unless(defined(&ATW_C_NAR_APSTA)) {
    sub ATW_C_NAR_APSTA () {	(1<<26);}
}
unless(defined(&ATW_C_NAR_TDBBE)) {
    sub ATW_C_NAR_TDBBE () {	(1<<25);}
}
unless(defined(&ATW_C_NAR_TDBHE)) {
    sub ATW_C_NAR_TDBHE () {	(1<<24);}
}
unless(defined(&ATW_C_NAR_TDBHT)) {
    sub ATW_C_NAR_TDBHT () {	(1<<23);}
}
unless(defined(&ATW_NAR_SF)) {
    sub ATW_NAR_SF () {	(1<<21);}
}
unless(defined(&ATW_NAR_TR_MASK)) {
    sub ATW_NAR_TR_MASK () {	0xc000;}
}
unless(defined(&ATW_NAR_TR_L64)) {
    sub ATW_NAR_TR_L64 () {	 &LSHIFT(0x,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_L160)) {
    sub ATW_NAR_TR_L160 () {	 &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_L192)) {
    sub ATW_NAR_TR_L192 () {	 &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H96)) {
    sub ATW_NAR_TR_H96 () {	 &LSHIFT(0x,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H288)) {
    sub ATW_NAR_TR_H288 () {	 &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H544)) {
    sub ATW_NAR_TR_H544 () {	 &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_ST)) {
    sub ATW_NAR_ST () {	(1<<13);}
}
unless(defined(&ATW_NAR_OM_MASK)) {
    sub ATW_NAR_OM_MASK () {	0xc00;}
}
unless(defined(&ATW_NAR_OM_NORMAL)) {
    sub ATW_NAR_OM_NORMAL () {	0x;}
}
unless(defined(&ATW_NAR_OM_LOOPBACK)) {
    sub ATW_NAR_OM_LOOPBACK () {	 &LSHIFT(0x1,  &ATW_NAR_OM_MASK);}
}
unless(defined(&ATW_NAR_MM)) {
    sub ATW_NAR_MM () {	(1<<7);}
}
unless(defined(&ATW_NAR_PR)) {
    sub ATW_NAR_PR () {	(1<<6);}
}
unless(defined(&ATW_NAR_EA)) {
    sub ATW_NAR_EA () {	(1<<5);}
}
unless(defined(&ATW_NAR_DISPCF)) {
    sub ATW_NAR_DISPCF () {	(1<<4);}
}
unless(defined(&ATW_NAR_PB)) {
    sub ATW_NAR_PB () {	(1<<3);}
}
unless(defined(&ATW_NAR_STPDMA)) {
    sub ATW_NAR_STPDMA () {	(1<<2);}
}
unless(defined(&ATW_NAR_SR)) {
    sub ATW_NAR_SR () {	(1<<1);}
}
unless(defined(&ATW_NAR_CTX)) {
    sub ATW_NAR_CTX () {	(1<<0);}
}
if(0) {
    eval 'sub ATW_IER_NIE () {(1<<16);}' unless defined(&ATW_IER_NIE);
    eval 'sub ATW_IER_AIE () {(1<<15);}' unless defined(&ATW_IER_AIE);
    eval 'sub ATW_IER_PCFIE () {(1<<31);}' unless defined(&ATW_IER_PCFIE);
    eval 'sub ATW_IER_BCNTCIE () {(1<<30);}' unless defined(&ATW_IER_BCNTCIE);
    eval 'sub ATW_IER_ATIMTCIE () {(1<<27);}' unless defined(&ATW_IER_ATIMTCIE);
    eval 'sub ATW_IER_LINKONIE () {(1<<24);}' unless defined(&ATW_IER_LINKONIE);
    eval 'sub ATW_IER_ATIMIE () {(1<<21);}' unless defined(&ATW_IER_ATIMIE);
    eval 'sub ATW_IER_TBTTIE () {(1<<20);}' unless defined(&ATW_IER_TBTTIE);
    eval 'sub ATW_IER_TEIE () {(1<<14);}' unless defined(&ATW_IER_TEIE);
    eval 'sub ATW_IER_REIE () {(1<<12);}' unless defined(&ATW_IER_REIE);
    eval 'sub ATW_IER_RCIE () {(1<<6);}' unless defined(&ATW_IER_RCIE);
    eval 'sub ATW_IER_TDUIE () {(1<<2);}' unless defined(&ATW_IER_TDUIE);
    eval 'sub ATW_IER_TCIE () {(1<<0);}' unless defined(&ATW_IER_TCIE);
    eval 'sub ATW_IER_GPIE () {(1<<29);}' unless defined(&ATW_IER_GPIE);
    eval 'sub ATW_IER_LINKOFFIE () {(1<<28);}' unless defined(&ATW_IER_LINKOFFIE);
    eval 'sub ATW_IER_TSFTFIE () {(1<<26);}' unless defined(&ATW_IER_TSFTFIE);
    eval 'sub ATW_IER_TSCIE () {(1<<25);}' unless defined(&ATW_IER_TSCIE);
    eval 'sub ATW_IER_SQLIE () {(1<<23);}' unless defined(&ATW_IER_SQLIE);
    eval 'sub ATW_IER_WEPIE () {(1<<22);}' unless defined(&ATW_IER_WEPIE);
    eval 'sub ATW_IER_FBEIE () {(1<<13);}' unless defined(&ATW_IER_FBEIE);
    eval 'sub ATW_IER_GPTIE () {(1<<11);}' unless defined(&ATW_IER_GPTIE);
    eval 'sub ATW_IER_RPSIE () {(1<<8);}' unless defined(&ATW_IER_RPSIE);
    eval 'sub ATW_IER_RUIE () {(1<<7);}' unless defined(&ATW_IER_RUIE);
    eval 'sub ATW_IER_TUIE () {(1<<5);}' unless defined(&ATW_IER_TUIE);
    eval 'sub ATW_IER_TRTIE () {(1<<4);}' unless defined(&ATW_IER_TRTIE);
    eval 'sub ATW_IER_TLTTIE () {(1<<3);}' unless defined(&ATW_IER_TLTTIE);
    eval 'sub ATW_IER_TPSIE () {(1<<1);}' unless defined(&ATW_IER_TPSIE);
}
unless(defined(&ATW_LPC_LPCO)) {
    sub ATW_LPC_LPCO () {	(1<<16);}
}
unless(defined(&ATW_LPC_LPC_MASK)) {
    sub ATW_LPC_LPC_MASK () {	0xffff;}
}
unless(defined(&ATW_TEST1_CONTROL)) {
    sub ATW_TEST1_CONTROL () {	(1<<31);}
}
unless(defined(&ATW_TEST1_DBGREAD_MASK)) {
    sub ATW_TEST1_DBGREAD_MASK () {	0x70000000;}
}
unless(defined(&ATW_TEST1_TXWP_MASK)) {
    sub ATW_TEST1_TXWP_MASK () {	0xe000000;}
}
unless(defined(&ATW_TEST1_TXWP_TDBD)) {
    sub ATW_TEST1_TXWP_TDBD () {	 &LSHIFT(0x,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBH)) {
    sub ATW_TEST1_TXWP_TDBH () {	 &LSHIFT(0x1,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBB)) {
    sub ATW_TEST1_TXWP_TDBB () {	 &LSHIFT(0x2,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBP)) {
    sub ATW_TEST1_TXWP_TDBP () {	 &LSHIFT(0x3,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_RSVD0_MASK)) {
    sub ATW_TEST1_RSVD0_MASK () {	0x1ffffc0;}
}
unless(defined(&ATW_TEST1_TESTMODE_MASK)) {
    sub ATW_TEST1_TESTMODE_MASK () {	0x30;}
}
unless(defined(&ATW_TEST1_TESTMODE_NORMAL)) {
    sub ATW_TEST1_TESTMODE_NORMAL () {	 &LSHIFT(0x,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_MACONLY)) {
    sub ATW_TEST1_TESTMODE_MACONLY () {	 &LSHIFT(0x1,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_NORMAL2)) {
    sub ATW_TEST1_TESTMODE_NORMAL2 () {	 &LSHIFT(0x2,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_MONITOR)) {
    sub ATW_TEST1_TESTMODE_MONITOR () {	 &LSHIFT(0x3,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_DUMP_MASK)) {
    sub ATW_TEST1_DUMP_MASK () {	0xf;}
}
unless(defined(&ATW_SPR_SRS)) {
    sub ATW_SPR_SRS () {	(1<<11);}
}
unless(defined(&ATW_SPR_SDO)) {
    sub ATW_SPR_SDO () {	(1<<3);}
}
unless(defined(&ATW_SPR_SDI)) {
    sub ATW_SPR_SDI () {	(1<<2);}
}
unless(defined(&ATW_SPR_SCLK)) {
    sub ATW_SPR_SCLK () {	(1<<1);}
}
unless(defined(&ATW_SPR_SCS)) {
    sub ATW_SPR_SCS () {	(1<<0);}
}
unless(defined(&ATW_TEST0_BE_MASK)) {
    sub ATW_TEST0_BE_MASK () {	0xe0000000;}
}
unless(defined(&ATW_TEST0_TS_MASK)) {
    sub ATW_TEST0_TS_MASK () {	0x1c000000;}
}
unless(defined(&ATW_TEST0_TS_STOPPED)) {
    sub ATW_TEST0_TS_STOPPED () {	 &LSHIFT(0,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_FETCH)) {
    sub ATW_TEST0_TS_FETCH () {	 &LSHIFT(1,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_WAIT)) {
    sub ATW_TEST0_TS_WAIT () {	 &LSHIFT(2,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_READING)) {
    sub ATW_TEST0_TS_READING () {	 &LSHIFT(3,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_RESERVED1)) {
    sub ATW_TEST0_TS_RESERVED1 () {	 &LSHIFT(4,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_RESERVED2)) {
    sub ATW_TEST0_TS_RESERVED2 () {	 &LSHIFT(5,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_SUSPENDED)) {
    sub ATW_TEST0_TS_SUSPENDED () {	 &LSHIFT(6,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_CLOSE)) {
    sub ATW_TEST0_TS_CLOSE () {	 &LSHIFT(7,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_SUSPENDED)) {
    sub ATW_C_TEST0_TS_SUSPENDED () {	 &LSHIFT(4,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_CLOSE)) {
    sub ATW_C_TEST0_TS_CLOSE () {	 &LSHIFT(5,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_CLOSELAST)) {
    sub ATW_C_TEST0_TS_CLOSELAST () {	 &LSHIFT(6,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_FIFOFULL)) {
    sub ATW_C_TEST0_TS_FIFOFULL () {	 &LSHIFT(7,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_RS_MASK)) {
    sub ATW_TEST0_RS_MASK () {	0x3800000;}
}
unless(defined(&ATW_TEST0_RS_STOPPED)) {
    sub ATW_TEST0_RS_STOPPED () {	 &LSHIFT(0,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_FETCH)) {
    sub ATW_TEST0_RS_FETCH () {	 &LSHIFT(1,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_CHECK)) {
    sub ATW_TEST0_RS_CHECK () {	 &LSHIFT(2,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_WAIT)) {
    sub ATW_TEST0_RS_WAIT () {	 &LSHIFT(3,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_SUSPENDED)) {
    sub ATW_TEST0_RS_SUSPENDED () {	 &LSHIFT(4,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_CLOSE)) {
    sub ATW_TEST0_RS_CLOSE () {	 &LSHIFT(5,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_FLUSH)) {
    sub ATW_TEST0_RS_FLUSH () {	 &LSHIFT(6,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_QUEUE)) {
    sub ATW_TEST0_RS_QUEUE () {	 &LSHIFT(7,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_EPNE)) {
    sub ATW_TEST0_EPNE () {	(1<<18);}
}
unless(defined(&ATW_TEST0_EPSNM)) {
    sub ATW_TEST0_EPSNM () {	(1<<17);}
}
unless(defined(&ATW_TEST0_EPTYP_MASK)) {
    sub ATW_TEST0_EPTYP_MASK () {	(1<<16);}
}
unless(defined(&ATW_TEST0_EPTYP_93c66)) {
    sub ATW_TEST0_EPTYP_93c66 () {	 &ATW_TEST0_EPTYP_MASK;}
}
unless(defined(&ATW_TEST0_EPTYP_93c46)) {
    sub ATW_TEST0_EPTYP_93c46 () {	0;}
}
unless(defined(&ATW_TEST0_EPRLD)) {
    sub ATW_TEST0_EPRLD () {	(1<<15);}
}
unless(defined(&ATW_WCSR_CRCT)) {
    sub ATW_WCSR_CRCT () {	(1<<30);}
}
unless(defined(&ATW_WCSR_WP1E)) {
    sub ATW_WCSR_WP1E () {	(1<<29);}
}
unless(defined(&ATW_WCSR_WP2E)) {
    sub ATW_WCSR_WP2E () {	(1<<28);}
}
unless(defined(&ATW_WCSR_WP3E)) {
    sub ATW_WCSR_WP3E () {	(1<<27);}
}
unless(defined(&ATW_WCSR_WP4E)) {
    sub ATW_WCSR_WP4E () {	(1<<26);}
}
unless(defined(&ATW_WCSR_WP5E)) {
    sub ATW_WCSR_WP5E () {	(1<<25);}
}
unless(defined(&ATW_WCSR_BLN_MASK)) {
    sub ATW_WCSR_BLN_MASK () {	0xe00000;}
}
unless(defined(&ATW_WCSR_TSFTWE)) {
    sub ATW_WCSR_TSFTWE () {	(1<<20);}
}
unless(defined(&ATW_WCSR_TIMWE)) {
    sub ATW_WCSR_TIMWE () {	(1<<19);}
}
unless(defined(&ATW_WCSR_ATIMWE)) {
    sub ATW_WCSR_ATIMWE () {	(1<<18);}
}
unless(defined(&ATW_WCSR_KEYWE)) {
    sub ATW_WCSR_KEYWE () {	(1<<17);}
}
unless(defined(&ATW_WCSR_WFRE)) {
    sub ATW_WCSR_WFRE () {	(1<<10);}
}
unless(defined(&ATW_WCSR_MPRE)) {
    sub ATW_WCSR_MPRE () {	(1<<9);}
}
unless(defined(&ATW_WCSR_LSOE)) {
    sub ATW_WCSR_LSOE () {	(1<<8);}
}
unless(defined(&ATW_WCSR_KEYUP)) {
    sub ATW_WCSR_KEYUP () {	(1<<6);}
}
unless(defined(&ATW_WCSR_TSFTW)) {
    sub ATW_WCSR_TSFTW () {	(1<<5);}
}
unless(defined(&ATW_WCSR_TIMW)) {
    sub ATW_WCSR_TIMW () {	(1<<4);}
}
unless(defined(&ATW_WCSR_ATIMW)) {
    sub ATW_WCSR_ATIMW () {	(1<<3);}
}
unless(defined(&ATW_WCSR_WFR)) {
    sub ATW_WCSR_WFR () {	(1<<2);}
}
unless(defined(&ATW_WCSR_MPR)) {
    sub ATW_WCSR_MPR () {	(1<<1);}
}
unless(defined(&ATW_WCSR_LSO)) {
    sub ATW_WCSR_LSO () {	(1<<0);}
}
unless(defined(&ATW_GPTMR_COM_MASK)) {
    sub ATW_GPTMR_COM_MASK () {	(1<<16);}
}
unless(defined(&ATW_GPTMR_GTV_MASK)) {
    sub ATW_GPTMR_GTV_MASK () {	0xffff;}
}
unless(defined(&ATW_GPIO_EC1_MASK)) {
    sub ATW_GPIO_EC1_MASK () {	0x3000000;}
}
unless(defined(&ATW_GPIO_LAT_MASK)) {
    sub ATW_GPIO_LAT_MASK () {	0x300000;}
}
unless(defined(&ATW_GPIO_INTEN_MASK)) {
    sub ATW_GPIO_INTEN_MASK () {	0xc0000;}
}
unless(defined(&ATW_GPIO_EN_MASK)) {
    sub ATW_GPIO_EN_MASK () {	0x3f000;}
}
unless(defined(&ATW_GPIO_O_MASK)) {
    sub ATW_GPIO_O_MASK () {	0xfc0;}
}
unless(defined(&ATW_GPIO_I_MASK)) {
    sub ATW_GPIO_I_MASK () {	0x3f;}
}
unless(defined(&ATW_BBPCTL_TWI)) {
    sub ATW_BBPCTL_TWI () {	(1<<31);}
}
unless(defined(&ATW_BBPCTL_RF3KADDR_MASK)) {
    sub ATW_BBPCTL_RF3KADDR_MASK () {	0x7f000000;}
}
unless(defined(&ATW_BBPCTL_RF3KADDR_ADDR)) {
    sub ATW_BBPCTL_RF3KADDR_ADDR () {	 &LSHIFT(0x20,  &ATW_BBPCTL_RF3KADDR_MASK);}
}
unless(defined(&ATW_BBPCTL_NEGEDGE_DO)) {
    sub ATW_BBPCTL_NEGEDGE_DO () {	(1<<23);}
}
unless(defined(&ATW_BBPCTL_NEGEDGE_DI)) {
    sub ATW_BBPCTL_NEGEDGE_DI () {	(1<<22);}
}
unless(defined(&ATW_BBPCTL_CCA_ACTLO)) {
    sub ATW_BBPCTL_CCA_ACTLO () {	(1<<21);}
}
unless(defined(&ATW_BBPCTL_TYPE_MASK)) {
    sub ATW_BBPCTL_TYPE_MASK () {	0x1c0000;}
}
unless(defined(&ATW_BBPCTL_WR)) {
    sub ATW_BBPCTL_WR () {	(1<<17);}
}
unless(defined(&ATW_BBPCTL_RD)) {
    sub ATW_BBPCTL_RD () {	(1<<16);}
}
unless(defined(&ATW_BBPCTL_ADDR_MASK)) {
    sub ATW_BBPCTL_ADDR_MASK () {	0xff00;}
}
unless(defined(&ATW_BBPCTL_DATA_MASK)) {
    sub ATW_BBPCTL_DATA_MASK () {	0xff;}
}
unless(defined(&ATW_SYNCTL_WR)) {
    sub ATW_SYNCTL_WR () {	(1<<31);}
}
unless(defined(&ATW_SYNCTL_RD)) {
    sub ATW_SYNCTL_RD () {	(1<<30);}
}
unless(defined(&ATW_SYNCTL_CS0)) {
    sub ATW_SYNCTL_CS0 () {	(1<<29);}
}
unless(defined(&ATW_SYNCTL_CS1)) {
    sub ATW_SYNCTL_CS1 () {	(1<<28);}
}
unless(defined(&ATW_SYNCTL_CAL)) {
    sub ATW_SYNCTL_CAL () {	(1<<27);}
}
unless(defined(&ATW_SYNCTL_SELCAL)) {
    sub ATW_SYNCTL_SELCAL () {	(1<<26);}
}
unless(defined(&ATW_C_SYNCTL_MMICE)) {
    sub ATW_C_SYNCTL_MMICE () {	(1<<25);}
}
unless(defined(&ATW_SYNCTL_RFTYPE_MASK)) {
    sub ATW_SYNCTL_RFTYPE_MASK () {	0x1c00000;}
}
unless(defined(&ATW_SYNCTL_DATA_MASK)) {
    sub ATW_SYNCTL_DATA_MASK () {	0x3fffff;}
}
unless(defined(&ATW_PLCPHD_SIGNAL_MASK)) {
    sub ATW_PLCPHD_SIGNAL_MASK () {	0xff000000;}
}
unless(defined(&ATW_PLCPHD_SERVICE_MASK)) {
    sub ATW_PLCPHD_SERVICE_MASK () {	0xff0000;}
}
unless(defined(&ATW_PLCPHD_PMBL)) {
    sub ATW_PLCPHD_PMBL () {	(1<<15);}
}
unless(defined(&ATW_MMIWADDR_LENLO_MASK)) {
    sub ATW_MMIWADDR_LENLO_MASK () {	0xff000000;}
}
unless(defined(&ATW_MMIWADDR_LENHI_MASK)) {
    sub ATW_MMIWADDR_LENHI_MASK () {	0xff0000;}
}
unless(defined(&ATW_MMIWADDR_GAIN_MASK)) {
    sub ATW_MMIWADDR_GAIN_MASK () {	0xff00;}
}
unless(defined(&ATW_MMIWADDR_RATE_MASK)) {
    sub ATW_MMIWADDR_RATE_MASK () {	0xff;}
}
unless(defined(&ATW_MMIWADDR_INTERSIL)) {
    sub ATW_MMIWADDR_INTERSIL () {	( &LSHIFT(0xc,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT(0xa,  &ATW_MMIWADDR_RATE_MASK) |  &LSHIFT(0xe,  &ATW_MMIWADDR_LENHI_MASK) |  &LSHIFT(0x10,  &ATW_MMIWADDR_LENLO_MASK));}
}
unless(defined(&ATW_MMIWADDR_RFMD)) {
    sub ATW_MMIWADDR_RFMD () {	( &LSHIFT( &RF3000_TWI_AI| &RF3000_GAINCTL,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT( &RF3000_CTL,  &ATW_MMIWADDR_RATE_MASK));}
}
unless(defined(&ATW_MMIRADDR1_RSVD_MASK)) {
    sub ATW_MMIRADDR1_RSVD_MASK () {	0xff000000;}
}
unless(defined(&ATW_MMIRADDR1_PWRLVL_MASK)) {
    sub ATW_MMIRADDR1_PWRLVL_MASK () {	0xff0000;}
}
unless(defined(&ATW_MMIRADDR1_RSSI_MASK)) {
    sub ATW_MMIRADDR1_RSSI_MASK () {	0xff00;}
}
unless(defined(&ATW_MMIRADDR1_RXSTAT_MASK)) {
    sub ATW_MMIRADDR1_RXSTAT_MASK () {	0xff;}
}
unless(defined(&ATW_MMIRADDR1_INTERSIL)) {
    sub ATW_MMIRADDR1_INTERSIL () {	( &LSHIFT(0x7c,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT(0x7e,  &ATW_MMIRADDR1_RXSTAT_MASK));}
}
unless(defined(&ATW_MMIRADDR1_RFMD)) {
    sub ATW_MMIRADDR1_RFMD () {	( &LSHIFT( &RF3000_RSSI,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT( &RF3000_RXSTAT,  &ATW_MMIRADDR1_RXSTAT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_INTERSIL)) {
    sub ATW_MMIRADDR2_INTERSIL () {	( &LSHIFT(0x,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_RFMD)) {
    sub ATW_MMIRADDR2_RFMD () {	( &LSHIFT(0x7e,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_ID_MASK)) {
    sub ATW_MMIRADDR2_ID_MASK () {	0xff000000;}
}
unless(defined(&ATW_MMIRADDR2_RXPECNT_MASK)) {
    sub ATW_MMIRADDR2_RXPECNT_MASK () {	0xff0000;}
}
unless(defined(&ATW_MMIRADDR2_PROREXT)) {
    sub ATW_MMIRADDR2_PROREXT () {	(1<<15);}
}
unless(defined(&ATW_MMIRADDR2_PRORLEN_MASK)) {
    sub ATW_MMIRADDR2_PRORLEN_MASK () {	0x7fff;}
}
unless(defined(&ATW_TXBR_ALCUPDATE_MASK)) {
    sub ATW_TXBR_ALCUPDATE_MASK () {	(1<<31);}
}
unless(defined(&ATW_TXBR_TBCNT_MASK)) {
    sub ATW_TXBR_TBCNT_MASK () {	0x1f0000;}
}
unless(defined(&ATW_TXBR_ALCSET_MASK)) {
    sub ATW_TXBR_ALCSET_MASK () {	0xff00;}
}
unless(defined(&ATW_TXBR_ALCREF_MASK)) {
    sub ATW_TXBR_ALCREF_MASK () {	0xff;}
}
unless(defined(&ATW_ALCSTAT_MCOV_MASK)) {
    sub ATW_ALCSTAT_MCOV_MASK () {	(1<<27);}
}
unless(defined(&ATW_ALCSTAT_ESOV_MASK)) {
    sub ATW_ALCSTAT_ESOV_MASK () {	(1<<26);}
}
unless(defined(&ATW_ALCSTAT_MCNT_MASK)) {
    sub ATW_ALCSTAT_MCNT_MASK () {	0x3ff0000;}
}
unless(defined(&ATW_ALCSTAT_ERSUM_MASK)) {
    sub ATW_ALCSTAT_ERSUM_MASK () {	0xffff;}
}
unless(defined(&ATW_TOFS2_PWR1UP_MASK)) {
    sub ATW_TOFS2_PWR1UP_MASK () {	0xf0000000;}
}
unless(defined(&ATW_TOFS2_PWR0PAPE_MASK)) {
    sub ATW_TOFS2_PWR0PAPE_MASK () {	0xf000000;}
}
unless(defined(&ATW_TOFS2_PWR1PAPE_MASK)) {
    sub ATW_TOFS2_PWR1PAPE_MASK () {	0xf00000;}
}
unless(defined(&ATW_TOFS2_PWR0TRSW_MASK)) {
    sub ATW_TOFS2_PWR0TRSW_MASK () {	0xf0000;}
}
unless(defined(&ATW_TOFS2_PWR1TRSW_MASK)) {
    sub ATW_TOFS2_PWR1TRSW_MASK () {	0xf000;}
}
unless(defined(&ATW_TOFS2_PWR0PE2_MASK)) {
    sub ATW_TOFS2_PWR0PE2_MASK () {	0xf00;}
}
unless(defined(&ATW_TOFS2_PWR1PE2_MASK)) {
    sub ATW_TOFS2_PWR1PE2_MASK () {	0xf0;}
}
unless(defined(&ATW_TOFS2_PWR0TXPE_MASK)) {
    sub ATW_TOFS2_PWR0TXPE_MASK () {	0xf;}
}
unless(defined(&ATW_CMDR_PM)) {
    sub ATW_CMDR_PM () {	(1<<19);}
}
unless(defined(&ATW_CMDR_APM)) {
    sub ATW_CMDR_APM () {	(1<<18);}
}
unless(defined(&ATW_CMDR_RTE)) {
    sub ATW_CMDR_RTE () {	(1<<4);}
}
unless(defined(&ATW_CMDR_DRT_MASK)) {
    sub ATW_CMDR_DRT_MASK () {	0xc;}
}
unless(defined(&ATW_CMDR_DRT_8DW)) {
    sub ATW_CMDR_DRT_8DW () {	 &LSHIFT(0x,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_16DW)) {
    sub ATW_CMDR_DRT_16DW () {	 &LSHIFT(0x1,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_SF)) {
    sub ATW_CMDR_DRT_SF () {	 &LSHIFT(0x2,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_RSVD)) {
    sub ATW_CMDR_DRT_RSVD () {	 &LSHIFT(0x3,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_SINT_MASK)) {
    sub ATW_CMDR_SINT_MASK () {	(1<<1);}
}
unless(defined(&ATW_PAR0_PAB0_MASK)) {
    sub ATW_PAR0_PAB0_MASK () {	0xff;}
}
unless(defined(&ATW_PAR0_PAB1_MASK)) {
    sub ATW_PAR0_PAB1_MASK () {	0xff00;}
}
unless(defined(&ATW_PAR0_PAB2_MASK)) {
    sub ATW_PAR0_PAB2_MASK () {	0xff0000;}
}
unless(defined(&ATW_PAR0_PAB3_MASK)) {
    sub ATW_PAR0_PAB3_MASK () {	0xff000000;}
}
unless(defined(&ATW_C_PAR1_CTD)) {
    sub ATW_C_PAR1_CTD () {	0xffff0000;}
}
unless(defined(&ATW_PAR1_PAB5_MASK)) {
    sub ATW_PAR1_PAB5_MASK () {	0xff00;}
}
unless(defined(&ATW_PAR1_PAB4_MASK)) {
    sub ATW_PAR1_PAB4_MASK () {	0xff;}
}
unless(defined(&ATW_MAR0_MAB3_MASK)) {
    sub ATW_MAR0_MAB3_MASK () {	0xff000000;}
}
unless(defined(&ATW_MAR0_MAB2_MASK)) {
    sub ATW_MAR0_MAB2_MASK () {	0xff0000;}
}
unless(defined(&ATW_MAR0_MAB1_MASK)) {
    sub ATW_MAR0_MAB1_MASK () {	0xff00;}
}
unless(defined(&ATW_MAR0_MAB0_MASK)) {
    sub ATW_MAR0_MAB0_MASK () {	0xff;}
}
unless(defined(&ATW_MAR1_MAB7_MASK)) {
    sub ATW_MAR1_MAB7_MASK () {	0xff000000;}
}
unless(defined(&ATW_MAR1_MAB6_MASK)) {
    sub ATW_MAR1_MAB6_MASK () {	0xff0000;}
}
unless(defined(&ATW_MAR1_MAB5_MASK)) {
    sub ATW_MAR1_MAB5_MASK () {	0xff00;}
}
unless(defined(&ATW_MAR1_MAB4_MASK)) {
    sub ATW_MAR1_MAB4_MASK () {	0xff;}
}
unless(defined(&ATW_ATIMDA0_ATIMB3_MASK)) {
    sub ATW_ATIMDA0_ATIMB3_MASK () {	0xff000000;}
}
unless(defined(&ATW_ATIMDA0_ATIMB2_MASK)) {
    sub ATW_ATIMDA0_ATIMB2_MASK () {	0xff0000;}
}
unless(defined(&ATW_ATIMDA0_ATIMB1_MASK)) {
    sub ATW_ATIMDA0_ATIMB1_MASK () {	0xff00;}
}
unless(defined(&ATW_ATIMDA0_ATIMB0_MASK)) {
    sub ATW_ATIMDA0_ATIMB0_MASK () {	0xff;}
}
unless(defined(&ATW_ABDA1_BSSIDB5_MASK)) {
    sub ATW_ABDA1_BSSIDB5_MASK () {	0xff000000;}
}
unless(defined(&ATW_ABDA1_BSSIDB4_MASK)) {
    sub ATW_ABDA1_BSSIDB4_MASK () {	0xff0000;}
}
unless(defined(&ATW_ABDA1_ATIMB5_MASK)) {
    sub ATW_ABDA1_ATIMB5_MASK () {	0xff00;}
}
unless(defined(&ATW_ABDA1_ATIMB4_MASK)) {
    sub ATW_ABDA1_ATIMB4_MASK () {	0xff;}
}
unless(defined(&ATW_BSSID0_BSSIDB3_MASK)) {
    sub ATW_BSSID0_BSSIDB3_MASK () {	0xff000000;}
}
unless(defined(&ATW_BSSID0_BSSIDB2_MASK)) {
    sub ATW_BSSID0_BSSIDB2_MASK () {	0xff0000;}
}
unless(defined(&ATW_BSSID0_BSSIDB1_MASK)) {
    sub ATW_BSSID0_BSSIDB1_MASK () {	0xff00;}
}
unless(defined(&ATW_BSSID0_BSSIDB0_MASK)) {
    sub ATW_BSSID0_BSSIDB0_MASK () {	0xff;}
}
unless(defined(&ATW_TXLMT_MTMLT_MASK)) {
    sub ATW_TXLMT_MTMLT_MASK () {	0xffff0000;}
}
unless(defined(&ATW_TXLMT_SRTYLIM_MASK)) {
    sub ATW_TXLMT_SRTYLIM_MASK () {	0xff;}
}
unless(defined(&ATW_MIBCNT_FFCNT_MASK)) {
    sub ATW_MIBCNT_FFCNT_MASK () {	0xff000000;}
}
unless(defined(&ATW_MIBCNT_AFCNT_MASK)) {
    sub ATW_MIBCNT_AFCNT_MASK () {	0xff0000;}
}
unless(defined(&ATW_MIBCNT_RSCNT_MASK)) {
    sub ATW_MIBCNT_RSCNT_MASK () {	0xff00;}
}
unless(defined(&ATW_MIBCNT_RFCNT_MASK)) {
    sub ATW_MIBCNT_RFCNT_MASK () {	0xff;}
}
unless(defined(&ATW_BCNT_PLCPH_MASK)) {
    sub ATW_BCNT_PLCPH_MASK () {	0xff0000;}
}
unless(defined(&ATW_BCNT_PLCPL_MASK)) {
    sub ATW_BCNT_PLCPL_MASK () {	0xff00;}
}
unless(defined(&ATW_BCNT_BCNT_MASK)) {
    sub ATW_BCNT_BCNT_MASK () {	0xff;}
}
unless(defined(&ATW_C_BCNT_EXTEN1)) {
    sub ATW_C_BCNT_EXTEN1 () {	(1<<31);}
}
unless(defined(&ATW_C_BCNT_BEANLEN1)) {
    sub ATW_C_BCNT_BEANLEN1 () {	0x7fff0000;}
}
unless(defined(&ATW_C_BCNT_EXTEN0)) {
    sub ATW_C_BCNT_EXTEN0 () {	(1<<15);}
}
unless(defined(&ATW_C_BCNT_BEANLEN0)) {
    sub ATW_C_BCNT_BEANLEN0 () {	 &BIT(14,0);}
}
unless(defined(&ATW_C_TSC_TIMOFS)) {
    sub ATW_C_TSC_TIMOFS () {	0xff000000;}
}
unless(defined(&ATW_C_TSC_TIMLEN)) {
    sub ATW_C_TSC_TIMLEN () {	0x3ff000;}
}
unless(defined(&ATW_C_TSC_TIMTABSEL)) {
    sub ATW_C_TSC_TIMTABSEL () {	(1<<4);}
}
unless(defined(&ATW_TSC_TSC_MASK)) {
    sub ATW_TSC_TSC_MASK () {	0xf;}
}
unless(defined(&ATW_SYNRF_SELSYN)) {
    sub ATW_SYNRF_SELSYN () {	(1<<31);}
}
unless(defined(&ATW_SYNRF_SELRF)) {
    sub ATW_SYNRF_SELRF () {	(1<<30);}
}
unless(defined(&ATW_SYNRF_LERF)) {
    sub ATW_SYNRF_LERF () {	(1<<29);}
}
unless(defined(&ATW_SYNRF_LEIF)) {
    sub ATW_SYNRF_LEIF () {	(1<<28);}
}
unless(defined(&ATW_SYNRF_SYNCLK)) {
    sub ATW_SYNRF_SYNCLK () {	(1<<27);}
}
unless(defined(&ATW_SYNRF_SYNDATA)) {
    sub ATW_SYNRF_SYNDATA () {	(1<<26);}
}
unless(defined(&ATW_SYNRF_PE1)) {
    sub ATW_SYNRF_PE1 () {	(1<<25);}
}
unless(defined(&ATW_SYNRF_PE2)) {
    sub ATW_SYNRF_PE2 () {	(1<<24);}
}
unless(defined(&ATW_SYNRF_PAPE)) {
    sub ATW_SYNRF_PAPE () {	(1<<23);}
}
unless(defined(&ATW_C_SYNRF_TRSW)) {
    sub ATW_C_SYNRF_TRSW () {	(1<<22);}
}
unless(defined(&ATW_C_SYNRF_TRSWN)) {
    sub ATW_C_SYNRF_TRSWN () {	(1<<21);}
}
unless(defined(&ATW_SYNRF_INTERSIL_EN)) {
    sub ATW_SYNRF_INTERSIL_EN () {	(1<<20);}
}
unless(defined(&ATW_SYNRF_PHYRST)) {
    sub ATW_SYNRF_PHYRST () {	(1<<18);}
}
unless(defined(&ATW_C_SYNRF_RF2958PD)) {
    sub ATW_C_SYNRF_RF2958PD () {	 &ATW_SYNRF_PHYRST;}
}
unless(defined(&ATW_BPLI_BP_MASK)) {
    sub ATW_BPLI_BP_MASK () {	0xffff0000;}
}
unless(defined(&ATW_BPLI_LI_MASK)) {
    sub ATW_BPLI_LI_MASK () {	0xffff;}
}
unless(defined(&ATW_C_CAP0_TIMLEN1)) {
    sub ATW_C_CAP0_TIMLEN1 () {	0xff000000;}
}
unless(defined(&ATW_C_CAP0_TIMLEN0)) {
    sub ATW_C_CAP0_TIMLEN0 () {	0xff0000;}
}
unless(defined(&ATW_C_CAP0_CWMAX)) {
    sub ATW_C_CAP0_CWMAX () {	0xf00;}
}
unless(defined(&ATW_CAP0_RCVDTIM)) {
    sub ATW_CAP0_RCVDTIM () {	(1<<4);}
}
unless(defined(&ATW_CAP0_CHN_MASK)) {
    sub ATW_CAP0_CHN_MASK () {	0xf;}
}
unless(defined(&ATW_CAP1_CAPI_MASK)) {
    sub ATW_CAP1_CAPI_MASK () {	0xffff0000;}
}
unless(defined(&ATW_CAP1_ATIMW_MASK)) {
    sub ATW_CAP1_ATIMW_MASK () {	0xffff;}
}
unless(defined(&ATW_RMD_ATIMST)) {
    sub ATW_RMD_ATIMST () {	(1<<31);}
}
unless(defined(&ATW_RMD_CFP)) {
    sub ATW_RMD_CFP () {	(1<<30);}
}
unless(defined(&ATW_RMD_PCNT)) {
    sub ATW_RMD_PCNT () {	0xfff0000;}
}
unless(defined(&ATW_RMD_RMRD_MASK)) {
    sub ATW_RMD_RMRD_MASK () {	0xffff;}
}
unless(defined(&ATW_CFPP_CFPP)) {
    sub ATW_CFPP_CFPP () {	0xff000000;}
}
unless(defined(&ATW_CFPP_CFPMD)) {
    sub ATW_CFPP_CFPMD () {	0xffff00;}
}
unless(defined(&ATW_CFPP_DTIMP)) {
    sub ATW_CFPP_DTIMP () {	0xff;}
}
unless(defined(&ATW_TOFS0_USCNT_MASK)) {
    sub ATW_TOFS0_USCNT_MASK () {	0x3f000000;}
}
unless(defined(&ATW_C_TOFS0_TUCNT_MASK)) {
    sub ATW_C_TOFS0_TUCNT_MASK () {	0x7c00;}
}
unless(defined(&ATW_TOFS0_TUCNT_MASK)) {
    sub ATW_TOFS0_TUCNT_MASK () {	0x3ff;}
}
unless(defined(&ATW_TOFS1_TSFTOFSR_MASK)) {
    sub ATW_TOFS1_TSFTOFSR_MASK () {	0xff000000;}
}
unless(defined(&ATW_TOFS1_TBTTPRE_MASK)) {
    sub ATW_TOFS1_TBTTPRE_MASK () {	0xffff00;}
}
unless(defined(&ATW_TBTTPRE_MASK)) {
    sub ATW_TBTTPRE_MASK () {	0x3fffc00;}
}
unless(defined(&ATW_TOFS1_TBTTOFS_MASK)) {
    sub ATW_TOFS1_TBTTOFS_MASK () {	0xff;}
}
unless(defined(&ATW_IFST_SLOT_MASK)) {
    sub ATW_IFST_SLOT_MASK () {	0xf800000;}
}
unless(defined(&ATW_IFST_SIFS_MASK)) {
    sub ATW_IFST_SIFS_MASK () {	0x7f8000;}
}
unless(defined(&ATW_IFST_DIFS_MASK)) {
    sub ATW_IFST_DIFS_MASK () {	0x7e00;}
}
unless(defined(&ATW_IFST_EIFS_MASK)) {
    sub ATW_IFST_EIFS_MASK () {	0x1ff;}
}
unless(defined(&ATW_RSPT_MART_MASK)) {
    sub ATW_RSPT_MART_MASK () {	0xffff0000;}
}
unless(defined(&ATW_RSPT_MIRT_MASK)) {
    sub ATW_RSPT_MIRT_MASK () {	0xff00;}
}
unless(defined(&ATW_RSPT_TSFTOFST_MASK)) {
    sub ATW_RSPT_TSFTOFST_MASK () {	0xff;}
}
unless(defined(&ATW_WEPCTL_WEPENABLE)) {
    sub ATW_WEPCTL_WEPENABLE () {	(1<<31);}
}
unless(defined(&ATW_WEPCTL_AUTOSWITCH)) {
    sub ATW_WEPCTL_AUTOSWITCH () {	(1<<30);}
}
unless(defined(&ATW_WEPCTL_CURTBL)) {
    sub ATW_WEPCTL_CURTBL () {	(1<<29);}
}
unless(defined(&ATW_WEPCTL_WR)) {
    sub ATW_WEPCTL_WR () {	(1<<28);}
}
unless(defined(&ATW_WEPCTL_RD)) {
    sub ATW_WEPCTL_RD () {	(1<<27);}
}
unless(defined(&ATW_WEPCTL_WEPRXBYP)) {
    sub ATW_WEPCTL_WEPRXBYP () {	(1<<25);}
}
unless(defined(&ATW_WEPCTL_SHKEY)) {
    sub ATW_WEPCTL_SHKEY () {	(1<<24);}
}
unless(defined(&ATW_WEPCTL_UNKNOWN0)) {
    sub ATW_WEPCTL_UNKNOWN0 () {	(1<<23);}
}
unless(defined(&ATW_WEPCTL_TBLADD_MASK)) {
    sub ATW_WEPCTL_TBLADD_MASK () {	0x1ff;}
}
unless(defined(&ATW_WEP_ENABLED)) {
    sub ATW_WEP_ENABLED () {	(1<<7);}
}
unless(defined(&ATW_WEP_104BIT)) {
    sub ATW_WEP_104BIT () {	(1<<6);}
}
unless(defined(&ATW_WESK_DATA_MASK)) {
    sub ATW_WESK_DATA_MASK () {	0xffff;}
}
unless(defined(&ATW_WEPCNT_WIEC_MASK)) {
    sub ATW_WEPCNT_WIEC_MASK () {	0xffff;}
}
unless(defined(&ATW_MACTEST_FORCE_IV)) {
    sub ATW_MACTEST_FORCE_IV () {	(1<<23);}
}
unless(defined(&ATW_MACTEST_FORCE_KEYID)) {
    sub ATW_MACTEST_FORCE_KEYID () {	(1<<22);}
}
unless(defined(&ATW_MACTEST_KEYID_MASK)) {
    sub ATW_MACTEST_KEYID_MASK () {	0x300000;}
}
unless(defined(&ATW_MACTEST_MMI_USETXCLK)) {
    sub ATW_MACTEST_MMI_USETXCLK () {	(1<<11);}
}
unless(defined(&ATW_FER_INTR)) {
    sub ATW_FER_INTR () {	(1<<15);}
}
unless(defined(&ATW_FER_GWAKE)) {
    sub ATW_FER_GWAKE () {	(1<<4);}
}
unless(defined(&ATW_FEMR_INTR_EN)) {
    sub ATW_FEMR_INTR_EN () {	(1<<15);}
}
unless(defined(&ATW_FEMR_WAKEUP_EN)) {
    sub ATW_FEMR_WAKEUP_EN () {	(1<<14);}
}
unless(defined(&ATW_FEMR_GWAKE_EN)) {
    sub ATW_FEMR_GWAKE_EN () {	(1<<4);}
}
unless(defined(&ATW_FPSR_INTR_STATUS)) {
    sub ATW_FPSR_INTR_STATUS () {	(1<<15);}
}
unless(defined(&ATW_FPSR_WAKEUP_STATUS)) {
    sub ATW_FPSR_WAKEUP_STATUS () {	(1<<4);}
}
unless(defined(&ATW_FFER_INTA_FORCE)) {
    sub ATW_FFER_INTA_FORCE () {	(1<<15);}
}
unless(defined(&ATW_FFER_GWAKE_FORCE)) {
    sub ATW_FFER_GWAKE_FORCE () {	(1<<4);}
}
unless(defined(&ATW_SR_CLASS_CODE)) {
    sub ATW_SR_CLASS_CODE () {	(0x/2);}
}
unless(defined(&ATW_SR_FORMAT_VERSION)) {
    sub ATW_SR_FORMAT_VERSION () {	(0x2/2);}
}
unless(defined(&ATW_SR_MAJOR_MASK)) {
    sub ATW_SR_MAJOR_MASK () {	0xff;}
}
unless(defined(&ATW_SR_MINOR_MASK)) {
    sub ATW_SR_MINOR_MASK () {	0xff00;}
}
unless(defined(&ATW_SR_MAC00)) {
    sub ATW_SR_MAC00 () {	(0x8/2);}
}
unless(defined(&ATW_SR_MAC01)) {
    sub ATW_SR_MAC01 () {	(0xa/2);}
}
unless(defined(&ATW_SR_MAC10)) {
    sub ATW_SR_MAC10 () {	(0xc/2);}
}
unless(defined(&ATW_SR_CSR20)) {
    sub ATW_SR_CSR20 () {	(0x16/2);}
}
unless(defined(&ATW_SR_ANT_MASK)) {
    sub ATW_SR_ANT_MASK () {	0x1c00;}
}
unless(defined(&ATW_SR_PWRSCALE_MASK)) {
    sub ATW_SR_PWRSCALE_MASK () {	0x300;}
}
unless(defined(&ATW_SR_CLKSAVE_MASK)) {
    sub ATW_SR_CLKSAVE_MASK () {	0xc0;}
}
unless(defined(&ATW_SR_RFTYPE_MASK)) {
    sub ATW_SR_RFTYPE_MASK () {	0x38;}
}
unless(defined(&ATW_SR_BBPTYPE_MASK)) {
    sub ATW_SR_BBPTYPE_MASK () {	0x7;}
}
unless(defined(&ATW_SR_CR28_CR03)) {
    sub ATW_SR_CR28_CR03 () {	(0x18/2);}
}
unless(defined(&ATW_SR_CR28_MASK)) {
    sub ATW_SR_CR28_MASK () {	0xff00;}
}
unless(defined(&ATW_SR_CR03_MASK)) {
    sub ATW_SR_CR03_MASK () {	0xff;}
}
unless(defined(&ATW_SR_CTRY_CR29)) {
    sub ATW_SR_CTRY_CR29 () {	(0x1a/2);}
}
unless(defined(&ATW_SR_CTRY_MASK)) {
    sub ATW_SR_CTRY_MASK () {	0xff00;}
}
unless(defined(&COUNTRY_FCC)) {
    sub COUNTRY_FCC () {	0;}
}
unless(defined(&COUNTRY_IC)) {
    sub COUNTRY_IC () {	1;}
}
unless(defined(&COUNTRY_ETSI)) {
    sub COUNTRY_ETSI () {	2;}
}
unless(defined(&COUNTRY_SPAIN)) {
    sub COUNTRY_SPAIN () {	3;}
}
unless(defined(&COUNTRY_FRANCE)) {
    sub COUNTRY_FRANCE () {	4;}
}
unless(defined(&COUNTRY_MMK)) {
    sub COUNTRY_MMK () {	5;}
}
unless(defined(&COUNTRY_MMK2)) {
    sub COUNTRY_MMK2 () {	6;}
}
unless(defined(&ATW_SR_CR29_MASK)) {
    sub ATW_SR_CR29_MASK () {	0xff;}
}
unless(defined(&ATW_SR_PCI_DEVICE)) {
    sub ATW_SR_PCI_DEVICE () {	(0x20/2);}
}
unless(defined(&ATW_SR_PCI_VENDOR)) {
    sub ATW_SR_PCI_VENDOR () {	(0x22/2);}
}
unless(defined(&ATW_SR_SUB_DEVICE)) {
    sub ATW_SR_SUB_DEVICE () {	(0x24/2);}
}
unless(defined(&ATW_SR_SUB_VENDOR)) {
    sub ATW_SR_SUB_VENDOR () {	(0x26/2);}
}
unless(defined(&ATW_SR_CR15)) {
    sub ATW_SR_CR15 () {	(0x28/2);}
}
unless(defined(&ATW_SR_LOCISPTR)) {
    sub ATW_SR_LOCISPTR () {	(0x2a/2);}
}
unless(defined(&ATW_SR_HICISPTR)) {
    sub ATW_SR_HICISPTR () {	(0x2c/2);}
}
unless(defined(&ATW_SR_CSR18)) {
    sub ATW_SR_CSR18 () {	(0x2e/2);}
}
unless(defined(&ATW_SR_D0_D1_PWR)) {
    sub ATW_SR_D0_D1_PWR () {	(0x40/2);}
}
unless(defined(&ATW_SR_D2_D3_PWR)) {
    sub ATW_SR_D2_D3_PWR () {	(0x42/2);}
}
unless(defined(&ATW_SR_CIS_WORDS)) {
    sub ATW_SR_CIS_WORDS () {	(0x52/2);}
}
unless(defined(&ATW_SR_TXPOWER)) {
    sub ATW_SR_TXPOWER {
	my($chnl) = @_;
	eval q((0x54/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LPF_CUTOFF)) {
    sub ATW_SR_LPF_CUTOFF {
	my($chnl) = @_;
	eval q((0x62/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LNA_GS_THRESH)) {
    sub ATW_SR_LNA_GS_THRESH {
	my($chnl) = @_;
	eval q((0x70/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_CHECKSUM)) {
    sub ATW_SR_CHECKSUM () {	(0x7e/2);}
}
unless(defined(&ATW_SR_CIS)) {
    sub ATW_SR_CIS () {	(0x80/2);}
}
unless(defined(&at_stat)) {
    sub at_stat () {	 &at_ctl;}
}
unless(defined(&ATW_TXCTL_OWN)) {
    sub ATW_TXCTL_OWN () {	(1<<31);}
}
unless(defined(&ATW_TXCTL_DONE)) {
    sub ATW_TXCTL_DONE () {	(1<<30);}
}
unless(defined(&ATW_TXCTL_TXDR_MASK)) {
    sub ATW_TXCTL_TXDR_MASK () {	0xff00000;}
}
unless(defined(&ATW_TXCTL_TL_MASK)) {
    sub ATW_TXCTL_TL_MASK () {	0xfffff;}
}
unless(defined(&ATW_TXSTAT_OWN)) {
    sub ATW_TXSTAT_OWN () {	 &ATW_TXCTL_OWN;}
}
unless(defined(&ATW_TXSTAT_DONE)) {
    sub ATW_TXSTAT_DONE () {	 &ATW_TXCTL_DONE;}
}
unless(defined(&ATW_TXSTAT_ES)) {
    sub ATW_TXSTAT_ES () {	(1<<29);}
}
unless(defined(&ATW_TXSTAT_TLT)) {
    sub ATW_TXSTAT_TLT () {	(1<<28);}
}
unless(defined(&ATW_TXSTAT_TRT)) {
    sub ATW_TXSTAT_TRT () {	(1<<27);}
}
unless(defined(&ATW_TXSTAT_TUF)) {
    sub ATW_TXSTAT_TUF () {	(1<<26);}
}
unless(defined(&ATW_TXSTAT_TRO)) {
    sub ATW_TXSTAT_TRO () {	(1<<25);}
}
unless(defined(&ATW_TXSTAT_SOFBR)) {
    sub ATW_TXSTAT_SOFBR () {	(1<<24);}
}
unless(defined(&ATW_TXSTAT_ARC_MASK)) {
    sub ATW_TXSTAT_ARC_MASK () {	0xfff;}
}
unless(defined(&ATW_TXFLAG_IC)) {
    sub ATW_TXFLAG_IC () {	(1<<31);}
}
unless(defined(&ATW_TXFLAG_LS)) {
    sub ATW_TXFLAG_LS () {	(1<<30);}
}
unless(defined(&ATW_TXFLAG_FS)) {
    sub ATW_TXFLAG_FS () {	(1<<29);}
}
unless(defined(&ATW_TXFLAG_TER)) {
    sub ATW_TXFLAG_TER () {	(1<<25);}
}
unless(defined(&ATW_TXFLAG_TCH)) {
    sub ATW_TXFLAG_TCH () {	(1<<24);}
}
unless(defined(&ATW_TXFLAG_TBS2_MASK)) {
    sub ATW_TXFLAG_TBS2_MASK () {	0xfff000;}
}
unless(defined(&ATW_TXFLAG_TBS1_MASK)) {
    sub ATW_TXFLAG_TBS1_MASK () {	0xfff;}
}
unless(defined(&ar_rssi)) {
    sub ar_rssi () {	 &ar_ctl;}
}
unless(defined(&ATW_RXCTL_RER)) {
    sub ATW_RXCTL_RER () {	(1<<25);}
}
unless(defined(&ATW_RXCTL_RCH)) {
    sub ATW_RXCTL_RCH () {	(1<<24);}
}
unless(defined(&ATW_RXCTL_RBS2_MASK)) {
    sub ATW_RXCTL_RBS2_MASK () {	0xfff000;}
}
unless(defined(&ATW_RXCTL_RBS1_MASK)) {
    sub ATW_RXCTL_RBS1_MASK () {	0xfff;}
}
unless(defined(&ATW_RXSTAT_OWN)) {
    sub ATW_RXSTAT_OWN () {	(1<<31);}
}
unless(defined(&ATW_RXSTAT_ES)) {
    sub ATW_RXSTAT_ES () {	(1<<30);}
}
unless(defined(&ATW_RXSTAT_SQL)) {
    sub ATW_RXSTAT_SQL () {	(1<<29);}
}
unless(defined(&ATW_RXSTAT_DE)) {
    sub ATW_RXSTAT_DE () {	(1<<28);}
}
unless(defined(&ATW_RXSTAT_FS)) {
    sub ATW_RXSTAT_FS () {	(1<<27);}
}
unless(defined(&ATW_RXSTAT_LS)) {
    sub ATW_RXSTAT_LS () {	(1<<26);}
}
unless(defined(&ATW_RXSTAT_PCF)) {
    sub ATW_RXSTAT_PCF () {	(1<<25);}
}
unless(defined(&ATW_RXSTAT_SFDE)) {
    sub ATW_RXSTAT_SFDE () {	(1<<24);}
}
unless(defined(&ATW_RXSTAT_SIGE)) {
    sub ATW_RXSTAT_SIGE () {	(1<<23);}
}
unless(defined(&ATW_RXSTAT_CRC16E)) {
    sub ATW_RXSTAT_CRC16E () {	(1<<22);}
}
unless(defined(&ATW_RXSTAT_RXTOE)) {
    sub ATW_RXSTAT_RXTOE () {	(1<<21);}
}
unless(defined(&ATW_RXSTAT_CRC32E)) {
    sub ATW_RXSTAT_CRC32E () {	(1<<20);}
}
unless(defined(&ATW_RXSTAT_ICVE)) {
    sub ATW_RXSTAT_ICVE () {	(1<<19);}
}
unless(defined(&ATW_RXSTAT_DA1)) {
    sub ATW_RXSTAT_DA1 () {	(1<<17);}
}
unless(defined(&ATW_RXSTAT_DA0)) {
    sub ATW_RXSTAT_DA0 () {	(1<<16);}
}
unless(defined(&ATW_RXSTAT_RXDR_MASK)) {
    sub ATW_RXSTAT_RXDR_MASK () {	0xf000;}
}
unless(defined(&ATW_RXSTAT_FL_MASK)) {
    sub ATW_RXSTAT_FL_MASK () {	0xfff;}
}
unless(defined(&ATW_SRAM_ADDR_INDIVL_KEY)) {
    sub ATW_SRAM_ADDR_INDIVL_KEY () {	0x;}
}
unless(defined(&ATW_SRAM_ADDR_SHARED_KEY)) {
    sub ATW_SRAM_ADDR_SHARED_KEY () {	(0x160 * 2);}
}
unless(defined(&ATW_SRAM_ADDR_SSID)) {
    sub ATW_SRAM_ADDR_SSID () {	(0x180 * 2);}
}
unless(defined(&ATW_SRAM_ADDR_SUPRATES)) {
    sub ATW_SRAM_ADDR_SUPRATES () {	(0x191 * 2);}
}
unless(defined(&ATW_SRAM_MAXSIZE)) {
    sub ATW_SRAM_MAXSIZE () {	(0x200 * 2);}
}
unless(defined(&ATW_SRAM_A_SIZE)) {
    sub ATW_SRAM_A_SIZE () {	 &ATW_SRAM_MAXSIZE;}
}
unless(defined(&ATW_SRAM_B_SIZE)) {
    sub ATW_SRAM_B_SIZE () {	(0x1c0 * 2);}
}
1;
