require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SK_WIN_BASE)) {
    sub SK_WIN_BASE () {	0x80;}
}
unless(defined(&SK_WIN_LEN)) {
    sub SK_WIN_LEN () {	0x80;}
}
unless(defined(&SK_WIN_MASK)) {
    sub SK_WIN_MASK () {	0x3f80;}
}
unless(defined(&SK_REG_MASK)) {
    sub SK_REG_MASK () {	0x7f;}
}
unless(defined(&SK_WIN)) {
    sub SK_WIN {
	my($reg) = @_;
	eval q(((($reg) &  &SK_WIN_MASK) /  &SK_WIN_LEN));
    }
}
unless(defined(&SK_REG)) {
    sub SK_REG {
	my($reg) = @_;
	eval q((($reg) &  &SK_REG_MASK));
    }
}
unless(defined(&SK_PORT_A)) {
    sub SK_PORT_A () {	0;}
}
unless(defined(&SK_PORT_B)) {
    sub SK_PORT_B () {	1;}
}
unless(defined(&SK_IF_READ_4)) {
    sub SK_IF_READ_4 {
	my($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_4( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_READ_2)) {
    sub SK_IF_READ_2 {
	my($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_2( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_READ_1)) {
    sub SK_IF_READ_1 {
	my($sc_if, $skip, $reg) = @_;
	eval q( &sk_win_read_1( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN)));
    }
}
unless(defined(&SK_IF_WRITE_4)) {
    sub SK_IF_WRITE_4 {
	my($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_4( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_IF_WRITE_2)) {
    sub SK_IF_WRITE_2 {
	my($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_2( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_IF_WRITE_1)) {
    sub SK_IF_WRITE_1 {
	my($sc_if, $skip, $reg, $val) = @_;
	eval q( &sk_win_write_1( ($sc_if->{sk_softc}), $reg + (( ($sc_if->{sk_port}) * ($skip + 1)) *  &SK_WIN_LEN), $val));
    }
}
unless(defined(&SK_RAP)) {
    sub SK_RAP () {	0x;}
}
unless(defined(&SK_CSR)) {
    sub SK_CSR () {	0x4;}
}
unless(defined(&SK_LED)) {
    sub SK_LED () {	0x6;}
}
unless(defined(&SK_ISR)) {
    sub SK_ISR () {	0x8;}
}
unless(defined(&SK_IMR)) {
    sub SK_IMR () {	0xc;}
}
unless(defined(&SK_IESR)) {
    sub SK_IESR () {	0x10;}
}
unless(defined(&SK_IEMR)) {
    sub SK_IEMR () {	0x14;}
}
unless(defined(&SK_ISSR)) {
    sub SK_ISSR () {	0x18;}
}
unless(defined(&SK_Y2_ISSR2)) {
    sub SK_Y2_ISSR2 () {	0x1c;}
}
unless(defined(&SK_Y2_ISSR3)) {
    sub SK_Y2_ISSR3 () {	0x20;}
}
unless(defined(&SK_Y2_EISR)) {
    sub SK_Y2_EISR () {	0x24;}
}
unless(defined(&SK_Y2_LISR)) {
    sub SK_Y2_LISR () {	0x28;}
}
unless(defined(&SK_Y2_ICR)) {
    sub SK_Y2_ICR () {	0x2c;}
}
unless(defined(&SK_XM_IMR0)) {
    sub SK_XM_IMR0 () {	0x20;}
}
unless(defined(&SK_XM_ISR0)) {
    sub SK_XM_ISR0 () {	0x28;}
}
unless(defined(&SK_XM_PHYADDR0)) {
    sub SK_XM_PHYADDR0 () {	0x30;}
}
unless(defined(&SK_XM_PHYDATA0)) {
    sub SK_XM_PHYDATA0 () {	0x34;}
}
unless(defined(&SK_XM_IMR1)) {
    sub SK_XM_IMR1 () {	0x40;}
}
unless(defined(&SK_XM_ISR1)) {
    sub SK_XM_ISR1 () {	0x48;}
}
unless(defined(&SK_XM_PHYADDR1)) {
    sub SK_XM_PHYADDR1 () {	0x50;}
}
unless(defined(&SK_XM_PHYDATA1)) {
    sub SK_XM_PHYDATA1 () {	0x54;}
}
unless(defined(&SK_BMU_RX_CSR0)) {
    sub SK_BMU_RX_CSR0 () {	0x60;}
}
unless(defined(&SK_BMU_RX_CSR1)) {
    sub SK_BMU_RX_CSR1 () {	0x64;}
}
unless(defined(&SK_BMU_TXS_CSR0)) {
    sub SK_BMU_TXS_CSR0 () {	0x68;}
}
unless(defined(&SK_BMU_TXA_CSR0)) {
    sub SK_BMU_TXA_CSR0 () {	0x6c;}
}
unless(defined(&SK_BMU_TXS_CSR1)) {
    sub SK_BMU_TXS_CSR1 () {	0x70;}
}
unless(defined(&SK_BMU_TXA_CSR1)) {
    sub SK_BMU_TXA_CSR1 () {	0x74;}
}
unless(defined(&SK_CSR_SW_RESET)) {
    sub SK_CSR_SW_RESET () {	0x1;}
}
unless(defined(&SK_CSR_SW_UNRESET)) {
    sub SK_CSR_SW_UNRESET () {	0x2;}
}
unless(defined(&SK_CSR_MASTER_RESET)) {
    sub SK_CSR_MASTER_RESET () {	0x4;}
}
unless(defined(&SK_CSR_MASTER_UNRESET)) {
    sub SK_CSR_MASTER_UNRESET () {	0x8;}
}
unless(defined(&SK_CSR_MASTER_STOP)) {
    sub SK_CSR_MASTER_STOP () {	0x10;}
}
unless(defined(&SK_CSR_MASTER_DONE)) {
    sub SK_CSR_MASTER_DONE () {	0x20;}
}
unless(defined(&SK_CSR_SW_IRQ_CLEAR)) {
    sub SK_CSR_SW_IRQ_CLEAR () {	0x40;}
}
unless(defined(&SK_CSR_SW_IRQ_SET)) {
    sub SK_CSR_SW_IRQ_SET () {	0x80;}
}
unless(defined(&SK_CSR_SLOTSIZE)) {
    sub SK_CSR_SLOTSIZE () {	0x100;}
}
unless(defined(&SK_CSR_BUSCLOCK)) {
    sub SK_CSR_BUSCLOCK () {	0x200;}
}
unless(defined(&SK_CSR_ASF_OFF)) {
    sub SK_CSR_ASF_OFF () {	0x1000;}
}
unless(defined(&SK_CSR_ASF_ON)) {
    sub SK_CSR_ASF_ON () {	0x2000;}
}
unless(defined(&SK_LED_GREEN_OFF)) {
    sub SK_LED_GREEN_OFF () {	0x1;}
}
unless(defined(&SK_LED_GREEN_ON)) {
    sub SK_LED_GREEN_ON () {	0x2;}
}
unless(defined(&SK_ISR_TX2_AS_CHECK)) {
    sub SK_ISR_TX2_AS_CHECK () {	0x1;}
}
unless(defined(&SK_ISR_TX2_AS_EOF)) {
    sub SK_ISR_TX2_AS_EOF () {	0x2;}
}
unless(defined(&SK_ISR_TX2_AS_EOB)) {
    sub SK_ISR_TX2_AS_EOB () {	0x4;}
}
unless(defined(&SK_ISR_TX2_S_CHECK)) {
    sub SK_ISR_TX2_S_CHECK () {	0x8;}
}
unless(defined(&SK_ISR_TX2_S_EOF)) {
    sub SK_ISR_TX2_S_EOF () {	0x10;}
}
unless(defined(&SK_ISR_TX2_S_EOB)) {
    sub SK_ISR_TX2_S_EOB () {	0x20;}
}
unless(defined(&SK_ISR_TX1_AS_CHECK)) {
    sub SK_ISR_TX1_AS_CHECK () {	0x40;}
}
unless(defined(&SK_ISR_TX1_AS_EOF)) {
    sub SK_ISR_TX1_AS_EOF () {	0x80;}
}
unless(defined(&SK_ISR_TX1_AS_EOB)) {
    sub SK_ISR_TX1_AS_EOB () {	0x100;}
}
unless(defined(&SK_ISR_TX1_S_CHECK)) {
    sub SK_ISR_TX1_S_CHECK () {	0x200;}
}
unless(defined(&SK_ISR_TX1_S_EOF)) {
    sub SK_ISR_TX1_S_EOF () {	0x400;}
}
unless(defined(&SK_ISR_TX1_S_EOB)) {
    sub SK_ISR_TX1_S_EOB () {	0x800;}
}
unless(defined(&SK_ISR_RX2_CHECK)) {
    sub SK_ISR_RX2_CHECK () {	0x1000;}
}
unless(defined(&SK_ISR_RX2_EOF)) {
    sub SK_ISR_RX2_EOF () {	0x2000;}
}
unless(defined(&SK_ISR_RX2_EOB)) {
    sub SK_ISR_RX2_EOB () {	0x4000;}
}
unless(defined(&SK_ISR_RX1_CHECK)) {
    sub SK_ISR_RX1_CHECK () {	0x8000;}
}
unless(defined(&SK_ISR_RX1_EOF)) {
    sub SK_ISR_RX1_EOF () {	0x10000;}
}
unless(defined(&SK_ISR_RX1_EOB)) {
    sub SK_ISR_RX1_EOB () {	0x20000;}
}
unless(defined(&SK_ISR_LINK2_OFLOW)) {
    sub SK_ISR_LINK2_OFLOW () {	0x40000;}
}
unless(defined(&SK_ISR_MAC2)) {
    sub SK_ISR_MAC2 () {	0x80000;}
}
unless(defined(&SK_ISR_LINK1_OFLOW)) {
    sub SK_ISR_LINK1_OFLOW () {	0x100000;}
}
unless(defined(&SK_ISR_MAC1)) {
    sub SK_ISR_MAC1 () {	0x200000;}
}
unless(defined(&SK_ISR_TIMER)) {
    sub SK_ISR_TIMER () {	0x400000;}
}
unless(defined(&SK_ISR_EXTERNAL_REG)) {
    sub SK_ISR_EXTERNAL_REG () {	0x800000;}
}
unless(defined(&SK_ISR_SW)) {
    sub SK_ISR_SW () {	0x1000000;}
}
unless(defined(&SK_ISR_I2C_RDY)) {
    sub SK_ISR_I2C_RDY () {	0x2000000;}
}
unless(defined(&SK_ISR_TX2_TIMEO)) {
    sub SK_ISR_TX2_TIMEO () {	0x4000000;}
}
unless(defined(&SK_ISR_TX1_TIMEO)) {
    sub SK_ISR_TX1_TIMEO () {	0x8000000;}
}
unless(defined(&SK_ISR_RX2_TIMEO)) {
    sub SK_ISR_RX2_TIMEO () {	0x10000000;}
}
unless(defined(&SK_ISR_RX1_TIMEO)) {
    sub SK_ISR_RX1_TIMEO () {	0x20000000;}
}
unless(defined(&SK_ISR_RSVD)) {
    sub SK_ISR_RSVD () {	0x40000000;}
}
unless(defined(&SK_ISR_HWERR)) {
    sub SK_ISR_HWERR () {	0x80000000;}
}
unless(defined(&SK_IMR_TX2_AS_CHECK)) {
    sub SK_IMR_TX2_AS_CHECK () {	0x1;}
}
unless(defined(&SK_IMR_TX2_AS_EOF)) {
    sub SK_IMR_TX2_AS_EOF () {	0x2;}
}
unless(defined(&SK_IMR_TX2_AS_EOB)) {
    sub SK_IMR_TX2_AS_EOB () {	0x4;}
}
unless(defined(&SK_IMR_TX2_S_CHECK)) {
    sub SK_IMR_TX2_S_CHECK () {	0x8;}
}
unless(defined(&SK_IMR_TX2_S_EOF)) {
    sub SK_IMR_TX2_S_EOF () {	0x10;}
}
unless(defined(&SK_IMR_TX2_S_EOB)) {
    sub SK_IMR_TX2_S_EOB () {	0x20;}
}
unless(defined(&SK_IMR_TX1_AS_CHECK)) {
    sub SK_IMR_TX1_AS_CHECK () {	0x40;}
}
unless(defined(&SK_IMR_TX1_AS_EOF)) {
    sub SK_IMR_TX1_AS_EOF () {	0x80;}
}
unless(defined(&SK_IMR_TX1_AS_EOB)) {
    sub SK_IMR_TX1_AS_EOB () {	0x100;}
}
unless(defined(&SK_IMR_TX1_S_CHECK)) {
    sub SK_IMR_TX1_S_CHECK () {	0x200;}
}
unless(defined(&SK_IMR_TX1_S_EOF)) {
    sub SK_IMR_TX1_S_EOF () {	0x400;}
}
unless(defined(&SK_IMR_TX1_S_EOB)) {
    sub SK_IMR_TX1_S_EOB () {	0x800;}
}
unless(defined(&SK_IMR_RX2_CHECK)) {
    sub SK_IMR_RX2_CHECK () {	0x1000;}
}
unless(defined(&SK_IMR_RX2_EOF)) {
    sub SK_IMR_RX2_EOF () {	0x2000;}
}
unless(defined(&SK_IMR_RX2_EOB)) {
    sub SK_IMR_RX2_EOB () {	0x4000;}
}
unless(defined(&SK_IMR_RX1_CHECK)) {
    sub SK_IMR_RX1_CHECK () {	0x8000;}
}
unless(defined(&SK_IMR_RX1_EOF)) {
    sub SK_IMR_RX1_EOF () {	0x10000;}
}
unless(defined(&SK_IMR_RX1_EOB)) {
    sub SK_IMR_RX1_EOB () {	0x20000;}
}
unless(defined(&SK_IMR_LINK2_OFLOW)) {
    sub SK_IMR_LINK2_OFLOW () {	0x40000;}
}
unless(defined(&SK_IMR_MAC2)) {
    sub SK_IMR_MAC2 () {	0x80000;}
}
unless(defined(&SK_IMR_LINK1_OFLOW)) {
    sub SK_IMR_LINK1_OFLOW () {	0x100000;}
}
unless(defined(&SK_IMR_MAC1)) {
    sub SK_IMR_MAC1 () {	0x200000;}
}
unless(defined(&SK_IMR_TIMER)) {
    sub SK_IMR_TIMER () {	0x400000;}
}
unless(defined(&SK_IMR_EXTERNAL_REG)) {
    sub SK_IMR_EXTERNAL_REG () {	0x800000;}
}
unless(defined(&SK_IMR_SW)) {
    sub SK_IMR_SW () {	0x1000000;}
}
unless(defined(&SK_IMR_I2C_RDY)) {
    sub SK_IMR_I2C_RDY () {	0x2000000;}
}
unless(defined(&SK_IMR_TX2_TIMEO)) {
    sub SK_IMR_TX2_TIMEO () {	0x4000000;}
}
unless(defined(&SK_IMR_TX1_TIMEO)) {
    sub SK_IMR_TX1_TIMEO () {	0x8000000;}
}
unless(defined(&SK_IMR_RX2_TIMEO)) {
    sub SK_IMR_RX2_TIMEO () {	0x10000000;}
}
unless(defined(&SK_IMR_RX1_TIMEO)) {
    sub SK_IMR_RX1_TIMEO () {	0x20000000;}
}
unless(defined(&SK_IMR_RSVD)) {
    sub SK_IMR_RSVD () {	0x40000000;}
}
unless(defined(&SK_IMR_HWERR)) {
    sub SK_IMR_HWERR () {	0x80000000;}
}
unless(defined(&SK_INTRS1)) {
    sub SK_INTRS1 () {	( &SK_IMR_RX1_EOF| &SK_IMR_TX1_S_EOF| &SK_IMR_MAC1);}
}
unless(defined(&SK_INTRS2)) {
    sub SK_INTRS2 () {	( &SK_IMR_RX2_EOF| &SK_IMR_TX2_S_EOF| &SK_IMR_MAC2);}
}
unless(defined(&SK_Y2_IMR_TX1_AS_CHECK)) {
    sub SK_Y2_IMR_TX1_AS_CHECK () {	0x1;}
}
unless(defined(&SK_Y2_IMR_TX1_S_CHECK)) {
    sub SK_Y2_IMR_TX1_S_CHECK () {	0x2;}
}
unless(defined(&SK_Y2_IMR_RX1_CHECK)) {
    sub SK_Y2_IMR_RX1_CHECK () {	0x4;}
}
unless(defined(&SK_Y2_IMR_MAC1)) {
    sub SK_Y2_IMR_MAC1 () {	0x8;}
}
unless(defined(&SK_Y2_IMR_PHY1)) {
    sub SK_Y2_IMR_PHY1 () {	0x10;}
}
unless(defined(&SK_Y2_IMR_TX2_AS_CHECK)) {
    sub SK_Y2_IMR_TX2_AS_CHECK () {	0x100;}
}
unless(defined(&SK_Y2_IMR_TX2_S_CHECK)) {
    sub SK_Y2_IMR_TX2_S_CHECK () {	0x200;}
}
unless(defined(&SK_Y2_IMR_RX2_CHECK)) {
    sub SK_Y2_IMR_RX2_CHECK () {	0x400;}
}
unless(defined(&SK_Y2_IMR_MAC2)) {
    sub SK_Y2_IMR_MAC2 () {	0x800;}
}
unless(defined(&SK_Y2_IMR_PHY2)) {
    sub SK_Y2_IMR_PHY2 () {	0x1000;}
}
unless(defined(&SK_Y2_IMR_TIMER)) {
    sub SK_Y2_IMR_TIMER () {	0x1000000;}
}
unless(defined(&SK_Y2_IMR_SW)) {
    sub SK_Y2_IMR_SW () {	0x2000000;}
}
unless(defined(&SK_Y2_IMR_ASF)) {
    sub SK_Y2_IMR_ASF () {	0x20000000;}
}
unless(defined(&SK_Y2_IMR_BMU)) {
    sub SK_Y2_IMR_BMU () {	0x40000000;}
}
unless(defined(&SK_Y2_IMR_HWERR)) {
    sub SK_Y2_IMR_HWERR () {	0x80000000;}
}
unless(defined(&SK_Y2_INTRS1)) {
    sub SK_Y2_INTRS1 () {	( &SK_Y2_IMR_RX1_CHECK| &SK_Y2_IMR_TX1_AS_CHECK | &SK_Y2_IMR_MAC1| &SK_Y2_IMR_PHY1);}
}
unless(defined(&SK_Y2_INTRS2)) {
    sub SK_Y2_INTRS2 () {	( &SK_Y2_IMR_RX2_CHECK| &SK_Y2_IMR_TX2_AS_CHECK | &SK_Y2_IMR_MAC2| &SK_Y2_IMR_PHY2);}
}
unless(defined(&SK_IESR_PAR_RX2)) {
    sub SK_IESR_PAR_RX2 () {	0x1;}
}
unless(defined(&SK_IESR_PAR_RX1)) {
    sub SK_IESR_PAR_RX1 () {	0x2;}
}
unless(defined(&SK_IESR_PAR_MAC2)) {
    sub SK_IESR_PAR_MAC2 () {	0x4;}
}
unless(defined(&SK_IESR_PAR_MAC1)) {
    sub SK_IESR_PAR_MAC1 () {	0x8;}
}
unless(defined(&SK_IESR_PAR_WR_RAM)) {
    sub SK_IESR_PAR_WR_RAM () {	0x10;}
}
unless(defined(&SK_IESR_PAR_RD_RAM)) {
    sub SK_IESR_PAR_RD_RAM () {	0x20;}
}
unless(defined(&SK_IESR_NO_TSTAMP_MAC2)) {
    sub SK_IESR_NO_TSTAMP_MAC2 () {	0x40;}
}
unless(defined(&SK_IESR_NO_TSTAMO_MAC1)) {
    sub SK_IESR_NO_TSTAMO_MAC1 () {	0x80;}
}
unless(defined(&SK_IESR_NO_STS_MAC2)) {
    sub SK_IESR_NO_STS_MAC2 () {	0x100;}
}
unless(defined(&SK_IESR_NO_STS_MAC1)) {
    sub SK_IESR_NO_STS_MAC1 () {	0x200;}
}
unless(defined(&SK_IESR_IRQ_STS)) {
    sub SK_IESR_IRQ_STS () {	0x400;}
}
unless(defined(&SK_IESR_MASTERERR)) {
    sub SK_IESR_MASTERERR () {	0x800;}
}
unless(defined(&SK_IEMR_PAR_RX2)) {
    sub SK_IEMR_PAR_RX2 () {	0x1;}
}
unless(defined(&SK_IEMR_PAR_RX1)) {
    sub SK_IEMR_PAR_RX1 () {	0x2;}
}
unless(defined(&SK_IEMR_PAR_MAC2)) {
    sub SK_IEMR_PAR_MAC2 () {	0x4;}
}
unless(defined(&SK_IEMR_PAR_MAC1)) {
    sub SK_IEMR_PAR_MAC1 () {	0x8;}
}
unless(defined(&SK_IEMR_PAR_WR_RAM)) {
    sub SK_IEMR_PAR_WR_RAM () {	0x10;}
}
unless(defined(&SK_IEMR_PAR_RD_RAM)) {
    sub SK_IEMR_PAR_RD_RAM () {	0x20;}
}
unless(defined(&SK_IEMR_NO_TSTAMP_MAC2)) {
    sub SK_IEMR_NO_TSTAMP_MAC2 () {	0x40;}
}
unless(defined(&SK_IEMR_NO_TSTAMO_MAC1)) {
    sub SK_IEMR_NO_TSTAMO_MAC1 () {	0x80;}
}
unless(defined(&SK_IEMR_NO_STS_MAC2)) {
    sub SK_IEMR_NO_STS_MAC2 () {	0x100;}
}
unless(defined(&SK_IEMR_NO_STS_MAC1)) {
    sub SK_IEMR_NO_STS_MAC1 () {	0x200;}
}
unless(defined(&SK_IEMR_IRQ_STS)) {
    sub SK_IEMR_IRQ_STS () {	0x400;}
}
unless(defined(&SK_IEMR_MASTERERR)) {
    sub SK_IEMR_MASTERERR () {	0x800;}
}
unless(defined(&SK_MAC0_0)) {
    sub SK_MAC0_0 () {	0x100;}
}
unless(defined(&SK_MAC0_1)) {
    sub SK_MAC0_1 () {	0x104;}
}
unless(defined(&SK_MAC1_0)) {
    sub SK_MAC1_0 () {	0x108;}
}
unless(defined(&SK_MAC1_1)) {
    sub SK_MAC1_1 () {	0x10c;}
}
unless(defined(&SK_MAC2_0)) {
    sub SK_MAC2_0 () {	0x110;}
}
unless(defined(&SK_MAC2_1)) {
    sub SK_MAC2_1 () {	0x114;}
}
unless(defined(&SK_CONNTYPE)) {
    sub SK_CONNTYPE () {	0x118;}
}
unless(defined(&SK_PMDTYPE)) {
    sub SK_PMDTYPE () {	0x119;}
}
unless(defined(&SK_CONFIG)) {
    sub SK_CONFIG () {	0x11a;}
}
unless(defined(&SK_CHIPVER)) {
    sub SK_CHIPVER () {	0x11b;}
}
unless(defined(&SK_EPROM0)) {
    sub SK_EPROM0 () {	0x11c;}
}
unless(defined(&SK_EPROM1)) {
    sub SK_EPROM1 () {	0x11d;}
}
unless(defined(&SK_Y2_CLKGATE)) {
    sub SK_Y2_CLKGATE () {	0x11d;}
}
unless(defined(&SK_EPROM2)) {
    sub SK_EPROM2 () {	0x11e;}
}
unless(defined(&SK_Y2_HWRES)) {
    sub SK_Y2_HWRES () {	0x11e;}
}
unless(defined(&SK_EPROM3)) {
    sub SK_EPROM3 () {	0x11f;}
}
unless(defined(&SK_EP_ADDR)) {
    sub SK_EP_ADDR () {	0x120;}
}
unless(defined(&SK_EP_DATA)) {
    sub SK_EP_DATA () {	0x124;}
}
unless(defined(&SK_EP_LOADCTL)) {
    sub SK_EP_LOADCTL () {	0x128;}
}
unless(defined(&SK_EP_LOADTST)) {
    sub SK_EP_LOADTST () {	0x129;}
}
unless(defined(&SK_TIMERINIT)) {
    sub SK_TIMERINIT () {	0x130;}
}
unless(defined(&SK_TIMER)) {
    sub SK_TIMER () {	0x134;}
}
unless(defined(&SK_TIMERCTL)) {
    sub SK_TIMERCTL () {	0x138;}
}
unless(defined(&SK_TIMERTST)) {
    sub SK_TIMERTST () {	0x139;}
}
unless(defined(&SK_IMTIMERINIT)) {
    sub SK_IMTIMERINIT () {	0x140;}
}
unless(defined(&SK_IMTIMER)) {
    sub SK_IMTIMER () {	0x144;}
}
unless(defined(&SK_IMTIMERCTL)) {
    sub SK_IMTIMERCTL () {	0x148;}
}
unless(defined(&SK_IMTIMERTST)) {
    sub SK_IMTIMERTST () {	0x149;}
}
unless(defined(&SK_IMMR)) {
    sub SK_IMMR () {	0x14c;}
}
unless(defined(&SK_IHWEMR)) {
    sub SK_IHWEMR () {	0x150;}
}
unless(defined(&SK_TESTCTL1)) {
    sub SK_TESTCTL1 () {	0x158;}
}
unless(defined(&SK_TESTCTL2)) {
    sub SK_TESTCTL2 () {	0x159;}
}
unless(defined(&SK_GPIO)) {
    sub SK_GPIO () {	0x15c;}
}
unless(defined(&SK_I2CHWCTL)) {
    sub SK_I2CHWCTL () {	0x160;}
}
unless(defined(&SK_I2CHWDATA)) {
    sub SK_I2CHWDATA () {	0x164;}
}
unless(defined(&SK_I2CHWIRQ)) {
    sub SK_I2CHWIRQ () {	0x168;}
}
unless(defined(&SK_I2CSW)) {
    sub SK_I2CSW () {	0x16c;}
}
unless(defined(&SK_BLNKINIT)) {
    sub SK_BLNKINIT () {	0x170;}
}
unless(defined(&SK_BLNKCOUNT)) {
    sub SK_BLNKCOUNT () {	0x174;}
}
unless(defined(&SK_BLNKCTL)) {
    sub SK_BLNKCTL () {	0x178;}
}
unless(defined(&SK_BLNKSTS)) {
    sub SK_BLNKSTS () {	0x179;}
}
unless(defined(&SK_BLNKTST)) {
    sub SK_BLNKTST () {	0x17a;}
}
unless(defined(&SK_GENESIS)) {
    sub SK_GENESIS () {	0xa;}
}
unless(defined(&SK_YUKON)) {
    sub SK_YUKON () {	0xb0;}
}
unless(defined(&SK_YUKON_LITE)) {
    sub SK_YUKON_LITE () {	0xb1;}
}
unless(defined(&SK_YUKON_LP)) {
    sub SK_YUKON_LP () {	0xb2;}
}
unless(defined(&SK_YUKON_XL)) {
    sub SK_YUKON_XL () {	0xb3;}
}
unless(defined(&SK_YUKON_EC_U)) {
    sub SK_YUKON_EC_U () {	0xb4;}
}
unless(defined(&SK_YUKON_EX)) {
    sub SK_YUKON_EX () {	0xb5;}
}
unless(defined(&SK_YUKON_EC)) {
    sub SK_YUKON_EC () {	0xb6;}
}
unless(defined(&SK_YUKON_FE)) {
    sub SK_YUKON_FE () {	0xb7;}
}
unless(defined(&SK_YUKON_FE_P)) {
    sub SK_YUKON_FE_P () {	0xb8;}
}
unless(defined(&SK_YUKON_SUPR)) {
    sub SK_YUKON_SUPR () {	0xb9;}
}
unless(defined(&SK_YUKON_ULTRA2)) {
    sub SK_YUKON_ULTRA2 () {	0xba;}
}
unless(defined(&SK_YUKON_OPTIMA)) {
    sub SK_YUKON_OPTIMA () {	0xbc;}
}
unless(defined(&SK_IS_GENESIS)) {
    sub SK_IS_GENESIS {
	my($sc) = @_;
	eval q((($sc)-> &sk_type ==  &SK_GENESIS));
    }
}
unless(defined(&SK_IS_YUKON)) {
    sub SK_IS_YUKON {
	my($sc) = @_;
	eval q((($sc)-> &sk_type >=  &SK_YUKON  && ($sc)-> &sk_type <=  &SK_YUKON_LP));
    }
}
unless(defined(&SK_IS_YUKON2)) {
    sub SK_IS_YUKON2 {
	my($sc) = @_;
	eval q((($sc)-> &sk_type >=  &SK_YUKON_XL  && ($sc)-> &sk_type <=  &SK_YUKON_OPTIMA));
    }
}
unless(defined(&SK_YUKON_LITE_REV_A0)) {
    sub SK_YUKON_LITE_REV_A0 () {	0x;}
}
unless(defined(&SK_YUKON_LITE_REV_A1)) {
    sub SK_YUKON_LITE_REV_A1 () {	0x3;}
}
unless(defined(&SK_YUKON_LITE_REV_A3)) {
    sub SK_YUKON_LITE_REV_A3 () {	0x7;}
}
unless(defined(&SK_YUKON_XL_REV_A0)) {
    sub SK_YUKON_XL_REV_A0 () {	0x;}
}
unless(defined(&SK_YUKON_XL_REV_A1)) {
    sub SK_YUKON_XL_REV_A1 () {	0x1;}
}
unless(defined(&SK_YUKON_XL_REV_A2)) {
    sub SK_YUKON_XL_REV_A2 () {	0x2;}
}
unless(defined(&SK_YUKON_XL_REV_A3)) {
    sub SK_YUKON_XL_REV_A3 () {	0x3;}
}
unless(defined(&SK_YUKON_EC_REV_A1)) {
    sub SK_YUKON_EC_REV_A1 () {	0x;}
}
unless(defined(&SK_YUKON_EC_REV_A2)) {
    sub SK_YUKON_EC_REV_A2 () {	0x1;}
}
unless(defined(&SK_YUKON_EC_REV_A3)) {
    sub SK_YUKON_EC_REV_A3 () {	0x2;}
}
unless(defined(&SK_YUKON_EC_U_REV_A0)) {
    sub SK_YUKON_EC_U_REV_A0 () {	0x1;}
}
unless(defined(&SK_YUKON_EC_U_REV_A1)) {
    sub SK_YUKON_EC_U_REV_A1 () {	0x2;}
}
unless(defined(&SK_YUKON_EC_U_REV_B0)) {
    sub SK_YUKON_EC_U_REV_B0 () {	0x3;}
}
unless(defined(&SK_YUKON_FE_REV_A1)) {
    sub SK_YUKON_FE_REV_A1 () {	0x1;}
}
unless(defined(&SK_YUKON_FE_REV_A2)) {
    sub SK_YUKON_FE_REV_A2 () {	0x2;}
}
unless(defined(&SK_YUKON_FE_P_REV_A0)) {
    sub SK_YUKON_FE_P_REV_A0 () {	0x;}
}
unless(defined(&SK_YUKON_EX_REV_A0)) {
    sub SK_YUKON_EX_REV_A0 () {	0x1;}
}
unless(defined(&SK_YUKON_EX_REV_B0)) {
    sub SK_YUKON_EX_REV_B0 () {	0x2;}
}
unless(defined(&SK_YUKON_SUPR_REV_A0)) {
    sub SK_YUKON_SUPR_REV_A0 () {	0x;}
}
unless(defined(&SK_IMCTL_IRQ_CLEAR)) {
    sub SK_IMCTL_IRQ_CLEAR () {	0x1;}
}
unless(defined(&SK_IMCTL_STOP)) {
    sub SK_IMCTL_STOP () {	0x2;}
}
unless(defined(&SK_IMCTL_START)) {
    sub SK_IMCTL_START () {	0x4;}
}
unless(defined(&SK_IMTIMER_TICKS_GENESIS)) {
    sub SK_IMTIMER_TICKS_GENESIS () {	53;}
}
unless(defined(&SK_IMTIMER_TICKS_YUKON)) {
    sub SK_IMTIMER_TICKS_YUKON () {	78;}
}
unless(defined(&SK_IMTIMER_TICKS_YUKON_EC)) {
    sub SK_IMTIMER_TICKS_YUKON_EC () {	125;}
}
unless(defined(&SK_IM_USECS)) {
    sub SK_IM_USECS {
	my($x) = @_;
	eval q((($x) *  &imtimer_ticks));
    }
}
unless(defined(&SK_RAMSIZE_512K_64)) {
    sub SK_RAMSIZE_512K_64 () {	0x1;}
}
unless(defined(&SK_RAMSIZE_1024K_128)) {
    sub SK_RAMSIZE_1024K_128 () {	0x2;}
}
unless(defined(&SK_RAMSIZE_1024K_64)) {
    sub SK_RAMSIZE_1024K_64 () {	0x3;}
}
unless(defined(&SK_RAMSIZE_2048K_128)) {
    sub SK_RAMSIZE_2048K_128 () {	0x4;}
}
unless(defined(&SK_RBOFF_0)) {
    sub SK_RBOFF_0 () {	0x;}
}
unless(defined(&SK_RBOFF_80000)) {
    sub SK_RBOFF_80000 () {	0x80000;}
}
unless(defined(&SK_PHYTYPE_XMAC)) {
    sub SK_PHYTYPE_XMAC () {	0;}
}
unless(defined(&SK_PHYTYPE_BCOM)) {
    sub SK_PHYTYPE_BCOM () {	1;}
}
unless(defined(&SK_PHYTYPE_LONE)) {
    sub SK_PHYTYPE_LONE () {	2;}
}
unless(defined(&SK_PHYTYPE_NAT)) {
    sub SK_PHYTYPE_NAT () {	3;}
}
unless(defined(&SK_PHYTYPE_MARV_COPPER)) {
    sub SK_PHYTYPE_MARV_COPPER () {	4;}
}
unless(defined(&SK_PHYTYPE_MARV_FIBER)) {
    sub SK_PHYTYPE_MARV_FIBER () {	5;}
}
unless(defined(&SK_PHYADDR_XMAC)) {
    sub SK_PHYADDR_XMAC () {	0x;}
}
unless(defined(&SK_PHYADDR_BCOM)) {
    sub SK_PHYADDR_BCOM () {	0x1;}
}
unless(defined(&SK_PHYADDR_LONE)) {
    sub SK_PHYADDR_LONE () {	0x3;}
}
unless(defined(&SK_PHYADDR_NAT)) {
    sub SK_PHYADDR_NAT () {	0x;}
}
unless(defined(&SK_PHYADDR_MARV)) {
    sub SK_PHYADDR_MARV () {	0x;}
}
unless(defined(&SK_CONFIG_SINGLEMAC)) {
    sub SK_CONFIG_SINGLEMAC () {	0x1;}
}
unless(defined(&SK_CONFIG_DIS_DSL_CLK)) {
    sub SK_CONFIG_DIS_DSL_CLK () {	0x2;}
}
unless(defined(&SK_PMD_1000BASETX_ALT)) {
    sub SK_PMD_1000BASETX_ALT () {	0x31;}
}
unless(defined(&SK_PMD_1000BASECX)) {
    sub SK_PMD_1000BASECX () {	0x43;}
}
unless(defined(&SK_PMD_1000BASELX)) {
    sub SK_PMD_1000BASELX () {	0x4c;}
}
unless(defined(&SK_PMD_1000BASESX)) {
    sub SK_PMD_1000BASESX () {	0x53;}
}
unless(defined(&SK_PMD_1000BASETX)) {
    sub SK_PMD_1000BASETX () {	0x54;}
}
unless(defined(&SK_GPIO_DAT0)) {
    sub SK_GPIO_DAT0 () {	0x1;}
}
unless(defined(&SK_GPIO_DAT1)) {
    sub SK_GPIO_DAT1 () {	0x2;}
}
unless(defined(&SK_GPIO_DAT2)) {
    sub SK_GPIO_DAT2 () {	0x4;}
}
unless(defined(&SK_GPIO_DAT3)) {
    sub SK_GPIO_DAT3 () {	0x8;}
}
unless(defined(&SK_GPIO_DAT4)) {
    sub SK_GPIO_DAT4 () {	0x10;}
}
unless(defined(&SK_GPIO_DAT5)) {
    sub SK_GPIO_DAT5 () {	0x20;}
}
unless(defined(&SK_GPIO_DAT6)) {
    sub SK_GPIO_DAT6 () {	0x40;}
}
unless(defined(&SK_GPIO_DAT7)) {
    sub SK_GPIO_DAT7 () {	0x80;}
}
unless(defined(&SK_GPIO_DAT8)) {
    sub SK_GPIO_DAT8 () {	0x100;}
}
unless(defined(&SK_GPIO_DAT9)) {
    sub SK_GPIO_DAT9 () {	0x200;}
}
unless(defined(&SK_Y2_GPIO_STAT_RACE_DIS)) {
    sub SK_Y2_GPIO_STAT_RACE_DIS () {	0x2000;}
}
unless(defined(&SK_GPIO_DIR0)) {
    sub SK_GPIO_DIR0 () {	0x10000;}
}
unless(defined(&SK_GPIO_DIR1)) {
    sub SK_GPIO_DIR1 () {	0x20000;}
}
unless(defined(&SK_GPIO_DIR2)) {
    sub SK_GPIO_DIR2 () {	0x40000;}
}
unless(defined(&SK_GPIO_DIR3)) {
    sub SK_GPIO_DIR3 () {	0x80000;}
}
unless(defined(&SK_GPIO_DIR4)) {
    sub SK_GPIO_DIR4 () {	0x100000;}
}
unless(defined(&SK_GPIO_DIR5)) {
    sub SK_GPIO_DIR5 () {	0x200000;}
}
unless(defined(&SK_GPIO_DIR6)) {
    sub SK_GPIO_DIR6 () {	0x400000;}
}
unless(defined(&SK_GPIO_DIR7)) {
    sub SK_GPIO_DIR7 () {	0x800000;}
}
unless(defined(&SK_GPIO_DIR8)) {
    sub SK_GPIO_DIR8 () {	0x1000000;}
}
unless(defined(&SK_GPIO_DIR9)) {
    sub SK_GPIO_DIR9 () {	0x2000000;}
}
unless(defined(&SK_Y2_CLKGATE_LINK2_INACTIVE)) {
    sub SK_Y2_CLKGATE_LINK2_INACTIVE () {	0x80;}
}
unless(defined(&SK_Y2_CLKGATE_LINK2_GATE_DIS)) {
    sub SK_Y2_CLKGATE_LINK2_GATE_DIS () {	0x40;}
}
unless(defined(&SK_Y2_CLKGATE_LINK2_CORE_DIS)) {
    sub SK_Y2_CLKGATE_LINK2_CORE_DIS () {	0x20;}
}
unless(defined(&SK_Y2_CLKGATE_LINK2_PCI_DIS)) {
    sub SK_Y2_CLKGATE_LINK2_PCI_DIS () {	0x10;}
}
unless(defined(&SK_Y2_CLKGATE_LINK1_INACTIVE)) {
    sub SK_Y2_CLKGATE_LINK1_INACTIVE () {	0x8;}
}
unless(defined(&SK_Y2_CLKGATE_LINK1_GATE_DIS)) {
    sub SK_Y2_CLKGATE_LINK1_GATE_DIS () {	0x4;}
}
unless(defined(&SK_Y2_CLKGATE_LINK1_CORE_DIS)) {
    sub SK_Y2_CLKGATE_LINK1_CORE_DIS () {	0x2;}
}
unless(defined(&SK_Y2_CLKGATE_LINK1_PCI_DIS)) {
    sub SK_Y2_CLKGATE_LINK1_PCI_DIS () {	0x1;}
}
unless(defined(&SK_Y2_HWRES_LINK_1)) {
    sub SK_Y2_HWRES_LINK_1 () {	0x1;}
}
unless(defined(&SK_Y2_HWRES_LINK_2)) {
    sub SK_Y2_HWRES_LINK_2 () {	0x2;}
}
unless(defined(&SK_Y2_HWRES_LINK_MASK)) {
    sub SK_Y2_HWRES_LINK_MASK () {	( &SK_Y2_HWRES_LINK_1 |  &SK_Y2_HWRES_LINK_2);}
}
unless(defined(&SK_Y2_HWRES_LINK_DUAL)) {
    sub SK_Y2_HWRES_LINK_DUAL () {	( &SK_Y2_HWRES_LINK_1 |  &SK_Y2_HWRES_LINK_2);}
}
unless(defined(&SK_RAMADDR)) {
    sub SK_RAMADDR () {	0x180;}
}
unless(defined(&SK_RAMDATA0)) {
    sub SK_RAMDATA0 () {	0x184;}
}
unless(defined(&SK_RAMDATA1)) {
    sub SK_RAMDATA1 () {	0x188;}
}
unless(defined(&SK_TO0)) {
    sub SK_TO0 () {	0x190;}
}
unless(defined(&SK_TO1)) {
    sub SK_TO1 () {	0x191;}
}
unless(defined(&SK_TO2)) {
    sub SK_TO2 () {	0x192;}
}
unless(defined(&SK_TO3)) {
    sub SK_TO3 () {	0x193;}
}
unless(defined(&SK_TO4)) {
    sub SK_TO4 () {	0x194;}
}
unless(defined(&SK_TO5)) {
    sub SK_TO5 () {	0x195;}
}
unless(defined(&SK_TO6)) {
    sub SK_TO6 () {	0x196;}
}
unless(defined(&SK_TO7)) {
    sub SK_TO7 () {	0x197;}
}
unless(defined(&SK_TO8)) {
    sub SK_TO8 () {	0x198;}
}
unless(defined(&SK_TO9)) {
    sub SK_TO9 () {	0x199;}
}
unless(defined(&SK_TO10)) {
    sub SK_TO10 () {	0x19a;}
}
unless(defined(&SK_TO11)) {
    sub SK_TO11 () {	0x19b;}
}
unless(defined(&SK_RITIMEO_TMR)) {
    sub SK_RITIMEO_TMR () {	0x19c;}
}
unless(defined(&SK_RAMCTL)) {
    sub SK_RAMCTL () {	0x1a0;}
}
unless(defined(&SK_RITIMER_TST)) {
    sub SK_RITIMER_TST () {	0x1a2;}
}
unless(defined(&SK_RAMCTL_RESET)) {
    sub SK_RAMCTL_RESET () {	0x1;}
}
unless(defined(&SK_RAMCTL_UNRESET)) {
    sub SK_RAMCTL_UNRESET () {	0x2;}
}
unless(defined(&SK_RAMCTL_CLR_IRQ_WPAR)) {
    sub SK_RAMCTL_CLR_IRQ_WPAR () {	0x100;}
}
unless(defined(&SK_RAMCTL_CLR_IRQ_RPAR)) {
    sub SK_RAMCTL_CLR_IRQ_RPAR () {	0x200;}
}
unless(defined(&SK_MINIT_RX1)) {
    sub SK_MINIT_RX1 () {	0x1b0;}
}
unless(defined(&SK_MINIT_RX2)) {
    sub SK_MINIT_RX2 () {	0x1b1;}
}
unless(defined(&SK_MINIT_TX1)) {
    sub SK_MINIT_TX1 () {	0x1b2;}
}
unless(defined(&SK_MINIT_TX2)) {
    sub SK_MINIT_TX2 () {	0x1b3;}
}
unless(defined(&SK_MTIMEO_RX1)) {
    sub SK_MTIMEO_RX1 () {	0x1b4;}
}
unless(defined(&SK_MTIMEO_RX2)) {
    sub SK_MTIMEO_RX2 () {	0x1b5;}
}
unless(defined(&SK_MTIMEO_TX1)) {
    sub SK_MTIMEO_TX1 () {	0x1b6;}
}
unless(defined(&SK_MTIEMO_TX2)) {
    sub SK_MTIEMO_TX2 () {	0x1b7;}
}
unless(defined(&SK_MACARB_CTL)) {
    sub SK_MACARB_CTL () {	0x1b8;}
}
unless(defined(&SK_MTIMER_TST)) {
    sub SK_MTIMER_TST () {	0x1ba;}
}
unless(defined(&SK_RCINIT_RX1)) {
    sub SK_RCINIT_RX1 () {	0x1c0;}
}
unless(defined(&SK_RCINIT_RX2)) {
    sub SK_RCINIT_RX2 () {	0x1c1;}
}
unless(defined(&SK_RCINIT_TX1)) {
    sub SK_RCINIT_TX1 () {	0x1c2;}
}
unless(defined(&SK_RCINIT_TX2)) {
    sub SK_RCINIT_TX2 () {	0x1c3;}
}
unless(defined(&SK_RCTIMEO_RX1)) {
    sub SK_RCTIMEO_RX1 () {	0x1c4;}
}
unless(defined(&SK_RCTIMEO_RX2)) {
    sub SK_RCTIMEO_RX2 () {	0x1c5;}
}
unless(defined(&SK_RCTIMEO_TX1)) {
    sub SK_RCTIMEO_TX1 () {	0x1c6;}
}
unless(defined(&SK_RCTIMEO_TX2)) {
    sub SK_RCTIMEO_TX2 () {	0x1c7;}
}
unless(defined(&SK_RECOVERY_CTL)) {
    sub SK_RECOVERY_CTL () {	0x1c8;}
}
unless(defined(&SK_RCTIMER_TST)) {
    sub SK_RCTIMER_TST () {	0x1ca;}
}
unless(defined(&SK_RXPA1_TINIT)) {
    sub SK_RXPA1_TINIT () {	0x1d0;}
}
unless(defined(&SK_RXPA2_TINIT)) {
    sub SK_RXPA2_TINIT () {	0x1d4;}
}
unless(defined(&SK_TXPA1_TINIT)) {
    sub SK_TXPA1_TINIT () {	0x1d8;}
}
unless(defined(&SK_TXPA2_TINIT)) {
    sub SK_TXPA2_TINIT () {	0x1dc;}
}
unless(defined(&SK_RXPA1_TIMEO)) {
    sub SK_RXPA1_TIMEO () {	0x1e0;}
}
unless(defined(&SK_RXPA2_TIMEO)) {
    sub SK_RXPA2_TIMEO () {	0x1e4;}
}
unless(defined(&SK_TXPA1_TIMEO)) {
    sub SK_TXPA1_TIMEO () {	0x1e8;}
}
unless(defined(&SK_TXPA2_TIMEO)) {
    sub SK_TXPA2_TIMEO () {	0x1ec;}
}
unless(defined(&SK_PKTARB_CTL)) {
    sub SK_PKTARB_CTL () {	0x1f0;}
}
unless(defined(&SK_PKTATB_TST)) {
    sub SK_PKTATB_TST () {	0x1f2;}
}
unless(defined(&SK_PKTARB_TIMEOUT)) {
    sub SK_PKTARB_TIMEOUT () {	0x2000;}
}
unless(defined(&SK_PKTARBCTL_RESET)) {
    sub SK_PKTARBCTL_RESET () {	0x1;}
}
unless(defined(&SK_PKTARBCTL_UNRESET)) {
    sub SK_PKTARBCTL_UNRESET () {	0x2;}
}
unless(defined(&SK_PKTARBCTL_RXTO1_OFF)) {
    sub SK_PKTARBCTL_RXTO1_OFF () {	0x4;}
}
unless(defined(&SK_PKTARBCTL_RXTO1_ON)) {
    sub SK_PKTARBCTL_RXTO1_ON () {	0x8;}
}
unless(defined(&SK_PKTARBCTL_RXTO2_OFF)) {
    sub SK_PKTARBCTL_RXTO2_OFF () {	0x10;}
}
unless(defined(&SK_PKTARBCTL_RXTO2_ON)) {
    sub SK_PKTARBCTL_RXTO2_ON () {	0x20;}
}
unless(defined(&SK_PKTARBCTL_TXTO1_OFF)) {
    sub SK_PKTARBCTL_TXTO1_OFF () {	0x40;}
}
unless(defined(&SK_PKTARBCTL_TXTO1_ON)) {
    sub SK_PKTARBCTL_TXTO1_ON () {	0x80;}
}
unless(defined(&SK_PKTARBCTL_TXTO2_OFF)) {
    sub SK_PKTARBCTL_TXTO2_OFF () {	0x100;}
}
unless(defined(&SK_PKTARBCTL_TXTO2_ON)) {
    sub SK_PKTARBCTL_TXTO2_ON () {	0x200;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_RXTO1)) {
    sub SK_PKTARBCTL_CLR_IRQ_RXTO1 () {	0x400;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_RXTO2)) {
    sub SK_PKTARBCTL_CLR_IRQ_RXTO2 () {	0x800;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_TXTO1)) {
    sub SK_PKTARBCTL_CLR_IRQ_TXTO1 () {	0x1000;}
}
unless(defined(&SK_PKTARBCTL_CLR_IRQ_TXTO2)) {
    sub SK_PKTARBCTL_CLR_IRQ_TXTO2 () {	0x2000;}
}
unless(defined(&SK_MINIT_XMAC_B2)) {
    sub SK_MINIT_XMAC_B2 () {	54;}
}
unless(defined(&SK_MINIT_XMAC_C1)) {
    sub SK_MINIT_XMAC_C1 () {	63;}
}
unless(defined(&SK_MACARBCTL_RESET)) {
    sub SK_MACARBCTL_RESET () {	0x1;}
}
unless(defined(&SK_MACARBCTL_UNRESET)) {
    sub SK_MACARBCTL_UNRESET () {	0x2;}
}
unless(defined(&SK_MACARBCTL_FASTOE_OFF)) {
    sub SK_MACARBCTL_FASTOE_OFF () {	0x4;}
}
unless(defined(&SK_MACARBCRL_FASTOE_ON)) {
    sub SK_MACARBCRL_FASTOE_ON () {	0x8;}
}
unless(defined(&SK_RCINIT_XMAC_B2)) {
    sub SK_RCINIT_XMAC_B2 () {	54;}
}
unless(defined(&SK_RCINIT_XMAC_C1)) {
    sub SK_RCINIT_XMAC_C1 () {	0;}
}
unless(defined(&SK_RECOVERYCTL_RX1_OFF)) {
    sub SK_RECOVERYCTL_RX1_OFF () {	0x1;}
}
unless(defined(&SK_RECOVERYCTL_RX1_ON)) {
    sub SK_RECOVERYCTL_RX1_ON () {	0x2;}
}
unless(defined(&SK_RECOVERYCTL_RX2_OFF)) {
    sub SK_RECOVERYCTL_RX2_OFF () {	0x4;}
}
unless(defined(&SK_RECOVERYCTL_RX2_ON)) {
    sub SK_RECOVERYCTL_RX2_ON () {	0x8;}
}
unless(defined(&SK_RECOVERYCTL_TX1_OFF)) {
    sub SK_RECOVERYCTL_TX1_OFF () {	0x10;}
}
unless(defined(&SK_RECOVERYCTL_TX1_ON)) {
    sub SK_RECOVERYCTL_TX1_ON () {	0x20;}
}
unless(defined(&SK_RECOVERYCTL_TX2_OFF)) {
    sub SK_RECOVERYCTL_TX2_OFF () {	0x40;}
}
unless(defined(&SK_RECOVERYCTL_TX2_ON)) {
    sub SK_RECOVERYCTL_TX2_ON () {	0x80;}
}
unless(defined(&SK_RECOVERY_XMAC_B2)) {
    sub SK_RECOVERY_XMAC_B2 () {	( &SK_RECOVERYCTL_RX1_ON| &SK_RECOVERYCTL_RX2_ON|  &SK_RECOVERYCTL_TX1_ON| &SK_RECOVERYCTL_TX2_ON);}
}
unless(defined(&SK_RECOVERY_XMAC_C1)) {
    sub SK_RECOVERY_XMAC_C1 () {	( &SK_RECOVERYCTL_RX1_OFF| &SK_RECOVERYCTL_RX2_OFF|  &SK_RECOVERYCTL_TX1_OFF| &SK_RECOVERYCTL_TX2_OFF);}
}
unless(defined(&SK_TXAR1_TIMERINIT)) {
    sub SK_TXAR1_TIMERINIT () {	0x200;}
}
unless(defined(&SK_TXAR1_TIMERVAL)) {
    sub SK_TXAR1_TIMERVAL () {	0x204;}
}
unless(defined(&SK_TXAR1_LIMITINIT)) {
    sub SK_TXAR1_LIMITINIT () {	0x208;}
}
unless(defined(&SK_TXAR1_LIMITCNT)) {
    sub SK_TXAR1_LIMITCNT () {	0x20c;}
}
unless(defined(&SK_TXAR1_COUNTERCTL)) {
    sub SK_TXAR1_COUNTERCTL () {	0x210;}
}
unless(defined(&SK_TXAR1_COUNTERTST)) {
    sub SK_TXAR1_COUNTERTST () {	0x212;}
}
unless(defined(&SK_TXAR1_COUNTERSTS)) {
    sub SK_TXAR1_COUNTERSTS () {	0x212;}
}
unless(defined(&SK_TXAR2_TIMERINIT)) {
    sub SK_TXAR2_TIMERINIT () {	0x280;}
}
unless(defined(&SK_TXAR2_TIMERVAL)) {
    sub SK_TXAR2_TIMERVAL () {	0x284;}
}
unless(defined(&SK_TXAR2_LIMITINIT)) {
    sub SK_TXAR2_LIMITINIT () {	0x288;}
}
unless(defined(&SK_TXAR2_LIMITCNT)) {
    sub SK_TXAR2_LIMITCNT () {	0x28c;}
}
unless(defined(&SK_TXAR2_COUNTERCTL)) {
    sub SK_TXAR2_COUNTERCTL () {	0x290;}
}
unless(defined(&SK_TXAR2_COUNTERTST)) {
    sub SK_TXAR2_COUNTERTST () {	0x291;}
}
unless(defined(&SK_TXAR2_COUNTERSTS)) {
    sub SK_TXAR2_COUNTERSTS () {	0x292;}
}
unless(defined(&SK_TXARCTL_OFF)) {
    sub SK_TXARCTL_OFF () {	0x1;}
}
unless(defined(&SK_TXARCTL_ON)) {
    sub SK_TXARCTL_ON () {	0x2;}
}
unless(defined(&SK_TXARCTL_RATECTL_OFF)) {
    sub SK_TXARCTL_RATECTL_OFF () {	0x4;}
}
unless(defined(&SK_TXARCTL_RATECTL_ON)) {
    sub SK_TXARCTL_RATECTL_ON () {	0x8;}
}
unless(defined(&SK_TXARCTL_ALLOC_OFF)) {
    sub SK_TXARCTL_ALLOC_OFF () {	0x10;}
}
unless(defined(&SK_TXARCTL_ALLOC_ON)) {
    sub SK_TXARCTL_ALLOC_ON () {	0x20;}
}
unless(defined(&SK_TXARCTL_FSYNC_OFF)) {
    sub SK_TXARCTL_FSYNC_OFF () {	0x40;}
}
unless(defined(&SK_TXARCTL_FSYNC_ON)) {
    sub SK_TXARCTL_FSYNC_ON () {	0x80;}
}
unless(defined(&SK_EXTREG_BASE)) {
    sub SK_EXTREG_BASE () {	0x300;}
}
unless(defined(&SK_EXTREG_END)) {
    sub SK_EXTREG_END () {	0x37c;}
}
unless(defined(&SK_PCI_BASE)) {
    sub SK_PCI_BASE () {	0x380;}
}
unless(defined(&SK_PCI_END)) {
    sub SK_PCI_END () {	0x3fc;}
}
unless(defined(&SK_PCI_REG)) {
    sub SK_PCI_REG {
	my($reg) = @_;
	eval q((($reg) +  &SK_PCI_BASE));
    }
}
unless(defined(&SK_RXQ1_BUFCNT)) {
    sub SK_RXQ1_BUFCNT () {	0x400;}
}
unless(defined(&SK_RXQ1_BUFCTL)) {
    sub SK_RXQ1_BUFCTL () {	0x402;}
}
unless(defined(&SK_RXQ1_NEXTDESC)) {
    sub SK_RXQ1_NEXTDESC () {	0x404;}
}
unless(defined(&SK_RXQ1_RXBUF_LO)) {
    sub SK_RXQ1_RXBUF_LO () {	0x408;}
}
unless(defined(&SK_RXQ1_RXBUF_HI)) {
    sub SK_RXQ1_RXBUF_HI () {	0x40c;}
}
unless(defined(&SK_RXQ1_RXSTAT)) {
    sub SK_RXQ1_RXSTAT () {	0x410;}
}
unless(defined(&SK_RXQ1_TIMESTAMP)) {
    sub SK_RXQ1_TIMESTAMP () {	0x414;}
}
unless(defined(&SK_RXQ1_CSUM1)) {
    sub SK_RXQ1_CSUM1 () {	0x418;}
}
unless(defined(&SK_RXQ1_CSUM2)) {
    sub SK_RXQ1_CSUM2 () {	0x41a;}
}
unless(defined(&SK_RXQ1_CSUM1_START)) {
    sub SK_RXQ1_CSUM1_START () {	0x41c;}
}
unless(defined(&SK_RXQ1_CSUM2_START)) {
    sub SK_RXQ1_CSUM2_START () {	0x41e;}
}
unless(defined(&SK_RXQ1_CURADDR_LO)) {
    sub SK_RXQ1_CURADDR_LO () {	0x420;}
}
unless(defined(&SK_RXQ1_CURADDR_HI)) {
    sub SK_RXQ1_CURADDR_HI () {	0x424;}
}
unless(defined(&SK_RXQ1_CURCNT_LO)) {
    sub SK_RXQ1_CURCNT_LO () {	0x428;}
}
unless(defined(&SK_RXQ1_CURCNT_HI)) {
    sub SK_RXQ1_CURCNT_HI () {	0x42c;}
}
unless(defined(&SK_RXQ1_CURBYTES)) {
    sub SK_RXQ1_CURBYTES () {	0x430;}
}
unless(defined(&SK_RXQ1_BMU_CSR)) {
    sub SK_RXQ1_BMU_CSR () {	0x434;}
}
unless(defined(&SK_RXQ1_WATERMARK)) {
    sub SK_RXQ1_WATERMARK () {	0x438;}
}
unless(defined(&SK_RXQ1_FLAG)) {
    sub SK_RXQ1_FLAG () {	0x43a;}
}
unless(defined(&SK_RXQ1_TEST1)) {
    sub SK_RXQ1_TEST1 () {	0x43c;}
}
unless(defined(&SK_RXQ1_TEST2)) {
    sub SK_RXQ1_TEST2 () {	0x440;}
}
unless(defined(&SK_RXQ1_TEST3)) {
    sub SK_RXQ1_TEST3 () {	0x444;}
}
unless(defined(&SK_RXQ1_Y2_WM)) {
    sub SK_RXQ1_Y2_WM () {	0x440;}
}
unless(defined(&SK_RXQ1_Y2_AL)) {
    sub SK_RXQ1_Y2_AL () {	0x442;}
}
unless(defined(&SK_RXQ1_Y2_RSP)) {
    sub SK_RXQ1_Y2_RSP () {	0x444;}
}
unless(defined(&SK_RXQ1_Y2_RSL)) {
    sub SK_RXQ1_Y2_RSL () {	0x446;}
}
unless(defined(&SK_RXQ1_Y2_RP)) {
    sub SK_RXQ1_Y2_RP () {	0x448;}
}
unless(defined(&SK_RXQ1_Y2_RL)) {
    sub SK_RXQ1_Y2_RL () {	0x44a;}
}
unless(defined(&SK_RXQ1_Y2_WP)) {
    sub SK_RXQ1_Y2_WP () {	0x44c;}
}
unless(defined(&SK_RXQ1_Y2_WSP)) {
    sub SK_RXQ1_Y2_WSP () {	0x44d;}
}
unless(defined(&SK_RXQ1_Y2_WL)) {
    sub SK_RXQ1_Y2_WL () {	0x44e;}
}
unless(defined(&SK_RXQ1_Y2_WSL)) {
    sub SK_RXQ1_Y2_WSL () {	0x44f;}
}
unless(defined(&SK_RXQ1_Y2_PREF_CSR)) {
    sub SK_RXQ1_Y2_PREF_CSR () {	0x450;}
}
unless(defined(&SK_RXQ1_Y2_PREF_LIDX)) {
    sub SK_RXQ1_Y2_PREF_LIDX () {	0x454;}
}
unless(defined(&SK_RXQ1_Y2_PREF_ADDRLO)) {
    sub SK_RXQ1_Y2_PREF_ADDRLO () {	0x458;}
}
unless(defined(&SK_RXQ1_Y2_PREF_ADDRHI)) {
    sub SK_RXQ1_Y2_PREF_ADDRHI () {	0x45c;}
}
unless(defined(&SK_RXQ1_Y2_PREF_GETIDX)) {
    sub SK_RXQ1_Y2_PREF_GETIDX () {	0x460;}
}
unless(defined(&SK_RXQ1_Y2_PREF_PUTIDX)) {
    sub SK_RXQ1_Y2_PREF_PUTIDX () {	0x464;}
}
unless(defined(&SK_RXQ1_Y2_PREF_FIFOWP)) {
    sub SK_RXQ1_Y2_PREF_FIFOWP () {	0x470;}
}
unless(defined(&SK_RXQ1_Y2_PREF_FIFORP)) {
    sub SK_RXQ1_Y2_PREF_FIFORP () {	0x474;}
}
unless(defined(&SK_RXQ1_Y2_PREF_FIFOWM)) {
    sub SK_RXQ1_Y2_PREF_FIFOWM () {	0x478;}
}
unless(defined(&SK_RXQ1_Y2_PREF_FIFOLV)) {
    sub SK_RXQ1_Y2_PREF_FIFOLV () {	0x47c;}
}
unless(defined(&SK_RXQ2_BUFCNT)) {
    sub SK_RXQ2_BUFCNT () {	0x480;}
}
unless(defined(&SK_RXQ2_BUFCTL)) {
    sub SK_RXQ2_BUFCTL () {	0x482;}
}
unless(defined(&SK_RXQ2_NEXTDESC)) {
    sub SK_RXQ2_NEXTDESC () {	0x484;}
}
unless(defined(&SK_RXQ2_RXBUF_LO)) {
    sub SK_RXQ2_RXBUF_LO () {	0x488;}
}
unless(defined(&SK_RXQ2_RXBUF_HI)) {
    sub SK_RXQ2_RXBUF_HI () {	0x48c;}
}
unless(defined(&SK_RXQ2_RXSTAT)) {
    sub SK_RXQ2_RXSTAT () {	0x490;}
}
unless(defined(&SK_RXQ2_TIMESTAMP)) {
    sub SK_RXQ2_TIMESTAMP () {	0x494;}
}
unless(defined(&SK_RXQ2_CSUM1)) {
    sub SK_RXQ2_CSUM1 () {	0x498;}
}
unless(defined(&SK_RXQ2_CSUM2)) {
    sub SK_RXQ2_CSUM2 () {	0x49a;}
}
unless(defined(&SK_RXQ2_CSUM1_START)) {
    sub SK_RXQ2_CSUM1_START () {	0x49c;}
}
unless(defined(&SK_RXQ2_CSUM2_START)) {
    sub SK_RXQ2_CSUM2_START () {	0x49e;}
}
unless(defined(&SK_RXQ2_CURADDR_LO)) {
    sub SK_RXQ2_CURADDR_LO () {	0x4a0;}
}
unless(defined(&SK_RXQ2_CURADDR_HI)) {
    sub SK_RXQ2_CURADDR_HI () {	0x4a4;}
}
unless(defined(&SK_RXQ2_CURCNT_LO)) {
    sub SK_RXQ2_CURCNT_LO () {	0x4a8;}
}
unless(defined(&SK_RXQ2_CURCNT_HI)) {
    sub SK_RXQ2_CURCNT_HI () {	0x4ac;}
}
unless(defined(&SK_RXQ2_CURBYTES)) {
    sub SK_RXQ2_CURBYTES () {	0x4b0;}
}
unless(defined(&SK_RXQ2_BMU_CSR)) {
    sub SK_RXQ2_BMU_CSR () {	0x4b4;}
}
unless(defined(&SK_RXQ2_WATERMARK)) {
    sub SK_RXQ2_WATERMARK () {	0x4b8;}
}
unless(defined(&SK_RXQ2_FLAG)) {
    sub SK_RXQ2_FLAG () {	0x4ba;}
}
unless(defined(&SK_RXQ2_TEST1)) {
    sub SK_RXQ2_TEST1 () {	0x4bc;}
}
unless(defined(&SK_RXQ2_TEST2)) {
    sub SK_RXQ2_TEST2 () {	0x4c0;}
}
unless(defined(&SK_RXQ2_TEST3)) {
    sub SK_RXQ2_TEST3 () {	0x4c4;}
}
unless(defined(&SK_RXQ2_Y2_WM)) {
    sub SK_RXQ2_Y2_WM () {	0x4c0;}
}
unless(defined(&SK_RXQ2_Y2_AL)) {
    sub SK_RXQ2_Y2_AL () {	0x4c2;}
}
unless(defined(&SK_RXQ2_Y2_RSP)) {
    sub SK_RXQ2_Y2_RSP () {	0x4c4;}
}
unless(defined(&SK_RXQ2_Y2_RSL)) {
    sub SK_RXQ2_Y2_RSL () {	0x4c6;}
}
unless(defined(&SK_RXQ2_Y2_RP)) {
    sub SK_RXQ2_Y2_RP () {	0x4c8;}
}
unless(defined(&SK_RXQ2_Y2_RL)) {
    sub SK_RXQ2_Y2_RL () {	0x4ca;}
}
unless(defined(&SK_RXQ2_Y2_WP)) {
    sub SK_RXQ2_Y2_WP () {	0x4cc;}
}
unless(defined(&SK_RXQ2_Y2_WSP)) {
    sub SK_RXQ2_Y2_WSP () {	0x4cd;}
}
unless(defined(&SK_RXQ2_Y2_WL)) {
    sub SK_RXQ2_Y2_WL () {	0x4ce;}
}
unless(defined(&SK_RXQ2_Y2_WSL)) {
    sub SK_RXQ2_Y2_WSL () {	0x4cf;}
}
unless(defined(&SK_RXQ2_Y2_PREF_CSR)) {
    sub SK_RXQ2_Y2_PREF_CSR () {	0x4d0;}
}
unless(defined(&SK_RXQ2_Y2_PREF_LIDX)) {
    sub SK_RXQ2_Y2_PREF_LIDX () {	0x4d4;}
}
unless(defined(&SK_RXQ2_Y2_PREF_ADDRLO)) {
    sub SK_RXQ2_Y2_PREF_ADDRLO () {	0x4d8;}
}
unless(defined(&SK_RXQ2_Y2_PREF_ADDRHI)) {
    sub SK_RXQ2_Y2_PREF_ADDRHI () {	0x4dc;}
}
unless(defined(&SK_RXQ2_Y2_PREF_GETIDX)) {
    sub SK_RXQ2_Y2_PREF_GETIDX () {	0x4e0;}
}
unless(defined(&SK_RXQ2_Y2_PREF_PUTIDX)) {
    sub SK_RXQ2_Y2_PREF_PUTIDX () {	0x4e4;}
}
unless(defined(&SK_RXQ2_Y2_PREF_FIFOWP)) {
    sub SK_RXQ2_Y2_PREF_FIFOWP () {	0x4f0;}
}
unless(defined(&SK_RXQ2_Y2_PREF_FIFORP)) {
    sub SK_RXQ2_Y2_PREF_FIFORP () {	0x4f4;}
}
unless(defined(&SK_RXQ2_Y2_PREF_FIFOWM)) {
    sub SK_RXQ2_Y2_PREF_FIFOWM () {	0x4f8;}
}
unless(defined(&SK_RXQ2_Y2_PREF_FIFOLV)) {
    sub SK_RXQ2_Y2_PREF_FIFOLV () {	0x4fc;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_ERR)) {
    sub SK_RXBMU_CLR_IRQ_ERR () {	0x1;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_EOF)) {
    sub SK_RXBMU_CLR_IRQ_EOF () {	0x2;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_EOB)) {
    sub SK_RXBMU_CLR_IRQ_EOB () {	0x4;}
}
unless(defined(&SK_RXBMU_CLR_IRQ_PAR)) {
    sub SK_RXBMU_CLR_IRQ_PAR () {	0x8;}
}
unless(defined(&SK_RXBMU_RX_START)) {
    sub SK_RXBMU_RX_START () {	0x10;}
}
unless(defined(&SK_RXBMU_RX_STOP)) {
    sub SK_RXBMU_RX_STOP () {	0x20;}
}
unless(defined(&SK_RXBMU_POLL_OFF)) {
    sub SK_RXBMU_POLL_OFF () {	0x40;}
}
unless(defined(&SK_RXBMU_POLL_ON)) {
    sub SK_RXBMU_POLL_ON () {	0x80;}
}
unless(defined(&SK_RXBMU_TRANSFER_SM_RESET)) {
    sub SK_RXBMU_TRANSFER_SM_RESET () {	0x100;}
}
unless(defined(&SK_RXBMU_TRANSFER_SM_UNRESET)) {
    sub SK_RXBMU_TRANSFER_SM_UNRESET () {	0x200;}
}
unless(defined(&SK_RXBMU_DESCWR_SM_RESET)) {
    sub SK_RXBMU_DESCWR_SM_RESET () {	0x400;}
}
unless(defined(&SK_RXBMU_DESCWR_SM_UNRESET)) {
    sub SK_RXBMU_DESCWR_SM_UNRESET () {	0x800;}
}
unless(defined(&SK_RXBMU_DESCRD_SM_RESET)) {
    sub SK_RXBMU_DESCRD_SM_RESET () {	0x1000;}
}
unless(defined(&SK_RXBMU_DESCRD_SM_UNRESET)) {
    sub SK_RXBMU_DESCRD_SM_UNRESET () {	0x2000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_SM_RESET)) {
    sub SK_RXBMU_SUPERVISOR_SM_RESET () {	0x4000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_SM_UNRESET)) {
    sub SK_RXBMU_SUPERVISOR_SM_UNRESET () {	0x8000;}
}
unless(defined(&SK_RXBMU_PFI_SM_RESET)) {
    sub SK_RXBMU_PFI_SM_RESET () {	0x10000;}
}
unless(defined(&SK_RXBMU_PFI_SM_UNRESET)) {
    sub SK_RXBMU_PFI_SM_UNRESET () {	0x20000;}
}
unless(defined(&SK_RXBMU_FIFO_RESET)) {
    sub SK_RXBMU_FIFO_RESET () {	0x40000;}
}
unless(defined(&SK_RXBMU_FIFO_UNRESET)) {
    sub SK_RXBMU_FIFO_UNRESET () {	0x80000;}
}
unless(defined(&SK_RXBMU_DESC_RESET)) {
    sub SK_RXBMU_DESC_RESET () {	0x100000;}
}
unless(defined(&SK_RXBMU_DESC_UNRESET)) {
    sub SK_RXBMU_DESC_UNRESET () {	0x200000;}
}
unless(defined(&SK_RXBMU_SUPERVISOR_IDLE)) {
    sub SK_RXBMU_SUPERVISOR_IDLE () {	0x1000000;}
}
unless(defined(&SK_RXBMU_ONLINE)) {
    sub SK_RXBMU_ONLINE () {	( &SK_RXBMU_TRANSFER_SM_UNRESET| &SK_RXBMU_DESCWR_SM_UNRESET|  &SK_RXBMU_DESCRD_SM_UNRESET| &SK_RXBMU_SUPERVISOR_SM_UNRESET|  &SK_RXBMU_PFI_SM_UNRESET| &SK_RXBMU_FIFO_UNRESET|  &SK_RXBMU_DESC_UNRESET);}
}
unless(defined(&SK_RXBMU_OFFLINE)) {
    sub SK_RXBMU_OFFLINE () {	( &SK_RXBMU_TRANSFER_SM_RESET| &SK_RXBMU_DESCWR_SM_RESET|  &SK_RXBMU_DESCRD_SM_RESET| &SK_RXBMU_SUPERVISOR_SM_RESET|  &SK_RXBMU_PFI_SM_RESET| &SK_RXBMU_FIFO_RESET|  &SK_RXBMU_DESC_RESET);}
}
unless(defined(&SK_TXQS1_BUFCNT)) {
    sub SK_TXQS1_BUFCNT () {	0x600;}
}
unless(defined(&SK_TXQS1_BUFCTL)) {
    sub SK_TXQS1_BUFCTL () {	0x602;}
}
unless(defined(&SK_TXQS1_NEXTDESC)) {
    sub SK_TXQS1_NEXTDESC () {	0x604;}
}
unless(defined(&SK_TXQS1_RXBUF_LO)) {
    sub SK_TXQS1_RXBUF_LO () {	0x608;}
}
unless(defined(&SK_TXQS1_RXBUF_HI)) {
    sub SK_TXQS1_RXBUF_HI () {	0x60c;}
}
unless(defined(&SK_TXQS1_RXSTAT)) {
    sub SK_TXQS1_RXSTAT () {	0x610;}
}
unless(defined(&SK_TXQS1_CSUM_STARTVAL)) {
    sub SK_TXQS1_CSUM_STARTVAL () {	0x614;}
}
unless(defined(&SK_TXQS1_CSUM_STARTPOS)) {
    sub SK_TXQS1_CSUM_STARTPOS () {	0x618;}
}
unless(defined(&SK_TXQS1_CSUM_WRITEPOS)) {
    sub SK_TXQS1_CSUM_WRITEPOS () {	0x61a;}
}
unless(defined(&SK_TXQS1_CURADDR_LO)) {
    sub SK_TXQS1_CURADDR_LO () {	0x620;}
}
unless(defined(&SK_TXQS1_CURADDR_HI)) {
    sub SK_TXQS1_CURADDR_HI () {	0x624;}
}
unless(defined(&SK_TXQS1_CURCNT_LO)) {
    sub SK_TXQS1_CURCNT_LO () {	0x628;}
}
unless(defined(&SK_TXQS1_CURCNT_HI)) {
    sub SK_TXQS1_CURCNT_HI () {	0x62c;}
}
unless(defined(&SK_TXQS1_CURBYTES)) {
    sub SK_TXQS1_CURBYTES () {	0x630;}
}
unless(defined(&SK_TXQS1_BMU_CSR)) {
    sub SK_TXQS1_BMU_CSR () {	0x634;}
}
unless(defined(&SK_TXQS1_WATERMARK)) {
    sub SK_TXQS1_WATERMARK () {	0x638;}
}
unless(defined(&SK_TXQS1_FLAG)) {
    sub SK_TXQS1_FLAG () {	0x63a;}
}
unless(defined(&SK_TXQS1_TEST1)) {
    sub SK_TXQS1_TEST1 () {	0x63c;}
}
unless(defined(&SK_TXQS1_TEST2)) {
    sub SK_TXQS1_TEST2 () {	0x640;}
}
unless(defined(&SK_TXQS1_TEST3)) {
    sub SK_TXQS1_TEST3 () {	0x644;}
}
unless(defined(&SK_TXQS1_Y2_WM)) {
    sub SK_TXQS1_Y2_WM () {	0x640;}
}
unless(defined(&SK_TXQS1_Y2_AL)) {
    sub SK_TXQS1_Y2_AL () {	0x642;}
}
unless(defined(&SK_TXQS1_Y2_RSP)) {
    sub SK_TXQS1_Y2_RSP () {	0x644;}
}
unless(defined(&SK_TXQS1_Y2_RSL)) {
    sub SK_TXQS1_Y2_RSL () {	0x646;}
}
unless(defined(&SK_TXQS1_Y2_RP)) {
    sub SK_TXQS1_Y2_RP () {	0x648;}
}
unless(defined(&SK_TXQS1_Y2_RL)) {
    sub SK_TXQS1_Y2_RL () {	0x64a;}
}
unless(defined(&SK_TXQS1_Y2_WP)) {
    sub SK_TXQS1_Y2_WP () {	0x64c;}
}
unless(defined(&SK_TXQS1_Y2_WSP)) {
    sub SK_TXQS1_Y2_WSP () {	0x64d;}
}
unless(defined(&SK_TXQS1_Y2_WL)) {
    sub SK_TXQS1_Y2_WL () {	0x64e;}
}
unless(defined(&SK_TXQS1_Y2_WSL)) {
    sub SK_TXQS1_Y2_WSL () {	0x64f;}
}
unless(defined(&SK_TXQS1_Y2_PREF_CSR)) {
    sub SK_TXQS1_Y2_PREF_CSR () {	0x650;}
}
unless(defined(&SK_TXQS1_Y2_PREF_LIDX)) {
    sub SK_TXQS1_Y2_PREF_LIDX () {	0x654;}
}
unless(defined(&SK_TXQS1_Y2_PREF_ADDRLO)) {
    sub SK_TXQS1_Y2_PREF_ADDRLO () {	0x658;}
}
unless(defined(&SK_TXQS1_Y2_PREF_ADDRHI)) {
    sub SK_TXQS1_Y2_PREF_ADDRHI () {	0x65c;}
}
unless(defined(&SK_TXQS1_Y2_PREF_GETIDX)) {
    sub SK_TXQS1_Y2_PREF_GETIDX () {	0x660;}
}
unless(defined(&SK_TXQS1_Y2_PREF_PUTIDX)) {
    sub SK_TXQS1_Y2_PREF_PUTIDX () {	0x664;}
}
unless(defined(&SK_TXQS1_Y2_PREF_FIFOWP)) {
    sub SK_TXQS1_Y2_PREF_FIFOWP () {	0x670;}
}
unless(defined(&SK_TXQS1_Y2_PREF_FIFORP)) {
    sub SK_TXQS1_Y2_PREF_FIFORP () {	0x674;}
}
unless(defined(&SK_TXQS1_Y2_PREF_FIFOWM)) {
    sub SK_TXQS1_Y2_PREF_FIFOWM () {	0x678;}
}
unless(defined(&SK_TXQS1_Y2_PREF_FIFOLV)) {
    sub SK_TXQS1_Y2_PREF_FIFOLV () {	0x67c;}
}
unless(defined(&SK_TXQA1_BUFCNT)) {
    sub SK_TXQA1_BUFCNT () {	0x680;}
}
unless(defined(&SK_TXQA1_BUFCTL)) {
    sub SK_TXQA1_BUFCTL () {	0x682;}
}
unless(defined(&SK_TXQA1_NEXTDESC)) {
    sub SK_TXQA1_NEXTDESC () {	0x684;}
}
unless(defined(&SK_TXQA1_RXBUF_LO)) {
    sub SK_TXQA1_RXBUF_LO () {	0x688;}
}
unless(defined(&SK_TXQA1_RXBUF_HI)) {
    sub SK_TXQA1_RXBUF_HI () {	0x68c;}
}
unless(defined(&SK_TXQA1_RXSTAT)) {
    sub SK_TXQA1_RXSTAT () {	0x690;}
}
unless(defined(&SK_TXQA1_CSUM_STARTVAL)) {
    sub SK_TXQA1_CSUM_STARTVAL () {	0x694;}
}
unless(defined(&SK_TXQA1_CSUM_STARTPOS)) {
    sub SK_TXQA1_CSUM_STARTPOS () {	0x698;}
}
unless(defined(&SK_TXQA1_CSUM_WRITEPOS)) {
    sub SK_TXQA1_CSUM_WRITEPOS () {	0x69a;}
}
unless(defined(&SK_TXQA1_CURADDR_LO)) {
    sub SK_TXQA1_CURADDR_LO () {	0x6a0;}
}
unless(defined(&SK_TXQA1_CURADDR_HI)) {
    sub SK_TXQA1_CURADDR_HI () {	0x6a4;}
}
unless(defined(&SK_TXQA1_CURCNT_LO)) {
    sub SK_TXQA1_CURCNT_LO () {	0x6a8;}
}
unless(defined(&SK_TXQA1_CURCNT_HI)) {
    sub SK_TXQA1_CURCNT_HI () {	0x6ac;}
}
unless(defined(&SK_TXQA1_CURBYTES)) {
    sub SK_TXQA1_CURBYTES () {	0x6b0;}
}
unless(defined(&SK_TXQA1_BMU_CSR)) {
    sub SK_TXQA1_BMU_CSR () {	0x6b4;}
}
unless(defined(&SK_TXQA1_WATERMARK)) {
    sub SK_TXQA1_WATERMARK () {	0x6b8;}
}
unless(defined(&SK_TXQA1_FLAG)) {
    sub SK_TXQA1_FLAG () {	0x6ba;}
}
unless(defined(&SK_TXQA1_TEST1)) {
    sub SK_TXQA1_TEST1 () {	0x6bc;}
}
unless(defined(&SK_TXQA1_TEST2)) {
    sub SK_TXQA1_TEST2 () {	0x6c0;}
}
unless(defined(&SK_TXQA1_TEST3)) {
    sub SK_TXQA1_TEST3 () {	0x6c4;}
}
unless(defined(&SK_TXQA1_Y2_WM)) {
    sub SK_TXQA1_Y2_WM () {	0x6c0;}
}
unless(defined(&SK_TXQA1_Y2_AL)) {
    sub SK_TXQA1_Y2_AL () {	0x6c2;}
}
unless(defined(&SK_TXQA1_Y2_RSP)) {
    sub SK_TXQA1_Y2_RSP () {	0x6c4;}
}
unless(defined(&SK_TXQA1_Y2_RSL)) {
    sub SK_TXQA1_Y2_RSL () {	0x6c6;}
}
unless(defined(&SK_TXQA1_Y2_RP)) {
    sub SK_TXQA1_Y2_RP () {	0x6c8;}
}
unless(defined(&SK_TXQA1_Y2_RL)) {
    sub SK_TXQA1_Y2_RL () {	0x6ca;}
}
unless(defined(&SK_TXQA1_Y2_WP)) {
    sub SK_TXQA1_Y2_WP () {	0x6cc;}
}
unless(defined(&SK_TXQA1_Y2_WSP)) {
    sub SK_TXQA1_Y2_WSP () {	0x6cd;}
}
unless(defined(&SK_TXQA1_Y2_WL)) {
    sub SK_TXQA1_Y2_WL () {	0x6ce;}
}
unless(defined(&SK_TXQA1_Y2_WSL)) {
    sub SK_TXQA1_Y2_WSL () {	0x6cf;}
}
unless(defined(&SK_TXQA1_Y2_PREF_CSR)) {
    sub SK_TXQA1_Y2_PREF_CSR () {	0x6d0;}
}
unless(defined(&SK_TXQA1_Y2_PREF_LIDX)) {
    sub SK_TXQA1_Y2_PREF_LIDX () {	0x6d4;}
}
unless(defined(&SK_TXQA1_Y2_PREF_ADDRLO)) {
    sub SK_TXQA1_Y2_PREF_ADDRLO () {	0x6d8;}
}
unless(defined(&SK_TXQA1_Y2_PREF_ADDRHI)) {
    sub SK_TXQA1_Y2_PREF_ADDRHI () {	0x6dc;}
}
unless(defined(&SK_TXQA1_Y2_PREF_GETIDX)) {
    sub SK_TXQA1_Y2_PREF_GETIDX () {	0x6e0;}
}
unless(defined(&SK_TXQA1_Y2_PREF_PUTIDX)) {
    sub SK_TXQA1_Y2_PREF_PUTIDX () {	0x6e4;}
}
unless(defined(&SK_TXQA1_Y2_PREF_FIFOWP)) {
    sub SK_TXQA1_Y2_PREF_FIFOWP () {	0x6f0;}
}
unless(defined(&SK_TXQA1_Y2_PREF_FIFORP)) {
    sub SK_TXQA1_Y2_PREF_FIFORP () {	0x6f4;}
}
unless(defined(&SK_TXQA1_Y2_PREF_FIFOWM)) {
    sub SK_TXQA1_Y2_PREF_FIFOWM () {	0x6f8;}
}
unless(defined(&SK_TXQA1_Y2_PREF_FIFOLV)) {
    sub SK_TXQA1_Y2_PREF_FIFOLV () {	0x6fc;}
}
unless(defined(&SK_TXQS2_BUFCNT)) {
    sub SK_TXQS2_BUFCNT () {	0x700;}
}
unless(defined(&SK_TXQS2_BUFCTL)) {
    sub SK_TXQS2_BUFCTL () {	0x702;}
}
unless(defined(&SK_TXQS2_NEXTDESC)) {
    sub SK_TXQS2_NEXTDESC () {	0x704;}
}
unless(defined(&SK_TXQS2_RXBUF_LO)) {
    sub SK_TXQS2_RXBUF_LO () {	0x708;}
}
unless(defined(&SK_TXQS2_RXBUF_HI)) {
    sub SK_TXQS2_RXBUF_HI () {	0x70c;}
}
unless(defined(&SK_TXQS2_RXSTAT)) {
    sub SK_TXQS2_RXSTAT () {	0x710;}
}
unless(defined(&SK_TXQS2_CSUM_STARTVAL)) {
    sub SK_TXQS2_CSUM_STARTVAL () {	0x714;}
}
unless(defined(&SK_TXQS2_CSUM_STARTPOS)) {
    sub SK_TXQS2_CSUM_STARTPOS () {	0x718;}
}
unless(defined(&SK_TXQS2_CSUM_WRITEPOS)) {
    sub SK_TXQS2_CSUM_WRITEPOS () {	0x71a;}
}
unless(defined(&SK_TXQS2_CURADDR_LO)) {
    sub SK_TXQS2_CURADDR_LO () {	0x720;}
}
unless(defined(&SK_TXQS2_CURADDR_HI)) {
    sub SK_TXQS2_CURADDR_HI () {	0x724;}
}
unless(defined(&SK_TXQS2_CURCNT_LO)) {
    sub SK_TXQS2_CURCNT_LO () {	0x728;}
}
unless(defined(&SK_TXQS2_CURCNT_HI)) {
    sub SK_TXQS2_CURCNT_HI () {	0x72c;}
}
unless(defined(&SK_TXQS2_CURBYTES)) {
    sub SK_TXQS2_CURBYTES () {	0x730;}
}
unless(defined(&SK_TXQS2_BMU_CSR)) {
    sub SK_TXQS2_BMU_CSR () {	0x734;}
}
unless(defined(&SK_TXQS2_WATERMARK)) {
    sub SK_TXQS2_WATERMARK () {	0x738;}
}
unless(defined(&SK_TXQS2_FLAG)) {
    sub SK_TXQS2_FLAG () {	0x73a;}
}
unless(defined(&SK_TXQS2_TEST1)) {
    sub SK_TXQS2_TEST1 () {	0x73c;}
}
unless(defined(&SK_TXQS2_TEST2)) {
    sub SK_TXQS2_TEST2 () {	0x740;}
}
unless(defined(&SK_TXQS2_TEST3)) {
    sub SK_TXQS2_TEST3 () {	0x744;}
}
unless(defined(&SK_TXQS2_Y2_WM)) {
    sub SK_TXQS2_Y2_WM () {	0x740;}
}
unless(defined(&SK_TXQS2_Y2_AL)) {
    sub SK_TXQS2_Y2_AL () {	0x742;}
}
unless(defined(&SK_TXQS2_Y2_RSP)) {
    sub SK_TXQS2_Y2_RSP () {	0x744;}
}
unless(defined(&SK_TXQS2_Y2_RSL)) {
    sub SK_TXQS2_Y2_RSL () {	0x746;}
}
unless(defined(&SK_TXQS2_Y2_RP)) {
    sub SK_TXQS2_Y2_RP () {	0x748;}
}
unless(defined(&SK_TXQS2_Y2_RL)) {
    sub SK_TXQS2_Y2_RL () {	0x74a;}
}
unless(defined(&SK_TXQS2_Y2_WP)) {
    sub SK_TXQS2_Y2_WP () {	0x74c;}
}
unless(defined(&SK_TXQS2_Y2_WSP)) {
    sub SK_TXQS2_Y2_WSP () {	0x74d;}
}
unless(defined(&SK_TXQS2_Y2_WL)) {
    sub SK_TXQS2_Y2_WL () {	0x74e;}
}
unless(defined(&SK_TXQS2_Y2_WSL)) {
    sub SK_TXQS2_Y2_WSL () {	0x74f;}
}
unless(defined(&SK_TXQS2_Y2_PREF_CSR)) {
    sub SK_TXQS2_Y2_PREF_CSR () {	0x750;}
}
unless(defined(&SK_TXQS2_Y2_PREF_LIDX)) {
    sub SK_TXQS2_Y2_PREF_LIDX () {	0x754;}
}
unless(defined(&SK_TXQS2_Y2_PREF_ADDRLO)) {
    sub SK_TXQS2_Y2_PREF_ADDRLO () {	0x758;}
}
unless(defined(&SK_TXQS2_Y2_PREF_ADDRHI)) {
    sub SK_TXQS2_Y2_PREF_ADDRHI () {	0x75c;}
}
unless(defined(&SK_TXQS2_Y2_PREF_GETIDX)) {
    sub SK_TXQS2_Y2_PREF_GETIDX () {	0x760;}
}
unless(defined(&SK_TXQS2_Y2_PREF_PUTIDX)) {
    sub SK_TXQS2_Y2_PREF_PUTIDX () {	0x764;}
}
unless(defined(&SK_TXQS2_Y2_PREF_FIFOWP)) {
    sub SK_TXQS2_Y2_PREF_FIFOWP () {	0x770;}
}
unless(defined(&SK_TXQS2_Y2_PREF_FIFORP)) {
    sub SK_TXQS2_Y2_PREF_FIFORP () {	0x774;}
}
unless(defined(&SK_TXQS2_Y2_PREF_FIFOWM)) {
    sub SK_TXQS2_Y2_PREF_FIFOWM () {	0x778;}
}
unless(defined(&SK_TXQS2_Y2_PREF_FIFOLV)) {
    sub SK_TXQS2_Y2_PREF_FIFOLV () {	0x77c;}
}
unless(defined(&SK_TXQA2_BUFCNT)) {
    sub SK_TXQA2_BUFCNT () {	0x780;}
}
unless(defined(&SK_TXQA2_BUFCTL)) {
    sub SK_TXQA2_BUFCTL () {	0x782;}
}
unless(defined(&SK_TXQA2_NEXTDESC)) {
    sub SK_TXQA2_NEXTDESC () {	0x784;}
}
unless(defined(&SK_TXQA2_RXBUF_LO)) {
    sub SK_TXQA2_RXBUF_LO () {	0x788;}
}
unless(defined(&SK_TXQA2_RXBUF_HI)) {
    sub SK_TXQA2_RXBUF_HI () {	0x78c;}
}
unless(defined(&SK_TXQA2_RXSTAT)) {
    sub SK_TXQA2_RXSTAT () {	0x790;}
}
unless(defined(&SK_TXQA2_CSUM_STARTVAL)) {
    sub SK_TXQA2_CSUM_STARTVAL () {	0x794;}
}
unless(defined(&SK_TXQA2_CSUM_STARTPOS)) {
    sub SK_TXQA2_CSUM_STARTPOS () {	0x798;}
}
unless(defined(&SK_TXQA2_CSUM_WRITEPOS)) {
    sub SK_TXQA2_CSUM_WRITEPOS () {	0x79a;}
}
unless(defined(&SK_TXQA2_CURADDR_LO)) {
    sub SK_TXQA2_CURADDR_LO () {	0x7a0;}
}
unless(defined(&SK_TXQA2_CURADDR_HI)) {
    sub SK_TXQA2_CURADDR_HI () {	0x7a4;}
}
unless(defined(&SK_TXQA2_CURCNT_LO)) {
    sub SK_TXQA2_CURCNT_LO () {	0x7a8;}
}
unless(defined(&SK_TXQA2_CURCNT_HI)) {
    sub SK_TXQA2_CURCNT_HI () {	0x7ac;}
}
unless(defined(&SK_TXQA2_CURBYTES)) {
    sub SK_TXQA2_CURBYTES () {	0x7b0;}
}
unless(defined(&SK_TXQA2_BMU_CSR)) {
    sub SK_TXQA2_BMU_CSR () {	0x7b4;}
}
unless(defined(&SK_TXQA2_WATERMARK)) {
    sub SK_TXQA2_WATERMARK () {	0x7b8;}
}
unless(defined(&SK_TXQA2_FLAG)) {
    sub SK_TXQA2_FLAG () {	0x7ba;}
}
unless(defined(&SK_TXQA2_TEST1)) {
    sub SK_TXQA2_TEST1 () {	0x7bc;}
}
unless(defined(&SK_TXQA2_TEST2)) {
    sub SK_TXQA2_TEST2 () {	0x7c0;}
}
unless(defined(&SK_TXQA2_TEST3)) {
    sub SK_TXQA2_TEST3 () {	0x7c4;}
}
unless(defined(&SK_TXQA2_Y2_WM)) {
    sub SK_TXQA2_Y2_WM () {	0x7c0;}
}
unless(defined(&SK_TXQA2_Y2_AL)) {
    sub SK_TXQA2_Y2_AL () {	0x7c2;}
}
unless(defined(&SK_TXQA2_Y2_RSP)) {
    sub SK_TXQA2_Y2_RSP () {	0x7c4;}
}
unless(defined(&SK_TXQA2_Y2_RSL)) {
    sub SK_TXQA2_Y2_RSL () {	0x7c6;}
}
unless(defined(&SK_TXQA2_Y2_RP)) {
    sub SK_TXQA2_Y2_RP () {	0x7c8;}
}
unless(defined(&SK_TXQA2_Y2_RL)) {
    sub SK_TXQA2_Y2_RL () {	0x7ca;}
}
unless(defined(&SK_TXQA2_Y2_WP)) {
    sub SK_TXQA2_Y2_WP () {	0x7cc;}
}
unless(defined(&SK_TXQA2_Y2_WSP)) {
    sub SK_TXQA2_Y2_WSP () {	0x7cd;}
}
unless(defined(&SK_TXQA2_Y2_WL)) {
    sub SK_TXQA2_Y2_WL () {	0x7ce;}
}
unless(defined(&SK_TXQA2_Y2_WSL)) {
    sub SK_TXQA2_Y2_WSL () {	0x7cf;}
}
unless(defined(&SK_TXQA2_Y2_PREF_CSR)) {
    sub SK_TXQA2_Y2_PREF_CSR () {	0x7d0;}
}
unless(defined(&SK_TXQA2_Y2_PREF_LIDX)) {
    sub SK_TXQA2_Y2_PREF_LIDX () {	0x7d4;}
}
unless(defined(&SK_TXQA2_Y2_PREF_ADDRLO)) {
    sub SK_TXQA2_Y2_PREF_ADDRLO () {	0x7d8;}
}
unless(defined(&SK_TXQA2_Y2_PREF_ADDRHI)) {
    sub SK_TXQA2_Y2_PREF_ADDRHI () {	0x7dc;}
}
unless(defined(&SK_TXQA2_Y2_PREF_GETIDX)) {
    sub SK_TXQA2_Y2_PREF_GETIDX () {	0x7e0;}
}
unless(defined(&SK_TXQA2_Y2_PREF_PUTIDX)) {
    sub SK_TXQA2_Y2_PREF_PUTIDX () {	0x7e4;}
}
unless(defined(&SK_TXQA2_Y2_PREF_FIFOWP)) {
    sub SK_TXQA2_Y2_PREF_FIFOWP () {	0x7f0;}
}
unless(defined(&SK_TXQA2_Y2_PREF_FIFORP)) {
    sub SK_TXQA2_Y2_PREF_FIFORP () {	0x7f4;}
}
unless(defined(&SK_TXQA2_Y2_PREF_FIFOWM)) {
    sub SK_TXQA2_Y2_PREF_FIFOWM () {	0x7f8;}
}
unless(defined(&SK_TXQA2_Y2_PREF_FIFOLV)) {
    sub SK_TXQA2_Y2_PREF_FIFOLV () {	0x7fc;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_ERR)) {
    sub SK_TXBMU_CLR_IRQ_ERR () {	0x1;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_EOF)) {
    sub SK_TXBMU_CLR_IRQ_EOF () {	0x2;}
}
unless(defined(&SK_TXBMU_CLR_IRQ_EOB)) {
    sub SK_TXBMU_CLR_IRQ_EOB () {	0x4;}
}
unless(defined(&SK_TXBMU_TX_START)) {
    sub SK_TXBMU_TX_START () {	0x10;}
}
unless(defined(&SK_TXBMU_TX_STOP)) {
    sub SK_TXBMU_TX_STOP () {	0x20;}
}
unless(defined(&SK_TXBMU_POLL_OFF)) {
    sub SK_TXBMU_POLL_OFF () {	0x40;}
}
unless(defined(&SK_TXBMU_POLL_ON)) {
    sub SK_TXBMU_POLL_ON () {	0x80;}
}
unless(defined(&SK_TXBMU_TRANSFER_SM_RESET)) {
    sub SK_TXBMU_TRANSFER_SM_RESET () {	0x100;}
}
unless(defined(&SK_TXBMU_TRANSFER_SM_UNRESET)) {
    sub SK_TXBMU_TRANSFER_SM_UNRESET () {	0x200;}
}
unless(defined(&SK_TXBMU_DESCWR_SM_RESET)) {
    sub SK_TXBMU_DESCWR_SM_RESET () {	0x400;}
}
unless(defined(&SK_TXBMU_DESCWR_SM_UNRESET)) {
    sub SK_TXBMU_DESCWR_SM_UNRESET () {	0x800;}
}
unless(defined(&SK_TXBMU_DESCRD_SM_RESET)) {
    sub SK_TXBMU_DESCRD_SM_RESET () {	0x1000;}
}
unless(defined(&SK_TXBMU_DESCRD_SM_UNRESET)) {
    sub SK_TXBMU_DESCRD_SM_UNRESET () {	0x2000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_SM_RESET)) {
    sub SK_TXBMU_SUPERVISOR_SM_RESET () {	0x4000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_SM_UNRESET)) {
    sub SK_TXBMU_SUPERVISOR_SM_UNRESET () {	0x8000;}
}
unless(defined(&SK_TXBMU_PFI_SM_RESET)) {
    sub SK_TXBMU_PFI_SM_RESET () {	0x10000;}
}
unless(defined(&SK_TXBMU_PFI_SM_UNRESET)) {
    sub SK_TXBMU_PFI_SM_UNRESET () {	0x20000;}
}
unless(defined(&SK_TXBMU_FIFO_RESET)) {
    sub SK_TXBMU_FIFO_RESET () {	0x40000;}
}
unless(defined(&SK_TXBMU_FIFO_UNRESET)) {
    sub SK_TXBMU_FIFO_UNRESET () {	0x80000;}
}
unless(defined(&SK_TXBMU_DESC_RESET)) {
    sub SK_TXBMU_DESC_RESET () {	0x100000;}
}
unless(defined(&SK_TXBMU_DESC_UNRESET)) {
    sub SK_TXBMU_DESC_UNRESET () {	0x200000;}
}
unless(defined(&SK_TXBMU_SUPERVISOR_IDLE)) {
    sub SK_TXBMU_SUPERVISOR_IDLE () {	0x1000000;}
}
unless(defined(&SK_TXBMU_ONLINE)) {
    sub SK_TXBMU_ONLINE () {	( &SK_TXBMU_TRANSFER_SM_UNRESET| &SK_TXBMU_DESCWR_SM_UNRESET|  &SK_TXBMU_DESCRD_SM_UNRESET| &SK_TXBMU_SUPERVISOR_SM_UNRESET|  &SK_TXBMU_PFI_SM_UNRESET| &SK_TXBMU_FIFO_UNRESET|  &SK_TXBMU_DESC_UNRESET| &SK_TXBMU_POLL_ON);}
}
unless(defined(&SK_TXBMU_OFFLINE)) {
    sub SK_TXBMU_OFFLINE () {	( &SK_TXBMU_TRANSFER_SM_RESET| &SK_TXBMU_DESCWR_SM_RESET|  &SK_TXBMU_DESCRD_SM_RESET| &SK_TXBMU_SUPERVISOR_SM_RESET|  &SK_TXBMU_PFI_SM_RESET| &SK_TXBMU_FIFO_RESET|  &SK_TXBMU_DESC_RESET| &SK_TXBMU_POLL_OFF);}
}
unless(defined(&SK_RXRB1_START)) {
    sub SK_RXRB1_START () {	0x800;}
}
unless(defined(&SK_RXRB1_END)) {
    sub SK_RXRB1_END () {	0x804;}
}
unless(defined(&SK_RXRB1_WR_PTR)) {
    sub SK_RXRB1_WR_PTR () {	0x808;}
}
unless(defined(&SK_RXRB1_RD_PTR)) {
    sub SK_RXRB1_RD_PTR () {	0x80c;}
}
unless(defined(&SK_RXRB1_UTHR_PAUSE)) {
    sub SK_RXRB1_UTHR_PAUSE () {	0x810;}
}
unless(defined(&SK_RXRB1_LTHR_PAUSE)) {
    sub SK_RXRB1_LTHR_PAUSE () {	0x814;}
}
unless(defined(&SK_RXRB1_UTHR_HIPRIO)) {
    sub SK_RXRB1_UTHR_HIPRIO () {	0x818;}
}
unless(defined(&SK_RXRB1_UTHR_LOPRIO)) {
    sub SK_RXRB1_UTHR_LOPRIO () {	0x81c;}
}
unless(defined(&SK_RXRB1_PKTCNT)) {
    sub SK_RXRB1_PKTCNT () {	0x820;}
}
unless(defined(&SK_RXRB1_LVL)) {
    sub SK_RXRB1_LVL () {	0x824;}
}
unless(defined(&SK_RXRB1_CTLTST)) {
    sub SK_RXRB1_CTLTST () {	0x828;}
}
unless(defined(&SK_RXRB2_START)) {
    sub SK_RXRB2_START () {	0x880;}
}
unless(defined(&SK_RXRB2_END)) {
    sub SK_RXRB2_END () {	0x884;}
}
unless(defined(&SK_RXRB2_WR_PTR)) {
    sub SK_RXRB2_WR_PTR () {	0x888;}
}
unless(defined(&SK_RXRB2_RD_PTR)) {
    sub SK_RXRB2_RD_PTR () {	0x88c;}
}
unless(defined(&SK_RXRB2_UTHR_PAUSE)) {
    sub SK_RXRB2_UTHR_PAUSE () {	0x890;}
}
unless(defined(&SK_RXRB2_LTHR_PAUSE)) {
    sub SK_RXRB2_LTHR_PAUSE () {	0x894;}
}
unless(defined(&SK_RXRB2_UTHR_HIPRIO)) {
    sub SK_RXRB2_UTHR_HIPRIO () {	0x898;}
}
unless(defined(&SK_RXRB2_UTHR_LOPRIO)) {
    sub SK_RXRB2_UTHR_LOPRIO () {	0x89c;}
}
unless(defined(&SK_RXRB2_PKTCNT)) {
    sub SK_RXRB2_PKTCNT () {	0x8a0;}
}
unless(defined(&SK_RXRB2_LVL)) {
    sub SK_RXRB2_LVL () {	0x8a4;}
}
unless(defined(&SK_RXRB2_CTLTST)) {
    sub SK_RXRB2_CTLTST () {	0x8a8;}
}
unless(defined(&SK_TXRBS1_START)) {
    sub SK_TXRBS1_START () {	0xa00;}
}
unless(defined(&SK_TXRBS1_END)) {
    sub SK_TXRBS1_END () {	0xa04;}
}
unless(defined(&SK_TXRBS1_WR_PTR)) {
    sub SK_TXRBS1_WR_PTR () {	0xa08;}
}
unless(defined(&SK_TXRBS1_RD_PTR)) {
    sub SK_TXRBS1_RD_PTR () {	0xa0c;}
}
unless(defined(&SK_TXRBS1_PKTCNT)) {
    sub SK_TXRBS1_PKTCNT () {	0xa20;}
}
unless(defined(&SK_TXRBS1_LVL)) {
    sub SK_TXRBS1_LVL () {	0xa24;}
}
unless(defined(&SK_TXRBS1_CTLTST)) {
    sub SK_TXRBS1_CTLTST () {	0xa28;}
}
unless(defined(&SK_TXRBA1_START)) {
    sub SK_TXRBA1_START () {	0xa80;}
}
unless(defined(&SK_TXRBA1_END)) {
    sub SK_TXRBA1_END () {	0xa84;}
}
unless(defined(&SK_TXRBA1_WR_PTR)) {
    sub SK_TXRBA1_WR_PTR () {	0xa88;}
}
unless(defined(&SK_TXRBA1_RD_PTR)) {
    sub SK_TXRBA1_RD_PTR () {	0xa8c;}
}
unless(defined(&SK_TXRBA1_PKTCNT)) {
    sub SK_TXRBA1_PKTCNT () {	0xaa0;}
}
unless(defined(&SK_TXRBA1_LVL)) {
    sub SK_TXRBA1_LVL () {	0xaa4;}
}
unless(defined(&SK_TXRBA1_CTLTST)) {
    sub SK_TXRBA1_CTLTST () {	0xaa8;}
}
unless(defined(&SK_TXRBS2_START)) {
    sub SK_TXRBS2_START () {	0xb00;}
}
unless(defined(&SK_TXRBS2_END)) {
    sub SK_TXRBS2_END () {	0xb04;}
}
unless(defined(&SK_TXRBS2_WR_PTR)) {
    sub SK_TXRBS2_WR_PTR () {	0xb08;}
}
unless(defined(&SK_TXRBS2_RD_PTR)) {
    sub SK_TXRBS2_RD_PTR () {	0xb0c;}
}
unless(defined(&SK_TXRBS2_PKTCNT)) {
    sub SK_TXRBS2_PKTCNT () {	0xb20;}
}
unless(defined(&SK_TXRBS2_LVL)) {
    sub SK_TXRBS2_LVL () {	0xb24;}
}
unless(defined(&SK_TXRBS2_CTLTST)) {
    sub SK_TXRBS2_CTLTST () {	0xb28;}
}
unless(defined(&SK_TXRBA2_START)) {
    sub SK_TXRBA2_START () {	0xb80;}
}
unless(defined(&SK_TXRBA2_END)) {
    sub SK_TXRBA2_END () {	0xb84;}
}
unless(defined(&SK_TXRBA2_WR_PTR)) {
    sub SK_TXRBA2_WR_PTR () {	0xb88;}
}
unless(defined(&SK_TXRBA2_RD_PTR)) {
    sub SK_TXRBA2_RD_PTR () {	0xb8c;}
}
unless(defined(&SK_TXRBA2_PKTCNT)) {
    sub SK_TXRBA2_PKTCNT () {	0xba0;}
}
unless(defined(&SK_TXRBA2_LVL)) {
    sub SK_TXRBA2_LVL () {	0xba4;}
}
unless(defined(&SK_TXRBA2_CTLTST)) {
    sub SK_TXRBA2_CTLTST () {	0xba8;}
}
unless(defined(&SK_RBCTL_RESET)) {
    sub SK_RBCTL_RESET () {	0x1;}
}
unless(defined(&SK_RBCTL_UNRESET)) {
    sub SK_RBCTL_UNRESET () {	0x2;}
}
unless(defined(&SK_RBCTL_OFF)) {
    sub SK_RBCTL_OFF () {	0x4;}
}
unless(defined(&SK_RBCTL_ON)) {
    sub SK_RBCTL_ON () {	0x8;}
}
unless(defined(&SK_RBCTL_STORENFWD_OFF)) {
    sub SK_RBCTL_STORENFWD_OFF () {	0x10;}
}
unless(defined(&SK_RBCTL_STORENFWD_ON)) {
    sub SK_RBCTL_STORENFWD_ON () {	0x20;}
}
unless(defined(&SK_RXF1_END)) {
    sub SK_RXF1_END () {	0xc00;}
}
unless(defined(&SK_RXF1_WPTR)) {
    sub SK_RXF1_WPTR () {	0xc04;}
}
unless(defined(&SK_RXF1_RPTR)) {
    sub SK_RXF1_RPTR () {	0xc0c;}
}
unless(defined(&SK_RXF1_PKTCNT)) {
    sub SK_RXF1_PKTCNT () {	0xc10;}
}
unless(defined(&SK_RXF1_LVL)) {
    sub SK_RXF1_LVL () {	0xc14;}
}
unless(defined(&SK_RXF1_MACCTL)) {
    sub SK_RXF1_MACCTL () {	0xc18;}
}
unless(defined(&SK_RXF1_CTL)) {
    sub SK_RXF1_CTL () {	0xc1c;}
}
unless(defined(&SK_RXLED1_CNTINIT)) {
    sub SK_RXLED1_CNTINIT () {	0xc20;}
}
unless(defined(&SK_RXLED1_COUNTER)) {
    sub SK_RXLED1_COUNTER () {	0xc24;}
}
unless(defined(&SK_RXLED1_CTL)) {
    sub SK_RXLED1_CTL () {	0xc28;}
}
unless(defined(&SK_RXLED1_TST)) {
    sub SK_RXLED1_TST () {	0xc29;}
}
unless(defined(&SK_LINK_SYNC1_CINIT)) {
    sub SK_LINK_SYNC1_CINIT () {	0xc30;}
}
unless(defined(&SK_LINK_SYNC1_COUNTER)) {
    sub SK_LINK_SYNC1_COUNTER () {	0xc34;}
}
unless(defined(&SK_LINK_SYNC1_CTL)) {
    sub SK_LINK_SYNC1_CTL () {	0xc38;}
}
unless(defined(&SK_LINK_SYNC1_TST)) {
    sub SK_LINK_SYNC1_TST () {	0xc39;}
}
unless(defined(&SK_LINKLED1_CTL)) {
    sub SK_LINKLED1_CTL () {	0xc3c;}
}
unless(defined(&SK_FIFO_END)) {
    sub SK_FIFO_END () {	0x3f;}
}
unless(defined(&SK_RXMF1_END)) {
    sub SK_RXMF1_END () {	0xc40;}
}
unless(defined(&SK_RXMF1_THRESHOLD)) {
    sub SK_RXMF1_THRESHOLD () {	0xc44;}
}
unless(defined(&SK_RXMF1_CTRL_TEST)) {
    sub SK_RXMF1_CTRL_TEST () {	0xc48;}
}
unless(defined(&SK_RXMF1_FLUSH_MASK)) {
    sub SK_RXMF1_FLUSH_MASK () {	0xc4c;}
}
unless(defined(&SK_RXMF1_FLUSH_THRESHOLD)) {
    sub SK_RXMF1_FLUSH_THRESHOLD () {	0xc50;}
}
unless(defined(&SK_RXMF1_WRITE_PTR)) {
    sub SK_RXMF1_WRITE_PTR () {	0xc60;}
}
unless(defined(&SK_RXMF1_WRITE_LEVEL)) {
    sub SK_RXMF1_WRITE_LEVEL () {	0xc68;}
}
unless(defined(&SK_RXMF1_READ_PTR)) {
    sub SK_RXMF1_READ_PTR () {	0xc70;}
}
unless(defined(&SK_RXMF1_READ_LEVEL)) {
    sub SK_RXMF1_READ_LEVEL () {	0xc78;}
}
unless(defined(&SK_RFCTL_WR_PTR_TST_ON)) {
    sub SK_RFCTL_WR_PTR_TST_ON () {	0x4000;}
}
unless(defined(&SK_RFCTL_WR_PTR_TST_OFF)) {
    sub SK_RFCTL_WR_PTR_TST_OFF () {	0x2000;}
}
unless(defined(&SK_RFCTL_WR_PTR_STEP)) {
    sub SK_RFCTL_WR_PTR_STEP () {	0x1000;}
}
unless(defined(&SK_RFCTL_RD_PTR_TST_ON)) {
    sub SK_RFCTL_RD_PTR_TST_ON () {	0x400;}
}
unless(defined(&SK_RFCTL_RD_PTR_TST_OFF)) {
    sub SK_RFCTL_RD_PTR_TST_OFF () {	0x200;}
}
unless(defined(&SK_RFCTL_RD_PTR_STEP)) {
    sub SK_RFCTL_RD_PTR_STEP () {	0x100;}
}
unless(defined(&SK_RFCTL_FIFO_FLUSH_ON)) {
    sub SK_RFCTL_FIFO_FLUSH_ON () {	0x80;}
}
unless(defined(&SK_RFCTL_FIFO_FLUSH_OFF)) {
    sub SK_RFCTL_FIFO_FLUSH_OFF () {	0x40;}
}
unless(defined(&SK_RFCTL_RX_FIFO_OVER)) {
    sub SK_RFCTL_RX_FIFO_OVER () {	0x20;}
}
unless(defined(&SK_RFCTL_FRAME_RX_DONE)) {
    sub SK_RFCTL_FRAME_RX_DONE () {	0x10;}
}
unless(defined(&SK_RFCTL_OPERATION_ON)) {
    sub SK_RFCTL_OPERATION_ON () {	0x8;}
}
unless(defined(&SK_RFCTL_OPERATION_OFF)) {
    sub SK_RFCTL_OPERATION_OFF () {	0x4;}
}
unless(defined(&SK_RFCTL_RESET_CLEAR)) {
    sub SK_RFCTL_RESET_CLEAR () {	0x2;}
}
unless(defined(&SK_RFCTL_RESET_SET)) {
    sub SK_RFCTL_RESET_SET () {	0x1;}
}
unless(defined(&SK_RFCTL_FIFO_THRESHOLD)) {
    sub SK_RFCTL_FIFO_THRESHOLD () {	0xa;}
}
unless(defined(&SK_RXF2_END)) {
    sub SK_RXF2_END () {	0xc80;}
}
unless(defined(&SK_RXF2_WPTR)) {
    sub SK_RXF2_WPTR () {	0xc84;}
}
unless(defined(&SK_RXF2_RPTR)) {
    sub SK_RXF2_RPTR () {	0xc8c;}
}
unless(defined(&SK_RXF2_PKTCNT)) {
    sub SK_RXF2_PKTCNT () {	0xc90;}
}
unless(defined(&SK_RXF2_LVL)) {
    sub SK_RXF2_LVL () {	0xc94;}
}
unless(defined(&SK_RXF2_MACCTL)) {
    sub SK_RXF2_MACCTL () {	0xc98;}
}
unless(defined(&SK_RXF2_CTL)) {
    sub SK_RXF2_CTL () {	0xc9c;}
}
unless(defined(&SK_RXLED2_CNTINIT)) {
    sub SK_RXLED2_CNTINIT () {	0xca0;}
}
unless(defined(&SK_RXLED2_COUNTER)) {
    sub SK_RXLED2_COUNTER () {	0xca4;}
}
unless(defined(&SK_RXLED2_CTL)) {
    sub SK_RXLED2_CTL () {	0xca8;}
}
unless(defined(&SK_RXLED2_TST)) {
    sub SK_RXLED2_TST () {	0xca9;}
}
unless(defined(&SK_LINK_SYNC2_CINIT)) {
    sub SK_LINK_SYNC2_CINIT () {	0xcb0;}
}
unless(defined(&SK_LINK_SYNC2_COUNTER)) {
    sub SK_LINK_SYNC2_COUNTER () {	0xcb4;}
}
unless(defined(&SK_LINK_SYNC2_CTL)) {
    sub SK_LINK_SYNC2_CTL () {	0xcb8;}
}
unless(defined(&SK_LINK_SYNC2_TST)) {
    sub SK_LINK_SYNC2_TST () {	0xcb9;}
}
unless(defined(&SK_LINKLED2_CTL)) {
    sub SK_LINKLED2_CTL () {	0xcbc;}
}
unless(defined(&SK_RXMACCTL_CLR_IRQ_NOSTS)) {
    sub SK_RXMACCTL_CLR_IRQ_NOSTS () {	0x1;}
}
unless(defined(&SK_RXMACCTL_CLR_IRQ_NOTSTAMP)) {
    sub SK_RXMACCTL_CLR_IRQ_NOTSTAMP () {	0x2;}
}
unless(defined(&SK_RXMACCTL_TSTAMP_OFF)) {
    sub SK_RXMACCTL_TSTAMP_OFF () {	0x4;}
}
unless(defined(&SK_RXMACCTL_RSTAMP_ON)) {
    sub SK_RXMACCTL_RSTAMP_ON () {	0x8;}
}
unless(defined(&SK_RXMACCTL_FLUSH_OFF)) {
    sub SK_RXMACCTL_FLUSH_OFF () {	0x10;}
}
unless(defined(&SK_RXMACCTL_FLUSH_ON)) {
    sub SK_RXMACCTL_FLUSH_ON () {	0x20;}
}
unless(defined(&SK_RXMACCTL_PAUSE_OFF)) {
    sub SK_RXMACCTL_PAUSE_OFF () {	0x40;}
}
unless(defined(&SK_RXMACCTL_PAUSE_ON)) {
    sub SK_RXMACCTL_PAUSE_ON () {	0x80;}
}
unless(defined(&SK_RXMACCTL_AFULL_OFF)) {
    sub SK_RXMACCTL_AFULL_OFF () {	0x100;}
}
unless(defined(&SK_RXMACCTL_AFULL_ON)) {
    sub SK_RXMACCTL_AFULL_ON () {	0x200;}
}
unless(defined(&SK_RXMACCTL_VALIDTIME_PATCH_OFF)) {
    sub SK_RXMACCTL_VALIDTIME_PATCH_OFF () {	0x400;}
}
unless(defined(&SK_RXMACCTL_VALIDTIME_PATCH_ON)) {
    sub SK_RXMACCTL_VALIDTIME_PATCH_ON () {	0x800;}
}
unless(defined(&SK_RXMACCTL_RXRDY_PATCH_OFF)) {
    sub SK_RXMACCTL_RXRDY_PATCH_OFF () {	0x1000;}
}
unless(defined(&SK_RXMACCTL_RXRDY_PATCH_ON)) {
    sub SK_RXMACCTL_RXRDY_PATCH_ON () {	0x2000;}
}
unless(defined(&SK_RXMACCTL_STS_TIMEO)) {
    sub SK_RXMACCTL_STS_TIMEO () {	0xff0000;}
}
unless(defined(&SK_RXMACCTL_TSTAMP_TIMEO)) {
    sub SK_RXMACCTL_TSTAMP_TIMEO () {	0xff000000;}
}
unless(defined(&SK_RXLEDCTL_ENABLE)) {
    sub SK_RXLEDCTL_ENABLE () {	0x1;}
}
unless(defined(&SK_RXLEDCTL_COUNTER_STOP)) {
    sub SK_RXLEDCTL_COUNTER_STOP () {	0x2;}
}
unless(defined(&SK_RXLEDCTL_COUNTER_START)) {
    sub SK_RXLEDCTL_COUNTER_START () {	0x4;}
}
unless(defined(&SK_LINKLED_OFF)) {
    sub SK_LINKLED_OFF () {	0x1;}
}
unless(defined(&SK_LINKLED_ON)) {
    sub SK_LINKLED_ON () {	0x2;}
}
unless(defined(&SK_LINKLED_LINKSYNC_OFF)) {
    sub SK_LINKLED_LINKSYNC_OFF () {	0x4;}
}
unless(defined(&SK_LINKLED_LINKSYNC_ON)) {
    sub SK_LINKLED_LINKSYNC_ON () {	0x8;}
}
unless(defined(&SK_LINKLED_BLINK_OFF)) {
    sub SK_LINKLED_BLINK_OFF () {	0x10;}
}
unless(defined(&SK_LINKLED_BLINK_ON)) {
    sub SK_LINKLED_BLINK_ON () {	0x20;}
}
unless(defined(&SK_TXF1_END)) {
    sub SK_TXF1_END () {	0xd00;}
}
unless(defined(&SK_TXF1_WPTR)) {
    sub SK_TXF1_WPTR () {	0xd04;}
}
unless(defined(&SK_TXF1_RPTR)) {
    sub SK_TXF1_RPTR () {	0xd0c;}
}
unless(defined(&SK_TXF1_PKTCNT)) {
    sub SK_TXF1_PKTCNT () {	0xd10;}
}
unless(defined(&SK_TXF1_LVL)) {
    sub SK_TXF1_LVL () {	0xd14;}
}
unless(defined(&SK_TXF1_MACCTL)) {
    sub SK_TXF1_MACCTL () {	0xd18;}
}
unless(defined(&SK_TXF1_CTL)) {
    sub SK_TXF1_CTL () {	0xd1c;}
}
unless(defined(&SK_TXLED1_CNTINIT)) {
    sub SK_TXLED1_CNTINIT () {	0xd20;}
}
unless(defined(&SK_TXLED1_COUNTER)) {
    sub SK_TXLED1_COUNTER () {	0xd24;}
}
unless(defined(&SK_TXLED1_CTL)) {
    sub SK_TXLED1_CTL () {	0xd28;}
}
unless(defined(&SK_TXLED1_TST)) {
    sub SK_TXLED1_TST () {	0xd29;}
}
unless(defined(&SK_TXMF1_END)) {
    sub SK_TXMF1_END () {	0xd40;}
}
unless(defined(&SK_TXMF1_THRESHOLD)) {
    sub SK_TXMF1_THRESHOLD () {	0xd44;}
}
unless(defined(&SK_TXMF1_CTRL_TEST)) {
    sub SK_TXMF1_CTRL_TEST () {	0xd48;}
}
unless(defined(&SK_TXMF1_WRITE_PTR)) {
    sub SK_TXMF1_WRITE_PTR () {	0xd60;}
}
unless(defined(&SK_TXMF1_WRITE_SHADOW)) {
    sub SK_TXMF1_WRITE_SHADOW () {	0xd64;}
}
unless(defined(&SK_TXMF1_WRITE_LEVEL)) {
    sub SK_TXMF1_WRITE_LEVEL () {	0xd68;}
}
unless(defined(&SK_TXMF1_READ_PTR)) {
    sub SK_TXMF1_READ_PTR () {	0xd70;}
}
unless(defined(&SK_TXMF1_RESTART_PTR)) {
    sub SK_TXMF1_RESTART_PTR () {	0xd74;}
}
unless(defined(&SK_TXMF1_READ_LEVEL)) {
    sub SK_TXMF1_READ_LEVEL () {	0xd78;}
}
unless(defined(&SK_TFCTL_WR_PTR_TST_ON)) {
    sub SK_TFCTL_WR_PTR_TST_ON () {	0x4000;}
}
unless(defined(&SK_TFCTL_WR_PTR_TST_OFF)) {
    sub SK_TFCTL_WR_PTR_TST_OFF () {	0x2000;}
}
unless(defined(&SK_TFCTL_WR_PTR_STEP)) {
    sub SK_TFCTL_WR_PTR_STEP () {	0x1000;}
}
unless(defined(&SK_TFCTL_RD_PTR_TST_ON)) {
    sub SK_TFCTL_RD_PTR_TST_ON () {	0x400;}
}
unless(defined(&SK_TFCTL_RD_PTR_TST_OFF)) {
    sub SK_TFCTL_RD_PTR_TST_OFF () {	0x200;}
}
unless(defined(&SK_TFCTL_RD_PTR_STEP)) {
    sub SK_TFCTL_RD_PTR_STEP () {	0x100;}
}
unless(defined(&SK_TFCTL_TX_FIFO_UNDER)) {
    sub SK_TFCTL_TX_FIFO_UNDER () {	0x40;}
}
unless(defined(&SK_TFCTL_FRAME_TX_DONE)) {
    sub SK_TFCTL_FRAME_TX_DONE () {	0x20;}
}
unless(defined(&SK_TFCTL_IRQ_PARITY_ER)) {
    sub SK_TFCTL_IRQ_PARITY_ER () {	0x10;}
}
unless(defined(&SK_TFCTL_OPERATION_ON)) {
    sub SK_TFCTL_OPERATION_ON () {	0x8;}
}
unless(defined(&SK_TFCTL_OPERATION_OFF)) {
    sub SK_TFCTL_OPERATION_OFF () {	0x4;}
}
unless(defined(&SK_TFCTL_RESET_CLEAR)) {
    sub SK_TFCTL_RESET_CLEAR () {	0x2;}
}
unless(defined(&SK_TFCTL_RESET_SET)) {
    sub SK_TFCTL_RESET_SET () {	0x1;}
}
unless(defined(&SK_TXF2_END)) {
    sub SK_TXF2_END () {	0xd80;}
}
unless(defined(&SK_TXF2_WPTR)) {
    sub SK_TXF2_WPTR () {	0xd84;}
}
unless(defined(&SK_TXF2_RPTR)) {
    sub SK_TXF2_RPTR () {	0xd8c;}
}
unless(defined(&SK_TXF2_PKTCNT)) {
    sub SK_TXF2_PKTCNT () {	0xd90;}
}
unless(defined(&SK_TXF2_LVL)) {
    sub SK_TXF2_LVL () {	0xd94;}
}
unless(defined(&SK_TXF2_MACCTL)) {
    sub SK_TXF2_MACCTL () {	0xd98;}
}
unless(defined(&SK_TXF2_CTL)) {
    sub SK_TXF2_CTL () {	0xd9c;}
}
unless(defined(&SK_TXLED2_CNTINIT)) {
    sub SK_TXLED2_CNTINIT () {	0xda0;}
}
unless(defined(&SK_TXLED2_COUNTER)) {
    sub SK_TXLED2_COUNTER () {	0xda4;}
}
unless(defined(&SK_TXLED2_CTL)) {
    sub SK_TXLED2_CTL () {	0xda8;}
}
unless(defined(&SK_TXLED2_TST)) {
    sub SK_TXLED2_TST () {	0xda9;}
}
unless(defined(&SK_TXMACCTL_XMAC_RESET)) {
    sub SK_TXMACCTL_XMAC_RESET () {	0x1;}
}
unless(defined(&SK_TXMACCTL_XMAC_UNRESET)) {
    sub SK_TXMACCTL_XMAC_UNRESET () {	0x2;}
}
unless(defined(&SK_TXMACCTL_LOOP_OFF)) {
    sub SK_TXMACCTL_LOOP_OFF () {	0x4;}
}
unless(defined(&SK_TXMACCTL_LOOP_ON)) {
    sub SK_TXMACCTL_LOOP_ON () {	0x8;}
}
unless(defined(&SK_TXMACCTL_FLUSH_OFF)) {
    sub SK_TXMACCTL_FLUSH_OFF () {	0x10;}
}
unless(defined(&SK_TXMACCTL_FLUSH_ON)) {
    sub SK_TXMACCTL_FLUSH_ON () {	0x20;}
}
unless(defined(&SK_TXMACCTL_WAITEMPTY_OFF)) {
    sub SK_TXMACCTL_WAITEMPTY_OFF () {	0x40;}
}
unless(defined(&SK_TXMACCTL_WAITEMPTY_ON)) {
    sub SK_TXMACCTL_WAITEMPTY_ON () {	0x80;}
}
unless(defined(&SK_TXMACCTL_AFULL_OFF)) {
    sub SK_TXMACCTL_AFULL_OFF () {	0x100;}
}
unless(defined(&SK_TXMACCTL_AFULL_ON)) {
    sub SK_TXMACCTL_AFULL_ON () {	0x200;}
}
unless(defined(&SK_TXMACCTL_TXRDY_PATCH_OFF)) {
    sub SK_TXMACCTL_TXRDY_PATCH_OFF () {	0x400;}
}
unless(defined(&SK_TXMACCTL_RXRDY_PATCH_ON)) {
    sub SK_TXMACCTL_RXRDY_PATCH_ON () {	0x800;}
}
unless(defined(&SK_TXMACCTL_PKT_RECOVERY_OFF)) {
    sub SK_TXMACCTL_PKT_RECOVERY_OFF () {	0x1000;}
}
unless(defined(&SK_TXMACCTL_PKT_RECOVERY_ON)) {
    sub SK_TXMACCTL_PKT_RECOVERY_ON () {	0x2000;}
}
unless(defined(&SK_TXMACCTL_CLR_IRQ_PERR)) {
    sub SK_TXMACCTL_CLR_IRQ_PERR () {	0x8000;}
}
unless(defined(&SK_TXMACCTL_WAITAFTERFLUSH)) {
    sub SK_TXMACCTL_WAITAFTERFLUSH () {	0x10000;}
}
unless(defined(&SK_TXLEDCTL_ENABLE)) {
    sub SK_TXLEDCTL_ENABLE () {	0x1;}
}
unless(defined(&SK_TXLEDCTL_COUNTER_STOP)) {
    sub SK_TXLEDCTL_COUNTER_STOP () {	0x2;}
}
unless(defined(&SK_TXLEDCTL_COUNTER_START)) {
    sub SK_TXLEDCTL_COUNTER_START () {	0x4;}
}
unless(defined(&SK_FIFO_RESET)) {
    sub SK_FIFO_RESET () {	0x1;}
}
unless(defined(&SK_FIFO_UNRESET)) {
    sub SK_FIFO_UNRESET () {	0x2;}
}
unless(defined(&SK_FIFO_OFF)) {
    sub SK_FIFO_OFF () {	0x4;}
}
unless(defined(&SK_FIFO_ON)) {
    sub SK_FIFO_ON () {	0x8;}
}
unless(defined(&SK_DPT_INIT)) {
    sub SK_DPT_INIT () {	0xe00;}
}
unless(defined(&SK_DPT_TIMER)) {
    sub SK_DPT_TIMER () {	0xe04;}
}
unless(defined(&SK_DPT_TIMER_MAX)) {
    sub SK_DPT_TIMER_MAX () {	0xffffffff;}
}
unless(defined(&SK_DPT_TIMER_CTRL)) {
    sub SK_DPT_TIMER_CTRL () {	0xe08;}
}
unless(defined(&SK_DPT_TCTL_STOP)) {
    sub SK_DPT_TCTL_STOP () {	0x1;}
}
unless(defined(&SK_DPT_TCTL_START)) {
    sub SK_DPT_TCTL_START () {	0x2;}
}
unless(defined(&SK_DPT_TIMER_TEST)) {
    sub SK_DPT_TIMER_TEST () {	0xe0a;}
}
unless(defined(&SK_DPT_TTEST_STEP)) {
    sub SK_DPT_TTEST_STEP () {	0x1;}
}
unless(defined(&SK_DPT_TTEST_OFF)) {
    sub SK_DPT_TTEST_OFF () {	0x2;}
}
unless(defined(&SK_DPT_TTEST_ON)) {
    sub SK_DPT_TTEST_ON () {	0x4;}
}
unless(defined(&SK_TSTAMP_COUNT)) {
    sub SK_TSTAMP_COUNT () {	0xe14;}
}
unless(defined(&SK_TSTAMP_CTL)) {
    sub SK_TSTAMP_CTL () {	0xe18;}
}
unless(defined(&SK_TSTAMP_IRQ_CLEAR)) {
    sub SK_TSTAMP_IRQ_CLEAR () {	0x1;}
}
unless(defined(&SK_TSTAMP_STOP)) {
    sub SK_TSTAMP_STOP () {	0x2;}
}
unless(defined(&SK_TSTAMP_START)) {
    sub SK_TSTAMP_START () {	0x4;}
}
unless(defined(&SK_Y2_ASF_CSR)) {
    sub SK_Y2_ASF_CSR () {	0xe68;}
}
unless(defined(&SK_Y2_ASF_RESET)) {
    sub SK_Y2_ASF_RESET () {	0x8;}
}
unless(defined(&SK_Y2_LEV_ITIMERINIT)) {
    sub SK_Y2_LEV_ITIMERINIT () {	0xeb0;}
}
unless(defined(&SK_Y2_LEV_ITIMERCTL)) {
    sub SK_Y2_LEV_ITIMERCTL () {	0xeb8;}
}
unless(defined(&SK_Y2_TX_ITIMERINIT)) {
    sub SK_Y2_TX_ITIMERINIT () {	0xec0;}
}
unless(defined(&SK_Y2_TX_ITIMERCTL)) {
    sub SK_Y2_TX_ITIMERCTL () {	0xec8;}
}
unless(defined(&SK_Y2_ISR_ITIMERINIT)) {
    sub SK_Y2_ISR_ITIMERINIT () {	0xed0;}
}
unless(defined(&SK_Y2_ISR_ITIMERCTL)) {
    sub SK_Y2_ISR_ITIMERCTL () {	0xed8;}
}
unless(defined(&SK_STAT_BMU_CSR)) {
    sub SK_STAT_BMU_CSR () {	0xe80;}
}
unless(defined(&SK_STAT_BMU_LIDX)) {
    sub SK_STAT_BMU_LIDX () {	0xe84;}
}
unless(defined(&SK_STAT_BMU_ADDRLO)) {
    sub SK_STAT_BMU_ADDRLO () {	0xe88;}
}
unless(defined(&SK_STAT_BMU_ADDRHI)) {
    sub SK_STAT_BMU_ADDRHI () {	0xe8c;}
}
unless(defined(&SK_STAT_BMU_TXA1_RIDX)) {
    sub SK_STAT_BMU_TXA1_RIDX () {	0xe90;}
}
unless(defined(&SK_STAT_BMU_TXS1_RIDX)) {
    sub SK_STAT_BMU_TXS1_RIDX () {	0xe92;}
}
unless(defined(&SK_STAT_BMU_TXA2_RIDX)) {
    sub SK_STAT_BMU_TXA2_RIDX () {	0xe94;}
}
unless(defined(&SK_STAT_BMU_TXS2_RIDX)) {
    sub SK_STAT_BMU_TXS2_RIDX () {	0xe96;}
}
unless(defined(&SK_STAT_BMU_TX_THRESH)) {
    sub SK_STAT_BMU_TX_THRESH () {	0xe98;}
}
unless(defined(&SK_STAT_BMU_PUTIDX)) {
    sub SK_STAT_BMU_PUTIDX () {	0xe9c;}
}
unless(defined(&SK_STAT_BMU_FIFOWP)) {
    sub SK_STAT_BMU_FIFOWP () {	0xea0;}
}
unless(defined(&SK_STAT_BMU_FIFORP)) {
    sub SK_STAT_BMU_FIFORP () {	0xea4;}
}
unless(defined(&SK_STAT_BMU_FIFORSP)) {
    sub SK_STAT_BMU_FIFORSP () {	0xea6;}
}
unless(defined(&SK_STAT_BMU_FIFOLV)) {
    sub SK_STAT_BMU_FIFOLV () {	0xea8;}
}
unless(defined(&SK_STAT_BMU_FIFOSLV)) {
    sub SK_STAT_BMU_FIFOSLV () {	0xeaa;}
}
unless(defined(&SK_STAT_BMU_FIFOWM)) {
    sub SK_STAT_BMU_FIFOWM () {	0xeac;}
}
unless(defined(&SK_STAT_BMU_FIFOIWM)) {
    sub SK_STAT_BMU_FIFOIWM () {	0xead;}
}
unless(defined(&SK_STAT_BMU_RESET)) {
    sub SK_STAT_BMU_RESET () {	0x1;}
}
unless(defined(&SK_STAT_BMU_UNRESET)) {
    sub SK_STAT_BMU_UNRESET () {	0x2;}
}
unless(defined(&SK_STAT_BMU_OFF)) {
    sub SK_STAT_BMU_OFF () {	0x4;}
}
unless(defined(&SK_STAT_BMU_ON)) {
    sub SK_STAT_BMU_ON () {	0x8;}
}
unless(defined(&SK_STAT_BMU_IRQ_CLEAR)) {
    sub SK_STAT_BMU_IRQ_CLEAR () {	0x10;}
}
unless(defined(&SK_GMAC_CTRL)) {
    sub SK_GMAC_CTRL () {	0xf00;}
}
unless(defined(&SK_GPHY_CTRL)) {
    sub SK_GPHY_CTRL () {	0xf04;}
}
unless(defined(&SK_GMAC_ISR)) {
    sub SK_GMAC_ISR () {	0xf08;}
}
unless(defined(&SK_GMAC_IMR)) {
    sub SK_GMAC_IMR () {	0xf0c;}
}
unless(defined(&SK_LINK_CTRL)) {
    sub SK_LINK_CTRL () {	0xf10;}
}
unless(defined(&SK_WOL_CTRL)) {
    sub SK_WOL_CTRL () {	0xf20;}
}
unless(defined(&SK_MAC_ADDR_LOW)) {
    sub SK_MAC_ADDR_LOW () {	0xf24;}
}
unless(defined(&SK_MAC_ADDR_HIGH)) {
    sub SK_MAC_ADDR_HIGH () {	0xf28;}
}
unless(defined(&SK_PAT_READ_PTR)) {
    sub SK_PAT_READ_PTR () {	0xf2c;}
}
unless(defined(&SK_PAT_LEN_REG0)) {
    sub SK_PAT_LEN_REG0 () {	0xf30;}
}
unless(defined(&SK_PAT_LEN0)) {
    sub SK_PAT_LEN0 () {	0xf30;}
}
unless(defined(&SK_PAT_LEN1)) {
    sub SK_PAT_LEN1 () {	0xf31;}
}
unless(defined(&SK_PAT_LEN2)) {
    sub SK_PAT_LEN2 () {	0xf32;}
}
unless(defined(&SK_PAT_LEN3)) {
    sub SK_PAT_LEN3 () {	0xf33;}
}
unless(defined(&SK_PAT_LEN_REG1)) {
    sub SK_PAT_LEN_REG1 () {	0xf34;}
}
unless(defined(&SK_PAT_LEN4)) {
    sub SK_PAT_LEN4 () {	0xf34;}
}
unless(defined(&SK_PAT_LEN5)) {
    sub SK_PAT_LEN5 () {	0xf35;}
}
unless(defined(&SK_PAT_LEN6)) {
    sub SK_PAT_LEN6 () {	0xf36;}
}
unless(defined(&SK_PAT_LEN7)) {
    sub SK_PAT_LEN7 () {	0xf37;}
}
unless(defined(&SK_PAT_CTR_REG0)) {
    sub SK_PAT_CTR_REG0 () {	0xf38;}
}
unless(defined(&SK_PAT_CTR0)) {
    sub SK_PAT_CTR0 () {	0xf38;}
}
unless(defined(&SK_PAT_CTR1)) {
    sub SK_PAT_CTR1 () {	0xf39;}
}
unless(defined(&SK_PAT_CTR2)) {
    sub SK_PAT_CTR2 () {	0xf3a;}
}
unless(defined(&SK_PAT_CTR3)) {
    sub SK_PAT_CTR3 () {	0xf3b;}
}
unless(defined(&SK_PAT_CTR_REG1)) {
    sub SK_PAT_CTR_REG1 () {	0xf3c;}
}
unless(defined(&SK_PAT_CTR4)) {
    sub SK_PAT_CTR4 () {	0xf3c;}
}
unless(defined(&SK_PAT_CTR5)) {
    sub SK_PAT_CTR5 () {	0xf3d;}
}
unless(defined(&SK_PAT_CTR6)) {
    sub SK_PAT_CTR6 () {	0xf3e;}
}
unless(defined(&SK_PAT_CTR7)) {
    sub SK_PAT_CTR7 () {	0xf3f;}
}
unless(defined(&SK_GMAC_BYP_MACSECRX)) {
    sub SK_GMAC_BYP_MACSECRX () {	0x2000;}
}
unless(defined(&SK_GMAC_BYP_MACSECTX)) {
    sub SK_GMAC_BYP_MACSECTX () {	0x800;}
}
unless(defined(&SK_GMAC_BYP_RETR_FIFO)) {
    sub SK_GMAC_BYP_RETR_FIFO () {	0x200;}
}
unless(defined(&SK_GMAC_LOOP_ON)) {
    sub SK_GMAC_LOOP_ON () {	0x20;}
}
unless(defined(&SK_GMAC_LOOP_OFF)) {
    sub SK_GMAC_LOOP_OFF () {	0x10;}
}
unless(defined(&SK_GMAC_PAUSE_ON)) {
    sub SK_GMAC_PAUSE_ON () {	0x8;}
}
unless(defined(&SK_GMAC_PAUSE_OFF)) {
    sub SK_GMAC_PAUSE_OFF () {	0x4;}
}
unless(defined(&SK_GMAC_RESET_CLEAR)) {
    sub SK_GMAC_RESET_CLEAR () {	0x2;}
}
unless(defined(&SK_GMAC_RESET_SET)) {
    sub SK_GMAC_RESET_SET () {	0x1;}
}
unless(defined(&SK_GPHY_SEL_BDT)) {
    sub SK_GPHY_SEL_BDT () {	0x10000000;}
}
unless(defined(&SK_GPHY_INT_POL_HI)) {
    sub SK_GPHY_INT_POL_HI () {	0x8000000;}
}
unless(defined(&SK_GPHY_75_OHM)) {
    sub SK_GPHY_75_OHM () {	0x4000000;}
}
unless(defined(&SK_GPHY_DIS_FC)) {
    sub SK_GPHY_DIS_FC () {	0x2000000;}
}
unless(defined(&SK_GPHY_DIS_SLEEP)) {
    sub SK_GPHY_DIS_SLEEP () {	0x1000000;}
}
unless(defined(&SK_GPHY_HWCFG_M_3)) {
    sub SK_GPHY_HWCFG_M_3 () {	0x800000;}
}
unless(defined(&SK_GPHY_HWCFG_M_2)) {
    sub SK_GPHY_HWCFG_M_2 () {	0x400000;}
}
unless(defined(&SK_GPHY_HWCFG_M_1)) {
    sub SK_GPHY_HWCFG_M_1 () {	0x200000;}
}
unless(defined(&SK_GPHY_HWCFG_M_0)) {
    sub SK_GPHY_HWCFG_M_0 () {	0x100000;}
}
unless(defined(&SK_GPHY_ANEG_0)) {
    sub SK_GPHY_ANEG_0 () {	0x80000;}
}
unless(defined(&SK_GPHY_ENA_XC)) {
    sub SK_GPHY_ENA_XC () {	0x40000;}
}
unless(defined(&SK_GPHY_DIS_125)) {
    sub SK_GPHY_DIS_125 () {	0x20000;}
}
unless(defined(&SK_GPHY_ANEG_3)) {
    sub SK_GPHY_ANEG_3 () {	0x10000;}
}
unless(defined(&SK_GPHY_ANEG_2)) {
    sub SK_GPHY_ANEG_2 () {	0x8000;}
}
unless(defined(&SK_GPHY_ANEG_1)) {
    sub SK_GPHY_ANEG_1 () {	0x4000;}
}
unless(defined(&SK_GPHY_ENA_PAUSE)) {
    sub SK_GPHY_ENA_PAUSE () {	0x2000;}
}
unless(defined(&SK_GPHY_PHYADDR_4)) {
    sub SK_GPHY_PHYADDR_4 () {	0x1000;}
}
unless(defined(&SK_GPHY_PHYADDR_3)) {
    sub SK_GPHY_PHYADDR_3 () {	0x800;}
}
unless(defined(&SK_GPHY_PHYADDR_2)) {
    sub SK_GPHY_PHYADDR_2 () {	0x400;}
}
unless(defined(&SK_GPHY_PHYADDR_1)) {
    sub SK_GPHY_PHYADDR_1 () {	0x200;}
}
unless(defined(&SK_GPHY_PHYADDR_0)) {
    sub SK_GPHY_PHYADDR_0 () {	0x100;}
}
unless(defined(&SK_GPHY_RESET_CLEAR)) {
    sub SK_GPHY_RESET_CLEAR () {	0x2;}
}
unless(defined(&SK_GPHY_RESET_SET)) {
    sub SK_GPHY_RESET_SET () {	0x1;}
}
unless(defined(&SK_GPHY_COPPER)) {
    sub SK_GPHY_COPPER () {	( &SK_GPHY_HWCFG_M_0 |  &SK_GPHY_HWCFG_M_1 |  &SK_GPHY_HWCFG_M_2 |  &SK_GPHY_HWCFG_M_3 );}
}
unless(defined(&SK_GPHY_FIBER)) {
    sub SK_GPHY_FIBER () {	( &SK_GPHY_HWCFG_M_0 |  &SK_GPHY_HWCFG_M_1 |  &SK_GPHY_HWCFG_M_2 );}
}
unless(defined(&SK_GPHY_ANEG_ALL)) {
    sub SK_GPHY_ANEG_ALL () {	( &SK_GPHY_ANEG_0 |  &SK_GPHY_ANEG_1 |  &SK_GPHY_ANEG_2 |  &SK_GPHY_ANEG_3 );}
}
unless(defined(&SK_GMAC_INT_TX_OFLOW)) {
    sub SK_GMAC_INT_TX_OFLOW () {	0x20;}
}
unless(defined(&SK_GMAC_INT_RX_OFLOW)) {
    sub SK_GMAC_INT_RX_OFLOW () {	0x10;}
}
unless(defined(&SK_GMAC_INT_TX_UNDER)) {
    sub SK_GMAC_INT_TX_UNDER () {	0x8;}
}
unless(defined(&SK_GMAC_INT_TX_DONE)) {
    sub SK_GMAC_INT_TX_DONE () {	0x4;}
}
unless(defined(&SK_GMAC_INT_RX_OVER)) {
    sub SK_GMAC_INT_RX_OVER () {	0x2;}
}
unless(defined(&SK_GMAC_INT_RX_DONE)) {
    sub SK_GMAC_INT_RX_DONE () {	0x1;}
}
unless(defined(&SK_LINK_RESET_CLEAR)) {
    sub SK_LINK_RESET_CLEAR () {	0x2;}
}
unless(defined(&SK_LINK_RESET_SET)) {
    sub SK_LINK_RESET_SET () {	0x1;}
}
unless(defined(&SK_WOL_PRAM)) {
    sub SK_WOL_PRAM () {	0x1000;}
}
unless(defined(&SK_Y2_PCI_BASE)) {
    sub SK_Y2_PCI_BASE () {	0x1c00;}
}
unless(defined(&SK_Y2_PCI_REG)) {
    sub SK_Y2_PCI_REG {
	my($reg) = @_;
	eval q((($reg) +  &SK_Y2_PCI_BASE));
    }
}
unless(defined(&SK_XMAC1_BASE)) {
    sub SK_XMAC1_BASE () {	0x2000;}
}
unless(defined(&SK_MARV1_BASE)) {
    sub SK_MARV1_BASE () {	0x2800;}
}
unless(defined(&SK_XMAC2_BASE)) {
    sub SK_XMAC2_BASE () {	0x3000;}
}
unless(defined(&SK_MARV2_BASE)) {
    sub SK_MARV2_BASE () {	0x3800;}
}
unless(defined(&SK_XMAC_REG)) {
    sub SK_XMAC_REG {
	my($sc, $reg) = @_;
	eval q(((($reg) * 2) +  &SK_XMAC1_BASE + ((($sc)-> &sk_port) * ( &SK_XMAC2_BASE -  &SK_XMAC1_BASE))));
    }
}
if(0) {
    eval 'sub SK_XM_READ_4 {
        my($sc, $reg) = @_;
	    eval q((( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg)) & 0xffff) | (( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg + 2)) & 0xffff) << 16)));
    }' unless defined(&SK_XM_READ_4);
    eval 'sub SK_XM_WRITE_4 {
        my($sc, $reg, $val) = @_;
	    eval q( &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg), (($val) & 0xffff));  &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg + 2), (($val) >> 16) & 0xffff));
    }' unless defined(&SK_XM_WRITE_4);
} else {
    eval 'sub SK_XM_READ_4 {
        my($sc, $reg) = @_;
	    eval q( &sk_win_read_4( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg)));
    }' unless defined(&SK_XM_READ_4);
    eval 'sub SK_XM_WRITE_4 {
        my($sc, $reg, $val) = @_;
	    eval q( &sk_win_write_4( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg), ($val)));
    }' unless defined(&SK_XM_WRITE_4);
}
unless(defined(&SK_XM_READ_2)) {
    sub SK_XM_READ_2 {
	my($sc, $reg) = @_;
	eval q( &sk_win_read_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg)));
    }
}
unless(defined(&SK_XM_WRITE_2)) {
    sub SK_XM_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &sk_win_write_2( ($sc->{sk_softc}),  &SK_XMAC_REG($sc, $reg), $val));
    }
}
unless(defined(&SK_XM_SETBIT_4)) {
    sub SK_XM_SETBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_4($sc, $reg, ( &SK_XM_READ_4($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_XM_CLRBIT_4)) {
    sub SK_XM_CLRBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_4($sc, $reg, ( &SK_XM_READ_4($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_XM_SETBIT_2)) {
    sub SK_XM_SETBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_2($sc, $reg, ( &SK_XM_READ_2($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_XM_CLRBIT_2)) {
    sub SK_XM_CLRBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_XM_WRITE_2($sc, $reg, ( &SK_XM_READ_2($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_YU_REG)) {
    sub SK_YU_REG {
	my($sc, $reg) = @_;
	eval q((($reg) +  &SK_MARV1_BASE + ((($sc)-> &sk_port) * ( &SK_MARV2_BASE -  &SK_MARV1_BASE))));
    }
}
unless(defined(&SK_YU_READ_4)) {
    sub SK_YU_READ_4 {
	my($sc, $reg) = @_;
	eval q( &sk_win_read_4(($sc)-> &sk_softc,  &SK_YU_REG(($sc), ($reg))));
    }
}
unless(defined(&SK_YU_READ_2)) {
    sub SK_YU_READ_2 {
	my($sc, $reg) = @_;
	eval q( &sk_win_read_2(($sc)-> &sk_softc,  &SK_YU_REG(($sc), ($reg))));
    }
}
unless(defined(&SK_YU_WRITE_4)) {
    sub SK_YU_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &sk_win_write_4(($sc)-> &sk_softc,  &SK_YU_REG(($sc), ($reg)), ($val)));
    }
}
unless(defined(&SK_YU_WRITE_2)) {
    sub SK_YU_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &sk_win_write_2(($sc)-> &sk_softc,  &SK_YU_REG(($sc), ($reg)), ($val)));
    }
}
unless(defined(&SK_YU_SETBIT_4)) {
    sub SK_YU_SETBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_YU_WRITE_4($sc, $reg, ( &SK_YU_READ_4($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_YU_CLRBIT_4)) {
    sub SK_YU_CLRBIT_4 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_YU_WRITE_4($sc, $reg, ( &SK_YU_READ_4($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_YU_SETBIT_2)) {
    sub SK_YU_SETBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_YU_WRITE_2($sc, $reg, ( &SK_YU_READ_2($sc, $reg)) | ($x)));
    }
}
unless(defined(&SK_YU_CLRBIT_2)) {
    sub SK_YU_CLRBIT_2 {
	my($sc, $reg, $x) = @_;
	eval q( &SK_YU_WRITE_2($sc, $reg, ( &SK_YU_READ_2($sc, $reg)) & ~($x)));
    }
}
unless(defined(&SK_XM_TX_FIFOTHRESH)) {
    sub SK_XM_TX_FIFOTHRESH () {	512;}
}
unless(defined(&SK_PCI_VENDOR_ID)) {
    sub SK_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&SK_PCI_DEVICE_ID)) {
    sub SK_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&SK_PCI_COMMAND)) {
    sub SK_PCI_COMMAND () {	0x4;}
}
unless(defined(&SK_PCI_STATUS)) {
    sub SK_PCI_STATUS () {	0x6;}
}
unless(defined(&SK_PCI_REVID)) {
    sub SK_PCI_REVID () {	0x8;}
}
unless(defined(&SK_PCI_CLASSCODE)) {
    sub SK_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&SK_PCI_CACHELEN)) {
    sub SK_PCI_CACHELEN () {	0xc;}
}
unless(defined(&SK_PCI_LATENCY_TIMER)) {
    sub SK_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&SK_PCI_HEADER_TYPE)) {
    sub SK_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&SK_PCI_LOMEM)) {
    sub SK_PCI_LOMEM () {	0x10;}
}
unless(defined(&SK_PCI_LOIO)) {
    sub SK_PCI_LOIO () {	0x14;}
}
unless(defined(&SK_PCI_SUBVEN_ID)) {
    sub SK_PCI_SUBVEN_ID () {	0x2c;}
}
unless(defined(&SK_PCI_SYBSYS_ID)) {
    sub SK_PCI_SYBSYS_ID () {	0x2e;}
}
unless(defined(&SK_PCI_BIOSROM)) {
    sub SK_PCI_BIOSROM () {	0x30;}
}
unless(defined(&SK_PCI_INTLINE)) {
    sub SK_PCI_INTLINE () {	0x3c;}
}
unless(defined(&SK_PCI_INTPIN)) {
    sub SK_PCI_INTPIN () {	0x3d;}
}
unless(defined(&SK_PCI_MINGNT)) {
    sub SK_PCI_MINGNT () {	0x3e;}
}
unless(defined(&SK_PCI_MINLAT)) {
    sub SK_PCI_MINLAT () {	0x3f;}
}
unless(defined(&SK_PCI_OURREG1)) {
    sub SK_PCI_OURREG1 () {	0x40;}
}
unless(defined(&SK_PCI_OURREG2)) {
    sub SK_PCI_OURREG2 () {	0x44;}
}
unless(defined(&SK_PCI_CAPID)) {
    sub SK_PCI_CAPID () {	0x48;}
}
unless(defined(&SK_PCI_NEXTPTR)) {
    sub SK_PCI_NEXTPTR () {	0x49;}
}
unless(defined(&SK_PCI_PWRMGMTCAP)) {
    sub SK_PCI_PWRMGMTCAP () {	0x4a;}
}
unless(defined(&SK_PCI_PWRMGMTCTRL)) {
    sub SK_PCI_PWRMGMTCTRL () {	0x4c;}
}
unless(defined(&SK_PCI_PME_EVENT)) {
    sub SK_PCI_PME_EVENT () {	0x4f;}
}
unless(defined(&SK_PCI_OURREG3)) {
    sub SK_PCI_OURREG3 () {	0x80;}
}
unless(defined(&SK_PCI_OURREG4)) {
    sub SK_PCI_OURREG4 () {	0x84;}
}
unless(defined(&SK_PCI_OURREG5)) {
    sub SK_PCI_OURREG5 () {	0x88;}
}
unless(defined(&SK_PCI_CFGREG0)) {
    sub SK_PCI_CFGREG0 () {	0x90;}
}
unless(defined(&SK_PCI_CFGREG1)) {
    sub SK_PCI_CFGREG1 () {	0x94;}
}
unless(defined(&SK_Y2_REG1_PHY1_PWRD)) {
    sub SK_Y2_REG1_PHY1_PWRD () {	0x4000000;}
}
unless(defined(&SK_Y2_REG1_PHY2_PWRD)) {
    sub SK_Y2_REG1_PHY2_PWRD () {	0x8000000;}
}
unless(defined(&SK_Y2_REG1_PHY1_COMA)) {
    sub SK_Y2_REG1_PHY1_COMA () {	0x10000000;}
}
unless(defined(&SK_Y2_REG1_PHY2_COMA)) {
    sub SK_Y2_REG1_PHY2_COMA () {	0x20000000;}
}
unless(defined(&SK_Y2_REG4_CLK_GATE_ROOT_COR_ENA)) {
    sub SK_Y2_REG4_CLK_GATE_ROOT_COR_ENA () {	0x1;}
}
unless(defined(&SK_Y2_REG4_CLK_GATE_PEX_UNIT_ENA)) {
    sub SK_Y2_REG4_CLK_GATE_PEX_UNIT_ENA () {	0x2;}
}
unless(defined(&SK_Y2_REG4_ASPM_A1_MODE_SELECT)) {
    sub SK_Y2_REG4_ASPM_A1_MODE_SELECT () {	0x4;}
}
unless(defined(&SK_Y2_REG4_ASPM_CLKREQ_PAD)) {
    sub SK_Y2_REG4_ASPM_CLKREQ_PAD () {	0x8;}
}
unless(defined(&SK_Y2_REG4_ASPM_FORCE_CLKREQ_ENA)) {
    sub SK_Y2_REG4_ASPM_FORCE_CLKREQ_ENA () {	0x10;}
}
unless(defined(&SK_Y2_REG4_ASPM_CLKRUN_REQUEST)) {
    sub SK_Y2_REG4_ASPM_CLKRUN_REQUEST () {	0x1000;}
}
unless(defined(&SK_Y2_REG4_ASPM_INT_FIFO_EMPTY)) {
    sub SK_Y2_REG4_ASPM_INT_FIFO_EMPTY () {	0x2000;}
}
unless(defined(&SK_Y2_REG4_ASPM_GPHY_LINK_DOWN)) {
    sub SK_Y2_REG4_ASPM_GPHY_LINK_DOWN () {	0x4000;}
}
unless(defined(&SK_Y2_REG4_FORCE_ASPM_REQUEST)) {
    sub SK_Y2_REG4_FORCE_ASPM_REQUEST () {	0x8000;}
}
unless(defined(&SK_Y2_REG4_TIMER_VALUE_MASK)) {
    sub SK_Y2_REG4_TIMER_VALUE_MASK () {	0xff0000;}
}
unless(defined(&SK_Y2_REG5_TIM_VMAIN_AV_MASK)) {
    sub SK_Y2_REG5_TIM_VMAIN_AV_MASK () {	0x18000000;}
}
unless(defined(&SK_PSTATE_MASK)) {
    sub SK_PSTATE_MASK () {	0x3;}
}
unless(defined(&SK_PSTATE_D0)) {
    sub SK_PSTATE_D0 () {	0x;}
}
unless(defined(&SK_PSTATE_D1)) {
    sub SK_PSTATE_D1 () {	0x1;}
}
unless(defined(&SK_PSTATE_D2)) {
    sub SK_PSTATE_D2 () {	0x2;}
}
unless(defined(&SK_PSTATE_D3)) {
    sub SK_PSTATE_D3 () {	0x3;}
}
unless(defined(&SK_PME_EN)) {
    sub SK_PME_EN () {	0x10;}
}
unless(defined(&SK_PME_STATUS)) {
    sub SK_PME_STATUS () {	0x8000;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg), ($val)));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg)));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1(($sc)-> &sk_btag, ($sc)-> &sk_bhandle, ($reg)));
    }
}
unless(defined(&SK_ADDR_LO)) {
    sub SK_ADDR_LO {
	my($x) = @_;
	eval q((( &u_int64_t) ($x) & 0xffffffff));
    }
}
unless(defined(&SK_ADDR_HI)) {
    sub SK_ADDR_HI {
	my($x) = @_;
	eval q((( &u_int64_t) ($x) >> 32));
    }
}
unless(defined(&SK_RING_ALIGN)) {
    sub SK_RING_ALIGN () {	64;}
}
unless(defined(&SK_OPCODE_DEFAULT)) {
    sub SK_OPCODE_DEFAULT () {	0x550000;}
}
unless(defined(&SK_OPCODE_CSUM)) {
    sub SK_OPCODE_CSUM () {	0x560000;}
}
unless(defined(&SK_RXCTL_LEN)) {
    sub SK_RXCTL_LEN () {	0xffff;}
}
unless(defined(&SK_RXCTL_OPCODE)) {
    sub SK_RXCTL_OPCODE () {	0xff0000;}
}
unless(defined(&SK_RXCTL_TSTAMP_VALID)) {
    sub SK_RXCTL_TSTAMP_VALID () {	0x1000000;}
}
unless(defined(&SK_RXCTL_STATUS_VALID)) {
    sub SK_RXCTL_STATUS_VALID () {	0x2000000;}
}
unless(defined(&SK_RXCTL_DEV0)) {
    sub SK_RXCTL_DEV0 () {	0x4000000;}
}
unless(defined(&SK_RXCTL_EOF_INTR)) {
    sub SK_RXCTL_EOF_INTR () {	0x8000000;}
}
unless(defined(&SK_RXCTL_EOB_INTR)) {
    sub SK_RXCTL_EOB_INTR () {	0x10000000;}
}
unless(defined(&SK_RXCTL_LASTFRAG)) {
    sub SK_RXCTL_LASTFRAG () {	0x20000000;}
}
unless(defined(&SK_RXCTL_FIRSTFRAG)) {
    sub SK_RXCTL_FIRSTFRAG () {	0x40000000;}
}
unless(defined(&SK_RXCTL_OWN)) {
    sub SK_RXCTL_OWN () {	0x80000000;}
}
unless(defined(&SK_RXSTAT)) {
    sub SK_RXSTAT () {	( &SK_OPCODE_DEFAULT| &SK_RXCTL_EOF_INTR| &SK_RXCTL_LASTFRAG|  &SK_RXCTL_FIRSTFRAG| &SK_RXCTL_OWN);}
}
unless(defined(&SK_TXCTL_LEN)) {
    sub SK_TXCTL_LEN () {	0xffff;}
}
unless(defined(&SK_TXCTL_OPCODE)) {
    sub SK_TXCTL_OPCODE () {	0xff0000;}
}
unless(defined(&SK_TXCTL_SW)) {
    sub SK_TXCTL_SW () {	0x1000000;}
}
unless(defined(&SK_TXCTL_NOCRC)) {
    sub SK_TXCTL_NOCRC () {	0x2000000;}
}
unless(defined(&SK_TXCTL_STORENFWD)) {
    sub SK_TXCTL_STORENFWD () {	0x4000000;}
}
unless(defined(&SK_TXCTL_EOF_INTR)) {
    sub SK_TXCTL_EOF_INTR () {	0x8000000;}
}
unless(defined(&SK_TXCTL_EOB_INTR)) {
    sub SK_TXCTL_EOB_INTR () {	0x10000000;}
}
unless(defined(&SK_TXCTL_LASTFRAG)) {
    sub SK_TXCTL_LASTFRAG () {	0x20000000;}
}
unless(defined(&SK_TXCTL_FIRSTFRAG)) {
    sub SK_TXCTL_FIRSTFRAG () {	0x40000000;}
}
unless(defined(&SK_TXCTL_OWN)) {
    sub SK_TXCTL_OWN () {	0x80000000;}
}
unless(defined(&SK_TXSTAT)) {
    sub SK_TXSTAT () {	( &SK_OPCODE_DEFAULT| &SK_TXCTL_EOF_INTR| &SK_TXCTL_LASTFRAG| &SK_TXCTL_OWN);}
}
unless(defined(&SK_RXBYTES)) {
    sub SK_RXBYTES {
	my($x) = @_;
	eval q((($x) & 0xffff););
    }
}
unless(defined(&SK_TXBYTES)) {
    sub SK_TXBYTES () {	 &SK_RXBYTES;}
}
unless(defined(&SK_TX_RING_CNT)) {
    sub SK_TX_RING_CNT () {	512;}
}
unless(defined(&SK_RX_RING_CNT)) {
    sub SK_RX_RING_CNT () {	256;}
}
unless(defined(&SK_Y2_RXOPC_BUFFER)) {
    sub SK_Y2_RXOPC_BUFFER () {	0x40;}
}
unless(defined(&SK_Y2_RXOPC_PACKET)) {
    sub SK_Y2_RXOPC_PACKET () {	0x41;}
}
unless(defined(&SK_Y2_RXOPC_OWN)) {
    sub SK_Y2_RXOPC_OWN () {	0x80;}
}
unless(defined(&SK_Y2_TXCTL_LASTFRAG)) {
    sub SK_Y2_TXCTL_LASTFRAG () {	0x80;}
}
unless(defined(&SK_Y2_TXOPC_BUFFER)) {
    sub SK_Y2_TXOPC_BUFFER () {	0x40;}
}
unless(defined(&SK_Y2_TXOPC_PACKET)) {
    sub SK_Y2_TXOPC_PACKET () {	0x41;}
}
unless(defined(&SK_Y2_TXOPC_OWN)) {
    sub SK_Y2_TXOPC_OWN () {	0x80;}
}
unless(defined(&SK_Y2_STOPC_RXSTAT)) {
    sub SK_Y2_STOPC_RXSTAT () {	0x60;}
}
unless(defined(&SK_Y2_STOPC_TXSTAT)) {
    sub SK_Y2_STOPC_TXSTAT () {	0x68;}
}
unless(defined(&SK_Y2_STOPC_OWN)) {
    sub SK_Y2_STOPC_OWN () {	0x80;}
}
unless(defined(&MSK_TX_RING_CNT)) {
    sub MSK_TX_RING_CNT () {	512;}
}
unless(defined(&MSK_RX_RING_CNT)) {
    sub MSK_RX_RING_CNT () {	512;}
}
unless(defined(&MSK_STATUS_RING_CNT)) {
    sub MSK_STATUS_RING_CNT () {	2048;}
}
unless(defined(&SK_JUMBO_FRAMELEN)) {
    sub SK_JUMBO_FRAMELEN () {	9018;}
}
unless(defined(&SK_JUMBO_MTU)) {
    sub SK_JUMBO_MTU () {	( &SK_JUMBO_FRAMELEN -  &ETHER_HDR_LEN -  &ETHER_CRC_LEN);}
}
unless(defined(&SK_MIN_FRAMELEN)) {
    sub SK_MIN_FRAMELEN () {	( &ETHER_MIN_LEN -  &ETHER_CRC_LEN);}
}
unless(defined(&SK_JSLOTS)) {
    sub SK_JSLOTS () {	(( &SK_RX_RING_CNT / 2) * 3);}
}
unless(defined(&SK_JRAWLEN)) {
    sub SK_JRAWLEN () {	( &SK_JUMBO_FRAMELEN +  &ETHER_ALIGN);}
}
unless(defined(&SK_JLEN)) {
    sub SK_JLEN () {	 &SK_JRAWLEN;}
}
unless(defined(&SK_JPAGESZ)) {
    sub SK_JPAGESZ () {	 &PAGE_SIZE;}
}
unless(defined(&SK_RESID)) {
    sub SK_RESID () {	( &SK_JPAGESZ - ( &SK_JLEN *  &SK_JSLOTS) %  &SK_JPAGESZ);}
}
unless(defined(&SK_JMEM)) {
    sub SK_JMEM () {	(( &SK_JLEN *  &SK_JSLOTS) +  &SK_RESID);}
}
unless(defined(&MSK_JSLOTS)) {
    sub MSK_JSLOTS () {	(( &MSK_RX_RING_CNT / 2) * 3);}
}
unless(defined(&MSK_RESID)) {
    sub MSK_RESID () {	( &SK_JPAGESZ - ( &SK_JLEN *  &MSK_JSLOTS) %  &SK_JPAGESZ);}
}
unless(defined(&MSK_JMEM)) {
    sub MSK_JMEM () {	(( &SK_JLEN *  &MSK_JSLOTS) +  &MSK_RESID);}
}
unless(defined(&SK_TIMEOUT)) {
    sub SK_TIMEOUT () {	1000;}
}
unless(defined(&YUKON_GPSR)) {
    sub YUKON_GPSR () {	0x;}
}
unless(defined(&YU_GPSR_SPEED)) {
    sub YU_GPSR_SPEED () {	0x8000;}
}
unless(defined(&YU_GPSR_DUPLEX)) {
    sub YU_GPSR_DUPLEX () {	0x4000;}
}
unless(defined(&YU_GPSR_FCTL_TX)) {
    sub YU_GPSR_FCTL_TX () {	0x2000;}
}
unless(defined(&YU_GPSR_LINK)) {
    sub YU_GPSR_LINK () {	0x1000;}
}
unless(defined(&YU_GPSR_PAUSE)) {
    sub YU_GPSR_PAUSE () {	0x800;}
}
unless(defined(&YU_GPSR_TX_IN_PROG)) {
    sub YU_GPSR_TX_IN_PROG () {	0x400;}
}
unless(defined(&YU_GPSR_EXCESS_COL)) {
    sub YU_GPSR_EXCESS_COL () {	0x200;}
}
unless(defined(&YU_GPSR_LATE_COL)) {
    sub YU_GPSR_LATE_COL () {	0x100;}
}
unless(defined(&YU_GPSR_MII_PHY_STC)) {
    sub YU_GPSR_MII_PHY_STC () {	0x20;}
}
unless(defined(&YU_GPSR_GIG_SPEED)) {
    sub YU_GPSR_GIG_SPEED () {	0x10;}
}
unless(defined(&YU_GPSR_PARTITION)) {
    sub YU_GPSR_PARTITION () {	0x8;}
}
unless(defined(&YU_GPSR_FCTL_RX)) {
    sub YU_GPSR_FCTL_RX () {	0x4;}
}
unless(defined(&YU_GPSR_PROMS_EN)) {
    sub YU_GPSR_PROMS_EN () {	0x2;}
}
unless(defined(&YUKON_GPCR)) {
    sub YUKON_GPCR () {	0x4;}
}
unless(defined(&YU_GPCR_FCTL_TX_DIS)) {
    sub YU_GPCR_FCTL_TX_DIS () {	0x2000;}
}
unless(defined(&YU_GPCR_TXEN)) {
    sub YU_GPCR_TXEN () {	0x1000;}
}
unless(defined(&YU_GPCR_RXEN)) {
    sub YU_GPCR_RXEN () {	0x800;}
}
unless(defined(&YU_GPCR_BURSTEN)) {
    sub YU_GPCR_BURSTEN () {	0x400;}
}
unless(defined(&YU_GPCR_LPBK)) {
    sub YU_GPCR_LPBK () {	0x200;}
}
unless(defined(&YU_GPCR_PAR)) {
    sub YU_GPCR_PAR () {	0x100;}
}
unless(defined(&YU_GPCR_GIG)) {
    sub YU_GPCR_GIG () {	0x80;}
}
unless(defined(&YU_GPCR_FLP)) {
    sub YU_GPCR_FLP () {	0x40;}
}
unless(defined(&YU_GPCR_DUPLEX)) {
    sub YU_GPCR_DUPLEX () {	0x20;}
}
unless(defined(&YU_GPCR_FCTL_RX_DIS)) {
    sub YU_GPCR_FCTL_RX_DIS () {	0x10;}
}
unless(defined(&YU_GPCR_SPEED)) {
    sub YU_GPCR_SPEED () {	0x8;}
}
unless(defined(&YU_GPCR_DPLX_DIS)) {
    sub YU_GPCR_DPLX_DIS () {	0x4;}
}
unless(defined(&YU_GPCR_FCTL_DIS)) {
    sub YU_GPCR_FCTL_DIS () {	0x2;}
}
unless(defined(&YU_GPCR_SPEED_DIS)) {
    sub YU_GPCR_SPEED_DIS () {	0x1;}
}
unless(defined(&YUKON_TCR)) {
    sub YUKON_TCR () {	0x8;}
}
unless(defined(&YU_TCR_FJ)) {
    sub YU_TCR_FJ () {	0x8000;}
}
unless(defined(&YU_TCR_CRCD)) {
    sub YU_TCR_CRCD () {	0x4000;}
}
unless(defined(&YU_TCR_PADD)) {
    sub YU_TCR_PADD () {	0x2000;}
}
unless(defined(&YU_TCR_COLTH)) {
    sub YU_TCR_COLTH () {	0x1c00;}
}
unless(defined(&YUKON_RCR)) {
    sub YUKON_RCR () {	0xc;}
}
unless(defined(&YU_RCR_UFLEN)) {
    sub YU_RCR_UFLEN () {	0x8000;}
}
unless(defined(&YU_RCR_MUFLEN)) {
    sub YU_RCR_MUFLEN () {	0x4000;}
}
unless(defined(&YU_RCR_CRCR)) {
    sub YU_RCR_CRCR () {	0x2000;}
}
unless(defined(&YU_RCR_PASSFC)) {
    sub YU_RCR_PASSFC () {	0x1000;}
}
unless(defined(&YUKON_TFCR)) {
    sub YUKON_TFCR () {	0x10;}
}
unless(defined(&YUKON_TPR)) {
    sub YUKON_TPR () {	0x14;}
}
unless(defined(&YU_TPR_JAM_LEN)) {
    sub YU_TPR_JAM_LEN {
	my($x) = @_;
	eval q(((($x) & 0x3) << 14));
    }
}
unless(defined(&YU_TPR_JAM_IPG)) {
    sub YU_TPR_JAM_IPG {
	my($x) = @_;
	eval q(((($x) & 0x1f) << 9));
    }
}
unless(defined(&YU_TPR_JAM2DATA_IPG)) {
    sub YU_TPR_JAM2DATA_IPG {
	my($x) = @_;
	eval q(((($x) & 0x1f) << 4));
    }
}
unless(defined(&YUKON_SMR)) {
    sub YUKON_SMR () {	0x18;}
}
unless(defined(&YU_SMR_DATA_BLIND)) {
    sub YU_SMR_DATA_BLIND {
	my($x) = @_;
	eval q(((($x) & 0x1f) << 11));
    }
}
unless(defined(&YU_SMR_LIMIT4)) {
    sub YU_SMR_LIMIT4 () {	0x400;}
}
unless(defined(&YU_SMR_MFL_JUMBO)) {
    sub YU_SMR_MFL_JUMBO () {	0x100;}
}
unless(defined(&YU_SMR_MFL_VLAN)) {
    sub YU_SMR_MFL_VLAN () {	0x200;}
}
unless(defined(&YU_SMR_IPG_DATA)) {
    sub YU_SMR_IPG_DATA {
	my($x) = @_;
	eval q((($x) & 0x1f));
    }
}
unless(defined(&YUKON_SAL1)) {
    sub YUKON_SAL1 () {	0x1c;}
}
unless(defined(&YUKON_SAM1)) {
    sub YUKON_SAM1 () {	0x20;}
}
unless(defined(&YUKON_SAH1)) {
    sub YUKON_SAH1 () {	0x24;}
}
unless(defined(&YUKON_SAL2)) {
    sub YUKON_SAL2 () {	0x28;}
}
unless(defined(&YUKON_SAM2)) {
    sub YUKON_SAM2 () {	0x2c;}
}
unless(defined(&YUKON_SAH2)) {
    sub YUKON_SAH2 () {	0x30;}
}
unless(defined(&YUKON_MCAH1)) {
    sub YUKON_MCAH1 () {	0x34;}
}
unless(defined(&YUKON_MCAH2)) {
    sub YUKON_MCAH2 () {	0x38;}
}
unless(defined(&YUKON_MCAH3)) {
    sub YUKON_MCAH3 () {	0x3c;}
}
unless(defined(&YUKON_MCAH4)) {
    sub YUKON_MCAH4 () {	0x40;}
}
unless(defined(&YUKON_TIR)) {
    sub YUKON_TIR () {	0x44;}
}
unless(defined(&YU_TIR_OUT_UNICAST)) {
    sub YU_TIR_OUT_UNICAST () {	0x1;}
}
unless(defined(&YU_TIR_OUT_BROADCAST)) {
    sub YU_TIR_OUT_BROADCAST () {	0x2;}
}
unless(defined(&YU_TIR_OUT_PAUSE)) {
    sub YU_TIR_OUT_PAUSE () {	0x4;}
}
unless(defined(&YU_TIR_OUT_MULTICAST)) {
    sub YU_TIR_OUT_MULTICAST () {	0x8;}
}
unless(defined(&YU_TIR_OUT_OCTETS)) {
    sub YU_TIR_OUT_OCTETS () {	0x30;}
}
unless(defined(&YU_TIR_OUT_64_OCTETS)) {
    sub YU_TIR_OUT_64_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_127_OCTETS)) {
    sub YU_TIR_OUT_127_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_255_OCTETS)) {
    sub YU_TIR_OUT_255_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_511_OCTETS)) {
    sub YU_TIR_OUT_511_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_1023_OCTETS)) {
    sub YU_TIR_OUT_1023_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_1518_OCTETS)) {
    sub YU_TIR_OUT_1518_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_MAX_OCTETS)) {
    sub YU_TIR_OUT_MAX_OCTETS () {	0x;}
}
unless(defined(&YU_TIR_OUT_SPARE)) {
    sub YU_TIR_OUT_SPARE () {	0x;}
}
unless(defined(&YU_TIR_OUT_COLLISIONS)) {
    sub YU_TIR_OUT_COLLISIONS () {	0x;}
}
unless(defined(&YU_TIR_OUT_LATE)) {
    sub YU_TIR_OUT_LATE () {	0x;}
}
unless(defined(&YUKON_RIR)) {
    sub YUKON_RIR () {	0x48;}
}
unless(defined(&YUKON_TRIR)) {
    sub YUKON_TRIR () {	0x4c;}
}
unless(defined(&YUKON_TIMR)) {
    sub YUKON_TIMR () {	0x50;}
}
unless(defined(&YUKON_RIMR)) {
    sub YUKON_RIMR () {	0x54;}
}
unless(defined(&YUKON_TRIMR)) {
    sub YUKON_TRIMR () {	0x58;}
}
unless(defined(&YUKON_SMICR)) {
    sub YUKON_SMICR () {	0x80;}
}
unless(defined(&YU_SMICR_PHYAD)) {
    sub YU_SMICR_PHYAD {
	my($x) = @_;
	eval q(((($x) & 0x1f) << 11));
    }
}
unless(defined(&YU_SMICR_REGAD)) {
    sub YU_SMICR_REGAD {
	my($x) = @_;
	eval q(((($x) & 0x1f) << 6));
    }
}
unless(defined(&YU_SMICR_OPCODE)) {
    sub YU_SMICR_OPCODE () {	0x20;}
}
unless(defined(&YU_SMICR_OP_READ)) {
    sub YU_SMICR_OP_READ () {	0x20;}
}
unless(defined(&YU_SMICR_OP_WRITE)) {
    sub YU_SMICR_OP_WRITE () {	0x;}
}
unless(defined(&YU_SMICR_READ_VALID)) {
    sub YU_SMICR_READ_VALID () {	0x10;}
}
unless(defined(&YU_SMICR_BUSY)) {
    sub YU_SMICR_BUSY () {	0x8;}
}
unless(defined(&YUKON_SMIDR)) {
    sub YUKON_SMIDR () {	0x84;}
}
unless(defined(&YUKON_PAR)) {
    sub YUKON_PAR () {	0x88;}
}
unless(defined(&YU_PAR_MIB_CLR)) {
    sub YU_PAR_MIB_CLR () {	0x20;}
}
unless(defined(&YU_PAR_LOAD_TSTCNT)) {
    sub YU_PAR_LOAD_TSTCNT () {	0x10;}
}
unless(defined(&YU_RXSTAT_FOFL)) {
    sub YU_RXSTAT_FOFL () {	0x1;}
}
unless(defined(&YU_RXSTAT_CRCERR)) {
    sub YU_RXSTAT_CRCERR () {	0x2;}
}
unless(defined(&YU_RXSTAT_FRAGMENT)) {
    sub YU_RXSTAT_FRAGMENT () {	0x8;}
}
unless(defined(&YU_RXSTAT_LONGERR)) {
    sub YU_RXSTAT_LONGERR () {	0x10;}
}
unless(defined(&YU_RXSTAT_MIIERR)) {
    sub YU_RXSTAT_MIIERR () {	0x20;}
}
unless(defined(&YU_RXSTAT_BADFC)) {
    sub YU_RXSTAT_BADFC () {	0x40;}
}
unless(defined(&YU_RXSTAT_GOODFC)) {
    sub YU_RXSTAT_GOODFC () {	0x80;}
}
unless(defined(&YU_RXSTAT_RXOK)) {
    sub YU_RXSTAT_RXOK () {	0x100;}
}
unless(defined(&YU_RXSTAT_BROADCAST)) {
    sub YU_RXSTAT_BROADCAST () {	0x200;}
}
unless(defined(&YU_RXSTAT_MULTICAST)) {
    sub YU_RXSTAT_MULTICAST () {	0x400;}
}
unless(defined(&YU_RXSTAT_RUNT)) {
    sub YU_RXSTAT_RUNT () {	0x800;}
}
unless(defined(&YU_RXSTAT_JABBER)) {
    sub YU_RXSTAT_JABBER () {	0x1000;}
}
unless(defined(&YU_RXSTAT_VLAN)) {
    sub YU_RXSTAT_VLAN () {	0x2000;}
}
unless(defined(&YU_RXSTAT_LENSHIFT)) {
    sub YU_RXSTAT_LENSHIFT () {	16;}
}
unless(defined(&YU_RXSTAT_BYTES)) {
    sub YU_RXSTAT_BYTES {
	my($x) = @_;
	eval q((($x) >>  &YU_RXSTAT_LENSHIFT));
    }
}
unless(defined(&XM_DEVICEID)) {
    sub XM_DEVICEID () {	0xe0ae20;}
}
unless(defined(&XM_XAQTI_OUI)) {
    sub XM_XAQTI_OUI () {	0xe0ae;}
}
unless(defined(&XM_XMAC_REV)) {
    sub XM_XMAC_REV {
	my($x) = @_;
	eval q(((($x) & 0xe0) >> 5));
    }
}
unless(defined(&XM_XMAC_REV_B2)) {
    sub XM_XMAC_REV_B2 () {	0x;}
}
unless(defined(&XM_XMAC_REV_C1)) {
    sub XM_XMAC_REV_C1 () {	0x1;}
}
unless(defined(&XM_MMUCMD)) {
    sub XM_MMUCMD () {	0x;}
}
unless(defined(&XM_POFF)) {
    sub XM_POFF () {	0x8;}
}
unless(defined(&XM_BURST)) {
    sub XM_BURST () {	0xc;}
}
unless(defined(&XM_VLAN_TAGLEV1)) {
    sub XM_VLAN_TAGLEV1 () {	0x10;}
}
unless(defined(&XM_VLAN_TAGLEV2)) {
    sub XM_VLAN_TAGLEV2 () {	0x14;}
}
unless(defined(&XM_TXCMD)) {
    sub XM_TXCMD () {	0x20;}
}
unless(defined(&XM_TX_RETRYLIMIT)) {
    sub XM_TX_RETRYLIMIT () {	0x24;}
}
unless(defined(&XM_TX_SLOTTIME)) {
    sub XM_TX_SLOTTIME () {	0x28;}
}
unless(defined(&XM_TX_IPG)) {
    sub XM_TX_IPG () {	0x3c;}
}
unless(defined(&XM_RXCMD)) {
    sub XM_RXCMD () {	0x30;}
}
unless(defined(&XM_PHY_ADDR)) {
    sub XM_PHY_ADDR () {	0x34;}
}
unless(defined(&XM_PHY_DATA)) {
    sub XM_PHY_DATA () {	0x38;}
}
unless(defined(&XM_GPIO)) {
    sub XM_GPIO () {	0x40;}
}
unless(defined(&XM_IMR)) {
    sub XM_IMR () {	0x44;}
}
unless(defined(&XM_ISR)) {
    sub XM_ISR () {	0x48;}
}
unless(defined(&XM_HWCFG)) {
    sub XM_HWCFG () {	0x4c;}
}
unless(defined(&XM_TX_LOWAT)) {
    sub XM_TX_LOWAT () {	0x60;}
}
unless(defined(&XM_TX_HIWAT)) {
    sub XM_TX_HIWAT () {	0x62;}
}
unless(defined(&XM_TX_REQTHRESH_LO)) {
    sub XM_TX_REQTHRESH_LO () {	0x64;}
}
unless(defined(&XM_TX_REQTHRESH_HI)) {
    sub XM_TX_REQTHRESH_HI () {	0x66;}
}
unless(defined(&XM_TX_REQTHRESH)) {
    sub XM_TX_REQTHRESH () {	 &XM_TX_REQTHRESH_LO;}
}
unless(defined(&XM_PAUSEDST0)) {
    sub XM_PAUSEDST0 () {	0x68;}
}
unless(defined(&XM_PAUSEDST1)) {
    sub XM_PAUSEDST1 () {	0x6a;}
}
unless(defined(&XM_PAUSEDST2)) {
    sub XM_PAUSEDST2 () {	0x6c;}
}
unless(defined(&XM_CTLPARM_LO)) {
    sub XM_CTLPARM_LO () {	0x70;}
}
unless(defined(&XM_CTLPARM_HI)) {
    sub XM_CTLPARM_HI () {	0x72;}
}
unless(defined(&XM_CTLPARM)) {
    sub XM_CTLPARM () {	 &XM_CTLPARM_LO;}
}
unless(defined(&XM_OPCODE_PAUSE_TIMER)) {
    sub XM_OPCODE_PAUSE_TIMER () {	0x74;}
}
unless(defined(&XM_TXSTAT_LIFO)) {
    sub XM_TXSTAT_LIFO () {	0x78;}
}
unless(defined(&XM_RXFILT_BASE)) {
    sub XM_RXFILT_BASE () {	0x80;}
}
unless(defined(&XM_RXFILT_END)) {
    sub XM_RXFILT_END () {	0x107;}
}
unless(defined(&XM_RXFILT_MAX)) {
    sub XM_RXFILT_MAX () {	16;}
}
unless(defined(&XM_RXFILT_ENTRY)) {
    sub XM_RXFILT_ENTRY {
	my($ent) = @_;
	eval q(( &XM_RXFILT_BASE + (($ent * 8))));
    }
}
unless(defined(&XM_PAR0)) {
    sub XM_PAR0 () {	0x108;}
}
unless(defined(&XM_PAR1)) {
    sub XM_PAR1 () {	0x10a;}
}
unless(defined(&XM_PAR2)) {
    sub XM_PAR2 () {	0x10c;}
}
unless(defined(&XM_MAR0)) {
    sub XM_MAR0 () {	0x110;}
}
unless(defined(&XM_MAR1)) {
    sub XM_MAR1 () {	0x112;}
}
unless(defined(&XM_MAR2)) {
    sub XM_MAR2 () {	0x114;}
}
unless(defined(&XM_MAR3)) {
    sub XM_MAR3 () {	0x116;}
}
unless(defined(&XM_RX_LOWAT)) {
    sub XM_RX_LOWAT () {	0x118;}
}
unless(defined(&XM_RX_HIWAT)) {
    sub XM_RX_HIWAT () {	0x11a;}
}
unless(defined(&XM_RX_REQTHRESH_LO)) {
    sub XM_RX_REQTHRESH_LO () {	0x11c;}
}
unless(defined(&XM_RX_REQTHRESH_HI)) {
    sub XM_RX_REQTHRESH_HI () {	0x11e;}
}
unless(defined(&XM_RX_REQTHRESH)) {
    sub XM_RX_REQTHRESH () {	 &XM_RX_REQTHRESH_LO;}
}
unless(defined(&XM_DEVID_LO)) {
    sub XM_DEVID_LO () {	0x120;}
}
unless(defined(&XM_DEVID_HI)) {
    sub XM_DEVID_HI () {	0x122;}
}
unless(defined(&XM_DEVID)) {
    sub XM_DEVID () {	 &XM_DEVID_LO;}
}
unless(defined(&XM_MODE_LO)) {
    sub XM_MODE_LO () {	0x124;}
}
unless(defined(&XM_MODE_HI)) {
    sub XM_MODE_HI () {	0x126;}
}
unless(defined(&XM_MODE)) {
    sub XM_MODE () {	 &XM_MODE_LO;}
}
unless(defined(&XM_LASTSRC0)) {
    sub XM_LASTSRC0 () {	0x128;}
}
unless(defined(&XM_LASTSRC1)) {
    sub XM_LASTSRC1 () {	0x12a;}
}
unless(defined(&XM_LASTSRC2)) {
    sub XM_LASTSRC2 () {	0x12c;}
}
unless(defined(&XM_TSTAMP_READ)) {
    sub XM_TSTAMP_READ () {	0x130;}
}
unless(defined(&XM_TSTAMP_LOAD)) {
    sub XM_TSTAMP_LOAD () {	0x134;}
}
unless(defined(&XM_STATS_CMD)) {
    sub XM_STATS_CMD () {	0x200;}
}
unless(defined(&XM_RXCNT_EVENT_LO)) {
    sub XM_RXCNT_EVENT_LO () {	0x204;}
}
unless(defined(&XM_RXCNT_EVENT_HI)) {
    sub XM_RXCNT_EVENT_HI () {	0x206;}
}
unless(defined(&XM_RXCNT_EVENT)) {
    sub XM_RXCNT_EVENT () {	 &XM_RXCNT_EVENT_LO;}
}
unless(defined(&XM_TXCNT_EVENT_LO)) {
    sub XM_TXCNT_EVENT_LO () {	0x208;}
}
unless(defined(&XM_TXCNT_EVENT_HI)) {
    sub XM_TXCNT_EVENT_HI () {	0x20a;}
}
unless(defined(&XM_TXCNT_EVENT)) {
    sub XM_TXCNT_EVENT () {	 &XM_TXCNT_EVENT_LO;}
}
unless(defined(&XM_RXCNT_EVMASK_LO)) {
    sub XM_RXCNT_EVMASK_LO () {	0x20c;}
}
unless(defined(&XM_RXCNT_EVMASK_HI)) {
    sub XM_RXCNT_EVMASK_HI () {	0x20e;}
}
unless(defined(&XM_RXCNT_EVMASK)) {
    sub XM_RXCNT_EVMASK () {	 &XM_RXCNT_EVMASK_LO;}
}
unless(defined(&XM_TXCNT_EVMASK_LO)) {
    sub XM_TXCNT_EVMASK_LO () {	0x210;}
}
unless(defined(&XM_TXCNT_EVMASK_HI)) {
    sub XM_TXCNT_EVMASK_HI () {	0x212;}
}
unless(defined(&XM_TXCNT_EVMASK)) {
    sub XM_TXCNT_EVMASK () {	 &XM_TXCNT_EVMASK_LO;}
}
unless(defined(&XM_STATCMD_CLR_TX)) {
    sub XM_STATCMD_CLR_TX () {	0x1;}
}
unless(defined(&XM_STATCMD_CLR_RX)) {
    sub XM_STATCMD_CLR_RX () {	0x2;}
}
unless(defined(&XM_STATCMD_COPY_TX)) {
    sub XM_STATCMD_COPY_TX () {	0x4;}
}
unless(defined(&XM_STATCMD_COPY_RX)) {
    sub XM_STATCMD_COPY_RX () {	0x8;}
}
unless(defined(&XM_STATCMD_SNAP_TX)) {
    sub XM_STATCMD_SNAP_TX () {	0x10;}
}
unless(defined(&XM_STATCMD_SNAP_RX)) {
    sub XM_STATCMD_SNAP_RX () {	0x20;}
}
unless(defined(&XM_TXSTATS_PKTSOK)) {
    sub XM_TXSTATS_PKTSOK () {	0x280;}
}
unless(defined(&XM_TXSTATS_BYTESOK_HI)) {
    sub XM_TXSTATS_BYTESOK_HI () {	0x284;}
}
unless(defined(&XM_TXSTATS_BYTESOK_LO)) {
    sub XM_TXSTATS_BYTESOK_LO () {	0x288;}
}
unless(defined(&XM_TXSTATS_BCASTSOK)) {
    sub XM_TXSTATS_BCASTSOK () {	0x28c;}
}
unless(defined(&XM_TXSTATS_MCASTSOK)) {
    sub XM_TXSTATS_MCASTSOK () {	0x290;}
}
unless(defined(&XM_TXSTATS_UCASTSOK)) {
    sub XM_TXSTATS_UCASTSOK () {	0x294;}
}
unless(defined(&XM_TXSTATS_GIANTS)) {
    sub XM_TXSTATS_GIANTS () {	0x298;}
}
unless(defined(&XM_TXSTATS_BURSTCNT)) {
    sub XM_TXSTATS_BURSTCNT () {	0x29c;}
}
unless(defined(&XM_TXSTATS_PAUSEPKTS)) {
    sub XM_TXSTATS_PAUSEPKTS () {	0x2a0;}
}
unless(defined(&XM_TXSTATS_MACCTLPKTS)) {
    sub XM_TXSTATS_MACCTLPKTS () {	0x2a4;}
}
unless(defined(&XM_TXSTATS_SINGLECOLS)) {
    sub XM_TXSTATS_SINGLECOLS () {	0x2a8;}
}
unless(defined(&XM_TXSTATS_MULTICOLS)) {
    sub XM_TXSTATS_MULTICOLS () {	0x2ac;}
}
unless(defined(&XM_TXSTATS_EXCESSCOLS)) {
    sub XM_TXSTATS_EXCESSCOLS () {	0x2b0;}
}
unless(defined(&XM_TXSTATS_LATECOLS)) {
    sub XM_TXSTATS_LATECOLS () {	0x2b4;}
}
unless(defined(&XM_TXSTATS_DEFER)) {
    sub XM_TXSTATS_DEFER () {	0x2b8;}
}
unless(defined(&XM_TXSTATS_EXCESSDEFER)) {
    sub XM_TXSTATS_EXCESSDEFER () {	0x2bc;}
}
unless(defined(&XM_TXSTATS_UNDERRUN)) {
    sub XM_TXSTATS_UNDERRUN () {	0x2c0;}
}
unless(defined(&XM_TXSTATS_CARRIERSENSE)) {
    sub XM_TXSTATS_CARRIERSENSE () {	0x2c4;}
}
unless(defined(&XM_TXSTATS_UTILIZATION)) {
    sub XM_TXSTATS_UTILIZATION () {	0x2c8;}
}
unless(defined(&XM_TXSTATS_64)) {
    sub XM_TXSTATS_64 () {	0x2d0;}
}
unless(defined(&XM_TXSTATS_65_127)) {
    sub XM_TXSTATS_65_127 () {	0x2d4;}
}
unless(defined(&XM_TXSTATS_128_255)) {
    sub XM_TXSTATS_128_255 () {	0x2d8;}
}
unless(defined(&XM_TXSTATS_256_511)) {
    sub XM_TXSTATS_256_511 () {	0x2dc;}
}
unless(defined(&XM_TXSTATS_512_1023)) {
    sub XM_TXSTATS_512_1023 () {	0x2e0;}
}
unless(defined(&XM_TXSTATS_1024_MAX)) {
    sub XM_TXSTATS_1024_MAX () {	0x2e4;}
}
unless(defined(&XM_RXSTATS_PKTSOK)) {
    sub XM_RXSTATS_PKTSOK () {	0x300;}
}
unless(defined(&XM_RXSTATS_BYTESOK_HI)) {
    sub XM_RXSTATS_BYTESOK_HI () {	0x304;}
}
unless(defined(&XM_RXSTATS_BYTESOK_LO)) {
    sub XM_RXSTATS_BYTESOK_LO () {	0x308;}
}
unless(defined(&XM_RXSTATS_BCASTSOK)) {
    sub XM_RXSTATS_BCASTSOK () {	0x30c;}
}
unless(defined(&XM_RXSTATS_MCASTSOK)) {
    sub XM_RXSTATS_MCASTSOK () {	0x310;}
}
unless(defined(&XM_RXSTATS_UCASTSOK)) {
    sub XM_RXSTATS_UCASTSOK () {	0x314;}
}
unless(defined(&XM_RXSTATS_PAUSEPKTS)) {
    sub XM_RXSTATS_PAUSEPKTS () {	0x318;}
}
unless(defined(&XM_RXSTATS_MACCTLPKTS)) {
    sub XM_RXSTATS_MACCTLPKTS () {	0x31c;}
}
unless(defined(&XM_RXSTATS_BADPAUSEPKTS)) {
    sub XM_RXSTATS_BADPAUSEPKTS () {	0x320;}
}
unless(defined(&XM_RXSTATS_BADMACCTLPKTS)) {
    sub XM_RXSTATS_BADMACCTLPKTS () {	0x324;}
}
unless(defined(&XM_RXSTATS_BURSTCNT)) {
    sub XM_RXSTATS_BURSTCNT () {	0x328;}
}
unless(defined(&XM_RXSTATS_MISSEDPKTS)) {
    sub XM_RXSTATS_MISSEDPKTS () {	0x32c;}
}
unless(defined(&XM_RXSTATS_FRAMEERRS)) {
    sub XM_RXSTATS_FRAMEERRS () {	0x330;}
}
unless(defined(&XM_RXSTATS_OVERRUN)) {
    sub XM_RXSTATS_OVERRUN () {	0x334;}
}
unless(defined(&XM_RXSTATS_JABBER)) {
    sub XM_RXSTATS_JABBER () {	0x338;}
}
unless(defined(&XM_RXSTATS_CARRLOSS)) {
    sub XM_RXSTATS_CARRLOSS () {	0x33c;}
}
unless(defined(&XM_RXSTATS_INRNGLENERR)) {
    sub XM_RXSTATS_INRNGLENERR () {	0x340;}
}
unless(defined(&XM_RXSTATS_SYMERR)) {
    sub XM_RXSTATS_SYMERR () {	0x344;}
}
unless(defined(&XM_RXSTATS_SHORTEVENT)) {
    sub XM_RXSTATS_SHORTEVENT () {	0x348;}
}
unless(defined(&XM_RXSTATS_RUNTS)) {
    sub XM_RXSTATS_RUNTS () {	0x34c;}
}
unless(defined(&XM_RXSTATS_GIANTS)) {
    sub XM_RXSTATS_GIANTS () {	0x350;}
}
unless(defined(&XM_RXSTATS_CRCERRS)) {
    sub XM_RXSTATS_CRCERRS () {	0x354;}
}
unless(defined(&XM_RXSTATS_CEXTERRS)) {
    sub XM_RXSTATS_CEXTERRS () {	0x35c;}
}
unless(defined(&XM_RXSTATS_UTILIZATION)) {
    sub XM_RXSTATS_UTILIZATION () {	0x360;}
}
unless(defined(&XM_RXSTATS_64)) {
    sub XM_RXSTATS_64 () {	0x368;}
}
unless(defined(&XM_RXSTATS_65_127)) {
    sub XM_RXSTATS_65_127 () {	0x36c;}
}
unless(defined(&XM_RXSTATS_128_255)) {
    sub XM_RXSTATS_128_255 () {	0x370;}
}
unless(defined(&XM_RXSTATS_256_511)) {
    sub XM_RXSTATS_256_511 () {	0x374;}
}
unless(defined(&XM_RXSTATS_512_1023)) {
    sub XM_RXSTATS_512_1023 () {	0x378;}
}
unless(defined(&XM_RXSTATS_1024_MAX)) {
    sub XM_RXSTATS_1024_MAX () {	0x37c;}
}
unless(defined(&XM_MMUCMD_TX_ENB)) {
    sub XM_MMUCMD_TX_ENB () {	0x1;}
}
unless(defined(&XM_MMUCMD_RX_ENB)) {
    sub XM_MMUCMD_RX_ENB () {	0x2;}
}
unless(defined(&XM_MMUCMD_GMIILOOP)) {
    sub XM_MMUCMD_GMIILOOP () {	0x4;}
}
unless(defined(&XM_MMUCMD_RATECTL)) {
    sub XM_MMUCMD_RATECTL () {	0x8;}
}
unless(defined(&XM_MMUCMD_GMIIFDX)) {
    sub XM_MMUCMD_GMIIFDX () {	0x10;}
}
unless(defined(&XM_MMUCMD_NO_MGMT_PRMB)) {
    sub XM_MMUCMD_NO_MGMT_PRMB () {	0x20;}
}
unless(defined(&XM_MMUCMD_SIMCOL)) {
    sub XM_MMUCMD_SIMCOL () {	0x40;}
}
unless(defined(&XM_MMUCMD_FORCETX)) {
    sub XM_MMUCMD_FORCETX () {	0x80;}
}
unless(defined(&XM_MMUCMD_LOOPENB)) {
    sub XM_MMUCMD_LOOPENB () {	0x200;}
}
unless(defined(&XM_MMUCMD_IGNPAUSE)) {
    sub XM_MMUCMD_IGNPAUSE () {	0x400;}
}
unless(defined(&XM_MMUCMD_PHYBUSY)) {
    sub XM_MMUCMD_PHYBUSY () {	0x800;}
}
unless(defined(&XM_MMUCMD_PHYDATARDY)) {
    sub XM_MMUCMD_PHYDATARDY () {	0x1000;}
}
unless(defined(&XM_TXCMD_AUTOPAD)) {
    sub XM_TXCMD_AUTOPAD () {	0x1;}
}
unless(defined(&XM_TXCMD_NOCRC)) {
    sub XM_TXCMD_NOCRC () {	0x2;}
}
unless(defined(&XM_TXCMD_NOPREAMBLE)) {
    sub XM_TXCMD_NOPREAMBLE () {	0x4;}
}
unless(defined(&XM_TXCMD_NOGIGAMODE)) {
    sub XM_TXCMD_NOGIGAMODE () {	0x8;}
}
unless(defined(&XM_TXCMD_SAMPLELINE)) {
    sub XM_TXCMD_SAMPLELINE () {	0x10;}
}
unless(defined(&XM_TXCMD_ENCBYPASS)) {
    sub XM_TXCMD_ENCBYPASS () {	0x20;}
}
unless(defined(&XM_TXCMD_XMITBK2BK)) {
    sub XM_TXCMD_XMITBK2BK () {	0x40;}
}
unless(defined(&XM_TXCMD_FAIRSHARE)) {
    sub XM_TXCMD_FAIRSHARE () {	0x80;}
}
unless(defined(&XM_RXCMD_DISABLE_CEXT)) {
    sub XM_RXCMD_DISABLE_CEXT () {	0x1;}
}
unless(defined(&XM_RXCMD_STRIPPAD)) {
    sub XM_RXCMD_STRIPPAD () {	0x2;}
}
unless(defined(&XM_RXCMD_SAMPLELINE)) {
    sub XM_RXCMD_SAMPLELINE () {	0x4;}
}
unless(defined(&XM_RXCMD_SELFRX)) {
    sub XM_RXCMD_SELFRX () {	0x8;}
}
unless(defined(&XM_RXCMD_STRIPFCS)) {
    sub XM_RXCMD_STRIPFCS () {	0x10;}
}
unless(defined(&XM_RXCMD_TRANSPARENT)) {
    sub XM_RXCMD_TRANSPARENT () {	0x20;}
}
unless(defined(&XM_RXCMD_IPGCAPTURE)) {
    sub XM_RXCMD_IPGCAPTURE () {	0x40;}
}
unless(defined(&XM_RXCMD_BIGPKTOK)) {
    sub XM_RXCMD_BIGPKTOK () {	0x80;}
}
unless(defined(&XM_RXCMD_LENERROK)) {
    sub XM_RXCMD_LENERROK () {	0x100;}
}
unless(defined(&XM_GPIO_GP0_SET)) {
    sub XM_GPIO_GP0_SET () {	0x1;}
}
unless(defined(&XM_GPIO_RESETSTATS)) {
    sub XM_GPIO_RESETSTATS () {	0x4;}
}
unless(defined(&XM_GPIO_RESETMAC)) {
    sub XM_GPIO_RESETMAC () {	0x8;}
}
unless(defined(&XM_GPIO_FORCEINT)) {
    sub XM_GPIO_FORCEINT () {	0x20;}
}
unless(defined(&XM_GPIO_ANEGINPROG)) {
    sub XM_GPIO_ANEGINPROG () {	0x40;}
}
unless(defined(&XM_IMR_RX_EOF)) {
    sub XM_IMR_RX_EOF () {	0x1;}
}
unless(defined(&XM_IMR_TX_EOF)) {
    sub XM_IMR_TX_EOF () {	0x2;}
}
unless(defined(&XM_IMR_TX_UNDERRUN)) {
    sub XM_IMR_TX_UNDERRUN () {	0x4;}
}
unless(defined(&XM_IMR_RX_OVERRUN)) {
    sub XM_IMR_RX_OVERRUN () {	0x8;}
}
unless(defined(&XM_IMR_TX_STATS_OFLOW)) {
    sub XM_IMR_TX_STATS_OFLOW () {	0x10;}
}
unless(defined(&XM_IMR_RX_STATS_OFLOW)) {
    sub XM_IMR_RX_STATS_OFLOW () {	0x20;}
}
unless(defined(&XM_IMR_TSTAMP_OFLOW)) {
    sub XM_IMR_TSTAMP_OFLOW () {	0x40;}
}
unless(defined(&XM_IMR_AUTONEG_DONE)) {
    sub XM_IMR_AUTONEG_DONE () {	0x80;}
}
unless(defined(&XM_IMR_NEXTPAGE_RDY)) {
    sub XM_IMR_NEXTPAGE_RDY () {	0x100;}
}
unless(defined(&XM_IMR_PAGE_RECEIVED)) {
    sub XM_IMR_PAGE_RECEIVED () {	0x200;}
}
unless(defined(&XM_IMR_LP_REQCFG)) {
    sub XM_IMR_LP_REQCFG () {	0x400;}
}
unless(defined(&XM_IMR_GP0_SET)) {
    sub XM_IMR_GP0_SET () {	0x800;}
}
unless(defined(&XM_IMR_FORCEINTR)) {
    sub XM_IMR_FORCEINTR () {	0x1000;}
}
unless(defined(&XM_IMR_TX_ABORT)) {
    sub XM_IMR_TX_ABORT () {	0x2000;}
}
unless(defined(&XM_IMR_LINKEVENT)) {
    sub XM_IMR_LINKEVENT () {	0x4000;}
}
unless(defined(&XM_INTRS)) {
    sub XM_INTRS () {	(~( &XM_IMR_GP0_SET| &XM_IMR_AUTONEG_DONE| &XM_IMR_TX_UNDERRUN));}
}
unless(defined(&XM_ISR_RX_EOF)) {
    sub XM_ISR_RX_EOF () {	0x1;}
}
unless(defined(&XM_ISR_TX_EOF)) {
    sub XM_ISR_TX_EOF () {	0x2;}
}
unless(defined(&XM_ISR_TX_UNDERRUN)) {
    sub XM_ISR_TX_UNDERRUN () {	0x4;}
}
unless(defined(&XM_ISR_RX_OVERRUN)) {
    sub XM_ISR_RX_OVERRUN () {	0x8;}
}
unless(defined(&XM_ISR_TX_STATS_OFLOW)) {
    sub XM_ISR_TX_STATS_OFLOW () {	0x10;}
}
unless(defined(&XM_ISR_RX_STATS_OFLOW)) {
    sub XM_ISR_RX_STATS_OFLOW () {	0x20;}
}
unless(defined(&XM_ISR_TSTAMP_OFLOW)) {
    sub XM_ISR_TSTAMP_OFLOW () {	0x40;}
}
unless(defined(&XM_ISR_AUTONEG_DONE)) {
    sub XM_ISR_AUTONEG_DONE () {	0x80;}
}
unless(defined(&XM_ISR_NEXTPAGE_RDY)) {
    sub XM_ISR_NEXTPAGE_RDY () {	0x100;}
}
unless(defined(&XM_ISR_PAGE_RECEIVED)) {
    sub XM_ISR_PAGE_RECEIVED () {	0x200;}
}
unless(defined(&XM_ISR_LP_REQCFG)) {
    sub XM_ISR_LP_REQCFG () {	0x400;}
}
unless(defined(&XM_ISR_GP0_SET)) {
    sub XM_ISR_GP0_SET () {	0x800;}
}
unless(defined(&XM_ISR_FORCEINTR)) {
    sub XM_ISR_FORCEINTR () {	0x1000;}
}
unless(defined(&XM_ISR_TX_ABORT)) {
    sub XM_ISR_TX_ABORT () {	0x2000;}
}
unless(defined(&XM_ISR_LINKEVENT)) {
    sub XM_ISR_LINKEVENT () {	0x4000;}
}
unless(defined(&XM_HWCFG_GENEOP)) {
    sub XM_HWCFG_GENEOP () {	0x8;}
}
unless(defined(&XM_HWCFG_SIGSTATCKH)) {
    sub XM_HWCFG_SIGSTATCKH () {	0x4;}
}
unless(defined(&XM_HWCFG_GMIIMODE)) {
    sub XM_HWCFG_GMIIMODE () {	0x1;}
}
unless(defined(&XM_MODE_FLUSH_RXFIFO)) {
    sub XM_MODE_FLUSH_RXFIFO () {	0x1;}
}
unless(defined(&XM_MODE_FLUSH_TXFIFO)) {
    sub XM_MODE_FLUSH_TXFIFO () {	0x2;}
}
unless(defined(&XM_MODE_BIGENDIAN)) {
    sub XM_MODE_BIGENDIAN () {	0x4;}
}
unless(defined(&XM_MODE_RX_PROMISC)) {
    sub XM_MODE_RX_PROMISC () {	0x8;}
}
unless(defined(&XM_MODE_RX_NOBROAD)) {
    sub XM_MODE_RX_NOBROAD () {	0x10;}
}
unless(defined(&XM_MODE_RX_NOMULTI)) {
    sub XM_MODE_RX_NOMULTI () {	0x20;}
}
unless(defined(&XM_MODE_RX_NOUNI)) {
    sub XM_MODE_RX_NOUNI () {	0x40;}
}
unless(defined(&XM_MODE_RX_BADFRAMES)) {
    sub XM_MODE_RX_BADFRAMES () {	0x80;}
}
unless(defined(&XM_MODE_RX_CRCERRS)) {
    sub XM_MODE_RX_CRCERRS () {	0x100;}
}
unless(defined(&XM_MODE_RX_GIANTS)) {
    sub XM_MODE_RX_GIANTS () {	0x200;}
}
unless(defined(&XM_MODE_RX_INRANGELEN)) {
    sub XM_MODE_RX_INRANGELEN () {	0x400;}
}
unless(defined(&XM_MODE_RX_RUNTS)) {
    sub XM_MODE_RX_RUNTS () {	0x800;}
}
unless(defined(&XM_MODE_RX_MACCTL)) {
    sub XM_MODE_RX_MACCTL () {	0x1000;}
}
unless(defined(&XM_MODE_RX_USE_PERFECT)) {
    sub XM_MODE_RX_USE_PERFECT () {	0x2000;}
}
unless(defined(&XM_MODE_RX_USE_STATION)) {
    sub XM_MODE_RX_USE_STATION () {	0x4000;}
}
unless(defined(&XM_MODE_RX_USE_HASH)) {
    sub XM_MODE_RX_USE_HASH () {	0x8000;}
}
unless(defined(&XM_MODE_RX_ADDRPAIR)) {
    sub XM_MODE_RX_ADDRPAIR () {	0x10000;}
}
unless(defined(&XM_MODE_PAUSEONHI)) {
    sub XM_MODE_PAUSEONHI () {	0x20000;}
}
unless(defined(&XM_MODE_PAUSEONLO)) {
    sub XM_MODE_PAUSEONLO () {	0x40000;}
}
unless(defined(&XM_MODE_TIMESTAMP)) {
    sub XM_MODE_TIMESTAMP () {	0x80000;}
}
unless(defined(&XM_MODE_SENDPAUSE)) {
    sub XM_MODE_SENDPAUSE () {	0x100000;}
}
unless(defined(&XM_MODE_SENDCONTINUOUS)) {
    sub XM_MODE_SENDCONTINUOUS () {	0x200000;}
}
unless(defined(&XM_MODE_LE_STATUSWORD)) {
    sub XM_MODE_LE_STATUSWORD () {	0x400000;}
}
unless(defined(&XM_MODE_AUTOFIFOPAUSE)) {
    sub XM_MODE_AUTOFIFOPAUSE () {	0x800000;}
}
unless(defined(&XM_MODE_EXPAUSEGEN)) {
    sub XM_MODE_EXPAUSEGEN () {	0x2000000;}
}
unless(defined(&XM_MODE_RX_INVERSE)) {
    sub XM_MODE_RX_INVERSE () {	0x4000000;}
}
unless(defined(&XM_RXSTAT_MACCTL)) {
    sub XM_RXSTAT_MACCTL () {	0x1;}
}
unless(defined(&XM_RXSTAT_ERRFRAME)) {
    sub XM_RXSTAT_ERRFRAME () {	0x2;}
}
unless(defined(&XM_RXSTAT_CRCERR)) {
    sub XM_RXSTAT_CRCERR () {	0x4;}
}
unless(defined(&XM_RXSTAT_GIANT)) {
    sub XM_RXSTAT_GIANT () {	0x8;}
}
unless(defined(&XM_RXSTAT_RUNT)) {
    sub XM_RXSTAT_RUNT () {	0x10;}
}
unless(defined(&XM_RXSTAT_FRAMEERR)) {
    sub XM_RXSTAT_FRAMEERR () {	0x20;}
}
unless(defined(&XM_RXSTAT_INRANGEERR)) {
    sub XM_RXSTAT_INRANGEERR () {	0x40;}
}
unless(defined(&XM_RXSTAT_CARRIERERR)) {
    sub XM_RXSTAT_CARRIERERR () {	0x80;}
}
unless(defined(&XM_RXSTAT_COLLERR)) {
    sub XM_RXSTAT_COLLERR () {	0x100;}
}
unless(defined(&XM_RXSTAT_802_3)) {
    sub XM_RXSTAT_802_3 () {	0x200;}
}
unless(defined(&XM_RXSTAT_CARREXTERR)) {
    sub XM_RXSTAT_CARREXTERR () {	0x400;}
}
unless(defined(&XM_RXSTAT_BURSTMODE)) {
    sub XM_RXSTAT_BURSTMODE () {	0x800;}
}
unless(defined(&XM_RXSTAT_UNICAST)) {
    sub XM_RXSTAT_UNICAST () {	0x2000;}
}
unless(defined(&XM_RXSTAT_MULTICAST)) {
    sub XM_RXSTAT_MULTICAST () {	0x4000;}
}
unless(defined(&XM_RXSTAT_BROADCAST)) {
    sub XM_RXSTAT_BROADCAST () {	0x8000;}
}
unless(defined(&XM_RXSTAT_VLAN_LEV1)) {
    sub XM_RXSTAT_VLAN_LEV1 () {	0x10000;}
}
unless(defined(&XM_RXSTAT_VLAN_LEV2)) {
    sub XM_RXSTAT_VLAN_LEV2 () {	0x20000;}
}
unless(defined(&XM_RXSTAT_LEN)) {
    sub XM_RXSTAT_LEN () {	0xfffc0000;}
}
unless(defined(&XM_RXSTAT_LENSHIFT)) {
    sub XM_RXSTAT_LENSHIFT () {	18;}
}
unless(defined(&XM_RXSTAT_BYTES)) {
    sub XM_RXSTAT_BYTES {
	my($x) = @_;
	eval q((($x) >>  &XM_RXSTAT_LENSHIFT));
    }
}
unless(defined(&XM_PHY_BMCR)) {
    sub XM_PHY_BMCR () {	0x;}
}
unless(defined(&XM_PHY_BMSR)) {
    sub XM_PHY_BMSR () {	0x1;}
}
unless(defined(&XM_PHY_VENID)) {
    sub XM_PHY_VENID () {	0x2;}
}
unless(defined(&XM_PHY_DEVID)) {
    sub XM_PHY_DEVID () {	0x3;}
}
unless(defined(&XM_PHY_ANAR)) {
    sub XM_PHY_ANAR () {	0x4;}
}
unless(defined(&XM_PHY_LPAR)) {
    sub XM_PHY_LPAR () {	0x5;}
}
unless(defined(&XM_PHY_ANEXP)) {
    sub XM_PHY_ANEXP () {	0x6;}
}
unless(defined(&XM_PHY_NEXTP)) {
    sub XM_PHY_NEXTP () {	0x7;}
}
unless(defined(&XM_PHY_LPNEXTP)) {
    sub XM_PHY_LPNEXTP () {	0x8;}
}
unless(defined(&XM_PHY_EXTSTS)) {
    sub XM_PHY_EXTSTS () {	0xf;}
}
unless(defined(&XM_PHY_RESAB)) {
    sub XM_PHY_RESAB () {	0x10;}
}
unless(defined(&XM_BMCR_DUPLEX)) {
    sub XM_BMCR_DUPLEX () {	0x100;}
}
unless(defined(&XM_BMCR_RENEGOTIATE)) {
    sub XM_BMCR_RENEGOTIATE () {	0x200;}
}
unless(defined(&XM_BMCR_AUTONEGENBL)) {
    sub XM_BMCR_AUTONEGENBL () {	0x1000;}
}
unless(defined(&XM_BMCR_LOOPBACK)) {
    sub XM_BMCR_LOOPBACK () {	0x4000;}
}
unless(defined(&XM_BMCR_RESET)) {
    sub XM_BMCR_RESET () {	0x8000;}
}
unless(defined(&XM_BMSR_EXTCAP)) {
    sub XM_BMSR_EXTCAP () {	0x1;}
}
unless(defined(&XM_BMSR_LINKSTAT)) {
    sub XM_BMSR_LINKSTAT () {	0x4;}
}
unless(defined(&XM_BMSR_AUTONEGABLE)) {
    sub XM_BMSR_AUTONEGABLE () {	0x8;}
}
unless(defined(&XM_BMSR_REMFAULT)) {
    sub XM_BMSR_REMFAULT () {	0x10;}
}
unless(defined(&XM_BMSR_AUTONEGDONE)) {
    sub XM_BMSR_AUTONEGDONE () {	0x20;}
}
unless(defined(&XM_BMSR_EXTSTAT)) {
    sub XM_BMSR_EXTSTAT () {	0x100;}
}
unless(defined(&XM_VENID_XAQTI)) {
    sub XM_VENID_XAQTI () {	0xd14c;}
}
unless(defined(&XM_DEVID_XMAC)) {
    sub XM_DEVID_XMAC () {	0x2;}
}
unless(defined(&XM_ANAR_FULLDUPLEX)) {
    sub XM_ANAR_FULLDUPLEX () {	0x20;}
}
unless(defined(&XM_ANAR_HALFDUPLEX)) {
    sub XM_ANAR_HALFDUPLEX () {	0x40;}
}
unless(defined(&XM_ANAR_PAUSEBITS)) {
    sub XM_ANAR_PAUSEBITS () {	0x180;}
}
unless(defined(&XM_ANAR_REMFAULTBITS)) {
    sub XM_ANAR_REMFAULTBITS () {	0x1800;}
}
unless(defined(&XM_ANAR_ACK)) {
    sub XM_ANAR_ACK () {	0x4000;}
}
unless(defined(&XM_ANAR_NEXTPAGE)) {
    sub XM_ANAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&XM_LPAR_FULLDUPLEX)) {
    sub XM_LPAR_FULLDUPLEX () {	0x20;}
}
unless(defined(&XM_LPAR_HALFDUPLEX)) {
    sub XM_LPAR_HALFDUPLEX () {	0x40;}
}
unless(defined(&XM_LPAR_PAUSEBITS)) {
    sub XM_LPAR_PAUSEBITS () {	0x180;}
}
unless(defined(&XM_LPAR_REMFAULTBITS)) {
    sub XM_LPAR_REMFAULTBITS () {	0x1800;}
}
unless(defined(&XM_LPAR_ACK)) {
    sub XM_LPAR_ACK () {	0x4000;}
}
unless(defined(&XM_LPAR_NEXTPAGE)) {
    sub XM_LPAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&XM_PAUSE_NOPAUSE)) {
    sub XM_PAUSE_NOPAUSE () {	0x;}
}
unless(defined(&XM_PAUSE_SYMPAUSE)) {
    sub XM_PAUSE_SYMPAUSE () {	0x80;}
}
unless(defined(&XM_PAUSE_ASYMPAUSE)) {
    sub XM_PAUSE_ASYMPAUSE () {	0x100;}
}
unless(defined(&XM_PAUSE_BOTH)) {
    sub XM_PAUSE_BOTH () {	0x180;}
}
unless(defined(&XM_REMFAULT_LINKOK)) {
    sub XM_REMFAULT_LINKOK () {	0x;}
}
unless(defined(&XM_REMFAULT_LINKFAIL)) {
    sub XM_REMFAULT_LINKFAIL () {	0x800;}
}
unless(defined(&XM_REMFAULT_OFFLINE)) {
    sub XM_REMFAULT_OFFLINE () {	0x1000;}
}
unless(defined(&XM_REMFAULT_ANEGERR)) {
    sub XM_REMFAULT_ANEGERR () {	0x1800;}
}
unless(defined(&XM_ANEXP_GOTPAGE)) {
    sub XM_ANEXP_GOTPAGE () {	0x2;}
}
unless(defined(&XM_ANEXP_NEXTPAGE_SELF)) {
    sub XM_ANEXP_NEXTPAGE_SELF () {	0x4;}
}
unless(defined(&XM_ANEXP_NEXTPAGE_LP)) {
    sub XM_ANEXP_NEXTPAGE_LP () {	0x8;}
}
unless(defined(&XM_NEXTP_MESSAGE)) {
    sub XM_NEXTP_MESSAGE () {	0x7ff;}
}
unless(defined(&XM_NEXTP_TOGGLE)) {
    sub XM_NEXTP_TOGGLE () {	0x800;}
}
unless(defined(&XM_NEXTP_ACK2)) {
    sub XM_NEXTP_ACK2 () {	0x1000;}
}
unless(defined(&XM_NEXTP_MPAGE)) {
    sub XM_NEXTP_MPAGE () {	0x2000;}
}
unless(defined(&XM_NEXTP_ACK1)) {
    sub XM_NEXTP_ACK1 () {	0x4000;}
}
unless(defined(&XM_NEXTP_NPAGE)) {
    sub XM_NEXTP_NPAGE () {	0x8000;}
}
unless(defined(&XM_LPNEXTP_MESSAGE)) {
    sub XM_LPNEXTP_MESSAGE () {	0x7ff;}
}
unless(defined(&XM_LPNEXTP_TOGGLE)) {
    sub XM_LPNEXTP_TOGGLE () {	0x800;}
}
unless(defined(&XM_LPNEXTP_ACK2)) {
    sub XM_LPNEXTP_ACK2 () {	0x1000;}
}
unless(defined(&XM_LPNEXTP_MPAGE)) {
    sub XM_LPNEXTP_MPAGE () {	0x2000;}
}
unless(defined(&XM_LPNEXTP_ACK1)) {
    sub XM_LPNEXTP_ACK1 () {	0x4000;}
}
unless(defined(&XM_LPNEXTP_NPAGE)) {
    sub XM_LPNEXTP_NPAGE () {	0x8000;}
}
unless(defined(&XM_EXTSTS_HALFDUPLEX)) {
    sub XM_EXTSTS_HALFDUPLEX () {	0x4000;}
}
unless(defined(&XM_EXTSTS_FULLDUPLEX)) {
    sub XM_EXTSTS_FULLDUPLEX () {	0x8000;}
}
unless(defined(&XM_RESAB_PAUSEMISMATCH)) {
    sub XM_RESAB_PAUSEMISMATCH () {	0x8;}
}
unless(defined(&XM_RESAB_ABLMISMATCH)) {
    sub XM_RESAB_ABLMISMATCH () {	0x10;}
}
unless(defined(&XM_RESAB_FDMODESEL)) {
    sub XM_RESAB_FDMODESEL () {	0x20;}
}
unless(defined(&XM_RESAB_HDMODESEL)) {
    sub XM_RESAB_HDMODESEL () {	0x40;}
}
unless(defined(&XM_RESAB_PAUSEBITS)) {
    sub XM_RESAB_PAUSEBITS () {	0x180;}
}
unless(defined(&SK_HASH_BITS)) {
    sub SK_HASH_BITS () {	6;}
}
1;
