/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (directive.h)
 *  
 *  It has been AutoGen-ed  Sunday November 16, 2008 at 04:03:58 PM PST
 *  From the definitions    directive.def
 *  and the template file   directive
 *
 *  copyright 1992-2007 Bruce Korb
 *
 *  AutoGen is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  AutoGen is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef AUTOGEN_DIRECTIVE_H_GUARD
#define AUTOGEN_DIRECTIVE_H_GUARD 1
#ifdef DEFINING

typedef char* (tDirProc)( char* pzArg, char* pzScan );

typedef struct dir_table tDirTable;
struct dir_table {
    size_t      nameSize;
    tCC*        pzDirName;
    tDirProc*   pDirProc;
    int         unused;
};

/*
 *  Declare the procedures that will handle the directives.
 */
static tDirProc doDir_IGNORE;
static tDirProc doDir_assert;
static tDirProc doDir_define;
static tDirProc doDir_elif;
static tDirProc doDir_else;
static tDirProc doDir_endif;
static tDirProc doDir_endmac;
static tDirProc doDir_endshell;
static tDirProc doDir_error;
#define         doDir_ident doDir_IGNORE
static tDirProc doDir_if;
static tDirProc doDir_ifdef;
static tDirProc doDir_ifndef;
static tDirProc doDir_include;
#define         doDir_let doDir_IGNORE
static tDirProc doDir_line;
static tDirProc doDir_macdef;
static tDirProc doDir_option;
#define         doDir_pragma doDir_IGNORE
static tDirProc doDir_shell;
static tDirProc doDir_undef;

/*
 *  Define the constant string names for each directive.
 *  We supply all the needed terminating NULs, so tell the compiler
 *  the size to allocate.
 */
static char const zDirectives[124] =
    "assert\0"    "define\0"    "elif\0"      "else\0"      "endif\0"
    "endmac\0"    "endshell\0"  "error\0"     "ident\0"     "if\0"
    "ifdef\0"     "ifndef\0"    "include\0"   "let\0"       "line\0"
    "macdef\0"    "option\0"    "pragma\0"    "shell\0"     "undef\0";

/*
 *  Enumerate the directives
 */
typedef enum {
    DIR_ASSERT,   DIR_DEFINE,   DIR_ELIF,     DIR_ELSE,     DIR_ENDIF,
    DIR_ENDMAC,   DIR_ENDSHELL, DIR_ERROR,    DIR_IDENT,    DIR_IF,
    DIR_IFDEF,    DIR_IFNDEF,   DIR_INCLUDE,  DIR_LET,      DIR_LINE,
    DIR_MACDEF,   DIR_OPTION,   DIR_PRAGMA,   DIR_SHELL,    DIR_UNDEF
} teDirectives;

/*
 *  Set up the table for handling each directive.
 */
#define DIRECTIVE_CT  20
static tDirTable dirTable[ DIRECTIVE_CT ] = {
    {  6, zDirectives +  0, doDir_assert,    0 },
    {  6, zDirectives +  7, doDir_define,    0 },
    {  4, zDirectives + 14, doDir_elif,      0 },
    {  4, zDirectives + 19, doDir_else,      0 },
    {  5, zDirectives + 24, doDir_endif,     0 },
    {  6, zDirectives + 30, doDir_endmac,    0 },
    {  8, zDirectives + 37, doDir_endshell,  0 },
    {  5, zDirectives + 46, doDir_error,     0 },
    {  5, zDirectives + 52, doDir_ident,     0 },
    {  2, zDirectives + 58, doDir_if,        0 },
    {  5, zDirectives + 61, doDir_ifdef,     0 },
    {  6, zDirectives + 67, doDir_ifndef,    0 },
    {  7, zDirectives + 74, doDir_include,   0 },
    {  3, zDirectives + 82, doDir_let,       0 },
    {  4, zDirectives + 86, doDir_line,      0 },
    {  6, zDirectives + 91, doDir_macdef,    0 },
    {  6, zDirectives + 98, doDir_option,    0 },
    {  6, zDirectives +105, doDir_pragma,    0 },
    {  5, zDirectives +112, doDir_shell,     0 },
    {  5, zDirectives +118, doDir_undef,     0 } };

/*
 *  This text has been extracted from /home/bkorb/ag/ag/agen5/schemedef.scm
 */
#define SCHEME_INIT_FILE "directive.h"
static const int  schemeLine = __LINE__+2;
static char const zSchemeInit[3990] =
"(use-modules (ice-9 common-list))\n\
(define identifier?\n\
(lambda (x) (or (string? x) (symbol? x))))\n\
(define normalize-identifier\n\
(lambda (x)\n\
(if (string? x) (string->symbol x) x)))\n\
(define coerce->string\n\
(lambda (x)\n\
(let ((char->string (lambda (x) (make-string 1 x)))\n\
(coercable? (lambda (x)\n\
(or (string? x) (boolean? x) (char? x)\n\
(symbol? x) (list? x) (number? x)) )) )\n\
(if (not (coercable? x))\n\
(error \"Wrong type to coerce->string\" x))\n\
(cond\n\
((string? x)  (string-append\n\
(char->string #\\\") x (char->string #\\\")  ))\n\
((boolean? x) (if x \"#t\" \"#f\"))\n\
((char? x)    (char->string x))\n\
((number? x)  (number->string x))\n\
((symbol? x)  (symbol->string x))\n\
((list? x)    (if (every coercable? x)\n\
(apply string-append (map coerce->string x))  ))\n\
) ) ) )\n\
(define alist->autogen-def\n\
(lambda (lst . recursive)\n\
(if (null? recursive) (set! recursive #f)\n\
(set! recursive #t))\n\
(let ((res (if recursive \"{\\n\" \"\"))\n\
(list-nnul? (lambda (x) (and (list? x) (not (null? x))))))\n\
(do ((i lst (cdr i)))\n\
((null? i) (if recursive\n\
(string-append res \"}\")\n\
res))\n\
(let* ((kvpair (car i))\n\
(value (cdr kvpair))\n\
(value-is-alist (if (and (list-nnul? value)\n\
(list-nnul? (car value))\n\
(list-nnul? (caar value))\n\
(identifier? (caaar value)))\n\
#t #f)))\n\
(set! res (string-append res\n\
(coerce->string (normalize-identifier (car kvpair)))\n\
\" = \"\n\
(if value-is-alist\n\
(alist->autogen-def (car value) 1)\n\
(coerce->string (cdr kvpair)))\n\
\";\\n\"\n\
) ) ) ) ) )         )\n\
(define shell-cleanup \"\")\n\
(define add-cleanup (lambda (t)\n\
(set! shell-cleanup (string-append shell-cleanup \"\\n\" t \"\\n\"))  ))\n\
(define tmp-dir \"\")\n\
(define make-tmp-dir\n\
(lambda () \n\
(begin (if (= tmp-dir \"\") (set! tmp-dir (shell\n\
\"mk_tmp_dir ; echo ${tmp_dir}\" ))))\n\
(add-cleanup (string-append\n\
\"test \\\"${VERBOSE:-false}\\\" = true || rm -rf \" tmp-dir))\n\
) )\n\
(define header-file     \"\")\n\
(define header-guard    \"\")\n\
(define autogen-version \"5.9.6\")\n\
(define c-file-line-fmt \"#line %2$d \\\"%1$s\\\"\\n\")\n\
(define-macro (defined-as predicate symbol)\n\
`(and (defined? ',symbol) (,predicate ,symbol)))\n\
(define html-escape-encode (lambda (str)\n\
(string-substitute str\n\
'(\"&\"      \"<\"     \">\")\n\
'(\"&amp;\"  \"&lt;\"  \"&gt;\") ) ))\n\
(define stt-table   (make-hash-table 31))\n\
(define stt-curr    stt-table)\n\
(define stt-idx-tbl stt-table)\n\
(define stt-idx     0)\n\
(define string-table-new (lambda (st-name) (begin\n\
(set! stt-curr (make-hash-table 31))\n\
(hash-create-handle! stt-table st-name stt-curr)\n\
(out-push-new)\n\
(out-suspend st-name)\n\
(set! stt-idx-tbl (make-hash-table 31))\n\
(hash-create-handle! stt-curr \"string-indexes\" stt-idx-tbl)\n\
(hash-create-handle! stt-curr \"current-index\"  0)\n\
\"\"\n\
)))\n\
(define string-table-add (lambda (st-name str-val) (begin\n\
(set! stt-curr    (hash-ref stt-table   st-name))\n\
(set! stt-idx-tbl (hash-ref stt-curr    \"string-indexes\"))\n\
(set! stt-idx     (hash-ref stt-idx-tbl str-val))\n\
(if (not (number? stt-idx))\n\
(begin\n\
(ag-fprintf st-name \"%s \\\"\\\\0\\\"\\n\" (c-string str-val))\n\
(set! stt-idx (hash-ref stt-curr \"current-index\"))\n\
(hash-create-handle! stt-idx-tbl str-val stt-idx)\n\
(hash-set! stt-curr \"current-index\"\n\
(+ stt-idx (string-length str-val) 1)  )\n\
)   )\n\
stt-idx\n\
)))\n\
(define string-table-add-ref (lambda (st-name str-val)\n\
(string-append st-name \"+\"\n\
(number->string (string-table-add st-name str-val)) ) ))\n\
(define emit-string-table (lambda (st-name) (begin\n\
(set! stt-curr (hash-ref stt-table   st-name))\n\
(set! stt-idx  (hash-ref stt-curr \"current-index\"))\n\
(ag-fprintf 0 \"\\nstatic char const %s[%d] =\\n\" st-name stt-idx)\n\
(out-resume st-name)\n\
(emit (shell (string-append\n\
\"(sed 's/^ *//;s/\\\" \\\"\\\\\\\\0\\\"/\\\\\\\\0\\\"/' | \\\n\
columns -I4 --spread=1\n\
) <<\\\\_EndStringTable_\\n\" (out-pop #t) \"_EndStringTable_\")))\n\
(emit \";\\n\")\n\
)))\n\
(define string-table-size (lambda (st-name)\n\
(hash-ref (hash-ref stt-table st-name) \"current-index\") ))\n\
(define gperf-code (lambda (gp-name) (shellf\n\
\"sed -e '1,/^#line/d' \\\n\
-e '/#include/d' \\\n\
-e '/#line/d' \\\n\
-e '/^[ \\t]*$/d' \\\n\
-e 's/^const struct /static const struct /' \\\n\
-e '/^int main(/,$d' ${gpdir}/%s.c\"\n\
gp-name\n\
)))\n\
(use-modules (ice-9 debug))\n\
(read-enable 'positions)"; /* ' // " // */

/*
 *  The shell initialization string.  It is not in "const" memory because
 *  we have to write our PID into it.
 */
static char zShellInit[] =
    "exec 8>&2 2>/dev/null\n\n\
if test -n \"${ZSH_VERSION+set}\" && (emulate sh) 1>&2\n\
then\n\
  emulate sh\n\
  NULLCMD=:\n\n\
else case `set -o` in *posix*) set -o posix ;; esac\n\
fi\n\n\
for f in 1 2 5 6 7 13 14\n\
do trap \"echo trapped on $f >&2\" $f ; done\n\n\
test -n \"${CDPATH}\" && {\n\
  CDPATH=''\n\
  unset CDPATH\n\
}\n\
( unalias cd ) 1>&2 && unalias cd\n\
die() {\n\
  echo \"Killing AutoGen:  $*\" >&8\n\
  kill -TERM ${AG_pid}\n\
  exit 1\n\
}\n\
tmp_dir=''\n\
mk_tmp_dir() {\n\
  test -d \"${tmp_dir}\" && return 0\n\
  tmp_dir=`\n\
    t=\\`mktemp -d ${TMPDIR:-.}/.ag-XXXXXX\\`\n\
    test -d \"${t}\" || {\n\
      t=${TMPDIR:-.}/.ag-$$\n\
      rm -rf ${t}\n\
      mkdir ${t} || die cannot mkdir ${t}\n\
    }\n\
    chmod 700 ${t} || die cannot chmod 700 ${t}\n\
    echo ${t}\n\
    ` 2>/dev/null\n\
}\n\
exec 2>&8\n\
AG_pid=" "\000........."; /* ' // " // */


#if defined(SHELL_ENABLED)
/*
 *  "gperf" functionality only works if the subshell is enabled.
 */
static char const zMakeGperf[1207] =
"gperf --version > /dev/null 2>&1 || die \"no gperf program\"\n\
test -z ${gpdir} && {\n\
  gpdir=`mktemp -d ./.gperf.XXXXXX` 2>/dev/null\n\
  test -z \"${gpdir}\" && gpdir=.gperf.$$\n\
  test -d ${gpdir} || mkdir ${gpdir} || die \"cannot mkdir ${gpdir}\"\n\
}\n\
cd ${gpdir} || die cannot cd into ${gpdir}\n\
gpdir=`pwd`\n\
gperf_%2$s=${gpdir}/%2$s\n\n\
( cat <<- '_EOF_'\n\
\t%%{\n\
\t#include <stdio.h>\n\
\t%%}\n\
\tstruct %2$s_index { char const * name; int const idx; };\n\
\t%%%%\n\
\t_EOF_\n\n\
  idx=1\n\
  while read f\n\
  do echo \"${f}, ${idx}\"\n\
     idx=`expr ${idx} + 1`\n\
  done <<- _EOLIST_\n\
%1$s\n\
\t_EOLIST_\n\n\
  cat <<- '_EOF_'\n\
\t%%%%\n\
\tint main( int argc, char** argv ) {\n\
\t    char*    pz = argv[1];\n\
\t    struct %2$s_index* pI = %2$s_find( pz, strlen( pz ));\n\
\t    if (pI == NULL)\n\
\t        return 1;\n\
\t    printf( \"0x%%02X\\n\", pI->idx );\n\
\t    return 0;\n\
\t}\n\
\t_EOF_\n\
) > %2$s.gperf\n\n\
exec 2> %2$s.log\n\
gperf --language=ANSI-C -H %2$s_hash -N %2$s_find --null-strings \\\n\
      -C -E -I -t %2$s.gperf > %2$s-temp.c || \\\n\
   die \"gperf failed on ${gpdir}/%2$s.gperf\n\
      `cat %2$s.log`\"\n\
egrep -v '^_*inline$' %2$s-temp.c > %2$s.c\n\
export CFLAGS=-g\n\
${MAKE-make} %2$s 1>&2\n\
test $? -eq 0 -a -x ${gperf_%2$s} || \\\n\
  die \"could not build gperf program\n\
      `cat %2$s.log`\"\n\
exec 2>&8\n"; /* ' // " // */

static char const zRunGperf[161] =
"test -n \"${gperf_%1$s}\" || die 'no environment variable \"gperf_%1$s\"'\n\
test -x \"${gperf_%1$s}\" || die \"no gperf program named  ${gperf_%1$s}\"\n\
${gperf_%1$s} %2$s\n"; /* ' // " // */
#endif

#ifdef DAEMON_ENABLED
typedef struct inet_family_map_s {
    char const*     pz_name;
    unsigned short  nm_len;
    unsigned short  family;
} inet_family_map_t;

#define INET_FAMILY_TYPE_CT 31
inet_family_map_t inet_family_map[ 32 ] = {
    { "appletalk:",   11, AF_APPLETALK },
    { "ash:",          5, AF_ASH },
    { "atmpvc:",       8, AF_ATMPVC },
    { "atmsvc:",       8, AF_ATMSVC },
    { "ax25:",         6, AF_AX25 },
    { "bluetooth:",   11, AF_BLUETOOTH },
    { "bridge:",       8, AF_BRIDGE },
    { "can:",          5, AF_CAN },
    { "econet:",       8, AF_ECONET },
    { "inet6:",        7, AF_INET6 },
    { "inet:",         6, AF_INET },
    { "ipx:",          5, AF_IPX },
    { "irda:",         6, AF_IRDA },
    { "iucv:",         6, AF_IUCV },
    { "key:",          5, AF_KEY },
    { "llc:",          5, AF_LLC },
    { "local:",        7, AF_LOCAL },
    { "netbeui:",      9, AF_NETBEUI },
    { "netlink:",      9, AF_NETLINK },
    { "netrom:",       8, AF_NETROM },
    { "packet:",       8, AF_PACKET },
    { "pppox:",        7, AF_PPPOX },
    { "rose:",         6, AF_ROSE },
    { "rxrpc:",        7, AF_RXRPC },
    { "security:",    10, AF_SECURITY },
    { "sna:",          5, AF_SNA },
    { "tipc:",         6, AF_TIPC },
    { "unix:",         6, AF_UNIX },
    { "unspec:",       8, AF_UNSPEC },
    { "wanpipe:",      9, AF_WANPIPE },
    { "x25:",          5, AF_X25 },
    { NULL, 0, 0 } };

#endif /* DAEMON_ENABLED */
#endif /* DEFINING */
#endif /* AUTOGEN_DIRECTIVE_H_GUARD */
/*
 *  End of directive.h */
