/* LocaleInformation_lv.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_lv extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "LVL";

  private static final String currenciesDisplayNameValues = "LVL";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "LVL";

  private static final String currenciesSymbolValues = "Ls";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "Mai",
    "J\u016bn",
    "J\u016bl",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Dec",
    null,
  };

  private static final String[] months = {
    "janv\u0101ris",
    "febru\u0101ris",
    "marts",
    "apr\u012blis",
    "maijs",
    "j\u016bnijs",
    "j\u016blijs",
    "augusts",
    "septembris",
    "oktobris",
    "novembris",
    "decembris",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Sv",
    "P",
    "O",
    "T",
    "C",
    "Pk",
    "S",
  };

  private static final String[] weekdays = {
    null,
    "sv\u0113tdiena",
    "pirmdiena",
    "otrdiena",
    "tre\u0161diena",
    "ceturtdiena",
    "piektdiena",
    "sestdiena",
  };

  private static final String[] eras = {
    "pm\u0113",
    "m\u0113",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Austrumtimora|Tokelau|Tad\u017eikist\u0101na|Taizeme|Togo|Fran\u010du dienvidu teritorijas|Gaj\u0101na|\u010cada|T\u0113rksas un Kaikosas salas|Gvineja-Bisava|Guama|Gvatemala|Dienvidd\u017eord\u017eija un Dienvidsendvi\u010du salas|Grie\u0137ija|Ekvatori\u0101l\u0101 Gvineja|Gvadelupa|Svazilenda|S\u012brija|Gvineja|Gambija|Grenlande|Salvadora|Santome un Prinsipi|Gibralt\u0101rs|Gana|Surinama|Fran\u010du Gvi\u0101na|Serbia|Gruzija|Som\u0101lija|Gren\u0101da|Seneg\u0101la|Sanmar\u012bno|Lielbrit\u0101nija|Sjerraleone|Gabona|Slov\u0101kija|Svalb\u0101ra un Jana Majena sala|Slov\u0113nija|Sv. Hel\u0113nas sala|Singap\u016bra|Zviedrija|Sud\u0101na|Sei\u0161e\u013cu salas|Z\u0101lamana salas|Sa\u016bda Ar\u0101bija|Francija|Far\u0113ru salas|Mikron\u0113zijas Federat\u012bv\u0101s Valstis|Ruanda|Folklenda salas|Krievija|Fid\u017ei|Somija|Rum\u0101nija|Reinjona|Etiopija|Sp\u0101nija|Eritreja|Rietumsah\u0101ra|\u0112\u0123ipte|Igaunija|Ekvadora|Al\u017e\u012brija|Katara|Dominik\u0101nas Republika|Paragvaja|Dominika|Palau|D\u0101nija|D\u017eibutija|Portug\u0101le|Palest\u012bnie\u0161u pa\u0161p\u0101rvaldes teritorija|Puertoriko|V\u0101cija|Pitk\u0113rna|Senpj\u0113ra un Mikelona|Polija|Pakist\u0101na|Filip\u012bnas|Papua-Jaungvineja|Fran\u010du Polin\u0113zija|\u010cehija|Peru|Kipra|Ziemsv\u0113tku sala|Kaboverde|Panama|Kuba|Kostarika|Kolumbija|\u0136\u012bna|Kamer\u016bna|\u010c\u012ble|Kuka salas|Kotdivu\u0101ra|\u0160veice|Kongo|Centr\u0101l\u0101frikas Republika|Kongo Demokr\u0101tisk\u0101 Republika|Kokosu (K\u012blinga) salas|Om\u0101na|Kan\u0101da|Beliza|Baltkrievija|Botsv\u0101na|Buv\u0113 sala|But\u0101na|Bahamas|Braz\u012blija|Jaunz\u0113lande|Bol\u012bvija|Bruneja|Bermudu salas|Niue|Benina|Burundi|Bahreina|Nauru|Bulg\u0101rija|Burkinafaso|Nep\u0101la|Be\u013c\u0123ija|Norv\u0113\u0123ija|Banglade\u0161a|Barbadosa|Zimbabve|N\u012bderlande|Bosnija un Hercegovina|Nikaragva|Nig\u0113rija|Norfolka|Azerbaid\u017e\u0101na|Nig\u0113ra|Jaunkaledonija|Aruba|Zambija|Nam\u012bbija|Austr\u0101lija|Austrija|Amerik\u0101\u0146u Samoa|Argent\u012bna|Antarktika|Mozambika|Angola|Malaizija|Anti\u013cas|Meksika|Arm\u0113nija|Mal\u0101vija|Alb\u0101nija|Mald\u012bvija|Dienvid\u0101frika|Maur\u012bcija|Malta|Angilja|Montserrata|Maurit\u0101nija|Antigva un Barbuda|Martinika|Afganist\u0101na|Zieme\u013cu Marianas|Apvienotie Ar\u0101bu Emir\u0101ti|Makao, \u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals|Andora|Mongolija|Mjanma|Mali|Ma\u0137edonija|Dienvidsl\u0101vija|Majota|M\u0101r\u0161ala salas|Madagaskara|Moldova|Monako|Maroka|Jemena|L\u012bbija|Latvija|Luksemburga|Lietuva|Lesoto|Lib\u0113rija|\u0160rilanka|Lihten\u0161teina|Sentl\u016bsija|Lib\u0101na|Laosa|Kazahst\u0101na|Kaimanu salas|Kuveita|Dienvidkoreja|Zieme\u013ckoreja|Sentkitsa un Nevisa|Komoru salas|Kiribati|Samoa|Kambod\u017ea|Kirg\u012bzija|Kenija|Volisa un Futuna|Jap\u0101na|Jord\u0101nija|Jamaika|Vanuatu|Vjetnama|Amerik\u0101\u0146u Vird\u017e\u012bnu salas|Britu Vird\u017e\u012bnu salas|Venecu\u0113la|Sentvinsenta un Grenad\u012bnas|Vatik\u0101ns|It\u0101lija|Islande|Ir\u0101na|Ir\u0101ka|Uzbekist\u0101na|Britu Indijas oke\u0101na teritorija|Urugvaja|Indija|Izra\u0113la|United States|\u012arija|Indon\u0113zija|ASV maz\u0101s aizj\u016bras teritorijas|Uganda|Ukraina|Ung\u0101rija|Haiti|Horv\u0101tija|Tanz\u0101nija|Hondurasa|H\u0113rda un Makdonalda salas|Taiv\u0101na|Tuvalu|Honkonga, \u0136\u012bnas \u012bpa\u0161\u0101s p\u0101rvaldes apgabals|Trinid\u0101da un Tob\u0101go|Turcija|Tonga|Tunisija|Turkmenist\u0101na";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ja|en|tr|ko|no|el|nl|bg|lv|he|cs|it|lt|fr|zh|ru|ro|fi|ar|sv|pt|pl|sl|sk|de|hu|et|es|hr|da";

  private static final String languagesValues = "jap\u0101\u0146u|ang\u013cu|turku|korejie\u0161u|norv\u0113\u0123u|grie\u0137u|holandie\u0161u|bulg\u0101ru|latvie\u0161u|ivrits|\u010dehu|it\u0101lie\u0161u|lietuvie\u0161u|fran\u010du|\u0137\u012bnie\u0161u|krievu|rum\u0101\u0146u|somu|ar\u0101bu|zviedru|portug\u0101\u013cu|po\u013cu|slov\u0113\u0146u|slov\u0101ku|v\u0101cu|ung\u0101ru|igau\u0146u|sp\u0101\u0146u|horv\u0101tu|d\u0101\u0146u";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "yy.d.M" },
    { "mediumDateFormat", "yyyy.d.M" },
    { "longDateFormat", "yyyy'. gada 'd. MMMM" },
    { "fullDateFormat", "EEEE, yyyy'. gada 'd. MMMM" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
