;;; -*- Mode:Lisp; Package:CLUEI; Syntax:COMMON-LISP; Base:10; Lowercase:T; Patch-File: T;  -*-

(in-package "CLUEI")

(defun default-resources (contact resource-class &optional resource-name)
  "Return the plist of default resources for RESOURCE-CLASS on CONTACT.
   If CONTACT is a string, its taken as a host name."
  (if (stringp contact)
      (let ((display (open-contact-display 'default-resources :host contact)))
	(unwind-protect
	    (default-resources (display-root display) resource-class resource-name)
	  (close-display display)))
      
      (let* ((contact-class (class-name (class-of contact)))
	     (class-key     (intern (symbol-name resource-class) 'keyword))
	     (name-key      (when resource-name (intern (symbol-name resource-name) 'keyword)))

	     ;; Find resource(s) that match given RESOURCE-CLASS and RESOURCE-NAME
	     (resources     (delete
			      nil
			      (append (class-resources   contact-class t)
				      (class-constraints contact-class t))
			      :key #'(lambda(r)
				       (let ((rclass (getf (rest r) :class))
					     (rname  (first r)))
					 (and
					   (eq (or rclass rname) class-key)
					   (or (null resource-name)
					       (eq rname name-key))))))))
	
	(when resources
	  (get-resources
	    nil
	    resources
	    contact
	    ;; **** [Hubertus 9/24/90] *****
	    ;; this is wrong!!!! full-name/full-path arguments do *NOT* include
	    ;; the resource's attribute-name/class!
	    ;;(append (contact-complete-name contact) (list (or resource-name resource-class)))
	    ;;(append (contact-complete-class contact) (list resource-class))
	    (contact-complete-name contact)
	    (contact-complete-class contact))))))