/* AMD pp. 297 - 308
 * Split plot
 */

#include <dap.h>

void main()
{
  infile("amd297.dat", " ")
    {
      char fertilizer[2], block[2], variety[2];
      double yield;
      input("block variety fertilizer yield");
      outset("amd297", "");
      skip(1);
      while (step()) 
              output();
    }
  
  sort("amd297", "fertilizer block variety", "");
  
  title("Whole plot (block, fertilizer) analysis");
  
  means("amd297.srt", "yield", "N MEAN VAR",
                                    "fertilizer block variety");
  
  effects("amd297.srt.mns", "yield fertilizer block variety",
                                    "fertilizer block", "");
  ftest("amd297.srt.mns.con", "yield fertilizer block variety",
          "fertilizer", "fertilizer*block", "");
  lsmeans("amd297.srt.mns.tst", "LSD", 0.05,
           "yield fertilizer block", "fertilizer", "", "s8.4");
  
  title("Subplot (variety) analysis");
  
  effects("amd297.srt.mns", "yield fertilizer block variety",
       "fertilizer block variety fertilizer*block fertilizer*variety",
       "");
  
  ftest("amd297.srt.mns.con", "yield fertilizer block variety",
                                                 "variety", "", "");
  lsmeans("amd297.srt.mns.tst", "LSD", 0.05,
          "yield fertilizer block variety", "variety", "", "s8.4");
  
  ftest("amd297.srt.mns.con", "yield fertilizer block variety",
                                     "variety*fertilizer", "", "");
}
