/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : CHANNEL
    Description : Abstraction of communication Channel
    Author      : David Martnez Oliveira
    Date        : 8/04/2001
-----------------------------------------------------
  REVISIONS :
  30/6/2001
  The open method didn't return -1 on error. FIXED
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/

#include <edma.h> 

/*
***************************************************
  Private Data Struct for class CHANNEL
***************************************************
*/
 
typedef struct
  {
    ESint32		Specialized;
    EPChar              Implementation;
    EPChar              Resource;
    EPChar              Target;
    EPChar              Access;
}DtCHANNEL;

EPChar access_type[]={"Read","Write","Append"};
/*
***************************************************
  Method Declaration for class Specialized
***************************************************
*/
 
ESint32 EDMAPROC 
CHANNELopenZrS32 (OBJID IdObj,EPChar res)
{
  DtCHANNEL	*m;
  EPChar        aux,aux1;
  EChar         cImpl[50];
  EChar         cTarget[1024];
  EChar         temp[1024];
  ESint32       access=0,r;
  
  m = (DtCHANNEL*) edma_get_data_ref (IdObj);

  /* Gets communication subclass from Resource Parameter*/
  /* Resource parameter :  Subclass:(slash slash)target */
  access = 0;
  strcpy (temp, res);
  if (temp[0] == '>') 
    {
      access++;
      if (temp[1] == '>')
	access++;
    }

  aux1 = temp;
  aux1 += access;
  aux = strstr (aux1, "://");
  if (aux == NULL) 
    {
      if (m->Specialized == 0) 
	{
	  edma_printf_obj(IdObj,"%s", "[ERROR] Resource Name Incomplete. "
			  "No Implementation specified");
	  return -1;
	}    
    } 
  else 
    { /* User provides one implementation*/
      *aux = 0;
      aux += 2;
      *aux = 0; 
      aux++;
      strcpy (cImpl, aux1);
      edma_wprop3 (IdObj, "Implementation", cImpl);
      edma_wprop3 (IdObj, "Target", aux);
      edma_wprop3 (IdObj, "Resource", res);
      edma_wprop3 (IdObj, "Access", access);
      strcpy (cTarget, aux);
    }
  /* DEBUG Traces To Be Removed */
#if 0
  edma_printf_obj (IdObj," Resource       : %s",res);
  edma_printf_obj (IdObj," Implementation : '%s'",aux1);
  edma_printf_obj (IdObj," Target         : %s",aux);
  edma_printf_obj (IdObj," Access         : %d",access);
#endif

  edma_add_subclass (IdObj, edma_get_class_id (cImpl), "IMP", "SUPER");

  /* We have an Implementation*/
  m->Specialized = 1;
  r = (ESint32) edma_met3(IdObj, "Open", cTarget, access);
  return r;
}


ESint32 EDMAPROC 
CHANNELcloserS32 (OBJID IdObj)
{
  DtCHANNEL	*m;
  
  m = (DtCHANNEL*) edma_get_data_ref (IdObj);
  return (ESint32) edma_met3 (IdObj, "Close");
}


ESint32 EDMAPROC 
CHANNELsendAS32rS32 (OBJID IdObj, EDMAT_BUFFER buf, ESint32 len)
{
  DtCHANNEL	*m;

  m = (DtCHANNEL*) edma_get_data_ref (IdObj);
  
  return (ESint32) edma_met3(IdObj, "Send", buf, len);
}


ESint32 EDMAPROC 
CHANNELrecvsAsS32rS32 (OBJID IdObj, EDMAT_BUFFER *buf, EPSint32 len)
{
  DtCHANNEL	*m;
  
  m = (DtCHANNEL*) edma_get_data_ref (IdObj);

  return (ESint32) edma_met3 (IdObj, "Recv", buf, len);
}

ESint32 EDMAPROC 
CHANNELwaitsOrS32 (OBJID IdObj, OBJID *id)
{
  DtCHANNEL	*m;
  OBJID         my_id;
  ESint32       r;
  EChar         impl[256], res[1024];

  m = (DtCHANNEL*) edma_get_data_ref (IdObj);
  edma_rprop3 (IdObj, "Implementation", impl);

  /* We create a new Communication Channel*/
  my_id = edma_new_obj ("CHANNEL");
  edma_wprop3 (my_id, "Implementation", impl);

  edma_add_subclass (my_id, edma_get_class_id (impl), "IMP", "SUPER");

  r = (ESint32) edma_met3 (IdObj, "Wait", &my_id);
  if (r==-1)
    {
      edma_free_obj (my_id);
      return r;
    }
  
  edma_wprop3 (my_id, "Specialized", 1);
  *id = my_id;

  edma_rprop3 (my_id, "resource", res);
  edma_wprop3 (my_id, "Implementation", impl);
  edma_wprop3 (my_id, "Resource", res);
  edma_wprop3 (my_id, "Target", "");
  edma_wprop3 (my_id, "Access", 1);

  return 0;
}


ESint32 EDMAPROC 
CHANNELborn (OBJID IdObj)
{
  DtCHANNEL	*m;

  m = (DtCHANNEL*) edma_get_data_ref (IdObj);

  m->Specialized = 0;
  
  return 0;
}


ESint32 EDMAPROC 
CHANNELrip (OBJID IdObj)
{
  DtCHANNEL	*m;

  m = (DtCHANNEL*) edma_get_data_ref (IdObj);
  
  if (m->Specialized)
    edma_met3 (IdObj, "close");

  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
