/*
 * Electric(tm) VLSI Design System
 *
 * File: graphpcmsgview.cpp
 * Message window implementation file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "graphpcstdafx.h"
#include "graphpc.h"
#include "graphpcmsgview.h"
#include "graphpcchildframe.h"
#include "global.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
/* CElectricMsgView */

IMPLEMENT_DYNCREATE(CElectricMsgView, CRichEditView)

COLORREF CElectricMsgView::fForeColor = RGB(0, 0, 0);
COLORREF CElectricMsgView::fBackColor = RGB(200, 200, 200);

CElectricMsgView::CElectricMsgView()
{
}

CElectricMsgView::~CElectricMsgView()
{
}

BEGIN_MESSAGE_MAP(CElectricMsgView, CRichEditView)
	//{{AFX_MSG_MAP(CElectricMsgView)
	ON_WM_CHAR()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/* CElectricMsgView drawing */

void CElectricMsgView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
/* CElectricMsgView diagnostics */

#ifdef _DEBUG
void CElectricMsgView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CElectricMsgView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////
/* CElectricMsgView message handlers */

void gra_activateframe(CChildFrame *frame, BOOL bActivate);
void gra_resize(CChildFrame *frame, int cx, int cy);
void gra_keyaction(UINT nChar, INTBIG special, UINT nRepCnt);

void CElectricMsgView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	gra_keyaction(nChar, 0, 1);
}

void CElectricMsgView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView)
{
	extern CChildFrame *gra_messageswindow;

	CRichEditView::OnActivateView(bActivate, pActivateView, pDeactiveView);
	LoadColors();
	gra_activateframe(gra_messageswindow, bActivate);
}

void CElectricMsgView::OnSize(UINT nType, int cx, int cy)
{
	extern CChildFrame *gra_messageswindow;

	CRichEditView::OnSize(nType, cx, cy);

	if (cx != 0 && cy != 0 && gra_messageswindow != 0)
		gra_resize(gra_messageswindow, cx, cy);
}

void CElectricMsgView::SetColors(COLORREF fore, COLORREF back)
{
	fForeColor = fore;
	fBackColor = back;

	LoadColors();
	Invalidate();
}

void CElectricMsgView::LoadColors(void)
{
	/* added part: */

	CRichEditCtrl *ctrl;
	CHARFORMAT2 cf;
	long startsel, endsel;

	ctrl = &GetRichEditCtrl();
	ctrl->SetBackgroundColor(FALSE, fBackColor);

	/* set foreground color */
	ctrl->GetSel(startsel, endsel);
	ctrl->SetSel(0, -1);
	cf.cbSize = sizeof (CHARFORMAT2);
	cf.dwMask = CFM_COLOR;
	cf.dwEffects = 0;
	cf.crTextColor = fForeColor;
	ctrl->SetSelectionCharFormat(cf);
	ctrl->SetSel(startsel, endsel);
	ctrl->SetDefaultCharFormat(cf);

#if 0
	int pos = ctrl->GetLimitText();
	ctrl->SetSel(pos, pos);
	ctrl->ReplaceSel("Color changes\r\n");
	ctrl->SetRedraw(TRUE);
	ctrl->Invalidate();
	GdiFlush();
	extern CChildFrame *gra_messageswindow;
	gra_messageswindow->ShowWindow(SW_RESTORE);
	gra_messageswindow->BringWindowToTop();
	gra_activateframe(gra_messageswindow, true);
#endif
}
