/* ARC Auxiliary register definitions
   Copyright (C) 2015-2016 Free Software Foundation, Inc.

   Contributed by Claudiu Zissulescu (claziss@synopsys.com)

   This file is part of libopcodes.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

DEF (0x0,   STATUS)
DEF (0x1,   SEMAPHORE)
DEF (0x2,   LP_START)
DEF (0x3,   LP_END)
DEF (0x4,   IDENTITY)
DEF (0x5,   DEBUG)
DEF (0x6,   PC)
DEF (0x7,   ADCR)
DEF (0x8,   APCR)
DEF (0x9,   ACR)
DEF (0xA,   STATUS32)
DEF (0xB,   STATUS32_L1)
DEF (0xC,   STATUS32_L2)
DEF (0xF,   BPU_FLUSH)
DEF (0x10,  IVIC)
DEF (0x10,  IC_IVIC)
DEF (0x11,  CHE_MODE)
DEF (0x11,  IC_CTRL)
DEF (0x12,  MULHI)
DEF (0x13,  LOCKLINE)
DEF (0x13,  IC_LIL)
DEF (0x14,  DMC_CODE_RAM)
DEF (0x15,  TAG_ADDR_MASK)
DEF (0x16,  TAG_DATA_MASK)
DEF (0x17,  LINE_LENGTH_MASK)
DEF (0x18,  AUX_LDST_RAM)
DEF (0x18,  AUX_DCCM)
DEF (0x19,  UNLOCKLINE)
DEF (0x19,  IC_IVIL)
DEF (0x1A,  IC_RAM_ADDRESS)
DEF (0x1A,  IC_RAM_ADDRESS)
DEF (0x1B,  IC_TAG)
DEF (0x1B,  IC_TAG)
DEF (0x1C,  IC_WP)
DEF (0x1C,  IC_WP)
DEF (0x1D,  IC_DATA)
DEF (0x1D,  IC_DATA)
DEF (0x20,  SRAM_SEQ)
DEF (0x21,  COUNT0)
DEF (0x22,  CONTROL0)
DEF (0x22,  CONTROL0)
DEF (0x23,  LIMIT0)
DEF (0x24,  PCPORT)
DEF (0x25,  INT_VECTOR_BASE)
DEF (0x26,  AUX_VBFDW_MODE)
DEF (0x26,  JLI_BASE)
DEF (0x27,  AUX_VBFDW_BM0)
DEF (0x28,  AUX_VBFDW_BM1)
DEF (0x29,  AUX_VBFDW_ACCU)
DEF (0x2A,  AUX_VBFDW_OFST)
DEF (0x2B,  AUX_VBFDW_INTSTAT)
DEF (0x2C,  AX2 (A4))
DEF (0x2C,  AUX_XMAC0_24)
DEF (0x2D,  AY2 (A4))
DEF (0x2D,  AUX_XMAC1_24)
DEF (0x2E,  MX2 (A4))
DEF (0x2E,  AUX_XMAC2_24)
DEF (0x2F,  MY2 (A4))
DEF (0x2F,  AUX_FBF_STORE_16)
DEF (0x30,  AX0)
DEF (0x31,  AX1)
DEF (0x32,  AY0 (A4))
DEF (0x32,  AUX_CRC_POLY)
DEF (0x33,  AY1 (A4))
DEF (0x33,  AUX_CRC_MODE)
DEF (0x34,  MX0)
DEF (0x35,  MX1)
DEF (0x36,  MY0)
DEF (0x37,  MY1)
DEF (0x38,  XYCONFIG)
DEF (0x39,  SCRATCH_A)
DEF (0x3A,  BURSTSYS)
DEF (0x3A,  TSCH)
DEF (0x3B,  BURSTXYM)
DEF (0x3C,  BURSTSZ)
DEF (0x3D,  BURSTVAL)
DEF (0x40,  XTP_NEWVAL)
DEF (0x41,  AUX_MACMODE)
DEF (0x42,  LSP_NEWVAL)
DEF (0x43,  AUX_IRQ_LV12)
DEF (0x44,  AUX_XMAC0)
DEF (0x45,  AUX_XMAC1)
DEF (0x46,  AUX_XMAC2)
DEF (0x47,  DC_IVDC)
DEF (0x48,  DC_CTRL)
DEF (0x49,  DC_LDL)
DEF (0x4A,  DC_IVDL)
DEF (0x4B,  DC_FLSH)
DEF (0x4C,  DC_FLDL)
DEF (0x50,  HEXDATA)
DEF (0x51,  HEXCTRL)
DEF (0x52,  LED)
DEF (0x53,  LCDINSTR (A4))
DEF (0x54,  LCDDATA (A4))
DEF (0x55,  LCDSTAT (A4))
DEF (0x56,  DILSTAT)
DEF (0x57,  SWSTAT)
DEF (0x58,  DC_RAM_ADDR)
DEF (0x58,  DC_RAM_ADDR)
DEF (0x59,  DC_TAG)
DEF (0x59,  DC_TAG)
DEF (0x5A,  DC_WP)
DEF (0x5B,  DC_DATA)
DEF (0x61,  DCCM_BASE_BUILD)
DEF (0x62,  CRC_BUILD)
DEF (0x63,  BTA_LINK_BUILD)
DEF (0x64,  VBFDW_BUILD)
DEF (0x65,  EA_BUILD)
DEF (0x66,  DATASPACE)
DEF (0x67,  MEMSUBSYS)
DEF (0x68,  VECBASE_AC_BUILD)
DEF (0x69,  P_BASE_ADDR)
DEF (0x6A,  DATA_UNCACHED_BUILD)
DEF (0x6B,  FP_BUILD)
DEF (0x6C,  DPFP_BUILD)
DEF (0x6D,  MPU_BUILD)
DEF (0x6E,  RF_BUILD)
DEF (0x6F,  MMU_BUILD)
DEF (0x70,  AA2_BUILD)
DEF (0x71,  VECBASE_BUILD)
DEF (0x72,  D_CACHE_BUILD)
DEF (0x73,  MADI_BUILD)
DEF (0x74,  DCCM_BUILD)
DEF (0x75,  TIMER_BUILD)
DEF (0x76,  AP_BUILD)
DEF (0x77,  I_CACHE_BUILD)
DEF (0x78,  ICCM_BUILD)
DEF (0x79,  DSPRAM_BUILD)
DEF (0x7A,  MAC_BUILD)
DEF (0x7B,  MULTIPLY_BUILD)
DEF (0x7C,  SWAP_BUILD)
DEF (0x7D,  NORM_BUILD)
DEF (0x7E,  MINMAX_BUILD)
DEF (0x7F,  BARREL_BUILD)
DEF (0x80,  AX0)
DEF (0x81,  AX1)
DEF (0x82,  AX2)
DEF (0x83,  AX3)
DEF (0x84,  AY0)
DEF (0x85,  AY1)
DEF (0x86,  AY2)
DEF (0x87,  AY3)
DEF (0x88,  MX00)
DEF (0x89,  MX01)
DEF (0x8A,  MX10)
DEF (0x8B,  MX11)
DEF (0x8C,  MX20)
DEF (0x8D,  MX21)
DEF (0x8E,  MX30)
DEF (0x8F,  MX31)
DEF (0x90,  MY00)
DEF (0x91,  MY01)
DEF (0x92,  MY10)
DEF (0x93,  MY11)
DEF (0x94,  MY20)
DEF (0x95,  MY21)
DEF (0x96,  MY30)
DEF (0x97,  MY31)
DEF (0x98,  XYCONFIG)
DEF (0x99,  BURSTSYS)
DEF (0x9A,  BURSTXYM)
DEF (0x9B,  BURSTSZ)
DEF (0x9C,  BURSTVAL)
DEF (0x9D,  XYLSBASEX)
DEF (0x9E,  XYLSBASEY)
DEF (0x9F,  AUX_XMACLW_H)
DEF (0xA0,  AUX_XMACLW_L)
DEF (0xA1,  SE_CTRL)
DEF (0xA2,  SE_STAT)
DEF (0xA3,  SE_ERR)
DEF (0xA4,  SE_EADR)
DEF (0xA5,  SE_SPC)
DEF (0xA6,  SDM_BASE)
DEF (0xA7,  SCM_BASE)
DEF (0xA8,  SE_DBG_CTRL)
DEF (0xA9,  SE_DBG_DATA0)
DEF (0xAA,  SE_DBG_DATA1)
DEF (0xAB,  SE_DBG_DATA2)
DEF (0xAC,  SE_DBG_DATA3)
DEF (0xAD,  SE_WATCH)
DEF (0xC0,  BPU_BUILD)
DEF (0xC1,  ARC600_BUILD_CONFIG)
DEF (0xC2,  ISA_CONFIG)
DEF (0xF4,  HWP_BUILD)
DEF (0xF5,  PCT_BUILD)
DEF (0xF6,  CC_BUILD)
DEF (0xF7,  PM_BCR)
DEF (0xF8,  SCQ_SWITCH_BUILD)
DEF (0xF9,  VRAPTOR_BUILD)
DEF (0xFA,  DMA_CONFIG)
DEF (0xFB,  SIMD_CONFIG)
DEF (0xFC,  VLC_BUILD)
DEF (0xFD,  SIMD_DMA_BUILD)
DEF (0xFE,  IFETCH_QUEUE_BUILD)
DEF (0xFF,  SMART_BUILD)
DEF (0x100, COUNT1)
DEF (0x101, CONTROL1)
DEF (0x101, CONTROL1)
DEF (0x102, LIMIT1)
DEF (0x103, TIMER_XX)
DEF (0x120, ARCANGEL_PERIPH_XX)
DEF (0x140, PERIPH_XX)
DEF (0x200, AUX_IRQ_LEV)
DEF (0x201, AUX_IRQ_HINT)
DEF (0x202, AUX_INTER_CORE_INTERRUPT)
DEF (0x210, AES_AUX_0)
DEF (0x211, AES_AUX_1)
DEF (0x212, AES_AUX_2)
DEF (0x213, AES_CRYPT_MODE)
DEF (0x214, AES_AUXS)
DEF (0x215, AES_AUXI)
DEF (0x216, AES_AUX_3)
DEF (0x217, AES_AUX_4)
DEF (0x218, ARITH_CTL_AUX)
DEF (0x219, DES_AUX)
DEF (0x220, AP_AMV0)
DEF (0x221, AP_AMM0)
DEF (0x222, AP_AC0)
DEF (0x223, AP_AMV1)
DEF (0x224, AP_AMM1)
DEF (0x225, AP_AC1)
DEF (0x226, AP_AMV2)
DEF (0x227, AP_AMM2)
DEF (0x228, AP_AC2)
DEF (0x229, AP_AMV3)
DEF (0x22A, AP_AMM3)
DEF (0x22B, AP_AC3)
DEF (0x22C, AP_AMV4)
DEF (0x22D, AP_AMM4)
DEF (0x22E, AP_AC4)
DEF (0x22F, AP_AMV5)
DEF (0x230, AP_AMM5)
DEF (0x231, AP_AC5)
DEF (0x232, AP_AMV6)
DEF (0x233, AP_AMM6)
DEF (0x234, AP_AC6)
DEF (0x235, AP_AMV7)
DEF (0x236, AP_AMM7)
DEF (0x237, AP_AC7)
DEF (0x240, CC_*)
DEF (0x250, PCT_COUNT*)
DEF (0x260, PCT_SNAP*)
DEF (0x270, PCT_CONFIG*)
DEF (0x278, PCT_CONTROL)
DEF (0x279, PCT_BANK)
DEF (0x300, FP_STATUS)
DEF (0x300, RTT (A5 - A4))
DEF (0x301, AUX_DPFP1L)
DEF (0x301, RTT (A5 - A4))
DEF (0x302, AUX_DPFP1H)
DEF (0x302, RTT (A5 - A4))
DEF (0x303, AUX_DPFP2L)
DEF (0x303, RTT (A5 - A4))
DEF (0x304, AUX_DPFP2H)
DEF (0x304, RTT (A5 - A4))
DEF (0x305, DPFP_STATUS)
DEF (0x305, RTT (A5 - A4))
DEF (0x306, RTT)
DEF (0x400, ERET)
DEF (0x401, ERBTA)
DEF (0x402, ERSTATUS)
DEF (0x403, ECR)
DEF (0x404, EFA)
DEF (0x405, TLBPD0)
DEF (0x406, TLBPD1)
DEF (0x407, TLBIndex)
DEF (0x408, TLBCommand)
DEF (0x409, PID)
DEF (0x409, MPUEN)
DEF (0x40A, ICAUSE1)
DEF (0x40B, ICAUSE2)
DEF (0x40C, AUX_IENABLE)
DEF (0x40D, AUX_ITRIGGER)
DEF (0x410, XPU)
DEF (0x412, BTA)
DEF (0x413, BTA_L1)
DEF (0x414, BTA_L2)
DEF (0x415, AUX_IRQ_PULSE_CANCEL)
DEF (0x416, AUX_IRQ_PENDING)
DEF (0x418, SCRATCH_DATA0)
DEF (0x420, MPUIC)
DEF (0x421, MPUFA)
DEF (0x422, MPURDB0)
DEF (0x423, MPURDP0)
DEF (0x424, MPURDB1)
DEF (0x425, MPURDP1)
DEF (0x426, MPURDB2)
DEF (0x427, MPURDP2)
DEF (0x428, MPURDB3)
DEF (0x429, MPURDP3)
DEF (0x42A, MPURDB4)
DEF (0x42B, MPURDP4)
DEF (0x42C, MPURDB5)
DEF (0x42D, MPURDP5)
DEF (0x42E, MPURDB6)
DEF (0x42F, MPURDP6)
DEF (0x430, MPURDB7)
DEF (0x431, MPURDP7)
DEF (0x432, MPURDB8)
DEF (0x433, MPURDP8)
DEF (0x434, MPURDB9)
DEF (0x435, MPURDP9)
DEF (0x436, MPURDB10)
DEF (0x437, MPURDP10)
DEF (0x438, MPURDB11)
DEF (0x439, MPURDP11)
DEF (0x43A, MPURDB12)
DEF (0x43B, MPURDP12)
DEF (0x43C, MPURDB13)
DEF (0x43D, MPURDP13)
DEF (0x43E, MPURDB14)
DEF (0x43F, MPURDP14)
DEF (0x440, MPURDB15)
DEF (0x441, MPURDP15)
DEF (0x44F, EIA_FLAGS)
DEF (0x450, PM_STATUS)
DEF (0x451, WAKE)
DEF (0x452, DVFS_PERFORMANCE)
DEF (0x453, PWR_CTRL)
DEF (0x500, AUX_VLC_BUF_IDX)
DEF (0x501, AUX_VLC_READ_BUF)
DEF (0x502, AUX_VLC_VALID_BITS)
DEF (0x503, AUX_VLC_BUF_IN)
DEF (0x504, AUX_VLC_BUF_FREE)
DEF (0x505, AUX_VLC_IBUF_STATUS)
DEF (0x506, AUX_VLC_SETUP)
DEF (0x507, AUX_VLC_BITS)
DEF (0x508, AUX_VLC_TABLE)
DEF (0x509, AUX_VLC_GET_SYMBOL)
DEF (0x50A, AUX_VLC_READ_SYMBOL)
DEF (0x510, AUX_UCAVLC_SETUP)
DEF (0x511, AUX_UCAVLC_STATE)
DEF (0x512, AUX_CAVLC_ZERO_LEFT)
DEF (0x514, AUX_UVLC_I_STATE)
DEF (0x51C, AUX_VLC_DMA_PTR)
DEF (0x51D, AUX_VLC_DMA_END)
DEF (0x51E, AUX_VLC_DMA_ESC)
DEF (0x51F, AUX_VLC_DMA_CTRL)
DEF (0x520, AUX_VLC_GET_0BIT)
DEF (0x521, AUX_VLC_GET_1BIT)
DEF (0x522, AUX_VLC_GET_2BIT)
DEF (0x523, AUX_VLC_GET_3BIT)
DEF (0x524, AUX_VLC_GET_4BIT)
DEF (0x525, AUX_VLC_GET_5BIT)
DEF (0x526, AUX_VLC_GET_6BIT)
DEF (0x527, AUX_VLC_GET_7BIT)
DEF (0x528, AUX_VLC_GET_8BIT)
DEF (0x529, AUX_VLC_GET_9BIT)
DEF (0x52A, AUX_VLC_GET_10BIT)
DEF (0x52B, AUX_VLC_GET_11BIT)
DEF (0x52C, AUX_VLC_GET_12BIT)
DEF (0x52D, AUX_VLC_GET_13BIT)
DEF (0x52E, AUX_VLC_GET_14BIT)
DEF (0x52F, AUX_VLC_GET_15BIT)
DEF (0x530, AUX_VLC_GET_16BIT)
DEF (0x531, AUX_VLC_GET_17BIT)
DEF (0x532, AUX_VLC_GET_18BIT)
DEF (0x533, AUX_VLC_GET_19BIT)
DEF (0x534, AUX_VLC_GET_20BIT)
DEF (0x535, AUX_VLC_GET_21BIT)
DEF (0x536, AUX_VLC_GET_22BIT)
DEF (0x537, AUX_VLC_GET_23BIT)
DEF (0x538, AUX_VLC_GET_24BIT)
DEF (0x539, AUX_VLC_GET_25BIT)
DEF (0x53A, AUX_VLC_GET_26BIT)
DEF (0x53B, AUX_VLC_GET_27BIT)
DEF (0x53C, AUX_VLC_GET_28BIT)
DEF (0x53D, AUX_VLC_GET_29BIT)
DEF (0x53E, AUX_VLC_GET_30BIT)
DEF (0x53F, AUX_VLC_GET_31BIT)
DEF (0x540, AUX_CABAC_CTRL)
DEF (0x541, AUX_CABAC_CTX_STATE)
DEF (0x542, AUX_CABAC_COD_PARAM)
DEF (0x543, AUX_CABAC_MISC0)
DEF (0x544, AUX_CABAC_MISC1)
DEF (0x545, AUX_CABAC_MISC2)
DEF (0x600, ARC600_BUILD_CONFIG)
DEF (0x700, SMART_CONTROL)
DEF (0x701, SMART_DATA_0)
DEF (0x701, SMART_DATA_1)
DEF (0x701, SMART_DATA_2)
DEF (0x701, SMART_DATA_3)
