/*
    GNUbik -- A 3 dimensional magic cube game.
    Copyright (C) 2003  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef WIDGET_SET_H
#define WIDGET_SET_H


#include "gnubik.h"
#include "cube.h"

extern t_widget main_application_window;

void widget_set_init(int *argc, char *** argv) ;

t_widget create_top_level_widget(void);

t_widget create_container_widget(t_widget parent);

t_widget create_menubar(t_widget container,t_widget toplevel);


t_widget create_statusbar(t_widget container);
void update_statusbar(void);


void cleanup(void);

void show_widget(t_widget);

void start_main_loop();

void set_the_colours(t_widget w,const char *progname);
void setCubeColours(char *progname);


/* Declare that the cube has been solved */
void declare_win(Cube_Status status) ;

/* Popup an error dialog box */
void error_dialog(t_widget parent, const char *format,...);


#endif
