#include <grub/unicode.h>

struct grub_unicode_compact_range grub_unicode_compact[] = {
{0x0, 0x9, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9, 0x1, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa, 0x1, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb, 0x1, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd, 0x1, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe, 0xe, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c, 0x3, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f, 0x1, GRUB_BIDI_TYPE_S, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x20, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x21, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x23, 0x3, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x28, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2c, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2d, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e, 0x2, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30, 0xa, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3a, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3b, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3c, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3d, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3e, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3f, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5b, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x5c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5d, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x5e, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7b, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x7c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7d, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x7e, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7f, 0x6, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x85, 0x1, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x86, 0x1a, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa0, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa1, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa2, 0x4, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa6, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xab, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xac, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xad, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xae, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb0, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb2, 0x2, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb6, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb9, 0x1, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbb, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xbc, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd7, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf7, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b9, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2c2, 0xe, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2d2, 0xe, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e5, 0x9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ef, 0x11, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x300, 0x15, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x315, 0x1, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x316, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31a, 0x1, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31b, 0x1, GRUB_BIDI_TYPE_NSM, 216, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x31c, 0x5, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x321, 0x2, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x323, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x327, 0x2, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x329, 0xb, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x334, 0x5, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x339, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x33d, 0x8, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x345, 0x1, GRUB_BIDI_TYPE_NSM, 240, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x346, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x347, 0x3, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34a, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34d, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x34f, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x350, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x353, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x357, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x358, 0x1, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x359, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35b, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35c, 0x1, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35d, 0x2, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x35f, 0x1, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x360, 0x2, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x362, 0x1, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x363, 0xd, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x374, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x37e, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x384, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x387, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3f6, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x483, 0x5, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x488, 0x2, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x58a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x591, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x592, 0x4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x596, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x597, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59a, 0x1, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59b, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x59c, 0x6, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5a2, 0x6, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5a8, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5aa, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ab, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ad, 0x1, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5ae, 0x1, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5af, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b0, 0x1, GRUB_BIDI_TYPE_NSM, 10, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b1, 0x1, GRUB_BIDI_TYPE_NSM, 11, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b2, 0x1, GRUB_BIDI_TYPE_NSM, 12, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b3, 0x1, GRUB_BIDI_TYPE_NSM, 13, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b4, 0x1, GRUB_BIDI_TYPE_NSM, 14, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b5, 0x1, GRUB_BIDI_TYPE_NSM, 15, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b6, 0x1, GRUB_BIDI_TYPE_NSM, 16, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b7, 0x1, GRUB_BIDI_TYPE_NSM, 17, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b8, 0x1, GRUB_BIDI_TYPE_NSM, 18, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5b9, 0x2, GRUB_BIDI_TYPE_NSM, 19, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bb, 0x1, GRUB_BIDI_TYPE_NSM, 20, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bc, 0x1, GRUB_BIDI_TYPE_NSM, 21, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5bd, 0x1, GRUB_BIDI_TYPE_NSM, 22, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5be, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5bf, 0x1, GRUB_BIDI_TYPE_NSM, 23, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c0, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c1, 0x1, GRUB_BIDI_TYPE_NSM, 24, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c2, 0x1, GRUB_BIDI_TYPE_NSM, 25, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c3, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c4, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c5, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5c6, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5c7, 0x1, GRUB_BIDI_TYPE_NSM, 18, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x5d0, 0x1b, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x5f0, 0x5, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x600, 0x4, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x606, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x608, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x609, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60b, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60c, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60d, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x60e, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x610, 0x8, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x618, 0x1, GRUB_BIDI_TYPE_NSM, 30, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x619, 0x1, GRUB_BIDI_TYPE_NSM, 31, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x61a, 0x1, GRUB_BIDI_TYPE_NSM, 32, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x61b, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x61e, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x620, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x621, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x622, 0x4, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x626, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x627, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x628, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x629, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x62a, 0x5, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x62f, 0x4, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x633, 0xd, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x640, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x641, 0x7, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x648, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x649, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x64b, 0x1, GRUB_BIDI_TYPE_NSM, 27, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64c, 0x1, GRUB_BIDI_TYPE_NSM, 28, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64d, 0x1, GRUB_BIDI_TYPE_NSM, 29, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64e, 0x1, GRUB_BIDI_TYPE_NSM, 30, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x64f, 0x1, GRUB_BIDI_TYPE_NSM, 31, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x650, 0x1, GRUB_BIDI_TYPE_NSM, 32, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x651, 0x1, GRUB_BIDI_TYPE_NSM, 33, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x652, 0x1, GRUB_BIDI_TYPE_NSM, 34, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x653, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x655, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x657, 0x5, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x65c, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x65d, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x65f, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x660, 0xa, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66a, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66b, 0x2, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66d, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x66e, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x670, 0x1, GRUB_BIDI_TYPE_NSM, 35, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x671, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x674, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x675, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x678, 0x10, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x688, 0x12, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x69a, 0x26, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6c0, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6c1, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6c3, 0x9, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6cc, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6cd, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6ce, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6cf, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d0, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6d2, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d4, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6d5, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6d6, 0x7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6dd, 0x1, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6de, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6df, 0x4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e3, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e4, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e5, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6e7, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6e9, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6ea, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6eb, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6ed, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x6ee, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x6f0, 0xa, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6fa, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x6fd, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x6ff, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x700, 0xe, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x70f, 0x1, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x710, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x711, 0x1, GRUB_BIDI_TYPE_NSM, 36, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x712, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x715, 0x5, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x71a, 0x4, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x71e, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x71f, 0x9, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x728, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x729, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72a, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x72b, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72c, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x72d, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x72f, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x730, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x731, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x732, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x734, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x735, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x737, 0x3, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73a, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73b, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73d, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73e, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x73f, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x742, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x743, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x744, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x745, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x746, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x747, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x748, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x749, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x74d, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x74e, 0xb, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x759, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x75c, 0xf, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x76b, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x76d, 0x4, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x771, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x772, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x773, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x775, 0x3, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x778, 0x2, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_RIGHT},
{0x77a, 0x6, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x780, 0x26, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7a6, 0xb, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7b1, 0x1, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7c0, 0xa, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7ca, 0x21, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_DUAL},
{0x7eb, 0x7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f2, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f3, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x7f4, 0x2, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7f6, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x7fa, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x800, 0x16, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x816, 0x4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x81a, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x81b, 0x9, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x824, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x825, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x828, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x829, 0x5, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x830, 0xf, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x840, 0x19, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x859, 0x3, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x85e, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x900, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x903, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x93a, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x93b, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x93c, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x93e, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x941, 0x8, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x949, 0x4, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x94d, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x94e, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x951, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x952, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x953, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x955, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x962, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x981, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x982, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9bc, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9be, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9c1, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9c7, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9cb, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9cd, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9d7, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9e2, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x9f2, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x9fb, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa01, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa03, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa3c, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa3e, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa41, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa47, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa4b, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa4d, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa51, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa70, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa75, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa81, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa83, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabc, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xac1, 0x5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xac7, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xac9, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xacb, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xacd, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xae2, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaf1, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb01, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb02, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb3c, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb3e, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb3f, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb40, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb41, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb47, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4b, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb4d, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb56, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb57, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xb62, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xb82, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbbe, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbc0, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbc1, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbc6, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbca, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbcd, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xbd7, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbf3, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbf9, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xbfa, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc01, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc3e, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc41, 0x4, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc46, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc4a, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc4d, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc55, 0x1, GRUB_BIDI_TYPE_NSM, 84, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc56, 0x1, GRUB_BIDI_TYPE_NSM, 91, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc62, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xc78, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xc82, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcbc, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcbe, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcbf, 0x1, GRUB_BIDI_TYPE_L, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcc0, 0x5, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcc6, 0x1, GRUB_BIDI_TYPE_L, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcc7, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xcca, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xccc, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xccd, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xcd5, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xce2, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd02, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd3e, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd41, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd46, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd4a, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd4d, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd57, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xd62, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xd82, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdca, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdcf, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdd2, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdd6, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xdd8, 0x8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xdf2, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe31, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe34, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe38, 0x2, GRUB_BIDI_TYPE_NSM, 103, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe3a, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe3f, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe47, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe48, 0x4, GRUB_BIDI_TYPE_NSM, 107, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe4c, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb1, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb4, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xeb8, 0x2, GRUB_BIDI_TYPE_NSM, 118, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xebb, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xec8, 0x4, GRUB_BIDI_TYPE_NSM, 122, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xecc, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf18, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf35, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf37, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf39, 0x1, GRUB_BIDI_TYPE_NSM, 216, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf3a, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xf3e, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf71, 0x1, GRUB_BIDI_TYPE_NSM, 129, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf72, 0x1, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf73, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf74, 0x1, GRUB_BIDI_TYPE_NSM, 132, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf75, 0x5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7a, 0x4, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7e, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf7f, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xf80, 0x1, GRUB_BIDI_TYPE_NSM, 130, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf81, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf82, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf84, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf86, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf8d, 0xb, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xf99, 0x24, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfc6, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x102b, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x102d, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1031, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1032, 0x5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1037, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1038, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1039, 0x2, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x103b, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x103d, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1056, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1058, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x105e, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1062, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1067, 0x7, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1071, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1082, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1083, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1085, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1087, 0x6, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x108d, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x108f, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x109a, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x109d, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x135d, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1390, 0xa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1400, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1680, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x169b, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1712, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1714, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1732, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1734, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1752, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1772, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17b6, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17b7, 0x7, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17be, 0x8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17c6, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17c7, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17c9, 0x9, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17d2, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17d3, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17db, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x17dd, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x17f0, 0xa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1800, 0xb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x180b, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x180e, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x18a9, 0x1, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1920, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1923, 0x4, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1927, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1929, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1930, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1932, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1933, 0x6, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1939, 0x1, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x193a, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x193b, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1940, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1944, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19b0, 0x11, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19c8, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x19de, 0x22, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a17, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a18, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a19, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a55, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a56, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a57, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a58, 0x7, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a60, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a61, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a62, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a63, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a65, 0x8, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a6d, 0x6, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1a73, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a75, 0x8, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1a7f, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b00, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b04, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b34, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b35, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b36, 0x5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b3b, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b3c, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b3d, 0x5, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b42, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b43, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b44, 0x1, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1b6b, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b6c, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b6d, 0x7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b80, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1b82, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba1, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba2, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ba6, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ba8, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1baa, 0x1, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1be6, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1be7, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1be8, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1bea, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1bed, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1bee, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1bef, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1bf2, 0x2, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c24, 0x8, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c2c, 0x8, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1c34, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1c36, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1c37, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd0, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd4, 0x1, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cd5, 0x5, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cda, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cdc, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ce0, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ce1, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ce2, 0x7, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1ced, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1cf2, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1dc0, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dc2, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dc3, 0x7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dca, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcb, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcd, 0x1, GRUB_BIDI_TYPE_NSM, 234, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dce, 0x1, GRUB_BIDI_TYPE_NSM, 214, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dcf, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dd0, 0x1, GRUB_BIDI_TYPE_NSM, 202, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dd1, 0x16, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dfc, 0x1, GRUB_BIDI_TYPE_NSM, 233, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dfd, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dfe, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1dff, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1fbd, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fbf, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fcd, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fdd, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1fed, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1ffd, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2000, 0xb, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x200b, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x200c, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x200d, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_CAUSING},
{0x200f, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2010, 0x18, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2028, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2029, 0x1, GRUB_BIDI_TYPE_B, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x202a, 0x1, GRUB_BIDI_TYPE_LRE, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202b, 0x1, GRUB_BIDI_TYPE_RLE, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202c, 0x1, GRUB_BIDI_TYPE_PDF, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202d, 0x1, GRUB_BIDI_TYPE_LRO, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202e, 0x1, GRUB_BIDI_TYPE_RLO, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x202f, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2030, 0x5, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2035, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2039, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x203b, 0x9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2044, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2045, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2047, 0x18, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x205f, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2060, 0x5, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x206a, 0x6, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2070, 0x1, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2074, 0x6, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207a, 0x2, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x207d, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2080, 0xa, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208a, 0x2, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x208d, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x20a0, 0x1a, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x20d0, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d2, 0x2, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d4, 0x4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20d8, 0x3, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20db, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20dd, 0x4, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e1, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e2, 0x3, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e5, 0x2, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e7, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e8, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20e9, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20ea, 0x2, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20ec, 0x4, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x20f0, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2100, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2103, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2108, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2114, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2116, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x211e, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2125, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2127, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2129, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x212e, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x213a, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2140, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2141, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x214a, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2150, 0x10, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2189, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2190, 0x71, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2201, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2205, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2208, 0x6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x220e, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2211, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2212, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2213, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2214, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2215, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2217, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x221a, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x221e, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x221f, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2223, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2224, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2225, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2226, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2227, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x222b, 0x9, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2234, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2239, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x223a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x223b, 0x12, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x224d, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2252, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2256, 0x9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x225f, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2261, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2262, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2263, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2264, 0x8, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x226c, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x226e, 0x1f, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x228d, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x228f, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2293, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2298, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2299, 0x9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22a2, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22a4, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22a6, 0x13, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22b9, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22be, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22c0, 0x9, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22c9, 0x5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22ce, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22d0, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22d2, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22d6, 0x18, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x22ee, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x22f0, 0x10, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2300, 0x8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2308, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x230c, 0x14, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2320, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2322, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2329, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x232b, 0xb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x237b, 0x1a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2396, 0x5e, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2400, 0x27, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2440, 0xb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2460, 0x28, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2488, 0x14, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x24ea, 0x1c2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x26ad, 0x53, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2701, 0x67, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2768, 0xe, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2776, 0x4a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c0, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27c1, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c3, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27c7, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27c8, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27ca, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27cc, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27ce, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27d3, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27d7, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27dc, 0x3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27df, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x27e2, 0xe, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x27f0, 0x10, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2900, 0x83, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2983, 0x16, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2999, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x299b, 0x15, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29b0, 0x8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29b8, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29b9, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29c0, 0x6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29c6, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29c9, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29ca, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29ce, 0x5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29d3, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29d4, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29d6, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29d8, 0x5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29dd, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e1, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29e2, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e3, 0x3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29e6, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29e8, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29ea, 0xa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29f4, 0x6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29fa, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x29fc, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x29fe, 0xc, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a0a, 0x13, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a1d, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a1e, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a22, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a24, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a25, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a26, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a27, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a29, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2b, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a2f, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a34, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a36, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a3c, 0x3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a3f, 0x18, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a57, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a59, 0xb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a64, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a66, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6a, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6e, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a6f, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a71, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a73, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2a75, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2a79, 0x2b, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aa4, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aa6, 0x8, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aae, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aaf, 0x28, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2ad7, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2adc, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2add, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ade, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2adf, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ae2, 0x5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2ae7, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2aec, 0x3, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2aef, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2af3, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2af4, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2af7, 0x5, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2afc, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2afd, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2afe, 0x4f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2b50, 0xa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ce5, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2cef, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2cf9, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2d7f, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2de0, 0x20, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x2e00, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e02, 0x4, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e06, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e09, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0b, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0c, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e0e, 0xe, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e1c, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e1e, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e20, 0xa, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x2e2a, 0x8, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e80, 0x1a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2e9b, 0x59, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2f00, 0xd6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x2ff0, 0xc, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3000, 0x1, GRUB_BIDI_TYPE_WS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3001, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3008, 0xa, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x3012, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3014, 0x8, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x301c, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x302a, 0x1, GRUB_BIDI_TYPE_NSM, 218, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302b, 0x1, GRUB_BIDI_TYPE_NSM, 228, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302c, 0x1, GRUB_BIDI_TYPE_NSM, 232, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302d, 0x1, GRUB_BIDI_TYPE_NSM, 222, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x302e, 0x2, GRUB_BIDI_TYPE_NSM, 224, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x3030, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3036, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x303d, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3099, 0x2, GRUB_BIDI_TYPE_NSM, 8, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x309b, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30a0, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x30fb, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x31c0, 0x24, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x321d, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3250, 0x10, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x327c, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x32b1, 0xf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x32cc, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x3377, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x33de, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x33ff, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x4dc0, 0x40, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa490, 0x37, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa60d, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa66f, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa670, 0x3, GRUB_BIDI_TYPE_NSM, 253, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa673, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa67c, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa67e, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa6f0, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa700, 0x22, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa788, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa802, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa806, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa80b, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa823, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa825, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa827, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa828, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa838, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa874, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa880, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa8b4, 0x10, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa8c4, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa8e0, 0x12, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa926, 0x5, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa92b, 0x3, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa947, 0xb, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa952, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa953, 0x1, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa980, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa983, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9b3, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9b4, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9b6, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9ba, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9bc, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xa9bd, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xa9c0, 0x1, GRUB_BIDI_TYPE_L, 9, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa29, 0x6, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa2f, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa31, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa33, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa35, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa43, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa4c, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaa4d, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaa7b, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xaab0, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab2, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab4, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaab7, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaabe, 0x2, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xaac1, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe3, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabe5, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe6, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabe8, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xabe9, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabec, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xabed, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfb1d, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb1e, 0x1, GRUB_BIDI_TYPE_NSM, 26, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfb1f, 0xa, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb29, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb2a, 0xd, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb38, 0x5, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb3e, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb40, 0x2, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb43, 0x2, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb46, 0xa, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfb50, 0x72, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfbd3, 0x16b, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd3e, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd50, 0x40, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfd92, 0x36, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfdf0, 0xd, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfdfd, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe00, 0x10, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfe10, 0xa, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe20, 0x7, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfe30, 0x20, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe50, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe51, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe52, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe54, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe55, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe56, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe59, 0x6, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xfe5f, 0x1, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe60, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe62, 0x2, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe64, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xfe66, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe68, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe69, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe6b, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe70, 0x5, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfe76, 0x87, GRUB_BIDI_TYPE_AL, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfeff, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xff01, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff03, 0x3, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff06, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff08, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff0a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0b, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0c, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0d, 0x1, GRUB_BIDI_TYPE_ES, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff0e, 0x2, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff10, 0xa, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1a, 0x1, GRUB_BIDI_TYPE_CS, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1b, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1c, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff1d, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff1e, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff1f, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff3b, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff3c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff3d, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff3e, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5b, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff5c, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5d, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff5e, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff5f, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff61, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xff62, 0x2, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0xff64, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe0, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe2, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe5, 0x2, GRUB_BIDI_TYPE_ET, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xffe8, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xfff9, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xfffc, 0x2, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10101, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10140, 0x4b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10190, 0xc, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x101fd, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10800, 0x6, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10808, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1080a, 0x2c, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10837, 0x2, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1083c, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1083f, 0x17, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10857, 0x9, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10900, 0x1c, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1091f, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10920, 0x1a, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1093f, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a00, 0x1, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a01, 0x3, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a05, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0c, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0d, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0e, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a0f, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a10, 0x4, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a15, 0x3, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a19, 0x1b, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a38, 0x1, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a39, 0x1, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a3a, 0x1, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a3f, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x10a40, 0x8, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a50, 0x9, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10a60, 0x20, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b00, 0x36, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b39, 0x7, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b40, 0x16, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b58, 0x1b, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10b78, 0x8, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10c00, 0x49, GRUB_BIDI_TYPE_R, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x10e60, 0x1f, GRUB_BIDI_TYPE_AN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x11000, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x11001, 0x1, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x11002, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x11038, 0xe, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x11046, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x11052, 0x14, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x11080, 0x2, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x11082, 0x1, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b0, 0x3, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b3, 0x4, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x110b7, 0x2, GRUB_BIDI_TYPE_L, 254, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x110b9, 0x1, GRUB_BIDI_TYPE_NSM, 9, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x110ba, 0x1, GRUB_BIDI_TYPE_NSM, 7, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d165, 0x2, GRUB_BIDI_TYPE_L, 216, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d167, 0x3, GRUB_BIDI_TYPE_NSM, 1, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d16d, 0x1, GRUB_BIDI_TYPE_L, 226, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d16e, 0x5, GRUB_BIDI_TYPE_L, 216, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d173, 0x8, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d17b, 0x8, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d185, 0x5, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d18a, 0x2, GRUB_BIDI_TYPE_NSM, 220, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d1aa, 0x4, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d200, 0x42, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d242, 0x3, GRUB_BIDI_TYPE_NSM, 230, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0x1d245, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d300, 0x57, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1d6db, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d715, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d74f, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d789, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d7c3, 0x1, GRUB_BIDI_TYPE_ON, 0, 1, GRUB_JOIN_TYPE_NONJOINING},
{0x1d7ce, 0x32, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f000, 0x2c, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f030, 0x64, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f0a0, 0xf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f0b1, 0xe, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f0c1, 0xf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f0d1, 0xf, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f100, 0xb, GRUB_BIDI_TYPE_EN, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f300, 0x21, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f330, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f337, 0x46, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f380, 0x14, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f3a0, 0x25, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f3c6, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f3e0, 0x11, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f400, 0x3f, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f440, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f442, 0x4a, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f48d, 0x6b, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f4f9, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f500, 0x24, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f525, 0x19, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f550, 0x18, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f5fb, 0x5, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f601, 0x10, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f612, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f616, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f618, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f61a, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f61c, 0x3, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f620, 0x6, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f628, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f62d, 0x1, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f630, 0x4, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f635, 0xc, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f645, 0xb, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f680, 0x46, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0x1f700, 0x74, GRUB_BIDI_TYPE_ON, 0, 0, GRUB_JOIN_TYPE_NONJOINING},
{0xe0001, 0x1, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe0020, 0x60, GRUB_BIDI_TYPE_BN, 0, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0xe0100, 0xf0, GRUB_BIDI_TYPE_NSM, 255, 0, GRUB_JOIN_TYPE_TRANSPARENT},
{0, 0, 0, 0, 0, 0},
};
struct grub_unicode_bidi_pair grub_unicode_bidi_pairs[] = {
{0x28, 0x29},
{0x29, 0x28},
{0x3c, 0x3e},
{0x3e, 0x3c},
{0x5b, 0x5d},
{0x5d, 0x5b},
{0x7b, 0x7d},
{0x7d, 0x7b},
{0xab, 0xbb},
{0xbb, 0xab},
{0xf3a, 0xf3b},
{0xf3b, 0xf3a},
{0xf3c, 0xf3d},
{0xf3d, 0xf3c},
{0x169b, 0x169c},
{0x169c, 0x169b},
{0x2039, 0x203a},
{0x203a, 0x2039},
{0x2045, 0x2046},
{0x2046, 0x2045},
{0x207d, 0x207e},
{0x207e, 0x207d},
{0x208d, 0x208e},
{0x208e, 0x208d},
{0x2208, 0x220b},
{0x2209, 0x220c},
{0x220a, 0x220d},
{0x220b, 0x2208},
{0x220c, 0x2209},
{0x220d, 0x220a},
{0x2215, 0x29f5},
{0x223c, 0x223d},
{0x223d, 0x223c},
{0x2243, 0x22cd},
{0x2252, 0x2253},
{0x2253, 0x2252},
{0x2254, 0x2255},
{0x2255, 0x2254},
{0x2264, 0x2265},
{0x2265, 0x2264},
{0x2266, 0x2267},
{0x2267, 0x2266},
{0x2268, 0x2269},
{0x2269, 0x2268},
{0x226a, 0x226b},
{0x226b, 0x226a},
{0x226e, 0x226f},
{0x226f, 0x226e},
{0x2270, 0x2271},
{0x2271, 0x2270},
{0x2272, 0x2273},
{0x2273, 0x2272},
{0x2274, 0x2275},
{0x2275, 0x2274},
{0x2276, 0x2277},
{0x2277, 0x2276},
{0x2278, 0x2279},
{0x2279, 0x2278},
{0x227a, 0x227b},
{0x227b, 0x227a},
{0x227c, 0x227d},
{0x227d, 0x227c},
{0x227e, 0x227f},
{0x227f, 0x227e},
{0x2280, 0x2281},
{0x2281, 0x2280},
{0x2282, 0x2283},
{0x2283, 0x2282},
{0x2284, 0x2285},
{0x2285, 0x2284},
{0x2286, 0x2287},
{0x2287, 0x2286},
{0x2288, 0x2289},
{0x2289, 0x2288},
{0x228a, 0x228b},
{0x228b, 0x228a},
{0x228f, 0x2290},
{0x2290, 0x228f},
{0x2291, 0x2292},
{0x2292, 0x2291},
{0x2298, 0x29b8},
{0x22a2, 0x22a3},
{0x22a3, 0x22a2},
{0x22a6, 0x2ade},
{0x22a8, 0x2ae4},
{0x22a9, 0x2ae3},
{0x22ab, 0x2ae5},
{0x22b0, 0x22b1},
{0x22b1, 0x22b0},
{0x22b2, 0x22b3},
{0x22b3, 0x22b2},
{0x22b4, 0x22b5},
{0x22b5, 0x22b4},
{0x22b6, 0x22b7},
{0x22b7, 0x22b6},
{0x22c9, 0x22ca},
{0x22ca, 0x22c9},
{0x22cb, 0x22cc},
{0x22cc, 0x22cb},
{0x22cd, 0x2243},
{0x22d0, 0x22d1},
{0x22d1, 0x22d0},
{0x22d6, 0x22d7},
{0x22d7, 0x22d6},
{0x22d8, 0x22d9},
{0x22d9, 0x22d8},
{0x22da, 0x22db},
{0x22db, 0x22da},
{0x22dc, 0x22dd},
{0x22dd, 0x22dc},
{0x22de, 0x22df},
{0x22df, 0x22de},
{0x22e0, 0x22e1},
{0x22e1, 0x22e0},
{0x22e2, 0x22e3},
{0x22e3, 0x22e2},
{0x22e4, 0x22e5},
{0x22e5, 0x22e4},
{0x22e6, 0x22e7},
{0x22e7, 0x22e6},
{0x22e8, 0x22e9},
{0x22e9, 0x22e8},
{0x22ea, 0x22eb},
{0x22eb, 0x22ea},
{0x22ec, 0x22ed},
{0x22ed, 0x22ec},
{0x22f0, 0x22f1},
{0x22f1, 0x22f0},
{0x22f2, 0x22fa},
{0x22f3, 0x22fb},
{0x22f4, 0x22fc},
{0x22f6, 0x22fd},
{0x22f7, 0x22fe},
{0x22fa, 0x22f2},
{0x22fb, 0x22f3},
{0x22fc, 0x22f4},
{0x22fd, 0x22f6},
{0x22fe, 0x22f7},
{0x2308, 0x2309},
{0x2309, 0x2308},
{0x230a, 0x230b},
{0x230b, 0x230a},
{0x2329, 0x232a},
{0x232a, 0x2329},
{0x2768, 0x2769},
{0x2769, 0x2768},
{0x276a, 0x276b},
{0x276b, 0x276a},
{0x276c, 0x276d},
{0x276d, 0x276c},
{0x276e, 0x276f},
{0x276f, 0x276e},
{0x2770, 0x2771},
{0x2771, 0x2770},
{0x2772, 0x2773},
{0x2773, 0x2772},
{0x2774, 0x2775},
{0x2775, 0x2774},
{0x27c3, 0x27c4},
{0x27c4, 0x27c3},
{0x27c5, 0x27c6},
{0x27c6, 0x27c5},
{0x27c8, 0x27c9},
{0x27c9, 0x27c8},
{0x27d5, 0x27d6},
{0x27d6, 0x27d5},
{0x27dd, 0x27de},
{0x27de, 0x27dd},
{0x27e2, 0x27e3},
{0x27e3, 0x27e2},
{0x27e4, 0x27e5},
{0x27e5, 0x27e4},
{0x27e6, 0x27e7},
{0x27e7, 0x27e6},
{0x27e8, 0x27e9},
{0x27e9, 0x27e8},
{0x27ea, 0x27eb},
{0x27eb, 0x27ea},
{0x27ec, 0x27ed},
{0x27ed, 0x27ec},
{0x27ee, 0x27ef},
{0x27ef, 0x27ee},
{0x2983, 0x2984},
{0x2984, 0x2983},
{0x2985, 0x2986},
{0x2986, 0x2985},
{0x2987, 0x2988},
{0x2988, 0x2987},
{0x2989, 0x298a},
{0x298a, 0x2989},
{0x298b, 0x298c},
{0x298c, 0x298b},
{0x298d, 0x2990},
{0x298e, 0x298f},
{0x298f, 0x298e},
{0x2990, 0x298d},
{0x2991, 0x2992},
{0x2992, 0x2991},
{0x2993, 0x2994},
{0x2994, 0x2993},
{0x2995, 0x2996},
{0x2996, 0x2995},
{0x2997, 0x2998},
{0x2998, 0x2997},
{0x29b8, 0x2298},
{0x29c0, 0x29c1},
{0x29c1, 0x29c0},
{0x29c4, 0x29c5},
{0x29c5, 0x29c4},
{0x29cf, 0x29d0},
{0x29d0, 0x29cf},
{0x29d1, 0x29d2},
{0x29d2, 0x29d1},
{0x29d4, 0x29d5},
{0x29d5, 0x29d4},
{0x29d8, 0x29d9},
{0x29d9, 0x29d8},
{0x29da, 0x29db},
{0x29db, 0x29da},
{0x29f5, 0x2215},
{0x29f8, 0x29f9},
{0x29f9, 0x29f8},
{0x29fc, 0x29fd},
{0x29fd, 0x29fc},
{0x2a2b, 0x2a2c},
{0x2a2c, 0x2a2b},
{0x2a2d, 0x2a2e},
{0x2a2e, 0x2a2d},
{0x2a34, 0x2a35},
{0x2a35, 0x2a34},
{0x2a3c, 0x2a3d},
{0x2a3d, 0x2a3c},
{0x2a64, 0x2a65},
{0x2a65, 0x2a64},
{0x2a79, 0x2a7a},
{0x2a7a, 0x2a79},
{0x2a7d, 0x2a7e},
{0x2a7e, 0x2a7d},
{0x2a7f, 0x2a80},
{0x2a80, 0x2a7f},
{0x2a81, 0x2a82},
{0x2a82, 0x2a81},
{0x2a83, 0x2a84},
{0x2a84, 0x2a83},
{0x2a8b, 0x2a8c},
{0x2a8c, 0x2a8b},
{0x2a91, 0x2a92},
{0x2a92, 0x2a91},
{0x2a93, 0x2a94},
{0x2a94, 0x2a93},
{0x2a95, 0x2a96},
{0x2a96, 0x2a95},
{0x2a97, 0x2a98},
{0x2a98, 0x2a97},
{0x2a99, 0x2a9a},
{0x2a9a, 0x2a99},
{0x2a9b, 0x2a9c},
{0x2a9c, 0x2a9b},
{0x2aa1, 0x2aa2},
{0x2aa2, 0x2aa1},
{0x2aa6, 0x2aa7},
{0x2aa7, 0x2aa6},
{0x2aa8, 0x2aa9},
{0x2aa9, 0x2aa8},
{0x2aaa, 0x2aab},
{0x2aab, 0x2aaa},
{0x2aac, 0x2aad},
{0x2aad, 0x2aac},
{0x2aaf, 0x2ab0},
{0x2ab0, 0x2aaf},
{0x2ab3, 0x2ab4},
{0x2ab4, 0x2ab3},
{0x2abb, 0x2abc},
{0x2abc, 0x2abb},
{0x2abd, 0x2abe},
{0x2abe, 0x2abd},
{0x2abf, 0x2ac0},
{0x2ac0, 0x2abf},
{0x2ac1, 0x2ac2},
{0x2ac2, 0x2ac1},
{0x2ac3, 0x2ac4},
{0x2ac4, 0x2ac3},
{0x2ac5, 0x2ac6},
{0x2ac6, 0x2ac5},
{0x2acd, 0x2ace},
{0x2ace, 0x2acd},
{0x2acf, 0x2ad0},
{0x2ad0, 0x2acf},
{0x2ad1, 0x2ad2},
{0x2ad2, 0x2ad1},
{0x2ad3, 0x2ad4},
{0x2ad4, 0x2ad3},
{0x2ad5, 0x2ad6},
{0x2ad6, 0x2ad5},
{0x2ade, 0x22a6},
{0x2ae3, 0x22a9},
{0x2ae4, 0x22a8},
{0x2ae5, 0x22ab},
{0x2aec, 0x2aed},
{0x2aed, 0x2aec},
{0x2af7, 0x2af8},
{0x2af8, 0x2af7},
{0x2af9, 0x2afa},
{0x2afa, 0x2af9},
{0x2e02, 0x2e03},
{0x2e03, 0x2e02},
{0x2e04, 0x2e05},
{0x2e05, 0x2e04},
{0x2e09, 0x2e0a},
{0x2e0a, 0x2e09},
{0x2e0c, 0x2e0d},
{0x2e0d, 0x2e0c},
{0x2e1c, 0x2e1d},
{0x2e1d, 0x2e1c},
{0x2e20, 0x2e21},
{0x2e21, 0x2e20},
{0x2e22, 0x2e23},
{0x2e23, 0x2e22},
{0x2e24, 0x2e25},
{0x2e25, 0x2e24},
{0x2e26, 0x2e27},
{0x2e27, 0x2e26},
{0x2e28, 0x2e29},
{0x2e29, 0x2e28},
{0x3008, 0x3009},
{0x3009, 0x3008},
{0x300a, 0x300b},
{0x300b, 0x300a},
{0x300c, 0x300d},
{0x300d, 0x300c},
{0x300e, 0x300f},
{0x300f, 0x300e},
{0x3010, 0x3011},
{0x3011, 0x3010},
{0x3014, 0x3015},
{0x3015, 0x3014},
{0x3016, 0x3017},
{0x3017, 0x3016},
{0x3018, 0x3019},
{0x3019, 0x3018},
{0x301a, 0x301b},
{0x301b, 0x301a},
{0xfe59, 0xfe5a},
{0xfe5a, 0xfe59},
{0xfe5b, 0xfe5c},
{0xfe5c, 0xfe5b},
{0xfe5d, 0xfe5e},
{0xfe5e, 0xfe5d},
{0xfe64, 0xfe65},
{0xfe65, 0xfe64},
{0xff08, 0xff09},
{0xff09, 0xff08},
{0xff1c, 0xff1e},
{0xff1e, 0xff1c},
{0xff3b, 0xff3d},
{0xff3d, 0xff3b},
{0xff5b, 0xff5d},
{0xff5d, 0xff5b},
{0xff5f, 0xff60},
{0xff60, 0xff5f},
{0xff62, 0xff63},
{0xff63, 0xff62},
{0, 0},
};
struct grub_unicode_arabic_shape grub_unicode_arabic_shapes[] = {
 {0x622, 0xfe81, 0xfe82, 0x0, 0x0},
 {0x623, 0xfe83, 0xfe84, 0x0, 0x0},
 {0x624, 0xfe85, 0xfe86, 0x0, 0x0},
 {0x625, 0xfe87, 0xfe88, 0x0, 0x0},
 {0x626, 0xfe89, 0xfe8a, 0xfe8c, 0xfe8b},
 {0x627, 0xfe8d, 0xfe8e, 0x0, 0x0},
 {0x628, 0xfe8f, 0xfe90, 0xfe92, 0xfe91},
 {0x629, 0xfe93, 0xfe94, 0x0, 0x0},
 {0x62a, 0xfe95, 0xfe96, 0xfe98, 0xfe97},
 {0x62b, 0xfe99, 0xfe9a, 0xfe9c, 0xfe9b},
 {0x62c, 0xfe9d, 0xfe9e, 0xfea0, 0xfe9f},
 {0x62d, 0xfea1, 0xfea2, 0xfea4, 0xfea3},
 {0x62e, 0xfea5, 0xfea6, 0xfea8, 0xfea7},
 {0x62f, 0xfea9, 0xfeaa, 0x0, 0x0},
 {0x630, 0xfeab, 0xfeac, 0x0, 0x0},
 {0x631, 0xfead, 0xfeae, 0x0, 0x0},
 {0x632, 0xfeaf, 0xfeb0, 0x0, 0x0},
 {0x633, 0xfeb1, 0xfeb2, 0xfeb4, 0xfeb3},
 {0x634, 0xfeb5, 0xfeb6, 0xfeb8, 0xfeb7},
 {0x635, 0xfeb9, 0xfeba, 0xfebc, 0xfebb},
 {0x636, 0xfebd, 0xfebe, 0xfec0, 0xfebf},
 {0x637, 0xfec1, 0xfec2, 0xfec4, 0xfec3},
 {0x638, 0xfec5, 0xfec6, 0xfec8, 0xfec7},
 {0x639, 0xfec9, 0xfeca, 0xfecc, 0xfecb},
 {0x63a, 0xfecd, 0xfece, 0xfed0, 0xfecf},
 {0x641, 0xfed1, 0xfed2, 0xfed4, 0xfed3},
 {0x642, 0xfed5, 0xfed6, 0xfed8, 0xfed7},
 {0x643, 0xfed9, 0xfeda, 0xfedc, 0xfedb},
 {0x644, 0xfedd, 0xfede, 0xfee0, 0xfedf},
 {0x645, 0xfee1, 0xfee2, 0xfee4, 0xfee3},
 {0x646, 0xfee5, 0xfee6, 0xfee8, 0xfee7},
 {0x647, 0xfee9, 0xfeea, 0xfeec, 0xfeeb},
 {0x648, 0xfeed, 0xfeee, 0x0, 0x0},
 {0x64a, 0xfef1, 0xfef2, 0xfef4, 0xfef3},
 {0x671, 0xfb50, 0xfb51, 0x0, 0x0},
 {0x679, 0xfb66, 0xfb67, 0xfb69, 0xfb68},
 {0x67a, 0xfb5e, 0xfb5f, 0xfb61, 0xfb60},
 {0x67b, 0xfb52, 0xfb53, 0xfb55, 0xfb54},
 {0x67e, 0xfb56, 0xfb57, 0xfb59, 0xfb58},
 {0x67f, 0xfb62, 0xfb63, 0xfb65, 0xfb64},
 {0x680, 0xfb5a, 0xfb5b, 0xfb5d, 0xfb5c},
 {0x683, 0xfb76, 0xfb77, 0xfb79, 0xfb78},
 {0x684, 0xfb72, 0xfb73, 0xfb75, 0xfb74},
 {0x686, 0xfb7a, 0xfb7b, 0xfb7d, 0xfb7c},
 {0x687, 0xfb7e, 0xfb7f, 0xfb81, 0xfb80},
 {0x688, 0xfb88, 0xfb89, 0x0, 0x0},
 {0x68c, 0xfb84, 0xfb85, 0x0, 0x0},
 {0x68d, 0xfb82, 0xfb83, 0x0, 0x0},
 {0x68e, 0xfb86, 0xfb87, 0x0, 0x0},
 {0x691, 0xfb8c, 0xfb8d, 0x0, 0x0},
 {0x698, 0xfb8a, 0xfb8b, 0x0, 0x0},
 {0x6a4, 0xfb6a, 0xfb6b, 0xfb6d, 0xfb6c},
 {0x6a6, 0xfb6e, 0xfb6f, 0xfb71, 0xfb70},
 {0x6a9, 0xfb8e, 0xfb8f, 0xfb91, 0xfb90},
 {0x6ad, 0xfbd3, 0xfbd4, 0xfbd6, 0xfbd5},
 {0x6af, 0xfb92, 0xfb93, 0xfb95, 0xfb94},
 {0x6b1, 0xfb9a, 0xfb9b, 0xfb9d, 0xfb9c},
 {0x6b3, 0xfb96, 0xfb97, 0xfb99, 0xfb98},
 {0x6bb, 0xfba0, 0xfba1, 0xfba3, 0xfba2},
 {0x6be, 0xfbaa, 0xfbab, 0xfbad, 0xfbac},
 {0x6c0, 0xfba4, 0xfba5, 0x0, 0x0},
 {0x6c1, 0xfba6, 0xfba7, 0xfba9, 0xfba8},
 {0x6c5, 0xfbe0, 0xfbe1, 0x0, 0x0},
 {0x6c6, 0xfbd9, 0xfbda, 0x0, 0x0},
 {0x6c7, 0xfbd7, 0xfbd8, 0x0, 0x0},
 {0x6c8, 0xfbdb, 0xfbdc, 0x0, 0x0},
 {0x6c9, 0xfbe2, 0xfbe3, 0x0, 0x0},
 {0x6cb, 0xfbde, 0xfbdf, 0x0, 0x0},
 {0x6cc, 0xfbfc, 0xfbfd, 0xfbff, 0xfbfe},
 {0x6d0, 0xfbe4, 0xfbe5, 0xfbe7, 0xfbe6},
 {0x6d2, 0xfbae, 0xfbaf, 0x0, 0x0},
 {0x6d3, 0xfbb0, 0xfbb1, 0x0, 0x0},
 {0, 0, 0, 0, 0},
};
