/* Copyright (C) 2015 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Ludovic Courtès <ludo@gnu.org>.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include <argz.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>


error_t
__argz_suffix_entries (char **argz, size_t *argz_len, const char *suffix)

{
  size_t suffix_len = strlen (suffix);
  size_t count = __argz_count (*argz, *argz_len);
  size_t new_argz_len = *argz_len + count * suffix_len;
  char *new_argz = malloc (new_argz_len);

  if (new_argz)
    {
      char *p = new_argz, *entry;

      for (entry = *argz;
	   entry != NULL;
	   entry = argz_next (*argz, *argz_len, entry))
	{
	  p = stpcpy (p, entry);
	  p = stpcpy (p, suffix);
	  p++;
	}

      free (*argz);
      *argz = new_argz;
      *argz_len = new_argz_len;

      return 0;
    }
  else
    return ENOMEM;
}
weak_alias (__argz_suffix_entries, argz_suffix_entries)
