/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2013, 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: properties.c
 *    This file is part of Prime.
 *
 *    Prime is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Prime is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Prime.  If not, see <http://www.gnu.org/licenses/>.
 */    

#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include "defs.h"
#include "dirstruct.h"
#include kbd_header

void refreshPropertiesDialog(char* input_str);
int UREAD, UWRITE, UEXECUTE;
int GREAD, GWRITE, GEXECUTE;
int OREAD, OWRITE, OEXECUTE;
int NAME_CHANGED = 0;
int x, y, w, h;
int sel;


void refreshPropertiesDialog(char *input_str)
{
    int i;
    //set the user interface
    setScreenColorsI(COLOR_WINDOW);
    fprintf(stdout, "\e[%d;%dH", x+1, y+2);
    if(activeWindow == DIR_WIN) fprintf(stdout, "Dir name:  ");
    else fprintf(stdout, "File name: ");
    if(strlen(input_str) > 26) 
    {
        for(i = 0; i < 24; i++) putchar(input_str[i]);
        fputs("..", stdout);
    }
    else fprintf(stdout, "%s", input_str);
  
    fprintf(stdout, "\e[%d;%dH", x+3, y+2);
    fprintf(stdout, "Permissions:");
    fprintf(stdout, "\e[%d;%dH", x+4, y+2);
    fprintf(stdout, "Owner:      Group:      Others:    ");
    fprintf(stdout, "\e[%d;%dH", x+5, y+2);
    fprintf(stdout, "[ ] Read    [ ] Read    [ ] Read   ");
    fprintf(stdout, "\e[%d;%dH", x+6, y+2);
    fprintf(stdout, "[ ] Write   [ ] Write   [ ] Write  ");
    fprintf(stdout, "\e[%d;%dH", x+7, y+2);
    fprintf(stdout, "[ ] Execute [ ] Execute [ ] Execute");
    setScreenColorsI(COLOR_BUTTONS);
    fprintf(stdout, "\e[%d;%dH   OK   ", x+9, y+10);
    fprintf(stdout, "\e[%d;%dH CANCEL ", x+9, y+22);

    setScreenColorsI(COLOR_WINDOW);
    if(UREAD   ) { fprintf(stdout, "\e[%d;%dHX", x+5, y+3 ); }
    if(UWRITE  ) { fprintf(stdout, "\e[%d;%dHX", x+6, y+3 ); }
    if(UEXECUTE) { fprintf(stdout, "\e[%d;%dHX", x+7, y+3 ); }
    if(GREAD   ) { fprintf(stdout, "\e[%d;%dHX", x+5, y+15); }
    if(GWRITE  ) { fprintf(stdout, "\e[%d;%dHX", x+6, y+15); }
    if(GEXECUTE) { fprintf(stdout, "\e[%d;%dHX", x+7, y+15); }
    if(OREAD   ) { fprintf(stdout, "\e[%d;%dHX", x+5, y+27); }
    if(OWRITE  ) { fprintf(stdout, "\e[%d;%dHX", x+6, y+27); }
    if(OEXECUTE) { fprintf(stdout, "\e[%d;%dHX", x+7, y+27); }
  
    setScreenColorsI(COLOR_HIGHLIGHT_TEXT);
    switch(sel)
    {
        case 0:
            fprintf(stdout, "\e[%d;%dH", x+1, y+13);
            if(strlen(input_str) > 26) 
            {
                for(i = 0; i < 24; i++) putchar(input_str[i]);
                fputs("..", stdout);
            }
            else fprintf(stdout, "%s", input_str);
            break;
        case 1:
            fprintf(stdout, "\e[%d;%dHRead", x+5, y+6);
            break;
        case 2:
            fprintf(stdout, "\e[%d;%dHRead", x+5, y+18);
            break;
        case 3:
            fprintf(stdout, "\e[%d;%dHRead", x+5, y+30);
            break;
        case 4:
            fprintf(stdout, "\e[%d;%dHWrite", x+6, y+6);
            break;
        case 5:
            fprintf(stdout, "\e[%d;%dHWrite", x+6, y+18);
            break;
        case 6:
            fprintf(stdout, "\e[%d;%dHWrite", x+6, y+30);
            break;
        case 7:
            fprintf(stdout, "\e[%d;%dHExecute", x+7, y+6);
            break;
        case 8:
            fprintf(stdout, "\e[%d;%dHExecute", x+7, y+18);
            break;
        case 9:
            fprintf(stdout, "\e[%d;%dHExecute", x+7, y+30);
            break;
        case 10:
            setScreenColorsI(COLOR_HBUTTONS);
            fprintf(stdout, "\e[%d;%dH   OK   ", x+9, y+10);
            break;
        case 11:
            setScreenColorsI(COLOR_HBUTTONS);
            fprintf(stdout, "\e[%d;%dH CANCEL ", x+9, y+22);
            break;
    }
    fflush(stdout);
}

void showPropertiesDialog()
{
    struct stat statbuf;
    struct dirstruct *dir;
    if(activeWindow == DIR_WIN) dir = dirs[firstVisDir+selectedDir];
    else dir = files[firstVisFile+selectedFile];
 
    UREAD = 0; UWRITE = 0; UEXECUTE = 0;
    GREAD = 0; GWRITE = 0; GEXECUTE = 0;
    OREAD = 0; OWRITE = 0; OEXECUTE = 0;
    sel = 0;
    h = 10; w = 40;
    x = (SCREEN_H/2)-(h/2);
    y = (SCREEN_W/2)-(w/2);

    //******read dir/file permissions ******//
    if(lstat(dir->name, &statbuf) == -1)
    {
        msgBoxH(strerror(errno), OK, ERROR);
        return;
    }
    if(statbuf.st_mode & S_IRUSR) { UREAD    = 1; }
    if(statbuf.st_mode & S_IWUSR) { UWRITE   = 1; }
    if(statbuf.st_mode & S_IXUSR) { UEXECUTE = 1; }
    if(statbuf.st_mode & S_IRGRP) { GREAD    = 1; }
    if(statbuf.st_mode & S_IWGRP) { GWRITE   = 1; }
    if(statbuf.st_mode & S_IXGRP) { GEXECUTE = 1; }
    if(statbuf.st_mode & S_IROTH) { OREAD    = 1; }
    if(statbuf.st_mode & S_IWOTH) { OWRITE   = 1; }
    if(statbuf.st_mode & S_IXOTH) { OEXECUTE = 1; }

    char *name = (char *)malloc(dir->namelen+1);
    if(!name)
    {
        msgBoxH("Insufficient memory!", OK, ERROR);
        return;
    }
    strcpy(name, dir->name);

    //showCursor();
    //draw window
    setScreenColorsI(COLOR_WINDOW);
    drawBox(x, y, x+h, w+y, " Properties ", YES);
    refreshPropertiesDialog(name);

    /////////////////////////////////////
    //Loop for user input  
    /////////////////////////////////////
    int c;
    int endme = 0;
    mode_t mode;
    while(!endme) 
    {
        c = getKey();
        switch(c) 
        {
            case(TAB_KEY):
                if(sel >= 0) sel++;
                if(sel > 11) sel = 0;
                break;
            case('p'):
                if(GNU_DOS_LEVEL > 1 && CTRL) goto do_up;
                break;
            case(UP_KEY):
                if(GNU_DOS_LEVEL > 1) break;
do_up:
                if(sel == 0) sel = 10;
                else if(sel >= 10) sel = 7;
                else if(sel >= 1 && sel <= 3) sel = 0;
                else if(sel >= 4 && sel <= 9) sel -= 3;
                break;
            case('n'):
                if(GNU_DOS_LEVEL > 1 && CTRL) goto do_down;
                break;
            case(DOWN_KEY):
                if(GNU_DOS_LEVEL > 1) break;
do_down:
                if(sel == 0) sel = 1;
                else if(sel >= 10) sel = 0;
                else if(sel >= 7 && sel <= 9) sel = 10;
                else if(sel >= 1 && sel <= 6) sel += 3;
                break;
            case('f'):
                if(GNU_DOS_LEVEL > 1 && CTRL) goto do_right;
                break;
            case(RIGHT_KEY):
                if(GNU_DOS_LEVEL > 1) break;
do_right:
                if(sel > 0) sel++;
                if(sel > 11) sel = 0;
                break;
            case('b'):
                if(GNU_DOS_LEVEL > 1 && CTRL) goto do_left;
                break;
            case(LEFT_KEY):
                if(GNU_DOS_LEVEL > 1) break;
do_left:
                if(sel > 0) sel--;
                break;
            case('g'):
                if(GNU_DOS_LEVEL < 3) break;
                if(!CTRL) break;
                goto do_esc;
            case(ESC_KEY):
                if(GNU_DOS_LEVEL > 2) break;
do_esc:
                endme = 1;
                break;
            case(SPACE_KEY):
            case(ENTER_KEY):
                switch(sel)
                {
                    case 0:
                        inputBoxI("Enter new name: ", name, " Rename... " );
                        int len = strlen(input);
                        if(len)
                        {
                            free(name);
                            name = (char *)malloc(len+1);
                            if(!name)
                            {
                                msgBoxH("Insufficient memory!", OK, ERROR);
                                return;
                            }
                            strcpy(name, input);
                            NAME_CHANGED = 1;
                        }
                        setScreenColorsI(COLOR_WINDOW);
                        drawBox(x, y, x+h, w+y, " Properties ", YES);
                        break;
                    case 1:
                        UREAD = !UREAD;
                        break;
                    case 2:
                        GREAD = !GREAD;
                        break;
                    case 3:
                        OREAD = !OREAD;
                        break;
                    case 4:
                        UWRITE = !UWRITE;
                        break;
                    case 5:
                        GWRITE = !GWRITE;
                        break;
                    case 6:
                        OWRITE = !OWRITE;
                        break;
                    case 7:
                        UEXECUTE = !UEXECUTE;
                        break;
                    case 8:
                        GEXECUTE = !GEXECUTE;
                        break;
                    case 9:
                        OEXECUTE = !OEXECUTE;
                        break;
                    case 11:
                        endme = 1;
                        break;
                    case 10:
                        mode = 00;
                        if(UREAD   ) mode += 0400;
                        if(UWRITE  ) mode += 0200;
                        if(UEXECUTE) mode += 0100;
                        if(GREAD   ) mode += 040;
                        if(GWRITE  ) mode += 020;
                        if(GEXECUTE) mode += 010;
                        if(OREAD   ) mode += 04;
                        if(OWRITE  ) mode += 02;
                        if(OEXECUTE) mode += 01;
                        if(chmod(dir->name, mode) != 0) 
                        {
                            msgBoxH(strerror(errno), OK, ERROR);
                        }
                        if(NAME_CHANGED) 
                        {
                            if(rename(dir->name, name) != 0)
                            msgBoxH(strerror(errno), OK, ERROR);
                        }
                        endme = 1;
                        break;
                }
                break;
        }
        refreshPropertiesDialog(name);
    }
    free(name);
    hideCursor();
}
