/* 
 * Copyright (c) 1995-1994 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 *
 *      Author: Bryan Ford, University of Utah CSL
 */

#include "config.h"

/* Kernel segment descriptors (32-bit flat address space).  */
gdt_sel(KERNEL_CS)
gdt_sel(KERNEL_DS)

/* Corresponding 16-bit descriptors for protected-mode entry and exit.  */
gdt_sel(KERNEL_16_CS)
gdt_sel(KERNEL_16_DS)

/* Code and data segments that always maps directly to flat, linear memory.  */
gdt_sel(LINEAR_CS)
gdt_sel(LINEAR_DS)

/* Standard LDT and TSS descriptors.  */
#ifdef ENABLE_KERNEL_LDT
gdt_sel(KERNEL_LDT)
#endif
#ifdef ENABLE_KERNEL_TSS
gdt_sel(KERNEL_TSS)
#endif

