/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Sample application to illustrate the use of a GrSimpleScopeSink.
 * The input here is provided by the VrSigSource signal generator.
 */

#include <VrSigSource.h>
#include <GrFFTSink.h>
#include <VrNullSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include "VrGUI.h" 

#define SAMPLING_FREQUENCY                          1e6
#define	MAX_FREQUENCY		(SAMPLING_FREQUENCY / 2)
#define SIG_GEN_FREQUENCY          		  200e3
#define AMPLITUDE                                 32767
#define WAVEFORM                            VR_SIN_WAVE


#define	DEFAULT_TPD				1000	// bogus

#define IOTYPE float

VrSigSource<IOTYPE> *source;
GrFFTSink<IOTYPE> *scope_sink;

void set_my_freq(double f) {
  cerr << "@@@ set_my_freq: " << f << '\n';
  source->setFrequency(f);
}

int main(int argc, char **argv) {
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();
  VrSink<IOTYPE> *sink;
  VrMultiTask *m = new VrMultiTask ();

  source = new VrSigSource<IOTYPE>(SAMPLING_FREQUENCY, WAVEFORM, SIG_GEN_FREQUENCY, AMPLITUDE);
  scope_sink = new GrFFTSink<IOTYPE>(vert, 150, 250, 1024);

  (void) new VrGUINumber(horiz, "Signal Generator",
			 "Frequency (cycles/sec)", set_my_freq,
			 MAX_FREQUENCY, SIG_GEN_FREQUENCY);

  sink = scope_sink;
  // sink = new VrNullSink<short>();

  m->add (sink);
  
  NWO_CONNECT (source, sink);

  m->start();
  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
