/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRFFT_VFC_H_
#define _GRFFT_VFC_H_

#include <VrSigProc.h>

class gr_fft_complex;

/*!
 * \brief compute forward or reverse FFT.  float vector in / complex vector out
 */

class GrFFT_vFC : public VrSigProc
{
 private:
  int		         d_fft_size;
  bool			 d_window;
  float			*d_winvals;
  gr_fft_complex	*d_fft;
  
 public:
  GrFFT_vFC (int fft_size, bool forward = true, bool window = true);
  ~GrFFT_vFC ();

  virtual const char *name () { return "GrFFT_vFC"; }
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);
};

#endif /* _GRFFT_VFC_H_ */
