/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_GrFIRfilterXXX.py
 * Any changes made to this file will be overwritten.
 */

#ifndef _@NAME@_H_
#define	_@NAME@_H_

#include <VrDecimatingSigProc.h>
#include <@FIR_BUILDER@.h>

class @FIR_TYPE@;

/*!
 * \brief FIR filter with @I_TYPE@ input, @O_TYPE@ output and @TAP_TYPE@ taps
 */

class @NAME@ : public VrDecimatingSigProc<@I_TYPE@, @O_TYPE@>
{
 public:
  /*!
   * Construct a FIR filter with the given taps
   */
  @NAME@ (int decimation_factor, const std::vector<@TAP_TYPE@> &taps);

  /*!
   * Construct a FIR filter where the taps will be determined
   * at initialization time by invoking builder->taps (sampling_freq)
   *
   * @NAME@ becomes responsible for life time management
   * of builder.
   */
  @NAME@ (int decimation_factor, @FIR_BUILDER@ *builder);
  virtual ~@NAME@ ();

  virtual const char *name () { return "@NAME@"; }
  virtual void initialize ();
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);

  void setTaps (const std::vector<@TAP_TYPE@> &taps);

 protected:
  @FIR_BUILDER@	*d_builder;
  @FIR_TYPE@		*d_fir;
  std::vector<@TAP_TYPE@>	d_new_taps;
  int			d_updated;
};

#endif // _@NAME@_H_
