/* -*-C++-*-
*******************************************************************************
*
* File:         GrTestSource.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "GrTestSource.h"
#include <stdio.h>
#include <cppunit/TestAssert.h>

#define	OUTPUT_SIZE	1000L

// add code to handle output size and check values.

GrTestSource::GrTestSource (double sampling_freq, bool use_sync_mode)
{
  sync_mode_p = use_sync_mode;
  last = (VrSampleIndex) 0;
  setSamplingFrequency (sampling_freq);
  setOutputSize (OUTPUT_SIZE);
}

int
GrTestSource::work2 (VrSampleRange output, void *ao[])
{
  unsigned long **o = (unsigned long **)ao;
  unsigned long	i;
  unsigned long	size = output.size;
  unsigned long index = output.index;

  if ((size % OUTPUT_SIZE) != 0){
    fprintf (stderr, "GrTestSource: size %% OUTPUT_SIZE != 0: %ld %% %ld = %ld\n",
	     size, OUTPUT_SIZE, size % OUTPUT_SIZE);
    CppUnit::TestAssert::assertEquals (0, size % OUTPUT_SIZE, __LINE__, __FILE__);
  }

#if 0	// not required
  if ((index % OUTPUT_SIZE) != 0){
    fprintf (stderr, "GrTestSource: index %% OUTPUT_SIZE != 0: %ld %% %ld = %ld\n",
	     index, OUTPUT_SIZE, index % OUTPUT_SIZE);
    CppUnit::TestAssert::assertEquals (0, index % OUTPUT_SIZE, __LINE__, __FILE__);
  }
#endif

  if (sync_mode_p){
    sync (output.index);

    // check for contiguous output range
    if (last != output.index){
      fprintf (stderr, "GrTestSource: last != output.index: %lld != %lld\n", last, output.index);
      CppUnit::TestAssert::assertEquals (last, output.index, __LINE__, __FILE__);
    }
  }
  else {
    // check for monotonically increasing index
    if (output.index < last){
      fprintf (stderr, "GrTestSource: output.index < last: %lld < %lld\n", output.index, last);
      assert (output.index >= last);
    }
  }
  
  for (i = 0; i < size; i++)
    o[0][i] = index++;

  last = output.index + output.size;
  return output.size;
}
