/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRCONNECT_H_
#define _VRCONNECT_H_


class VrSigProc;
class VrBuffer;
#include<VrBuffer.h>

class VrConnect {
  friend class VrBuffer;

private:
  VrBuffer 	*buffer;
  VrSigProc	*ds_sigproc; 
  volatile 	readerLL *first, *last;
  volatile 	VrSampleIndex lastRP; 
  MUTEX_DECLARE (mutex);

public: 
  void attach_reader(readerLL *r,VrSampleIndex nextBlock) {
    MUTEX_LOCK(&mutex);

    //jca printf("attach_reader[%s] r %x first %x block %lld\n",
    //	getUpstreamModule()->name(), r, first, nextBlock);

    if(first==NULL) {
      first=r;

      // -eb if work doesn't complete all work, this test isn't valid.
      if(0 && PARANOID && lastRP > r->index) {
	fprintf(stderr, "Out of order read threads (predicted read VrSampleIndex incorrect).\n");
	abort ();
      }
    }
    else {
      last->next=r;

      if(PARANOID && last->index > r->index) {
	fprintf(stderr, "Out of order read threads.\n");
	abort ();
      }
    } 

    last=r;
    lastRP=nextBlock; //what's coming up next 
    MUTEX_UNLOCK(&mutex);
  }

  void detach_reader(readerLL *r) {
    MUTEX_LOCK(&mutex);
    if(first==r) {
      first=r->next;
      if(last==r) {
	last=NULL;
	//	lastRP=r->index;
      }
    }
    else {
      readerLL *t= (readerLL *) first;
      while(t->next != r) {
	t=t->next;
      }
      t->next=r->next; 
      if(last==r) {
	last = t;
	//	lastRP=r->index;
	//What will the next block from downstream ask for?
      }
    } 
    MUTEX_UNLOCK(&mutex);
    //jca printf("detach_reader[%s] r %x first %x last %x\n",
    //	getUpstreamModule()->name(), r, first, last);
  }

  VrSampleIndex minRP() {
    MUTEX_LOCK(&mutex);
    VrSampleIndex m=lastRP; 

    //jca printf("[%s:%d] minRP[%s] m %lld\n",
    //	__FILE__, __LINE__, getUpstreamModule()->name(), m);

    readerLL *t= (readerLL *) first;

    while (t) {

      //jca printf("[%s:%d] t %x next %x minRP[%s] index %lld\n",
      // __FILE__, __LINE__, (int)t, (int)t->next, getUpstreamModule()->name(), t->index);

      if (t->index < m)
	m = t->index;
      t = t->next;
    } 

    MUTEX_UNLOCK(&mutex);
    return m;
  } 

  char *getReadPointer(VrSampleRange r) { return buffer->getReadPointer(r); } 

  VrSigProc *getUpstreamModule() { return buffer->getUpstreamModule(); } 

  //Make input connector for s reading from buffer b     //     
  VrConnect(VrSigProc*s, VrBuffer* b) : buffer(b), ds_sigproc(s), 
    first(NULL), last(NULL), lastRP(0) {
    MUTEX_INIT(&mutex);
    buffer->connect_buffer(this);
  } 

  double connect_getSamplingFrequency() {return buffer->buffer_getSamplingFrequency();}

  virtual ~VrConnect() {}
}; 
#endif 
