/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRSOFTLINKSINK_H_
#define _VRSOFTLINKSINK_H_

extern "C" {
#include <unistd.h>
#include <fcntl.h>
#include <netinet/in.h>
}

#include <VrSink.h>
#include <VrIPpacket.h>

class VrSoftLinkSink : public VrSink<VrIPpacket> {
protected:
  int devfd;
public:
  virtual void work(int n);
  VrSoftLinkSink();
  u_short ComputeChecksum(VrIPpacket* p);
};

void 
VrSoftLinkSink::work(int n)
{
  static int count = 0;

  for (int i=0;i<n;i++,incReadPtr(1)) {
    VrIPpacket packet = inputRead(0);

    /* begin hack 
    u_int dest = (18 << 24) | (31 << 16) | (205); 
    packet.setDestAddr(dest);
    u_int source = (18 << 24) | (128 << 16) | (1);
    packet.setSourceAddr(source);
    packet.setHeaderCheckSum((u_short)0);
    u_short cs = ComputeChecksum(&packet);
    packet.setHeaderCheckSum((u_short)cs);
    end hack */

    //    packet.printHeader();


    int status =  packet.transmitPacket(devfd);
    printf("ID: %d packet #: %d\n",packet.getId(),++count);
    if (!status) exit(0);
  }
}

u_short
VrSoftLinkSink::ComputeChecksum(VrIPpacket* packet) {
  
  u_char* ptr = packet->ptr();
  int len = 4*(packet->getHlen());

  u_int sum = 0;

  while (len > 1) {
    sum += *(((u_short*)ptr)+1);
    
    if (sum & 0x80000000)
      sum = (sum & 0xffff) + (sum >> 16);
    len -=2;
  }

  if (len)
    sum += (u_short) *ptr;

  while (sum >> 16)
    sum = (sum & 0xffff) + (sum >> 16);
  return ~sum;

}

VrSoftLinkSink::VrSoftLinkSink()
{
  
  printf("Opening %s for write(SoftLinkSink).\n", SLDEV);
  
  if((devfd=open(SLDEV,O_WRONLY|O_NONBLOCK ))==-1) {
    fprintf(stderr,"Error encountered opening device(SoftLinkSink) %d.\n",errno);
    perror("error:");
    exit(0);
  } else
    printf("Device opened Successfully, beginning write (SoftLinkSink)\n");
    
  //  printf("Softlinksink disabled. Continuing. \n");
}

#endif
