#ifndef _TV_AUDIO_RECEIVER_H_
#define _TV_AUDIO_RECEIVER_H_

#include <qwidget.h>

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
template<class iType, class oType> class VrRealFIRfilter;
template<class oType> class VrQuadratureDemod;
template<class iType> class VrAudioSink;

class TVTuner;
class QLCDNumber;

class TVAudioReceiver : public QWidget
{
  Q_OBJECT

  VrAR5000Source<char> *source;
  VrComplexFIRfilter<char> *chanFilter;
  VrQuadratureDemod<float> *demod;
  VrRealFIRfilter<float, short> *ifFilter;
  VrAudioSink<short> *audio;

  TVTuner *tuner;
  QLCDNumber *display;
  int volume;

public:  
  TVAudioReceiver(VrAR5000Source<char> *source,
		  QWidget *parent = 0, const char *name = 0);
  ~TVAudioReceiver();

private slots:
  void run();

public slots:
  void setChannel(int channel);
  void incVolume();
  void decVolume();

};

#endif


