/**
 * Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/
 */

var testGenerator = testSteps();

function testSteps()
{
  const nsIIDBObjectStore = Components.interfaces.nsIIDBObjectStore;
  const nsIIDBTransaction = Components.interfaces.nsIIDBTransaction;

  const name = this.window ? window.location.pathname : "Splendid Test";
  const description = "My Test Database";
  const objectStoreInfo = [
    { name: "1", options: { keyPath: null } },
    { name: "2", options: { keyPath: null, autoIncrement: true } },
    { name: "3", options: { keyPath: null, autoIncrement: false } },
    { name: "4", options: { keyPath: null } },
    { name: "5", options: { keyPath: "foo" } },
    { name: "6" },
    { name: "7", options: null },
    { name: "8", options: { autoIncrement: true } },
    { name: "9", options: { autoIncrement: false } },
    { name: "10", options: { keyPath: "foo", autoIncrement: false } },
    { name: "11", options: { keyPath: "foo", autoIncrement: true } },
    { name: "" },
    { name: null },
    { name: undefined }
  ];

  let request = mozIndexedDB.open(name, 1, description);
  request.onerror = errorHandler;
  request.onupgradeneeded = grabEventAndContinueHandler;
  let event = yield;

  let db = event.target.result;

  let count = db.objectStoreNames.length;
  is(count, 0, "correct objectStoreNames length");

  try {
    db.createObjectStore("foo", "bar");
    ok(false, "createObjectStore with bad options should throw");
  }
  catch(e) {
    ok(true, "createObjectStore with bad options");
  }

  ok(db.createObjectStore("foo", { foo: "" }),
     "createObjectStore with unknown options should not throw");
  db.deleteObjectStore("foo");

  for (let index in objectStoreInfo) {
    index = parseInt(index);
    const info = objectStoreInfo[index];

    let objectStore = info.hasOwnProperty("options") ?
                      db.createObjectStore(info.name, info.options) :
                      db.createObjectStore(info.name);

    is(db.objectStoreNames.length, index + 1,
       "updated objectStoreNames list");

    let name = info.name;
    if (name === null) {
      name = "null";
    }
    else if (name === undefined) {
      name = "undefined";
    }

    let found = false;
    for (let i = 0; i <= index; i++) {
      if (db.objectStoreNames.item(i) == name) {
        found = true;
        break;
      }
    }
    is(found, true, "objectStoreNames contains name");

    is(objectStore.name, name, "Bad name");
    is(objectStore.keyPath, info.options && info.options.keyPath ?
                            info.options.keyPath : null,
       "Bad keyPath");
    if(objectStore.indexNames.length, 0, "Bad indexNames");

    ok(event.target.transaction, "event has a transaction");
    ok(event.target.transaction.db === db, "transaction has the right db");
    is(event.target.transaction.readyState, nsIIDBTransaction.LOADING,
       "transaction has the correct readyState");
    is(event.target.transaction.mode, nsIIDBTransaction.VERSION_CHANGE,
       "transaction has the correct mode");
    is(event.target.transaction.objectStoreNames.length, index + 1,
       "transaction has correct objectStoreNames list");
    found = false;
    for (let j = 0; j < event.target.transaction.objectStoreNames.length;
         j++) {
      if (event.target.transaction.objectStoreNames.item(j) == name) {
        found = true;
        break;
      }
    }
    is(found, true, "transaction has correct objectStoreNames list");
  }

  finishTest();
  yield;
}